/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.mdx.parser.ASTTuple;
import com.cognos.xqe.ast.mdx.parser.MDXQueryNode;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.MDXEngineException;
import com.cognos.xqe.runtree.olap.mdx.XMdxElement;
import com.cognos.xqe.runtree.olap.mdx.XMdxNode;
import com.cognos.xqe.runtree.olap.mdx.data.values.CubicsValue;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.IDMRMember;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.Member;
import com.cognos.xqe.runtree.olap.mdx.metadata.NullMember;
import com.cognos.xqe.runtree.olap.mdx.security.SecurityManagerInterface;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.IOrderedMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.dom4j.Element;

public class XMdxTuple
extends XMdxNode {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_KEYWORD = "keyword";
    private static final String KEYWORD_VALUE_TUPLE = "Tuple";
    private static final String KEYWORD_VALUE_MEMBERRANGE = "MemberRange";
    protected static final String STRING_TUPLECONTEXT = "tupleElement";

    @Override
    public int getType() {
        return 501075;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        super.capture(env, inputNode);
        String keyword = inputNode.attributeValue(ATTRIBUTE_KEYWORD);
        if (keyword != null) {
            this.setPropertyValue(ATTRIBUTE_KEYWORD, keyword);
        }
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        if (this.getPropertyValue(ATTRIBUTE_KEYWORD) != null) {
            this.dumpProperty(trace, ATTRIBUTE_KEYWORD);
        }
    }

    @Override
    public void setParserNode(MDXQueryNode node) {
        super.setParserNode(node);
        ASTTuple tuple = (ASTTuple)node;
        String keyword = tuple.getKeyword();
        if (keyword != null) {
            this.setPropertyValue(ATTRIBUTE_KEYWORD, keyword);
        }
    }

    @Override
    protected IValue executeImpl(XDataContext context) {
        Object result = null;
        try {
            if (this.isMemberTuple()) {
                result = this.processTuple(context);
            } else if (this.isMemberRange()) {
                result = this.processMemberRange(context);
            } else {
                Block block = (Block)this.executeXMdxChildNode(0, context);
                result = block;
            }
        }
        catch (InterpreterException e) {
            throw new MDXEngineException(e);
        }
        return new CubicsValue(result);
    }

    private Object processTuple(XDataContext context) throws InterpreterException {
        Object blockObj;
        InterpreterContext interpreterContext = context.getInterpreterContext();
        int childCount = this.getNumberChildren();
        String keyword = this.getKeyword();
        ICube cube = interpreterContext.getCube();
        boolean isTMRCube = cube != null && cube.getType() == ICube.CubeTypeEnum.TMR;
        Block[] tupleMemBlock = new Block[childCount];
        for (int i = 0; i < childCount; ++i) {
            XMdxNode mdxNode = (XMdxNode)this.getChild(i);
            if (keyword != null && mdxNode != null && mdxNode instanceof XMdxTuple && isTMRCube) {
                mdxNode.setPropertyValue(ATTRIBUTE_KEYWORD, keyword);
            }
            tupleMemBlock[i] = (Block)this.executeXMdxChildNode(i, context);
            blockObj = tupleMemBlock[i].first();
            if (childCount == 1 && blockObj instanceof Set) {
                return tupleMemBlock[i];
            }
            if (blockObj instanceof IMember || blockObj instanceof ITuple) continue;
            try {
                tupleMemBlock[i] = Caster.cast(tupleMemBlock[i], Member.class, interpreterContext);
                continue;
            }
            catch (Exception e) {
                String classCode = XMdxTuple.getClassNameCode(blockObj.getClass().getSimpleName());
                throw new MDXEngineException("X01461", (Throwable)e, new String[]{classCode, "CMP_TYPETUPLE, CMP_TYPEMEMBER"});
            }
        }
        Block retBlock = new Block(interpreterContext, tupleMemBlock);
        BlockIterator blockIter = new BlockIterator(tupleMemBlock);
        while (blockIter.hasNext()) {
            blockObj = (Object[])blockIter.next();
            ArrayList<IMember> tupleMems = new ArrayList<IMember>();
            for (int i = 0; i < tupleMemBlock.length; ++i) {
                if (blockObj[i] instanceof IMember) {
                    tupleMems.add((IMember)blockObj[i]);
                    continue;
                }
                if (blockObj[i] instanceof ITuple) {
                    ITuple tuple = (ITuple)blockObj[i];
                    for (int j = 0; j < tuple.size(); ++j) {
                        tupleMems.add(tuple.getMember(j));
                    }
                    continue;
                }
                if (blockObj[i] == null) continue;
                String classCode = XMdxTuple.getClassNameCode(blockObj[i].getClass().getSimpleName());
                throw new MDXEngineException("X01461", new String[]{classCode, "CMP_TYPEMEMBER, CMP_TYPETUPLE"});
            }
            Tuple t = new Tuple(tupleMems.toArray(new IMember[tupleMems.size()]), interpreterContext.getCube());
            retBlock.add(blockIter, (Object)t);
        }
        return retBlock;
    }

    private Object processMemberRange(XDataContext context) throws InterpreterException {
        InterpreterContext interpreterContext = context.getInterpreterContext();
        Block b1 = (Block)this.executeXMdxChildNode(0, context);
        b1 = Caster.cast(b1, IMember.class, interpreterContext);
        Block b2 = (Block)this.executeXMdxChildNode(1, context);
        b2 = Caster.cast(b2, IMember.class, interpreterContext);
        Block[] childBlocks = new Block[]{b1, b2};
        Block retBlock = new Block(interpreterContext, childBlocks);
        BlockIterator blockIter = new BlockIterator(childBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            IMember member1 = (IMember)blockObj[0];
            IMember member2 = (IMember)blockObj[1];
            Level level = null;
            boolean member1MemberNotFound = member1 instanceof NullMember;
            boolean member2MemberNotFound = member2 instanceof NullMember;
            boolean member1Missing = member1 == null;
            boolean member2Missing = member2 == null;
            boolean member1Valid = !member1MemberNotFound && !member1Missing;
            boolean member2Valid = !member2MemberNotFound && !member2Missing;
            List<Tuple> setTuples = null;
            if (interpreterContext.getCube().isDMR() && (member1MemberNotFound || member2MemberNotFound)) {
                setTuples = this.processFilteredMemberRange(member1, member2);
            } else if (member1Valid || member2Valid) {
                IMember lastMember;
                IMember firstMember;
                if (member1Valid) {
                    level = (Level)member1.getLevel();
                } else if (member2Valid) {
                    level = (Level)member2.getLevel();
                }
                if (!member1Valid) {
                    member1 = level.getMember(0);
                } else if (!member2Valid) {
                    int idx = level.getMemberCount() - 1;
                    member2 = level.getMember(idx);
                }
                if (member1Valid && member2Valid && member1.getLevel() != member2.getLevel()) {
                    throw new MDXEngineException("X01430", new String[]{member1.getLevel().getName(), member2.getLevel().getName()});
                }
                if (level.getMemberIndex(member1) <= level.getMemberIndex(member2)) {
                    firstMember = member1;
                    lastMember = member2;
                } else {
                    firstMember = member2;
                    lastMember = member1;
                }
                setTuples = new ArrayList<Tuple>();
                IMember memberInRange = firstMember;
                while (memberInRange != null && memberInRange != lastMember) {
                    setTuples.add(new Tuple(memberInRange));
                    memberInRange = ((IMemberCubics)memberInRange).getNextMember();
                }
                if (memberInRange == lastMember) {
                    setTuples.add(new Tuple(lastMember));
                }
            }
            ISet memRangeSet = null;
            if (setTuples == null) {
                memRangeSet = new Set(new Tuple[0]);
            } else {
                SecurityManagerInterface sec;
                memRangeSet = new Set(setTuples.toArray(new Tuple[0]));
                if (interpreterContext.getCube() != null && (sec = ((Cube)interpreterContext.getCube()).getSecurityManager(interpreterContext.getProvider())) != null) {
                    ISet[] input = new Set[]{memRangeSet};
                    ISet[] output = sec.applySecurity(input, interpreterContext);
                    memRangeSet = output[0];
                }
            }
            retBlock.add(blockIter, (Object)memRangeSet);
        }
        return retBlock;
    }

    private List<Tuple> processFilteredMemberRange(IMember member1, IMember member2) {
        int idx;
        IHierarchy hierarchy = null;
        Level level = null;
        String[] startValues = null;
        String[] endValues = null;
        IMember startMember = null;
        IMember endMember = null;
        if (member1 != null) {
            if (member1 instanceof NullMember) {
                startValues = this.getMemberNameValuesFromComposite(0);
                hierarchy = member1.getHierarchy();
                level = (Level)hierarchy.getLevel(startValues.length);
            } else {
                hierarchy = member1.getHierarchy();
                level = (Level)member1.getLevel();
                startMember = member1;
            }
        }
        if (member2 != null) {
            DMRLevel level2 = null;
            if (member2 instanceof NullMember) {
                endValues = this.getMemberNameValuesFromComposite(1);
                hierarchy = member2.getHierarchy();
                level2 = (DMRLevel)hierarchy.getLevel(endValues.length);
            } else {
                hierarchy = member2.getHierarchy();
                level2 = (DMRLevel)member2.getLevel();
                endMember = member2;
            }
            if (level == null) {
                level = level2;
            } else if (level.getIndex() != level2.getIndex()) {
                throw new MDXEngineException("X01430", new String[]{level.getName(), level2.getName()});
            }
        }
        ArrayList<Tuple> setTuples = new ArrayList<Tuple>();
        IMember startParentMember = null;
        IMember endParentMember = null;
        boolean startParentPartialMatch = false;
        boolean endParentPartialMatch = false;
        for (int i = 0; i < level.getIndex(); ++i) {
            Value businessKey;
            IMember match;
            DMRLevel currentLevel = (DMRLevel)hierarchy.getLevel(i + 1);
            IDataType keyDataType = currentLevel.getBusinessKeyQueryItem().getDataType();
            ArrayList<IMember> memberList = currentLevel.getMembersOrderedMap().getList();
            IMember[] members = memberList.toArray(new IMember[memberList.size()]);
            currentLevel.getDataType();
            if (startValues != null) {
                match = null;
                if (startParentPartialMatch) {
                    match = ((IMemberCubics)startParentMember).getChildrenOrderedMap().get(0);
                } else {
                    if (i + 1 < level.getIndex()) {
                        match = this.getMemberInLevel(currentLevel, startParentMember, startValues[i]);
                    }
                    if (match == null) {
                        businessKey = (Value)keyDataType.createValue();
                        businessKey.set(startValues[i]);
                        match = this.findMemberInLevel(members, startParentMember, businessKey, true);
                        if (i + 1 < level.getIndex() && match != null) {
                            startParentPartialMatch = true;
                        }
                    }
                }
                if (match == null) {
                    return setTuples;
                }
                if (i + 1 == level.getIndex()) {
                    startMember = match;
                } else {
                    startParentMember = match;
                }
            }
            if (endValues == null || i != 0 && endParentMember == null) continue;
            match = null;
            if (endParentPartialMatch) {
                IOrderedMap<IMember> children = ((IMemberCubics)endParentMember).getChildrenOrderedMap();
                match = children.get(children.size() - 1);
            } else {
                if (i + 1 < level.getIndex()) {
                    match = this.getMemberInLevel(currentLevel, endParentMember, endValues[i]);
                }
                if (match == null) {
                    businessKey = (Value)keyDataType.createValue();
                    businessKey.set(endValues[i]);
                    match = this.findMemberInLevel(members, endParentMember, businessKey, false);
                    if (i + 1 < level.getIndex() && match != null) {
                        endParentPartialMatch = true;
                    }
                }
            }
            if (match == null) {
                return setTuples;
            }
            if (i + 1 == level.getIndex()) {
                endMember = match;
                continue;
            }
            endParentMember = match;
        }
        List<IMember> members = level.getMembers();
        if (member1 != null) {
            for (idx = 0; idx < members.size() && members.get(idx) != startMember; ++idx) {
            }
        }
        while (idx < members.size()) {
            IMember member = members.get(idx);
            setTuples.add(new Tuple(member));
            if (member == endMember) break;
            ++idx;
        }
        return setTuples;
    }

    String[] getMemberNameValuesFromComposite(int index) {
        int three;
        ArrayList<String> values = new ArrayList<String>();
        IXQEQueryNode[] compositeChildren = this.getChild(index).getChildren();
        for (int i = three = 3; i < compositeChildren.length; ++i) {
            IXQEQueryNode compositeChild = compositeChildren[i];
            XMdxElement element = (XMdxElement)compositeChild;
            values.add(element.getValue());
        }
        return values.toArray(new String[values.size()]);
    }

    private IMember getMemberInLevel(Level level, IMember parentMember, String value) {
        IMember match = level.getMember(value);
        if (match == null) {
            return null;
        }
        if (parentMember == null) {
            return match;
        }
        if (match.getParent() == parentMember) {
            return match;
        }
        for (IMember dupMatch : level.getMembersOrderedMap().getDuplicates(value)) {
            if (dupMatch.getParent() != parentMember) continue;
            return dupMatch;
        }
        return null;
    }

    private IMember findMemberInLevel(IMember[] members, IMember parentMember, Value value, boolean start) {
        int idx = -1;
        MemberKeyComparator comparator = new MemberKeyComparator();
        if (parentMember == null) {
            idx = Arrays.binarySearch(members, value, comparator);
            if (idx >= 0) {
                return members[idx];
            }
            idx = Math.abs(idx) - 1;
        } else {
            boolean parentFound = false;
            for (idx = 0; idx < members.length; ++idx) {
                boolean childOfParent;
                boolean bl = childOfParent = members[idx].getParent() == parentMember;
                if (parentFound) {
                    if (!childOfParent) {
                        break;
                    }
                } else if (childOfParent) {
                    parentFound = true;
                }
                if (!parentFound) continue;
                int result = comparator.compare(members[idx], value);
                if (result == 0) {
                    return members[idx];
                }
                if (result > 0) break;
            }
            if (!parentFound) {
                throw new IllegalStateException("Expected to find parent in level");
            }
        }
        if (start) {
            if (idx < members.length) {
                return members[idx];
            }
        } else if (idx > 0) {
            return members[idx - 1];
        }
        return null;
    }

    private String getKeyword() {
        return (String)this.getPropertyValue(ATTRIBUTE_KEYWORD);
    }

    public boolean isMemberTuple() {
        return KEYWORD_VALUE_TUPLE.equalsIgnoreCase(this.getKeyword());
    }

    public boolean isMemberRange() {
        return KEYWORD_VALUE_MEMBERRANGE.equalsIgnoreCase(this.getKeyword());
    }

    @Override
    public String[] getSyntaxProperties() {
        return new String[]{ATTRIBUTE_KEYWORD};
    }

    private class MemberKeyComparator
    implements Comparator<IValue> {
        MemberKeyComparator() {
        }

        @Override
        public int compare(IValue v1, IValue v2) {
            if (v1 instanceof IDMRMember) {
                v1 = ((IDMRMember)v1).getBusinessKeyValue();
            }
            if (v2 instanceof IDMRMember) {
                v2 = ((IDMRMember)v2).getBusinessKeyValue();
            }
            int result = v1.compareTo(v2);
            return result;
        }
    }
}

