/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.data.cache;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultset.interfaces.ICellIterator;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultset.interfaces.IIterator;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.md.Cell;
import com.cognos.xqe.resultsets.md.Tuple;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XScrollableIterator;
import com.cognos.xqe.runtree.olap.mdx.data.cache.AbstractCubeResultSetCache;
import com.cognos.xqe.runtree.olap.mdx.data.cache.CachedCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.data.cache.ICachedCubeResultSet;
import com.cognos.xqe.runtree.olap.mdx.data.cache.IResultSetCacheKeyMaker;
import com.cognos.xqe.runtree.olap.mdx.data.cache.MemberIndex;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.io.FileChannelInputStream;
import com.cognos.xqe.util.io.FileChannelOutputStream;
import com.cognos.xqe.util.io.FileCleanerService;
import com.cognos.xqe.util.pool.DirectByteBufferPool;
import com.ibm.bi.org.apache.hadoop.io.CryptoProvider;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class DiskBackedCubeResultSetCache
extends AbstractCubeResultSetCache {
    private static final String RESULT_SET_PREFIX = "ResultSet_";
    private static final String EDGE_DATA_SUFFIX = "_EdgeData_";
    private static final String CELL_DATA_SUFFIX = "_CellData";
    private static final String DATA_EXTENSION = ".data";
    private static final String READ_WRITE_MODE = "rw";
    private static final String READ_MODE = "r";
    private static final AtomicLong RESULT_SET_ID_COUNTER = new AtomicLong(0L);
    private static final XQELogger LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MDXEngine.ResultSetCache", LogLevel.INFO);
    protected final ICube mCube;
    private final File mRootDirectory;
    private final boolean mUseEncryption;
    private final DirectByteBufferPool mBufferPool;

    public DiskBackedCubeResultSetCache(ICube cube, IResultSetCacheKeyMaker keyMaker, File rootDirectory, boolean useEncryption, DirectByteBufferPool bufferPool) throws IOException {
        super(cube.getName(), keyMaker);
        this.mCube = cube;
        this.mRootDirectory = rootDirectory;
        this.mUseEncryption = useEncryption;
        this.mBufferPool = bufferPool;
        try {
            DiskBackedCubeResultSetCache.rmdirRecursive(this.mRootDirectory);
        }
        catch (Exception ex) {
            LOGGER.log(LogLevel.ERROR, (Throwable)ex);
        }
        this.mRootDirectory.mkdirs();
    }

    @Override
    protected ICachedCubeResultSet createCachedResultSet(Object cacheKey, ICubeResultSet resultSet) {
        ResultSetData rsData = null;
        LOGGER.log(LogLevel.TRACE, OperationEnum.START, "Started serializing result set to disk.");
        try {
            if (!this.mRootDirectory.exists()) {
                this.mRootDirectory.mkdirs();
            }
            int axisCount = resultSet.getNumAxes();
            IDimension[][] axisDimensions = new IDimension[axisCount][];
            long resultSetId = RESULT_SET_ID_COUNTER.incrementAndGet();
            File cellStoreFile = this.makeCellDataFile(resultSetId);
            File[] edgeStoreFiles = new File[axisCount];
            for (int axis = 0; axis < axisCount; ++axis) {
                axisDimensions[axis] = resultSet.getDimensions(axis);
                edgeStoreFiles[axis] = this.makeEdgeDataFile(resultSetId, axis);
            }
            rsData = new ResultSetData(cacheKey, axisCount, axisDimensions, cellStoreFile, edgeStoreFiles);
            rsData.populateCaches(resultSet);
            ResultSetData resultSetData = rsData;
            return resultSetData;
        }
        catch (Exception ex) {
            LOGGER.log(LogLevel.ERROR, (Throwable)ex);
            if (null != rsData) {
                rsData.destroyCache();
            }
            throw XQERuntimeException.wrap(XQEMessageKeys.GEN_UnexpectedException, ex);
        }
        finally {
            LOGGER.log(LogLevel.TRACE, OperationEnum.END, "Finished serializing result set to disk.");
        }
    }

    @Override
    protected void releaseImpl() {
        try {
            DiskBackedCubeResultSetCache.rmdirRecursive(this.mRootDirectory);
        }
        catch (Exception ex) {
            LOGGER.log(LogLevel.ERROR, (Throwable)ex);
        }
    }

    private static void rmdirRecursive(File dir) throws IOException {
        if (!dir.exists()) {
            return;
        }
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                DiskBackedCubeResultSetCache.rmdirRecursive(f);
                continue;
            }
            if (f.delete()) continue;
            throw new IOException("Failed to remove file: " + f.getCanonicalPath());
        }
        if (!dir.delete()) {
            throw new IOException("Failed to remove directory: " + dir.getCanonicalPath());
        }
    }

    private File makeEdgeDataFile(long resultSetId, int axisNum) throws IOException {
        StringBuilder pathBuilder = new StringBuilder(this.mRootDirectory.getCanonicalPath());
        pathBuilder.append(File.separatorChar).append(RESULT_SET_PREFIX).append(resultSetId);
        pathBuilder.append(EDGE_DATA_SUFFIX).append(axisNum).append(DATA_EXTENSION);
        return new File(pathBuilder.toString());
    }

    private File makeCellDataFile(long resultSetId) throws IOException {
        StringBuilder pathBuilder = new StringBuilder(this.mRootDirectory.getCanonicalPath());
        pathBuilder.append(File.separatorChar).append(RESULT_SET_PREFIX).append(resultSetId);
        pathBuilder.append(CELL_DATA_SUFFIX).append(DATA_EXTENSION);
        return new File(pathBuilder.toString());
    }

    private final class CellIter
    implements ICellIterator {
        private final CellData mData;
        private FileChannelInputStream mChannelStream = null;
        private DataInputStream mDataStream = null;
        private long mCurrentOrdinal = -1L;

        CellIter(CellData data) {
            this.mData = data;
            this.openStorageFile();
        }

        @Override
        public long getIndex() {
            return this.mCurrentOrdinal;
        }

        @Override
        public boolean hasNext() {
            return this.mCurrentOrdinal < this.mData.getMaxCellOrdinal();
        }

        @Override
        public ICell next() {
            if (this.mCurrentOrdinal >= this.mData.getMaxCellOrdinal()) {
                return null;
            }
            ICell cell = null;
            try {
                cell = this.mData.deserializeCell(this.mDataStream);
            }
            catch (IOException ex) {
                LOGGER.log(LogLevel.ERROR, (Throwable)ex);
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL, (Throwable)ex);
            }
            this.mCurrentOrdinal = cell.getOrdinal();
            return cell;
        }

        @Override
        public void release() {
            this.closeStorageFile();
        }

        private void openStorageFile() {
            block8: {
                RandomAccessFile raf = null;
                try {
                    raf = new RandomAccessFile(this.mData.getStoreFile(), DiskBackedCubeResultSetCache.READ_MODE);
                    this.mChannelStream = new FileChannelInputStream(raf.getChannel(), DiskBackedCubeResultSetCache.this.mBufferPool);
                    if (DiskBackedCubeResultSetCache.this.mUseEncryption) {
                        try {
                            InputStream decryptingStream = CryptoProvider.createDecryptingInputStream((InputStream)this.mChannelStream);
                            this.mDataStream = new DataInputStream(decryptingStream);
                            break block8;
                        }
                        catch (Exception ex) {
                            LOGGER.log(LogLevel.ERROR, (Throwable)ex);
                            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL, (Throwable)ex);
                        }
                    }
                    this.mDataStream = new DataInputStream(this.mChannelStream);
                }
                catch (IOException ex) {
                    LOGGER.log(LogLevel.ERROR, (Throwable)ex);
                    if (null != raf) {
                        try {
                            raf.close();
                        }
                        catch (IOException ex2) {
                            LOGGER.log(LogLevel.ERROR, (Throwable)ex2);
                        }
                    }
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL, (Throwable)ex);
                }
            }
        }

        private void closeStorageFile() {
            try {
                if (null != this.mDataStream) {
                    this.mDataStream.close();
                }
            }
            catch (IOException ex) {
                LOGGER.log(LogLevel.ERROR, (Throwable)ex);
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL, (Throwable)ex);
            }
        }
    }

    private final class EdgeIter
    implements IIterator {
        private final EdgeData mData;
        private FileChannelInputStream mChannelStream = null;
        private DataInputStream mDataStream = null;
        private long mCurrentIndex = -1L;

        EdgeIter(EdgeData data) {
            this.mData = data;
            this.openStorageFile();
        }

        @Override
        public long getIndex() {
            return this.mCurrentIndex;
        }

        @Override
        public boolean hasNext() {
            return this.mCurrentIndex + 1L < this.mData.getTupleCount();
        }

        @Override
        public Object next() {
            if (this.mCurrentIndex + 1L >= this.mData.getTupleCount()) {
                return null;
            }
            ITuple tuple = null;
            try {
                tuple = this.mData.deserializeTuple(this.mDataStream);
            }
            catch (IOException ex) {
                LOGGER.log(LogLevel.ERROR, (Throwable)ex);
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL, (Throwable)ex);
            }
            ++this.mCurrentIndex;
            return tuple;
        }

        @Override
        public void release() {
            this.closeStorageFile();
        }

        private void openStorageFile() {
            block8: {
                RandomAccessFile raf = null;
                try {
                    raf = new RandomAccessFile(this.mData.getStoreFile(), DiskBackedCubeResultSetCache.READ_MODE);
                    this.mChannelStream = new FileChannelInputStream(raf.getChannel(), DiskBackedCubeResultSetCache.this.mBufferPool);
                    if (DiskBackedCubeResultSetCache.this.mUseEncryption) {
                        try {
                            InputStream decryptingStream = CryptoProvider.createDecryptingInputStream((InputStream)this.mChannelStream);
                            this.mDataStream = new DataInputStream(decryptingStream);
                            break block8;
                        }
                        catch (Exception ex) {
                            LOGGER.log(LogLevel.ERROR, (Throwable)ex);
                            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL, (Throwable)ex);
                        }
                    }
                    this.mDataStream = new DataInputStream(this.mChannelStream);
                }
                catch (IOException ex) {
                    LOGGER.log(LogLevel.ERROR, (Throwable)ex);
                    if (null != raf) {
                        try {
                            raf.close();
                        }
                        catch (IOException ex2) {
                            LOGGER.log(LogLevel.ERROR, (Throwable)ex2);
                        }
                    }
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL, (Throwable)ex);
                }
            }
        }

        private void closeStorageFile() {
            try {
                if (null != this.mDataStream) {
                    this.mDataStream.close();
                }
            }
            catch (IOException ex) {
                LOGGER.log(LogLevel.ERROR, (Throwable)ex);
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL, (Throwable)ex);
            }
        }
    }

    private final class CellData {
        private final File mStoreFile;
        private long mNonNullCellCount = 0L;
        private long mNullCellCount = 0L;
        private long mMaxOrdinal = -1L;

        CellData(File storeFile) {
            this.mStoreFile = storeFile;
        }

        File getStoreFile() {
            return this.mStoreFile;
        }

        long getFileSize() {
            return this.mStoreFile.length();
        }

        long getMaxCellOrdinal() {
            return this.mMaxOrdinal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void populateCache(XCellIterator cellIter) throws IOException {
            try (RandomAccessFile raf = new RandomAccessFile(this.mStoreFile, DiskBackedCubeResultSetCache.READ_WRITE_MODE);){
                FileChannel channel = raf.getChannel();
                OutputStream os = new FileChannelOutputStream(channel, DiskBackedCubeResultSetCache.this.mBufferPool);
                if (DiskBackedCubeResultSetCache.this.mUseEncryption) {
                    try {
                        os = CryptoProvider.createEncryptingOutputStream((OutputStream)os);
                    }
                    catch (Exception ex) {
                        LOGGER.log(LogLevel.ERROR, (Throwable)ex);
                        os.close();
                        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL, (Throwable)ex);
                    }
                }
                try (DataOutputStream dos = new DataOutputStream(os);){
                    ICell cell;
                    long lastCellOrdinal = -1L;
                    while (null != (cell = cellIter.next())) {
                        if (null != cell.getValue() && !cell.getValue().isNull()) {
                            this.serializeCell(cell, dos);
                            ++this.mNonNullCellCount;
                            this.mNullCellCount += cell.getOrdinal() - lastCellOrdinal - 1L;
                            lastCellOrdinal = cell.getOrdinal();
                            continue;
                        }
                        this.mNullCellCount += cell.getOrdinal() - lastCellOrdinal;
                    }
                    this.mMaxOrdinal = lastCellOrdinal;
                }
            }
            if (LOGGER.isOn(LogLevel.TRACE)) {
                LOGGER.log(LogLevel.TRACE, String.format("Serialized %d non-null cells, skipped %d null cells.", this.mNonNullCellCount, this.mNullCellCount));
            }
        }

        private void serializeCell(ICell cell, DataOutput out) throws IOException {
            out.writeLong(cell.getOrdinal());
            this.serializeValue((Value)cell.getValue(), out);
        }

        private ICell deserializeCell(DataInput in) throws IOException {
            long ordinal = in.readLong();
            IValue value = this.deserializeValue(in);
            return new Cell(ordinal, value);
        }

        private void serializeValue(Value value, DataOutput out) throws IOException {
            this.serializeDataType(value.getDataType(), out);
            value.encode(out);
        }

        private IValue deserializeValue(DataInput in) throws IOException {
            IDataType dataType = this.deserializeDataType(in);
            Value value = (Value)dataType.createValue();
            value.decode(in);
            return value;
        }

        private void serializeDataType(IDataType dataType, DataOutput out) throws IOException {
            out.writeByte(dataType.getCCLTypeCode());
            if (dataType.isExactNumeric()) {
                out.writeBoolean(true);
                out.writeInt(dataType.getPrecision());
                out.writeInt(dataType.getScale());
            } else {
                out.writeBoolean(false);
            }
        }

        private IDataType deserializeDataType(DataInput in) throws IOException {
            byte cclDType = in.readByte();
            boolean isExactNumeric = in.readBoolean();
            if (isExactNumeric) {
                int precision = in.readInt();
                int scale = in.readInt();
                return DataTypeFactory.getDataType(cclDType, precision, scale);
            }
            return DataTypeFactory.getDataType(cclDType);
        }

        private void destroy() {
            if (this.mStoreFile.exists() && !this.mStoreFile.delete()) {
                if (LOGGER.isOn(LogLevel.WARN)) {
                    LOGGER.log(LogLevel.WARN, "Delete failed on cell data store file: " + this.mStoreFile.getPath());
                }
                FileCleanerService.getInstance().deleteLater(this.mStoreFile);
            }
        }
    }

    private final class EdgeData {
        private final int mAxisNumber;
        private final File mStoreFile;
        private final IDimension[] mDimensions;
        private final MemberIndex[] mMemberIndexes;
        private long mTupleCount = 0L;

        EdgeData(int axisNumber, IDimension[] dimensions, File storeFile) {
            this.mAxisNumber = axisNumber;
            this.mDimensions = dimensions;
            this.mStoreFile = storeFile;
            this.mMemberIndexes = new MemberIndex[this.mDimensions.length];
            for (int i = 0; i < this.mMemberIndexes.length; ++i) {
                this.mMemberIndexes[i] = new MemberIndex();
            }
        }

        IDimension[] getDimensions() {
            return this.mDimensions;
        }

        File getStoreFile() {
            return this.mStoreFile;
        }

        long getTupleCount() {
            return this.mTupleCount;
        }

        long getFileSize() {
            return this.mStoreFile.length();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void populateCache(XIterator edgeIter) throws IOException {
            try (RandomAccessFile raf = new RandomAccessFile(this.mStoreFile, DiskBackedCubeResultSetCache.READ_WRITE_MODE);){
                FileChannel channel = raf.getChannel();
                OutputStream os = new FileChannelOutputStream(channel, DiskBackedCubeResultSetCache.this.mBufferPool);
                if (DiskBackedCubeResultSetCache.this.mUseEncryption) {
                    try {
                        os = CryptoProvider.createEncryptingOutputStream((OutputStream)os);
                    }
                    catch (Exception ex) {
                        LOGGER.log(LogLevel.ERROR, (Throwable)ex);
                        os.close();
                        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL, (Throwable)ex);
                    }
                }
                IdentityHashMap<IMember, IMember> calcMemberCache = new IdentityHashMap<IMember, IMember>();
                try (DataOutputStream dos = new DataOutputStream(os);){
                    ITuple tuple;
                    while (null != (tuple = (ITuple)edgeIter.next())) {
                        this.serializeTuple(tuple, dos, calcMemberCache);
                        ++this.mTupleCount;
                    }
                }
            }
            for (MemberIndex idx : this.mMemberIndexes) {
                idx.clearMapping();
            }
            if (LOGGER.isOn(LogLevel.TRACE)) {
                LOGGER.log(LogLevel.TRACE, String.format("Serialized %d tuples for axis %d.", this.mTupleCount, this.mAxisNumber));
            }
        }

        private void serializeTuple(ITuple tuple, DataOutput out, Map<IMember, IMember> calcMemberCache) throws IOException {
            int size = tuple.size();
            for (int i = 0; i < size; ++i) {
                IMember member = tuple.getMember(i);
                if (member.isCalculatedMember()) {
                    IMember cached = calcMemberCache.get(member);
                    if (null == cached) {
                        cached = new CachedCalculatedMember((CalculatedMember)member);
                        calcMemberCache.put(member, cached);
                    }
                    member = cached;
                }
                out.writeInt(this.mMemberIndexes[i].map(member));
            }
        }

        private ITuple deserializeTuple(DataInput in) throws IOException {
            int size = this.mDimensions.length;
            IMember[] members = new IMember[size];
            for (int i = 0; i < size; ++i) {
                members[i] = this.mMemberIndexes[i].forIndex(in.readInt());
            }
            return new Tuple(members);
        }

        void destroy() {
            if (this.mStoreFile.exists() && !this.mStoreFile.delete()) {
                if (LOGGER.isOn(LogLevel.WARN)) {
                    LOGGER.log(LogLevel.WARN, "Delete failed on edge data store file: " + this.mStoreFile.getPath());
                }
                FileCleanerService.getInstance().deleteLater(this.mStoreFile);
            }
        }
    }

    private final class ResultSetData
    implements ICachedCubeResultSet {
        private final Object mCacheKey;
        private final int mAxisCount;
        private ITuple mSlicer = null;
        private final EdgeData[] mEdges;
        private CellData mCells;
        private boolean mDestroyed = false;
        private AtomicLong mCacheSize = new AtomicLong(0L);

        ResultSetData(Object cacheKey, int axisCount, IDimension[][] axisDimensions, File cellStoreFile, File[] edgeStoreFiles) {
            this.mCacheKey = cacheKey;
            this.mAxisCount = axisCount;
            this.mCells = new CellData(cellStoreFile);
            this.mEdges = new EdgeData[this.mAxisCount];
            for (int i = 0; i < this.mAxisCount; ++i) {
                this.mEdges[i] = new EdgeData(i, axisDimensions[i], edgeStoreFiles[i]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void populateCaches(ICubeResultSet resultSet) throws IOException {
            this.mSlicer = this.cacheTuple(resultSet.getSlicer());
            for (int i = 0; i < this.mAxisCount; ++i) {
                EdgeData edgeData = this.mEdges[i];
                XIterator edgeIter = resultSet.getAxisIterator(i);
                try {
                    edgeData.populateCache(edgeIter);
                }
                finally {
                    edgeIter.release();
                }
                this.mCacheSize.addAndGet(edgeData.getFileSize());
            }
            XCellIterator cellIter = resultSet.getCellIterator();
            try {
                this.mCells.populateCache(cellIter);
            }
            finally {
                cellIter.release();
            }
            this.mCacheSize.addAndGet(this.mCells.getFileSize());
        }

        private ITuple cacheTuple(ITuple slicer) {
            IMember[] slicerMembers = slicer.getMembers();
            IMember[] copySlicerMembers = new IMember[slicerMembers.length];
            for (int index = 0; index < slicerMembers.length; ++index) {
                IMember member = slicerMembers[index];
                copySlicerMembers[index] = member.isCalculatedMember() ? new CachedCalculatedMember((CalculatedMember)member) : member;
            }
            return new Tuple(copySlicerMembers);
        }

        @Override
        public boolean isValid() {
            if (this.mDestroyed) {
                return false;
            }
            if (!this.mCells.getStoreFile().exists()) {
                return false;
            }
            for (EdgeData ed : this.mEdges) {
                if (ed.getStoreFile().exists()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void destroyCache() {
            if (this.mDestroyed) {
                return;
            }
            if (LOGGER.isOn(LogLevel.INFO)) {
                LOGGER.log(LogLevel.INFO, "Destroying cache with key " + this.mCacheKey.toString());
            }
            this.mDestroyed = true;
            for (int i = 0; i < this.mEdges.length; ++i) {
                try {
                    this.mEdges[i].destroy();
                    this.mEdges[i] = null;
                    continue;
                }
                catch (Exception ex) {
                    LOGGER.log(LogLevel.ERROR, (Throwable)ex);
                }
            }
            try {
                this.mCells.destroy();
                this.mCells = null;
            }
            catch (Exception ex) {
                LOGGER.log(LogLevel.ERROR, (Throwable)ex);
            }
        }

        @Override
        public long getCacheSize() {
            return this.mCacheSize.get();
        }

        @Override
        public IIterator getAxisIterator(int axisNumber) {
            return new EdgeIter(this.mEdges[axisNumber]);
        }

        @Override
        public long getAxisSize(int axisNumber) {
            return this.mEdges[axisNumber].getTupleCount();
        }

        @Override
        public ICellIterator getCellIterator() {
            return new CellIter(this.mCells);
        }

        @Override
        public IDimension[] getDimensions(int axisNumber) {
            return this.mEdges[axisNumber].getDimensions();
        }

        @Override
        public int getNumAxes() {
            return this.mAxisCount;
        }

        @Override
        public XScrollableIterator getScrollableAxisIterator(int axisNumber) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ITuple getSlicer() {
            return this.mSlicer;
        }
    }
}

