/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.data.cache;

import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultset.interfaces.ICellIterator;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultset.interfaces.IIterator;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.md.CubicsDimensionalResultSet;
import com.cognos.xqe.runtree.olap.mdx.data.cache.AbstractCubeResultSetCache;
import com.cognos.xqe.runtree.olap.mdx.data.cache.ICachedCubeResultSet;
import com.cognos.xqe.runtree.olap.mdx.data.cache.IResultSetCacheKeyMaker;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ICompleteResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import java.util.Iterator;

public class SimpleCubeResultSetCache
extends AbstractCubeResultSetCache {
    public SimpleCubeResultSetCache(String name, IResultSetCacheKeyMaker keyMaker) {
        super(name, keyMaker);
    }

    @Override
    protected ICachedCubeResultSet createCachedResultSet(Object cacheKey, ICubeResultSet resultSet) {
        if (resultSet instanceof CubicsDimensionalResultSet) {
            return new SimpleCubeResultSetCacheEntry((ICompleteResultSet)((CubicsDimensionalResultSet)resultSet).getResultSet());
        }
        return null;
    }

    @Override
    protected void releaseImpl() {
    }

    private final class SimpleCubeResultSetCacheEntry
    implements ICachedCubeResultSet {
        private static final int MEMBER_SIZE = 8;
        private static final int CELL_SIZE = 10;
        private final ICompleteResultSet mCachedResultSet;
        private long mCacheSize;

        private SimpleCubeResultSetCacheEntry(ICompleteResultSet resultSet) {
            this.mCachedResultSet = resultSet;
            this.mCacheSize = resultSet.size() * (long)resultSet.getQuerySet().getHierarchyCount() * 8L + (long)(resultSet.cellCount() * 10);
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public long getCacheSize() {
            return this.mCacheSize;
        }

        @Override
        public void destroyCache() {
        }

        @Override
        public int getNumAxes() {
            return this.mCachedResultSet.getNumberOfAxes();
        }

        @Override
        public IIterator getAxisIterator(int axisNumber) {
            if (axisNumber < 0 || axisNumber >= this.mCachedResultSet.getNumberOfAxes()) {
                return null;
            }
            return ((Set)this.mCachedResultSet.getAxis(axisNumber)).getTupleList().iterator();
        }

        @Override
        public IScrollableIterator getScrollableAxisIterator(int axisNumber) {
            Set set = (Set)this.mCachedResultSet.getAxis(axisNumber);
            return set.getScrollableIterator();
        }

        @Override
        public ITuple getSlicer() {
            ISet slicer = this.mCachedResultSet.getSlicer();
            if (slicer.size() == 0L) {
                return null;
            }
            return slicer.getTuple(0L);
        }

        @Override
        public ICellIterator getCellIterator() {
            return new SimpleCubeResultSetCacheEntryCellIterator();
        }

        @Override
        public IDimension[] getDimensions(int axisNumber) {
            return this.mCachedResultSet.getAxis(axisNumber).getDimensions();
        }

        @Override
        public long getAxisSize(int axisNumber) {
            return this.mCachedResultSet.getAxis(axisNumber).size();
        }

        private class SimpleCubeResultSetCacheEntryCellIterator
        implements ICellIterator {
            private Iterator<ICell> iterator;

            SimpleCubeResultSetCacheEntryCellIterator() {
                this.iterator = SimpleCubeResultSetCacheEntry.this.mCachedResultSet.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public ICell next() {
                if (this.hasNext()) {
                    return this.iterator.next();
                }
                return null;
            }

            @Override
            public void release() {
            }

            @Override
            public long getIndex() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

