/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider;

import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRDimension;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.IDMRMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.INullPlacement;
import com.cognos.xqe.util.IOrderedMap;
import com.cognos.xqe.util.OrderedMap;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import com.cognos.xqe.util.apache.Named;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import com.cognos.xqe.util.xml.XMLWriter;
import java.util.ListIterator;

public class DMRHierarchy
extends Hierarchy {
    public static final String MEASURES_LEVEL = "MeasuresLevel";
    protected final IHierarchy fmHierarchy;
    public static final String MEMBER_ABBR = "m";
    public static final String NAME_ABBR = "n";
    private Integer mLevelCount = null;

    public DMRHierarchy(String name, Dimension d, IHierarchy hierarchy) {
        super(name, d);
        this.setConnection(d.getConnection());
        if (hierarchy != null) {
            this.fmHierarchy = hierarchy;
            this.initialiseHierarchy();
        } else {
            this.fmHierarchy = null;
            this.initialiseMeasureHierarchy();
        }
    }

    protected void initialiseMeasureHierarchy() {
        new DMRLevel(MEASURES_LEVEL, this);
    }

    protected void initialiseHierarchy() {
        DMRCube cube = (DMRCube)this.getDimension().getCube();
        cube.addDMRMetadataObject(this.fmHierarchy, this);
        int levelCount = this.fmHierarchy.getLevelCount();
        for (int i = 0; i < levelCount; ++i) {
            ILevel level = this.fmHierarchy.getLevel(i);
            DMRLevel dmrLevel = new DMRLevel(level.getName(), this, level);
            cube.addDMRMetadataObject(level, dmrLevel);
        }
        this.setUnbalanced(this.fmHierarchy.isUnbalanced());
        this.setRagged(this.fmHierarchy.isRagged());
        this.setParentChild(this.fmHierarchy.isParentChild());
        this.mLevelCount = XQEIntegerPool.getInteger(this.getLevels().size());
    }

    @Override
    public int getLevelCount() {
        if (this.mLevelCount != null) {
            return this.mLevelCount;
        }
        return super.getLevelCount();
    }

    protected void addToCubeMetadataObject(DMRCube cube) {
        cube.addDMRMetadataObject(this.fmHierarchy, this);
        for (ILevel level : this.getLevels()) {
            if (!(level instanceof DMRLevel)) continue;
            ((DMRLevel)level).addToCubeMetadataObject(cube);
        }
    }

    @Override
    public IOrderedMap<IMember> fetchFirstLevelMembers() throws MetadataException, ProviderException {
        DMRDimension dim = (DMRDimension)this.getDimension();
        DMRCube cube = (DMRCube)dim.getCube();
        boolean membersCachedInMemberStorage = cube.memberStorageEnabled();
        if (dim.isMeasureDimension()) {
            return dim.fetchMeasures();
        }
        DMRLevel level = (DMRLevel)this.getLevel(0);
        if (level.isMappedToRelationalColumn()) {
            level.getMembers();
            return level.getMembersOrderedMap();
        }
        IMember rootMember = this.getFMHierarchyRootMember();
        Value memberCaption = null;
        Value businessKey = null;
        if (rootMember != null) {
            memberCaption = rootMember.getCaptionValue();
            try {
                businessKey = rootMember.getBusinessKeyValue();
            }
            catch (UnsupportedOperationException e) {
                XQEDebugLog.err.println("Root member has no business key: " + rootMember.getUniqueName());
            }
        } else {
            memberCaption = DataValueFactory.createStringValue();
            memberCaption.set("all");
            businessKey = DataValueFactory.createStringValue();
            businessKey.set(memberCaption);
        }
        if (businessKey == null || businessKey.isNull()) {
            String rootName = rootMember.getUniqueName();
            if ((rootName = UniqueNameGenerator.extractRightPartFromCognosMUN(rootName)) == null) {
                rootName = rootMember.getUniqueName();
            }
            String[] parts = null;
            try {
                parts = UniqueNameParser.parse(rootName);
            }
            catch (UniqueNameParserException e) {
                mErrorLogger.log(e);
            }
            if (parts != null && parts.length > 0) {
                businessKey = DataValueFactory.createStringValue();
                businessKey.set(parts[parts.length - 1]);
            }
        }
        if (memberCaption == null || memberCaption.isNull()) {
            memberCaption = DataValueFactory.createStringValue();
            memberCaption.set("All " + this.getName());
        }
        DMRMember dmrAllMember = new DMRMember(memberCaption, businessKey, level);
        String allMemberV5Name = null;
        if (rootMember != null && rootMember.getProperty("_v5MemberName") != null) {
            allMemberV5Name = (String)rootMember.getProperty("_v5MemberName");
        }
        INullPlacement allMember = membersCachedInMemberStorage ? DMRMemberProxy.cacheMemberRootMember(dmrAllMember) : dmrAllMember;
        if (allMemberV5Name != null) {
            allMember.setV5Name(allMemberV5Name);
        }
        OrderedMap<IMember> result = new OrderedMap<IMember>();
        result.put((Named)((Object)allMember));
        return result;
    }

    private IMember getFMHierarchyRootMember() {
        return this.fmHierarchy.getRootMember();
    }

    @Override
    public String getV5UniqueName() {
        if (this.v5UniqueName == null && this.fmHierarchy != null) {
            this.v5UniqueName = this.fmHierarchy.getV5UniqueName();
        }
        return this.v5UniqueName;
    }

    @Override
    public String getUniqueName() {
        if (this.uniqueName == null) {
            this.uniqueName = UniqueNameGenerator.createEscapedUniqueName(this.getDimension().getName(), this.getName());
        }
        return this.uniqueName;
    }

    public void dumpMembers(XMLWriter xmlWriter) {
        DMRDimension dim = (DMRDimension)this.getDimension();
        boolean bIsMeasure = dim.isMeasureDimension();
        int nLevels = this.getLevelCount();
        if (nLevels < 1) {
            return;
        }
        if (bIsMeasure) {
            return;
        }
        xmlWriter.beginElement("hierarchy", -1);
        xmlWriter.attribute(NAME_ABBR, this.getV5UniqueName());
        DMRLevel root = (DMRLevel)this.getLevel(0);
        IOrderedMap<IMember> ms = root.getMembersNoBlock();
        ListIterator<IMember> it = ms.listIterator();
        while (it.hasNext()) {
            IMember m = it.next();
            xmlWriter.beginElement(MEMBER_ABBR, -1);
            xmlWriter.attribute(NAME_ABBR, m.getName());
            this.dumpChildrenMembers(m, xmlWriter);
            xmlWriter.endElement();
        }
        xmlWriter.endElement();
    }

    private void dumpChildrenMembers(IMember pm, XMLWriter xmlWriter) {
        IOrderedMap<IMember> childMap = ((IDMRMember)pm).getChildrenOrderedMap();
        if (childMap == null || childMap.size() < 1) {
            return;
        }
        ListIterator<IMember> it = childMap.listIterator();
        while (it.hasNext()) {
            IMember m = it.next();
            xmlWriter.beginElement(MEMBER_ABBR, -1);
            xmlWriter.attribute(NAME_ABBR, m.getName());
            this.dumpChildrenMembers(m, xmlWriter);
            xmlWriter.endElement();
        }
    }

    @Override
    protected void initDefaultMember() throws MetadataException {
        this.defaultMember = ((DMRLevel)this.getLevel(0)).getMember(0);
        if (this.fmHierarchy != null && ((DMRCube)this.getDimension().getCube()).dimensionHasEmbeddedFilter(this.fmHierarchy.getDimension())) {
            if (this.defaultMember instanceof DMRMemberProxy) {
                ((DMRMemberProxy)this.defaultMember).setHierarchyMemberType((byte)1);
            } else {
                ((DMRMember)this.defaultMember).setHierarchyMemberType((byte)1);
            }
            String allMemberV5Name = ((IDMRMember)this.defaultMember).getV5Name();
            if (this.defaultMember instanceof DMRMemberProxy) {
                this.defaultMember = DMRMemberProxy.cloneRootMember((DMRMemberProxy)this.defaultMember);
            } else {
                Value cap = ((DMRMember)this.defaultMember).getCaptionValue();
                Value key = ((DMRMember)this.defaultMember).getBusinessKeyValue();
                this.defaultMember = new DMRMember(cap, key, (Level)this.getLevel(0));
            }
            if (allMemberV5Name != null) {
                ((IDMRMember)this.defaultMember).setV5Name(allMemberV5Name);
            }
        }
    }

    public String getSkipDimForDefaultMember(IMember mb) {
        long idx = this.getMemberId(mb);
        if (idx == -1L) {
            return null;
        }
        long defaultIdx = this.getMemberId(this.defaultMember);
        if (idx != defaultIdx) {
            return null;
        }
        long rootIdx = this.getMemberId(((Level)this.getLevel(0)).getMember(0));
        if (rootIdx == -1L || idx == rootIdx) {
            return null;
        }
        return this.fmHierarchy.getDimension().getV5UniqueName();
    }

    private long getMemberId(IMember mb) {
        long idx = -1L;
        if (mb instanceof DMRMemberProxy) {
            idx = ((DMRMemberProxy)mb).getIndex();
        } else if (mb instanceof DMRMember) {
            idx = ((DMRMember)mb).getMemberId();
        }
        return idx;
    }
}

