/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.ast.rqp.RQPPrePlan;
import com.cognos.xqe.ast.v5Exp.V5ExpressionProcessor;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.AllocationRule;
import com.cognos.xqe.metadata.IAggregateRule;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IScopeRelationship;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.metadata.wrapper.IMeasureWrapper;
import com.cognos.xqe.metadata.wrapper.MeasureWrapper;
import com.cognos.xqe.metadata.wrapper.QueryItemWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToMeasureWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRDimension;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.tabstream.PreLoadDMRCubeUtil;
import com.cognos.xqe.runtree.olap.mdx.metadata.IAggregateMeasure;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.Measure;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.transformation.v5tocogsql.prePlan.PrePlanUtilities;
import com.cognos.xqe.transformation.v5tocogsql.prePlan.SetOfTables;
import com.cognos.xqe.util.OrderedMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class DMRMeasure
extends Measure
implements IAggregateMeasure,
IMeasureWrapper {
    protected final IMeasure fmMeasure;

    public DMRMeasure(String s, Level level, IMeasure measure) {
        super(s, level);
        this.fmMeasure = measure;
        this.caption = measure.getCaptionValue().getV5formattedString();
        this.setConnection(level.getDimension().getCube().getConnection());
        DMRDimension dimension = (DMRDimension)level.getDimension();
        this.setMemberId(dimension.getmaxMemberId());
    }

    public OrderedMap<IMember> fetchChildMembers() throws MetadataException, ProviderException {
        return null;
    }

    @Override
    public String getV5UniqueName() {
        if (this.v5UniqueName == null) {
            this.v5UniqueName = this.fmMeasure.getV5UniqueName();
        }
        return this.v5UniqueName;
    }

    @Override
    public boolean isRelational() {
        return true;
    }

    @Override
    public String getV5AggregateForModelAggregate() {
        return this.fmMeasure.getRegularAggregate().toV5Type();
    }

    @Override
    public AggregateTypeEnum getRegularAggregate() {
        return this.fmMeasure.getRegularAggregate();
    }

    @Override
    public IAggregateRule[] getAggregateRules() {
        return this.fmMeasure.getAggregateRules();
    }

    @Override
    public String getQueryItemExpression(PlanningEnvironment planEnv) {
        if (this.fmMeasure instanceof V5DataItemToMeasureWrapper) {
            return null;
        }
        MetadataConnection connection = this.getConnection();
        Locale locale = ((RequestEnvironment)planEnv.getRequestEnvironment()).getExpressionLocale();
        String expression = null;
        IMeasure measure = this.getWrappedModelMeasure();
        boolean measureFound = true;
        while (measureFound && (expression = measure.getExpression()) != null) {
            IXQEQueryNode exprNode;
            measureFound = false;
            String expandedExpression = expression = MetadataUtil.extractExpressionFromModelString(expression, planEnv);
            if (MacroExpander.isMacro(expandedExpression)) {
                MacroExpander expander = new MacroExpander();
                expandedExpression = expander.expand(null, planEnv, expandedExpression);
            }
            if ((exprNode = V5ExpressionProcessor.parse(expandedExpression, planEnv, locale)).getType() != 201030) continue;
            try {
                IMetadata metadata = connection.bindMetadataReference(expression);
                if (!MetadataType.isMeasure(metadata)) continue;
                measure = (IMeasure)metadata;
                measureFound = true;
            }
            catch (XQERuntimeException xQERuntimeException) {}
        }
        if (expression == null) {
            expression = measure.getV5UniqueName();
        }
        return expression;
    }

    @Override
    public String getDescription() {
        return this.fmMeasure.getDescription();
    }

    @Override
    public Object getProperty(String propertyName) {
        Object property = super.getProperty(propertyName);
        if (property == null) {
            property = this.fmMeasure.getProperty(propertyName);
        }
        return property;
    }

    @Override
    public IScopeRelationship getScopeRelationship(IMetadata dimension) {
        return this.fmMeasure.getScopeRelationship(dimension);
    }

    @Override
    public IDataType getDataType() {
        return this.fmMeasure.getDataType();
    }

    @Override
    public int getPrecision() {
        throw new XQERuntimeException(XQEMessageKeys.GEN_NotYetSupported_INTERNAL, "DMRMeasure.getPrecision()");
    }

    @Override
    public int getScale() {
        throw new XQERuntimeException(XQEMessageKeys.GEN_NotYetSupported_INTERNAL, "DMRMeasure.getScale()");
    }

    @Override
    public String getUnits() {
        throw new XQERuntimeException(XQEMessageKeys.GEN_NotYetSupported_INTERNAL, "DMRMeasure.getUnits()");
    }

    @Override
    public AllocationRule getAllocationRule() {
        if (this.fmMeasure.isMFWMeasure() || this.fmMeasure instanceof MeasureWrapper) {
            return this.fmMeasure.getAllocationRule();
        }
        return AllocationRule.DEFAULT;
    }

    public IMeasure getWrappedModelMeasure() {
        if (this.fmMeasure.isMFWMeasure()) {
            return this.fmMeasure;
        }
        if (this.fmMeasure instanceof MeasureWrapper) {
            return ((MeasureWrapper)this.fmMeasure).getWrapped();
        }
        return null;
    }

    public IMeasure getFMMeasue() {
        return this.fmMeasure;
    }

    public boolean isManual() {
        String manual = (String)this.getProperty("isManual");
        if (manual == null) {
            return false;
        }
        return manual.equals("true");
    }

    @Override
    public String getV5AggregateAttribute() {
        if (this.fmMeasure instanceof MeasureWrapper) {
            return ((MeasureWrapper)this.fmMeasure).getV5AggregateAttribute();
        }
        if (this.fmMeasure instanceof V5DataItemToMeasureWrapper) {
            return ((V5DataItemToMeasureWrapper)this.fmMeasure).getV5AggregateAttribute();
        }
        return null;
    }

    public IXQEQueryNode getBinaryExpression() {
        if (this.fmMeasure instanceof MeasureWrapper) {
            return ((MeasureWrapper)this.fmMeasure).getBinaryExpression();
        }
        if (this.fmMeasure instanceof V5DataItemToMeasureWrapper) {
            return ((V5DataItemToMeasureWrapper)this.fmMeasure).getBinaryExpression();
        }
        return null;
    }

    public boolean useNativeV5Name() {
        return this.fmMeasure instanceof V5DataItemToMeasureWrapper;
    }

    public String getNativeLUN() {
        if (this.fmMeasure instanceof V5DataItemToMeasureWrapper) {
            return ((V5DataItemToMeasureWrapper)this.fmMeasure).getNativeLUN();
        }
        return null;
    }

    public String getNativeDUN() {
        if (this.fmMeasure instanceof V5DataItemToMeasureWrapper) {
            return ((V5DataItemToMeasureWrapper)this.fmMeasure).getNativeDUN();
        }
        return null;
    }

    public String getNativeHUN() {
        if (this.fmMeasure instanceof V5DataItemToMeasureWrapper) {
            return ((V5DataItemToMeasureWrapper)this.fmMeasure).getNativeHUN();
        }
        return null;
    }

    public String getNativeMUN() {
        if (this.fmMeasure instanceof V5DataItemToMeasureWrapper) {
            return ((V5DataItemToMeasureWrapper)this.fmMeasure).getNativeMUN();
        }
        return null;
    }

    public String getNativePUN() {
        if (this.fmMeasure instanceof V5DataItemToMeasureWrapper) {
            return ((V5DataItemToMeasureWrapper)this.fmMeasure).getNativePUN();
        }
        return null;
    }

    public boolean isReUseable() {
        if (this.fmMeasure instanceof V5DataItemToMeasureWrapper) {
            return false;
        }
        if (this.fmMeasure instanceof MeasureWrapper) {
            return ((MeasureWrapper)this.fmMeasure).isReUseable();
        }
        return true;
    }

    @Override
    public boolean isFromSameDimension(IMeasure other) {
        if (!(this.fmMeasure instanceof IMeasureWrapper)) {
            return false;
        }
        IMeasureWrapper measureWrapper = (IMeasureWrapper)this.fmMeasure;
        if (other instanceof MeasureWrapper) {
            return measureWrapper.isFromSameDimension(other);
        }
        if (other instanceof DMRMeasure) {
            return measureWrapper.isFromSameDimension(((DMRMeasure)other).fmMeasure);
        }
        return false;
    }

    @Override
    public IDimension getModelDimension() {
        if (this.fmMeasure instanceof IMeasureWrapper) {
            return ((IMeasureWrapper)this.fmMeasure).getModelDimension();
        }
        return null;
    }

    public SetOfTables getInvolvedTables() {
        List<DMRMeasure> requiredMeasures;
        SetOfTables t = PreLoadDMRCubeUtil.getInvolvedTablesForMeasureForCustomValue(this.getName());
        if (t != null) {
            return t;
        }
        DMRCube dmrCube = (DMRCube)this.getDimension().getCube();
        CubeWrapper cubeWrapper = dmrCube.getModelCube();
        RQPPrePlan prePlan = cubeWrapper.getRQPPrePlanQuery();
        if (prePlan == null) {
            return new SetOfTables();
        }
        IMeasure measure = (IMeasure)dmrCube.getWrapped(this);
        if (measure == cubeWrapper.getDefaultMeasure() && !(requiredMeasures = dmrCube.getMeasureInfo()).contains(this)) {
            return new SetOfTables();
        }
        IMetadata qItem = measure instanceof QueryItemWrapper ? ((QueryItemWrapper)((Object)measure)).getQueryItem() : (measure instanceof V5DataItemToMeasureWrapper ? measure : DMRUtilities.getMFWMeasure(this));
        ArrayList<IMetadata> queryItems = new ArrayList<IMetadata>();
        queryItems.add(qItem);
        return PrePlanUtilities.getInvolvedTables(prePlan, queryItems, false);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DMRMeasure)) {
            return false;
        }
        if (((DMRMeasure)other).getDimension().isMeasuresDimension()) {
            return this.getUniqueName().equals(((DMRMeasure)other).getUniqueName());
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.getUniqueName().hashCode();
        }
        return this.hashCode;
    }

    @Override
    public IQuerySubject getQuerySubject() {
        return null;
    }

    @Override
    public String getExpression() {
        return null;
    }

    @Override
    public boolean isMFWMeasure() {
        return false;
    }

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public Integer getSolveOrder() {
        return null;
    }

    @Override
    public boolean isDMR() {
        return true;
    }
}

