/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider;

import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.ISortItem;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMember;
import java.util.ArrayList;
import java.util.Comparator;

public class DMRMemberComparator
implements Comparator<IMember> {
    private final ArrayList<Object> sorts = new ArrayList();
    private final ArrayList<Integer> directions = new ArrayList();
    private final ArrayList<ISortItem.NullPlacementType> nullOrder = new ArrayList();

    public void addBusinessKey(Integer direct, ISortItem.NullPlacementType nullFlag) {
        this.sorts.add(Boolean.TRUE);
        this.directions.add(direct);
        this.nullOrder.add(nullFlag);
    }

    public void addCaption(Integer direct, ISortItem.NullPlacementType nullFlag) {
        this.sorts.add(Boolean.FALSE);
        this.directions.add(direct);
        this.nullOrder.add(nullFlag);
    }

    public void addProperty(String uniqueName, Integer direct, ISortItem.NullPlacementType nullFlag) {
        this.sorts.add(uniqueName);
        this.directions.add(direct);
        this.nullOrder.add(nullFlag);
    }

    @Override
    public int compare(IMember lhs, IMember rhs) {
        if (this.sorts.isEmpty()) {
            Value lV = lhs.getBusinessKeyValue();
            Value rV = rhs.getBusinessKeyValue();
            if (lV.isNull() && rV.isNull()) {
                return 0;
            }
            if (lV.isNull() || rV.isNull()) {
                if (lV.isNull()) {
                    return 1;
                }
                return -1;
            }
            return lV.compareTo(rV);
        }
        int r = 0;
        for (int i = 0; i < this.sorts.size(); ++i) {
            Value lV = this.getValue(this.sorts.get(i), lhs);
            Value rV = this.getValue(this.sorts.get(i), rhs);
            if (lV.isNull() && rV.isNull()) continue;
            if (lV.isNull() || rV.isNull()) {
                ISortItem.NullPlacementType nullOrderFlag = this.nullOrder.get(i);
                if (lV.isNull()) {
                    if (nullOrderFlag == ISortItem.NullPlacementType.NULL_FIRST) {
                        return -1;
                    }
                    return 1;
                }
                if (nullOrderFlag == null || nullOrderFlag == ISortItem.NullPlacementType.NULL_LAST) {
                    return -1;
                }
                return 1;
            }
            r = lV.compareTo(rV);
            if (r == 0) continue;
            return r *= this.directions.get(i).intValue();
        }
        return 0;
    }

    private Value getValue(Object o, IMember m) {
        if (o == Boolean.TRUE) {
            return m.getBusinessKeyValue();
        }
        if (o == Boolean.FALSE) {
            return m.getCaptionValue();
        }
        if (o instanceof String) {
            return (Value)m.getProperty((String)o);
        }
        return DMRMember.DEFAULT_BUSINESSKEY;
    }
}

