/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider;

import com.cognos.xqe.data.providers.olap.securecache.DMRMemberStorage;
import com.cognos.xqe.data.providers.olap.securecache.DMRMemberStoragePerLevel;
import com.cognos.xqe.data.providers.olap.securecache.MemberStorage;
import com.cognos.xqe.util.FileHandler;
import com.cognos.xqe.util.MemoryWalker;
import com.cognos.xqe.util.xml.XMLWriter;
import java.util.ArrayList;
import java.util.List;

public class DMRMetrics {
    protected static final String WILD_CARD = "*";
    protected static final String DMRSTATISTICS = "dmrStatistics";
    protected static final String DMRMEMBERSTORAGE = "dmrMemberStorage";
    protected static final String DMRMEMBERSTORAGELEVEL = "dmrMemberStorageLevels";
    protected static final String DMRMEMBERSTORAGEPERLEVEL = "dmrMemberStoragePerLevel";
    protected static final String KEY_ATTR = "KEY";
    protected static final String MEMORY_STATISTICS = "MemoryStatistics";
    protected static final String NMEMBER_ATTR = "NUMBER_OF_MEMBERS";

    public static void dumpDMRStatisticsToXMLFile(String fileName) {
        DMRStatistics r = DMRMetrics.collectDMRStatistics();
        XMLWriter xmlWriter = FileHandler.createOrAppendXMLWriterToFile(fileName);
        r.writeToXML(xmlWriter);
        xmlWriter.flush();
        xmlWriter.close();
    }

    public static DMRStatistics collectDMRStatistics() {
        DMRStatistics r = new DMRStatistics();
        List<MemberStorage> storages = MemberStorage.getMemberStorageInstances(WILD_CARD, WILD_CARD, WILD_CARD);
        for (MemberStorage st : storages) {
            if (!(st instanceof DMRMemberStorage)) continue;
            DMRMemberStorage dmrStorage = (DMRMemberStorage)st;
            DMRMemberStorage.DMRMemberStorageIdentifier id = dmrStorage.getIdentifier();
            DMRMemberStorageStatistics memberStorageSt = new DMRMemberStorageStatistics();
            r.allMemberStorages.add(memberStorageSt);
            memberStorageSt.key = id.toString();
            memberStorageSt.memoryStatistics = MemoryWalker.deepStatistics(dmrStorage);
            List<DMRMemberStoragePerLevel> levelStorages = dmrStorage.getDMRMemberStoragePerLevels();
            for (DMRMemberStoragePerLevel lvlStorage : levelStorages) {
                Object[] objSkip;
                DMRMemberStoragePerLevelStatistics l_st = new DMRMemberStoragePerLevelStatistics();
                memberStorageSt.levelStorages.add(l_st);
                l_st.levelUniqueName = lvlStorage.getLevelUniqueName();
                l_st.nMembers = lvlStorage.getNumberOfMembers();
                l_st.memoryStatistics = new MemoryWalker.MemoryStatistics();
                l_st.memoryStatistics.skip(st);
                l_st.memoryStatistics.skip(l_st.levelUniqueName);
                for (Object o : objSkip = lvlStorage.getTempObjects()) {
                    l_st.memoryStatistics.skip(o);
                }
                MemoryWalker.deepSizeof(lvlStorage, l_st.memoryStatistics);
                memberStorageSt.nMembers += l_st.nMembers;
            }
        }
        return r;
    }

    public static class DMRCubeStatistics {
    }

    public static class DMRMemberStoragePerLevelStatistics {
        public int nMembers = 0;
        public String levelUniqueName = null;
        public MemoryWalker.MemoryStatistics memoryStatistics = null;

        public void writeToXML(XMLWriter writer) {
            writer.beginElement(DMRMetrics.DMRMEMBERSTORAGEPERLEVEL, -1);
            writer.attribute(DMRMetrics.KEY_ATTR, this.levelUniqueName);
            writer.attribute(DMRMetrics.NMEMBER_ATTR, this.nMembers);
            writer.beginElement(DMRMetrics.MEMORY_STATISTICS, -1);
            writer.data(this.memoryStatistics.summaryToString());
            writer.endElement();
            writer.endElement();
        }
    }

    public static class DMRMemberStorageStatistics {
        public String key = null;
        public MemoryWalker.MemoryStatistics memoryStatistics = null;
        public List<DMRMemberStoragePerLevelStatistics> levelStorages = new ArrayList<DMRMemberStoragePerLevelStatistics>();
        public int nMembers = 0;

        public void writeToXML(XMLWriter writer) {
            writer.beginElement(DMRMetrics.DMRMEMBERSTORAGE, -1);
            writer.attribute(DMRMetrics.KEY_ATTR, this.key);
            writer.attribute(DMRMetrics.NMEMBER_ATTR, this.nMembers);
            writer.beginElement(DMRMetrics.MEMORY_STATISTICS, -1);
            writer.data(this.memoryStatistics.summaryToString());
            writer.endElement();
            if (!this.levelStorages.isEmpty()) {
                writer.beginElement(DMRMetrics.DMRMEMBERSTORAGELEVEL, -1);
            }
            for (DMRMemberStoragePerLevelStatistics st : this.levelStorages) {
                st.writeToXML(writer);
            }
            if (!this.levelStorages.isEmpty()) {
                writer.endElement();
            }
            writer.endElement();
        }
    }

    public static class DMRStatistics {
        public List<DMRMemberStorageStatistics> allMemberStorages = new ArrayList<DMRMemberStorageStatistics>();
        public List<DMRCubeStatistics> allCubes = new ArrayList<DMRCubeStatistics>();

        public void writeToXML(XMLWriter writer) {
            writer.beginElement(DMRMetrics.DMRSTATISTICS, -1);
            for (DMRMemberStorageStatistics st : this.allMemberStorages) {
                st.writeToXML(writer);
            }
            writer.endElement();
        }
    }
}

