/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.rqp.RQPPrePlan;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.AllocationRule;
import com.cognos.xqe.metadata.IAggregateRule;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IEmbeddedFilter;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.wrapper.DimensionWrapper;
import com.cognos.xqe.pool.connection.IConnectionPool;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.ResponseMessageFolder;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.rsapi.RSAPIColumn;
import com.cognos.xqe.rsapi.RSAPIRow;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.CJSPreloader;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCompoundKeyMapping;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRDimension;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRFetchingContextKey;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRHierarchy;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMeasure;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRPreloadCellsLogger;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRPreloadQueryEliminator;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRQueryStrategyPreCellLoading;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.IDMRMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.ReusableDMRDimension;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.V5QueryAggregateOverTabularStream;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.V5QueryGroup;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.V5QueryGroupWorker;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.V5QueryOverTabularStream;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.V5QueryResult;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.AggregateCombination;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.Combination;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.CrossJoinedSetDecomposer;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.MeasureSelection;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.Selection;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.rsapi.RSAPIQueryResult;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.rsapi.RSAPIRowCallback;
import com.cognos.xqe.runtree.olap.mdx.interpreter.AbstractResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ITupleValueIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterRuntimeException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline.IPipelineResultSet;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.Member;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.MemberProxy;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.BlockTupleStorageUtil;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.AdaptiveCubeletStorageManager;
import com.cognos.xqe.runtree.olap.mdx.util.SymmetricSubqueryIterator;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderQuery;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderQueryResult;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.DMRPushdownAdapter;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.IPushdownAdapter;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.PushdownManager;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.TraceLogManager;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.transformation.v5tocogsql.prePlan.PrePlanUtilities;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.INullPlacement;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.monitor.ResourceMonitor;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqe.zipi.ZipiContext;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.collections.map.MultiValueMap;

public class DMRQueryStrategy
extends QueryStrategy {
    public static final int MAX_COMBINATION_SIZE_TO_OPTIMIZE = 8;
    protected static final Integer NUMEROFROWS_EXECUTE_FOR_VALIDATE = 50;
    private Map<IDimension, Integer> dimToIndex = null;
    MultiValueMap queryNameToScopeMember = new MultiValueMap();
    private DMRQueryStrategyPreCellLoading preLoadingStrategy = null;

    public void setPreLoadingStrategy(DMRQueryStrategyPreCellLoading qs) {
        this.preLoadingStrategy = qs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CrossJoinedSet cjs, IResultSet resultSet) throws InterpreterException {
        DMRCube cube = (DMRCube)this.getCube();
        ZipiTimer zipiTimer = ZipiBridge.startTimer("FetchDMRCellValues", ZipiContext.getQRDName());
        try {
            if (this.preLoadingStrategy != null && this.preLoadingStrategy.getPreLoading()) {
                this.fetchFromCubelets(cjs, (AbstractResultSet)resultSet, cube);
                return;
            }
            IDataSourceCapabilities capabilities = null;
            ExecutionEnvironment ee = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
            if (ee != null) {
                IDataSource ds = ee.getDataSource();
                if (ds != null) {
                    capabilities = ds.getCapabilities();
                }
            } else {
                capabilities = null;
            }
            int minExcessTuplesForSplitQuery = -1;
            int excessTuplesRatioForSplitQuery = -1;
            if (capabilities != null) {
                minExcessTuplesForSplitQuery = capabilities.getIntegerValue("lolap.minExcessTuplesForSplitQuery", -1);
                excessTuplesRatioForSplitQuery = capabilities.getIntegerValue("lolap.excessTuplesRatioForSplitQuery", -1);
            }
            StringBuilder strBldr = new StringBuilder();
            SymmetricSubqueryIterator iterator = new SymmetricSubqueryIterator(cjs, minExcessTuplesForSplitQuery, excessTuplesRatioForSplitQuery, true, strBldr);
            while (iterator.hasNext()) {
                CrossJoinedSet requestedCJS = iterator.next();
                this.fetchFromCubelets(requestedCJS, (AbstractResultSet)resultSet, cube);
            }
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
    }

    protected Map<IDimension, Integer> getDimToIndexMap() {
        if (this.dimToIndex == null) {
            List<IDimension> dimensions = this.getCube().getDimensions();
            this.dimToIndex = new HashMap<IDimension, Integer>();
            int idx = 0;
            for (IDimension dimension : dimensions) {
                this.dimToIndex.put(dimension, new Integer(idx++));
            }
        }
        return this.dimToIndex;
    }

    private DMRLevel getHighestScopeLevelInCombination(DMRDimension dimension, Map<DMRDimension, DMRLevel> dimScopes) {
        DMRLevel scopeOfTargetDimension;
        DMRLevel scopeLevel = dimScopes.get(dimension);
        int scopeLevelIndex = scopeLevel.getIndex();
        if (dimension.getObjectType() == MetadataType.SHORTCUT || dimension.isAccessedViaShortcut()) {
            IMetadata target = dimension.getShortcut().getTarget();
            for (DMRDimension dim : dimScopes.keySet()) {
                if (dim.equals(dimension)) continue;
                IDimension wrappedDim = dim.getWrappedDimension();
                if (wrappedDim instanceof DimensionWrapper) {
                    wrappedDim = ((DimensionWrapper)wrappedDim).getWrappedDimension();
                }
                if (!wrappedDim.equals(target)) continue;
                scopeOfTargetDimension = dimScopes.get(dim);
                if (scopeLevelIndex <= scopeOfTargetDimension.getIndex()) break;
                scopeLevelIndex = scopeOfTargetDimension.getIndex();
                break;
            }
        } else {
            IDimension wrappedDim = dimension.getWrappedDimension();
            if (wrappedDim instanceof DimensionWrapper) {
                wrappedDim = ((DimensionWrapper)wrappedDim).getWrappedDimension();
            }
            for (DMRDimension dim : dimScopes.keySet()) {
                IMetadata target;
                if (dim.equals(dimension) || dim.getObjectType() != MetadataType.SHORTCUT && !dim.isAccessedViaShortcut() || !wrappedDim.equals(target = dim.getShortcut().getTarget())) continue;
                scopeOfTargetDimension = dimScopes.get(dim);
                if (scopeLevelIndex <= scopeOfTargetDimension.getIndex()) break;
                scopeLevelIndex = scopeOfTargetDimension.getIndex();
                break;
            }
        }
        while (scopeLevelIndex < scopeLevel.getIndex()) {
            scopeLevel = (DMRLevel)scopeLevel.getPreviousLevel();
        }
        return scopeLevel;
    }

    private void populateKeyMapping(List<Map<IMember, List<ILevel>>> listofMeasures, Combination combination, IMember[] outputTuple, Map<IDimension, Integer> dimToIndexMap, String queryName, List<ILevel> levelsForAllCombinations, V5QueryOverTabularStream result) {
        ArrayList<DMRCompoundKeyMapping> keyMappings = new ArrayList<DMRCompoundKeyMapping>();
        ArrayList<List<ILevel>> listofLevels = new ArrayList<List<ILevel>>();
        List<IMember> measures = combination.getMeasures();
        HashMap<DMRDimension, DMRLevel> dimScopes = new HashMap<DMRDimension, DMRLevel>();
        for (Selection currentSelection : combination.getSelections()) {
            IMember mem = currentSelection.getFirstMember();
            DMRDimension dim = (DMRDimension)mem.getDimension();
            if (dim.isMeasuresDimension()) continue;
            DMRLevel level = (DMRLevel)mem.getLevel();
            DMRLevel scopeLevel = V5QueryOverTabularStream.getLowestLevelFromScope((IMeasure)measures.get(0), level);
            if (scopeLevel == null) {
                scopeLevel = (DMRLevel)level.getDimension().getLevel(0);
            }
            dimScopes.put(dim, scopeLevel);
        }
        for (Selection currentSelection : combination.getSelections()) {
            RQPPrePlan prePlan;
            List<IEmbeddedFilter> embeddedFilters;
            IDimension dim;
            List<IMember> memberList = null;
            memberList = currentSelection.getMembersList();
            IMember mem = currentSelection.getFirstMember();
            if (currentSelection.isSlicer()) {
                outputTuple[dimToIndexMap.get((Object)mem.getDimension()).intValue()] = mem;
            }
            if ((dim = mem.getDimension()).isMeasuresDimension()) continue;
            DMRLevel level = (DMRLevel)mem.getLevel();
            boolean isRootWithRelationalEmbeddedFilters = false;
            if (level.isRootLevel() && !(embeddedFilters = PrePlanUtilities.getInvolvedEmbeddedFiltersByDimension(prePlan = ((DMRCube)this.getCube()).getModelCube().getRQPPrePlanQuery(), level.getDimension().getV5UniqueName())).isEmpty()) {
                isRootWithRelationalEmbeddedFilters = true;
            }
            DMRLevel scopeLevel = (DMRLevel)dimScopes.get(dim);
            HashMap<IMember, Set<IMember>> membersByParent = new HashMap<IMember, Set<IMember>>();
            IHierarchy hierarchy = level.getHierarchy();
            if (level.isMappedToRelationalColumn() && scopeLevel.isMappedToRelationalColumn()) {
                DMRCompoundKeyMapping keyMapping = new DMRCompoundKeyMapping();
                if (memberList != null) {
                    for (int idx = 0; idx < memberList.size(); ++idx) {
                        IMember parentMember;
                        HashSet<IMember> members;
                        IMember scopeMember = memberList.get(idx);
                        boolean addScopeMember = false;
                        while (scopeMember.getLevel().getIndex() > scopeLevel.getIndex()) {
                            scopeMember = scopeMember.getParent();
                            addScopeMember = true;
                        }
                        if (addScopeMember) {
                            this.queryNameToScopeMember.put((Object)queryName, (Object)scopeMember);
                        }
                        if ((members = (HashSet<IMember>)membersByParent.get(parentMember = scopeMember.getParent())) == null) {
                            members = new HashSet<IMember>();
                            membersByParent.put(parentMember, members);
                        }
                        members.add(scopeMember);
                        keyMapping.addMemberSelection(scopeMember);
                    }
                } else {
                    IMember parentMember;
                    HashSet<IMember> members;
                    IMember scopeMember = mem;
                    boolean addScopeMember = false;
                    while (scopeMember.getLevel().getIndex() > scopeLevel.getIndex()) {
                        scopeMember = scopeMember.getParent();
                    }
                    if (addScopeMember) {
                        this.queryNameToScopeMember.put((Object)queryName, (Object)scopeMember);
                    }
                    if ((members = (HashSet<IMember>)membersByParent.get(parentMember = scopeMember.getParent())) == null) {
                        members = new HashSet<IMember>();
                        membersByParent.put(parentMember, members);
                    }
                    members.add(scopeMember);
                    keyMapping.addMemberSelection(scopeMember);
                }
                this.collectOptimizableAggregationLevels(listofLevels, membersByParent, level);
                if (!(this.preLoadingStrategy != null && !this.preLoadingStrategy.loadLowestLevel() || level.isRootLevel() && !isRootWithRelationalEmbeddedFilters)) {
                    keyMapping.adjustProjectedLevelsToLowestLevel(listofLevels, combination.getLowestAggregationLevelInfo(), this.getHighestScopeLevelInCombination((DMRDimension)dim, dimScopes), this);
                }
                keyMappings.add(keyMapping);
            } else {
                this.collectOptimizableAggregationLevels(listofLevels, membersByParent, level);
                MDXLevelInfo lowestAggregationLevelInfo = combination.getLowestAggregationLevelInfo();
                if (lowestAggregationLevelInfo != null && lowestAggregationLevelInfo.getHierarchyInfo().projectsHierarchy(hierarchy) && lowestAggregationLevelInfo.getLowestProjectedLevel(hierarchy).getIndex() > level.getIndex()) {
                    DMRCompoundKeyMapping keyMapping = new DMRCompoundKeyMapping();
                    if (!(this.preLoadingStrategy != null && !this.preLoadingStrategy.loadLowestLevel() || level.isRootLevel() && !isRootWithRelationalEmbeddedFilters)) {
                        keyMapping.adjustProjectedLevelsToLowestLevel(listofLevels, combination.getLowestAggregationLevelInfo(), this.getHighestScopeLevelInCombination((DMRDimension)dim, dimScopes), this);
                        keyMappings.add(keyMapping);
                    }
                }
            }
            if (!level.isMappedToRelationalColumn() || scopeLevel.isMappedToRelationalColumn()) continue;
            IMember scopeMember = mem;
            while (scopeMember.getLevel().getIndex() > scopeLevel.getIndex()) {
                scopeMember = scopeMember.getParent();
            }
            outputTuple[this.dimToIndex.get((Object)scopeMember.getDimension()).intValue()] = scopeMember;
            this.queryNameToScopeMember.put((Object)queryName, (Object)scopeMember);
        }
        List<IMember> extraMeasures = null;
        if (combination.hasMeasures()) {
            MeasureSelection measuresSels = combination.getMeasureSelection();
            extraMeasures = measuresSels.getExtraMeasures();
        }
        ArrayList<IMember> allMeasures = new ArrayList<IMember>();
        allMeasures.addAll(measures);
        if (extraMeasures != null) {
            allMeasures.addAll(extraMeasures);
        }
        this.optimizeCombination(listofLevels, listofMeasures, allMeasures, levelsForAllCombinations);
        for (DMRCompoundKeyMapping aKeyMapping : keyMappings) {
            aKeyMapping.removeUnusedProjectedLevels(listofMeasures);
            aKeyMapping.addToQuery(result);
        }
        for (IMember mb : outputTuple) {
            DMRHierarchy hier;
            String skipDimUName;
            ILevel lvl;
            if (mb == null || mb.isMeasure() || !(lvl = mb.getLevel()).isRootLevel() || (skipDimUName = (hier = (DMRHierarchy)lvl.getHierarchy()).getSkipDimForDefaultMember(mb)) == null) continue;
            result.addSkipDimensionForEmbeddedFilter(skipDimUName);
        }
    }

    public V5QueryOverTabularStream combinationToV5Query(V5QueryGroup groupQuery, Combination combination, List<ILevel> levelsForAllCombinations) {
        List<IDimension> dimensions = this.getCube().getDimensions();
        IMember[] outputTuple = new IMember[dimensions.size()];
        Map<IDimension, Integer> dimToIndexMap = this.getDimToIndexMap();
        List<IMember> measures = combination.getMeasures();
        DMRUtilities.SubqueryType subQueryType = DMRUtilities.SubqueryType.FETCH_CELL_VALUES;
        if (this.getPushDownMode()) {
            subQueryType = DMRUtilities.SubqueryType.getPushdownSubqueryType(this.getPushdownManager());
        }
        DMRCube dmrCube = (DMRCube)this.getCube();
        StringBuilder sb = new StringBuilder(subQueryType.toString());
        if (this.preLoadingStrategy != null && this.preLoadingStrategy.getPreLoading()) {
            sb.append("_pc");
        }
        String queryName = sb.toString();
        String metadataNames = TraceLogManager.formatMemberNames(measures);
        V5QueryOverTabularStream result = new V5QueryOverTabularStream(dmrCube, subQueryType, metadataNames, queryName);
        if (dmrCube.getExecuteForValidate()) {
            result.setNumberOfRowsToRetrieve(NUMEROFROWS_EXECUTE_FOR_VALIDATE);
        }
        this.populateKeyMapping(groupQuery.getListOfMeasures(), combination, outputTuple, dimToIndexMap, queryName, levelsForAllCombinations, result);
        result.setMeasuresByLevels(groupQuery.getListOfMeasures());
        result.setV5QueryToLoadmembers(false);
        result.setMeasuresSelections(measures);
        result.setSelections(combination.getSelectionList());
        result.setOutputTuple(outputTuple);
        result.setMeasuresOffset(result.getColumnCount());
        for (int i = 0; i < measures.size(); ++i) {
            DMRMeasure measure = (DMRMeasure)measures.get(i);
            result.addColumn(measure);
        }
        List<IMember> extraMeasures = null;
        if (combination.hasMeasures()) {
            MeasureSelection measuresSels = combination.getMeasureSelection();
            extraMeasures = measuresSels.getExtraMeasures();
        }
        if (extraMeasures != null) {
            result.setExtraMeasures(extraMeasures);
            for (IMember eM : extraMeasures) {
                result.addColumn(eM);
            }
        }
        return result;
    }

    public boolean compareExceptSetWithIncomingCJS(IMember[][] incomingSet, IMember[][] exceptSet, IHierarchy[] cubeHiers) {
        HashMap<String, String> exceptSetHashMap = new HashMap<String, String>();
        if (exceptSet == null) {
            return false;
        }
        for (int k = 0; k < cubeHiers.length; ++k) {
            String memberUN;
            for (int i = 0; i < exceptSet[k].length; ++i) {
                memberUN = exceptSet[k][i].getUniqueName();
                exceptSetHashMap.put(memberUN, memberUN);
            }
            for (int j = 0; j < incomingSet[k].length; ++j) {
                memberUN = incomingSet[k][j].getUniqueName();
                if (exceptSetHashMap.containsKey(memberUN)) continue;
                return false;
            }
        }
        return true;
    }

    public V5QueryAggregateOverTabularStream combinationAggregateToV5Query(V5QueryGroup groupQuery, int index, AggregateCombination comb, List<ILevel> levelsForAllCombinations) {
        List<IDimension> dimensions = this.getCube().getDimensions();
        IMember[] outputTuple = new IMember[dimensions.size()];
        Map<IDimension, Integer> dimToIndexMap = this.getDimToIndexMap();
        DMRCube dmrCube = (DMRCube)this.getCube();
        String queryName = "FetchCellValuesFLAggregates" + index;
        V5QueryAggregateOverTabularStream result = new V5QueryAggregateOverTabularStream(dmrCube, comb.getMeasure().getUniqueName(), queryName);
        this.populateKeyMapping(groupQuery.getListOfMeasures(), comb, outputTuple, dimToIndexMap, queryName, levelsForAllCombinations, result);
        result.setV5QueryToLoadmembers(false);
        result.setAggregateMemberToOrExpressions(comb.getPerHierarchyMemberList());
        List<IMember> measuresSelections = comb.getMeasures();
        result.setMeasuresSelections(measuresSelections);
        result.setSelections(comb.getSelectionList());
        result.setOutputTuple(outputTuple);
        result.setMeasuresByLevels(groupQuery.getListOfMeasures());
        result.setMeasuresOffset(result.getColumnCount());
        for (int i = 0; i < measuresSelections.size(); ++i) {
            DMRMeasure measure = (DMRMeasure)measuresSelections.get(i);
            result.addColumn(measure);
        }
        return result;
    }

    public static IDimension getLowestDimensionInContext(Map<IDimension, ILevel> levelInfo, List<IDimension> dimensions, IAggregateRule rule) {
        List<DMRDimension> dmrDims = CollectionCast.downcast(dimensions, IDimension.class, DMRDimension.class);
        DMRDimension[] dims = DMRUtilities.getDMRDimensionsFromMFWDimensionUniqueName(rule.getDimensionRef(), dmrDims);
        if (dims.length == 1) {
            return dims[0];
        }
        DMRDimension lowestDim = dims[0];
        int lowestLevelIndex = 0;
        for (DMRDimension dim : dims) {
            int levelIndex;
            ILevel level = levelInfo.get(dim);
            if (level == null || (levelIndex = level.getIndex()) <= lowestLevelIndex) continue;
            lowestDim = dim;
            lowestLevelIndex = levelIndex;
        }
        return lowestDim;
    }

    protected boolean needLoadExtraMeasuresForReport() {
        QueryContext qc = this.getInfoData();
        return !qc.isOneMeasurePerSubquery() && qc.canLoadExtraReportMeasures();
    }

    protected void fetchFromCubelets(CrossJoinedSet cjs, AbstractResultSet resultSet, DMRCube cube) throws InterpreterException {
        if (cjs.isEmpty()) {
            return;
        }
        List<IHierarchy> hiers = cube.getHierarchies(false);
        IHierarchy[] cubeHiers = hiers.toArray(new IHierarchy[hiers.size()]);
        IMember[][] cjsSelections = cjs.getMembers(cubeHiers);
        IMember[][] notReuseSelections = new IMember[cubeHiers.length][];
        IMember[][] reuseSelections = new IMember[cubeHiers.length][];
        ArrayList<IMember> notReuseMeasures = new ArrayList<IMember>();
        ArrayList<IMember> reuseMeasures = new ArrayList<IMember>();
        int measurePos = -1;
        boolean isFetchingCompleteTuple = this.checkTagForCompleteTuple(cjsSelections);
        boolean bHasTemporaryDim = false;
        int i = 0;
        for (i = 0; i < cubeHiers.length; ++i) {
            if (!cubeHiers[i].getDimension().isMeasuresDimension()) {
                notReuseSelections[i] = cjsSelections[i];
                reuseSelections[i] = cjsSelections[i];
                if (cubeHiers[i].getDimension() instanceof ReusableDMRDimension) continue;
                bHasTemporaryDim = true;
                continue;
            }
            measurePos = i;
            for (IMember meas : cjsSelections[i]) {
                if (((DMRMeasure)meas).isReUseable()) {
                    reuseMeasures.add(meas);
                    continue;
                }
                notReuseMeasures.add(meas);
            }
        }
        if (measurePos == -1) {
            return;
        }
        if (!notReuseMeasures.isEmpty()) {
            notReuseSelections[measurePos] = notReuseMeasures.toArray(new IMember[notReuseMeasures.size()]);
            if (this.executeToPushdownManager(notReuseSelections, notReuseMeasures.toArray(new IMember[notReuseMeasures.size()]), resultSet, cube.getLocalCubelet(), measurePos, isFetchingCompleteTuple)) {
                return;
            }
            this.executeToCubeletForCombinations(cube, notReuseSelections, resultSet, cube.getLocalCubelet(), measurePos, cubeHiers, isFetchingCompleteTuple);
        }
        if (reuseMeasures.isEmpty()) {
            return;
        }
        reuseSelections[measurePos] = reuseMeasures.toArray(new IMember[reuseMeasures.size()]);
        PushdownManager pm = this.getPushdownManager();
        if ((!cube.isReusedCube() || bHasTemporaryDim || pm != null && !pm.isPushdownResultCachable()) && this.executeToPushdownManager(reuseSelections, reuseMeasures.toArray(new IMember[reuseMeasures.size()]), resultSet, cube.getLocalCubelet(), measurePos, isFetchingCompleteTuple)) {
            return;
        }
        AdaptiveCubeletStorageManager storageManager = null;
        if (cube.isReusedCube() && !bHasTemporaryDim) {
            storageManager = cube.getGlobalCubelet();
            storageManager.syncToCubeContext();
            storageManager.getReadLock().lock();
            try {
                if (this.executeToPushdownManager(reuseSelections, reuseMeasures.toArray(new IMember[reuseMeasures.size()]), resultSet, storageManager, measurePos, isFetchingCompleteTuple)) {
                    return;
                }
                if (resultSet != null && resultSet.isPipelining()) {
                    try {
                        ((IPipelineResultSet)((Object)resultSet)).doNotTrackAddedCellsAsPossibleFutureDuplicates();
                    }
                    catch (InterruptedException e) {
                        throw new InterpreterException(e.getLocalizedMessage(), e);
                    }
                }
                if (isFetchingCompleteTuple || !cube.getBlockingFetchingSameCells()) {
                    this.executeToCubeletForCombinations(cube, reuseSelections, resultSet, storageManager, measurePos, cubeHiers, isFetchingCompleteTuple);
                }
                this.blockedExecuteToCubeletForCombinations(cube, reuseSelections, resultSet, storageManager, measurePos, cubeHiers);
            }
            catch (InterpreterException e) {
                throw new XQERuntimeException(e);
            }
            finally {
                storageManager.getReadLock().unlock();
            }
        } else {
            storageManager = cube.getLocalCubelet();
            try {
                if (this.needPreciseLoading(cjs, cube)) {
                    this.executeToCubeletForCJS(cube, cjs, resultSet, storageManager, measurePos, cubeHiers, isFetchingCompleteTuple);
                } else {
                    this.executeToCubeletForCombinations(cube, reuseSelections, resultSet, storageManager, measurePos, cubeHiers, isFetchingCompleteTuple);
                }
            }
            catch (InterpreterException e) {
                throw new XQERuntimeException(e);
            }
        }
    }

    public void preloadCellValuesConcurrently(List<CrossJoinedSet> cjs) throws InterpreterException {
        DMRCube cube = (DMRCube)this.getCube();
        this.preloadCellValuesConcurrently(cjs, null, cube);
    }

    private void preloadCellValuesConcurrently(List<CrossJoinedSet> listOfCrossJoinedSet, AbstractResultSet resultSet, DMRCube cube) throws InterpreterException {
        ArrayList<CJSPreloader> cjsPreloaders = new ArrayList<CJSPreloader>();
        for (CrossJoinedSet cjs : listOfCrossJoinedSet) {
            if (cjs.isEmpty()) continue;
            List<IHierarchy> hiers = cube.getHierarchies(false);
            IHierarchy[] cubeHiers = hiers.toArray(new IHierarchy[hiers.size()]);
            IMember[][] cjsSelections = cjs.getMembers(cubeHiers);
            int measurePos = -1;
            for (int i = 0; i < cubeHiers.length; ++i) {
                if (!cubeHiers[i].getDimension().isMeasuresDimension()) continue;
                measurePos = i;
                break;
            }
            if (measurePos == -1) continue;
            AdaptiveCubeletStorageManager storageManager = cube.getLocalCubelet();
            CJSPreloader cjsPreloader = new CJSPreloader(cube, cjsSelections, storageManager, measurePos, cubeHiers, cjs);
            cjsPreloaders.add(cjsPreloader);
            this.setupV5QueryGroups(cjsPreloader);
        }
        if (cjsPreloaders.size() > 0) {
            List<CJSPreloader> subqueriesToDB = DMRPreloadQueryEliminator.eliminatesUnnecesaryPreloadQueries(cjsPreloaders);
            this.executeConcurrentPreloaders(subqueriesToDB, cube);
        }
    }

    private void executeConcurrentPreloaders(List<CJSPreloader> cjsPreloader, DMRCube cube) throws InterpreterException {
        if (cjsPreloader.size() == 0) {
            return;
        }
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        AdaptiveCubeletStorageManager storageManager = cube.getLocalCubelet();
        ArrayList<V5QueryGroupWorker> allQueryGroupWorkers = new ArrayList<V5QueryGroupWorker>();
        for (CJSPreloader cjSworker : cjsPreloader) {
            for (V5QueryGroup v5QueryGroup : cjSworker.getV5QueryGroups()) {
                V5QueryGroupWorker v5QueryGroupWorker = new V5QueryGroupWorker(cube, this, storageManager, execEnv, v5QueryGroup);
                allQueryGroupWorkers.add(v5QueryGroupWorker);
            }
        }
        if (allQueryGroupWorkers.size() == 0) {
            return;
        }
        ExecutorService executor = Executors.newFixedThreadPool(allQueryGroupWorkers.size());
        HashMap<V5QueryGroup, Future<Boolean>> v5QueryResults = new HashMap<V5QueryGroup, Future<Boolean>>();
        RequestEnvironment requestEnvironment = (RequestEnvironment)execEnv.getRequestEnvironment();
        int maxSeverityLevel = requestEnvironment.getMaxSeverityLevel();
        if (DMRPreloadCellsLogger.isPreloadLoggerOnAtInfoLevel() || maxSeverityLevel == 3) {
            IMessageKey.Param1 messageKey = XQEMessageKeys.EXE_PreloadCellsNumberOfConcurrent;
            Locale productLocale = XQEMessages.getCurrProductLocale();
            String number = new Integer(allQueryGroupWorkers.size()).toString();
            String governorValueLogMessage = XQEMessages.getMessage(messageKey, productLocale, number);
            if (DMRPreloadCellsLogger.isPreloadLoggerOnAtInfoLevel()) {
                DMRPreloadCellsLogger.logToXQELog(governorValueLogMessage);
            }
            if (maxSeverityLevel == 3) {
                Object msgType = ResponseMessage.ResponseMessageType.DMR_NODE_TYPE_INT;
                ResponseMessage message = new ResponseMessage((ResponseMessage.ResponseMessageType)((Object)msgType), governorValueLogMessage);
                ResponseMessageFolder folder = requestEnvironment.getResponseMessageFolder();
                folder.appendExecutionResponseMessage(message);
            }
        }
        IExecutionEnvironment environment = ExecutionEnvironmentContext.getExecutionEnvironment();
        MultiRequestContext multiRequestContext = environment.getMultiRequestContext();
        IConnectionPool poolMRC = multiRequestContext.getConnectionPool();
        IConnectionPool poolEE = environment.getConnectionPool();
        try {
            for (V5QueryGroupWorker queryGroupWorker : allQueryGroupWorkers) {
                Future<Boolean> results = executor.submit(queryGroupWorker);
                v5QueryResults.put(queryGroupWorker.getV5QueryGroup(), results);
            }
        }
        catch (Exception ex) {
            throw XQERuntimeException.wrap(ex);
        }
        finally {
            executor.shutdown();
            multiRequestContext.setConnectionPool(poolMRC);
            environment.setConnectionPool(poolEE);
        }
        for (V5QueryGroup v5QueryGroup : v5QueryResults.keySet()) {
            try {
                Boolean queryResult = (Boolean)((Future)v5QueryResults.get(v5QueryGroup)).get();
                if (queryResult.booleanValue()) {
                    DMRPreloadCellsLogger.logToXQELog("Execution result success.");
                } else {
                    DMRPreloadCellsLogger.logToXQELog("Execution result failure.");
                }
            }
            catch (Exception ex) {
                DMRPreloadCellsLogger.logToXQELog("Execution result occurred with exception.");
                throw XQERuntimeException.wrap(ex);
            }
            IMember[][] unknownMemberSet = v5QueryGroup.getUnknownMemberSet();
            AdaptiveCubeletStorageManager.ParamDefinition param = v5QueryGroup.getParam();
            this.performConstantAllocationOnGroupQuery(v5QueryGroup, unknownMemberSet, null, param);
            this.includeAllTheParentSelections(v5QueryGroup, unknownMemberSet, param);
            storageManager.putTupleValues(param);
        }
    }

    private boolean needPreciseLoading(CrossJoinedSet cjs, DMRCube cube) {
        if (this.preLoadingStrategy == null || !this.preLoadingStrategy.isPreLoaded()) {
            return false;
        }
        return cube.getLoadingTypeAfterPreLoading() == DMRQueryStrategyPreCellLoading.LoadType.PRECISELOAD && DMRQueryStrategyPreCellLoading.hasSetWithMultipleDimensions(cjs);
    }

    private boolean executeToPushdownManager(IMember[][] setToFetch, IMember[] measuresMembers, AbstractResultSet resultSet, AdaptiveCubeletStorageManager storage, int measurePos, boolean isFetchingCompleteTuple) {
        if (!this.getPushDownMode()) {
            return false;
        }
        boolean toReturn = false;
        PushdownManager pm = this.getPushdownManager();
        try {
            String functionName = pm.getTopPushdownFunctionName();
            pm.setParameter(functionName, "measurePos", measurePos);
            pm.setParameter(functionName, "isFetchingCompleteTuple", isFetchingCompleteTuple);
            toReturn = pm.executePushdown(setToFetch, measuresMembers, resultSet, storage);
        }
        catch (InterpreterRuntimeException e) {
            throw new XQERuntimeException();
        }
        catch (InterpreterException e) {
            throw new XQERuntimeException();
        }
        if (toReturn) {
            pm.setPushdownExecutionFinished(true);
        }
        return toReturn;
    }

    public boolean checkTagForCompleteTuple(IMember[][] cjsSelections) {
        for (int i = 0; i < cjsSelections.length; ++i) {
            for (int j = 0; j < cjsSelections[i].length; ++j) {
                if (!this.isCompleteTupleTag(cjsSelections[i][j])) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isCompleteTupleTag(IMember member) {
        String name = member.getName();
        return name != null && name.equals("tagCompleteTuple");
    }

    protected boolean checkIfSummaryFactPatternExistsInCombinations(List<Combination> combinations) throws InterpreterException {
        boolean summaryExists = false;
        boolean summaryFactQuery = false;
        int comboSize = combinations.size();
        boolean hasSummary = this.getInfoData().isSummaryRequested();
        if (this.getInfoData().getDMRQuerySummaryOptimizationLevel() < 1 || comboSize > 8) {
            return false;
        }
        if (!hasSummary && comboSize == 1) {
            return false;
        }
        boolean bOnlySummary = true;
        boolean batleastOneSummary = false;
        summaryExists = true;
        for (Combination aCombination : combinations) {
            for (Selection aSelection : aCombination.getSelections()) {
                if (aSelection.getMembersList().get(0).isMeasure() || aSelection.getMembersList().get(0).getLevel().isRootLevel()) continue;
                summaryExists = false;
                bOnlySummary = false;
                break;
            }
            if (!summaryExists || batleastOneSummary) continue;
            batleastOneSummary = true;
        }
        if (!bOnlySummary && batleastOneSummary) {
            summaryFactQuery = true;
        }
        if (!summaryFactQuery && hasSummary && !bOnlySummary) {
            summaryFactQuery = hasSummary;
        }
        if (summaryFactQuery && !hasSummary && (combinations.size() == 1 || combinations.size() > 8)) {
            summaryFactQuery = false;
        }
        if (summaryFactQuery && this.getInfoData().getDMRQuerySummaryOptimizationLevel() < 1) {
            summaryFactQuery = false;
        }
        return summaryFactQuery;
    }

    public IMember[][] checkIfSummaryLevelCombinationExits(int measurePos, IHierarchy[] cubeHiers, IMember[][] selections, AdaptiveCubeletStorageManager storageManager, AbstractResultSet resultSet, List<IMember> measureSelection, DMRCube cube) throws InterpreterException {
        IMember[][] selectionsOfTheRoot = new IMember[cube.getDimensionCount()][];
        for (int ii = 0; ii < cube.getDimensionCount(); ++ii) {
            ArrayList<IMember> selectionRootMemberSet = new ArrayList<IMember>();
            IMember mem = cube.getDimension(ii).getDefaultHierarchy().getDefaultMember();
            if (mem.isMeasure()) {
                selectionsOfTheRoot[ii] = measureSelection.toArray(new IMember[measureSelection.size()]);
                continue;
            }
            selectionRootMemberSet.add(mem);
            selectionsOfTheRoot[ii] = selectionRootMemberSet.toArray(new IMember[selectionRootMemberSet.size()]);
        }
        IMember[][] unknownMemberSet = storageManager.fetchSingleLevelCombination(measurePos, cubeHiers, selectionsOfTheRoot, resultSet);
        return unknownMemberSet;
    }

    private void collectOptimizableAggregationLevels(List<List<ILevel>> listofLevels, Map<IMember, Set<IMember>> membersByParent, ILevel currentLevel) {
        ArrayList<ILevel> oneListOfLevels = new ArrayList<ILevel>();
        oneListOfLevels.add(currentLevel);
        listofLevels.add(oneListOfLevels);
        String currentLevelName = currentLevel.getName();
        if (this.getInfoData().getDMRQuerySummaryOptimizationLevel() > 0 && this.getInfoData().isDMR() && !this.getPushDownMode() && !currentLevelName.equals("tagLevelForCompleteTuple")) {
            boolean hasAllChild = true;
            while (hasAllChild && currentLevel.getPreviousLevel() != null) {
                IMember member;
                IMember parentMember;
                currentLevel = currentLevel.getPreviousLevel();
                for (IMember member2 : membersByParent.keySet()) {
                    INullPlacement dmrMember;
                    Set<IMember> childMembers = membersByParent.get(member2);
                    if (member2 instanceof DMRMemberProxy) {
                        dmrMember = (DMRMemberProxy)member2;
                        if (((DMRMemberProxy)dmrMember).hasGotAllChildren() && ((MemberProxy)((Object)dmrMember)).getChildrenCardinality() == childMembers.size()) continue;
                        hasAllChild = false;
                        break;
                    }
                    dmrMember = (DMRMember)member2;
                    if (((Member)((Object)dmrMember)).hasGotAllChildren() && ((Member)((Object)dmrMember)).getChildrenCardinality() == childMembers.size()) continue;
                    hasAllChild = false;
                    break;
                }
                if (!hasAllChild) continue;
                oneListOfLevels.add(currentLevel);
                ArrayList<IMember> currentMembers = new ArrayList<IMember>(membersByParent.keySet());
                membersByParent.clear();
                Iterator<IMember> iterator = currentMembers.iterator();
                while (iterator.hasNext() && (parentMember = (member = iterator.next()).getParent()) != null) {
                    Set<IMember> members = membersByParent.get(parentMember);
                    if (members == null) {
                        members = new HashSet<IMember>();
                        membersByParent.put(parentMember, members);
                    }
                    members.add(member);
                }
            }
        }
    }

    private void optimizeCombination(List<List<ILevel>> inputListOfLevels, List<Map<IMember, List<ILevel>>> listofMeasures, List<IMember> measures, List<ILevel> levelsForAllCombinations) {
        XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "DMRQueryStrategy", LogLevel.INFO);
        if (logger.isOn()) {
            long computedSize = 1L;
            logger.log("listOfLevels: size=" + inputListOfLevels.size());
            for (int i = 0; i < inputListOfLevels.size(); ++i) {
                List<ILevel> levelList = inputListOfLevels.get(i);
                if (levelList.size() <= 0) continue;
                computedSize *= (long)levelList.size();
            }
            logger.log("computedSize=" + computedSize);
            logger.log("levelsForAllCombinations: size=" + levelsForAllCombinations.size());
            logger.log(levelsForAllCombinations.toString());
        }
        long startTime = System.currentTimeMillis();
        int[] trackCombinations = new int[inputListOfLevels.size()];
        for (int idx = 0; idx < trackCombinations.length; ++idx) {
            trackCombinations[idx] = 0;
        }
        HashSet<IHierarchy> hierarchieLastFirst = new HashSet<IHierarchy>();
        for (IMember measure : measures) {
            for (IAggregateRule rule : measure.getAggregateRules()) {
                DMRDimension[] dims;
                if (rule.getAggregate() != AggregateTypeEnum.FIRST && rule.getAggregate() != AggregateTypeEnum.LAST) continue;
                for (DMRDimension dim : dims = DMRUtilities.getDMRDimensionsFromMFWDimensionUniqueName(rule.getDimensionRef(), (DMRCube)measure.getDimension().getCube())) {
                    hierarchieLastFirst.addAll(dim.getHierarchies());
                }
            }
        }
        List<List<ILevel>> listOfLevels = null;
        listOfLevels = this.getInfoData().getDMRQuerySummaryOptimizationLevel() > 1 ? this.constructRequiredListOfLevels(inputListOfLevels, levelsForAllCombinations, hierarchieLastFirst) : inputListOfLevels;
        List<ILevel> baseCombination = this.constructBaseCombination(inputListOfLevels);
        if (this.onlyBaseCombinationRequired(listOfLevels)) {
            this.addCombination(listofMeasures, measures, baseCombination);
            return;
        }
        boolean allDone = false;
        boolean requiredBaseCombination = true;
        long numCombinations = 0L;
        while (!allDone) {
            ++numCombinations;
            if (requiredBaseCombination) {
                if (this.getInfoData().getDMRQuerySummaryOptimizationLevel() > 1) {
                    this.addCombination(listofMeasures, measures, baseCombination);
                } else {
                    List<ILevel> levelCombination = this.buildCombination(listOfLevels, trackCombinations);
                    this.addCombination(listofMeasures, measures, levelCombination);
                }
            } else {
                List<ILevel> levelCombination = this.buildCombination(listOfLevels, trackCombinations);
                this.addCombination(listofMeasures, measures, levelCombination);
            }
            if (this.getInfoData().getDMRQuerySummaryOptimizationLevel() > 1) {
                requiredBaseCombination = false;
            }
            boolean done = false;
            block6: while (!done) {
                for (int currentPostion = trackCombinations.length - 1; currentPostion >= 0; --currentPostion) {
                    int currentValue = trackCombinations[currentPostion];
                    List<ILevel> levels = listOfLevels.get(currentPostion);
                    if (currentValue + 1 < levels.size()) {
                        int n = currentPostion;
                        int n2 = trackCombinations[n] + 1;
                        trackCombinations[n] = n2;
                        trackCombinations[currentPostion] = n2;
                        done = true;
                        continue block6;
                    }
                    trackCombinations[currentPostion] = 0;
                    if (currentPostion != 0) continue;
                    done = true;
                    allDone = true;
                    continue block6;
                }
            }
        }
        if (logger.isOn()) {
            logger.log("Num Combinations: " + numCombinations);
            logger.log("optimizeCombination: elapsedTime=" + (System.currentTimeMillis() - startTime) + "ms");
        }
    }

    private List<ILevel> buildCombination(List<List<ILevel>> listofLevels, int[] trackCombinations) {
        ArrayList<ILevel> levelCombination = new ArrayList<ILevel>();
        for (int idx = 0; idx < trackCombinations.length; ++idx) {
            int position = trackCombinations[idx];
            List<ILevel> levels = listofLevels.get(idx);
            levelCombination.add(levels.get(position));
        }
        return levelCombination;
    }

    private void addCombination(List<Map<IMember, List<ILevel>>> listofMeasures, List<IMember> measures, List<ILevel> levelCombination) {
        for (IMember measure : measures) {
            HashMap<IMember, List<ILevel>> aCombinbation = new HashMap<IMember, List<ILevel>>();
            aCombinbation.put(measure, levelCombination);
            listofMeasures.add(aCombinbation);
        }
    }

    private boolean onlyBaseCombinationRequired(List<List<ILevel>> listOfLevels) {
        for (List<ILevel> levels : listOfLevels) {
            if (levels != null && levels.size() != 0) continue;
            return true;
        }
        return false;
    }

    private List<ILevel> constructBaseCombination(List<List<ILevel>> inputListOfLevels) {
        ArrayList<ILevel> baseCombination = new ArrayList<ILevel>(inputListOfLevels.size());
        for (List<ILevel> levels : inputListOfLevels) {
            baseCombination.add(levels.get(0));
        }
        return baseCombination;
    }

    private List<List<ILevel>> constructRequiredListOfLevels(List<List<ILevel>> inputListOfLevels, List<ILevel> levelsForAllCombinations, Set<IHierarchy> hierarchieLastFirst) {
        ArrayList<List<ILevel>> requiredListOfLevels = new ArrayList<List<ILevel>>(inputListOfLevels.size());
        DMRCube cube = (DMRCube)this.getCube();
        Map<IXQEQueryNode, MDXLevelInfo> summaryInfo = cube.getAggregationLevelInfo();
        Collection<MDXLevelInfo> listOfLevelInfo = summaryInfo.values();
        for (List<ILevel> inputLevels : inputListOfLevels) {
            ArrayList<ILevel> requiredLevels = new ArrayList<ILevel>();
            for (ILevel currentLevel : inputLevels) {
                if (!this.isLevelRequired(cube, currentLevel, listOfLevelInfo, inputLevels, hierarchieLastFirst, levelsForAllCombinations)) continue;
                requiredLevels.add(currentLevel);
            }
            requiredListOfLevels.add(requiredLevels);
        }
        return requiredListOfLevels;
    }

    boolean isLevelRequired(DMRCube cube, ILevel level, Collection<MDXLevelInfo> listOfLevelInfo, List<ILevel> levels, Set<IHierarchy> hierarchieLastFirst, List<ILevel> levelsForAllCombinations) {
        IHierarchy hierarchy = level.getHierarchy();
        if (levels.size() > 1 && hierarchieLastFirst.contains(hierarchy)) {
            return false;
        }
        if (levelsForAllCombinations.contains(level)) {
            return true;
        }
        if (listOfLevelInfo.size() > 0) {
            IHierarchy wrapperHierarchy = (IHierarchy)cube.getWrapped(hierarchy);
            ILevel wrapperLevel = (ILevel)cube.getWrapped(level);
            for (MDXLevelInfo levelInfo : listOfLevelInfo) {
                boolean projected = true;
                if (!levelInfo.getHierarchyInfo().projectsHierarchy(wrapperHierarchy)) {
                    if (level.isRootLevel()) {
                        return true;
                    }
                    projected = false;
                } else {
                    List<ILevel> projLevels = levelInfo.getProjectedLevels(wrapperHierarchy);
                    if (!projLevels.contains(wrapperLevel)) {
                        projected = false;
                    }
                }
                if (!projected) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executePushdown(DMRCube cube, IMember[][] selections, AbstractResultSet resultSet, AdaptiveCubeletStorageManager storageManager) {
        List<Combination> combinations = this.getCombinationList(cube, storageManager, selections);
        ArrayList<ILevel> levelsForAllCombinations = new ArrayList<ILevel>();
        for (Combination onCom : combinations) {
            for (Selection aSelection : onCom.getSelections()) {
                levelsForAllCombinations.add(aSelection.getFirstMember().getLevel());
            }
        }
        String functionName = this.getPushdownManager().getTopPushdownFunctionName();
        boolean isFetchingCompleteTuple = (Boolean)this.getPushdownManager().getParameter(functionName, "isFetchingCompleteTuple");
        int measurePos = (Integer)this.getPushdownManager().getParameter(functionName, "measurePos");
        int queryIndex = 0;
        for (Combination aCombination : combinations) {
            ISet contexts = (ISet)this.getPushdownManager().getParameter(functionName, "contexts");
            if (contexts != null && contexts.size() != 0L) {
                contexts.size();
            }
            IHierarchy[] cubeHiers = cube.getHierarchies().toArray(new IHierarchy[cube.getHierarchies().size()]);
            IMember[][] selectionsOfTheCombination = aCombination.getSelectionAsArray(cubeHiers);
            IMember[][] unknownMemberSet = null;
            try {
                unknownMemberSet = storageManager.fetchSingleLevelCombination(measurePos, cubeHiers, selectionsOfTheCombination, resultSet);
            }
            catch (InterpreterException e) {
                throw new XQERuntimeException();
            }
            if (unknownMemberSet == null || !BlockTupleStorageUtil.hasUnknownMbrs(unknownMemberSet)) continue;
            V5QueryGroup groupQuery = this.createV5QueryGroup(aCombination, levelsForAllCombinations, queryIndex, isFetchingCompleteTuple);
            this.executeAggregatePushdown(groupQuery.getListOfMeasures());
            AdaptiveCubeletStorageManager.ParamDefinition param = this.getNewParamDefinition(cube, storageManager);
            for (V5ProviderQuery queryToPushdown : groupQuery.getQueries()) {
                queryToPushdown.setPushdownManager(this.mPushdownManager);
                V5ProviderQueryResult v5Result = queryToPushdown.execute(null);
                RSAPIQueryResult queryResult = v5Result.getRSAPIQueryResult();
                try {
                    if (queryResult == null) continue;
                    RowHandler rowHandler = new RowHandler((V5QueryOverTabularStream)queryToPushdown, resultSet, param);
                    queryResult.iterateResult(rowHandler);
                }
                finally {
                    queryResult.release();
                    v5Result = null;
                }
            }
            ++queryIndex;
            try {
                storageManager.putTupleValues(param);
            }
            catch (InterpreterException e) {
                throw new XQERuntimeException();
            }
        }
        return true;
    }

    private void executeAggregatePushdown(List<Map<IMember, List<ILevel>>> listofMeasures) {
        HashSet pushdownAggregateLevels = new HashSet();
        while (this.mPushdownManager.isAggregate()) {
            pushdownAggregateLevels.addAll((HashSet)this.mPushdownManager.getParameter("Aggregate", "AggregateLevel"));
            this.mPushdownManager.popPushdownFunction();
        }
        if (!pushdownAggregateLevels.isEmpty()) {
            Map<IMember, List<ILevel>> baseAggregateLevelListMap = listofMeasures.get(0);
            ArrayList<ILevel> pushdownAggregateLevelList = new ArrayList<ILevel>();
            for (List<ILevel> aBaseAggregateLevelList : baseAggregateLevelListMap.values()) {
                for (ILevel aLevel : aBaseAggregateLevelList) {
                    if (pushdownAggregateLevels.contains(aLevel)) {
                        pushdownAggregateLevelList.add(aLevel.getPreviousLevel());
                        continue;
                    }
                    pushdownAggregateLevelList.add(aLevel);
                }
            }
            HashMap<IMember, ArrayList<ILevel>> pushdownAggregateLevelListMap = new HashMap<IMember, ArrayList<ILevel>>();
            for (IMember measure : baseAggregateLevelListMap.keySet()) {
                pushdownAggregateLevelListMap.put(measure, pushdownAggregateLevelList);
            }
            listofMeasures.add(pushdownAggregateLevelListMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void blockedExecuteToCubeletForCombinations(DMRCube cube, IMember[][] selections, AbstractResultSet resultSet, AdaptiveCubeletStorageManager storageManager, int measurePos, IHierarchy[] cubeHiers) throws InterpreterException {
        boolean bNeedBlock = true;
        List<Combination> combinations = this.getCombinationList(cube, storageManager, selections);
        ArrayList<ILevel> levelsForAllCombinations = new ArrayList<ILevel>();
        for (Combination onCom : combinations) {
            if (onCom instanceof AggregateCombination) {
                bNeedBlock = false;
            }
            for (Selection aSelection : onCom.getSelections()) {
                levelsForAllCombinations.add(aSelection.getFirstMember().getLevel());
            }
        }
        int queryIndex = 1;
        for (Combination aCombination : combinations) {
            IMember[][] selectionsOfTheCombination = aCombination.getSelectionAsArray(cubeHiers);
            int members = 0;
            if (bNeedBlock && queryIndex == 1) {
                for (int i = 0; i < selectionsOfTheCombination.length; ++i) {
                    members += selectionsOfTheCombination[i].length;
                }
                if (members >= 5000) {
                    bNeedBlock = false;
                }
            }
            if (bNeedBlock && queryIndex == 1) {
                DMRFetchingContextKey fecthingKey = new DMRFetchingContextKey();
                IMember[][] unknownMemberSet = storageManager.fetchSingleLevelCombinationReturnKey(measurePos, cubeHiers, selectionsOfTheCombination, resultSet, fecthingKey);
                if (unknownMemberSet == null || !BlockTupleStorageUtil.hasUnknownMbrs(unknownMemberSet)) continue;
                CountDownLatch newGate = new CountDownLatch(1);
                CountDownLatch gate = storageManager.getFetching().putIfAbsent(fecthingKey, newGate);
                if (gate != null) {
                    try {
                        gate.await();
                    }
                    catch (InterruptedException e) {
                        throw new InterpreterException("fetching cells is incomplete.");
                    }
                    storageManager.fetchSingleLevelCombination(measurePos, cubeHiers, unknownMemberSet, resultSet);
                    this.executeNoBlocking(storageManager, measurePos, cubeHiers, selectionsOfTheCombination, resultSet, cube, aCombination, levelsForAllCombinations, queryIndex);
                } else {
                    try {
                        if (queryIndex == 1) {
                            this.setLowestAggregationLevel(cube, aCombination);
                        }
                        V5QueryGroup groupQuery = this.createV5QueryGroup(aCombination, levelsForAllCombinations, queryIndex, false);
                        this.executeToCubeletStorage(cube, groupQuery, unknownMemberSet, resultSet, storageManager);
                    }
                    finally {
                        newGate.countDown();
                    }
                }
                ++queryIndex;
                continue;
            }
            queryIndex = this.executeNoBlocking(storageManager, measurePos, cubeHiers, selectionsOfTheCombination, resultSet, cube, aCombination, levelsForAllCombinations, queryIndex);
        }
    }

    private int executeNoBlocking(AdaptiveCubeletStorageManager storageManager, int measurePos, IHierarchy[] cubeHiers, IMember[][] selectionsOfTheCombination, AbstractResultSet resultSet, DMRCube cube, Combination aCombination, List<ILevel> levelsForAllCombinations, int queryIndex) throws InterpreterException {
        IMember[][] unknownMemberSet = storageManager.fetchSingleLevelCombination(measurePos, cubeHiers, selectionsOfTheCombination, resultSet);
        if (unknownMemberSet != null && BlockTupleStorageUtil.hasUnknownMbrs(unknownMemberSet)) {
            if (queryIndex == 1) {
                this.setLowestAggregationLevel(cube, aCombination);
            }
            V5QueryGroup groupQuery = this.createV5QueryGroup(aCombination, levelsForAllCombinations, queryIndex, false);
            this.executeToCubeletStorage(cube, groupQuery, unknownMemberSet, resultSet, storageManager);
            ++queryIndex;
        }
        return queryIndex;
    }

    private boolean notLoadMissingCellsAfterPreLoading(DMRCube cube) {
        return cube.getLoadingTypeAfterPreLoading() == DMRQueryStrategyPreCellLoading.LoadType.NOLOAD && (cube.cellPreciselyLoaded() || this.preLoadingStrategy != null && this.preLoadingStrategy.isPreLoaded());
    }

    protected void executeToCubeletForCombinations(DMRCube cube, IMember[][] selections, AbstractResultSet resultSet, AdaptiveCubeletStorageManager storageManager, int measurePos, IHierarchy[] cubeHiers, boolean bIsFetchingCompleteTuple) throws InterpreterException {
        List<Combination> combinations = this.getCombinationList(cube, storageManager, selections);
        ArrayList<ILevel> levelsForAllCombinations = new ArrayList<ILevel>();
        for (Combination onCom : combinations) {
            for (Selection aSelection : onCom.getSelections()) {
                levelsForAllCombinations.add(aSelection.getFirstMember().getLevel());
            }
        }
        boolean noLoadAfterPreLoading = this.notLoadMissingCellsAfterPreLoading(cube);
        int queryIndex = 1;
        for (Combination aCombination : combinations) {
            boolean hasUnknown;
            IMember[][] selectionsOfTheCombination = aCombination.getSelectionAsArray(cubeHiers);
            IMember[][] unknownMemberSet = storageManager.fetchSingleLevelCombination(measurePos, cubeHiers, selectionsOfTheCombination, resultSet);
            boolean bl = hasUnknown = unknownMemberSet != null && BlockTupleStorageUtil.hasUnknownMbrs(unknownMemberSet);
            if (hasUnknown && cube.cellPreciselyLoaded()) {
                hasUnknown = this.fetchCellsFromHigherScope(measurePos, cubeHiers, selectionsOfTheCombination, resultSet, storageManager);
            }
            if (!hasUnknown || noLoadAfterPreLoading) continue;
            DMRQueryStrategyPreCellLoading.log(unknownMemberSet, this.preLoadingStrategy);
            if (queryIndex == 1) {
                this.setLowestAggregationLevel(cube, aCombination);
            }
            V5QueryGroup groupQuery = this.createV5QueryGroup(aCombination, levelsForAllCombinations, queryIndex, bIsFetchingCompleteTuple);
            this.executeToCubeletStorage(cube, groupQuery, unknownMemberSet, resultSet, storageManager);
            ++queryIndex;
        }
    }

    protected boolean fetchCellsFromHigherScope(int measurePos, IHierarchy[] cubeHiers, IMember[][] selections, AbstractResultSet resultSet, AdaptiveCubeletStorageManager storageManager) throws InterpreterException {
        IMember[] measures = selections[measurePos];
        DMRMeasure firstM = (DMRMeasure)measures[0];
        boolean hHasHigherScope = false;
        IMember[][] nonMeasureSelections = new IMember[selections.length - 1][];
        int[] basesize = new int[selections.length - 1];
        HashMap[] map = new HashMap[selections.length - 1];
        int j = 0;
        int i = 0;
        for (i = 0; i < selections.length; ++i) {
            HashMap<IMember, IMember> st;
            if (i == measurePos) continue;
            nonMeasureSelections[j] = selections[i];
            map[j] = st = new HashMap<IMember, IMember>();
            IMember[] iMemberArray = selections[i];
            int n = iMemberArray.length;
            for (int k = 0; k < n; ++k) {
                IMember mb = iMemberArray[k];
                DMRLevel level = (DMRLevel)mb.getLevel();
                IMember scopeMember = mb;
                if (!level.isRootLevel()) {
                    DMRLevel scopeLevel = V5QueryOverTabularStream.getLowestLevelFromScope(firstM, level);
                    if (scopeLevel == null) {
                        scopeLevel = (DMRLevel)level.getDimension().getLevel(0);
                    }
                    if (scopeLevel.getIndex() < level.getIndex()) {
                        hHasHigherScope = true;
                        while (scopeMember.getLevel().getIndex() > scopeLevel.getIndex()) {
                            scopeMember = scopeMember.getParent();
                        }
                    }
                }
                st.put(mb, scopeMember);
                if (basesize[j] >= ((DMRMember)scopeMember).getIndex()) continue;
                basesize[j] = ((DMRMember)scopeMember).getIndex();
            }
            ++j;
        }
        if (!hHasHigherScope) {
            return true;
        }
        for (i = 0; i < basesize.length; ++i) {
            basesize[i] = basesize[i] + 1;
        }
        for (IMember m : measures) {
            DMRMeasure dmrMeasure = (DMRMeasure)m;
            boolean bNeedConstAllocation = ((DMRCube)dmrMeasure.getDimension().getCube()).isQueryListReport();
            if (!bNeedConstAllocation) {
                AllocationRule rule = dmrMeasure.getAllocationRule();
                boolean bl = bNeedConstAllocation = rule != null && rule.equals((Object)AllocationRule.CONSTANT);
            }
            if (!bNeedConstAllocation) continue;
            TreeMap<Long, Value> feteched = new TreeMap<Long, Value>();
            if (!this.fetchHigherScopeValues(feteched, measurePos, cubeHiers, dmrMeasure, map, basesize, storageManager)) {
                return true;
            }
            ForwardMembersFetcher fetcher = new ForwardMembersFetcher(nonMeasureSelections);
            IMember[] nonMeasureMembers = fetcher.getNext();
            while (nonMeasureMembers != null) {
                IMember[] newMembers = new IMember[selections.length];
                newMembers[measurePos] = dmrMeasure;
                IMember[] scopeMembers = new IMember[nonMeasureMembers.length];
                for (int pos = 0; pos < nonMeasureMembers.length; ++pos) {
                    HashMap mp = map[pos];
                    scopeMembers[pos] = (IMember)mp.get(nonMeasureMembers[pos]);
                    if (pos >= measurePos) {
                        newMembers[pos + 1] = nonMeasureMembers[pos];
                        continue;
                    }
                    newMembers[pos] = nonMeasureMembers[pos];
                }
                long ord = this.getOrdinal(scopeMembers, basesize);
                Value v = feteched.get(ord);
                Tuple dataTuple = new Tuple(newMembers, false);
                if (v != null) {
                    resultSet.addCell(dataTuple, new Cell(v));
                }
                nonMeasureMembers = fetcher.getNext();
            }
        }
        return false;
    }

    private long getOrdinal(IMember[] scopeMembers, int[] basesize) {
        long ord = 0L;
        long baseTupleSize = 1L;
        for (int i = 0; i < scopeMembers.length; ++i) {
            int memberIdx = ((DMRMember)scopeMembers[i]).getIndex() - 1;
            ord += (long)memberIdx * baseTupleSize;
            baseTupleSize *= (long)basesize[i];
        }
        return ord;
    }

    private boolean fetchHigherScopeValues(TreeMap<Long, Value> feteched, int measurePos, IHierarchy[] cubeHiers, DMRMeasure dmrMeasure, HashMap<IMember, IMember>[] map, int[] basesize, AdaptiveCubeletStorageManager storageManager) throws InterpreterException {
        HashSet[] sel = new HashSet[map.length + 1];
        int pos = 0;
        for (pos = 0; pos < sel.length; ++pos) {
            sel[pos] = new HashSet();
            if (pos == measurePos) {
                sel[pos].add(dmrMeasure);
                continue;
            }
            int p = pos;
            if (p >= measurePos) {
                --p;
            }
            sel[pos].addAll(map[p].values());
        }
        IMember[][] selections = new IMember[sel.length][];
        for (pos = 0; pos < sel.length; ++pos) {
            selections[pos] = sel[pos].toArray(new IMember[sel[pos].size()]);
        }
        CrossJoinedSet s = BlockTupleStorageUtil.createCjsFromMemberSelections(selections);
        ResultSet rs = new ResultSet(s);
        IMember[][] unknownMemberSet = storageManager.fetchSingleLevelCombination(measurePos, cubeHiers, selections, rs);
        if (unknownMemberSet != null && BlockTupleStorageUtil.hasUnknownMbrs(unknownMemberSet)) {
            return false;
        }
        ITupleValueIterator it = rs.tupleValueIterator();
        while (it.hasNext()) {
            TupleValue tv = (TupleValue)it.next();
            Tuple tp = tv.getTuple();
            IMember[] mbs = tp.getMembers();
            IMember[] m = new IMember[mbs.length - 1];
            int j = 0;
            for (int i = 0; i < mbs.length; ++i) {
                if (i == measurePos) continue;
                m[j] = mbs[i];
                ++j;
            }
            Cell cell = tv.getCell();
            long ord = this.getOrdinal(m, basesize);
            feteched.put(ord, (Value)cell.getValue());
        }
        return true;
    }

    private void setupV5QueryGroups(CJSPreloader cjsPreloader) throws InterpreterException {
        DMRCube cube = cjsPreloader.getCube();
        IMember[][] selections = cjsPreloader.getSelection();
        AdaptiveCubeletStorageManager storageManager = cjsPreloader.getStorageManager();
        int measurePos = cjsPreloader.getMeasurePosition();
        IHierarchy[] cubeHiers = cjsPreloader.getCubeHierarchies();
        List<Combination> combinations = this.getCombinationList(cube, storageManager, selections);
        ArrayList<ILevel> levelsForAllCombinations = new ArrayList<ILevel>();
        for (Combination onCom : combinations) {
            for (Selection aSelection : onCom.getSelections()) {
                levelsForAllCombinations.add(aSelection.getFirstMember().getLevel());
            }
        }
        boolean noLoadAfterPreLoading = this.notLoadMissingCellsAfterPreLoading(cube);
        ArrayList<V5QueryGroup> listOfV5QueryGroup = new ArrayList<V5QueryGroup>();
        int queryIndex = 1;
        for (Combination aCombination : combinations) {
            IMember[][] selectionsOfTheCombination = aCombination.getSelectionAsArray(cubeHiers);
            IMember[][] unknownMemberSet = storageManager.fetchSingleLevelCombination(measurePos, cubeHiers, selectionsOfTheCombination, null);
            boolean unknownMemberSetNotNull = unknownMemberSet != null;
            boolean hasUnknownMbrs = false;
            if (unknownMemberSetNotNull) {
                hasUnknownMbrs = BlockTupleStorageUtil.hasUnknownMbrs(unknownMemberSet);
            }
            if (!unknownMemberSetNotNull || !hasUnknownMbrs || noLoadAfterPreLoading) continue;
            DMRQueryStrategyPreCellLoading.log(unknownMemberSet, this.preLoadingStrategy);
            if (queryIndex == 1) {
                this.setLowestAggregationLevel(cube, aCombination);
            }
            V5QueryGroup groupQuery = this.createV5QueryGroup(aCombination, levelsForAllCombinations, queryIndex, false);
            groupQuery.setUnknownMemberSet(unknownMemberSet);
            listOfV5QueryGroup.add(groupQuery);
            ++queryIndex;
        }
        cjsPreloader.setV5QueryGroups(listOfV5QueryGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeToCubeletForCJS(DMRCube cube, CrossJoinedSet cjs, AbstractResultSet resultSet, AdaptiveCubeletStorageManager storageManager, int measurePos, IHierarchy[] cubeHiers, boolean bIsFetchingCompleteTuple) throws InterpreterException {
        List<IMember[][]> preciseSelections = DMRQueryStrategyPreCellLoading.getPreciseSelectionsFromCJS(cjs, cube);
        if (this.preLoadingStrategy != null) {
            this.preLoadingStrategy.setLoadLowestLevel(false);
        }
        try {
            for (IMember[][] sel : preciseSelections) {
                this.executeToCubeletForCombinations(cube, sel, resultSet, storageManager, measurePos, cubeHiers, bIsFetchingCompleteTuple);
            }
        }
        finally {
            if (this.preLoadingStrategy != null) {
                this.preLoadingStrategy.setLoadLowestLevel(true);
            }
        }
    }

    protected void setLowestAggregationLevel(DMRCube cube, Combination aCombination) {
        Map<IXQEQueryNode, MDXLevelInfo> summaryInfo = cube.getAggregationLevelInfo();
        Collection<MDXLevelInfo> listOfLevelInfo = summaryInfo.values();
        MDXLevelInfo lowestAggregationLevelInfo = new MDXLevelInfo();
        MDXLevelInfo unionedAggregationLevelInfo = new MDXLevelInfo();
        for (MDXLevelInfo aLevelInfo : listOfLevelInfo) {
            unionedAggregationLevelInfo.unionProjectedHierarchies(aLevelInfo);
        }
        for (IHierarchy aHierarchy : unionedAggregationLevelInfo.getHierarchyInfo().getProjectedHierarchies()) {
            ILevel lowestLevel = unionedAggregationLevelInfo.getLowestProjectedLevel(aHierarchy);
            if (lowestLevel == null) continue;
            lowestAggregationLevelInfo.addProjectedHierarchy(lowestLevel);
        }
        aCombination.setLowestAggregationLevelInfo(lowestAggregationLevelInfo);
    }

    protected void executeToCubeletStorage(DMRCube cube, V5QueryGroup groupQuery, IMember[][] selections, AbstractResultSet resultSet, AdaptiveCubeletStorageManager storageManager) throws InterpreterException {
        V5QueryResult result = groupQuery.execute();
        AdaptiveCubeletStorageManager.ParamDefinition param = this.getNewParamDefinition(cube, storageManager);
        this.getExtraMeasures(groupQuery);
        this.iterateResults(groupQuery, resultSet, result, param);
        this.performConstantAllocationOnGroupQuery(groupQuery, selections, resultSet, param);
        this.includeAllTheParentSelections(groupQuery, selections, param);
        storageManager.putTupleValues(param);
    }

    public void getExtraMeasures(V5QueryGroup groupQuery) {
        HashSet<IMember> extraMeasures = new HashSet<IMember>();
        for (int i = 0; i < groupQuery.queryCount(); ++i) {
            V5QueryOverTabularStream query = groupQuery.getQuery(i);
            List<IMember> extra = query.getExtraMeasures();
            if (extra == null) continue;
            extraMeasures.addAll(query.getExtraMeasures());
        }
    }

    private void includeAllTheParentSelections(V5QueryGroup groupQuery, IMember[][] selections, AdaptiveCubeletStorageManager.ParamDefinition param) {
        for (int idx = 0; idx < groupQuery.getListOfMeasures().size(); ++idx) {
            ArrayList updatedSelection = new ArrayList();
            for (int idxSelection = 0; idxSelection < selections.length; ++idxSelection) {
                updatedSelection.add(new HashSet());
            }
            DMRMeasure measure = (DMRMeasure)groupQuery.getListOfMeasures().get(idx).keySet().iterator().next();
            List<ILevel> levels = groupQuery.getListOfMeasures().get(idx).get(measure);
            int levelPos = 0;
            for (int idxSelection = 0; idxSelection < selections.length; ++idxSelection) {
                IMember[] selection = selections[idxSelection];
                Set currentList = (Set)updatedSelection.get(idxSelection);
                if (selection[0].isMeasure()) {
                    currentList.add(measure);
                    continue;
                }
                ILevel levelTobeAt = levels.get(levelPos);
                ++levelPos;
                IMember[] iMemberArray = selection;
                int n = iMemberArray.length;
                for (int i = 0; i < n; ++i) {
                    IMember member;
                    IMember currentMember = member = iMemberArray[i];
                    ILevel currentLevel = currentMember.getLevel();
                    while (levelTobeAt.getIndex() < currentLevel.getIndex()) {
                        currentMember = currentMember.getParent();
                        currentLevel = currentMember.getLevel();
                    }
                    currentList.add(currentMember);
                }
            }
            IMember[][] newSelection = new IMember[updatedSelection.size()][];
            for (int idxUpdatedSelection = 0; idxUpdatedSelection < updatedSelection.size(); ++idxUpdatedSelection) {
                Set selection = (Set)updatedSelection.get(idxUpdatedSelection);
                newSelection[idxUpdatedSelection] = new IMember[selection.size()];
                Iterator it = selection.iterator();
                for (int idxMember = 0; idxMember < selection.size(); ++idxMember) {
                    newSelection[idxUpdatedSelection][idxMember] = (IMember)it.next();
                }
            }
            this.addSelectionsToCubelet(param, newSelection, new HashSet<IMember>());
        }
    }

    private void performConstantAllocationOnGroupQuery(V5QueryGroup groupQuery, IMember[][] selections, AbstractResultSet resultSet, AdaptiveCubeletStorageManager.ParamDefinition param) throws InterpreterException {
        if (groupQuery.queryCount() > 0) {
            List<DMRCompoundKeyMapping> compoundKeyMappings = groupQuery.getQuery(0).getCompoundKeyMappings();
            for (int i = 0; i < compoundKeyMappings.size(); ++i) {
                IMember[] membersFromCJS;
                DMRCompoundKeyMapping keyMapping = compoundKeyMappings.get(i);
                ILevel level = keyMapping.getLowestLevelAddedByOptimization();
                if (level == null) continue;
                int dimIndex = this.getDimToIndexMap().get(level.getDimension());
                if (selections[dimIndex].length == 1 && selections[dimIndex][0] == level.getHierarchy().getDefaultMember()) {
                    if (((Level)level).getMembersOrderedMap().size() <= 0) continue;
                    selections[dimIndex] = (IMember[])((Level)level).getMembersOrderedMap().toArray(new IMember[0]);
                    continue;
                }
                ArrayList<IMember> descendants = new ArrayList<IMember>();
                for (IMember aMember : membersFromCJS = selections[this.getDimToIndexMap().get(level.getDimension())]) {
                    descendants.addAll(((IMemberCubics)aMember).getDescendants(level));
                }
                selections[this.getDimToIndexMap().get((Object)level.getDimension()).intValue()] = descendants.toArray(new IMember[0]);
            }
            this.performConstantAllocationRule(groupQuery.getListOfMeasures(), param, selections, resultSet);
        }
    }

    public AdaptiveCubeletStorageManager.ParamDefinition getNewParamDefinition(DMRCube cube, AdaptiveCubeletStorageManager storageManager) {
        AdaptiveCubeletStorageManager adaptiveCubeletStorageManager = storageManager;
        adaptiveCubeletStorageManager.getClass();
        AdaptiveCubeletStorageManager.ParamDefinition param = new AdaptiveCubeletStorageManager.ParamDefinition(adaptiveCubeletStorageManager, storageManager);
        List<IHierarchy> cubeHiers = cube.getHierarchies(false);
        for (IHierarchy hier : cubeHiers) {
            if (hier.getDimension().isMeasuresDimension()) continue;
            param.addNonMeasureHierarchy(hier);
        }
        param.initialLevelIndex();
        return param;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterateResults(V5QueryGroup groupQuery, AbstractResultSet resultSet, V5QueryResult result, AdaptiveCubeletStorageManager.ParamDefinition param) {
        V5ProviderQueryResult v5Result;
        try {
            for (int i = 0; i < groupQuery.queryCount(); ++i) {
                V5QueryOverTabularStream query = groupQuery.getQuery(i);
                v5Result = groupQuery.getV5QueryResult(query.getName());
                RSAPIQueryResult queryResult = v5Result.getRSAPIQueryResult();
                if (queryResult != null) {
                    RowHandler rowHandler = new RowHandler(query, resultSet, param);
                    queryResult.iterateResult(rowHandler);
                    continue;
                }
                XQEDebugLog.out.println("No result for the query " + query.getName());
            }
        }
        finally {
            result.release();
            v5Result = null;
        }
    }

    private V5QueryGroup createV5QueryGroup(Combination combination, List<ILevel> levelsForAllCombinations, int queryIndex, boolean bIsFetchingCompleteTuple) {
        V5QueryGroup groupQuery = new V5QueryGroup();
        V5QueryOverTabularStream query = null;
        query = combination instanceof AggregateCombination ? this.combinationAggregateToV5Query(groupQuery, queryIndex, (AggregateCombination)combination, levelsForAllCombinations) : this.combinationToV5Query(groupQuery, combination, levelsForAllCombinations);
        query.setXmdxNodeId(this.getInfoData().getXmdxSelectId());
        if (bIsFetchingCompleteTuple) {
            query.setIgnoreSlicerWhenFetchingCompleteTuple();
        }
        groupQuery.addQuery(query);
        return groupQuery;
    }

    private List<Combination> getCombinationList(ICube cube, AdaptiveCubeletStorageManager storageManager, IMember[][] selections) {
        List<IDimension> dimensions = cube.getDimensions();
        CrossJoinedSetDecomposer cb = null;
        cb = new CrossJoinedSetDecomposer(dimensions);
        for (int i = 0; i < dimensions.size(); ++i) {
            IDimension dimension = dimensions.get(i);
            cb.addToSelectionsByDimension(dimension, selections[i], i);
        }
        cb.buildDimIndexToMemberGroups();
        cb.setOneMeasurePerSubquery(this.getInfoData().isOneMeasurePerSubquery());
        List<Combination> combinations = cb.getCombinationObjects();
        if (this.needLoadExtraMeasuresForReport() && storageManager != null) {
            cb.addMeasuresForReport(storageManager, combinations);
        }
        return combinations;
    }

    private void addSelectionsToCubelet(AdaptiveCubeletStorageManager.ParamDefinition param, IMember[][] selections, HashSet<IMember> extraMeasures) {
        IMember[] measureSelection = null;
        IMember[][] nonMeasureSelections = new IMember[selections.length - 1][];
        IMember[] firstTuple = new IMember[selections.length];
        int measurePos = -1;
        int j = 0;
        int i = 0;
        for (i = 0; i < selections.length; ++i) {
            if (selections[i][0].isMeasure()) {
                measureSelection = selections[i];
                measurePos = i;
                continue;
            }
            firstTuple[i] = selections[i][0];
            nonMeasureSelections[j] = selections[i];
            ++j;
        }
        ArrayList<IMember> allMeasures = new ArrayList<IMember>();
        for (i = 0; i < measureSelection.length; ++i) {
            allMeasures.add(measureSelection[i]);
        }
        allMeasures.addAll(extraMeasures);
        Iterator iterator = allMeasures.iterator();
        while (iterator.hasNext()) {
            IMember measure;
            firstTuple[measurePos] = measure = (IMember)iterator.next();
            param.updateValueMapNoValue(firstTuple, nonMeasureSelections, true);
        }
    }

    private boolean needConstAllocationForRealDMRMeasureAndRelLevel(DMRMeasure measure, List<ILevel> levels) {
        if (measure.useNativeV5Name()) {
            return false;
        }
        for (ILevel lvl : levels) {
            if (!(lvl instanceof DMRLevel)) {
                return false;
            }
            DMRLevel dmrLevel = (DMRLevel)lvl;
            if (!dmrLevel.isV5LevelWrapper() || dmrLevel.getIndex() <= 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void performConstantAllocationRule(List<Map<IMember, List<ILevel>>> xListofMeasures, AdaptiveCubeletStorageManager.ParamDefinition param, IMember[][] selections, AbstractResultSet resultSet) throws InterpreterException {
        IMember[] measureSelection = null;
        IMember[][] nonMeasureSelections = new IMember[selections.length - 1][];
        int measurePos = -1;
        int j = 0;
        int i = 0;
        for (i = 0; i < selections.length; ++i) {
            if (selections[i][0].isMeasure()) {
                measureSelection = selections[i];
                measurePos = i;
                continue;
            }
            nonMeasureSelections[j] = selections[i];
            ++j;
        }
        HashMap<AdaptiveCubeletStorageManager.StoreKey, Object[]> localIndexedValueMap = new HashMap<AdaptiveCubeletStorageManager.StoreKey, Object[]>();
        HashMap<Pair, ILevel> lowestLevelCache = new HashMap<Pair, ILevel>();
        Pair key = new Pair(null, null);
        for (i = 0; i < xListofMeasures.size(); ++i) {
            AllocationRule rule;
            DMRMeasure measure = (DMRMeasure)xListofMeasures.get(i).keySet().iterator().next();
            List<ILevel> levels = xListofMeasures.get(i).get(measure);
            if (!((DMRCube)measure.getDimension().getCube()).isQueryListReport() && ((rule = measure.getAllocationRule()) == null || rule.compareTo(AllocationRule.DEFAULT) == 0) && !this.needConstAllocationForRealDMRMeasureAndRelLevel(measure, levels)) continue;
            int[] scopeDistance = new int[levels.size()];
            boolean bNeedConstAlloc = false;
            for (j = 0; j < levels.size(); ++j) {
                int d;
                ILevel lvl = levels.get(j);
                key.setFirst(measure);
                IDimension dimension = lvl.getDimension();
                key.setSecond(dimension);
                ILevel scopeLevel = (ILevel)lowestLevelCache.get(key);
                if (scopeLevel == null) {
                    scopeLevel = V5QueryOverTabularStream.getLowestLevelFromScope(measure, lvl);
                    if (scopeLevel == null) {
                        scopeLevel = dimension.getLevel(0);
                    }
                    Pair storeKey = new Pair(measure, dimension);
                    lowestLevelCache.put(storeKey, scopeLevel);
                }
                if ((d = lvl.getIndex() - scopeLevel.getIndex()) > 0) {
                    bNeedConstAlloc = true;
                } else if (d < 0) {
                    d = 0;
                }
                scopeDistance[j] = d;
            }
            if (!bNeedConstAlloc) continue;
            Object[] fetchedValues = null;
            IMember[] aScopeMembers = new IMember[nonMeasureSelections.length + 1];
            IMember[] dummyMembers = new IMember[aScopeMembers.length - 1];
            for (j = 0; j < nonMeasureSelections.length; ++j) {
                IMember member = nonMeasureSelections[j][0];
                ILevel lvl = member.getLevel();
                int idx = levels.indexOf(lvl);
                if (idx == -1) {
                    while (!levels.contains(lvl) && member.getParent() != null) {
                        member = member.getParent();
                        lvl = member.getLevel();
                    }
                    idx = levels.indexOf(lvl);
                    if (idx == -1) {
                        bNeedConstAlloc = false;
                        break;
                    }
                }
                for (int dd = 0; dd < scopeDistance[idx]; ++dd) {
                    member = member.getParent();
                }
                aScopeMembers[j] = member;
            }
            if (!bNeedConstAlloc) continue;
            aScopeMembers[aScopeMembers.length - 1] = measure;
            AdaptiveCubeletStorageManager.StoreKey theKey = param.skipMeasure(aScopeMembers, dummyMembers);
            fetchedValues = param.getFetchedValues().get(theKey);
            if (fetchedValues == null) continue;
            int[] indexPosition = new int[nonMeasureSelections.length];
            IMember[][] nonMeasureSelectionsThisLevels = new IMember[nonMeasureSelections.length][];
            for (j = 0; j < nonMeasureSelections.length; ++j) {
                IMember[] sel = nonMeasureSelections[j];
                ArrayList<IMember> newSel = new ArrayList<IMember>();
                ILevel lvl = sel[0].getLevel();
                int idx = levels.indexOf(lvl);
                if (idx != -1) {
                    if (scopeDistance[idx] == 0) {
                        nonMeasureSelectionsThisLevels[j] = this.getFetchedMembers(fetchedValues, j);
                        if (nonMeasureSelectionsThisLevels[j] != null) continue;
                        bNeedConstAlloc = false;
                        break;
                    }
                    for (IMember iMember : sel) {
                        if (!this.scopeMemberExistsInFetchedValues(fetchedValues, j, iMember, scopeDistance[idx])) continue;
                        newSel.add(iMember);
                    }
                } else {
                    IMember member2 = sel[0];
                    int distance = 0;
                    while (!levels.contains(lvl) && member2.getParent() != null) {
                        ++distance;
                        member2 = member2.getParent();
                        lvl = member2.getLevel();
                    }
                    idx = levels.indexOf(lvl);
                    if (idx == -1) {
                        bNeedConstAlloc = false;
                        break;
                    }
                    if (scopeDistance[idx] == 0) {
                        nonMeasureSelectionsThisLevels[j] = this.getFetchedMembers(fetchedValues, j);
                        if (nonMeasureSelectionsThisLevels[j] != null) continue;
                        bNeedConstAlloc = false;
                        break;
                    }
                    HashSet<Integer> uniqueMembers = new HashSet<Integer>();
                    IMember[] iMemberArray = sel;
                    int n = iMemberArray.length;
                    for (int k = 0; k < n; ++k) {
                        IMember mb;
                        member2 = mb = iMemberArray[k];
                        for (int d = 0; d < distance; ++d) {
                            member2 = member2.getParent();
                        }
                        Integer memberId = XQEIntegerPool.getInteger(((IDMRMember)member2).getIndex());
                        if (uniqueMembers.contains(memberId)) continue;
                        uniqueMembers.add(memberId);
                        if (!this.scopeMemberExistsInFetchedValues(fetchedValues, j, member2, scopeDistance[idx])) continue;
                        newSel.add(member2);
                    }
                }
                if (newSel.isEmpty()) {
                    bNeedConstAlloc = false;
                    break;
                }
                nonMeasureSelectionsThisLevels[j] = newSel.toArray(new IMember[newSel.size()]);
                indexPosition[j] = idx;
            }
            if (!bNeedConstAlloc) continue;
            this.createLocalMemberIndexMap(theKey, localIndexedValueMap, fetchedValues);
            ForwardMembersFetcher fetcher = new ForwardMembersFetcher(nonMeasureSelectionsThisLevels);
            IMember[] nonMeasureMembers = fetcher.getNext();
            while (nonMeasureMembers != null) {
                IMember[] scopeMembers = new IMember[selections.length];
                IMember[] newMembers = new IMember[selections.length];
                j = 0;
                for (int idxMember = 0; idxMember < nonMeasureMembers.length; ++idxMember) {
                    void var30_45;
                    if (idxMember == measurePos) {
                        newMembers[j] = measure;
                        scopeMembers[j] = measure;
                        ++j;
                    }
                    newMembers[j] = nonMeasureMembers[idxMember];
                    int theScopeDistance = scopeDistance[indexPosition[idxMember]];
                    IMember parentMember = newMembers[j];
                    boolean bl = false;
                    while (var30_45 < theScopeDistance) {
                        parentMember = parentMember.getParent();
                        ++var30_45;
                    }
                    scopeMembers[j] = parentMember;
                    ++j;
                }
                Tuple dataTuple = new Tuple(newMembers, false);
                Value value = this.getValue(param, scopeMembers, localIndexedValueMap);
                if (value != null) {
                    FormatId formatId = DMRUtilities.resolveFormatIdForMeasure(measure, value);
                    value.setFormatId(formatId);
                    if (i < measureSelection.length && resultSet != null) {
                        resultSet.addCell(dataTuple, new Cell(value));
                    }
                    param.updateValueMap(new TupleValue(dataTuple, new Cell(value)), Boolean.FALSE);
                }
                nonMeasureMembers = fetcher.getNext();
            }
        }
    }

    private IMember[] getFetchedMembers(Object[] values, int pos) {
        ArrayList[] members = (ArrayList[])values[0];
        if (!members[pos].isEmpty()) {
            return members[pos].toArray(new IMember[members[pos].size()]);
        }
        return null;
    }

    private boolean scopeMemberExistsInFetchedValues(Object[] values, int pos, IMember member, int distance) {
        IMember scopeMember = member;
        for (int i = 0; i < distance; ++i) {
            scopeMember = scopeMember.getParent();
        }
        Integer idxObj = XQEIntegerPool.getInteger(((IDMRMember)scopeMember).getIndex());
        HashSet[] st = (HashSet[])values[2];
        return st[pos].contains(idxObj);
    }

    private void createLocalMemberIndexMap(AdaptiveCubeletStorageManager.StoreKey theKey, HashMap<AdaptiveCubeletStorageManager.StoreKey, Object[]> r, Object[] values) {
        if (r.containsKey(theKey)) {
            return;
        }
        ArrayList[] st = (ArrayList[])values[0];
        int len = st.length;
        HashMap[] localIdxMap = new HashMap[len];
        HashMap<Integer, Value> indexedValues = new HashMap<Integer, Value>();
        Object[] data = new Object[]{localIdxMap, indexedValues};
        r.put(theKey, data);
        for (int i = 0; i < len; ++i) {
            localIdxMap[i] = new HashMap();
            int j = 0;
            for (IMember m : st[i]) {
                localIdxMap[i].put(XQEIntegerPool.getInteger(((IDMRMember)m).getIndex()), XQEIntegerPool.getInteger(j));
                ++j;
            }
        }
        for (TupleValue v : (ArrayList)values[1]) {
            Integer idx = this.getLocalIndex(v.getTuple().getMembers(), localIdxMap);
            indexedValues.put(idx, (Value)v.getCell().getValue());
        }
    }

    protected Integer getLocalIndex(IMember[] members, HashMap<Integer, Integer>[] localIdxMap) {
        int ord = 0;
        int baseTupleSize = 1;
        for (int i = 0; i < members.length; ++i) {
            Integer idx = XQEIntegerPool.getInteger(((IDMRMember)members[i]).getIndex());
            if (!localIdxMap[i].containsKey(idx)) {
                return -1;
            }
            Integer memberIdx = localIdxMap[i].get(idx);
            ord += memberIdx * baseTupleSize;
            baseTupleSize *= localIdxMap[i].size();
        }
        return XQEIntegerPool.getInteger(ord);
    }

    protected Value getValue(AdaptiveCubeletStorageManager.ParamDefinition param, IMember[] scopeMembers, HashMap<AdaptiveCubeletStorageManager.StoreKey, Object[]> localIndexedValueMap) {
        IMember[] newMembers = new IMember[scopeMembers.length - 1];
        AdaptiveCubeletStorageManager.StoreKey key = param.skipMeasure(scopeMembers, newMembers);
        if (!localIndexedValueMap.containsKey(key)) {
            return null;
        }
        Object[] s = localIndexedValueMap.get(key);
        HashMap[] localIdxMap = (HashMap[])s[0];
        HashMap indexedValues = (HashMap)s[1];
        Integer idx = this.getLocalIndex(newMembers, localIdxMap);
        if (idx == -1) {
            return null;
        }
        if (indexedValues.containsKey(idx)) {
            return (Value)indexedValues.get(idx);
        }
        return null;
    }

    @Override
    public IPushdownAdapter getPushdownAdapter() {
        return new DMRPushdownAdapter();
    }

    private final class ForwardMembersFetcher {
        private IMember[][] membersToFetch;
        private int[] currentPos;
        private IMember[] returnMembers;

        private ForwardMembersFetcher(IMember[][] membersPerDimension) {
            this.membersToFetch = membersPerDimension;
            this.currentPos = new int[membersPerDimension.length];
            Arrays.fill(this.currentPos, -1);
            this.returnMembers = new IMember[membersPerDimension.length];
        }

        private IMember[] getNext() {
            if (this.currentPos[0] == -1) {
                Arrays.fill(this.currentPos, 0);
                for (int i = 0; i < this.currentPos.length; ++i) {
                    this.returnMembers[i] = this.membersToFetch[i][0];
                }
                return this.returnMembers;
            }
            boolean b = this.moveNext();
            if (!b) {
                return null;
            }
            return this.returnMembers;
        }

        private boolean moveNext() {
            int i;
            boolean b = false;
            for (i = this.currentPos.length - 1; i >= 0; --i) {
                if (this.currentPos[i] >= this.membersToFetch[i].length - 1) continue;
                this.currentPos[i] = this.currentPos[i] + 1;
                b = true;
                break;
            }
            if (!b) {
                return false;
            }
            if (i < this.currentPos.length - 1) {
                for (int j = i + 1; j < this.currentPos.length; ++j) {
                    this.currentPos[j] = 0;
                }
            }
            for (int u = i; u < this.currentPos.length; ++u) {
                this.returnMembers[u] = this.membersToFetch[u][this.currentPos[u]];
            }
            return true;
        }
    }

    private final class RowHandler
    implements RSAPIRowCallback {
        V5QueryOverTabularStream query;
        ArrayList<Value> outputRow = new ArrayList();
        AbstractResultSet result = null;
        protected AdaptiveCubeletStorageManager.ParamDefinition cubeletParam = null;
        protected HashMap<Integer, HashMap<Integer, IMember>> existMembers = new HashMap();

        private RowHandler(V5QueryOverTabularStream aQuery, AbstractResultSet resultSet, AdaptiveCubeletStorageManager.ParamDefinition param) {
            this.query = aQuery;
            this.result = resultSet;
            this.cubeletParam = param;
            QueryContext queryContext = DMRQueryStrategy.this.getInfoData();
            boolean isInteractive = false;
            if (queryContext != null) {
                isInteractive = queryContext.isInteractive();
            }
            long maxCellCount = 0L;
            XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            if (configuration != null) {
                if (isInteractive) {
                    maxCellCount = configuration.getIntegerProperty("qsMaxCrossjoinInteractiveOrderOfMagnitude", 5).intValue();
                }
                if (maxCellCount > 0L) {
                    maxCellCount = (long)Math.pow(10.0, maxCellCount);
                }
            }
            if (this.result != null && maxCellCount > 0L && (long)this.result.cellCount() > maxCellCount) {
                QueryContext qc = DMRQueryStrategy.this.getInfoData();
                ResourceMonitor.checkMaxSetSize((long)this.result.cellCount(), qc, XQEMessageKeys.MDX_MaxResultSize);
            }
        }

        @Override
        public boolean reRun() {
            return false;
        }

        @Override
        public boolean needReIterateRows() {
            return false;
        }

        private int populateTuple(List<DMRCompoundKeyMapping> compoundKeyMappings, List<Value> theOutputRow, IMember[] outputTuple) {
            this.existMembers.clear();
            int memberInMapping = 1;
            for (int j = 0; j < compoundKeyMappings.size(); ++j) {
                DMRCompoundKeyMapping mapping = compoundKeyMappings.get(j);
                IMember member = mapping.getMemberForRowResult(theOutputRow, false);
                IDimension dim = null;
                if (member != null) {
                    dim = member.getDimension();
                    outputTuple[((Integer)((DMRQueryStrategy)DMRQueryStrategy.this).dimToIndex.get((Object)dim)).intValue()] = member;
                    continue;
                }
                memberInMapping = 0;
                member = mapping.getMemberForRowResult(theOutputRow, true);
                if (member == null) {
                    return -1;
                }
                dim = member.getDimension();
                Integer pos = (Integer)DMRQueryStrategy.this.dimToIndex.get(dim);
                HashMap<Integer, IMember> levelIndexToMember = new HashMap<Integer, IMember>();
                this.existMembers.put(pos, levelIndexToMember);
                if (outputTuple[pos] == null) {
                    outputTuple[pos.intValue()] = member;
                }
                while (member != null) {
                    levelIndexToMember.put(member.getLevel().getIndex(), member);
                    member = member.getParent();
                }
            }
            return memberInMapping;
        }

        @Override
        public void consumeRow(RSAPIRow row, RSAPIColumn[] columns, FormatId[] formatIDs) {
            IMember[] outputTuple = this.query.getOutputTuple();
            int numColumns = columns.length;
            this.outputRow.clear();
            this.outputRow.ensureCapacity(numColumns);
            for (int k = 0; k < numColumns; ++k) {
                Value aValue = (Value)row.getColumn(k);
                if (aValue == null || aValue.isNull()) {
                    aValue = null;
                } else if ((aValue.getFormatId() == FormatId.INVALID_FORMAT_FID || aValue.getFormatId() == FormatId.EMPTY_FORMAT_FID) && formatIDs[k] != FormatId.INVALID_FORMAT_FID) {
                    aValue.setFormatId(formatIDs[k]);
                }
                this.outputRow.add(aValue);
            }
            List<Map<IMember, List<ILevel>>> measuresByLevels = this.query.getMeasuresByLevels();
            List<DMRCompoundKeyMapping> compoundKeyMappings = this.query.getCompoundKeyMappings();
            int state = this.populateTuple(compoundKeyMappings, this.outputRow, outputTuple);
            if (state == -1) {
                return;
            }
            int outputRowSize = this.outputRow.size();
            boolean isRequiredAggregation = false;
            Object currentMeasure = null;
            for (int k = 0; k < measuresByLevels.size(); ++k) {
                IMember measure = measuresByLevels.get(k).keySet().iterator().next();
                isRequiredAggregation = measure != currentMeasure;
                int currentMeasureOffset = this.query.getMeasuresOffset() + k;
                IMember[] adjustedOutputTuple = new IMember[outputTuple.length];
                List<ILevel> levelInfo = measuresByLevels.get(k).get(measure);
                boolean bAdjusted = true;
                int pos = 0;
                for (int idx = 0; idx < outputTuple.length; ++idx) {
                    IMember member = outputTuple[idx];
                    if (member == null || member.isMeasure()) continue;
                    ILevel levelTobeAt = levelInfo.get(pos);
                    if (state == 0 && this.existMembers.containsKey(idx)) {
                        HashMap<Integer, IMember> levelToMember = this.existMembers.get(idx);
                        if (!levelToMember.containsKey(levelTobeAt.getIndex())) {
                            bAdjusted = false;
                            break;
                        }
                        adjustedOutputTuple[idx] = levelToMember.get(levelTobeAt.getIndex());
                    } else {
                        ILevel currentLevel = member.getLevel();
                        while (levelTobeAt.getIndex() < currentLevel.getIndex()) {
                            member = member.getParent();
                            currentLevel = member.getLevel();
                        }
                        adjustedOutputTuple[idx] = member;
                    }
                    ++pos;
                }
                if (!bAdjusted) continue;
                adjustedOutputTuple[((Integer)((DMRQueryStrategy)DMRQueryStrategy.this).dimToIndex.get((Object)measure.getDimension())).intValue()] = measure;
                if (currentMeasureOffset >= outputRowSize) {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, " Error Index in OutputRow=" + currentMeasureOffset + " of row" + this.outputRow);
                }
                TupleValue tupleValue = this.createDataTuple(adjustedOutputTuple, measure, currentMeasureOffset);
                if (this.query.getExtraMeasures() != null && this.query.getExtraMeasures().contains(measure) || tupleValue == null || !isRequiredAggregation || this.result == null) continue;
                this.result.addCell(tupleValue.getTuple(), tupleValue.getCell());
            }
        }

        private TupleValue createDataTuple(IMember[] outputTuple, IMember measure, int currentMeasureOffset) {
            TupleValue tupleValue = null;
            try {
                Value measureValue = this.outputRow.get(currentMeasureOffset);
                if (measureValue == null || measureValue.isNull()) {
                    return null;
                }
                measureValue = (Value)measureValue.copy();
                Tuple dataTuple = new Tuple((IMember[])outputTuple.clone(), false);
                if (measureValue != null) {
                    FormatId formatId = DMRUtilities.resolveFormatIdForMeasure(measure, measureValue);
                    measureValue.setFormatId(formatId);
                    tupleValue = new TupleValue(dataTuple, new Cell(measureValue));
                    if (this.cubeletParam != null) {
                        this.cubeletParam.updateValueMap(tupleValue, Boolean.FALSE);
                    }
                }
            }
            catch (Exception e) {
                XQEDebugLog.out.println(" DataProvider processing output gave up on " + this.outputRow.toString() + " at " + currentMeasureOffset + " exception = " + e);
            }
            return tupleValue;
        }
    }
}

