/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.ICatalog;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.rsapi.RSAPIColumn;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.olap.XRelationalCrosstab;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRDimension;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMeasure;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRProperty;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.RelationalCrosstabRowHandler;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.rsapi.RSAPIQueryResult;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.rsapi.RSAPIRowCallback;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.CubeContext;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.OrdinalValue;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.ArrayOrdinalValueStorage;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import com.cognos.xqe.util.pool.XQELongPool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class RelationalCrosstabCube
extends DMRCube {
    public static final int DIRECT_STORAGE = 0;
    public static final int INMEMORY_STORAGE = 1;
    private int useStorage = 1;
    private List<TupleValue> allCells = null;
    private HashMap<Long, CellValueStorage> sectionToOrdinalToValue = null;
    private int measureDimensionIndex = -1;
    private HashMap<Integer, Integer> measureIndexRefined = null;
    private int[] dimMemberSize = null;
    private IMember[] sortedMembers = null;
    private boolean bLoaded = false;

    public RelationalCrosstabCube(ICatalog theCatalog, ICube theModelCube, CubeContext cContext) throws ProviderException {
        super(theCatalog, theModelCube, cContext);
        if (theModelCube != null && ((CubeWrapper)theModelCube).getDirectReturnCellValues()) {
            this.useStorage = 0;
            this.allCells = new ArrayList<TupleValue>();
        }
        if (this.useStorage == 1) {
            this.sectionToOrdinalToValue = new HashMap();
        }
    }

    public void setLoaded() {
        this.bLoaded = true;
    }

    @Override
    public void loadFromTabularStream(XMdxLocal xmdxlocal) {
        if (this.bLoaded) {
            return;
        }
        this.bLoaded = true;
        XRelationalCrosstab xNode = (XRelationalCrosstab)xmdxlocal.getParent();
        ArrayList<IMember> measures = new ArrayList<IMember>();
        ArrayList<Level> lowestLevelsInDimensions = new ArrayList<Level>();
        this.initializeCubeForLoading(lowestLevelsInDimensions, measures);
        RelationalCrosstabRowHandler callback = new RelationalCrosstabRowHandler(xmdxlocal, this, lowestLevelsInDimensions, measures, null);
        RelationalCrosstabCube.loadFromTabularQuery((RSAPIDataset)xNode.getChild(1), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFromTabularQuery(RSAPIDataset tab, RSAPIRowCallback callback) {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        MultiRequestContext originalMultiReqCtx = execEnv.getMultiRequestContext();
        RequestEnvironment newReqEnv = ((RequestEnvironment)execEnv.getRequestEnvironment()).duplicate();
        ExecutionEnvironment newExecEnv = (ExecutionEnvironment)newReqEnv.getExecutionEnvironment();
        execEnv.copyCollationTo(newExecEnv);
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(newExecEnv);
        try {
            originalMultiReqCtx.incrementRefCount();
            try {
                RSAPIQueryResult tabularResult = new RSAPIQueryResult(tab, newExecEnv);
                try {
                    tabularResult.iterateResult(callback);
                }
                finally {
                    tabularResult.release();
                }
            }
            finally {
                originalMultiReqCtx.decrementRefCount();
            }
        }
        finally {
            executionEnvironmentContext.exit();
        }
    }

    public void initializeCubeForLoading(List<Level> lowestLevelsInDimensions, List<IMember> measures) {
        List<IDimension> dimensions = this.getDimensions();
        int i = 0;
        for (i = 0; i < dimensions.size(); ++i) {
            IDimension dimension = dimensions.get(i);
            IHierarchy defaultHierarchy = dimension.getDefaultHierarchy();
            if (dimension.isMeasuresDimension()) {
                measures.addAll(defaultHierarchy.getLevel(0).getMembers());
                lowestLevelsInDimensions.add(null);
                this.measureDimensionIndex = i;
                this.measureIndexRefined = new HashMap();
                for (int idx = 0; idx < measures.size(); ++idx) {
                    int measureIdx = ((DMRMeasure)measures.get(idx)).getIndex();
                    this.measureIndexRefined.put(XQEIntegerPool.getInteger(measureIdx), XQEIntegerPool.getInteger(idx));
                }
                continue;
            }
            int levelCount = defaultHierarchy.getLevelCount();
            lowestLevelsInDimensions.add((DMRLevel)defaultHierarchy.getLevel(levelCount - 1));
        }
    }

    public List<TupleValue> getAllCells() {
        return this.allCells;
    }

    public int getStorageType() {
        return this.useStorage;
    }

    protected int getMeasureDimensionIndex() {
        return this.measureDimensionIndex;
    }

    protected void getSectionTupleOrdinals(IMember[] members, long[] ords) {
        long baseSectionSize = 1L;
        long baseTupleSize = 1L;
        for (int i = 0; i < members.length; ++i) {
            DMRDimension dim = (DMRDimension)this.dimensions.get(i);
            int levelIdx = 0;
            int dimLevels = 1;
            if (i == this.measureDimensionIndex) {
                int measureIdx = ((DMRMeasure)members[i]).getIndex();
                levelIdx = this.measureIndexRefined.get(XQEIntegerPool.getInteger(measureIdx));
                dimLevels = this.measureIndexRefined.size();
            } else {
                levelIdx = members[i].getLevel().getIndex();
                dimLevels = dim.getLevelCount();
            }
            ords[0] = ords[0] + (long)levelIdx * baseSectionSize;
            baseSectionSize *= (long)dimLevels;
            if (i == this.measureDimensionIndex || this.dimMemberSize == null) continue;
            int memberIdx = ((DMRMember)members[i]).getIndex() - 1;
            ords[1] = ords[1] + (long)memberIdx * baseTupleSize;
            baseTupleSize *= (long)this.dimMemberSize[i];
        }
    }

    public Value getValue(Tuple tup, boolean sortToCubeDimension) {
        long[] ords = new long[]{0L, 0L};
        IMember[] members = tup.getMembers();
        if (!sortToCubeDimension) {
            this.getSectionTupleOrdinals(members, ords);
        } else {
            this.sortToDimensionOrder(members);
            this.getSectionTupleOrdinals(this.sortedMembers, ords);
        }
        Long sectionId = XQELongPool.getLong(ords[0]);
        CellValueStorage storage = this.sectionToOrdinalToValue.get(sectionId);
        if (storage == null) {
            return null;
        }
        return storage.get(ords[1]);
    }

    protected void sortToDimensionOrder(IMember[] members) {
        for (IMember m : members) {
            int idx = m.getDimension().getIndex();
            this.sortedMembers[idx] = m;
        }
    }

    protected void fixStorage() {
        Collection<CellValueStorage> ss = this.sectionToOrdinalToValue.values();
        for (CellValueStorage s : ss) {
            s.fix();
        }
    }

    protected void buildDimensionMemberSize() {
        this.dimMemberSize = new int[this.dimensions.size()];
        for (int i = 0; i < this.dimensions.size(); ++i) {
            DMRDimension dim = (DMRDimension)this.dimensions.get(i);
            if (i == this.measureDimensionIndex) continue;
            this.dimMemberSize[i] = dim.getMembers().length;
        }
    }

    protected boolean tupleExist(IMember[] members) {
        long[] ords = new long[]{0L, 0L};
        this.getSectionTupleOrdinals(members, ords);
        Long sectionId = XQELongPool.getLong(ords[0]);
        Long tupleId = XQELongPool.getLong(ords[1]);
        if (!this.sectionToOrdinalToValue.containsKey(sectionId)) {
            return false;
        }
        CellValueStorage storage = this.sectionToOrdinalToValue.get(sectionId);
        return storage.seenTuples.contains(tupleId);
    }

    protected void addValueToCellMap(IMember[] members, Value nv, boolean bcheck) {
        long[] ords = new long[]{0L, 0L};
        this.getSectionTupleOrdinals(members, ords);
        Long sectionId = XQELongPool.getLong(ords[0]);
        CellValueStorage storage = null;
        if (this.sectionToOrdinalToValue.containsKey(sectionId)) {
            storage = this.sectionToOrdinalToValue.get(sectionId);
        } else {
            storage = new CellValueStorage(bcheck);
            this.sectionToOrdinalToValue.put(sectionId, storage);
        }
        storage.addSeen(ords[1]);
        storage.put(new OrdinalValue(ords[1], nv));
    }

    protected void createSortedMembers() {
        this.sortedMembers = new IMember[this.dimensions.size()];
    }

    public void adjustRSAPIDataItemDataTypes(RSAPIDataset rootRSAPIDataset) {
        RSAPIEdge[] edges;
        if (rootRSAPIDataset == null) {
            return;
        }
        for (RSAPIEdge edge : edges = rootRSAPIDataset.getEdges()) {
            RSAPIEdgeRowset[] rowSets;
            for (RSAPIEdgeRowset rowSet : rowSets = edge.getRowsets()) {
                RSAPIColumn[] columns;
                RSAPIDataItem[] dataItems = rowSet.getDataItems();
                if (dataItems == null) {
                    return;
                }
                ArrayList<RSAPIDataItem> adjustedDIs = new ArrayList<RSAPIDataItem>();
                for (RSAPIDataItem dataItem : dataItems) {
                    IDataType propDT;
                    DMRProperty prop;
                    String propName;
                    IDataType dt = dataItem.getPropertyDataType();
                    if (dt != null || (propName = dataItem.getPropertyName()) == null || (prop = this.getLevelProperty(propName)) == null || (propDT = prop.getDataType()) == null) continue;
                    dataItem.setPropertyDataType(propDT);
                    adjustedDIs.add(dataItem);
                }
                if (adjustedDIs.isEmpty()) continue;
                for (RSAPIColumn c : columns = rowSet.getColumns()) {
                    RSAPIDataItem refDI = c.getBaseRefDataItem();
                    if (!adjustedDIs.contains(refDI)) continue;
                    c.setPropertyDataTypeAndName(refDI.getPropertyDataType(), refDI.getPropertyName());
                }
            }
        }
    }

    protected DMRProperty getLevelProperty(String propertyUniqueName) {
        try {
            String[] parts = UniqueNameParser.parse(propertyUniqueName);
            if (parts.length != 4) {
                return null;
            }
            IDimension dimension = this.getDimension(parts[0]);
            if (dimension == null) {
                return null;
            }
            IHierarchy hierarchy = dimension.getHierarchy(parts[1]);
            if (hierarchy == null) {
                return null;
            }
            ILevel level = null;
            if (dimension.isMeasuresDimension()) {
                return null;
            }
            level = hierarchy.getLevel(parts[2]);
            if (level == null) {
                return null;
            }
            return (DMRProperty)level.getMemberProperty(parts[3]);
        }
        catch (UniqueNameParserException uniqueNameParserException) {
            return null;
        }
    }

    protected final class CellValueStorage {
        protected boolean needCheckExist = false;
        protected ArrayOrdinalValueStorage cellStorage = new ArrayOrdinalValueStorage();
        protected int valueCount = 0;
        protected HashSet<Long> seenTuples = null;
        private OrdinalValue fecthedValue = null;

        protected CellValueStorage(boolean bcheck) {
            if (bcheck) {
                this.needCheckExist = true;
                this.seenTuples = new HashSet();
            }
            this.fecthedValue = new OrdinalValue(0L, null);
        }

        protected void addSeen(long tupleOrdinal) {
            if (!this.needCheckExist) {
                return;
            }
            Long tupleId = XQELongPool.getLong(tupleOrdinal);
            this.seenTuples.add(tupleId);
        }

        protected void put(OrdinalValue v) {
            this.cellStorage.put(v);
            ++this.valueCount;
        }

        protected void fix() {
            if (this.seenTuples != null) {
                this.seenTuples.clear();
            }
            this.cellStorage.fix(this.valueCount);
        }

        protected Value get(long ordinal) {
            this.fecthedValue.setOrdinal(ordinal);
            if (!this.cellStorage.get(this.fecthedValue)) {
                return null;
            }
            return (Value)this.fecthedValue.getValue();
        }
    }
}

