/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider;

import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRExternalAggregateStrategy;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.RelationalCrosstabCube;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ExternalAggregateStrategyException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.util.ArrayWrapper;
import com.cognos.xqe.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;

public class RelationalCrosstabExternalAggregateStrategy
extends DMRExternalAggregateStrategy {
    public RelationalCrosstabExternalAggregateStrategy(ICube c) {
        super(c);
    }

    public Value[] execute(InterpreterContext interpreterContext, Set[] aggSets) throws ExternalAggregateStrategyException {
        try {
            return this.execute(interpreterContext, aggSets, null);
        }
        catch (InterpreterException ie) {
            throw new ExternalAggregateStrategyException("RelationalCrosstabExternalAggregateStrategy failure", ie);
        }
    }

    public Value[] execute(InterpreterContext interpreterContext, Set[] aggSets, IHierarchy[] aggregateSetHierarchy) throws ExternalAggregateStrategyException {
        Value[] aggValues = new Value[aggSets.length];
        RelationalCrosstabCube cube = (RelationalCrosstabCube)interpreterContext.getCube();
        int type = cube.getStorageType();
        for (int i = 0; i < aggSets.length; ++i) {
            Tuple tp = this.getTupleFromSet(aggSets[i], aggregateSetHierarchy);
            Value v = null;
            if (tp != null) {
                if (type == 1) {
                    v = cube.getValue(tp, true);
                }
            } else {
                v = TextValue.ERROR_VALUE;
            }
            aggValues[i] = v;
        }
        return aggValues;
    }

    protected Tuple getTupleFromSet(Set aggSets, IHierarchy[] aggregateSetHierarchy) {
        HashMap<IHierarchy, Pair> aggregationSetByHierarchy = new HashMap<IHierarchy, Pair>();
        if (aggregateSetHierarchy != null) {
            for (IHierarchy hier : aggregateSetHierarchy) {
                aggregationSetByHierarchy.put(hier, null);
            }
        }
        HashMap<IHierarchy, HashSet> mp = new HashMap<IHierarchy, HashSet>();
        IMetadata measure = null;
        ITupleList list = aggSets.getTupleList();
        for (ITuple tp : list) {
            IMember[] members;
            if (((Tuple)tp).containsCalculation()) {
                return null;
            }
            for (IMember member : members = tp.getMembers()) {
                IHierarchy hier = member.getLevel().getHierarchy();
                HashSet memberSet = null;
                if (!mp.containsKey(hier)) {
                    memberSet = new HashSet();
                    mp.put(hier, memberSet);
                } else {
                    memberSet = (HashSet)mp.get(hier);
                }
                memberSet.add(member);
                if (!hier.getDimension().isMeasuresDimension()) continue;
                if (memberSet.size() > 1) {
                    return null;
                }
                if (memberSet.size() <= 0) continue;
                measure = (IMember)memberSet.iterator().next();
            }
        }
        if (measure == null) {
            return null;
        }
        HashMap rollUp = (HashMap)measure.getProperty("externalRollUpScopes");
        if (rollUp == null) {
            return null;
        }
        IMember[] scopeMembers = new IMember[mp.size()];
        ArrayList<ILevel> otherLevels = new ArrayList<ILevel>();
        int i = 0;
        int hierIndex = 0;
        for (Map.Entry e : mp.entrySet()) {
            HashSet members = (HashSet)e.getValue();
            if (aggregationSetByHierarchy.containsKey(e.getKey()) || members.size() > 1) {
                Pair pos = new Pair(hierIndex, i);
                ++hierIndex;
                Pair p = new Pair(pos, members);
                aggregationSetByHierarchy.put((IHierarchy)e.getKey(), p);
            } else {
                IMember aMember;
                scopeMembers[i] = aMember = (IMember)members.iterator().next();
                ILevel aLevel = aMember.getLevel();
                if (!aLevel.getHierarchy().getDimension().isMeasuresDimension() && aLevel.getIndex() > 0) {
                    otherLevels.add(aLevel);
                }
            }
            ++i;
        }
        for (Map.Entry e1 : aggregationSetByHierarchy.entrySet()) {
            Pair p = (Pair)e1.getValue();
            IMember rollUpMember = this.rollUpMembers((HashSet)p.getSecond());
            if (rollUpMember == null) {
                return null;
            }
            int memberPos = this.getMemberPosition(p);
            scopeMembers[memberPos] = rollUpMember;
        }
        if (!aggregationSetByHierarchy.isEmpty()) {
            this.adjustRollUpMembersToScope(rollUp, scopeMembers, otherLevels, aggregationSetByHierarchy);
        }
        return new Tuple(scopeMembers);
    }

    protected IMember rollUpMembers(HashSet<IMember> members) {
        HashSet<IMember> parentMembers = new HashSet<IMember>();
        IMember firstTop = null;
        while (members.size() > 1) {
            parentMembers.clear();
            for (IMember member : members) {
                IMember pm = member.getParent();
                if (pm != null) {
                    parentMembers.add(pm);
                    continue;
                }
                if (firstTop != null) continue;
                firstTop = member;
            }
            members.clear();
            members.addAll(parentMembers);
        }
        if (members.isEmpty()) {
            return firstTop;
        }
        return members.iterator().next();
    }

    protected void adjustRollUpMembersToScope(HashMap<ArrayList<ILevel>, String> rollUp, IMember[] scopeMembers, ArrayList<ILevel> otherLevels, HashMap<IHierarchy, Pair> aggregationSetByHierarchy) {
        Integer[] currentAggregateLevels = new Integer[aggregationSetByHierarchy.size()];
        int[] memberPosition = new int[aggregationSetByHierarchy.size()];
        for (Map.Entry<IHierarchy, Pair> e : aggregationSetByHierarchy.entrySet()) {
            int hierIndex = this.getHierachyIndex(e.getValue());
            int memberPos = this.getMemberPosition(e.getValue());
            int levelIndex = scopeMembers[memberPos].getLevel().getIndex();
            memberPosition[hierIndex] = memberPos;
            currentAggregateLevels[hierIndex] = levelIndex;
        }
        ArrayWrapper<Integer> current = new ArrayWrapper<Integer>(currentAggregateLevels);
        TreeSet<ArrayWrapper<Object>> allPossibleScopes = new TreeSet<ArrayWrapper<Object>>();
        for (ArrayList<ILevel> s : rollUp.keySet()) {
            HashSet<ILevel> scope = new HashSet<ILevel>(s);
            scope.removeAll(otherLevels);
            Object[] scopeLevels = new Integer[currentAggregateLevels.length];
            Arrays.fill(scopeLevels, (Object)0);
            if (scope.isEmpty()) {
                allPossibleScopes.add(new ArrayWrapper<Object>(scopeLevels));
                continue;
            }
            boolean bInAggregationSet = true;
            for (ILevel lvl : scope) {
                int hierarchyIndex;
                int currentLevelIndex;
                Pair p = aggregationSetByHierarchy.get(lvl.getHierarchy());
                if (p == null) {
                    bInAggregationSet = false;
                    break;
                }
                int scopeLevelIndex = lvl.getIndex();
                if (scopeLevelIndex > (currentLevelIndex = currentAggregateLevels[hierarchyIndex = this.getHierachyIndex(p)].intValue())) {
                    bInAggregationSet = false;
                    break;
                }
                scopeLevels[hierarchyIndex] = scopeLevelIndex;
            }
            if (!bInAggregationSet) continue;
            allPossibleScopes.add(new ArrayWrapper<Object>(scopeLevels));
        }
        if (allPossibleScopes.contains(current) || allPossibleScopes.isEmpty()) {
            return;
        }
        Integer[] lastLevelScope = (Integer[])((ArrayWrapper)allPossibleScopes.last()).get();
        for (int i = 0; i < lastLevelScope.length; ++i) {
            int memberPos = memberPosition[i];
            for (int distance = currentAggregateLevels[i] - lastLevelScope[i]; distance > 0 && scopeMembers[memberPos] != null; --distance) {
                scopeMembers[memberPos] = scopeMembers[memberPos].getParent();
            }
        }
    }

    private int getHierachyIndex(Pair p) {
        Pair pos = (Pair)p.getFirst();
        return (Integer)pos.getFirst();
    }

    private int getMemberPosition(Pair p) {
        Pair pos = (Pair)p.getFirst();
        return (Integer)pos.getSecond();
    }
}

