/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5;

import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.MemberRSAPIValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.rsapi.RSAPIColumn;
import com.cognos.xqe.rsapi.RSAPIRow;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCubeWithCaching;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRDimension;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMemberComparator;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMemberForOLAP;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRProperty;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.IDMRMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.DMRMemberLoadQuery;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.rsapi.RSAPIQueryResult;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.rsapi.RSAPIRowCallback;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.Member;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.DimensionContext;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.MemberProxy;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderQueryResult;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.PushdownManager;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.transformation.v5tocogsql.prePlan.SetOfTables;
import com.cognos.xqe.util.IOrderedMap;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqe.zipi.ZipiContext;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;

public class DMRLevelMemberLoader {
    protected static final Integer NUMEROFROWS_EXECUTE_FOR_VALIDATE = 10;
    private DMRLevel level;
    private List<DMRLevel> levelsToQuery;
    private PushdownManager pushdownManager;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    private DMRCube.IncrementalMemberLoading loadingType = DMRCube.IncrementalMemberLoading.SQL_SORT;
    protected final IdentityHashMap<ILevel, DMRMemberComparator> memberComparator = new IdentityHashMap();

    public DMRLevelMemberLoader(DMRLevel levelToLoad) {
        this.level = levelToLoad;
    }

    public DMRLevelMemberLoader(DMRLevel levelToLoad, PushdownManager pdManager) {
        this.level = levelToLoad;
        this.pushdownManager = pdManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("LoadDMRLevels", ZipiContext.getQRDName());
        try {
            DMRLevel lowestLevel;
            DMRCube dmrCube = (DMRCube)this.level.getDimension().getCube();
            int levelThreshold = dmrCube.getLevelCountThreshold();
            if (levelThreshold > 0 && (lowestLevel = dmrCube.getLowestProjectedLevel(this.level)) != null) {
                this.level = lowestLevel;
            }
            String topN = dmrCube.getModelCube().getTopN();
            this.levelsToQuery = this.level.getParentLevelToQueryWith();
            if (topN == null) {
                ListIterator<DMRLevel> iterator = this.levelsToQuery.listIterator();
                boolean nextLevelRemoved = false;
                while (iterator.hasNext()) {
                    DMRLevel l = iterator.next();
                    if (l.hasGotAllMembers()) {
                        ILevel nextLevel = l.getNextLevel();
                        if (nextLevel == null || nextLevel.isUnique()) {
                            iterator.remove();
                            nextLevelRemoved = true;
                            continue;
                        }
                        if (!nextLevel.isUnique() && nextLevelRemoved) {
                            iterator.remove();
                            continue;
                        }
                        nextLevelRemoved = false;
                        continue;
                    }
                    nextLevelRemoved = false;
                }
            }
            this.checkTreeMerge(dmrCube);
            List<DMRMemberLoadQuery> queries = this.buildRelationalQueries();
            IMember rootParentMember = this.getRootMember();
            for (DMRMemberLoadQuery query : queries) {
                query.setPushdownManager(this.pushdownManager);
                IMetadata[] projectedLevels = query.getProjectedColumns();
                V5ProviderQueryResult v5Result = query.execute(null);
                RSAPIQueryResult result = v5Result.getRSAPIQueryResult();
                try {
                    MembersResultHandler resultHandler = new MembersResultHandler(rootParentMember, query);
                    try {
                        if (resultHandler.lockTargetLevels() > 0) {
                            result.iterateResult(resultHandler);
                            query.addRestrictionMembersToDMRLevel();
                        }
                    }
                    finally {
                        resultHandler.unlockTargetLevels();
                    }
                    resultHandler.setGotAllChildrenForMembersWithAllChildren();
                    if (resultHandler.isReorderStartingLevel()) {
                        resultHandler.reorderStartingLevelMembers(!this.isLevelPartiallyLoaded(query));
                    }
                }
                finally {
                    result.release();
                    v5Result = null;
                }
                for (int i = 0; i < projectedLevels.length; ++i) {
                    DMRLevel aLevel = (DMRLevel)projectedLevels[i];
                    if (aLevel.hasGotAllMembers()) continue;
                    if (!this.isLevelPartiallyLoaded(query)) {
                        aLevel.setGotAllMembers();
                    }
                    dmrCube.removeLevelPropertiesLoadedWithMembers(aLevel);
                }
            }
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
    }

    protected void checkTreeMerge(DMRCube dmrCube) {
        ListIterator<DMRLevel> iterator;
        this.loadingType = dmrCube.getIncrementalMemberLoading();
        if (this.loadingType == DMRCube.IncrementalMemberLoading.TREE_MERGE) {
            boolean bHasComparatorForAllLevels = !this.levelsToQuery.isEmpty();
            iterator = this.levelsToQuery.listIterator();
            while (iterator.hasNext()) {
                DMRLevel l = iterator.next();
                DMRMemberComparator cmp = l.getMemberComparatorForTreeMerge();
                if (cmp == null) {
                    bHasComparatorForAllLevels = false;
                    continue;
                }
                this.memberComparator.put(l, cmp);
            }
            if (!bHasComparatorForAllLevels) {
                this.loadingType = DMRCube.IncrementalMemberLoading.SQL_SORT;
            }
        }
        if (this.loadingType != DMRCube.IncrementalMemberLoading.TREE_MERGE) {
            iterator = this.levelsToQuery.listIterator();
            while (iterator.hasNext()) {
                DMRLevel l = iterator.next();
                if (l.hasGotAllMembers()) continue;
                l.clearMemberOrderedMap();
            }
        }
    }

    private boolean restrictionMembersExistInCube(List<BaseMember> members, List<ILevel> allDMRLevels, int levelIdx) {
        HashMap<ILevel, DMRLevel> levelWrapperToDMRLevel = new HashMap<ILevel, DMRLevel>();
        for (ILevel lvl : allDMRLevels) {
            DMRLevel dmrLvl;
            int n = lvl.getIndex();
            if (n == 0 || n >= levelIdx || (dmrLvl = (DMRLevel)lvl).hasGotAllMembers()) continue;
            levelWrapperToDMRLevel.put(dmrLvl.getFMLevel(), dmrLvl);
        }
        if (levelWrapperToDMRLevel.isEmpty()) {
            return true;
        }
        HashMap munToCheck = new HashMap();
        for (BaseMember baseMember : members) {
            ILevel lvl = baseMember.getLevel();
            DMRLevel dmrLvl = (DMRLevel)levelWrapperToDMRLevel.get(lvl);
            if (dmrLvl == null) continue;
            HashSet<String> st = (HashSet<String>)munToCheck.get(dmrLvl);
            if (st == null) {
                st = new HashSet<String>();
                munToCheck.put(dmrLvl, st);
            }
            String externalName = baseMember.getExternalName();
            st.add(externalName);
        }
        for (Map.Entry entry : munToCheck.entrySet()) {
            IOrderedMap<IMember> allLevelMembers = ((DMRLevel)entry.getKey()).getMembersNoBlock();
            HashSet<String> allMuns = new HashSet<String>();
            if (allLevelMembers == null) {
                return false;
            }
            ArrayList<IMember> lst = allLevelMembers.getList();
            if (lst == null) {
                return false;
            }
            for (IMember mb : lst) {
                allMuns.add(mb.getUniqueName());
            }
            if (allMuns.containsAll((Collection)entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private List<DMRMemberLoadQuery> buildRelationalQueries() {
        ArrayList<DMRMemberLoadQuery> queries = new ArrayList<DMRMemberLoadQuery>();
        DMRCube dmrCube = (DMRCube)this.level.getDimension().getCube();
        SetOfTables currentSetOfTables = null;
        String mName = DMRUtilities.getMetadataNameForLog(this.level);
        DMRUtilities.SubqueryType type = this.pushdownManager != null ? DMRUtilities.SubqueryType.getPushdownSubqueryType(this.pushdownManager) : DMRUtilities.SubqueryType.LOAD_LEVELS;
        DMRMemberLoadQuery currentQuery = new DMRMemberLoadQuery(dmrCube, mName, type, this.loadingType == DMRCube.IncrementalMemberLoading.TREE_MERGE);
        currentQuery.setXmdxNodeId(this.level.getXmdxTupleId());
        Map.Entry<ILevel, List<BaseMember>> restriction = dmrCube.getRestrictionMembersForHierarchy(this.level.getHierarchy());
        boolean bCheckInvolvedTables = true;
        String topN = dmrCube.getModelCube().getTopN();
        if (topN != null) {
            bCheckInvolvedTables = false;
        }
        if (bCheckInvolvedTables && this.loadingType != DMRCube.IncrementalMemberLoading.NONE && restriction != null) {
            List<BaseMember> r = restriction.getValue();
            currentQuery.setRestrictionMembers(r);
            if (this.loadingType == DMRCube.IncrementalMemberLoading.TREE_MERGE && r != null && r.size() > 0 && r.size() < dmrCube.getRestrictionMembersCountThreshold() && this.restrictionMembersExistInCube(r, this.level.getHierarchy().getLevels(), this.level.getIndex())) {
                bCheckInvolvedTables = false;
            }
        }
        queries.add(currentQuery);
        int countLevels = this.levelsToQuery.size();
        for (int i = countLevels - 1; i >= 0; --i) {
            int levelsAdded;
            DMRLevel aLevel = this.levelsToQuery.get(i);
            SetOfTables tables = null;
            if (bCheckInvolvedTables) {
                tables = aLevel.getInvolvedTables();
                if (currentSetOfTables == null) {
                    currentSetOfTables = tables;
                } else if (!currentSetOfTables.equals(tables)) {
                    if (currentQuery.getColumnCount() != 0) {
                        currentQuery = new DMRMemberLoadQuery(dmrCube, mName, type, this.loadingType == DMRCube.IncrementalMemberLoading.TREE_MERGE);
                        restriction = dmrCube.getRestrictionMembersForHierarchy(this.level.getHierarchy());
                        if (this.loadingType != DMRCube.IncrementalMemberLoading.NONE && restriction != null) {
                            currentQuery.setRestrictionMembers(restriction.getValue());
                        }
                        queries.add(currentQuery);
                    }
                    levelsAdded = this.addContextLevels(currentQuery, aLevel);
                    currentQuery.setStartingLevelIndex(levelsAdded);
                }
            }
            if (currentQuery.getColumnCount() == 0 && aLevel.getIndex() > 1) {
                levelsAdded = this.addContextLevels(currentQuery, aLevel);
                currentQuery.setStartingLevelIndex(levelsAdded);
            }
            currentQuery.setXmdxNodeId(aLevel.getXmdxTupleId());
            currentQuery.addColumn(aLevel);
            currentSetOfTables = tables;
        }
        this.removeRedundantQueries(queries);
        if (dmrCube.getExecuteForValidate()) {
            for (DMRMemberLoadQuery q : queries) {
                q.setNumberOfRowsToRetrieve(NUMEROFROWS_EXECUTE_FOR_VALIDATE);
            }
        }
        return queries;
    }

    private void removeRedundantQueries(List<DMRMemberLoadQuery> queries) {
        ListIterator<DMRMemberLoadQuery> iterator = queries.listIterator();
        while (iterator.hasNext()) {
            DMRMemberLoadQuery query = iterator.next();
            IMetadata[] columns = query.getProjectedColumns();
            boolean removeQuery = true;
            for (int i = 0; i < columns.length; ++i) {
                DMRLevel aLevel = (DMRLevel)columns[i];
                if (aLevel.hasGotAllMembers()) continue;
                removeQuery = false;
                break;
            }
            if (!removeQuery) continue;
            iterator.remove();
        }
    }

    private int addContextLevels(DMRMemberLoadQuery query, ILevel aLevel) {
        int levelsAdded = 0;
        for (ILevel currentLevel = this.determineLowestUniqueParentLevel(aLevel); currentLevel != aLevel; currentLevel = currentLevel.getNextLevel()) {
            query.addColumn(currentLevel);
            ++levelsAdded;
        }
        return levelsAdded;
    }

    private ILevel determineLowestUniqueParentLevel(ILevel aLevel) {
        if (aLevel.getIndex() <= 1) {
            return aLevel;
        }
        ILevel currentLevel = aLevel.getPreviousLevel();
        while (!currentLevel.isUnique() && currentLevel.getIndex() > 1) {
            currentLevel = currentLevel.getPreviousLevel();
        }
        return currentLevel;
    }

    private IMember getRootMember() {
        IMember rootParentMember = null;
        try {
            Level rootLevel = (Level)this.level.getHierarchy().getLevel(0);
            if (rootLevel.hasGotAllMembers() && rootLevel != this.level && rootLevel.getMembers().size() == 1) {
                rootParentMember = rootLevel.getMembers().get(0);
            }
        }
        catch (Exception e) {
            mErrorLogger.log(e);
        }
        return rootParentMember;
    }

    public static void sortMembersInHierarchyOrder(ILevel rootLevel, TreeMap extra) {
        IdentityHashMap<ILevel, ArrayList<IMember>> sortedMembersPerLevel = new IdentityHashMap<ILevel, ArrayList<IMember>>();
        IOrderedMap<IMember> members = ((DMRLevel)rootLevel).getMembersNoBlock();
        ArrayList<IMember> listOfMembers = members.getList();
        for (IMember iMember : listOfMembers) {
            DMRLevelMemberLoader.generateSortedmembersPerLevel(iMember, sortedMembersPerLevel);
        }
        for (Map.Entry entry : sortedMembersPerLevel.entrySet()) {
            LevelInfoForHandler info;
            DMRLevel dmrLevel = (DMRLevel)entry.getKey();
            if (extra != null && ((info = (LevelInfoForHandler)extra.get(dmrLevel.getIndex())) == null || info.loadedAndUnlocked == Boolean.TRUE)) continue;
            IOrderedMap<IMember> membersInLevel = dmrLevel.getMembersNoBlock();
            membersInLevel.clear();
            membersInLevel.putAll((Collection)entry.getValue());
        }
    }

    private static void generateSortedmembersPerLevel(IMember pm, IdentityHashMap<ILevel, ArrayList<IMember>> sortedMembersPerLevel) {
        boolean hasChilden = false;
        if (pm instanceof MemberProxy) {
            hasChilden = ((MemberProxy)pm).getChildrenOrderedMapSize() > 0;
        } else {
            boolean bl = hasChilden = ((Member)pm).getChildrenOrderedMapSize() > 0;
        }
        if (!hasChilden) {
            return;
        }
        IOrderedMap<IMember> childMap = ((IMemberCubics)pm).getChildrenOrderedMap();
        ArrayList<IMember> childMembers = childMap.getList();
        for (IMember cm : childMembers) {
            ILevel l = cm.getLevel();
            ArrayList<IMember> memberList = sortedMembersPerLevel.get(l);
            if (memberList == null) {
                memberList = new ArrayList();
                sortedMembersPerLevel.put(l, memberList);
            }
            memberList.add(cm);
            DMRLevelMemberLoader.generateSortedmembersPerLevel(cm, sortedMembersPerLevel);
        }
    }

    private static int getStorageUID(DMRLevel level) {
        DMRDimension dmrDim = (DMRDimension)level.getDimension();
        DimensionContext context = dmrDim.getStorage();
        if (context != null) {
            return context.getUniqueId();
        }
        return ((DMRCubeWithCaching)level.getDimension().getCube()).getCubeContext().getUniqueId();
    }

    private boolean isLevelPartiallyLoaded(DMRMemberLoadQuery query) {
        return !query.getRestrictionMembers().isEmpty() || this.pushdownManager != null;
    }

    private final class MembersResultHandler
    implements RSAPIRowCallback {
        private IMember rootMember;
        private DMRMemberLoadQuery query;
        private DMRLevel startingLevel;
        private boolean reorderStartingLevel = false;
        private final IdentityHashMap<IMemberCubics, IMemberCubics> membersHasAllChildren = new IdentityHashMap();
        private LevelInfoForHandler[] levels;
        private boolean[] levelMembersRestricted;
        private final TreeMap<Integer, LevelInfoForHandler> targetLevels = new TreeMap();
        private final IdentityHashMap<IMemberCubics, Boolean> parentMembersHasNewChild = new IdentityHashMap();
        private final IdentityHashMap<IMemberCubics, IMemberCubics> newMembers = new IdentityHashMap();

        private MembersResultHandler(IMember theRootMember, DMRMemberLoadQuery membersQuery) {
            this.rootMember = theRootMember;
            this.query = membersQuery;
            IMetadata[] columns = this.query.getProjectedColumns();
            this.levels = new LevelInfoForHandler[columns.length];
            this.startingLevel = (DMRLevel)columns[this.query.getStartingLevelIndex()];
            for (int i = 0; i < columns.length; ++i) {
                this.levels[i] = new LevelInfoForHandler();
                this.levels[i].level = (DMRLevel)columns[i];
                this.levels[i].needCaption = this.query.needLevelCaption(this.levels[i].level) ? Boolean.TRUE : Boolean.FALSE;
                this.levels[i].properties = this.query.getLevelProperties(this.levels[i].level);
                FormatId businessKeyId = this.levels[i].level.getBusinessKeyFormatId();
                FormatId captionId = this.levels[i].level.getCaptionFormatId();
                boolean bHasFormat = businessKeyId != null || captionId != null;
                ArrayList<FormatId> formats = new ArrayList<FormatId>();
                formats.add(businessKeyId);
                formats.add(captionId);
                if (this.levels[i].properties != null) {
                    for (String prop : this.levels[i].properties) {
                        DMRProperty property = (DMRProperty)this.levels[i].level.getMemberProperty(prop);
                        String propertyFormat = (String)property.getProperty("format");
                        FormatId propertyFormatId = null;
                        if (propertyFormat != null) {
                            propertyFormatId = FormatService.getInstance().registerV5Format(propertyFormat, null);
                        }
                        formats.add(propertyFormatId);
                        if (propertyFormatId == null) continue;
                        bHasFormat = true;
                    }
                }
                if (!bHasFormat) continue;
                this.levels[i].formatId = formats;
            }
            boolean queryRestricted = this.query.getRestrictionMembers().size() > 0;
            this.levelMembersRestricted = new boolean[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                DMRLevel dmrLevel = this.levels[i].level;
                this.levelMembersRestricted[i] = queryRestricted || !dmrLevel.hasGotAllMembers() && dmrLevel.getMemberCount() > 0;
            }
        }

        @Override
        public boolean reRun() {
            if (DMRLevelMemberLoader.this.loadingType == DMRCube.IncrementalMemberLoading.TREE_MERGE) {
                this.reorderStartingLevel = false;
                this.resortMemberTreeAndGeneratedMembersForLevel();
            }
            return false;
        }

        @Override
        public boolean needReIterateRows() {
            return false;
        }

        private void resortMemberTreeAndGeneratedMembersForLevel() {
            if (this.newMembers.isEmpty()) {
                return;
            }
            ILevel highestLevel = null;
            for (Map.Entry<IMemberCubics, Boolean> e : this.parentMembersHasNewChild.entrySet()) {
                IOrderedMap<IMember> childMap;
                ArrayList<IMember> childMembers;
                IMemberCubics pm = e.getKey();
                ILevel l = pm.getLevel();
                if (highestLevel == null || highestLevel.getIndex() > l.getIndex()) {
                    highestLevel = l;
                }
                if (e.getValue() == Boolean.FALSE || (childMembers = (childMap = pm.getChildrenOrderedMap()).getList()) == null || childMembers.isEmpty()) continue;
                IMember first = (IMember)childMembers.get(0);
                DMRMemberComparator cmp = DMRLevelMemberLoader.this.memberComparator.get(first.getLevel());
                childMap.sort(cmp);
                childMembers = childMap.getList();
                for (int i = 0; i < childMembers.size(); ++i) {
                    ((IDMRMember)childMembers.get(i)).setIndexInParentsChildren(i);
                }
            }
            DMRLevelMemberLoader.sortMembersInHierarchyOrder(highestLevel, this.targetLevels);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void consumeRow(RSAPIRow row, RSAPIColumn[] columns, FormatId[] formatIds) {
            IMemberCubics currentParent = null;
            IDMRMember columnZeroMember = null;
            LevelInfoForHandler currentLevelInfo = this.levels[0];
            int countLevels = this.levels.length;
            int columnZeroLevelNumber = currentLevelInfo.level.getIndex();
            DMRCube currentCube = (DMRCube)currentLevelInfo.level.getDimension().getCube();
            boolean membersCachedInMemberStorage = currentCube.memberStorageEnabled();
            if (membersCachedInMemberStorage && currentLevelInfo.level.isV5LevelWrapper()) {
                membersCachedInMemberStorage = false;
            }
            if (columnZeroLevelNumber == 1) {
                currentParent = (IMemberCubics)this.rootMember;
            } else {
                FormatId id;
                Value v = (Value)row.getColumn(0);
                List<FormatId> formats = currentLevelInfo.formatId;
                if (formats != null && (id = formats.get(0)) != null) {
                    v.setFormatId(id);
                }
                if (v.getFormatId() == FormatId.INVALID_FORMAT_FID) {
                    v.setFormatId(formatIds[0]);
                }
                String keyName = v.getV5formattedString();
                if (v.isNull()) {
                    keyName = "";
                }
                columnZeroMember = currentLevelInfo.loadedAndUnlocked == Boolean.FALSE ? (IDMRMember)currentLevelInfo.level.getMember(keyName) : (IDMRMember)currentLevelInfo.level.getMemberNolocking(keyName);
            }
            int rowOffset = 0;
            for (int j = 0; j < countLevels; ++j) {
                currentLevelInfo = this.levels[j];
                FormatId businessKeyId = null;
                FormatId captionId = null;
                List<FormatId> formats = currentLevelInfo.formatId;
                if (formats != null) {
                    businessKeyId = formats.get(0);
                    captionId = formats.get(1);
                }
                Value businessKey = (Value)row.getColumn(rowOffset);
                Value memberName = null;
                HashMap<String, Object> propertyValues = null;
                boolean bOlapMember = businessKey instanceof MemberRSAPIValue;
                if (!bOlapMember) {
                    if (businessKey == null) {
                        businessKey = DMRMember.DEFAULT_BUSINESSKEY;
                    }
                    if (businessKeyId != null) {
                        businessKey.setFormatId(businessKeyId);
                    }
                    if (businessKey.getFormatId() == FormatId.INVALID_FORMAT_FID) {
                        businessKey.setFormatId(formatIds[rowOffset]);
                    }
                    ++rowOffset;
                    if (currentLevelInfo.needCaption == Boolean.TRUE) {
                        memberName = (Value)row.getColumn(rowOffset);
                        if (captionId != null) {
                            memberName.setFormatId(captionId);
                        }
                        if (memberName.getFormatId() == FormatId.INVALID_FORMAT_FID) {
                            memberName.setFormatId(formatIds[rowOffset]);
                        }
                        ++rowOffset;
                    } else {
                        memberName = (Value)businessKey.copy();
                        if (captionId != null) {
                            memberName.setFormatId(captionId);
                        }
                        memberName.setFormatId(businessKey.getFormatId());
                    }
                    List<String> props = currentLevelInfo.properties;
                    if (props != null) {
                        propertyValues = new HashMap<String, Object>();
                        int f = 2;
                        for (String string : props) {
                            Value propValue = (Value)row.getColumn(rowOffset);
                            if (formats != null && formats.get(f) != null) {
                                propValue.setFormatId(formats.get(f));
                            }
                            if (propValue.getFormatId() == FormatId.INVALID_FORMAT_FID) {
                                propValue.setFormatId(formatIds[rowOffset]);
                            }
                            ++rowOffset;
                            propertyValues.put(currentLevelInfo.level.getMemberProperty(string).getUniqueName(), propValue);
                            ++f;
                        }
                    }
                } else {
                    ++rowOffset;
                }
                IDMRMember currentMember = null;
                if (currentParent != null) {
                    void var23_33;
                    boolean isReorderChildrenRequired = false;
                    if (!DMRLevelMemberLoader.this.isLevelPartiallyLoaded(this.query)) {
                        this.membersHasAllChildren.put(currentParent, currentParent);
                        isReorderChildrenRequired = true;
                    } else {
                        String parentMemberName = currentParent.getUniqueName();
                        if (parentMemberName != null) {
                            List<BaseMember> list = this.query.getRestrictionMembers();
                            for (BaseMember aRestrictionMember : list) {
                                String restrictionMemberName = aRestrictionMember.getExternalName();
                                if (restrictionMemberName == null || !parentMemberName.regionMatches(0, restrictionMemberName, 0, restrictionMemberName.length())) continue;
                                this.membersHasAllChildren.put(currentParent, currentParent);
                                isReorderChildrenRequired = true;
                                break;
                            }
                        }
                    }
                    Value[] rtBusinessKey = new Value[]{null};
                    String string = DMRMember.convertBusinessKeyToDMRMemberName(businessKey, rtBusinessKey);
                    if (rtBusinessKey[0] != null) {
                        businessKey = rtBusinessKey[0];
                    }
                    if (businessKey instanceof MemberRSAPIValue) {
                        String string2 = DMRMember.convertBusinessKeyToDMRMemberName(((MemberRSAPIValue)businessKey).getBusinessKeyValue(), null);
                    }
                    if ((currentMember = (IDMRMember)currentParent.searchChildrenOrderedMap((String)var23_33)) != null && DMRLevelMemberLoader.this.loadingType == DMRCube.IncrementalMemberLoading.SQL_SORT && (!currentParent.hasGotAllChildren() || isReorderChildrenRequired)) {
                        IOrderedMap<IMember> childrenMap = currentParent.getChildrenOrderedMap();
                        childrenMap.remove(currentMember);
                        childrenMap.add(currentMember);
                        currentMember.resetIndexInParentsChildren();
                    }
                } else if (j == 0) {
                    currentMember = columnZeroMember;
                } else {
                    throw new IllegalStateException();
                }
                if (currentMember == null) {
                    if (bOlapMember) {
                        currentMember = new DMRMemberForOLAP((MemberRSAPIValue)businessKey, currentLevelInfo.level);
                    } else {
                        if (currentLevelInfo.loadedAndUnlocked == Boolean.TRUE) {
                            return;
                        }
                        if (memberName == null || memberName.isNull()) {
                            memberName = DataValueFactory.createStringValue();
                            memberName.set("");
                        } else {
                            memberName = (Value)memberName.copy();
                        }
                        DMRMember dmrMember = new DMRMember(memberName, (Value)businessKey.copy(), currentLevelInfo.level);
                        if (propertyValues != null) {
                            for (Map.Entry entry : propertyValues.entrySet()) {
                                dmrMember.setProperty((String)entry.getKey(), ((Value)entry.getValue()).copy());
                            }
                        }
                        currentMember = membersCachedInMemberStorage ? DMRMemberProxy.cacheMember(dmrMember, currentParent) : dmrMember;
                        if (DMRLevelMemberLoader.this.loadingType == DMRCube.IncrementalMemberLoading.TREE_MERGE) {
                            this.newMembers.put(currentMember, currentMember);
                        }
                    }
                    if (currentParent != null) {
                        if (DMRLevelMemberLoader.this.loadingType == DMRCube.IncrementalMemberLoading.TREE_MERGE && !this.newMembers.containsKey(currentParent) && !this.parentMembersHasNewChild.containsKey(currentParent)) {
                            boolean hasChilden = false;
                            if (currentParent instanceof MemberProxy) {
                                hasChilden = ((MemberProxy)currentParent).getChildrenOrderedMapSize() > 0;
                            } else {
                                boolean bl = hasChilden = ((Member)currentParent).getChildrenOrderedMapSize() > 0;
                            }
                            if (hasChilden) {
                                this.parentMembersHasNewChild.put(currentParent, Boolean.TRUE);
                            } else {
                                this.parentMembersHasNewChild.put(currentParent, Boolean.FALSE);
                            }
                        }
                        if (DMRLevelMemberLoader.this.loadingType != DMRCube.IncrementalMemberLoading.SQL_SORT) {
                            currentMember.setIndexInParentsChildren(currentParent.getChildrenOrderedMapSize());
                        }
                        currentParent.addMemberToChildrenOrderedMap(currentMember);
                        if (currentParent instanceof IDMRMember) {
                            ((IDMRMember)currentParent).addChildToBusinessKeyMap(currentMember);
                        }
                        currentMember.setParentMember(currentParent);
                    }
                }
                if (DMRLevelMemberLoader.this.loadingType != DMRCube.IncrementalMemberLoading.TREE_MERGE && currentLevelInfo.loadedAndUnlocked == Boolean.FALSE) {
                    if (!currentLevelInfo.level.equals(this.startingLevel)) {
                        currentLevelInfo.level.addMember(currentMember);
                    } else {
                        this.reorderStartingLevel = true;
                    }
                }
                currentParent = currentMember;
            }
        }

        protected void setGotAllChildrenForMembersWithAllChildren() {
            for (IMemberCubics member : this.membersHasAllChildren.keySet()) {
                member.setGotAllChildren();
            }
        }

        protected void reorderStartingLevelMembers(boolean hasNoRestrictions) {
            this.reorderStartLevelMembers(this.startingLevel, hasNoRestrictions);
            ILevel topContextLevel = DMRLevelMemberLoader.this.determineLowestUniqueParentLevel(this.startingLevel);
            if (topContextLevel != this.startingLevel && topContextLevel.getIndex() > 1) {
                for (int i = this.query.getStartingLevelIndex() + 1; i < this.levels.length; ++i) {
                    this.reorderStartLevelMembers(this.levels[i].level, hasNoRestrictions);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reorderStartLevelMembers(DMRLevel startLevel, boolean hasNoRestrictions) {
            ILevel previousLevel = startLevel.getPreviousLevel();
            ArrayList<IMemberCubics> previousLevelMembers = new ArrayList<IMemberCubics>();
            IOrderedMap<IMember> memberMap = ((Level)previousLevel).getMembersOrderedMap();
            memberMap.lock();
            try {
                for (IMemberCubics iMemberCubics : memberMap) {
                    if (iMemberCubics.isFillerMember() || iMemberCubics.isHidden()) continue;
                    previousLevelMembers.add(iMemberCubics);
                }
            }
            finally {
                memberMap.unlock();
            }
            ArrayList<IMember> levelMembers = new ArrayList<IMember>();
            for (IMemberCubics parentMember : previousLevelMembers) {
                if (parentMember.isPopulateChildrenRequired() && hasNoRestrictions) {
                    parentMember.setGotAllChildren();
                    continue;
                }
                memberMap = parentMember.getChildrenOrderedMap();
                memberMap.lock();
                try {
                    for (IMember aMember : memberMap) {
                        levelMembers.add(aMember);
                    }
                }
                finally {
                    memberMap.unlock();
                }
            }
            startLevel.writeLock().lock();
            try {
                startLevel.clearMemberOrderedMap();
                for (IMember aMember : levelMembers) {
                    startLevel.addMember(aMember);
                }
            }
            finally {
                startLevel.writeLock().unlock();
            }
        }

        protected boolean isReorderStartingLevel() {
            return this.reorderStartingLevel;
        }

        protected int lockTargetLevels() {
            Object aLevel2;
            for (int i = 0; i < this.levels.length; ++i) {
                aLevel2 = this.levels[i].level;
                this.targetLevels.put(((Level)aLevel2).getIndex(), this.levels[i]);
            }
            for (Object aLevel2 : this.targetLevels.descendingMap().values()) {
                ((LevelInfoForHandler)aLevel2).level.writeLock().lock();
            }
            Iterator<LevelInfoForHandler> it = this.targetLevels.values().iterator();
            while (it.hasNext()) {
                aLevel2 = it.next();
                if (((LevelInfoForHandler)aLevel2).level.hasGotAllMembers()) {
                    ((LevelInfoForHandler)aLevel2).loadedAndUnlocked = Boolean.TRUE;
                    ((LevelInfoForHandler)aLevel2).level.writeLock().unlock();
                    it.remove();
                    continue;
                }
                ((LevelInfoForHandler)aLevel2).loadedAndUnlocked = Boolean.FALSE;
                if (((LevelInfoForHandler)aLevel2).level.getLevelStorage() == null) continue;
                ((LevelInfoForHandler)aLevel2).level.getLevelStorage().openBuffer(DMRLevelMemberLoader.getStorageUID(((LevelInfoForHandler)aLevel2).level));
            }
            return this.targetLevels.size();
        }

        protected void unlockTargetLevels() {
            for (LevelInfoForHandler aLevel : this.targetLevels.values()) {
                if (aLevel.level.getLevelStorage() != null) {
                    aLevel.level.getLevelStorage().flushToCache(DMRLevelMemberLoader.getStorageUID(aLevel.level));
                }
                aLevel.level.writeLock().unlock();
            }
        }
    }

    private final class LevelInfoForHandler {
        protected DMRLevel level = null;
        protected Boolean loadedAndUnlocked = null;
        protected Boolean needCaption = null;
        protected List<String> properties = null;
        protected List<FormatId> formatId = null;

        private LevelInfoForHandler() {
        }
    }
}

