/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.V5QueryOverTabularStream;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DMRMemberLoadQuery
extends V5QueryOverTabularStream {
    private int startingLevelIndex;
    private List<BaseMember> restrictionMembers = Collections.emptyList();
    private final boolean useTreeMerger;
    private Map<DMRLevel, List<BaseMember>> restrictionsToDMRLevels;

    public DMRMemberLoadQuery(DMRCube cCube, String levelName, DMRUtilities.SubqueryType type, boolean bTreeMerge) {
        super(cCube, type, levelName, type.toString());
        this.useTreeMerger = bTreeMerge;
    }

    protected int getStartingLevelIndex() {
        return this.startingLevelIndex;
    }

    protected void setStartingLevelIndex(int column) {
        this.startingLevelIndex = column;
    }

    protected void registerRestrictionMembersToDMRLevel(DMRLevel dmrLevel, List<BaseMember> theRestrictionMembers) {
        if (this.restrictionsToDMRLevels == null) {
            this.restrictionsToDMRLevels = new HashMap<DMRLevel, List<BaseMember>>();
        }
        if (!this.restrictionsToDMRLevels.containsKey(dmrLevel)) {
            this.restrictionsToDMRLevels.put(dmrLevel, new ArrayList<BaseMember>(theRestrictionMembers));
        }
    }

    public void addRestrictionMembersToDMRLevel() {
        if (this.restrictionsToDMRLevels == null) {
            return;
        }
        for (Map.Entry<DMRLevel, List<BaseMember>> e : this.restrictionsToDMRLevels.entrySet()) {
            e.getKey().addRestrictionMembers(e.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void generateFilters(IXQEQueryNode query, PlanningEnvironment planningEnv, XQENodeFactory nodeFactory) {
        super.generateFilters(query, planningEnv, nodeFactory);
        boolean isNoRestriction = true;
        if (this.restrictionMembers != null && !this.restrictionMembers.isEmpty()) {
            TreeMap<String, BaseMember> currentRestrictions = new TreeMap<String, BaseMember>();
            for (IMetadata aColumn : this.getProjectedColumns()) {
                DMRLevel dmrLevel = (DMRLevel)aColumn;
                this.registerRestrictionMembersToDMRLevel(dmrLevel, this.restrictionMembers);
                if (!this.useTreeMerger) {
                    dmrLevel.readLock().lock();
                    try {
                        ArrayList<BaseMember> allRestrictionMembers = new ArrayList<BaseMember>(dmrLevel.getRestrictionMembers());
                        allRestrictionMembers.addAll(this.restrictionMembers);
                        Iterator iterator = allRestrictionMembers.iterator();
                        while (iterator.hasNext()) {
                            BaseMember member = (BaseMember)iterator.next();
                            boolean bDuplicate = false;
                            for (IXQEQueryNode aMember : currentRestrictions.values()) {
                                if (member != aMember && !member.isSameExpression(aMember, false)) continue;
                                bDuplicate = true;
                                break;
                            }
                            if (bDuplicate) continue;
                            currentRestrictions.put(member.getExternalName(), member);
                        }
                        continue;
                    }
                    finally {
                        dmrLevel.readLock().unlock();
                    }
                }
                for (BaseMember member : this.restrictionMembers) {
                    boolean bDuplicate = false;
                    for (BaseMember aMember : currentRestrictions.values()) {
                        if (member != aMember && !member.isSameExpression(aMember, false)) continue;
                        bDuplicate = true;
                        break;
                    }
                    if (bDuplicate) continue;
                    currentRestrictions.put(member.getExternalName(), member);
                }
            }
            DMRCube cube = (DMRCube)((DMRLevel)this.getProjectedColumns()[0]).getDimension().getCube();
            if (currentRestrictions.size() < cube.getRestrictionMembersCountThreshold()) {
                isNoRestriction = false;
                IXQEQueryNode filterExpr = null;
                for (BaseMember member : currentRestrictions.values()) {
                    String logical;
                    String mun;
                    ILevel level = member.getLevel();
                    IXQEQueryNode in = DMRMemberLoadQuery.createInExpression(nodeFactory, level, mun = member.getExternalName(), logical = (String)member.getPropertyValue("logical"));
                    if (in == null) continue;
                    filterExpr = DMRMemberLoadQuery.createLogicalExpression(nodeFactory, in, filterExpr, 1);
                }
                if (filterExpr != null) {
                    V5DetailFilter detailFilter = (V5DetailFilter)nodeFactory.createNode(101008);
                    detailFilter.setPostAutoAggregation(false);
                    detailFilter.addChild(filterExpr);
                    query.addChild(detailFilter);
                }
            } else {
                this.restrictionMembers.clear();
            }
        }
        if (isNoRestriction) {
            for (IMetadata aColumn : this.getProjectedColumns()) {
                DMRLevel dmrLevel = (DMRLevel)aColumn;
                dmrLevel.clearRestrictionMembers();
            }
        }
    }

    public static IXQEQueryNode createInExpression(XQENodeFactory nodeFactory, ILevel level, String externalMUN, String logical) {
        if (level == null || externalMUN == null || externalMUN.length() == 0) {
            return null;
        }
        IXQEQueryNode in = nodeFactory.createNode(201011);
        V5BoundMemberUniqueName v5BoundMemberUniqueName = (V5BoundMemberUniqueName)nodeFactory.createNode(201117);
        v5BoundMemberUniqueName.setExternalMemberUniqueName(externalMUN);
        v5BoundMemberUniqueName.setLevel(level);
        if (logical != null) {
            v5BoundMemberUniqueName.setPropertyValue("nativeName", UniqueNameGenerator.joinModelLogicalPhysicalParts(level.getV5UniqueName(), logical, null));
        }
        V5BoundModelIdentifier modelHierarchy = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
        modelHierarchy.setMetadata(level);
        in.addChild(modelHierarchy);
        in.addChild(v5BoundMemberUniqueName);
        return in;
    }

    public static IXQEQueryNode createLogicalExpression(XQENodeFactory nodeFactory, IXQEQueryNode in, IXQEQueryNode filterExpr, int subType) {
        if (filterExpr == null) {
            return in;
        }
        V5LogicalExpression or = (V5LogicalExpression)nodeFactory.createNode(201003);
        or.setSubType(subType);
        or.addChild(filterExpr);
        or.addChild(in);
        return or;
    }

    public List<BaseMember> getRestrictionMembers() {
        return this.restrictionMembers;
    }

    public void setRestrictionMembers(List<BaseMember> members) {
        this.restrictionMembers = members;
    }

    @Override
    protected boolean isTreeMerge() {
        return this.useTreeMerger;
    }
}

