/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5Exp.AbstractV5BooleanExpression;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.V5QueryOverTabularStream;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import java.util.ArrayList;
import java.util.List;

public class V5QueryAggregateOverTabularStream
extends V5QueryOverTabularStream {
    private List<List<IMember>> aggregateMemberExpressions;

    public V5QueryAggregateOverTabularStream(DMRCube cCube, String index, String theQueryName) {
        super(cCube, DMRUtilities.SubqueryType.FETCH_CELL_VALUES_FIRST_LAST_AGGREGATE, index, theQueryName);
    }

    public void setAggregateMemberToOrExpressions(List<List<IMember>> aggrMemExpressions) {
        this.aggregateMemberExpressions = aggrMemExpressions;
    }

    @Override
    protected void generateFilters(IXQEQueryNode query, PlanningEnvironment planningEnv, XQENodeFactory nodeFactory) {
        super.generateFilters(query, planningEnv, nodeFactory);
        V5QueryAggregateOverTabularStream.generateFiltersPerHierarchy(query, this.aggregateMemberExpressions, planningEnv, nodeFactory);
    }

    private static void generateFiltersPerHierarchy(IXQEQueryNode query, List<List<IMember>> perHierarchyMemberList, PlanningEnvironment planningEnv, XQENodeFactory nodeFactory) {
        for (List<IMember> membersPerHierarchy : perHierarchyMemberList) {
            IXQEQueryNode filterExpr = null;
            for (IMember member : membersPerHierarchy) {
                IXQEQueryNode memberFilterExpression = V5QueryAggregateOverTabularStream.createFilterExpressionForMember(member, planningEnv);
                if (filterExpr == null) {
                    filterExpr = memberFilterExpression;
                    continue;
                }
                V5LogicalExpression orExpr = (V5LogicalExpression)nodeFactory.createNode(201003);
                orExpr.setSubType(1);
                orExpr.addChild(filterExpr);
                orExpr.addChild(memberFilterExpression);
                filterExpr = orExpr;
            }
            if (filterExpr == null) {
                return;
            }
            V5DetailFilter rootFilter = (V5DetailFilter)nodeFactory.createNode(101008);
            rootFilter.addChild(filterExpr);
            query.addChild(rootFilter);
        }
    }

    private static IXQEQueryNode createFilterExpressionForMember(IMember member, PlanningEnvironment planEnv) {
        XQENodeFactory nodeFactory = planEnv.getNodeFactory();
        IDataSourceCapabilities providerCapabilities = ProviderCapabilites.getInstance().getOrAddProviderCapabilities("DMR");
        ArrayList<IMember> ancestors = new ArrayList<IMember>();
        if (providerCapabilities.getBooleanValue("enableUniqueLevelSupport", true)) {
            while (member.getLevel().getIndex() != 0) {
                ancestors.add(0, member);
                if (!member.getLevel().isUnique()) {
                    member = member.getParent();
                    continue;
                }
                break;
            }
        } else {
            while (member.getLevel().getIndex() != 0) {
                ancestors.add(0, member);
                member = member.getParent();
            }
        }
        AbstractV5BooleanExpression aFilter = null;
        for (int i = 0; i < ancestors.size(); ++i) {
            AbstractV5BooleanExpression filterExpression = DMRUtilities.createFilterForMember(planEnv, (IMember)ancestors.get(i));
            if (aFilter == null) {
                aFilter = filterExpression;
                continue;
            }
            V5LogicalExpression andExpr = (V5LogicalExpression)nodeFactory.createNode(201003);
            andExpr.setSubType(0);
            andExpr.addChild(aFilter);
            andExpr.addChild(filterExpression);
            aFilter = andExpr;
        }
        return aFilter;
    }
}

