/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRPreloadCellsLogger;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRQueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.V5QueryGroup;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.V5QueryResult;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.AdaptiveCubeletStorageManager;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.usage.UsageTrackingService;
import com.cognos.xqe.util.usage.indicators.IUsageIndicator;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorCategory;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorType;
import com.cognos.xqebifw.cubingservices.DQThreadContext;
import java.util.concurrent.Callable;

public class V5QueryGroupWorker
implements Callable<Boolean> {
    ExecutionEnvironment execEnv;
    private V5QueryGroup queryGroup;
    private DMRQueryStrategy strategy;
    private DMRCube cube;
    private AdaptiveCubeletStorageManager storageManager;

    public V5QueryGroupWorker(DMRCube pCube, DMRQueryStrategy pStrategy, AdaptiveCubeletStorageManager pStorageManager, ExecutionEnvironment executionEnvironment, V5QueryGroup v5QueryGroup) {
        this.execEnv = executionEnvironment;
        this.queryGroup = v5QueryGroup;
        this.cube = pCube;
        this.strategy = pStrategy;
        this.storageManager = pStorageManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() throws Exception {
        long startTime = System.currentTimeMillis();
        ExecutionEnvironmentContext.enter(this.execEnv);
        String requestID = ((RequestEnvironment)this.execEnv.getRequestEnvironment()).getRequestID();
        Thread currentThread = Thread.currentThread();
        try {
            DQThreadContext.getInstance().addRequestThread(requestID, currentThread);
            DMRPreloadCellsLogger.logToXQELog("Start executing...");
            V5QueryResult result = this.queryGroup.execute(this.execEnv);
            DMRPreloadCellsLogger.logToXQELog("Finish executing...");
            AdaptiveCubeletStorageManager.ParamDefinition param = this.strategy.getNewParamDefinition(this.cube, this.storageManager);
            this.queryGroup.setParam(param);
            DMRPreloadCellsLogger.logToXQELog("Start iterating and populating...");
            try {
                this.strategy.iterateResults(this.queryGroup, null, result, param);
            }
            catch (Exception e) {
                DMRPreloadCellsLogger.logERRORToXQELog("I&P", e);
                throw e;
            }
            DMRPreloadCellsLogger.logToXQELog("Finish iterating and populating...");
        }
        finally {
            DQThreadContext.getInstance().removeThread(requestID, currentThread);
        }
        long endTime = System.currentTimeMillis();
        IUsageIndicator indicator = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.DMRCONCURRENTPRELOAD, "Thread " + currentThread.getId() + "|subqueryExecTime");
        indicator.add(endTime - startTime);
        return true;
    }

    public V5QueryGroup getV5QueryGroup() {
        return this.queryGroup;
    }
}

