/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination;

import com.cognos.xqe.metadata.IAccessedViaShortcut;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IShortcut;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MeasureScope {
    IMeasure measure;
    private static final int NUMBER_31 = 31;
    Map<IDimension, ILevel> dimToLevel;

    MeasureScope(List<IDimension> dimensions, IMeasure m) {
        this.measure = m;
        this.dimToLevel = new HashMap<IDimension, ILevel>(dimensions.size());
    }

    void addLevel(ILevel level, IDimension dimension) {
        this.dimToLevel.put(dimension, level);
    }

    ILevel getLowestLevel(IDimension dim) {
        ILevel level = this.dimToLevel.get(dim);
        if (level != null) {
            return level;
        }
        if (!(dim instanceof IAccessedViaShortcut)) {
            return this.dimToLevel.get(dim);
        }
        IAccessedViaShortcut accessedViaSc = (IAccessedViaShortcut)((Object)dim);
        if (!accessedViaSc.isAccessedViaShortcut()) {
            return level;
        }
        IShortcut sc = accessedViaSc.getShortcut();
        IDimension target = (IDimension)sc.getTarget();
        return this.dimToLevel.get(target);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MeasureScope)) {
            return false;
        }
        MeasureScope other = (MeasureScope)o;
        for (IDimension dim : this.dimToLevel.keySet()) {
            ILevel otherLevel;
            ILevel thisLevel = this.getLowestLevel(dim);
            if (thisLevel == (otherLevel = other.getLowestLevel(dim))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 1;
        for (ILevel level : this.dimToLevel.values()) {
            hash = hash * 31 + level.hashCode();
        }
        return hash;
    }

    public String toString() {
        return this.dimToLevel.values().toString();
    }
}

