/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.rqp.RQPPrePlan;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunctionSubtype;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp.V5OrderedValueExpression;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IAggregateRule;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.ISortItem;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.metadata.wrapper.LevelWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRDimension;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMeasure;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRProperty;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.V5QueryOverTabularStream;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.tabstream.LoadDMRCubeSingleV5Query;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.tabstream.PreLoadDMRCubeUtil;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.tabstream.PreciseCubeLoadInfo;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.metadata.Measure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.AggregationUtils;
import com.cognos.xqe.transformation.dmr.DMRPushdownQueryGenerator;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.transformation.v5.tabstream.MixedDMRRelUtil;
import com.cognos.xqe.transformation.v5tocogsql.prePlan.PrePlanUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import com.cognos.xqe.util.pushdownQuery.DMRCustomValueRefiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class LoadDMRCubeV5Query
extends LoadDMRCubeSingleV5Query {
    private static final String AGGREGATERULEQUERYNAME = "aggregateRuleQuery_";
    private static final String EXTRA_COLNAME = "ec";
    private static final int FIVE_HUNDRED = 500;
    private final PreciseCubeLoadInfo loadingInfo;
    private boolean bIsFactDrivenCustomValue = false;
    private AggregateRuleQueryGeneration aggregateRulesV5Queries = null;
    protected Set<String> skipEmbeddedFilterForDim = null;

    public LoadDMRCubeV5Query(DMRCube cube, PreciseCubeLoadInfo info, boolean b) {
        super(cube);
        this.loadingInfo = info;
        this.bNeedToSortmembers = b;
    }

    @Override
    protected boolean isSingleLoading() {
        return false;
    }

    @Override
    protected void buildCubeStreamV5QuerySet(PlanningEnvironment planningEnv, DMRUtilities.SubqueryType type) {
        if (this.buildCubeStreamV5QuerySetCustomValue(planningEnv, type)) {
            return;
        }
        if (this.buildCubeStreamV5QuerySetAggregateRules(planningEnv, type)) {
            return;
        }
        super.buildCubeStreamV5QuerySet(planningEnv, type);
    }

    protected boolean buildCubeStreamV5QuerySetCustomValue(PlanningEnvironment planningEnv, DMRUtilities.SubqueryType type) {
        Set<String> measures = this.loadingInfo.getMeasureNames();
        if (measures.size() != 1 || !PreLoadDMRCubeUtil.isMeasureForCustomValue(measures.iterator().next())) {
            return false;
        }
        this.bIsFactDrivenCustomValue = true;
        XQENodeFactory nodeFactory = planningEnv.getNodeFactory();
        planningEnv.setMetdataConnection(this.ownerCube.getConnection());
        DMRMeasure theMeasure = (DMRMeasure)this.ownerCube.getMeasure(measures.iterator().next());
        AbstractMDXNode pushdownTarget = (AbstractMDXNode)theMeasure.getBinaryExpression();
        ArrayList<DMRPushdownQueryGenerator.ContextDataItem> contextDataItemNames = new ArrayList<DMRPushdownQueryGenerator.ContextDataItem>();
        ArrayList<DMRPushdownQueryGenerator.ContextDataItem> ancestorDataItemNames = new ArrayList<DMRPushdownQueryGenerator.ContextDataItem>();
        DMRPushdownQueryGenerator generator = new DMRPushdownQueryGenerator(planningEnv, true);
        IMetadata modelMeasure = V5QueryOverTabularStream.getMeasureModel(theMeasure);
        this.querySet = generator.buildEmptyQuerySet("PushdownQuery", this.ownerCube.getConnection().getDefaultLocale(modelMeasure));
        this.querySet.setPropertyValue("customValuePushDown", true);
        DMRCustomValueRefiner cvRefiner = new DMRCustomValueRefiner(this.querySet, planningEnv, true);
        this.querySet.setPropertyValue("customValueRefiner", cvRefiner);
        int columnIdx = 0;
        ArrayList<IMember> rootMembers = new ArrayList<IMember>();
        ArrayList<List<Pair>> restrictionMembers = new ArrayList<List<Pair>>();
        List<IDimension> dims = this.ownerCube.getDimensions();
        for (int dimPos = 0; dimPos < dims.size(); ++dimPos) {
            IDimension dimension = dims.get(dimPos);
            if (dimension.isMeasuresDimension()) continue;
            for (IHierarchy hierarchy : dimension.getHierarchies()) {
                if (!this.bNeedToSortmembers) {
                    this.paramCubelet.addNonMeasureHierarchy(hierarchy);
                }
                this.nonMeasureHierarchies.add(hierarchy);
                DMRLevel loadLevel = this.getLowestLevelToLoad(hierarchy, dimPos);
                this.addlowestLevelHier(loadLevel, dimPos);
                IMember iMember = this.getHierarchyRootMember(hierarchy, dimPos);
                ((DMRMember)iMember).setGotAllChildren();
                rootMembers.add(iMember);
                if (loadLevel == null || loadLevel.getIndex() == 0) continue;
                List<DMRLevel> levels = loadLevel.getParentLevelToQueryWith();
                Collections.reverse(levels);
                for (DMRLevel level : levels) {
                    columnIdx = this.createDataItemsForLevelFactDrivenCustomValue(planningEnv, generator, level, columnIdx, contextDataItemNames);
                }
                this.getMUNRestriction(hierarchy, dimPos, restrictionMembers);
            }
        }
        this.paramCubelet.initialLevelIndex();
        StringBuilder buffer = new StringBuilder();
        generator.visit(pushdownTarget, this.querySet, contextDataItemNames, ancestorDataItemNames, buffer);
        DMRCustomValueRefiner refiner = DMRPushdownQueryGenerator.getCustomValueRefiner(this.querySet);
        refiner.refine();
        this.currentMembers = rootMembers.toArray(new IMember[rootMembers.size()]);
        this.scopeMembers = new IMember[this.currentMembers.length];
        System.arraycopy(this.currentMembers, 0, this.scopeMembers, 0, this.currentMembers.length);
        this.projectedMeasures = new ArrayList();
        this.projectedMeasures.add(theMeasure);
        this.projectedMeasuresColPos = new ArrayList();
        ArrayList<Integer> range = new ArrayList<Integer>();
        range.add(XQEIntegerPool.getInteger(columnIdx));
        this.projectedMeasuresColPos.add(range);
        this.setDefaultMeasure(theMeasure);
        List<V5Query> leafQueries = this.getLeafQueries();
        for (CogMDXDetailFilter cogMDXDetailFilter : this.ownerCube.getDetailFilters()) {
            IDimension dimension = cogMDXDetailFilter.getDimensionFromModel();
            IMetadata filterOwner = cogMDXDetailFilter.getFilterOwner();
            if (dimension != null && filterOwner != null && dimension != filterOwner || !this.isDimensionEmbeddedFilterRequired(cogMDXDetailFilter, dimension)) continue;
            for (V5Query query : leafQueries) {
                this.createDetailFilter(nodeFactory, query, cogMDXDetailFilter);
            }
        }
        for (List list : restrictionMembers) {
            for (V5Query query : leafQueries) {
                this.createDetailFilterForRestrictMember(nodeFactory, query, list);
            }
        }
        planningEnv.setRoot(this.querySet);
        this.querySet.setUnreferencedQueriesRemoved();
        this.querySet.addToIndex();
        return true;
    }

    protected int createDataItemsForLevelFactDrivenCustomValue(PlanningEnvironment planningEnv, DMRPushdownQueryGenerator generator, DMRLevel level, int columnIdx, List<DMRPushdownQueryGenerator.ContextDataItem> contextDataItemNames) {
        String expr;
        LoadDMRCubeSingleV5Query.LevelInfo info = new LoadDMRCubeSingleV5Query.LevelInfo(this);
        String keyExpr = level.getQueryItemExpressionForKey();
        info.keyPosition = columnIdx++;
        String capExpr = null;
        info.captionPosition = info.keyPosition;
        if (level.needCaptionWhenLoadMembers() && !keyExpr.equals(expr = level.getQueryItemExpressionForCaption())) {
            info.captionPosition = columnIdx++;
            capExpr = expr;
        }
        ArrayList<String> levelPros = new ArrayList<String>();
        ArrayList<Integer> colPos = new ArrayList<Integer>();
        List<String> props = this.ownerCube.getProjectedLevelProperties(level);
        HashMap<String, DMRProperty> allProps = new HashMap<String, DMRProperty>();
        List<IProperty> memberProperties = level.getMemberProperties();
        for (IProperty property : memberProperties) {
            allProps.put(property.getName(), (DMRProperty)property);
        }
        ISortItem[] levelSortItems = level.getSortItems();
        for (ISortItem sortItem : levelSortItems) {
            String n;
            DMRProperty p;
            String refObj = sortItem.getRefObject();
            String[] nameParts = UniqueNameParser.parseNoThrow(refObj);
            if (nameParts == null || nameParts.length <= 0 || (p = (DMRProperty)allProps.get(n = nameParts[nameParts.length - 1])) == null || p.isBusinessKey() || p.isMemberCaption()) continue;
            if (props == null) {
                props = new ArrayList<String>();
                props.add(n);
                continue;
            }
            if (props.contains(n)) continue;
            props.add(n);
        }
        if (props != null) {
            for (String prop : props) {
                ArrayList<DMRProperty> list;
                DMRProperty propMeta = (DMRProperty)level.getMemberProperty(prop);
                if (propMeta == null || propMeta.isDynamicProperty()) continue;
                String propExpr = propMeta.getQueryItemExpressionForKey(planningEnv);
                int propPos = -1;
                if (propExpr.equals(keyExpr)) {
                    propPos = info.keyPosition;
                } else if (propExpr.equals(capExpr)) {
                    propPos = info.captionPosition;
                } else {
                    int index = levelPros.indexOf(propExpr);
                    if (index != -1) {
                        propPos = (Integer)colPos.get(index);
                    }
                }
                if (propPos == -1) {
                    propPos = columnIdx++;
                    levelPros.add(propExpr);
                    colPos.add(propPos);
                }
                if (info.properties == null) {
                    info.properties = new HashMap();
                }
                if ((list = info.properties.get(XQEIntegerPool.getInteger(propPos))) == null) {
                    list = new ArrayList();
                    info.properties.put(XQEIntegerPool.getInteger(propPos), list);
                }
                list.add(propMeta);
            }
        }
        this.mapping.put(level, info);
        contextDataItemNames.add(generator.addLevelToV5QuerySetExplicit((LevelWrapper)level.getFMLevel(), this.querySet, keyExpr, capExpr, levelPros));
        return columnIdx;
    }

    protected List<V5Query> getLeafQueries() {
        IXQEQueryNode[] nodes;
        CubeWrapper cubeWrapper = this.ownerCube.getModelCube();
        RQPPrePlan prePlan = cubeWrapper.getRQPPrePlanQuery();
        ArrayList<V5Query> rt = new ArrayList<V5Query>();
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)this.querySet.getFirstChildByType(101055);
        String mainQuery = qrd.getRefQueryProperty();
        ArrayList<V5Query> subQueries = new ArrayList<V5Query>();
        for (IXQEQueryNode n : nodes = this.querySet.getChildrenOfType(101006)) {
            V5Query q = (V5Query)n;
            q.setPropertyValue("relationalSubquery", true);
            q.setPropertyValue("relationalSubquerySource", V5Query.RelationalSubquerySource.DMR.getName());
            q.setIsReferenced();
            if (mainQuery.equals(q.getV5QueryName())) continue;
            subQueries.add(q);
            V5Source src = q.getV5Source();
            Set<String> subs = src.getReferencedQueries();
            if (subs != null && !subs.isEmpty()) continue;
            rt.add(q);
            if (prePlan != null) {
                List<IMetadata> allJoins = PrePlanUtilities.getAllJoins(prePlan);
                q.setPropertyValue("allJoins", allJoins);
            }
            Governors governors = cubeWrapper.getGovernors();
            q.setPropertyValue("governors", governors);
        }
        IXQEQueryNode[] dataItems = this.querySet.getDescendantsOfType(101003, false);
        for (IXQEQueryNode di : dataItems) {
            V5DataItem dataItem = (V5DataItem)di;
            dataItem.setIsProjected();
            dataItem.setIsReferenced();
            dataItem.setReferencesWalked();
        }
        for (V5Query q : subQueries) {
            for (IXQEQueryNode di : dataItems = q.getDescendantsOfType(101003, false)) {
                V5DataItem dataItem = (V5DataItem)di;
                dataItem.setIsOriginal();
            }
        }
        return rt;
    }

    public void updateAllLevels(ArrayList<DMRLevel> allLevels) {
        if (allLevels.isEmpty()) {
            allLevels.addAll(this.lowestLevelHier);
        } else {
            for (int i = 0; i < this.lowestLevelHier.size(); ++i) {
                DMRLevel targetLvl;
                DMRLevel srcLvl = (DMRLevel)this.lowestLevelHier.get(i);
                if (srcLvl == null || (targetLvl = allLevels.get(i)) != null && targetLvl.getIndex() >= srcLvl.getIndex()) continue;
                allLevels.set(i, srcLvl);
            }
        }
    }

    @Override
    protected DMRLevel getLowestLevelToLoad(IHierarchy hierarchy, int dimPos) {
        ILevel lvl = this.loadingInfo.getFMLevel(dimPos);
        if (lvl == null || lvl.isRootLevel()) {
            return null;
        }
        return (DMRLevel)this.ownerCube.getWrapper(lvl);
    }

    @Override
    protected void getMUNRestriction(IHierarchy hierarchy, int dimPos, ArrayList<List<Pair>> restrictionMembers) {
        Map<Integer, TreeSet<String>> restrictions = this.loadingInfo.getLevelRestrictions(dimPos);
        if (restrictions == null || restrictions.isEmpty()) {
            return;
        }
        ArrayList<Pair> munRestriction = new ArrayList<Pair>();
        for (Map.Entry<Integer, TreeSet<String>> e : restrictions.entrySet()) {
            int lvlPos = e.getKey();
            DMRLevel dmrLevel = (DMRLevel)hierarchy.getLevel(lvlPos);
            ILevel fmLevel = dmrLevel.getFMLevel();
            for (String uMun : e.getValue()) {
                Pair p = new Pair(uMun, fmLevel);
                munRestriction.add(p);
            }
        }
        if (!munRestriction.isEmpty()) {
            restrictionMembers.add(munRestriction);
        }
    }

    @Override
    protected List<DMRMeasure> getProjectedMeasure() {
        ArrayList<DMRMeasure> rt = new ArrayList<DMRMeasure>();
        List<DMRMeasure> allmeasures = this.ownerCube.getMeasureInfo();
        Set<String> measures = this.loadingInfo.getMeasureNames();
        block0: for (String mName : measures) {
            for (DMRMeasure dmrM : allmeasures) {
                if (!dmrM.getName().equals(mName)) continue;
                rt.add(dmrM);
                continue block0;
            }
        }
        return rt;
    }

    @Override
    protected boolean rollUpIsrequired(ArrayList<DMRLevel> combination) {
        ArrayList<Integer> toCheck = new ArrayList<Integer>();
        for (DMRLevel l : combination) {
            toCheck.add(l.getIndex());
        }
        return this.loadingInfo.rollUpContains(toCheck);
    }

    @Override
    protected boolean isFilterRequired(CogMDXDetailFilter astDetailFilter) {
        IMetadata filterOwner = astDetailFilter.getFilterOwner();
        ArrayList<IMetadata> projectedCols = new ArrayList<IMetadata>();
        for (DMRLevel l : this.lowestLevelHier) {
            if (l == null) continue;
            projectedCols.add(l);
        }
        ArrayList<Measure> projectedMeas = new ArrayList<Measure>();
        projectedMeas.addAll(this.projectedMeasures);
        boolean b = V5QueryOverTabularStream.filterIsRequired(astDetailFilter, filterOwner, false, projectedMeas, projectedCols, this.ownerCube, false);
        if (b && astDetailFilter.getPropertyValue("dmrSlicer") == Boolean.TRUE) {
            ArrayList<IXQEQueryNode> outOfScopeIds = new ArrayList<IXQEQueryNode>();
            ILevel lowestL = V5QueryOverTabularStream.checkSlicerOutOfScopeLevels(astDetailFilter, projectedMeas, this.ownerCube, outOfScopeIds);
            if (!outOfScopeIds.isEmpty() && lowestL != null && lowestL.getIndex() == 0) {
                b = false;
            }
        }
        return b;
    }

    @Override
    protected boolean isDimensionEmbeddedFilterRequired(CogMDXDetailFilter astDetailFilter, IDimension dimension) {
        boolean b = dimension != null && this.skipEmbeddedFilterForDim != null && astDetailFilter.getPropertyValue("DMRMandatoryEmbeddedFilter") == null && this.skipEmbeddedFilterForDim.contains(dimension.getV5UniqueName());
        return !b;
    }

    @Override
    protected void setIsOriginalToFalse(IXQEQueryNode dataItem) {
        if (this.bIsFactDrivenCustomValue || this.aggregateRulesV5Queries != null) {
            dataItem.setPropertyValue("isOriginal", Boolean.FALSE);
        }
    }

    @Override
    protected void extractOutOfScopeDMRSlicerMembers(V5DetailFilter detailFilter) {
        if (this.bIsFactDrivenCustomValue) {
            return;
        }
        ArrayList<Measure> projectedMeas = new ArrayList<Measure>();
        projectedMeas.addAll(this.projectedMeasures);
        V5QueryOverTabularStream.extractOutOfScopeDMRSlicerMembers(detailFilter, projectedMeas, this.ownerCube);
    }

    @Override
    protected void setDefaultMeasure(DMRMeasure measure) {
    }

    @Override
    protected void setGotAllChildren(DMRMember member, boolean bLastMember) {
        DMRLevel lvl = (DMRLevel)member.getLevel();
        if (lvl.isLeafLevel() || !bLastMember) {
            member.setGotAllChildren();
        }
    }

    @Override
    protected void logFactDrivenLoadingStart() {
        if (INFO_LOGGER.isOn()) {
            INFO_LOGGER.log("Start to load cube with a fact driven sub-query for report: " + QueryStrategy.getReportName() + " loadInfo: " + this.loadingInfo.toString());
        }
    }

    public void fillMissingCellsWithNULLs() {
        IMember[][] nonMeasureSelections = new IMember[this.lowestLevelHier.size()][];
        TreeMap<Integer, Integer> maps = new TreeMap<Integer, Integer>();
        ArrayList realLevels = new ArrayList();
        int i = 0;
        int j = 0;
        for (i = 0; i < this.lowestLevelHier.size(); ++i) {
            if (this.lowestLevelHier.get(i) == null) {
                nonMeasureSelections[i] = new IMember[1];
                nonMeasureSelections[i][0] = this.currentMembers[i];
                continue;
            }
            realLevels.add(this.lowestLevelHier.get(i));
            maps.put(j, i);
            ++j;
        }
        ArrayList<ArrayList<DMRLevel>> tempLevels = null;
        for (i = 0; i < realLevels.size(); ++i) {
            tempLevels = i == 0 ? this.getLevels((DMRLevel)realLevels.get(0)) : this.crossProduct(tempLevels, this.getLevels((DMRLevel)realLevels.get(i)));
        }
        if (tempLevels != null) {
            for (ArrayList arrayList : tempLevels) {
                boolean bEmptyLevel = false;
                for (j = 0; j < arrayList.size(); ++j) {
                    List<IMember> members = ((DMRLevel)arrayList.get(j)).getMembers();
                    if (members.isEmpty()) {
                        bEmptyLevel = true;
                        break;
                    }
                    i = (Integer)maps.get(j);
                    nonMeasureSelections[i] = members.toArray(new IMember[members.size()]);
                }
                if (bEmptyLevel) continue;
                for (DMRMeasure m : this.projectedMeasures) {
                    IMember[] firstTuple = new IMember[this.currentMembers.length + 1];
                    firstTuple[this.currentMembers.length] = m;
                    for (i = 0; i < nonMeasureSelections.length; ++i) {
                        firstTuple[i] = nonMeasureSelections[i][0];
                    }
                    this.paramCubelet.updateValueMapNoValue(firstTuple, nonMeasureSelections, false);
                }
            }
        }
        this.putInStorage();
    }

    private void putInStorage() {
        try {
            this.ownerCube.getLocalCubelet().putTupleValues(this.paramCubelet);
        }
        catch (InterpreterException e) {
            throw new XQERuntimeException(e);
        }
    }

    protected boolean buildCubeStreamV5QuerySetAggregateRules(PlanningEnvironment planningEnv, DMRUtilities.SubqueryType type) {
        V5DataItem dataItem;
        List<DMRMeasure> measures = this.getProjectedMeasure();
        if (measures.isEmpty() || measures.get(0).getAggregateRules().length == 0) {
            return false;
        }
        this.aggregateRulesV5Queries = new AggregateRuleQueryGeneration();
        planningEnv.setMetdataConnection(this.ownerCube.getConnection());
        XQENodeFactory nodeFactory = planningEnv.getNodeFactory();
        CubeWrapper cubeWrapper = this.ownerCube.getModelCube();
        RQPPrePlan prePlan = cubeWrapper.getRQPPrePlanQuery();
        boolean bridgeQuery = false;
        if (prePlan != null) {
            bridgeQuery = PrePlanUtilities.isBridgeQuery(prePlan);
        }
        this.createV5QuerySet(planningEnv, nodeFactory);
        this.aggregateRulesV5Queries.aggTypes = new HashMap();
        for (DMRMeasure aMeasure : measures) {
            IAggregateRule[] rules = aMeasure.getAggregateRules();
            if (this.aggregateRulesV5Queries.nRules == -1) {
                this.aggregateRulesV5Queries.nRules = rules.length;
                AggregateRuleQueryGeneration.access$302(this.aggregateRulesV5Queries, new String[this.aggregateRulesV5Queries.nRules]);
                AggregateRuleQueryGeneration.access$402(this.aggregateRulesV5Queries, new boolean[this.aggregateRulesV5Queries.nRules]);
                for (int n = 0; n < this.aggregateRulesV5Queries.nRules; ++n) {
                    ((AggregateRuleQueryGeneration)this.aggregateRulesV5Queries).dimRefs[n] = rules[n].getDimensionRef();
                    ((AggregateRuleQueryGeneration)this.aggregateRulesV5Queries).needSorts[n] = false;
                }
            }
            AggregateTypeEnum[] aggrs = new AggregateTypeEnum[this.aggregateRulesV5Queries.nRules];
            for (int n = 0; n < this.aggregateRulesV5Queries.nRules; ++n) {
                aggrs[n] = rules[n].getAggregate();
                if (aggrs[n] != AggregateTypeEnum.FIRST && aggrs[n] != AggregateTypeEnum.LAST) continue;
                ((AggregateRuleQueryGeneration)this.aggregateRulesV5Queries).needSorts[n] = true;
            }
            this.aggregateRulesV5Queries.aggTypes.put(aMeasure, aggrs);
        }
        this.aggregateRulesV5Queries.v5Queries = new ArrayList(this.aggregateRulesV5Queries.nRules + 1);
        IXQEQueryNode theQuery = this.createV5Query(planningEnv, nodeFactory, type);
        theQuery.setPropertyValue("name", "aggregateRuleQuery_0");
        this.aggregateRulesV5Queries.v5Queries.add((V5Query)theQuery);
        this.createV5Source(nodeFactory, theQuery);
        theQuery.addChild(nodeFactory.createNode(101009));
        int i = 0;
        for (i = 0; i < this.aggregateRulesV5Queries.nRules; ++i) {
            theQuery = nodeFactory.createNode(101006);
            this.querySet.addChild(theQuery);
            this.aggregateRulesV5Queries.v5Queries.add((V5Query)theQuery);
            theQuery.setPropertyValue("name", AGGREGATERULEQUERYNAME + (i + 1));
            theQuery.setPropertyValue("relationalSubquery", true);
            V5Source source = (V5Source)nodeFactory.createNode(101007);
            source.setPropertyValue("relational", true);
            theQuery.addChild(source);
            source.setQueryRef(AGGREGATERULEQUERYNAME + i);
            theQuery.addChild(nodeFactory.createNode(101009));
            String dimName = this.aggregateRulesV5Queries.dimRefs[i];
            DMRDimension[] dims = DMRUtilities.getDMRDimensionsFromMFWDimensionUniqueName(dimName, this.ownerCube);
            int nLevels = dims[0].getLevelCount();
            DMRLevel lowestLevel = V5QueryOverTabularStream.getLowestLevelFromScope(measures.get(0), dims[0].getLevel(nLevels - 1));
            this.aggregateRulesV5Queries.lowestLevels.add(lowestLevel);
            this.aggregateRulesV5Queries.extraLevels.add(new ArrayList());
            this.aggregateRulesV5Queries.aggrRuleSorts.add(new ArrayList());
            this.aggregateRulesV5Queries.unPorjectedAggrDimKeyItems.add(new ArrayList());
            this.aggregateRulesV5Queries.allExtraItems.add(new TreeSet());
        }
        theQuery.setPropertyValue("name", "singleTabularQuery");
        this.createGroupBody(nodeFactory, theQuery);
        int columnIdx = 0;
        ArrayList<IMember> rootMembers = new ArrayList<IMember>();
        ArrayList<List<Pair>> restrictionMembers = new ArrayList<List<Pair>>();
        ArrayList<IDimension> includedDimensions = new ArrayList<IDimension>();
        List<IDimension> dims = this.ownerCube.getDimensions();
        for (int dimPos = 0; dimPos < dims.size(); ++dimPos) {
            IDimension dimension = dims.get(dimPos);
            if (dimension.isMeasuresDimension()) continue;
            boolean bl = false;
            for (IHierarchy iHierarchy : dimension.getHierarchies()) {
                if (!this.bNeedToSortmembers) {
                    this.paramCubelet.addNonMeasureHierarchy(iHierarchy);
                }
                this.nonMeasureHierarchies.add(iHierarchy);
                DMRLevel loadLevel = this.getLowestLevelToLoad(iHierarchy, dimPos);
                if (loadLevel != null) {
                    bl = true;
                }
                this.addlowestLevelHier(loadLevel, dimPos);
                IMember rootMember = this.getHierarchyRootMember(iHierarchy, dimPos);
                ((DMRMember)rootMember).setGotAllChildren();
                rootMembers.add(rootMember);
                if (loadLevel == null || loadLevel.getIndex() == 0) {
                    this.aggregateRulesV5Queries.setCurrentAggrRule(dimension);
                    this.aggregateRulesV5Queries.addExtraLevels(0);
                    continue;
                }
                List<DMRLevel> levels = loadLevel.getParentLevelToQueryWith();
                Collections.reverse(levels);
                this.aggregateRulesV5Queries.setCurrentAggrRule(dimension);
                for (DMRLevel level : levels) {
                    columnIdx = this.createDataItemsForLevelAggrRules(planningEnv, nodeFactory, level, columnIdx, null);
                }
                this.aggregateRulesV5Queries.addExtraLevels(loadLevel.getIndex());
                this.getMUNRestriction(iHierarchy, dimPos, restrictionMembers);
            }
            if (!bl) continue;
            includedDimensions.add(dimension);
        }
        this.paramCubelet.initialLevelIndex();
        this.addExtraLevelsIntoV5Queries(planningEnv, nodeFactory);
        this.currentMembers = rootMembers.toArray(new IMember[rootMembers.size()]);
        this.scopeMembers = new IMember[this.currentMembers.length];
        System.arraycopy(this.currentMembers, 0, this.scopeMembers, 0, this.currentMembers.length);
        this.projectedMeasures = this.getProjectedMeasure();
        this.projectedMeasuresColPos = new ArrayList();
        for (DMRMeasure measure : this.projectedMeasures) {
            this.setDefaultMeasure(measure);
            columnIdx = this.createDataItemsForMeasureAggrRules(planningEnv, bridgeQuery, nodeFactory, measure, columnIdx);
        }
        IXQEQueryNode[] dataItems = this.querySet.getDescendantsOfType(101003, false);
        for (IXQEQueryNode iXQEQueryNode : dataItems) {
            dataItem = (V5DataItem)iXQEQueryNode;
            dataItem.setIsProjected();
            dataItem.setIsReferenced();
            dataItem.setReferencesWalked();
        }
        for (i = 0; i < this.aggregateRulesV5Queries.v5Queries.size() - 1; ++i) {
            dataItems = ((V5Query)this.aggregateRulesV5Queries.v5Queries.get(i)).getDescendantsOfType(101003, false);
            for (IXQEQueryNode iXQEQueryNode : dataItems) {
                dataItem = (V5DataItem)iXQEQueryNode;
                dataItem.setIsOriginal();
            }
        }
        for (CogMDXDetailFilter cogMDXDetailFilter : this.ownerCube.getDetailFilters()) {
            IDimension dimension = cogMDXDetailFilter.getDimensionFromModel();
            IMetadata iMetadata = cogMDXDetailFilter.getFilterOwner();
            if (dimension != null && iMetadata != null && dimension != iMetadata || !this.isFilterRequired(cogMDXDetailFilter) || !this.isDimensionEmbeddedFilterRequired(cogMDXDetailFilter, dimension)) continue;
            this.createDetailFilter(nodeFactory, (IXQEQueryNode)this.aggregateRulesV5Queries.v5Queries.get(0), cogMDXDetailFilter);
        }
        for (List list : restrictionMembers) {
            this.createDetailFilterForRestrictMember(nodeFactory, (IXQEQueryNode)this.aggregateRulesV5Queries.v5Queries.get(0), list);
        }
        planningEnv.setRoot(this.querySet);
        this.querySet.setUnreferencedQueriesRemoved();
        this.querySet.addToIndex();
        return true;
    }

    @Override
    protected IMember getHierarchyRootMember(IHierarchy hierarchy, int dimPos) {
        hierarchy.getDefaultMember();
        boolean bDefaultMemberIgnoreEmbeddedFilter = this.isDefaultMemberIgnoreEmbeddedFilter(dimPos);
        if (!bDefaultMemberIgnoreEmbeddedFilter) {
            return ((DMRLevel)hierarchy.getLevel(0)).getMember(0);
        }
        if (this.skipEmbeddedFilterForDim == null) {
            this.skipEmbeddedFilterForDim = new HashSet<String>();
        }
        this.skipEmbeddedFilterForDim.add(hierarchy.getDimension().getV5UniqueName());
        return hierarchy.getDefaultMember();
    }

    @Override
    protected boolean isDefaultMemberIgnoreEmbeddedFilter(int dimPos) {
        Map<Integer, TreeSet<String>> restrictions = this.loadingInfo.getLevelRestrictions(dimPos);
        if (restrictions == null || restrictions.size() != 1) {
            return false;
        }
        Integer levelId = restrictions.keySet().iterator().next();
        if (levelId != 0) {
            return false;
        }
        TreeSet<String> s = restrictions.get(levelId);
        return s.size() == 1 && "Hierarchy_Default_Member".equals(s.iterator().next());
    }

    protected int createDataItemsForLevelAggrRules(PlanningEnvironment planningEnv, XQENodeFactory nodeFactory, DMRLevel level, int columnIdx, Set<String> extraCols) {
        LoadDMRCubeSingleV5Query.LevelInfo info = new LoadDMRCubeSingleV5Query.LevelInfo(this);
        String colName = "c";
        if (extraCols != null) {
            colName = EXTRA_COLNAME;
        }
        boolean bNeedSortItems = this.aggregateRulesV5Queries.needSortItems();
        String keyName = null;
        IXQEQueryNode expression = this.getExpressionForLevelProp(planningEnv, nodeFactory, level, "key");
        info.keyPosition = this.getExistingExpression(expression, "none");
        if (info.keyPosition == -1) {
            info.keyPosition = columnIdx;
            keyName = extraCols == null ? this.addDataItemAggrRule(nodeFactory, "none", info.keyPosition, expression) : this.addDataItemAggrRuleInBase(nodeFactory, "none", info.keyPosition, expression, colName);
            ++columnIdx;
        } else {
            keyName = colName + info.keyPosition;
        }
        this.aggregateRulesV5Queries.keyItems.add(keyName);
        if (extraCols != null) {
            List unProjected = (List)this.aggregateRulesV5Queries.unPorjectedAggrDimKeyItems.get(this.aggregateRulesV5Queries.currentAggrRule);
            unProjected.add(keyName);
            Set allExtra = (Set)this.aggregateRulesV5Queries.allExtraItems.get(this.aggregateRulesV5Queries.currentAggrRule);
            allExtra.add(keyName);
            extraCols.add(keyName);
        }
        String aggrTypeLevelAttr = this.getAggregateForLevelAttributes(level, this.getGovernors());
        info.captionPosition = info.keyPosition;
        String capName = null;
        if ((extraCols == null || bNeedSortItems && level.getSortItems().length == 0) && level.needCaptionWhenLoadMembers()) {
            expression = this.getExpressionForLevelProp(planningEnv, nodeFactory, level, "caption");
            info.captionPosition = this.getExistingExpression(expression, aggrTypeLevelAttr);
            if (info.captionPosition == -1) {
                info.captionPosition = columnIdx;
                capName = extraCols == null ? this.addDataItemAggrRule(nodeFactory, aggrTypeLevelAttr, info.captionPosition, expression) : this.addDataItemAggrRuleInBase(nodeFactory, aggrTypeLevelAttr, info.captionPosition, expression, colName);
                ++columnIdx;
            } else {
                capName = colName + info.captionPosition;
            }
            if (extraCols != null) {
                Set allExtra = (Set)this.aggregateRulesV5Queries.allExtraItems.get(this.aggregateRulesV5Queries.currentAggrRule);
                allExtra.add(capName);
                extraCols.add(capName);
            }
        }
        if (extraCols == null || bNeedSortItems) {
            List<String> props = this.ownerCube.getProjectedLevelProperties(level);
            HashMap<String, DMRProperty> allProps = new HashMap<String, DMRProperty>();
            List<IProperty> memberProperties = level.getMemberProperties();
            for (IProperty property : memberProperties) {
                allProps.put(property.getName(), (DMRProperty)property);
            }
            ISortItem[] levelSortItems = level.getSortItems();
            for (ISortItem sortItem : levelSortItems) {
                String n;
                DMRProperty p;
                String refObj = sortItem.getRefObject();
                String[] nameParts = UniqueNameParser.parseNoThrow(refObj);
                if (nameParts == null || nameParts.length <= 0 || (p = (DMRProperty)allProps.get(n = nameParts[nameParts.length - 1])) == null || p.isBusinessKey() || p.isMemberCaption()) continue;
                if (props == null) {
                    props = new ArrayList<String>();
                    props.add(n);
                    continue;
                }
                if (props.contains(n)) continue;
                props.add(n);
            }
            if (props != null) {
                for (String prop : props) {
                    ArrayList<DMRProperty> list;
                    DMRProperty propMeta = (DMRProperty)level.getMemberProperty(prop);
                    if (propMeta == null || propMeta.isDynamicProperty()) continue;
                    expression = this.getExpressionForLevelProp(planningEnv, nodeFactory, level, propMeta);
                    int propPos = this.getExistingExpression(expression, aggrTypeLevelAttr);
                    if (propPos == -1) {
                        propPos = columnIdx;
                        String propName = null;
                        if (extraCols == null) {
                            propName = this.addDataItemAggrRule(nodeFactory, aggrTypeLevelAttr, propPos, expression);
                        } else {
                            propName = this.addDataItemAggrRuleInBase(nodeFactory, aggrTypeLevelAttr, propPos, expression, colName);
                            Set allExtra = (Set)this.aggregateRulesV5Queries.allExtraItems.get(this.aggregateRulesV5Queries.currentAggrRule);
                            allExtra.add(propName);
                            extraCols.add(propName);
                        }
                        ++columnIdx;
                    }
                    if (info.properties == null) {
                        info.properties = new HashMap();
                    }
                    if ((list = info.properties.get(XQEIntegerPool.getInteger(propPos))) == null) {
                        list = new ArrayList();
                        info.properties.put(XQEIntegerPool.getInteger(propPos), list);
                    }
                    list.add(propMeta);
                }
            }
        }
        if (extraCols == null) {
            this.mapping.put(level, info);
        }
        if (bNeedSortItems) {
            this.addSortInfo(level, info, capName, keyName, colName);
        }
        return columnIdx;
    }

    protected void addSortInfo(DMRLevel level, LoadDMRCubeSingleV5Query.LevelInfo info, String cap, String key, String colName) {
        List s = (List)this.aggregateRulesV5Queries.aggrRuleSorts.get(this.aggregateRulesV5Queries.currentAggrRule);
        ISortItem[] levelSortItems = level.getSortItems();
        if (levelSortItems.length == 0) {
            Pair p;
            if (cap != null && !cap.equals(key)) {
                p = new Pair(cap, new Integer(1));
                s.add(p);
            }
            p = new Pair(key, new Integer(1));
            s.add(p);
        } else {
            HashMap<String, DMRProperty> allProps = new HashMap<String, DMRProperty>();
            List<IProperty> memberProperties = level.getMemberProperties();
            for (IProperty property : memberProperties) {
                allProps.put(property.getName(), (DMRProperty)property);
            }
            for (ISortItem sortItem : levelSortItems) {
                String n;
                DMRProperty prop;
                String refObj = sortItem.getRefObject();
                String[] nameParts = UniqueNameParser.parseNoThrow(refObj);
                if (nameParts == null || nameParts.length <= 0 || (prop = (DMRProperty)allProps.get(n = nameParts[nameParts.length - 1])) == null) continue;
                int pos = 0;
                if (prop.isBusinessKey()) {
                    pos = info.keyPosition;
                } else if (prop.isMemberCaption()) {
                    pos = info.captionPosition;
                } else {
                    for (Map.Entry<Integer, ArrayList<DMRProperty>> e : info.properties.entrySet()) {
                        int propColumnNum = e.getKey();
                        ArrayList<DMRProperty> createdProps = e.getValue();
                        if (!createdProps.contains(prop)) continue;
                        pos = propColumnNum;
                        break;
                    }
                }
                ISortItem.SortType st = sortItem.getSort();
                String sItem = colName + pos;
                int sd = 1;
                if (st == ISortItem.SortType.DESCENDING) {
                    sd = 2;
                }
                Pair p = new Pair(sItem, new Integer(sd));
                s.add(p);
            }
        }
    }

    protected String addDataItemAggrRule(XQENodeFactory nodeFactory, String aggr, int pos, IXQEQueryNode expression) {
        this.selection = ((V5Query)this.aggregateRulesV5Queries.v5Queries.get(0)).getV5Selection();
        V5DataItem dataItem = (V5DataItem)nodeFactory.createNode(101003);
        dataItem.setPropertyValue("aggregate", aggr);
        String dataItemName = "c" + pos;
        dataItem.setPropertyValue("name", dataItemName);
        this.selection.addChild(dataItem);
        dataItem.addChild(expression);
        for (int i = 1; i < this.aggregateRulesV5Queries.v5Queries.size(); ++i) {
            String preQName = ((V5Query)this.aggregateRulesV5Queries.v5Queries.get(i - 1)).getV5QueryName();
            this.selection = ((V5Query)this.aggregateRulesV5Queries.v5Queries.get(i)).getV5Selection();
            dataItem = (V5DataItem)nodeFactory.createNode(101003);
            dataItem.setPropertyValue("aggregate", aggr);
            dataItem.setPropertyValue("name", dataItemName);
            this.selection.addChild(dataItem);
            V5MultiPartIdentifier dataItemIdentifier = (V5MultiPartIdentifier)nodeFactory.createNode(201030);
            dataItemIdentifier.setIdentifier(UniqueNameGenerator.createUniqueName(preQName, dataItemName));
            dataItem.addChild(dataItemIdentifier);
        }
        IXQEQueryNode dataItemRef = nodeFactory.createNode(101015);
        dataItemRef.setPropertyValue("refDataItem", dataItemName);
        this.groupBody.addChild(dataItemRef);
        return dataItemName;
    }

    protected void addExtraLevelsIntoV5Queries(PlanningEnvironment planningEnv, XQENodeFactory nodeFactory) {
        TreeSet<String> extraCols = new TreeSet<String>();
        int i = 0;
        for (i = 0; i < this.aggregateRulesV5Queries.extraLevels.size(); ++i) {
            this.aggregateRulesV5Queries.currentAggrRule = i;
            for (DMRLevel level : (List)this.aggregateRulesV5Queries.extraLevels.get(i)) {
                this.aggregateRulesV5Queries.extraColId = this.createDataItemsForLevelAggrRules(planningEnv, nodeFactory, level, this.aggregateRulesV5Queries.extraColId, extraCols);
            }
        }
        for (i = 1; i < this.aggregateRulesV5Queries.v5Queries.size() - 1; ++i) {
            Set<String> s = this.getExtraColumnsInRule(i - 1);
            extraCols.removeAll(s);
            String preQName = ((V5Query)this.aggregateRulesV5Queries.v5Queries.get(i - 1)).getV5QueryName();
            this.selection = ((V5Query)this.aggregateRulesV5Queries.v5Queries.get(i)).getV5Selection();
            for (String nm : extraCols) {
                V5DataItem dataItem = (V5DataItem)nodeFactory.createNode(101003);
                dataItem.setPropertyValue("aggregate", "none");
                dataItem.setPropertyValue("name", nm);
                this.selection.addChild(dataItem);
                V5MultiPartIdentifier dataItemIdentifier = (V5MultiPartIdentifier)nodeFactory.createNode(201030);
                dataItemIdentifier.setIdentifier(UniqueNameGenerator.createUniqueName(preQName, nm));
                dataItem.addChild(dataItemIdentifier);
            }
        }
    }

    protected Set<String> getExtraColumnsInRule(int pos) {
        TreeSet<String> rt = new TreeSet<String>((Collection)this.aggregateRulesV5Queries.allExtraItems.get(pos));
        return rt;
    }

    protected String addDataItemAggrRuleInBase(XQENodeFactory nodeFactory, String aggr, int pos, IXQEQueryNode expression, String colName) {
        this.selection = ((V5Query)this.aggregateRulesV5Queries.v5Queries.get(0)).getV5Selection();
        V5DataItem dataItem = (V5DataItem)nodeFactory.createNode(101003);
        dataItem.setPropertyValue("aggregate", aggr);
        String dataItemName = colName + pos;
        dataItem.setPropertyValue("name", dataItemName);
        this.selection.addChild(dataItem);
        dataItem.addChild(expression);
        return dataItemName;
    }

    protected int createDataItemsForMeasureAggrRules(PlanningEnvironment planningEnv, boolean bridgeQuery, XQENodeFactory nodeFactory, DMRMeasure measure, int columnIdx) {
        String measureColName = "c" + columnIdx;
        columnIdx = this.createDataItemsForMeasureAggrRulesInBase(planningEnv, bridgeQuery, nodeFactory, measure, columnIdx);
        TreeSet allKeyItems = new TreeSet(this.aggregateRulesV5Queries.keyItems);
        for (int i = 1; i < this.aggregateRulesV5Queries.v5Queries.size(); ++i) {
            allKeyItems.removeAll((Collection)this.aggregateRulesV5Queries.unPorjectedAggrDimKeyItems.get(i - 1));
            String preQName = ((V5Query)this.aggregateRulesV5Queries.v5Queries.get(i - 1)).getV5QueryName();
            this.selection = ((V5Query)this.aggregateRulesV5Queries.v5Queries.get(i)).getV5Selection();
            V5DataItem dataItem = (V5DataItem)nodeFactory.createNode(101003);
            dataItem.setPropertyValue("aggregate", "calculated");
            dataItem.setPropertyValue("name", measureColName);
            this.selection.addChild(dataItem);
            V5MultiPartIdentifier dataItemIdentifier = (V5MultiPartIdentifier)nodeFactory.createNode(201030);
            dataItemIdentifier.setIdentifier(UniqueNameGenerator.createUniqueName(preQName, measureColName));
            AggregateTypeEnum aggrType = ((AggregateTypeEnum[])this.aggregateRulesV5Queries.aggTypes.get(measure))[i - 1];
            V5AggregateFunction aggrFunc = null;
            if (aggrType == AggregateTypeEnum.FIRST || aggrType == AggregateTypeEnum.LAST) {
                aggrFunc = (V5AggregateFunction)nodeFactory.createNode(201033);
                if (aggrType == AggregateTypeEnum.FIRST) {
                    aggrFunc.setSubType(12);
                } else {
                    aggrFunc.setSubType(13);
                }
            } else {
                aggrFunc = (V5AggregateFunction)nodeFactory.createNode(201031);
                if (aggrType == AggregateTypeEnum.MIN) {
                    aggrFunc.setSubType(6);
                } else if (aggrType == AggregateTypeEnum.MAX) {
                    aggrFunc.setSubType(4);
                } else if (aggrType == AggregateTypeEnum.AVG) {
                    aggrFunc.setSubType(1);
                } else {
                    aggrFunc.setSubType(9);
                }
            }
            dataItem.addChild(aggrFunc);
            aggrFunc.addChild(dataItemIdentifier);
            V5AggregateBreakClause forClause = (V5AggregateBreakClause)nodeFactory.createNode(201037);
            aggrFunc.addChild(forClause);
            if (allKeyItems.isEmpty()) {
                forClause.setSubType(0);
            } else {
                for (String kCol : allKeyItems) {
                    IXQEQueryNode item = DMRUtilities.createColumnMeasureRef(nodeFactory, kCol);
                    forClause.addChild(item);
                }
            }
            if (aggrType != AggregateTypeEnum.FIRST && aggrType != AggregateTypeEnum.LAST) continue;
            TreeSet keyItems = new TreeSet(allKeyItems);
            Set<String> s = this.getExtraColumnsInRule(i - 1);
            keyItems.removeAll(s);
            for (String k : keyItems) {
                V5OrderedValueExpression orderedValueExpr = (V5OrderedValueExpression)nodeFactory.createNode(201114);
                orderedValueExpr.setSubType(1);
                IXQEQueryNode item = DMRUtilities.createColumnMeasureRef(nodeFactory, k);
                orderedValueExpr.addChild(item);
                aggrFunc.addChild(orderedValueExpr);
            }
            List dimSort = (List)this.aggregateRulesV5Queries.aggrRuleSorts.get(i - 1);
            for (Pair p : dimSort) {
                V5OrderedValueExpression orderedValueExpr = (V5OrderedValueExpression)nodeFactory.createNode(201114);
                int st = (Integer)p.getSecond();
                orderedValueExpr.setSubType(st);
                V5MultiPartIdentifier item = (V5MultiPartIdentifier)nodeFactory.createNode(201030);
                item.setIdentifier(UniqueNameGenerator.createUniqueName(preQName, (String)p.getFirst()));
                orderedValueExpr.addChild(item);
                aggrFunc.addChild(orderedValueExpr);
            }
        }
        IXQEQueryNode dataItemRef = nodeFactory.createNode(101015);
        dataItemRef.setPropertyValue("refDataItem", measureColName);
        this.groupBody.addChild(dataItemRef);
        return columnIdx;
    }

    protected int createDataItemsForMeasureAggrRulesInBase(PlanningEnvironment planningEnv, boolean bridgeQuery, XQENodeFactory nodeFactory, DMRMeasure measure, int columnIdx) {
        String aggregateAttribute = measure.getV5AggregateAttribute();
        if (AggregationUtils.isNoneCalculatedOrAutomaticAggregate(aggregateAttribute)) {
            aggregateAttribute = measure.getV5AggregateForModelAggregate();
        }
        IXQEQueryNode measureExpr = null;
        IXQEQueryNode expression = measure.getBinaryExpression();
        if (expression != null) {
            expression = nodeFactory.deepCopyNode(expression);
            if (this.clonedSrc != null) {
                MixedDMRRelUtil.reBindReferences(nodeFactory, expression, this.clonedSrc, this.querySet);
            }
            this.unwindWrapObjects(planningEnv, nodeFactory, expression);
        } else {
            String measureExprStr = measure.getQueryItemExpression(planningEnv);
            expression = DMRUtilities.createExpression(nodeFactory, measureExprStr);
            measureExpr = RQPUtilities.createV5ValueExpressionMetadata(measureExprStr, planningEnv, null, V5QueryOverTabularStream.getMeasureModel(measure));
        }
        String measureAggrType = aggregateAttribute;
        if (measureAggrType == null || measureAggrType.equals(AggregateTypeEnum.UNSUPPORTED.toV5Type()) || measureAggrType.equals(AggregateTypeEnum.UNKNOWN.toV5Type()) || measureAggrType.equals("notApplicable")) {
            int subtype = RQPUtilities.getDefaultAggregateBasedOnDataType(measure.getDataType());
            measureAggrType = V5AggregateFunctionSubtype.getName(subtype);
        }
        int measurePos = this.getExistingExpression(expression, measureAggrType);
        String measureReferenceName = "c";
        if (measurePos == -1) {
            this.selection = ((V5Query)this.aggregateRulesV5Queries.v5Queries.get(0)).getV5Selection();
            measurePos = columnIdx;
            measureReferenceName = "RefMeasure";
            IXQEQueryNode dataItem = nodeFactory.createNode(101003);
            dataItem.setPropertyValue("aggregate", measureAggrType);
            dataItem.setPropertyValue("name", "RefMeasure" + columnIdx);
            dataItem.addChild(expression);
            this.selection.addChild(dataItem);
            IXQEQueryNode dataItemIdentifier = DMRUtilities.createColumnMeasureRef(nodeFactory, measureReferenceName + columnIdx);
            expression = nodeFactory.createNode(201031);
            if (measureExpr != null && measureExpr.getType() == 201031 && ((V5ValueSummaryFunction)measureExpr).getSubType() == 43) {
                ((V5ValueSummaryFunction)expression).setSubType(43);
                ((V5ValueSummaryFunction)expression).setNativeName(((V5ValueSummaryFunction)measureExpr).getNativeName());
            } else {
                AggregationUtils.convertAggregateNameToV5AggregateFunctionSubtype(planningEnv, measure.getUniqueName(), aggregateAttribute, (V5ValueSummaryFunction)expression, measure.getDataType(), this.ownerCube.getDecomposeCalculatedMeasure());
            }
            expression.addChild(dataItemIdentifier);
            V5AggregateBreakClause forClause = (V5AggregateBreakClause)nodeFactory.createNode(201037);
            expression.addChild(forClause);
            if (this.aggregateRulesV5Queries.keyItems.isEmpty() || measure.getName().equals("TBDummyMeasureName")) {
                forClause.setSubType(0);
            } else {
                for (String kCol : this.aggregateRulesV5Queries.keyItems) {
                    dataItemIdentifier = DMRUtilities.createColumnMeasureRef(nodeFactory, kCol);
                    forClause.addChild(dataItemIdentifier);
                }
            }
            this.addDataItemAggrRuleInBase(nodeFactory, AggregateTypeEnum.CALCULATED.toV5Type(), measurePos, expression, "c");
            ++columnIdx;
        }
        ArrayList<Integer> range = new ArrayList<Integer>();
        range.add(XQEIntegerPool.getInteger(measurePos));
        this.projectedMeasuresColPos.add(range);
        return columnIdx;
    }

    private final class AggregateRuleQueryGeneration {
        private int extraColId = 500;
        private int nRules = -1;
        private String[] dimRefs;
        private boolean[] needSorts;
        private HashMap<DMRMeasure, AggregateTypeEnum[]> aggTypes;
        private List<V5Query> v5Queries;
        private List<String> keyItems = new ArrayList<String>();
        private List<DMRLevel> lowestLevels = new ArrayList<DMRLevel>();
        private List<List<DMRLevel>> extraLevels = new ArrayList<List<DMRLevel>>();
        private List<List<Pair>> aggrRuleSorts = new ArrayList<List<Pair>>();
        private List<List<String>> unPorjectedAggrDimKeyItems = new ArrayList<List<String>>();
        private List<Set<String>> allExtraItems = new ArrayList<Set<String>>();
        private int currentAggrRule = -1;

        private AggregateRuleQueryGeneration() {
        }

        private void setCurrentAggrRule(IDimension dimension) {
            this.currentAggrRule = -1;
            for (int i = 0; i < this.lowestLevels.size(); ++i) {
                if (!this.lowestLevels.get(i).getDimension().equals(dimension)) continue;
                this.currentAggrRule = i;
                return;
            }
        }

        private void addExtraLevels(int pre) {
            if (this.currentAggrRule == -1 || pre < 0) {
                return;
            }
            List<DMRLevel> rt = this.extraLevels.get(this.currentAggrRule);
            int lowest = this.lowestLevels.get(this.currentAggrRule).getIndex();
            if (lowest > pre) {
                for (DMRLevel currentLevel = this.lowestLevels.get(this.currentAggrRule); currentLevel != null && currentLevel.getIndex() > pre; currentLevel = (DMRLevel)currentLevel.getPreviousLevel()) {
                    rt.add(currentLevel);
                }
            }
            Collections.reverse(rt);
        }

        private boolean needSortItems() {
            if (this.currentAggrRule == -1) {
                return false;
            }
            return this.needSorts[this.currentAggrRule];
        }

        static /* synthetic */ String[] access$302(AggregateRuleQueryGeneration x0, String[] x1) {
            x0.dimRefs = x1;
            return x1;
        }

        static /* synthetic */ boolean[] access$402(AggregateRuleQueryGeneration x0, boolean[] x1) {
            x0.needSorts = x1;
            return x1;
        }
    }
}

