/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.metadata.IAggregateRule;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.IIterator;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMeasure;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.V5QueryOverTabularStream;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.tabstream.DMRCubeForPreciseLoading;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.tabstream.PreLoadDMRCubeUtil;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Measure;
import com.cognos.xqe.transformation.v5tocogsql.prePlan.SetOfTables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class PreciseCubeLoadInfo {
    private TreeMap<Integer, LevelLoadInfo> levelInfo = new TreeMap();
    private MeasureGroupingKey measureKey;
    private TreeMap<String, MeasureLoadInfo> measureInfo = new TreeMap();

    public String toString() {
        return "{Levels: " + this.levelInfo.toString() + " Measures: " + this.measureInfo.toString() + "}";
    }

    public ILevel getFMLevel(int dimPos) {
        LevelLoadInfo lvlInfo = this.levelInfo.get(dimPos);
        if (lvlInfo != null) {
            return lvlInfo.fmLevel;
        }
        return null;
    }

    public Map<Integer, TreeSet<String>> getLevelRestrictions(int dimPos) {
        LevelLoadInfo lvlInfo = this.levelInfo.get(dimPos);
        if (lvlInfo != null) {
            return lvlInfo.restriction;
        }
        return null;
    }

    public Set<String> getMeasureNames() {
        return this.measureInfo.keySet();
    }

    public boolean rollUpContains(ArrayList<Integer> toCheck) {
        for (MeasureLoadInfo m : this.measureInfo.values()) {
            if (!m.rollUps.contains(toCheck)) continue;
            return true;
        }
        return false;
    }

    public static void createFactDrivenPreciseLoadingDefinition(DMRCubeForPreciseLoading cb, CrossJoinedSet cjs, List<PreciseCubeLoadInfo> loadInfos) {
        List<IDimension> dimensions = cb.getDimensions();
        TreeMap<Integer, HashSet<DMRMember>> memberByDimPos = new TreeMap<Integer, HashSet<DMRMember>>();
        HashSet<DMRMeasure> measures = new HashSet<DMRMeasure>();
        IIterator it = cjs.dimensionOrderedIterator(dimensions.toArray(new Dimension[dimensions.size()]));
        while (it.hasNext()) {
            Tuple t = (Tuple)it.next();
            IMember[] members = t.getMembers();
            for (int i = 0; i < members.length; ++i) {
                IMember mb = members[i];
                if (mb instanceof DMRMeasure) {
                    measures.add((DMRMeasure)mb);
                    continue;
                }
                DMRMember member = (DMRMember)mb;
                HashSet<DMRMember> mbs = memberByDimPos.get(i);
                if (mbs == null) {
                    mbs = new HashSet();
                    memberByDimPos.put(i, mbs);
                }
                mbs.add(member);
            }
        }
        for (DMRMeasure m : measures) {
            PreciseCubeLoadInfo info = new PreciseCubeLoadInfo();
            TreeMap<Integer, HashSet<DMRMember>> adjsuted = new TreeMap<Integer, HashSet<DMRMember>>();
            MeasureGroupingKey key = PreciseCubeLoadInfo.createMeasureKeyAndAdjustScope(cb, info, adjsuted, m, memberByDimPos);
            boolean btrymerge = !PreLoadDMRCubeUtil.isMeasureForCustomValue(m.getName());
            PreciseCubeLoadInfo.addPreciseLoadInfo(info, key, adjsuted, m, loadInfos, btrymerge);
        }
    }

    private static void addPreciseLoadInfo(PreciseCubeLoadInfo info, MeasureGroupingKey key, TreeMap<Integer, HashSet<DMRMember>> adjsuted, DMRMeasure m, List<PreciseCubeLoadInfo> loadInfos, boolean bTrymerge) {
        if (bTrymerge) {
            for (PreciseCubeLoadInfo aInfo : loadInfos) {
                int c;
                if (!aInfo.measureKey.equals(key) || (c = aInfo.checkCompatible(adjsuted)) < 0) continue;
                if (c == 0) {
                    aInfo.addNewMeasure(adjsuted, m);
                    return;
                }
                if (!aInfo.measureInfo.containsKey(m.getName())) continue;
                aInfo.addRollUpMeasure(adjsuted, m);
                return;
            }
        }
        info.addLevelAndRestriction(adjsuted);
        info.addMeasure(key, m);
        loadInfos.add(info);
    }

    private static MeasureGroupingKey createMeasureKeyAndAdjustScope(DMRCubeForPreciseLoading cb, PreciseCubeLoadInfo info, TreeMap<Integer, HashSet<DMRMember>> adjsuted, DMRMeasure measure, TreeMap<Integer, HashSet<DMRMember>> muns) {
        MeasureGroupingKey key = info.createMeasureKey(measure.getInvolvedTables());
        if (!PreLoadDMRCubeUtil.isMeasureForCustomValue(measure.getName())) {
            IAggregateRule[] rules;
            for (IAggregateRule r : rules = measure.getAggregateRules()) {
                String dim = r.getDimensionRef();
                key.dimensionsInAggrRule.add(dim);
            }
            ArrayList<Measure> projectedMeasures = new ArrayList<Measure>();
            projectedMeasures.add(measure);
            for (CogMDXDetailFilter aDetailFilter : cb.getDetailFilters()) {
                if (aDetailFilter.getPropertyValue("dmrSlicer") != Boolean.TRUE) continue;
                ArrayList<IXQEQueryNode> outOfScopeIds = new ArrayList<IXQEQueryNode>();
                ILevel lowestL = V5QueryOverTabularStream.checkSlicerOutOfScopeLevels(aDetailFilter, projectedMeasures, cb, outOfScopeIds);
                if (outOfScopeIds.isEmpty() || lowestL == null) continue;
                key.slicerSope.put(lowestL.getHierarchy().getDimension().getUniqueName(), lowestL.getIndex());
            }
        }
        for (Map.Entry<Integer, HashSet<DMRMember>> e : muns.entrySet()) {
            HashSet<DMRMember> scopedMUNs = PreciseCubeLoadInfo.getScopedMUNs(measure, e.getValue());
            adjsuted.put(e.getKey(), scopedMUNs);
        }
        return key;
    }

    private static HashSet<DMRMember> getScopedMUNs(DMRMeasure measure, HashSet<DMRMember> muns) {
        HashSet<DMRMember> rt = null;
        DMRLevel level = (DMRLevel)muns.iterator().next().getLevel();
        DMRLevel scopeLevel = null;
        scopeLevel = PreLoadDMRCubeUtil.isMeasureForCustomValue(measure.getName()) ? level : V5QueryOverTabularStream.getLowestLevelFromScope(measure, level);
        if (scopeLevel.getIndex() >= level.getIndex()) {
            rt = new HashSet<DMRMember>(muns);
        } else {
            rt = new HashSet();
            Iterator<DMRMember> iterator = muns.iterator();
            while (iterator.hasNext()) {
                DMRMember m;
                DMRMember scopeMember = m = iterator.next();
                while (scopeMember.getLevel().getIndex() > scopeLevel.getIndex()) {
                    scopeMember = (DMRMember)scopeMember.getParent();
                }
                rt.add(scopeMember);
            }
        }
        return rt;
    }

    private void addNewMeasure(TreeMap<Integer, HashSet<DMRMember>> adjsuted, DMRMeasure measure) {
        if (!this.measureInfo.containsKey(measure.getName())) {
            MeasureLoadInfo info = new MeasureLoadInfo();
            info.fmMeasure = (IMeasure)DMRCubeForPreciseLoading.getFMMetadata(measure);
            this.measureInfo.put(measure.getName(), info);
        }
        this.mergeLevelRestriction(adjsuted);
    }

    private void mergeLevelRestriction(TreeMap<Integer, HashSet<DMRMember>> adjsuted) {
        block0: for (Map.Entry<Integer, HashSet<DMRMember>> e : adjsuted.entrySet()) {
            LevelLoadInfo lvlInfo = this.levelInfo.get(e.getKey());
            DMRMember mb = e.getValue().iterator().next();
            if (mb.getLevel().isRootLevel()) continue;
            for (DMRMember amb : e.getValue()) {
                DMRMember restrict = this.getRestrictMUN(amb);
                if (restrict == null) {
                    lvlInfo.restriction.clear();
                    continue block0;
                }
                int lvlId = restrict.getLevel().getIndex();
                TreeSet<String> st = (TreeSet<String>)lvlInfo.restriction.get(lvlId);
                if (st == null) {
                    st = new TreeSet<String>();
                    lvlInfo.restriction.put(lvlId, st);
                }
                st.add(restrict.getUniqueName());
            }
        }
    }

    private void addRollUpMeasure(TreeMap<Integer, HashSet<DMRMember>> adjsuted, DMRMeasure measure) {
        MeasureLoadInfo info = this.measureInfo.get(measure.getName());
        if (info != null) {
            info.addRollUp(adjsuted);
            this.mergeLevelRestriction(adjsuted);
        }
    }

    private void addLevelAndRestriction(TreeMap<Integer, HashSet<DMRMember>> adjsuted) {
        for (Map.Entry<Integer, HashSet<DMRMember>> e : adjsuted.entrySet()) {
            DMRMember firstMB = e.getValue().iterator().next();
            LevelLoadInfo lvlInfo = new LevelLoadInfo();
            ILevel lvl = firstMB.getLevel();
            lvlInfo.fmLevel = (ILevel)DMRCubeForPreciseLoading.getFMMetadata(lvl);
            if (!lvl.isRootLevel()) {
                for (DMRMember aMB : e.getValue()) {
                    DMRMember restrict = this.getRestrictMUN(aMB);
                    if (restrict == null) {
                        lvlInfo.restriction.clear();
                        break;
                    }
                    int lvlId = restrict.getLevel().getIndex();
                    TreeSet<String> st = (TreeSet<String>)lvlInfo.restriction.get(lvlId);
                    if (st == null) {
                        st = new TreeSet<String>();
                        lvlInfo.restriction.put(lvlId, st);
                    }
                    st.add(restrict.getUniqueName());
                }
            } else if (this.isDefaultMemberOfHierarchyWithEmbeddedFilter(firstMB)) {
                lvlInfo.bIsDefaultMember = true;
                TreeSet<String> st = (TreeSet<String>)lvlInfo.restriction.get(0);
                if (st == null) {
                    st = new TreeSet<String>();
                    lvlInfo.restriction.put(0, st);
                }
                st.add("Hierarchy_Default_Member");
            }
            this.levelInfo.put(e.getKey(), lvlInfo);
        }
    }

    private boolean isDefaultMemberOfHierarchyWithEmbeddedFilter(DMRMember mb) {
        String cap = mb.getCaption();
        return "Hierarchy_Default_Member".equals(cap);
    }

    private int checkCompatible(TreeMap<Integer, HashSet<DMRMember>> adjsuted) {
        int rt = 0;
        for (Map.Entry<Integer, HashSet<DMRMember>> e : adjsuted.entrySet()) {
            DMRMember mb = e.getValue().iterator().next();
            ILevel fmLevel = (ILevel)DMRCubeForPreciseLoading.getFMMetadata(mb.getLevel());
            boolean bIsDefaulMember = this.isDefaultMemberOfHierarchyWithEmbeddedFilter(mb);
            LevelLoadInfo info = this.levelInfo.get(e.getKey());
            if (info.bIsDefaultMember != bIsDefaulMember) {
                return -1;
            }
            if (fmLevel.getIndex() > info.fmLevel.getIndex()) {
                return -1;
            }
            if (fmLevel.getIndex() == info.fmLevel.getIndex()) continue;
            if (!this.measureKey.dimensionsInAggrRule.isEmpty()) {
                return -1;
            }
            if (!info.restriction.isEmpty() || this.hasMemberRestriction(e.getValue())) {
                return -1;
            }
            rt = 1;
        }
        return rt;
    }

    private boolean hasMemberRestriction(HashSet<DMRMember> muns) {
        for (DMRMember m : muns) {
            DMRMember restrict = this.getRestrictMUN(m);
            if (restrict == null) continue;
            return true;
        }
        return false;
    }

    private DMRMember getRestrictMUN(DMRMember mb) {
        if (mb == null || mb.getLevel().isRootLevel()) {
            return null;
        }
        String name = mb.getName();
        if (!"Level_All_Members".equals(name) && !"Member_All_Children".equals(name)) {
            return mb;
        }
        return this.getRestrictMUN((DMRMember)mb.getParent());
    }

    private void addMeasure(MeasureGroupingKey mkey, DMRMeasure m) {
        this.measureKey = mkey;
        MeasureLoadInfo info = new MeasureLoadInfo();
        info.fmMeasure = (IMeasure)DMRCubeForPreciseLoading.getFMMetadata(m);
        this.measureInfo.put(m.getName(), info);
    }

    private MeasureGroupingKey createMeasureKey(SetOfTables t) {
        return new MeasureGroupingKey(t);
    }

    private final class MeasureGroupingKey {
        private SetOfTables mInvolvedTables;
        private List<String> dimensionsInAggrRule = new ArrayList<String>();
        private TreeMap<String, Integer> slicerSope = new TreeMap();

        private MeasureGroupingKey(SetOfTables t) {
            this.mInvolvedTables = t;
        }

        public String toString() {
            return "Tabs: " + this.mInvolvedTables.toString() + " aggrRules: " + this.dimensionsInAggrRule.toString() + " slicer scope: " + this.slicerSope.toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MeasureGroupingKey)) {
                return false;
            }
            MeasureGroupingKey other = (MeasureGroupingKey)obj;
            return this.mInvolvedTables.equals(other.mInvolvedTables) && this.dimensionsInAggrRule.equals(other.dimensionsInAggrRule) && this.equalMaps(this.slicerSope, other.slicerSope);
        }

        private boolean equalMaps(TreeMap m1, TreeMap m2) {
            if (m1.size() != m2.size()) {
                return false;
            }
            for (Object key : m1.keySet()) {
                if (m1.get(key).equals(m2.get(key))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            HashCodeBuilder hcb = new HashCodeBuilder();
            hcb.append((Object)this.mInvolvedTables);
            hcb.append(this.dimensionsInAggrRule);
            hcb.append(this.slicerSope);
            return hcb.toHashCode();
        }
    }

    private final class MeasureLoadInfo {
        private IMeasure fmMeasure;
        private HashSet<ArrayList<Integer>> rollUps = new HashSet();

        private MeasureLoadInfo() {
        }

        private void addRollUp(TreeMap<Integer, HashSet<DMRMember>> adjsuted) {
            ArrayList<Integer> lst = new ArrayList<Integer>();
            for (Map.Entry<Integer, HashSet<DMRMember>> e : adjsuted.entrySet()) {
                DMRMember mb = e.getValue().iterator().next();
                int lvlId = mb.getLevel().getIndex();
                lst.add(lvlId);
            }
            this.rollUps.add(lst);
        }

        public String toString() {
            return this.fmMeasure.getName() + " rollups: " + this.rollUps.toString();
        }
    }

    private final class LevelLoadInfo {
        private ILevel fmLevel;
        private TreeMap<Integer, TreeSet<String>> restriction = new TreeMap();
        private boolean bIsDefaultMember = false;

        private LevelLoadInfo() {
        }

        public String toString() {
            return this.fmLevel.getName() + " restriction: " + this.restriction.toString() + " defaultMember: " + this.bIsDefaultMember;
        }
    }
}

