/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions;

import com.cognos.xqe.data.values.NullContextFlagValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.functions.ICellStreamResultCalculator;
import com.cognos.xqe.runtree.olap.mdx.functions.IResultCalculatorFactory;
import com.cognos.xqe.runtree.olap.mdx.functions.Utilities;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IBlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import java.text.NumberFormat;

public class CellStreamProcessor {
    private Set[] contextSets = null;
    private ICellStreamResultCalculator[] resultCalculators = null;
    private final IResultCalculatorFactory resultCalculatorFactory;

    public CellStreamProcessor(IResultCalculatorFactory aResultCalculatorFactory) {
        this.resultCalculatorFactory = aResultCalculatorFactory;
    }

    public boolean processAllCells(IBlockIterator blockIter, Block retBlock, int indexOfContextSet, int indexOfCell) {
        boolean allResultCalculatorsSuccessful = true;
        int numContexts = Utilities.calcNumContexts(retBlock);
        this.contextSets = new Set[numContexts];
        this.resultCalculators = new ICellStreamResultCalculator[numContexts];
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Cell nextCell = ((Cell[])blockObj[indexOfCell])[0];
            long contextId = nextCell.getOrdinal();
            if (contextId > Integer.MAX_VALUE) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Cannot have a contextId greater than Integer.MAX_VALUE");
            }
            int intContextId = (int)contextId;
            if (this.resultCalculators[intContextId] == null) {
                Set s = (Set)blockObj[indexOfContextSet];
                this.resultCalculators[intContextId] = this.resultCalculatorFactory.createCalculatorForNewContext(blockObj, intContextId);
                this.contextSets[intContextId] = s;
                if (nextCell.getValue() == NullContextFlagValue.NULLCONTEXTFLAGVALUE) continue;
            }
            Cell nextValue = (Cell)nextCell.getValue();
            this.resultCalculators[intContextId].processCell(nextValue);
        }
        for (int i = 0; i < this.resultCalculators.length; ++i) {
            if (this.resultCalculators[i] == null) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "The iterator did not return all contexts.  Even null/empty ones need to be returned.");
            }
            Cell[] resultCells = this.resultCalculators[i].getResult();
            if (resultCells != null) {
                Set resultSet = Utilities.createSortedSet(this.contextSets[i], resultCells);
                retBlock.add(i, (Object)resultSet, null);
                continue;
            }
            allResultCalculatorsSuccessful = false;
        }
        return allResultCalculatorsSuccessful;
    }

    public Set[] getContextSets() {
        return this.contextSets;
    }

    public ICellStreamResultCalculator[] getResultCalculators() {
        return this.resultCalculators;
    }

    public static String generateLogMsg(String functionName, ICellStreamResultCalculator[] resultCalculators, int passNum) {
        StringBuilder sb = new StringBuilder(functionName + " stats for pass " + passNum + ":\n");
        for (int i = 0; i < resultCalculators.length; ++i) {
            sb.append(" #");
            sb.append(String.valueOf(i));
            sb.append(" ");
            sb.append(resultCalculators[i].getLogMsgText());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String generateLogMsg(long totalCellCount, int insertedCellCount, int returnedCellCount) {
        NumberFormat nf = NumberFormat.getInstance();
        StringBuilder sb = new StringBuilder("Total cells examined=");
        sb.append(nf.format(totalCellCount));
        sb.append("  Cells inserted into values list=");
        sb.append(nf.format(insertedCellCount));
        sb.append("  Cells in answer=");
        sb.append(nf.format(returnedCellCount));
        return sb.toString();
    }
}

