/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions;

import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IBlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullObject;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.metadata.NullMember;

public class Item
implements Function {
    private static final String ITEM_FUNCTION_NAME = "Item";

    @Override
    public Class<?> getSubjectType() {
        return Set.class;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Double.class}, {String.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return IMember.class;
    }

    @Override
    public String getName() {
        return ITEM_FUNCTION_NAME;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        if (parameterFetcher.getParameterCount() > 1) {
            throw new InterpreterException("X01517", new String[]{"1", this.getName()});
        }
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Block subjectBlock = (Block)subject;
        Block param0Block = (Block)parameterFetcher.getParameter(0);
        param0Block.getValues(interpreterContext);
        Block[] wrkBlocks = new Block[]{subjectBlock, param0Block};
        Block block = new Block(interpreterContext, wrkBlocks);
        IBlockIterator blockIter = Block.getBlockIterator(wrkBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Object itemObj = this.item(interpreterContext, blockObj[0], blockObj[1]);
            block.add(blockIter, itemObj);
        }
        return block;
    }

    private Object item(InterpreterContext interpreterContext, Object subject, Object param0) throws InterpreterException {
        int index = -1;
        if (param0 == null || param0 instanceof NullObject) {
            index = 0;
        } else if (param0 instanceof Double) {
            index = ((Double)param0).intValue();
        } else if (param0 instanceof Integer) {
            index = (Integer)param0;
        } else if (param0 instanceof Value) {
            Value v = (Value)param0;
            index = v.isNull() ? 0 : v.getInteger();
        } else {
            throw new InterpreterException("X01490", new String[]{param0.getClass().getSimpleName(), this.getName(), "CMP_TYPENUMERIC"});
        }
        if (subject instanceof Set) {
            Set set = (Set)subject;
            if (index >= 0 && (long)index < set.size()) {
                return set.getTuple(index);
            }
            if (index == 0 && set.isEmpty()) {
                return null;
            }
            IHierarchy[] setHiers = set.getHierarchies();
            IMember[] tupleMembers = new NullMember[setHiers.length];
            for (int i = 0; i < setHiers.length; ++i) {
                tupleMembers[i] = NullMember.getNullMember(setHiers[i]);
            }
            return new Tuple(tupleMembers);
        }
        if (subject instanceof Tuple) {
            Tuple tuple = (Tuple)subject;
            if (index >= 0 && index < tuple.size()) {
                return ((Tuple)subject).getMember(index);
            }
            return null;
        }
        if (subject instanceof IMember) {
            IMember member = (IMember)subject;
            if (index == 0) {
                return member;
            }
            return null;
        }
        if (subject == null) {
            return null;
        }
        throw new InterpreterException("X01434", new String[]{subject.getClass().toString(), "Member, Set, Tuple, ..."});
    }
}

