/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.mdx.parser.ASTUnsignedNumericLiteral;
import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.runtree.olap.mdx.XMdxUnsignedNumericLiteral;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.MDXAggregateProcessorRelationalSetFunction;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.MDXMathOperatorProcessorRelationalOperator;
import com.cognos.xqe.runtree.olap.mdx.functions.IMDXFunctionProcessor;
import com.cognos.xqe.runtree.olap.mdx.functions.numeric.MDXAggregateProcessor;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.MDXMathOperatorProcessor;
import java.util.Map;

public class MDXFunctionProcessorFactory {
    private static final String ATTRIBUTE_SIGN_XMDXTERM = "sign";

    public static IMDXFunctionProcessor getAggregateProcessor(ICube cube) {
        if (cube instanceof DMRCube) {
            return new MDXAggregateProcessorRelationalSetFunction();
        }
        return new MDXAggregateProcessor();
    }

    public static IMDXFunctionProcessor getMathOperatorProcessor(ICube cube) {
        if (MDXFunctionProcessorFactory.isRelationalMathOperatorEnabled(cube)) {
            return new MDXMathOperatorProcessorRelationalOperator();
        }
        return new MDXMathOperatorProcessor();
    }

    protected static boolean isRelationalMathOperatorEnabled(ICube cube) {
        if (cube instanceof DMRCube) {
            IDataSourceCapabilities providerCapabilities = ProviderCapabilites.getInstance().getOrAddProviderCapabilities("DMR");
            return providerCapabilities.getBooleanValue("enableRelationalMathOperator", true);
        }
        return false;
    }

    public static Value getExactNumber(ICube cube, XMdxUnsignedNumericLiteral literalNode) {
        if (literalNode == null) {
            return null;
        }
        if (!(cube instanceof DMRCube)) {
            return null;
        }
        Map<String, Object> props = literalNode.getProperties();
        if (props.containsKey("exactvalue")) {
            return (Value)props.get("exactvalue");
        }
        NumericValue v = null;
        ASTUnsignedNumericLiteral numericLiteralNode = (ASTUnsignedNumericLiteral)literalNode.getParserNode();
        if (numericLiteralNode != null) {
            boolean bApply = false;
            IXQEQueryNode parent = literalNode.getParent();
            if (parent != null) {
                String sign;
                if (parent.getType() == 501067 || parent.getType() == 501062) {
                    bApply = true;
                } else if (parent.getType() == 501074) {
                    sign = (String)parent.getPropertyValue(ATTRIBUTE_SIGN_XMDXTERM);
                    bApply = sign != null && sign.equals("*");
                } else if (parent.getType() == 501077 && (parent = parent.getParent()) != null && parent.getType() == 501074) {
                    sign = (String)parent.getPropertyValue(ATTRIBUTE_SIGN_XMDXTERM);
                    bApply = sign != null && sign.equals("/");
                }
            }
            String szNumber = numericLiteralNode.getParameter("literal");
            if (bApply && szNumber != null) {
                if (szNumber.matches("^([0-9]+)$")) {
                    try {
                        long iValue = Long.parseLong(szNumber);
                        v = iValue <= 32767L ? DataValueFactory.createSmallintValue() : (iValue <= Integer.MAX_VALUE ? DataValueFactory.createIntegerValue() : DataValueFactory.createLongValue());
                        ((Value)v).set(iValue);
                    }
                    catch (NumberFormatException e) {
                        int precision = szNumber.length();
                        v = precision <= 256 ? DataValueFactory.createDecimalValue(DataTypeFactory.getDecimalType(precision, 0)) : DataValueFactory.createDoubleValue();
                        v.set(szNumber);
                    }
                } else if (szNumber.matches("^(([0-9]+)\\.([0-9]+))$")) {
                    int precision = 0;
                    int scale = 0;
                    String[] parts = szNumber.split("\\.");
                    scale = parts[1].length();
                    precision = parts[0].length() + scale;
                    v = precision <= 256 ? DataValueFactory.createDecimalValue(DataTypeFactory.getDecimalType(precision, scale)) : DataValueFactory.createDoubleValue();
                    v.set(szNumber);
                }
            }
        }
        props.put("exactvalue", v);
        return v;
    }

    public static Object negateValue(InterpreterContext interpreterContext, Value vlaue) {
        if (!MDXFunctionProcessorFactory.isRelationalMathOperatorEnabled(interpreterContext.getCube())) {
            return null;
        }
        MDXMathOperatorProcessorRelationalOperator theNegateProcessor = new MDXMathOperatorProcessorRelationalOperator();
        theNegateProcessor.setFunctionCode(-1, 1);
        theNegateProcessor.addParameter(interpreterContext, vlaue);
        return theNegateProcessor.getResult(interpreterContext);
    }
}

