/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.manager;

import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.function.FunctionManager;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.IScalarFunction;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.XMdxExpressionList;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.RuntreeParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;

public class BlockFunctionExecutor
implements IParameterEvaluator {
    private RuntreeParameterFetcher paramFetcher;
    private InterpreterContext interpreterContext;
    private IValue[] currentFunctionParameters;
    private IDataType[] currentParameterDataTypes;

    protected BlockFunctionExecutor(XMdxExpressionList expressionListNode, InterpreterContext context, Object data) {
        this.interpreterContext = context;
        this.paramFetcher = new RuntreeParameterFetcher(null, expressionListNode, context, data);
    }

    protected Block executeXQEScalarFunction(String signature) throws InterpreterException {
        IScalarFunction scalarFunction;
        if ("Ceil".equalsIgnoreCase(signature)) {
            signature = "Ceiling";
        }
        if ((scalarFunction = (IScalarFunction)FunctionManager.getFunction(signature)) == null) {
            return null;
        }
        Block valueParamB = (Block)this.paramFetcher.getParameter(0);
        valueParamB.getValues(this.interpreterContext);
        Block[] wrkBlocks = new Block[]{valueParamB};
        Block block = new Block(this.interpreterContext, wrkBlocks);
        BlockIterator blockIter = new BlockIterator(wrkBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            if (this.currentFunctionParameters == null) {
                this.currentFunctionParameters = new IValue[blockObj.length];
            }
            System.arraycopy(blockObj, 0, this.currentFunctionParameters, 0, this.currentFunctionParameters.length);
            if (this.currentParameterDataTypes == null) {
                this.currentParameterDataTypes = new IDataType[this.currentFunctionParameters.length];
            }
            for (int i = 0; i < this.currentFunctionParameters.length; ++i) {
                this.currentParameterDataTypes[i] = this.currentFunctionParameters[i].getDataType();
            }
            IDataType outputType = scalarFunction.getResultDataType(this.currentParameterDataTypes);
            Value outputArg = (Value)outputType.createValue();
            outputArg.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
            this.paramFetcher.startClock();
            scalarFunction.execute(null, (IParameterEvaluator)this, outputArg);
            this.paramFetcher.stopClock();
            block.add(blockIter, (Object)outputArg);
        }
        return block;
    }

    @Override
    public IValue getParameter(XDataContext context, int index) {
        return this.currentFunctionParameters[index];
    }

    @Override
    public int getParameterCount() {
        return this.currentFunctionParameters.length;
    }

    @Override
    public String getParameterName(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isParameterLiteral(int index) {
        return false;
    }

    @Override
    public IValue[] getParameters(XDataContext context) {
        return this.currentFunctionParameters;
    }

    @Override
    public IDataType getParameterType(int index) {
        return this.currentFunctionParameters[index].getDataType();
    }

    @Override
    public IDataSource getDataSource() {
        return null;
    }

    @Override
    public SQLAbstractFunction.OnErrorPolicy getOnErrorPolicy() {
        throw new UnsupportedOperationException();
    }
}

