/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.manager;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.XMdxElement;
import com.cognos.xqe.runtree.olap.mdx.XMdxNode;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.RuntreeParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.storage.ExpressionCacheManager;
import com.cognos.xqe.runtree.olap.mdx.storage.ExpressionCacheResult;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;

public abstract class CacheableFunction
implements Function {
    private static final String NEW_LINE = "\n";
    private static XQELogger expCacheLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MDXEngine.ExpressionCache", LogLevel.TRACE);

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        XQEBaseQueryNode functNode = (XQEBaseQueryNode)((RuntreeParameterFetcher)parameterFetcher).getFunctionNode();
        this.processParameters(functNode, interpreterContext.getXDataContext());
        ExpressionCacheResult cachedResults = ExpressionCacheManager.get(functNode, this.getName(), interpreterContext);
        if (cachedResults != null) {
            Set unresolvedContext = (Set)cachedResults.getUnresolvedContext();
            if (unresolvedContext == null) {
                this.log(interpreterContext.getContextSet(), cachedResults);
                return cachedResults.getBlock();
            }
            interpreterContext.pushPartialContext(cachedResults.getBlock(), unresolvedContext);
        }
        interpreterContext.addCacheableNode((XMdxNode)functNode);
        long calcStart = System.currentTimeMillis();
        Block evalResultsBlock = (Block)this.executeImpl(subject, parameterFetcher);
        long calcTime = System.currentTimeMillis() - calcStart;
        interpreterContext.removeCacheableNode((XMdxNode)functNode);
        ExpressionCacheManager.put(functNode, evalResultsBlock, interpreterContext, calcTime);
        Block retBlock = evalResultsBlock;
        if (cachedResults != null) {
            Block cachedResultsBlock = cachedResults.getBlock();
            evalResultsBlock.changeToPreviousContext(cachedResultsBlock, cachedResults.getEmptyOrdinals(), false);
            interpreterContext.popContext();
            Block[] blocksToCombine = new Block[]{cachedResultsBlock, evalResultsBlock};
            retBlock = new Block(interpreterContext, blocksToCombine);
            BlockIterator blockIter = new BlockIterator(blocksToCombine);
            while (blockIter.hasNext()) {
                Object[] blockObj = (Object[])blockIter.next();
                if (blockObj[0] != null) {
                    retBlock.add(blockIter, blockObj[0]);
                    continue;
                }
                retBlock.add(blockIter, blockObj[1]);
            }
        }
        this.log(interpreterContext.getContextSet(), cachedResults);
        return retBlock;
    }

    public abstract Object executeImpl(Object var1, ParameterFetcher var2) throws InterpreterException;

    private void processParameters(IXQEQueryNode parentNode, XDataContext dataContext) {
        String parameterName = (String)parentNode.getPropertyValue("parameterName");
        if (parameterName != null && parentNode instanceof XMdxElement) {
            ((XMdxElement)parentNode).processParameter(dataContext, parameterName);
        }
        IXQEQueryNode[] childNodes = parentNode.getChildren();
        for (int i = 0; i < childNodes.length; ++i) {
            IXQEQueryNode childNode = childNodes[i];
            this.processParameters(childNode, dataContext);
        }
    }

    private void log(ISet requestedSet, ExpressionCacheResult cachedResults) {
        if (expCacheLogger.isOn(LogLevel.TRACE)) {
            long requestedTupleCount = requestedSet.size();
            long cachedTuplesCount = 0L;
            long notCachedTuplesCount = requestedTupleCount;
            ISet notCachedTuples = requestedSet;
            if (cachedResults != null) {
                if (cachedResults.getUnresolvedContext() == null) {
                    cachedTuplesCount = requestedTupleCount;
                    notCachedTuples = new Set(new Tuple[0]);
                    notCachedTuplesCount = 0L;
                } else {
                    cachedTuplesCount = requestedTupleCount - cachedResults.getUnresolvedContext().size();
                    notCachedTuples = cachedResults.getUnresolvedContext();
                    notCachedTuplesCount = notCachedTuples.size();
                }
            }
            expCacheLogger.log(LogLevel.TRACE, String.format("\nExpression cache\nFunction: " + this.getName() + NEW_LINE + "Requested context tuples: %d\n" + requestedSet.toString() + NEW_LINE + "Context tuples found in expression cache: %d\nContext tuples not found in expression cache: %d\n" + notCachedTuples.toString() + NEW_LINE, requestedTupleCount, cachedTuplesCount, notCachedTuplesCount));
        }
    }
}

