/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.manager;

import com.cognos.xqe.ast.mdx.parser.SimpleNode;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.interpreter.AbstractResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Interpreter;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullObject;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;

public class ParameterFetcher {
    private static final String COMMA_SPACE = ", ";
    private Function function;
    private SimpleNode node;
    private Interpreter interpreter;
    private InterpreterContext interpreterContext;
    private Object data;
    protected Object[] parameters;
    protected boolean[] fetched;
    private long cumulativeTime;
    private long clockStartTime;

    protected ParameterFetcher(Function fn, SimpleNode n, Interpreter i, InterpreterContext ic, Object d) {
        this.function = fn;
        this.interpreter = i;
        this.interpreterContext = ic;
        this.node = n;
        this.data = d;
    }

    public int getParameterCount() {
        if (this.node == null) {
            return 0;
        }
        return this.node.jjtGetNumChildren();
    }

    public Object getParameterDefinition(int index) {
        return this.node.jjtGetChild(index);
    }

    public Object getParameter(int index, Object d, boolean useParamCache) throws InterpreterException {
        Object result = null;
        this.stopClock();
        int paramCount = this.getParameterCount();
        if (index < paramCount && index > -1) {
            if (this.parameters == null) {
                this.parameters = new Object[paramCount];
                this.fetched = new boolean[paramCount];
            }
            if (this.fetched[index] && useParamCache) {
                result = this.parameters[index];
            } else {
                this.node.setParameterObject("parameterToFetch", new Integer(index));
                result = d instanceof NullPlaceHolder ? this.node.accept(this.interpreter, null) : this.node.accept(this.interpreter, d);
                this.parameters[index] = result;
                this.fetched[index] = true;
                result = this.parameters[index];
            }
        } else {
            throw new InterpreterException("X01517", new String[]{"> " + paramCount, this.function.getName()});
        }
        this.startClock();
        return result;
    }

    public Object getParameter(int index, Object d) throws InterpreterException {
        return this.getParameter(index, d, true);
    }

    public Object getParameter(int index, Class<?> cl) throws InterpreterException {
        Object param = this.getParameter(index, this.data, true);
        try {
            return Caster.cast(param, cl, this.interpreterContext);
        }
        catch (InterpreterException e) {
            String paramName = ParameterFetcher.getParameterName(param);
            throw new InterpreterException("X01490", new String[]{paramName, this.function.getName(), cl.getSimpleName()}, e);
        }
    }

    public Object getParameterWithoutData(int index) throws InterpreterException {
        return this.getParameter(index, new NullPlaceHolder(), true);
    }

    public Object getParameter(int index) throws InterpreterException {
        return this.getParameter(index, this.data, true);
    }

    public Object getParameter(int index, boolean useParamCache) throws InterpreterException {
        return this.getParameter(index, this.data, useParamCache);
    }

    public static String getParameterName(Object o) throws InterpreterException {
        if (o == null) {
            return "";
        }
        if (o instanceof ILevel) {
            return ((Level)o).getUniqueName();
        }
        if (o instanceof ILevel[]) {
            ILevel[] levels = (ILevel[])o;
            String result = levels[0].getUniqueName();
            for (int i = 1; i < levels.length; ++i) {
                result = result + COMMA_SPACE + levels[i].getUniqueName();
            }
            return result;
        }
        if (o instanceof Integer) {
            return ((Integer)o).toString();
        }
        if (o instanceof Double) {
            return ((Double)o).toString();
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof String[]) {
            String[] strings = (String[])o;
            String result = strings[0];
            for (int i = 1; i < strings.length; ++i) {
                result = result + COMMA_SPACE + strings[i];
            }
            return result;
        }
        if (o instanceof IHierarchy) {
            return ((IHierarchy)o).getUniqueName();
        }
        if (o instanceof IHierarchy[]) {
            IHierarchy[] hiers = (IHierarchy[])o;
            String result = hiers[0].getUniqueName();
            for (int i = 1; i < hiers.length; ++i) {
                result = result + COMMA_SPACE + hiers[i].getUniqueName();
            }
            return result;
        }
        if (o instanceof IDimension) {
            return ((Dimension)o).getUniqueName();
        }
        if (o instanceof IDimension[]) {
            IDimension[] dims = (IDimension[])o;
            String result = dims[0].getUniqueName();
            for (int i = 1; i < dims.length; ++i) {
                result = result + COMMA_SPACE + dims[i].getUniqueName();
            }
            return result;
        }
        if (o instanceof IMember) {
            return ((IMember)o).getUniqueName();
        }
        if (o instanceof IMember[]) {
            IMember[] mems = (IMember[])o;
            if (mems.length == 1) {
                return mems[0].getUniqueName();
            }
            return o.getClass().getSimpleName();
        }
        if (o instanceof Tuple || o instanceof Tuple[]) {
            return Tuple.class.getSimpleName();
        }
        if (o instanceof Set || o instanceof Set[]) {
            return Set.class.getSimpleName();
        }
        if (o instanceof NullObject) {
            return "Null";
        }
        if (o instanceof AbstractResultSet) {
            return "";
        }
        if (o instanceof TupleValue || o instanceof TupleValue[]) {
            return "";
        }
        if (o instanceof Value) {
            return ((Value)o).toString();
        }
        return "";
    }

    public InterpreterContext getInterpreterContext() {
        return this.interpreterContext;
    }

    public Function getFunction() {
        return this.function;
    }

    public void pushContext(Set s) throws InterpreterException {
        this.parameters = null;
        this.fetched = null;
        this.interpreterContext.pushContext(s);
    }

    public void popContext() {
        this.parameters = null;
        this.fetched = null;
        this.interpreterContext.popContext();
    }

    public void startClock() {
        this.clockStartTime = System.currentTimeMillis();
    }

    public void stopClock() {
        this.cumulativeTime += System.currentTimeMillis() - this.clockStartTime;
    }

    public long getCumulativeTime() {
        return this.cumulativeTime;
    }

    protected static class NullPlaceHolder {
        protected NullPlaceHolder() {
        }
    }
}

