/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.math;

import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.runtree.olap.mdx.functions.math.MathFunction;

public class Exp
extends MathFunction {
    private static final String EXP_FUNCTION_NAME = "Exp";

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Double.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return Double.class;
    }

    @Override
    public String getName() {
        return EXP_FUNCTION_NAME;
    }

    @Override
    public Double doMathFunction(Double value) {
        return new Double(Math.exp(value));
    }

    @Override
    public Value doMathFunction(Value value) {
        DoubleValue v = DataValueFactory.createDoubleValue();
        FormatId resultFormatId = value.getFormatId();
        v.setFormatId(resultFormatId);
        ((Value)v).set(Math.exp(value.getDouble()));
        return v;
    }
}

