/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.math;

import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IBlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullObject;
import java.util.ArrayList;

public class Pow
implements Function {
    private static final String POW_FUNCTION_NAME = "Pow";

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Double.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return 2;
    }

    @Override
    public Class<?> getReturnType() {
        return Double.class;
    }

    @Override
    public String getName() {
        return POW_FUNCTION_NAME;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        Block[] wrkBlocks;
        int paramCount = parameterFetcher.getParameterCount();
        if (paramCount > 2) {
            throw new InterpreterException("X01517", new String[]{"2", this.getName()});
        }
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Block baseParamB = (Block)parameterFetcher.getParameter(0);
        baseParamB.getValues(interpreterContext);
        Block expParamB = null;
        if (paramCount <= 1) {
            DoubleValue v = DataValueFactory.createDoubleValue();
            ((Value)v).set(1);
            v.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
            expParamB = new Block(interpreterContext, v);
        } else {
            expParamB = (Block)parameterFetcher.getParameter(1);
            expParamB.getValues(interpreterContext);
        }
        if (expParamB.isConstant()) {
            wrkBlocks = new Block[]{baseParamB};
            Block block = new Block(interpreterContext, wrkBlocks);
            IBlockIterator blockIter = Block.getBlockIterator(wrkBlocks);
            Object expParam = expParamB.first();
            while (blockIter.hasNext()) {
                Object[] blockObj = (Object[])blockIter.next();
                Object resultValue = this.doExecute(parameterFetcher, blockObj[0], expParam);
                block.add(blockIter, resultValue);
            }
            return block;
        }
        wrkBlocks = new Block[]{baseParamB, expParamB};
        Block block = new Block(interpreterContext, wrkBlocks);
        IBlockIterator blockIter = Block.getBlockIterator(wrkBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Object resultValue = this.doExecute(parameterFetcher, blockObj[0], blockObj[1]);
            block.add(blockIter, resultValue);
        }
        return block;
    }

    private Object doExecute(ParameterFetcher parameterFetcher, Object baseParam, Object expParam) throws InterpreterException {
        Value v;
        double exp;
        double base;
        if (baseParam == NullObject.instance() || baseParam == null || expParam == null || expParam == NullObject.instance()) {
            return baseParam;
        }
        if (baseParam instanceof String) {
            try {
                base = Double.parseDouble((String)baseParam);
            }
            catch (Exception e) {
                String paramString = ParameterFetcher.getParameterName(baseParam);
                throw new InterpreterException("X01490", new String[]{paramString, this.getName(), "CMP_TYPENUMERIC"}, 1L, e);
            }
        } else if (baseParam instanceof Double) {
            base = (Double)baseParam;
        } else if (baseParam instanceof Integer) {
            base = ((Integer)baseParam).doubleValue();
        } else if (baseParam instanceof Value) {
            Value v2 = (Value)baseParam;
            if (!v2.isOK()) {
                DoubleValue resultValue = DataValueFactory.createDoubleValue();
                resultValue.setState(v2.getState());
                return resultValue;
            }
            try {
                base = v2.getDouble();
            }
            catch (Exception e) {
                String paramString = ParameterFetcher.getParameterName(baseParam);
                throw new InterpreterException("X01490", new String[]{paramString, this.getName(), "CMP_TYPENUMERIC"}, 1L, e);
            }
        } else {
            String paramString = ParameterFetcher.getParameterName(baseParam);
            throw new InterpreterException("X01490", new String[]{paramString, this.getName(), "CMP_TYPENUMERIC"});
        }
        if (expParam instanceof String) {
            try {
                exp = Double.valueOf((String)expParam);
            }
            catch (Exception e) {
                String paramString = ParameterFetcher.getParameterName(expParam);
                throw new InterpreterException("X01490", new String[]{paramString, this.getName(), "CMP_TYPENUMERIC"}, 1L, e);
            }
        } else if (expParam instanceof Double) {
            exp = (Double)expParam;
        } else if (expParam instanceof Integer) {
            exp = ((Integer)expParam).doubleValue();
        } else if (expParam instanceof Value) {
            v = (Value)expParam;
            if (!v.isOK()) {
                DoubleValue resultValue = DataValueFactory.createDoubleValue();
                resultValue.setState(v.getState());
                return resultValue;
            }
            try {
                exp = v.getDouble();
            }
            catch (Exception e) {
                String paramString = ParameterFetcher.getParameterName(expParam);
                throw new InterpreterException("X01490", new String[]{paramString, this.getName(), "CMP_TYPENUMERIC"}, 1L, e);
            }
        } else {
            String paramString = ParameterFetcher.getParameterName(expParam);
            throw new InterpreterException("X01490", new String[]{paramString, this.getName(), "CMP_TYPENUMERIC"});
        }
        if (baseParam instanceof Value && expParam instanceof Value) {
            v = DataValueFactory.createDoubleValue();
            FormatService service = FormatService.getInstance();
            ArrayList<FormatId> operandIds = new ArrayList<FormatId>();
            operandIds.add(((Value)baseParam).getFormatId());
            operandIds.add(((Value)expParam).getFormatId());
            FormatId resultFormatId = service.formatResult("Power", operandIds);
            v.setFormatId(resultFormatId);
            v.set(Math.pow(base, exp));
            return v;
        }
        Double result = new Double(Math.pow(base, exp));
        return result;
    }
}

