/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.numeric;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IAggregateRule;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.metadata.virtual.VirtualMember;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.olap.mdx.XMdxElement;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.RelationalCrosstabExternalAggregateStrategy;
import com.cognos.xqe.runtree.olap.mdx.functions.IMDXFunctionProcessor;
import com.cognos.xqe.runtree.olap.mdx.functions.MDXFunctionProcessorFactory;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.functions.numeric.MDXAggregateProcessor;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ExternalAggregateStrategyException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IBlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IExternalAggregateStrategy;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.CrossJoinTupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.SingleHierarchySimpleTupleList;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPCube;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPTM1ExternalAggregateStategy;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.tm1.LOLAPTM1Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.Member;
import com.cognos.xqe.runtree.olap.mdx.metadata.Provider;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPAggregateStrategyDelegator;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPProvider;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.AggregationUtils;
import com.cognos.xqe.runtree.olap.mdx.util.OrdinalMath;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.CalculationPushdownUtility;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.PushdownManager;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.primitive.LongArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class Aggregate
implements Function {
    public static final String AGGREGATE_FUNCTION_NAME = "Aggregate";
    private static final String AGGREGATION_FUNCTION_NULL = "AGGREGATION_FUNCTION_NULL";
    public static final int SUM_OPERATOR = 0;
    public static final int MIN_OPERATOR = 1;
    public static final int MAX_OPERATOR = 2;
    public static final int COUNT_OPERATOR = 3;
    public static final int AVG_OPERATOR = 4;
    public static final int VAR_OPERATOR = 5;
    public static final int STDDEV_OPERATOR = 6;
    public static final int MEDIAN_OPERATOR = 7;
    public static final int STDDEVP_OPERATOR = 8;
    public static final int VARP_OPERATOR = 9;
    public static final int EXTERNAL_OPERATOR = 10;
    public static final int UNSUPPORTED_OPERATOR = 11;
    public static final int MAX_NUMBER_OF_ARGUMENTS = 2;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public int getAggregationType(IMember m) {
        int aggregationType = 0;
        ICube cube = m.getDimension().getCube();
        if (cube instanceof DMRCube || cube instanceof ROLAPCube) {
            AggregateTypeEnum aggrTypeEnum;
            if (cube instanceof DMRCube || cube instanceof ROLAPCube && !((ROLAPCube)cube).isVirtual()) {
                aggregationType = 10;
            }
            if ((aggrTypeEnum = m.getRegularAggregate()) == AggregateTypeEnum.SUM) {
                aggregationType = 0;
            } else if (aggrTypeEnum == AggregateTypeEnum.COUNT) {
                aggregationType = 0;
            } else if (aggrTypeEnum == AggregateTypeEnum.MIN) {
                aggregationType = 1;
            } else if (aggrTypeEnum == AggregateTypeEnum.MAX) {
                aggregationType = 2;
            }
            IAggregateRule[] aggregateRules = m.getAggregateRules();
            if (aggregateRules.length > 0) {
                for (IAggregateRule rule : aggregateRules) {
                    if (rule.getAggregate() == aggrTypeEnum) continue;
                    return 10;
                }
            }
        } else {
            if (cube instanceof LOLAPCube) {
                AggregateTypeEnum aggregateTypeEnum = m.getRegularAggregate();
                aggregationType = this.getAggregationType(aggregateTypeEnum.toMDDSType());
                return aggregationType;
            }
            aggregationType = this.getAggregationType("" + m.getProperty("AggregationType"));
        }
        return aggregationType;
    }

    public int getAggregationType(String aggregateTypeString) {
        if (aggregateTypeString.equalsIgnoreCase("Sum")) {
            return 0;
        }
        if (aggregateTypeString.equalsIgnoreCase("Count")) {
            return 0;
        }
        if (aggregateTypeString.equalsIgnoreCase("Min")) {
            return 1;
        }
        if (aggregateTypeString.equalsIgnoreCase("Max")) {
            return 2;
        }
        if (aggregateTypeString.equalsIgnoreCase("Avg")) {
            return 4;
        }
        if (aggregateTypeString.equalsIgnoreCase("Std")) {
            return 6;
        }
        if (aggregateTypeString.equalsIgnoreCase("Var")) {
            return 5;
        }
        return 0;
    }

    @Override
    public Class<?> getSubjectType() {
        return String.class;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{String.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return 2;
    }

    @Override
    public Class<?> getReturnType() {
        return ResultSet.class;
    }

    @Override
    public String getName() {
        return AGGREGATE_FUNCTION_NAME;
    }

    public IMember getFirstMeasure(InterpreterContext interpreterContext) {
        Dimension measuresDim = (Dimension)interpreterContext.getCube().getMeasuresHierarchy().getDimension();
        CrossJoinedSet contextSet = interpreterContext.getContextSet();
        IMember member = ((Set)contextSet).getTuple(0L).getMember(measuresDim);
        return member;
    }

    public IMember[] getAllMeasuresDimensionMembers(InterpreterContext interpreterContext) {
        Dimension measuresDim = (Dimension)interpreterContext.getCube().getMeasuresHierarchy().getDimension();
        CrossJoinedSet contextSet = interpreterContext.getContextSet();
        IMember[] member = ((Set)contextSet).getMembers(measuresDim);
        return member;
    }

    public int getOp(Set[] sets, Object tupleSet, InterpreterContext interpreterContext) {
        int op = 0;
        IMember member = this.getFirstMeasure(interpreterContext);
        if (member != null && member instanceof Member) {
            op = this.getAggregationType((Member)member);
        }
        return op;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        Block numExpParamB;
        Object block;
        PushdownManager pushdownManager;
        IBlockIterator blockIter;
        Set aggregateSet;
        Object block2;
        XNode setParameter;
        XMdxElement setParameterDefinition;
        boolean isNameAggregate = this.getName().equals(AGGREGATE_FUNCTION_NAME);
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        int paramCount = parameterFetcher.getParameterCount();
        OrdinalMath ordinalMath = interpreterContext.getOrdinalMath();
        if (isNameAggregate && interpreterContext.getCube() instanceof DMRCube && "CustomSet".equalsIgnoreCase((setParameterDefinition = (XMdxElement)(setParameter = (XNode)parameterFetcher.getParameterDefinition(0)).getFirstDescendantOfTypeOrdered(501059, true)).getValue())) {
            boolean calculationInContext = false;
            CrossJoinedSet contextSet = interpreterContext.getContextSet();
            HashSet<IMember> calculatedMembersInContext = contextSet.getTupleList().getCalculatedMembers();
            for (IMember calc : calculatedMembersInContext) {
                if (interpreterContext.getInterpreterSubject().equals(calc.getUniqueName())) continue;
                calculationInContext = true;
                break;
            }
            if (!calculationInContext) {
                IHierarchy measuresHier = interpreterContext.getCube().getMeasuresHierarchy();
                IMember[] measures = interpreterContext.getContextSet().getMembers(measuresHier);
                if (measures.length == 1 && measures[0].getAggregateRules().length == 0) {
                    interpreterContext.setDeferCustomSetExecution(true);
                }
            }
        }
        Block b1 = (Block)parameterFetcher.getParameter(0);
        b1 = Caster.cast(b1, Set.class, interpreterContext);
        interpreterContext.setDeferCustomSetExecution(false);
        if (isNameAggregate && (block2 = this.returnInvalidAggregateOfMeasures(parameterFetcher, aggregateSet = (Set)Caster.cast(b1.first(), Set.class))) != null) {
            return block2;
        }
        boolean hasEssbaseUnknownAggMeasure = this.hasEssbaseUnknownAggMeasure(interpreterContext, isNameAggregate);
        Set[] contextSets = interpreterContext.getContextSet().getSets();
        int measuresSetIndex = -1;
        Hierarchy measuresHier = null;
        int measuresMemberIndexInSet = -1;
        for (int i = 0; i < contextSets.length; ++i) {
            IHierarchy[] hiers = contextSets[i].getHierarchies();
            for (int j = 0; j < hiers.length; ++j) {
                if (!hiers[j].getDimension().isMeasuresDimension()) continue;
                measuresHier = (Hierarchy)hiers[j];
                measuresSetIndex = i;
                measuresMemberIndexInSet = j;
                break;
            }
            if (measuresSetIndex != -1) break;
        }
        ArrayList<Set> extAggSets = new ArrayList<Set>();
        LongArrayList extAggSetsOrdinalsSurrogateIds = new LongArrayList();
        HashMap<Set, List<List<Tuple>>> aggregateSetToContextTupleListListsMap = new HashMap<Set, List<List<Tuple>>>();
        boolean forceExternalAggregation = false;
        if (interpreterContext.getCube() instanceof DMRCube) {
            Block b1Scope = new Block(b1);
            forceExternalAggregation = this.getAggregateSetsForScopeRelationship(b1, b1Scope, interpreterContext);
            if (!b1Scope.isEmpty()) {
                b1 = b1Scope;
                forceExternalAggregation = false;
            }
            VirtualMember customSetQuery = null;
            blockIter = b1.iterator();
            block5: while (((BlockIterator)blockIter).hasNext()) {
                Object[] blockObjs = (Object[])((BlockIterator)blockIter).next();
                Object blockObj = blockObjs[0];
                Set set = null;
                if (!(blockObj instanceof Set) || (set = (Set)blockObj).size() != 1L) continue;
                for (IMember member : set.getTuple(0L).getMembers()) {
                    if (!(member instanceof VirtualMember) || ((VirtualMember)member).getV5Query() == null) continue;
                    customSetQuery = (VirtualMember)member;
                    continue block5;
                }
            }
            if (customSetQuery != null) {
                forceExternalAggregation = true;
            }
        }
        Block b2 = null;
        Block[] childBlocks = null;
        if (isNameAggregate && interpreterContext.getCube() instanceof LOLAPTM1Cube) {
            b2 = new Block(interpreterContext, b1, parameterFetcher, 1, true, true);
            childBlocks = new Block[]{b2};
            blockIter = Block.getBlockIterator(childBlocks);
            while (blockIter.hasNext()) {
                Object[] blockObj = (Object[])blockIter.next();
                TreeSet values = (TreeSet)blockObj[0];
                if (!this.containsTM1CalculatedCell(interpreterContext, values)) continue;
                forceExternalAggregation = true;
                break;
            }
        }
        Block externalB2 = null;
        Block[] externalChildBlocks = null;
        int aggSetsSize = 0;
        if (forceExternalAggregation || isNameAggregate && this.hasMeasureOperator(interpreterContext, 10)) {
            try {
                externalB2 = new Block(interpreterContext, b1, parameterFetcher, 1);
                if (externalB2.isErrorBlock()) {
                    mErrorLogger.log("Failed to build a new Block. Return error cell");
                    return new Block(interpreterContext, TextValue.ERROR_VALUE);
                }
            }
            catch (ExternalAggregateStrategyException ie) {
                mErrorLogger.log("Added error cell", (Throwable)ie);
                return new Block(interpreterContext, TextValue.ERROR_VALUE);
            }
            externalChildBlocks = new Block[]{externalB2};
            Set aggregateSet2 = (Set)Caster.cast(b1.first(), Set.class);
            aggSetsSize = this.getExtAggregateSets(interpreterContext, externalChildBlocks, paramCount, extAggSets, extAggSetsOrdinalsSurrogateIds, measuresHier, forceExternalAggregation, aggregateSet2.getHierarchies(), contextSets, aggregateSetToContextTupleListListsMap);
        }
        Value[] extAggregateValues = null;
        boolean useExternalAggregation = extAggSets.size() > 0 || forceExternalAggregation;
        int aggregateType = this.getAggregationType(this.getFirstMeasure(interpreterContext));
        if (useExternalAggregation) {
            aggregateType = 10;
        }
        Set aggregateSet3 = (Set)Caster.cast(b1.first(), Set.class);
        CalculationPushdownUtility.configurePushdown(interpreterContext, aggregateSet3, aggregateType);
        if (useExternalAggregation && !interpreterContext.inPrimingPhase()) {
            IExternalAggregateStrategy aggStrategy = interpreterContext.getProvider().getExternalAggregateStrategy();
            if (aggStrategy instanceof LOLAPTM1ExternalAggregateStategy) {
                ((LOLAPTM1ExternalAggregateStategy)aggStrategy).setBlock(b2);
            }
            if (aggStrategy != null) {
                extAggregateValues = this.getExtAggregateValues(interpreterContext, aggStrategy, aggregateSet3, extAggSets, extAggSetsOrdinalsSurrogateIds, b1, aggregateSetToContextTupleListListsMap);
                if (paramCount > 1 || extAggSets.size() == aggSetsSize) {
                    Block retBlock = new Block(interpreterContext, externalChildBlocks);
                    IBlockIterator blockIter2 = Block.getBlockIterator(externalChildBlocks);
                    for (int i = 0; i < extAggregateValues.length; ++i) {
                        blockIter2.next();
                        retBlock.add(blockIter2, (Object)extAggregateValues[i]);
                    }
                    return retBlock;
                }
            } else {
                return new Block(interpreterContext, externalChildBlocks);
            }
        }
        if (b2 == null) {
            b2 = new Block(interpreterContext, b1, parameterFetcher, 1, true, true);
        }
        if ((pushdownManager = PushdownManager.getPushdownManager(interpreterContext)) != null && pushdownManager.isAggregate()) {
            pushdownManager.setPushdownExecutionFinished(true);
            pushdownManager.popPushdownFunction();
        }
        if (b2.isEmpty() && paramCount > 1 && !interpreterContext.inPrimingPhase() && b1.isAllEmptySet() && (block = this.returnInvalidAggregateNumericExp((numExpParamB = (Block)parameterFetcher.getParameter(1)).first(), interpreterContext)) != null) {
            return block;
        }
        int op = this.getOp(null, null, interpreterContext);
        if (op == 3 || isNameAggregate && this.hasMeasureOperator(interpreterContext, 3)) {
            boolean[] keeps = new boolean[contextSets.length];
            for (int i = 0; i < contextSets.length; ++i) {
                keeps[i] = i == measuresSetIndex;
            }
            Block measuresBlock = new Block(b2, keeps);
            childBlocks = new Block[]{b2, measuresBlock};
            Iterator<TupleValue> iter = measuresBlock.tupleValueIterator();
            while (iter.hasNext()) {
                TupleValue bo = iter.next();
                Tuple currentTuple = bo.getTuple();
                IMember measureMember = currentTuple.getMember(measuresMemberIndexInSet);
                if (measureMember == null || this.getAggregationType(measureMember) != 3) continue;
                DoubleValue v = DataValueFactory.createDoubleValue();
                ((Value)v).set(0.0);
                v.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
                measuresBlock.add(iter, (Object)v);
            }
        } else {
            childBlocks = new Block[]{b2};
        }
        int currentExtAggValueIndex = -1;
        Block retBlock = new Block(interpreterContext, childBlocks);
        IBlockIterator blockIter3 = Block.getBlockIterator(childBlocks);
        int cellOp = op;
        boolean oneMeasureForAllTuples = false;
        int measuresMemberIndex = -1;
        boolean firstCell = true;
        IMember measuresMember = this.getFirstMeasure(interpreterContext);
        if (isNameAggregate && blockIter3.getMeasuresForAllTuples() != null) {
            measuresMember = blockIter3.getMeasuresForAllTuples();
            cellOp = this.getAggregationType(measuresMember);
            oneMeasureForAllTuples = true;
        }
        while (blockIter3.hasNext()) {
            Object[] blockObj = (Object[])blockIter3.next();
            TreeSet values = (TreeSet)blockObj[0];
            boolean errCell = false;
            if (isNameAggregate) {
                Tuple t = null;
                if (!oneMeasureForAllTuples) {
                    t = (Tuple)blockIter3.getCurrentTuple();
                    if (firstCell) {
                        firstCell = false;
                        measuresMemberIndex = t.getHierarchyIndex(measuresHier);
                    }
                    if (measuresMemberIndex != -1) {
                        measuresMember = t.getMember(measuresMemberIndex);
                    }
                    cellOp = this.getAggregationType(measuresMember);
                }
                if (hasEssbaseUnknownAggMeasure) {
                    errCell = this.isEssbaseUnknownAggMeasure(measuresMember, measuresMemberIndex, interpreterContext, t, retBlock, blockIter3);
                }
                if (!errCell && this.containsNullAggregatedMember(measuresMember)) {
                    retBlock.add(blockIter3, (Object)TextValue.ERROR_VALUE);
                    errCell = true;
                }
            }
            if (errCell || interpreterContext.inPrimingPhase()) continue;
            if (values != null) {
                if (cellOp == 10 && extAggregateValues != null) {
                    ++currentExtAggValueIndex;
                    long cellOrdSurrogateId = blockIter3.pos();
                    while (currentExtAggValueIndex < extAggSetsOrdinalsSurrogateIds.size() && 0 != ordinalMath.compare(extAggSetsOrdinalsSurrogateIds.get(currentExtAggValueIndex), cellOrdSurrogateId)) {
                        ++currentExtAggValueIndex;
                    }
                    if (currentExtAggValueIndex >= extAggSetsOrdinalsSurrogateIds.size()) {
                        throw new RuntimeException("Could not find the expected cell ordinal of " + cellOrdSurrogateId + ".");
                    }
                    retBlock.add(blockIter3, (Object)extAggregateValues[currentExtAggValueIndex]);
                    continue;
                }
                retBlock.add(blockIter3, Aggregate.aggregate(interpreterContext, values, cellOp));
                continue;
            }
            retBlock.add(blockIter3, blockObj[1]);
        }
        return retBlock;
    }

    private IHierarchy[] getAggregateSetHierarchy(Block b1) {
        BlockIterator blockIter = b1.iterator();
        while (blockIter.hasNext()) {
            Set set;
            Object[] blockObjs = (Object[])blockIter.next();
            Object blockObj = blockObjs[0];
            if (!(blockObj instanceof Set) || (set = (Set)blockObj).size() <= 0L) continue;
            Tuple tp = (Tuple)set.getTuple(0L);
            IHierarchy[] hiers = new IHierarchy[tp.size()];
            for (int i = 0; i < tp.size(); ++i) {
                IMember mb = tp.getMember(i);
                hiers[i] = mb.getHierarchy();
            }
            return hiers;
        }
        return null;
    }

    private int getExtAggregateSets(InterpreterContext interpreterContext, Block[] childBlocks, int paramCount, ArrayList<Set> extAggSets, LongArrayList extAggSetsOrdinalsSurrogateIds, Hierarchy measuresHier, boolean forceExternalAggregation, IHierarchy[] aggregateHierarchies, Set[] contextSets, Map<Set, List<List<Tuple>>> aggregateSetToContextTupleListListsMap) {
        IBlockIterator blockIter = Block.getBlockIterator(childBlocks);
        int measuresMemberIndex = -1;
        boolean firstCell = true;
        IMember measuresMember = this.getFirstMeasure(interpreterContext);
        int aggSetsSize = 0;
        boolean isROLAP = false;
        Provider provider = interpreterContext.getProvider();
        if (provider instanceof ROLAPProvider) {
            isROLAP = true;
        }
        boolean bCheckIfAggrSetIsMultiLevel = false;
        if (isROLAP) {
            bCheckIfAggrSetIsMultiLevel = ROLAPCubeManager.getInstance().getConfig().isAggrSetMultiLevel();
        }
        boolean hasMultipleTuplesInContext = false;
        HashMap<IHierarchy, HashSet<ILevel>> hierToChildLevelsMap = new HashMap<IHierarchy, HashSet<ILevel>>();
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            TreeSet values = (TreeSet)blockObj[0];
            ++aggSetsSize;
            if (values == null) continue;
            Tuple t = (Tuple)blockIter.getCurrentTuple();
            if (firstCell) {
                firstCell = false;
                measuresMemberIndex = t.getHierarchyIndex(measuresHier);
            }
            if (measuresMemberIndex != -1) {
                measuresMember = t.getMember(measuresMemberIndex);
            }
            if (!forceExternalAggregation && (measuresMember == null || this.getAggregationType(measuresMember) != 10) && paramCount <= 1) continue;
            ArrayList<List[]> aggTuples = new ArrayList<List[]>();
            hierToChildLevelsMap.clear();
            List[] firstTuple = null;
            int aggregateHierarchyCount = aggregateHierarchies.length;
            List[] aggregateHierarchyMemberLists = new List[aggregateHierarchyCount];
            for (int i = 0; i < aggregateHierarchyCount; ++i) {
                aggregateHierarchyMemberLists[i] = new ArrayList();
            }
            block2: for (Cell cellValue : values) {
                IHierarchy[] nonAggregateHierarchies;
                List[] aggTup = (List[])cellValue.getObjectValue();
                if (aggTup.containsNullMember()) continue;
                aggTuples.add(aggTup);
                if (hasMultipleTuplesInContext && !bCheckIfAggrSetIsMultiLevel || !isROLAP) continue;
                Object currentTuple = aggTup;
                for (int i = 0; i < aggregateHierarchyCount; ++i) {
                    IHierarchy[] aggregateHierarchy = aggregateHierarchies[i];
                    IMember aggregateHierarchyMember = ((Tuple)currentTuple).getMember((IHierarchy)aggregateHierarchy);
                    this.add2HierToChildLevelsMap(aggregateHierarchyMember, (IHierarchy)aggregateHierarchy, hierToChildLevelsMap, bCheckIfAggrSetIsMultiLevel);
                    if (aggregateHierarchyMemberLists[i].contains(aggregateHierarchyMember)) continue;
                    aggregateHierarchyMemberLists[i].add(aggregateHierarchyMember);
                }
                if (firstTuple == null) {
                    for (IHierarchy aggregateHierarchy : aggregateHierarchies) {
                        currentTuple = (Tuple)((Tuple)currentTuple).remove(aggregateHierarchy);
                    }
                    firstTuple = currentTuple;
                    continue;
                }
                for (IHierarchy nonAggregateHierarchy : nonAggregateHierarchies = firstTuple.getHierarchies()) {
                    IMember firstTupleMember = firstTuple.getMember(nonAggregateHierarchy);
                    IMember currentTupleMember = ((Tuple)currentTuple).getMember(nonAggregateHierarchy);
                    this.add2HierToChildLevelsMap(firstTupleMember, nonAggregateHierarchy, hierToChildLevelsMap, bCheckIfAggrSetIsMultiLevel);
                    if (!currentTupleMember.equals(firstTupleMember)) {
                        this.add2HierToChildLevelsMap(currentTupleMember, nonAggregateHierarchy, hierToChildLevelsMap, bCheckIfAggrSetIsMultiLevel);
                    }
                    if (firstTupleMember.equals(currentTupleMember)) continue;
                    hasMultipleTuplesInContext = true;
                    if (!bCheckIfAggrSetIsMultiLevel) continue block2;
                }
            }
            if (!aggTuples.isEmpty()) {
                Set extAggSet = new Set(aggTuples.toArray(new Tuple[aggTuples.size()]));
                extAggSets.add(extAggSet);
                if (bCheckIfAggrSetIsMultiLevel) {
                    extAggSet.setIsMultiLevel(this.isHierMultiLevel(hierToChildLevelsMap));
                }
                extAggSetsOrdinalsSurrogateIds.add(blockIter.pos());
            }
            if (firstTuple == null || hasMultipleTuplesInContext) continue;
            ArrayList<ITupleList> aggregateHierarchyMemberTupleLists = new ArrayList<ITupleList>();
            for (List aggregateHierarchyMemberList : aggregateHierarchyMemberLists) {
                IMember[] aggregateHierarchyMemberArray = aggregateHierarchyMemberList.toArray(new IMember[aggregateHierarchyMemberList.size()]);
                ITupleList aggregateHierarchyMemberTupleList = SingleHierarchySimpleTupleList.construct(aggregateHierarchyMemberArray);
                aggregateHierarchyMemberTupleLists.add(aggregateHierarchyMemberTupleList);
            }
            Set aggregateSet = new Set(CrossJoinTupleList.construct(aggregateHierarchyMemberTupleLists));
            List<List<Tuple>> contextTupleListLists = aggregateSetToContextTupleListListsMap.get(aggregateSet);
            if (contextTupleListLists == null) {
                contextTupleListLists = new ArrayList<List<Tuple>>();
                ArrayList<List[]> contextTupleList = new ArrayList<List[]>();
                contextTupleList.add(firstTuple);
                contextTupleListLists.add(contextTupleList);
                aggregateSetToContextTupleListListsMap.put(aggregateSet, contextTupleListLists);
                continue;
            }
            List<Tuple> contextTupleListWithMembersAtSameLevels = null;
            for (List<Tuple> contextTupleList : contextTupleListLists) {
                Tuple contextTuple = contextTupleList.get(0);
                if (!AggregationUtils.areMembersAtSameLevels(contextTuple, (Tuple)firstTuple)) continue;
                contextTupleListWithMembersAtSameLevels = contextTupleList;
                break;
            }
            if (contextTupleListWithMembersAtSameLevels == null) {
                ArrayList<List[]> contextTupleList = new ArrayList<List[]>();
                contextTupleList.add(firstTuple);
                contextTupleListLists.add(contextTupleList);
                continue;
            }
            contextTupleListWithMembersAtSameLevels.add((Tuple)firstTuple);
        }
        if (hasMultipleTuplesInContext) {
            aggregateSetToContextTupleListListsMap.clear();
        }
        return aggSetsSize;
    }

    private void add2HierToChildLevelsMap(IMember m, IHierarchy h, HashMap<IHierarchy, HashSet<ILevel>> hierToChildLevelsMap, boolean bCheckIfAggrSetIsMultiLevel) {
        if (!bCheckIfAggrSetIsMultiLevel) {
            return;
        }
        if (hierToChildLevelsMap.containsKey(h)) {
            HashSet<ILevel> levelList = hierToChildLevelsMap.get(h);
            levelList.add(m.getLevel());
        } else {
            HashSet<ILevel> levelList = new HashSet<ILevel>();
            levelList.add(m.getLevel());
            hierToChildLevelsMap.put(h, levelList);
        }
    }

    private boolean isHierMultiLevel(HashMap<IHierarchy, HashSet<ILevel>> hierToChildLevelsMap) {
        for (IHierarchy h : hierToChildLevelsMap.keySet()) {
            if (1 == hierToChildLevelsMap.get(h).size()) continue;
            return true;
        }
        return false;
    }

    private Value[] getExtAggregateValues(InterpreterContext interpreterContext, IExternalAggregateStrategy aggStrategy, Set aggregateSet, ArrayList<Set> extAggSets, LongArrayList extAggSetsOrdinalsSurrogateIds, Block b1, Map<Set, List<List<Tuple>>> aggregateSetToContextTupleListListsMap) throws InterpreterException {
        Value[] extAggregateValues = null;
        if (this.calculateAggregatesExternally(interpreterContext)) {
            Set[] externalAggregateSets = extAggSets.toArray(new Set[extAggSets.size()]);
            extAggregateValues = aggStrategy instanceof RelationalCrosstabExternalAggregateStrategy ? ((RelationalCrosstabExternalAggregateStrategy)aggStrategy).execute(interpreterContext, externalAggregateSets, this.getAggregateSetHierarchy(b1)) : (aggStrategy instanceof ROLAPAggregateStrategyDelegator ? ((ROLAPAggregateStrategyDelegator)aggStrategy).execute(interpreterContext, aggregateSet.getHierarchies(), externalAggregateSets, aggregateSetToContextTupleListListsMap) : aggStrategy.execute(interpreterContext, aggregateSet.getHierarchies(), externalAggregateSets));
            AggregationUtils.addAggregateContext(interpreterContext, extAggSetsOrdinalsSurrogateIds, externalAggregateSets, extAggregateValues);
        } else {
            extAggregateValues = new Value[extAggSets.size()];
            for (int idx = 0; idx < extAggregateValues.length; ++idx) {
                extAggregateValues[idx] = TextValue.ERROR_VALUE;
            }
        }
        return extAggregateValues;
    }

    private boolean containsTM1CalculatedCell(InterpreterContext interpreterContext, TreeSet<Cell> values) {
        if (interpreterContext.getCube() instanceof LOLAPTM1Cube) {
            Iterator<Cell> it = values.iterator();
            while (it.hasNext()) {
                IValue value = it.next().getValue();
                if (!(value instanceof Value) || !((Value)value).isCALC()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasEssbaseUnknownAggMeasure(InterpreterContext interpreterContext, boolean isNameAggregate) {
        if (isNameAggregate && ((Cube)interpreterContext.getCube()).isProviderEssbase()) {
            IMember[] measuresSet = this.getAllMeasuresDimensionMembers(interpreterContext);
            for (int measureIndx = 0; measureIndx < measuresSet.length; ++measureIndx) {
                IMember mem = measuresSet[measureIndx];
                if (mem.isCalculatedMember() || !((Cube)interpreterContext.getCube()).isOfTypeAggregateUnknown(mem.getRegularAggregate())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isEssbaseUnknownAggMeasure(IMember measuresMember, int measuresMemberIndex, InterpreterContext interpreterContext, Tuple t, Block retBlock, IBlockIterator blockIter) {
        if (t == null) {
            t = (Tuple)blockIter.getCurrentTuple();
        }
        boolean skipTuple = false;
        if (t.size() == 0) {
            retBlock.add(blockIter, (Object)TextValue.ERROR_VALUE);
            return true;
        }
        if (measuresMemberIndex != -1 && !measuresMember.isCalculatedMember() && !((Cube)interpreterContext.getCube()).isOfTypeAggregateUnknown(measuresMember.getRegularAggregate())) {
            skipTuple = true;
        }
        if (!skipTuple) {
            for (int i = 0; i < t.size(); ++i) {
                boolean isDummyMember = false;
                if (!t.getMember(i).isMeasure() && ((Cube)interpreterContext.getCube()).isDummyMember(t.getMember(i))) {
                    isDummyMember = true;
                }
                if (isDummyMember || t.getMember(i).getLevel().isLeafLevel()) continue;
                retBlock.add(blockIter, (Object)TextValue.ERROR_VALUE);
                return true;
            }
        }
        return false;
    }

    private Object returnInvalidAggregateOfMeasures(ParameterFetcher parameterFetcher, Set aggregateSet) throws InterpreterException {
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Dimension measures = (Dimension)interpreterContext.getCube().getMeasuresHierarchy().getDimension();
        IMember[] aggregateSetMeasures = aggregateSet.getMembers(measures);
        IMember contextSetMeasure = this.getFirstMeasure(interpreterContext);
        if (aggregateSetMeasures.length > 0 && MemberTypeEnum.QUERY_CALCULATION == contextSetMeasure.getType()) {
            Block secondParamB;
            List<Object> secondParamDimensions = new ArrayList();
            if (parameterFetcher.getParameterCount() > 1 && Caster.isCastable((secondParamB = (Block)parameterFetcher.getParameter(1, false)).first(), Set.class)) {
                Set secondParam = (Set)Caster.cast(secondParamB.first(), Set.class);
                secondParamDimensions = Arrays.asList(secondParam.getDimensions());
            }
            if (!secondParamDimensions.contains(measures)) {
                return new Block(interpreterContext, TextValue.ERROR_VALUE);
            }
        }
        return null;
    }

    private Object returnInvalidAggregateNumericExp(Object numExpObj, InterpreterContext interpreterContext) {
        Value v;
        if (numExpObj instanceof String) {
            return new Block(interpreterContext, TextValue.ERROR_VALUE);
        }
        if (numExpObj instanceof Value && ((v = (Value)numExpObj).isError() || !v.isNumeric())) {
            return new Block(interpreterContext, TextValue.ERROR_VALUE);
        }
        return null;
    }

    private boolean getAggregateSetsForScopeRelationship(Block b1, Block b1Scope, InterpreterContext interpreterContext) throws InterpreterException {
        boolean useExternalAggregation = false;
        Dimension measuresDim = (Dimension)interpreterContext.getCube().getMeasuresHierarchy().getDimension();
        CrossJoinedSet contextSet = interpreterContext.getContextSet();
        IMember[] measures = ((Set)contextSet).getMembers(measuresDim);
        BlockIterator blockIter = b1.iterator();
        while (blockIter.hasNext()) {
            Object[] blockObjs = (Object[])blockIter.next();
            Object blockObj = blockObjs[0];
            Set set = null;
            if (!(blockObj instanceof Set)) continue;
            set = (Set)blockObj;
            ArrayList<IMember> scopeMembers = new ArrayList<IMember>();
            useExternalAggregation = AggregationUtils.haveMembersOutOfMeasureScope(set, interpreterContext, measures, scopeMembers);
            if (measures.length > 1 && !scopeMembers.isEmpty()) {
                scopeMembers.clear();
                return true;
            }
            boolean membersHaveSameParent = false;
            if (!scopeMembers.isEmpty()) {
                membersHaveSameParent = AggregationUtils.checkMembersHaveSameParent(set);
            }
            if (membersHaveSameParent) {
                for (IMember member : scopeMembers) {
                    if ((set = (Set)set.removeDimension(member.getDimension())).isEmpty()) {
                        b1Scope.add(blockIter, (Object)new Set(new Tuple(member)));
                        continue;
                    }
                    b1Scope.add(blockIter, (Object)set.crossjoin(new Set(new Tuple(member))));
                }
                useExternalAggregation = false;
            }
            if (!useExternalAggregation) continue;
            return true;
        }
        return false;
    }

    private boolean calculateAggregatesExternally(InterpreterContext interpreterContext) {
        IDataSource dataSource = interpreterContext.getXDataContext().getEnvironment().getDataSource();
        String parameter = Boolean.TRUE.toString();
        if (dataSource != null) {
            parameter = dataSource.getCapabilities().getStringValue("pushdownExtAggregatesToRelational", parameter);
        }
        return parameter.equalsIgnoreCase(Boolean.TRUE.toString());
    }

    private boolean hasMeasureOperator(InterpreterContext interpreterContext, int operator) {
        for (IMember measure : this.getAllMeasuresDimensionMembers(interpreterContext)) {
            if (measure == null || !(measure instanceof Member) || this.getAggregationType((Member)measure) != operator) continue;
            return true;
        }
        return false;
    }

    protected static Object count(TreeSet<Cell> cells) {
        long count = 0L;
        for (Cell cell : cells) {
            Object cellValue = cell.getObjectValue();
            if (cellValue instanceof Value) {
                Value v = (Value)cellValue;
                if (v.isError()) {
                    return TextValue.ERROR_VALUE;
                }
                if (v.isNull()) continue;
                ++count;
                continue;
            }
            ++count;
        }
        DoubleValue resultValue = DataValueFactory.createDoubleValue();
        resultValue.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
        ((Value)resultValue).set(count);
        return resultValue;
    }

    public static Object aggregate(InterpreterContext interpreterContext, TreeSet<Cell> values, int op) {
        if (op == 3) {
            return Aggregate.count(values);
        }
        IMDXFunctionProcessor processor = null;
        processor = op == 5 || op == 6 || op == 8 || op == 9 ? new MDXAggregateProcessor() : MDXFunctionProcessorFactory.getAggregateProcessor(interpreterContext.getCube());
        processor.setFunctionCode(op, values.size());
        for (Cell cellValue : values) {
            Object cellValueObj = cellValue.getObjectValue();
            Object retObj = processor.addParameter(interpreterContext, cellValueObj);
            if (retObj == null) continue;
            return retObj;
        }
        return processor.getResult(interpreterContext);
    }

    private boolean containsNullAggregatedMember(IMember measure) {
        boolean containsNullAgg = false;
        Boolean currentMeasureAggFuncIsNull = null;
        if (measure != null && (currentMeasureAggFuncIsNull = (Boolean)measure.getProperty(AGGREGATION_FUNCTION_NULL)) != null && currentMeasureAggFuncIsNull.booleanValue()) {
            containsNullAgg = true;
        }
        return containsNullAgg;
    }
}

