/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.other;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IBlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullObject;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.ArrayList;

public class Sqrt
implements Function {
    private static final String SQRT_FUNCTION_NAME = "Sqrt";
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Double.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return Double.class;
    }

    @Override
    public String getName() {
        return SQRT_FUNCTION_NAME;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        if (parameterFetcher.getParameterCount() > 1) {
            throw new InterpreterException("X01517", new String[]{"1", this.getName()});
        }
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Block b1 = (Block)parameterFetcher.getParameter(0);
        b1.getValues(interpreterContext);
        Block[] wrkBlocks = new Block[]{b1};
        Block block = new Block(interpreterContext, wrkBlocks);
        IBlockIterator blockIter = Block.getBlockIterator(wrkBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Object sqrtValue = this.sqrt(parameterFetcher, blockObj[0]);
            block.add(blockIter, sqrtValue);
        }
        return block;
    }

    private Object sqrt(ParameterFetcher paramFetcher, Object param1) throws InterpreterException {
        if (param1 instanceof Double) {
            return new Double(Math.sqrt((Double)param1));
        }
        if (param1 instanceof Integer) {
            Double doubleValue = new Double(((Integer)param1).doubleValue());
            return new Double(Math.sqrt(doubleValue));
        }
        if (param1 instanceof NullObject) {
            return new Double(0.0);
        }
        if (param1 instanceof String) {
            try {
                double d = Double.parseDouble((String)param1);
                return new Double(Math.sqrt(d));
            }
            catch (Exception e) {
                mErrorLogger.log(e);
                return TextValue.ERROR_VALUE;
            }
        }
        if (param1 instanceof Value) {
            Value paramValue = (Value)param1;
            if (!paramValue.isOK()) {
                DoubleValue v = DataValueFactory.createDoubleValue();
                v.setState(paramValue.getState());
                return v;
            }
            DoubleValue v = DataValueFactory.createDoubleValue();
            FormatService service = FormatService.getInstance();
            ArrayList<FormatId> operandIds = new ArrayList<FormatId>();
            operandIds.add(paramValue.getFormatId());
            FormatId resultFormatId = service.formatResult(SQRT_FUNCTION_NAME, operandIds);
            v.setFormatId(resultFormatId);
            try {
                ((Value)v).set(Math.sqrt(paramValue.getDouble()));
                if (paramValue.getDouble() < 0.0) {
                    v.setState(ValueState.ERROR);
                }
                return v;
            }
            catch (Exception e) {
                mErrorLogger.log(e);
                return TextValue.ERROR_VALUE;
            }
        }
        String o1String = ParameterFetcher.getParameterName(param1);
        throw new InterpreterException("X01490", new String[]{o1String, this.getName(), "CMP_TYPENUMERIC"});
    }
}

