/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.set;

import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.resultset.interfaces.IIterator;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.functions.set.TopPercent;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullObject;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;

public class BottomPercent
extends TopPercent {
    private static final double ONE_HUNDRED = 100.0;
    public static final String BOTTOMPERCENT_FUNCTION_NAME = "BottomPercent";

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Set.class, Set.class}};
    }

    @Override
    public Class<?> getReturnType() {
        return Set.class;
    }

    @Override
    public String getName() {
        return BOTTOMPERCENT_FUNCTION_NAME;
    }

    @Override
    public Set getTopSet(Set s, boolean ascending, double maxPercent, TreeSet<Cell> rs, InterpreterContext interpreterContext) throws InterpreterException {
        TupleValue tupleValue;
        Cell cell;
        Set result = null;
        if (s.size() <= 1L) {
            return s;
        }
        Object[] tupleValuesToSort = null;
        double grandTotal = 0.0;
        if (rs == null) {
            if (!ascending) {
                return (Set)s.head(1L);
            }
            return s.tail(1);
        }
        Cell fobj = rs.first();
        if (fobj.getObjectValue() instanceof NullObject) {
            if (!ascending) {
                return (Set)s.head(1L);
            }
            return s.tail(1);
        }
        Tuple setTuple = null;
        tupleValuesToSort = new TupleValue[(int)s.size()];
        int tupleValueIdx = 0;
        IIterator setIter = s.iterator();
        while (setIter.hasNext()) {
            setTuple = (Tuple)((ITuple)setIter.next()).copy();
            DoubleValue v = DataValueFactory.createDoubleValue();
            ((Value)v).set(0.0);
            v.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
            cell = new Cell(-1L, v);
            tupleValue = new TupleValue(setTuple, cell);
            tupleValuesToSort[tupleValueIdx] = new TupleValue(setTuple, cell);
            ((TupleValue)tupleValuesToSort[tupleValueIdx]).setTiesComp(Integer.valueOf(tupleValuesToSort.length - tupleValueIdx - 1));
            ++tupleValueIdx;
        }
        Iterator<Cell> cellIt = rs.iterator();
        if (cellIt.hasNext()) {
            while (cellIt.hasNext()) {
                cell = cellIt.next();
                setTuple = (Tuple)s.getTuple(cell.getOrdinal());
                tupleValue = new TupleValue(setTuple, cell);
                tupleValueIdx = (int)cell.getOrdinal();
                tupleValuesToSort[tupleValueIdx] = tupleValue;
                ((TupleValue)tupleValuesToSort[tupleValueIdx]).setTiesComp(Integer.valueOf(tupleValuesToSort.length - tupleValueIdx - 1));
                Value theValue = (Value)tupleValue.getCell().getValue();
                if (theValue.isError()) continue;
                grandTotal += ((TupleValue)tupleValuesToSort[tupleValueIdx]).getCellValue();
            }
        }
        Arrays.sort(tupleValuesToSort);
        ArrayList<Tuple> al = new ArrayList<Tuple>();
        double totalSoFar = 0.0;
        double maxValue = grandTotal * maxPercent / 100.0;
        for (int i = 0; i < tupleValuesToSort.length; ++i) {
            int tupleIdx = ascending ? i : tupleValuesToSort.length - i - 1;
            Object tupleValue2 = tupleValuesToSort[tupleIdx];
            Value theValue = (Value)((TupleValue)tupleValue2).getCell().getValue();
            if (!theValue.isError()) {
                double cellValue = ((TupleValue)tupleValue2).getCellValue();
                if (totalSoFar >= maxValue && totalSoFar != 0.0) break;
                totalSoFar += cellValue;
            }
            al.add(((TupleValue)tupleValue2).getTuple());
        }
        result = new Set(al.toArray(new Tuple[0]));
        return result;
    }
}

