/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.set;

import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.runtree.olap.mdx.MDXEngineException;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IBlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullObject;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import java.util.Arrays;
import java.util.HashSet;

public class DrillDownMemberTop
implements Function {
    private static final int PARAMETER_INDEX_4 = 4;
    private static final int NUMBER_3 = 3;
    private static final String DRILL_DOWN_MEMBER_TOP = "DrillDownMemberTop";
    private static final String SET_OR_NAMED_SET_STR = "CMP_TYPESET, CMP_TYPENAMEDSET";
    private static final String RECURSIVE_STR = "RECURSIVE";
    private static final String NULL_STR = "NULL";

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Set.class, Double.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return Set.class;
    }

    @Override
    public String getName() {
        return DRILL_DOWN_MEMBER_TOP;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Block set1ParamB = (Block)parameterFetcher.getParameter(0);
        Block set2ParamB = (Block)parameterFetcher.getParameter(1);
        if (set1ParamB == null || set2ParamB == null) {
            throw new InterpreterException("X01490", new String[]{NULL_STR, this.getName(), "CMP_TYPESET"});
        }
        Block countParamB = (Block)parameterFetcher.getParameter(2);
        if (countParamB == null) {
            throw new InterpreterException("X01490", new String[]{NULL_STR, this.getName(), "CMP_TYPENUMERIC"});
        }
        countParamB.getValues(interpreterContext);
        int paramCount = parameterFetcher.getParameterCount();
        boolean recurse = false;
        if (paramCount > 4) {
            Object recurseParam = null;
            try {
                Block recurseParamB = (Block)parameterFetcher.getParameter(4);
                recurseParam = recurseParamB.first();
            }
            catch (Exception e) {
                String recurseString = "";
                Object[] args = null;
                if (e instanceof InterpreterException) {
                    args = ((InterpreterException)e).getArgs();
                    if (e.getMessage().equals("X01405")) {
                        recurseString = ParameterFetcher.getParameterName(args);
                    }
                } else if (e instanceof MDXEngineException) {
                    args = ((MDXEngineException)e).getArguments();
                    if (e.getMessage().equals("X01405")) {
                        recurseString = ParameterFetcher.getParameterName(args);
                    }
                }
                throw new InterpreterException("X01490", new String[]{recurseString, this.getName(), RECURSIVE_STR}, e);
            }
            recurse = recurseParam.toString().equalsIgnoreCase(RECURSIVE_STR);
            if (!recurse) {
                String recurseString = ParameterFetcher.getParameterName(recurseParam);
                throw new InterpreterException("X01490", new String[]{recurseString, this.getName(), RECURSIVE_STR});
            }
        }
        Block[] wrkBlocks = new Block[]{set1ParamB, set2ParamB, countParamB};
        Block block = new Block(interpreterContext, wrkBlocks);
        IBlockIterator blockIter = Block.getBlockIterator(wrkBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Set drilledSet = this.drillDownMemberTop(parameterFetcher, blockObj[0], blockObj[1], blockObj[2], recurse);
            block.add(blockIter, (Object)drilledSet);
        }
        block.removeInvalidTuples();
        return block;
    }

    private Set drillDownMemberTop(ParameterFetcher parameterFetcher, Object set1Param, Object set2Param, Object countParam, boolean recurse) throws InterpreterException {
        if (!(set1Param instanceof Set)) {
            String param1Name = ParameterFetcher.getParameterName(set1Param);
            throw new InterpreterException("X01490", new String[]{param1Name, this.getName(), SET_OR_NAMED_SET_STR});
        }
        if (!(set2Param instanceof Set)) {
            String param2Name = ParameterFetcher.getParameterName(set2Param);
            throw new InterpreterException("X01490", new String[]{param2Name, this.getName(), SET_OR_NAMED_SET_STR});
        }
        Set set1 = (Set)set1Param;
        Set set2 = (Set)set2Param;
        if (set1.isEmpty()) {
            return new Set(new Tuple[0]);
        }
        if (set2.isEmpty()) {
            return set1;
        }
        if (set2.getTuple(0L).size() > 1) {
            throw new InterpreterException("X01482", new String[]{this.getName()});
        }
        HashSet<IHierarchy> s1Hierarchies = new HashSet<IHierarchy>();
        IHierarchy[] hiers = set1.getHierarchies();
        s1Hierarchies.addAll(Arrays.asList(hiers));
        IHierarchy[] s2Hierarchies = set2.getHierarchies();
        if (!s1Hierarchies.contains(s2Hierarchies[0])) {
            String s2Hierarchy = ParameterFetcher.getParameterName(s2Hierarchies[0]);
            String hiersName = ParameterFetcher.getParameterName(hiers);
            throw new InterpreterException("X01490", new String[]{s2Hierarchy, this.getName(), hiersName});
        }
        double count = 0.0;
        if (countParam == null || countParam == NullObject.instance() || countParam instanceof Number || countParam instanceof Boolean) {
            count = parameterFetcher.getInterpreterContext().getDoubleOperand(countParam);
        } else if (countParam instanceof Value) {
            Value v = (Value)countParam;
            if (v.isNull()) {
                count = 0.0;
            } else {
                try {
                    count = v.getDouble();
                }
                catch (ValueConversionException vce) {
                    String countString = ParameterFetcher.getParameterName(countParam);
                    throw new InterpreterException("X01490", new String[]{countString, this.getName(), "CMP_TYPENUMERIC"}, vce);
                }
            }
        } else {
            String countString = ParameterFetcher.getParameterName(countParam);
            throw new InterpreterException("X01490", new String[]{countString, this.getName(), "CMP_TYPENUMERIC"});
        }
        if (count > Double.MAX_VALUE) {
            throw new InterpreterException("X01490", new String[]{count + "", this.getName(), "<= 1.7976931348623157E308"});
        }
        boolean drillTop = this.getName().equals(DRILL_DOWN_MEMBER_TOP);
        int paramCount = parameterFetcher.getParameterCount();
        int paramIdx = 3;
        if (paramCount <= 3) {
            paramIdx = Integer.MAX_VALUE;
        }
        return set1.drillDownMemberTopOrBottom(set2, (int)count, parameterFetcher, paramIdx, drillTop, recurse);
    }
}

