/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.set;

import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.tabstream.DMRProviderForPreciseLoading;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.CacheableFunction;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ErrorCell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.TupleListFilter;
import com.cognos.xqe.runtree.olap.mdx.metadata.Provider;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.FilterPushdownUtility;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.PushdownManager;
import java.util.TreeSet;

public class Filter
extends CacheableFunction {
    public static final String FILTER_FUNCTION_NAME = "Filter";

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Set.class, Set.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return Set.class;
    }

    @Override
    public String getName() {
        return FILTER_FUNCTION_NAME;
    }

    private Object getConditionObject(InterpreterContext interpreterContext, Object o) {
        Provider p = interpreterContext.getProvider();
        if (p instanceof DMRProviderForPreciseLoading) {
            return BooleanValue.TRUE;
        }
        return o;
    }

    @Override
    public Object executeImpl(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Block setParamB = (Block)parameterFetcher.getParameter(0);
        setParamB = Caster.cast(setParamB, Set.class, interpreterContext);
        FilterPushdownUtility.configurePushdown(interpreterContext);
        Block searchCondParamB = new Block(interpreterContext, setParamB, parameterFetcher, 1, true, false, setParamB.isConstant());
        Block[] childBlocks = new Block[]{setParamB, searchCondParamB};
        Block retBlock = new Block(interpreterContext, childBlocks, setParamB, searchCondParamB);
        if (interpreterContext.inPrimingPhase() && interpreterContext.getPrimingInfo().getPrimingMode() == 1) {
            retBlock.setDefaultValue(new Set(new Tuple[0]));
            PushdownManager.resetPushdownContext(interpreterContext);
            retBlock.removeInvalidTuples();
            return retBlock;
        }
        boolean useSparseIteration = true;
        Object searchCondDefaultValue = searchCondParamB.getDefaultValue();
        if (searchCondDefaultValue != null && searchCondDefaultValue instanceof BooleanValue && BooleanValue.TRUE.equals(searchCondDefaultValue)) {
            useSparseIteration = false;
        }
        BlockIterator blockIter = new BlockIterator(childBlocks, useSparseIteration);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Set setParam = (Set)blockObj[0];
            if (setParam == null) continue;
            Object searchCondParam = blockObj[1];
            retBlock.add(blockIter, (Object)this.filter(setParam, this.getConditionObject(interpreterContext, searchCondParam)));
        }
        if (retBlock.hasEmptyCells()) {
            if (setParamB.isConstant() && searchCondParamB.getDefaultValue() != null) {
                retBlock.setDefaultValue(this.filter((Set)setParamB.first(), this.getConditionObject(interpreterContext, searchCondParamB.getDefaultValue())));
            } else if (setParamB.getDefaultValue() != null && searchCondParamB.getDefaultValue() != null) {
                retBlock.setDefaultValue(this.filter((Set)setParamB.getDefaultValue(), this.getConditionObject(interpreterContext, searchCondParamB.getDefaultValue())));
            } else {
                retBlock.setDefaultValue(new Set(new Tuple[0]));
            }
        }
        PushdownManager.resetPushdownContext(interpreterContext);
        retBlock.removeInvalidTuples();
        return retBlock;
    }

    private Set filter(Set inputSet, Object searchCondition) {
        Set set = inputSet.removeNullMembers();
        if (set.isEmpty() && !inputSet.isEmpty()) {
            return inputSet;
        }
        if (set.isEmpty() || searchCondition == null) {
            return new Set(new Tuple[0]);
        }
        if (!(searchCondition instanceof TreeSet)) {
            if (!(searchCondition instanceof BooleanValue) && !(searchCondition instanceof Boolean)) {
                return new Set(new Tuple[0]);
            }
            BooleanValue searchConditionValue = (BooleanValue)searchCondition;
            if (searchConditionValue.getBoolean()) {
                return inputSet;
            }
            return new Set(new Tuple[0]);
        }
        TreeSet searchConditionValues = (TreeSet)searchCondition;
        TupleListFilter filter = null;
        filter = new TupleListFilter(set.size());
        for (Cell c : searchConditionValues) {
            long tupleOrdinal = c.getOrdinal();
            boolean searchCondValue = false;
            if (ErrorCell.isErrorCell(c.getObjectValue())) {
                searchCondValue = false;
            } else if (c.isBoolean()) {
                searchCondValue = c.getBooleanValue();
            } else if (c.isNumeric()) {
                searchCondValue = c.getNumericValue() != 0.0;
            } else if (c.isString()) {
                searchCondValue = c.getStringValue().equalsIgnoreCase("true");
            } else if (c.getObjectValue() instanceof Value) {
                searchCondValue = c.getBooleanValue();
            }
            filter.set((int)tupleOrdinal, searchCondValue);
        }
        return set.getFilteredSet(filter);
    }
}

