/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.set;

import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.util.monitor.ResourceMonitor;
import java.sql.Timestamp;
import java.util.TreeSet;

public class Generate
implements Function {
    private static final String GENERATE_FUNCTION_NAME = "Generate";
    private static final int SET_SYNTAX = 1;
    private static final int STRING_SYNTAX = 2;
    private static final String ALL_STR = "ALL";
    private static final String STRING_STR = "String";

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Set.class, Set.class}, {Set.class, Set.class, String.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return Set.class;
    }

    @Override
    public String getName() {
        return GENERATE_FUNCTION_NAME;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        if (parameterFetcher.getParameterCount() < 2) {
            throw new InterpreterException("X01517", new String[]{"> 1", this.getName()});
        }
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Block b1 = (Block)parameterFetcher.getParameter(0);
        b1 = Caster.cast(b1, Set.class, interpreterContext);
        Block b2 = new Block(interpreterContext, b1, parameterFetcher, 1, false, true, b1.isConstant());
        Object firstObj = b2.first();
        int mode = this.getFunctionMode(firstObj, parameterFetcher);
        String delimiterStrParam = null;
        boolean allParam = false;
        Block[] childBlocks = null;
        if (parameterFetcher.getParameterCount() > 2) {
            Block b3 = (Block)parameterFetcher.getParameter(2);
            if (mode == 1) {
                allParam = this.getALLParameter(b3.first());
                childBlocks = new Block[]{b1, b2};
            } else {
                b3.getValues(interpreterContext);
                childBlocks = new Block[]{b1, b2, b3};
            }
        } else {
            childBlocks = new Block[]{b1, b2};
        }
        Block retBlock = new Block(interpreterContext, childBlocks);
        BlockIterator blockIter = new BlockIterator(childBlocks, true);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Set param1 = (Set)blockObj[0];
            Object param2 = blockObj[1];
            if (blockObj.length > 2) {
                delimiterStrParam = this.getDelimiterString(blockObj[2]);
            }
            retBlock.add(blockIter, this.generate(param1, param2, mode, allParam, delimiterStrParam, interpreterContext));
        }
        if (retBlock.hasEmptyCells()) {
            if (b2.getDefaultValue() != null) {
                retBlock.setDefaultValue(this.generate((Set)b1.first(), b2.getDefaultValue(), mode, allParam, delimiterStrParam, interpreterContext));
            } else if (mode == 2) {
                StringValue emptyStr = DataValueFactory.createStringValue();
                ((Value)emptyStr).set("");
                retBlock.setDefaultValue(emptyStr);
            } else {
                retBlock.setDefaultValue(new Set(new Tuple[0]));
            }
        }
        retBlock.removeInvalidTuples();
        return retBlock;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object generate(Set setParam, Object param2, int mode, boolean allParam, String delimiterStrParam, InterpreterContext interpreterContext) throws InterpreterException {
        Value v;
        if (setParam.isEmpty() || param2 == null) {
            if (mode != 2) return new Set(new Tuple[0]);
            StringValue emptyStr = DataValueFactory.createStringValue();
            ((Value)emptyStr).set("");
            return emptyStr;
        }
        Set[] setsToUnion = null;
        StringBuilder genString = new StringBuilder();
        if (!(param2 instanceof TreeSet)) {
            if (mode == 1) {
                Set param2Set = (Set)Caster.cast(param2, Set.class);
                if (param2Set.isEmpty()) {
                    return new Set(new Tuple[0]);
                }
                ResourceMonitor.checkMaxSetSize(setParam.size(), interpreterContext.getQueryContext(), XQEMessageKeys.MDX_MaxCrossjoinSize);
                setsToUnion = new Set[(int)setParam.size()];
                for (int i = 0; i < (int)setParam.size() - 1; ++i) {
                    setsToUnion[i] = param2Set;
                }
            } else {
                if (!(param2 instanceof Value)) return TextValue.ERROR_VALUE;
                v = (Value)param2;
                if (v.isNull()) {
                    return TextValue.ERROR_VALUE;
                }
                ResourceMonitor.checkMaxSetSize(setParam.size(), interpreterContext.getQueryContext(), XQEMessageKeys.MDX_MaxCrossjoinSize);
                for (int i = 0; i < (int)setParam.size() - 1; ++i) {
                    Tuple currTuple = (Tuple)setParam.getTuple(i);
                    if (currTuple.containsNullMember()) continue;
                    if (delimiterStrParam != null && genString.length() != 0) {
                        genString.append(delimiterStrParam);
                    }
                    genString.append(v.getString());
                }
            }
        } else {
            TreeSet param2Values = (TreeSet)param2;
            int setIdx = 0;
            if (mode == 1) {
                setsToUnion = new Set[param2Values.size()];
            }
            for (Cell c : param2Values) {
                Object param2Value = c.getObjectValue();
                if (mode == 1) {
                    param2Value = Caster.cast(param2Value, Set.class);
                    setsToUnion[setIdx++] = (Set)param2Value;
                    continue;
                }
                if (param2Value instanceof Value) {
                    Value v2 = (Value)param2Value;
                    if (v2.isNull()) {
                        return TextValue.ERROR_VALUE;
                    }
                    long setOrd = c.getOrdinal();
                    Tuple currTuple = (Tuple)setParam.getTuple(setOrd);
                    if (currTuple.containsNullMember()) continue;
                    if (delimiterStrParam != null && genString.length() != 0) {
                        genString.append(delimiterStrParam);
                    }
                    genString.append(v2.getString());
                    continue;
                }
                if (!(param2Value instanceof String) && !(param2Value instanceof Boolean)) {
                    return TextValue.ERROR_VALUE;
                }
                long setOrd = c.getOrdinal();
                Tuple currTuple = (Tuple)setParam.getTuple(setOrd);
                if (currTuple.containsNullMember()) continue;
                if (delimiterStrParam != null && genString.length() != 0) {
                    genString.append(delimiterStrParam);
                }
                genString.append(param2Value);
            }
        }
        if (mode == 1) {
            return Set.union(setsToUnion, allParam);
        }
        v = DataValueFactory.createStringValue();
        v.set(genString.toString());
        return v;
    }

    private int getFunctionMode(Object param2, ParameterFetcher parameterFetcher) throws InterpreterException {
        Object firstObj = param2;
        if (param2 != null && param2 instanceof TreeSet) {
            firstObj = !((TreeSet)param2).isEmpty() ? ((Cell)((TreeSet)param2).first()).getObjectValue() : null;
        }
        if (firstObj == null) {
            Block setOrStrParam = (Block)parameterFetcher.getParameter(1);
            if (setOrStrParam.first() instanceof Value || setOrStrParam.first() == null || setOrStrParam.first() instanceof Number || setOrStrParam.first() instanceof String || setOrStrParam.first() instanceof Boolean || setOrStrParam.first() instanceof Timestamp) {
                return 2;
            }
            return 1;
        }
        if (firstObj instanceof Value || firstObj instanceof Number || firstObj instanceof String || firstObj instanceof Boolean || firstObj instanceof Timestamp) {
            return 2;
        }
        return 1;
    }

    private String getDelimiterString(Object delimiterStrParam) throws InterpreterException {
        if (delimiterStrParam instanceof String && ((String)delimiterStrParam).equalsIgnoreCase(ALL_STR)) {
            throw new InterpreterException("X01490", new String[]{delimiterStrParam.toString(), this.getName(), STRING_STR});
        }
        if (delimiterStrParam instanceof Value) {
            String delimiterString = ((Value)delimiterStrParam).getString();
            if (delimiterString.equalsIgnoreCase(ALL_STR)) {
                throw new InterpreterException("X01490", new String[]{delimiterString, this.getName(), STRING_STR});
            }
            return delimiterString;
        }
        return (String)delimiterStrParam;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean getALLParameter(Object allReservedWord) throws InterpreterException {
        boolean all = false;
        if (allReservedWord instanceof String && ((String)allReservedWord).equalsIgnoreCase(ALL_STR)) {
            return true;
        }
        if (allReservedWord instanceof String) {
            throw new InterpreterException("X01478", new String[]{allReservedWord.toString()});
        }
        if (!(allReservedWord instanceof Value)) throw new InterpreterException("X01478", new String[]{allReservedWord.getClass().getSimpleName()});
        String allReservedWordString = ((Value)allReservedWord).getString();
        if (!allReservedWordString.equalsIgnoreCase(ALL_STR)) throw new InterpreterException("X01478", new String[]{allReservedWordString.toString()});
        return true;
    }
}

