/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.vb;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IBlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullBehavior;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;

public class Abs
implements Function {
    private static final String ABS_FUNCTION_NAME = "Abs";
    private static final String ZERO = "zero";
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Double.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return Double.class;
    }

    @Override
    public String getName() {
        return ABS_FUNCTION_NAME;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        NullBehavior absNull;
        int paramCount = parameterFetcher.getParameterCount();
        if (paramCount > 1) {
            throw new InterpreterException("X01517", new String[]{"1", this.getName()});
        }
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Block valueParamB = (Block)parameterFetcher.getParameter(0);
        valueParamB.getValues(interpreterContext);
        Block[] wrkBlocks = new Block[]{valueParamB};
        Block block = new Block(interpreterContext, wrkBlocks);
        IBlockIterator blockIter = Block.getBlockIterator(wrkBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Value resultValue = this.doExecute(parameterFetcher, blockObj[0]);
            block.add(blockIter, (Object)resultValue);
        }
        if (block.hasEmptyCells() && (absNull = NullBehavior.getDataSourceNullBehavior(interpreterContext, "null.vb.math.function", NullBehavior.ZERO)) == NullBehavior.ZERO) {
            DoubleValue v = DataValueFactory.createDoubleValue();
            ((Value)v).set(0.0);
            v.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
            block.setDefaultValue(v);
        }
        return block;
    }

    private Value doExecute(ParameterFetcher parameterFetcher, Object value) throws InterpreterException {
        DoubleValue doubleValue = DataValueFactory.createDoubleValue();
        doubleValue.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
        if (value instanceof String) {
            try {
                ((Value)doubleValue).set((String)value);
            }
            catch (Exception e) {
                String paramString = ParameterFetcher.getParameterName(value);
                throw new InterpreterException("X01490", new String[]{paramString, this.getName(), "CMP_TYPENUMERIC"}, 1L, e);
            }
        } else if (value instanceof Double) {
            ((Value)doubleValue).set((Double)value);
        } else if (value instanceof Integer) {
            ((Value)doubleValue).set((Integer)value);
        } else {
            if (value instanceof Value) {
                Value v = (Value)value;
                if (v.isNull()) {
                    String paramString = ParameterFetcher.getParameterName(value);
                    throw new InterpreterException("X01490", new String[]{paramString, this.getName(), "CMP_TYPENUMERIC"});
                }
                if (!v.isOK()) {
                    DoubleValue resultValue = DataValueFactory.createDoubleValue();
                    resultValue.setState(v.getState());
                    return resultValue;
                }
                return this.abs(v);
            }
            String paramString = ParameterFetcher.getParameterName(value);
            throw new InterpreterException("X01490", new String[]{paramString, this.getName(), "CMP_TYPENUMERIC"});
        }
        return this.abs(doubleValue);
    }

    public Double abs(Double value) {
        return new Double(Math.abs(value));
    }

    public Value abs(Value value) {
        double d = 0.0;
        try {
            d = value.getDouble();
        }
        catch (Exception e) {
            mErrorLogger.log(e);
            return TextValue.ERROR_VALUE;
        }
        DoubleValue v = DataValueFactory.createDoubleValue();
        FormatId resultFormatId = value.getFormatId();
        v.setFormatId(resultFormatId);
        ((Value)v).set(Math.abs(d));
        return v;
    }
}

