/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.vb;

import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullObject;

public class Len
implements Function {
    private static final String LEN_FUNCTION_NAME = "Len";

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[0][];
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return null;
    }

    @Override
    public String getName() {
        return LEN_FUNCTION_NAME;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        if (parameterFetcher.getParameterCount() > 1) {
            throw new InterpreterException("X01517", new String[]{"1", this.getName()});
        }
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Block b1 = (Block)parameterFetcher.getParameter(0);
        b1.getValues(interpreterContext);
        Block[] wrkBlocks = new Block[]{b1};
        Block block = new Block(interpreterContext, wrkBlocks);
        BlockIterator blockIter = new BlockIterator(wrkBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Object strLen = this.len(blockObj[0]);
            block.add(blockIter, strLen);
        }
        if (block.hasEmptyCells()) {
            DoubleValue v = DataValueFactory.createDoubleValue();
            ((Value)v).set(0.0);
            v.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
            block.setDefaultValue(v);
        }
        return block;
    }

    private Object len(Object strParam) throws InterpreterException {
        String str = null;
        if (strParam instanceof String) {
            str = (String)strParam;
        } else if (strParam instanceof Double) {
            str = String.valueOf((Double)strParam);
            String[] doubleParts = str.split("\\.");
            int decimalPart = Integer.parseInt(doubleParts[1]);
            if (decimalPart == 0) {
                str = doubleParts[0];
            }
        } else if (strParam instanceof Value) {
            int decimalPos;
            Value v = (Value)strParam;
            if (v.isNull() || v.isError()) {
                return strParam;
            }
            str = v.getString();
            if (v.isNumeric() && (decimalPos = str.indexOf(46)) != -1) {
                str = str.substring(0, decimalPos);
            }
        } else {
            if (strParam == NullObject.instance()) {
                return NullObject.instance();
            }
            if (strParam != null) {
                throw new InterpreterException("X01490", new String[]{strParam.getClass().toString(), this.getName(), "String"});
            }
        }
        if (str == null) {
            return null;
        }
        int strLen = str.length();
        DoubleValue retValue = DataValueFactory.createDoubleValue();
        ((Value)retValue).set(strLen);
        retValue.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
        return retValue;
    }
}

