/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.runtree.olap.mdx.interpreter.BCell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.trace.LogLevel;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;

public class BPlusTreeSetCell1<E>
extends TreeSet<E> {
    private TreeSet<E> treeSetBCell = new TreeSet();
    private InternalNode root;
    private int size;
    private static final InternalNode EXISTNODE = new InternalNode();
    private static final int INTERNALSIZE = 17;
    private static final int LEAFSIZE = 16;
    private static final boolean CACHE = true;
    private LeafNode cachedLeafNode = null;
    private long previousKey = -2L;
    private long cachedMaxKey = Long.MAX_VALUE;

    public BPlusTreeSetCell1() {
        this.clear();
    }

    @Override
    public E ceiling(E e) {
        return this.floor(e);
    }

    @Override
    public E floor(E e) {
        if (e instanceof BCell) {
            return this.treeSetBCell.floor(e);
        }
        if (!(e instanceof Cell)) {
            return null;
        }
        Cell c = (Cell)e;
        long key = c.getOrdinal();
        Node cur = this.root;
        while (cur instanceof InternalNode) {
            InternalNode inode = cur;
            cur = BPlusTreeSetCell1.getInternalNode(inode, key);
        }
        LeafNode ln = (LeafNode)cur;
        return (E)BPlusTreeSetCell1.getInLeaf(ln, key);
    }

    @Override
    public E first() {
        if (this.size() == 0) {
            return this.treeSetBCell.first();
        }
        LeafNode leafNode = BPlusTreeSetCell1.findFirstLeafNode(this.root);
        return (E)leafNode.elem00;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public E last() {
        try {
            return this.treeSetBCell.last();
        }
        catch (NoSuchElementException excp) {
            if (this.size() == 0) {
                throw new NoSuchElementException();
            }
            LeafNode leafNode = BPlusTreeSetCell1.findLastLeafNode(this.root);
            int size = leafNode.getSize();
            Cell c = null;
            switch (size) {
                case 1: {
                    c = leafNode.elem00;
                    break;
                }
                case 2: {
                    c = leafNode.elem01;
                    break;
                }
                case 3: {
                    c = leafNode.elem02;
                    break;
                }
                case 4: {
                    c = leafNode.elem03;
                    break;
                }
                case 5: {
                    c = leafNode.elem04;
                    break;
                }
                case 6: {
                    c = leafNode.elem05;
                    break;
                }
                case 7: {
                    c = leafNode.elem06;
                    break;
                }
                case 8: {
                    c = leafNode.elem07;
                    break;
                }
                case 9: {
                    c = leafNode.elem08;
                    break;
                }
                case 10: {
                    c = leafNode.elem09;
                    break;
                }
                case 11: {
                    c = leafNode.elem10;
                    break;
                }
                case 12: {
                    c = leafNode.elem11;
                    break;
                }
                case 13: {
                    c = leafNode.elem12;
                    break;
                }
                case 14: {
                    c = leafNode.elem13;
                    break;
                }
                case 15: {
                    c = leafNode.elem14;
                    break;
                }
                case 16: {
                    c = leafNode.elem15;
                }
            }
            return (E)c;
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new BPlusTreeSetCell1Iterator();
    }

    @Override
    public int size() {
        return this.size + this.treeSetBCell.size();
    }

    @Override
    public void clear() {
        this.root = new InternalNode();
        this.root.ikey00 = Long.MAX_VALUE;
        this.root.ichild00 = new LeafNode();
        this.root.ichild00.parent = this.root;
        this.root.incSize();
        this.size = 0;
        this.treeSetBCell.clear();
        this.cachedLeafNode = null;
        this.previousKey = -2L;
        this.cachedMaxKey = Long.MAX_VALUE;
    }

    @Override
    public boolean contains(Object e) {
        if (e instanceof BCell) {
            return this.treeSetBCell.contains(e);
        }
        if (!(e instanceof Cell)) {
            return false;
        }
        Cell c = (Cell)e;
        long key = c.getOrdinal();
        Node cur = this.root;
        while (cur instanceof InternalNode) {
            InternalNode inode = cur;
            cur = BPlusTreeSetCell1.getInternalNode(inode, key);
        }
        LeafNode ln = (LeafNode)cur;
        return BPlusTreeSetCell1.findInLeaf(ln, key);
    }

    @Override
    public boolean add(E e) {
        Node newNode;
        if (e == null) {
            throw new NullPointerException();
        }
        if (e instanceof BCell) {
            return this.treeSetBCell.add(e);
        }
        Cell c = (Cell)e;
        if (this.cachedLeafNode != null) {
            long key = c.getOrdinal();
            if (this.previousKey <= key && key < this.cachedMaxKey) {
                newNode = this.root.addAtLeaf(this.cachedLeafNode, c, this);
                if (EXISTNODE.equals(newNode)) {
                    this.previousKey = key;
                    return false;
                }
            } else {
                this.cachedLeafNode = null;
                newNode = this.root.add(c, this);
                if (EXISTNODE.equals(newNode)) {
                    this.previousKey = key;
                    return false;
                }
            }
            this.previousKey = key;
        } else {
            newNode = this.root.add(c, this);
            if (EXISTNODE.equals(newNode)) {
                return false;
            }
        }
        if (newNode != null) {
            InternalNode newRoot = new InternalNode();
            newRoot.ikey00 = 0L;
            newRoot.ikey01 = newNode.getFirstKey();
            newRoot.ichild00 = this.root;
            newRoot.ichild01 = newNode;
            newRoot.setSize(2);
            this.root.parent = newRoot;
            newNode.parent = newRoot;
            this.root = newRoot;
        }
        ++this.size;
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean r = false;
        for (E e : c) {
            if (e instanceof BCell) {
                r |= this.treeSetBCell.add(e);
                continue;
            }
            r |= this.add(e);
        }
        return r;
    }

    private static LeafNode findFirstLeafNode(InternalNode node) {
        Node n = node;
        while (n instanceof InternalNode) {
            node = n;
            n = node.ichild00;
        }
        return (LeafNode)n;
    }

    private static LeafNode findLastLeafNode(InternalNode node) {
        Node n = node;
        while (n instanceof InternalNode) {
            node = n;
            int size = node.getSize();
            n = null;
            switch (size) {
                case 1: {
                    n = node.ichild00;
                    break;
                }
                case 2: {
                    n = node.ichild01;
                    break;
                }
                case 3: {
                    n = node.ichild02;
                    break;
                }
                case 4: {
                    n = node.ichild03;
                    break;
                }
                case 5: {
                    n = node.ichild04;
                    break;
                }
                case 6: {
                    n = node.ichild05;
                    break;
                }
                case 7: {
                    n = node.ichild06;
                    break;
                }
                case 8: {
                    n = node.ichild07;
                    break;
                }
                case 9: {
                    n = node.ichild08;
                    break;
                }
                case 10: {
                    n = node.ichild09;
                    break;
                }
                case 11: {
                    n = node.ichild10;
                    break;
                }
                case 12: {
                    n = node.ichild11;
                    break;
                }
                case 13: {
                    n = node.ichild12;
                    break;
                }
                case 14: {
                    n = node.ichild13;
                    break;
                }
                case 15: {
                    n = node.ichild14;
                    break;
                }
                case 16: {
                    n = node.ichild15;
                    break;
                }
                case 17: {
                    n = node.ichild16;
                }
            }
        }
        return (LeafNode)n;
    }

    private static Node getInternalNode(InternalNode node, long key) {
        if (key < node.ikey08) {
            if (key < node.ikey04) {
                if (key < node.ikey02) {
                    return key < node.ikey01 ? node.ichild00 : node.ichild01;
                }
                return key < node.ikey03 ? node.ichild02 : node.ichild03;
            }
            if (key < node.ikey06) {
                return key < node.ikey05 ? node.ichild04 : node.ichild05;
            }
            return key < node.ikey07 ? node.ichild06 : node.ichild07;
        }
        if (key < node.ikey12) {
            if (key < node.ikey10) {
                return key < node.ikey09 ? node.ichild08 : node.ichild09;
            }
            return key < node.ikey11 ? node.ichild10 : node.ichild11;
        }
        if (key < node.ikey14) {
            return key < node.ikey13 ? node.ichild12 : node.ichild13;
        }
        return key < node.ikey15 ? node.ichild14 : (key < node.ikey16 ? node.ichild15 : node.ichild16);
    }

    private static Node findInternalNode(InternalNode node, long key) {
        if (key == node.ikey00 || key == node.ikey01 || key == node.ikey02 || key == node.ikey03 || key == node.ikey04 || key == node.ikey05 || key == node.ikey06 || key == node.ikey07 || key == node.ikey08 || key == node.ikey09 || key == node.ikey10 || key == node.ikey11 || key == node.ikey12 || key == node.ikey13 || key == node.ikey14 || key == node.ikey15 || key == node.ikey16) {
            return null;
        }
        return BPlusTreeSetCell1.getInternalNode(node, key);
    }

    private static void insertInternalNode(InternalNode node, long key, Node newNode) {
        if (key < node.ikey08) {
            if (key < node.ikey04) {
                if (key < node.ikey02) {
                    if (key < node.ikey01) {
                        node.ikey16 = node.ikey15;
                        node.ikey15 = node.ikey14;
                        node.ikey14 = node.ikey13;
                        node.ikey13 = node.ikey12;
                        node.ikey12 = node.ikey11;
                        node.ikey11 = node.ikey10;
                        node.ikey10 = node.ikey09;
                        node.ikey09 = node.ikey08;
                        node.ikey08 = node.ikey07;
                        node.ikey07 = node.ikey06;
                        node.ikey06 = node.ikey05;
                        node.ikey05 = node.ikey04;
                        node.ikey04 = node.ikey03;
                        node.ikey03 = node.ikey02;
                        node.ikey02 = node.ikey01;
                        node.ichild16 = node.ichild15;
                        node.ichild15 = node.ichild14;
                        node.ichild14 = node.ichild13;
                        node.ichild13 = node.ichild12;
                        node.ichild12 = node.ichild11;
                        node.ichild11 = node.ichild10;
                        node.ichild10 = node.ichild09;
                        node.ichild09 = node.ichild08;
                        node.ichild08 = node.ichild07;
                        node.ichild07 = node.ichild06;
                        node.ichild06 = node.ichild05;
                        node.ichild05 = node.ichild04;
                        node.ichild04 = node.ichild03;
                        node.ichild03 = node.ichild02;
                        node.ichild02 = node.ichild01;
                        node.ikey01 = key;
                        node.ichild01 = newNode;
                    } else {
                        node.ikey16 = node.ikey15;
                        node.ikey15 = node.ikey14;
                        node.ikey14 = node.ikey13;
                        node.ikey13 = node.ikey12;
                        node.ikey12 = node.ikey11;
                        node.ikey11 = node.ikey10;
                        node.ikey10 = node.ikey09;
                        node.ikey09 = node.ikey08;
                        node.ikey08 = node.ikey07;
                        node.ikey07 = node.ikey06;
                        node.ikey06 = node.ikey05;
                        node.ikey05 = node.ikey04;
                        node.ikey04 = node.ikey03;
                        node.ikey03 = node.ikey02;
                        node.ichild16 = node.ichild15;
                        node.ichild15 = node.ichild14;
                        node.ichild14 = node.ichild13;
                        node.ichild13 = node.ichild12;
                        node.ichild12 = node.ichild11;
                        node.ichild11 = node.ichild10;
                        node.ichild10 = node.ichild09;
                        node.ichild09 = node.ichild08;
                        node.ichild08 = node.ichild07;
                        node.ichild07 = node.ichild06;
                        node.ichild06 = node.ichild05;
                        node.ichild05 = node.ichild04;
                        node.ichild04 = node.ichild03;
                        node.ichild03 = node.ichild02;
                        node.ikey02 = key;
                        node.ichild02 = newNode;
                    }
                } else if (key < node.ikey03) {
                    node.ikey16 = node.ikey15;
                    node.ikey15 = node.ikey14;
                    node.ikey14 = node.ikey13;
                    node.ikey13 = node.ikey12;
                    node.ikey12 = node.ikey11;
                    node.ikey11 = node.ikey10;
                    node.ikey10 = node.ikey09;
                    node.ikey09 = node.ikey08;
                    node.ikey08 = node.ikey07;
                    node.ikey07 = node.ikey06;
                    node.ikey06 = node.ikey05;
                    node.ikey05 = node.ikey04;
                    node.ikey04 = node.ikey03;
                    node.ichild16 = node.ichild15;
                    node.ichild15 = node.ichild14;
                    node.ichild14 = node.ichild13;
                    node.ichild13 = node.ichild12;
                    node.ichild12 = node.ichild11;
                    node.ichild11 = node.ichild10;
                    node.ichild10 = node.ichild09;
                    node.ichild09 = node.ichild08;
                    node.ichild08 = node.ichild07;
                    node.ichild07 = node.ichild06;
                    node.ichild06 = node.ichild05;
                    node.ichild05 = node.ichild04;
                    node.ichild04 = node.ichild03;
                    node.ikey03 = key;
                    node.ichild03 = newNode;
                } else {
                    node.ikey16 = node.ikey15;
                    node.ikey15 = node.ikey14;
                    node.ikey14 = node.ikey13;
                    node.ikey13 = node.ikey12;
                    node.ikey12 = node.ikey11;
                    node.ikey11 = node.ikey10;
                    node.ikey10 = node.ikey09;
                    node.ikey09 = node.ikey08;
                    node.ikey08 = node.ikey07;
                    node.ikey07 = node.ikey06;
                    node.ikey06 = node.ikey05;
                    node.ikey05 = node.ikey04;
                    node.ichild16 = node.ichild15;
                    node.ichild15 = node.ichild14;
                    node.ichild14 = node.ichild13;
                    node.ichild13 = node.ichild12;
                    node.ichild12 = node.ichild11;
                    node.ichild11 = node.ichild10;
                    node.ichild10 = node.ichild09;
                    node.ichild09 = node.ichild08;
                    node.ichild08 = node.ichild07;
                    node.ichild07 = node.ichild06;
                    node.ichild06 = node.ichild05;
                    node.ichild05 = node.ichild04;
                    node.ikey04 = key;
                    node.ichild04 = newNode;
                }
            } else if (key < node.ikey06) {
                if (key < node.ikey05) {
                    node.ikey16 = node.ikey15;
                    node.ikey15 = node.ikey14;
                    node.ikey14 = node.ikey13;
                    node.ikey13 = node.ikey12;
                    node.ikey12 = node.ikey11;
                    node.ikey11 = node.ikey10;
                    node.ikey10 = node.ikey09;
                    node.ikey09 = node.ikey08;
                    node.ikey08 = node.ikey07;
                    node.ikey07 = node.ikey06;
                    node.ikey06 = node.ikey05;
                    node.ichild16 = node.ichild15;
                    node.ichild15 = node.ichild14;
                    node.ichild14 = node.ichild13;
                    node.ichild13 = node.ichild12;
                    node.ichild12 = node.ichild11;
                    node.ichild11 = node.ichild10;
                    node.ichild10 = node.ichild09;
                    node.ichild09 = node.ichild08;
                    node.ichild08 = node.ichild07;
                    node.ichild07 = node.ichild06;
                    node.ichild06 = node.ichild05;
                    node.ikey05 = key;
                    node.ichild05 = newNode;
                } else {
                    node.ikey16 = node.ikey15;
                    node.ikey15 = node.ikey14;
                    node.ikey14 = node.ikey13;
                    node.ikey13 = node.ikey12;
                    node.ikey12 = node.ikey11;
                    node.ikey11 = node.ikey10;
                    node.ikey10 = node.ikey09;
                    node.ikey09 = node.ikey08;
                    node.ikey08 = node.ikey07;
                    node.ikey07 = node.ikey06;
                    node.ichild16 = node.ichild15;
                    node.ichild15 = node.ichild14;
                    node.ichild14 = node.ichild13;
                    node.ichild13 = node.ichild12;
                    node.ichild12 = node.ichild11;
                    node.ichild11 = node.ichild10;
                    node.ichild10 = node.ichild09;
                    node.ichild09 = node.ichild08;
                    node.ichild08 = node.ichild07;
                    node.ichild07 = node.ichild06;
                    node.ikey06 = key;
                    node.ichild06 = newNode;
                }
            } else if (key < node.ikey07) {
                node.ikey16 = node.ikey15;
                node.ikey15 = node.ikey14;
                node.ikey14 = node.ikey13;
                node.ikey13 = node.ikey12;
                node.ikey12 = node.ikey11;
                node.ikey11 = node.ikey10;
                node.ikey10 = node.ikey09;
                node.ikey09 = node.ikey08;
                node.ikey08 = node.ikey07;
                node.ichild16 = node.ichild15;
                node.ichild15 = node.ichild14;
                node.ichild14 = node.ichild13;
                node.ichild13 = node.ichild12;
                node.ichild12 = node.ichild11;
                node.ichild11 = node.ichild10;
                node.ichild10 = node.ichild09;
                node.ichild09 = node.ichild08;
                node.ichild08 = node.ichild07;
                node.ikey07 = key;
                node.ichild07 = newNode;
            } else {
                node.ikey16 = node.ikey15;
                node.ikey15 = node.ikey14;
                node.ikey14 = node.ikey13;
                node.ikey13 = node.ikey12;
                node.ikey12 = node.ikey11;
                node.ikey11 = node.ikey10;
                node.ikey10 = node.ikey09;
                node.ikey09 = node.ikey08;
                node.ichild16 = node.ichild15;
                node.ichild15 = node.ichild14;
                node.ichild14 = node.ichild13;
                node.ichild13 = node.ichild12;
                node.ichild12 = node.ichild11;
                node.ichild11 = node.ichild10;
                node.ichild10 = node.ichild09;
                node.ichild09 = node.ichild08;
                node.ikey08 = key;
                node.ichild08 = newNode;
            }
        } else if (key < node.ikey12) {
            if (key < node.ikey10) {
                if (key < node.ikey09) {
                    node.ikey16 = node.ikey15;
                    node.ikey15 = node.ikey14;
                    node.ikey14 = node.ikey13;
                    node.ikey13 = node.ikey12;
                    node.ikey12 = node.ikey11;
                    node.ikey11 = node.ikey10;
                    node.ikey10 = node.ikey09;
                    node.ichild16 = node.ichild15;
                    node.ichild15 = node.ichild14;
                    node.ichild14 = node.ichild13;
                    node.ichild13 = node.ichild12;
                    node.ichild12 = node.ichild11;
                    node.ichild11 = node.ichild10;
                    node.ichild10 = node.ichild09;
                    node.ikey09 = key;
                    node.ichild09 = newNode;
                } else {
                    node.ikey16 = node.ikey15;
                    node.ikey15 = node.ikey14;
                    node.ikey14 = node.ikey13;
                    node.ikey13 = node.ikey12;
                    node.ikey12 = node.ikey11;
                    node.ikey11 = node.ikey10;
                    node.ichild16 = node.ichild15;
                    node.ichild15 = node.ichild14;
                    node.ichild14 = node.ichild13;
                    node.ichild13 = node.ichild12;
                    node.ichild12 = node.ichild11;
                    node.ichild11 = node.ichild10;
                    node.ikey10 = key;
                    node.ichild10 = newNode;
                }
            } else if (key < node.ikey11) {
                node.ikey16 = node.ikey15;
                node.ikey15 = node.ikey14;
                node.ikey14 = node.ikey13;
                node.ikey13 = node.ikey12;
                node.ikey12 = node.ikey11;
                node.ichild16 = node.ichild15;
                node.ichild15 = node.ichild14;
                node.ichild14 = node.ichild13;
                node.ichild13 = node.ichild12;
                node.ichild12 = node.ichild11;
                node.ikey11 = key;
                node.ichild11 = newNode;
            } else {
                node.ikey16 = node.ikey15;
                node.ikey15 = node.ikey14;
                node.ikey14 = node.ikey13;
                node.ikey13 = node.ikey12;
                node.ichild16 = node.ichild15;
                node.ichild15 = node.ichild14;
                node.ichild14 = node.ichild13;
                node.ichild13 = node.ichild12;
                node.ikey12 = key;
                node.ichild12 = newNode;
            }
        } else if (key < node.ikey14) {
            if (key < node.ikey13) {
                node.ikey16 = node.ikey15;
                node.ikey15 = node.ikey14;
                node.ikey14 = node.ikey13;
                node.ichild16 = node.ichild15;
                node.ichild15 = node.ichild14;
                node.ichild14 = node.ichild13;
                node.ikey13 = key;
                node.ichild13 = newNode;
            } else {
                node.ikey16 = node.ikey15;
                node.ikey15 = node.ikey14;
                node.ichild16 = node.ichild15;
                node.ichild15 = node.ichild14;
                node.ikey14 = key;
                node.ichild14 = newNode;
            }
        } else if (key < node.ikey15) {
            node.ikey16 = node.ikey15;
            node.ikey15 = key;
            node.ichild16 = node.ichild15;
            node.ichild15 = newNode;
        } else {
            node.ikey16 = key;
            node.ichild16 = newNode;
        }
    }

    private static LeafNode findLeafNode(InternalNode node, long key) {
        Node n = node;
        while (n instanceof InternalNode) {
            node = n;
            n = BPlusTreeSetCell1.getInternalNode(node, key);
        }
        return (LeafNode)n;
    }

    private static boolean findInLeaf(LeafNode node, long key) {
        return key == node.key00 || key == node.key01 || key == node.key02 || key == node.key03 || key == node.key04 || key == node.key05 || key == node.key06 || key == node.key07 || key == node.key08 || key == node.key09 || key == node.key10 || key == node.key11 || key == node.key12 || key == node.key13 || key == node.key14 || key == node.key15;
    }

    private static Object getInLeaf(LeafNode node, long key) {
        Cell r = null;
        if (key == node.key00) {
            r = node.elem00;
        } else if (key == node.key01) {
            r = node.elem01;
        } else if (key == node.key02) {
            r = node.elem02;
        } else if (key == node.key03) {
            r = node.elem03;
        } else if (key == node.key04) {
            r = node.elem04;
        } else if (key == node.key05) {
            r = node.elem05;
        } else if (key == node.key06) {
            r = node.elem06;
        } else if (key == node.key07) {
            r = node.elem07;
        } else if (key == node.key08) {
            r = node.elem08;
        } else if (key == node.key09) {
            r = node.elem09;
        } else if (key == node.key10) {
            r = node.elem10;
        } else if (key == node.key11) {
            r = node.elem11;
        } else if (key == node.key12) {
            r = node.elem12;
        } else if (key == node.key13) {
            r = node.elem13;
        } else if (key == node.key14) {
            r = node.elem14;
        } else if (key == node.key15) {
            r = node.elem15;
        }
        return r;
    }

    private static void insertLeafElement(LeafNode node, Cell e, long key) {
        if (key < node.key08) {
            if (key < node.key04) {
                if (key < node.key02) {
                    if (key < node.key01) {
                        if (key < node.key00) {
                            node.key15 = node.key14;
                            node.key14 = node.key13;
                            node.key13 = node.key12;
                            node.key12 = node.key11;
                            node.key11 = node.key10;
                            node.key10 = node.key09;
                            node.key09 = node.key08;
                            node.key08 = node.key07;
                            node.key07 = node.key06;
                            node.key06 = node.key05;
                            node.key05 = node.key04;
                            node.key04 = node.key03;
                            node.key03 = node.key02;
                            node.key02 = node.key01;
                            node.key01 = node.key00;
                            node.elem15 = node.elem14;
                            node.elem14 = node.elem13;
                            node.elem13 = node.elem12;
                            node.elem12 = node.elem11;
                            node.elem11 = node.elem10;
                            node.elem10 = node.elem09;
                            node.elem09 = node.elem08;
                            node.elem08 = node.elem07;
                            node.elem07 = node.elem06;
                            node.elem06 = node.elem05;
                            node.elem05 = node.elem04;
                            node.elem04 = node.elem03;
                            node.elem03 = node.elem02;
                            node.elem02 = node.elem01;
                            node.elem01 = node.elem00;
                            node.key00 = key;
                            node.elem00 = e;
                        } else {
                            node.key15 = node.key14;
                            node.key14 = node.key13;
                            node.key13 = node.key12;
                            node.key12 = node.key11;
                            node.key11 = node.key10;
                            node.key10 = node.key09;
                            node.key09 = node.key08;
                            node.key08 = node.key07;
                            node.key07 = node.key06;
                            node.key06 = node.key05;
                            node.key05 = node.key04;
                            node.key04 = node.key03;
                            node.key03 = node.key02;
                            node.key02 = node.key01;
                            node.elem15 = node.elem14;
                            node.elem14 = node.elem13;
                            node.elem13 = node.elem12;
                            node.elem12 = node.elem11;
                            node.elem11 = node.elem10;
                            node.elem10 = node.elem09;
                            node.elem09 = node.elem08;
                            node.elem08 = node.elem07;
                            node.elem07 = node.elem06;
                            node.elem06 = node.elem05;
                            node.elem05 = node.elem04;
                            node.elem04 = node.elem03;
                            node.elem03 = node.elem02;
                            node.elem02 = node.elem01;
                            node.key01 = key;
                            node.elem01 = e;
                        }
                    } else {
                        node.key15 = node.key14;
                        node.key14 = node.key13;
                        node.key13 = node.key12;
                        node.key12 = node.key11;
                        node.key11 = node.key10;
                        node.key10 = node.key09;
                        node.key09 = node.key08;
                        node.key08 = node.key07;
                        node.key07 = node.key06;
                        node.key06 = node.key05;
                        node.key05 = node.key04;
                        node.key04 = node.key03;
                        node.key03 = node.key02;
                        node.elem15 = node.elem14;
                        node.elem14 = node.elem13;
                        node.elem13 = node.elem12;
                        node.elem12 = node.elem11;
                        node.elem11 = node.elem10;
                        node.elem10 = node.elem09;
                        node.elem09 = node.elem08;
                        node.elem08 = node.elem07;
                        node.elem07 = node.elem06;
                        node.elem06 = node.elem05;
                        node.elem05 = node.elem04;
                        node.elem04 = node.elem03;
                        node.elem03 = node.elem02;
                        node.key02 = key;
                        node.elem02 = e;
                    }
                } else if (key < node.key03) {
                    node.key15 = node.key14;
                    node.key14 = node.key13;
                    node.key13 = node.key12;
                    node.key12 = node.key11;
                    node.key11 = node.key10;
                    node.key10 = node.key09;
                    node.key09 = node.key08;
                    node.key08 = node.key07;
                    node.key07 = node.key06;
                    node.key06 = node.key05;
                    node.key05 = node.key04;
                    node.key04 = node.key03;
                    node.elem15 = node.elem14;
                    node.elem14 = node.elem13;
                    node.elem13 = node.elem12;
                    node.elem12 = node.elem11;
                    node.elem11 = node.elem10;
                    node.elem10 = node.elem09;
                    node.elem09 = node.elem08;
                    node.elem08 = node.elem07;
                    node.elem07 = node.elem06;
                    node.elem06 = node.elem05;
                    node.elem05 = node.elem04;
                    node.elem04 = node.elem03;
                    node.key03 = key;
                    node.elem03 = e;
                } else {
                    node.key15 = node.key14;
                    node.key14 = node.key13;
                    node.key13 = node.key12;
                    node.key12 = node.key11;
                    node.key11 = node.key10;
                    node.key10 = node.key09;
                    node.key09 = node.key08;
                    node.key08 = node.key07;
                    node.key07 = node.key06;
                    node.key06 = node.key05;
                    node.key05 = node.key04;
                    node.elem15 = node.elem14;
                    node.elem14 = node.elem13;
                    node.elem13 = node.elem12;
                    node.elem12 = node.elem11;
                    node.elem11 = node.elem10;
                    node.elem10 = node.elem09;
                    node.elem09 = node.elem08;
                    node.elem08 = node.elem07;
                    node.elem07 = node.elem06;
                    node.elem06 = node.elem05;
                    node.elem05 = node.elem04;
                    node.key04 = key;
                    node.elem04 = e;
                }
            } else if (key < node.key06) {
                if (key < node.key05) {
                    node.key15 = node.key14;
                    node.key14 = node.key13;
                    node.key13 = node.key12;
                    node.key12 = node.key11;
                    node.key11 = node.key10;
                    node.key10 = node.key09;
                    node.key09 = node.key08;
                    node.key08 = node.key07;
                    node.key07 = node.key06;
                    node.key06 = node.key05;
                    node.elem15 = node.elem14;
                    node.elem14 = node.elem13;
                    node.elem13 = node.elem12;
                    node.elem12 = node.elem11;
                    node.elem11 = node.elem10;
                    node.elem10 = node.elem09;
                    node.elem09 = node.elem08;
                    node.elem08 = node.elem07;
                    node.elem07 = node.elem06;
                    node.elem06 = node.elem05;
                    node.key05 = key;
                    node.elem05 = e;
                } else {
                    node.key15 = node.key14;
                    node.key14 = node.key13;
                    node.key13 = node.key12;
                    node.key12 = node.key11;
                    node.key11 = node.key10;
                    node.key10 = node.key09;
                    node.key09 = node.key08;
                    node.key08 = node.key07;
                    node.key07 = node.key06;
                    node.elem15 = node.elem14;
                    node.elem14 = node.elem13;
                    node.elem13 = node.elem12;
                    node.elem12 = node.elem11;
                    node.elem11 = node.elem10;
                    node.elem10 = node.elem09;
                    node.elem09 = node.elem08;
                    node.elem08 = node.elem07;
                    node.elem07 = node.elem06;
                    node.key06 = key;
                    node.elem06 = e;
                }
            } else if (key < node.key07) {
                node.key15 = node.key14;
                node.key14 = node.key13;
                node.key13 = node.key12;
                node.key12 = node.key11;
                node.key11 = node.key10;
                node.key10 = node.key09;
                node.key09 = node.key08;
                node.key08 = node.key07;
                node.elem15 = node.elem14;
                node.elem14 = node.elem13;
                node.elem13 = node.elem12;
                node.elem12 = node.elem11;
                node.elem11 = node.elem10;
                node.elem10 = node.elem09;
                node.elem09 = node.elem08;
                node.elem08 = node.elem07;
                node.key07 = key;
                node.elem07 = e;
            } else {
                node.key15 = node.key14;
                node.key14 = node.key13;
                node.key13 = node.key12;
                node.key12 = node.key11;
                node.key11 = node.key10;
                node.key10 = node.key09;
                node.key09 = node.key08;
                node.elem15 = node.elem14;
                node.elem14 = node.elem13;
                node.elem13 = node.elem12;
                node.elem12 = node.elem11;
                node.elem11 = node.elem10;
                node.elem10 = node.elem09;
                node.elem09 = node.elem08;
                node.key08 = key;
                node.elem08 = e;
            }
        } else if (key < node.key12) {
            if (key < node.key10) {
                if (key < node.key09) {
                    node.key15 = node.key14;
                    node.key14 = node.key13;
                    node.key13 = node.key12;
                    node.key12 = node.key11;
                    node.key11 = node.key10;
                    node.key10 = node.key09;
                    node.elem15 = node.elem14;
                    node.elem14 = node.elem13;
                    node.elem13 = node.elem12;
                    node.elem12 = node.elem11;
                    node.elem11 = node.elem10;
                    node.elem10 = node.elem09;
                    node.key09 = key;
                    node.elem09 = e;
                } else {
                    node.key15 = node.key14;
                    node.key14 = node.key13;
                    node.key13 = node.key12;
                    node.key12 = node.key11;
                    node.key11 = node.key10;
                    node.elem15 = node.elem14;
                    node.elem14 = node.elem13;
                    node.elem13 = node.elem12;
                    node.elem12 = node.elem11;
                    node.elem11 = node.elem10;
                    node.key10 = key;
                    node.elem10 = e;
                }
            } else if (key < node.key11) {
                node.key15 = node.key14;
                node.key14 = node.key13;
                node.key13 = node.key12;
                node.key12 = node.key11;
                node.elem15 = node.elem14;
                node.elem14 = node.elem13;
                node.elem13 = node.elem12;
                node.elem12 = node.elem11;
                node.key11 = key;
                node.elem11 = e;
            } else {
                node.key15 = node.key14;
                node.key14 = node.key13;
                node.key13 = node.key12;
                node.elem15 = node.elem14;
                node.elem14 = node.elem13;
                node.elem13 = node.elem12;
                node.key12 = key;
                node.elem12 = e;
            }
        } else if (key < node.key14) {
            if (key < node.key13) {
                node.key15 = node.key14;
                node.key14 = node.key13;
                node.elem15 = node.elem14;
                node.elem14 = node.elem13;
                node.key13 = key;
                node.elem13 = e;
            } else {
                node.key15 = node.key14;
                node.elem15 = node.elem14;
                node.key14 = key;
                node.elem14 = e;
            }
        } else {
            node.key15 = key;
            node.elem15 = e;
        }
    }

    @Override
    public Object clone() {
        ROLAPLog.getLogger("ROLAPCubes.Loader").log(LogLevel.ERROR, "clone");
        throw new UnsupportedOperationException();
    }

    @Override
    public Comparator<? super E> comparator() {
        ROLAPLog.getLogger("ROLAPCubes.Loader").log(LogLevel.ERROR, "comparator");
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> descendingIterator() {
        ROLAPLog.getLogger("ROLAPCubes.Loader").log(LogLevel.ERROR, "descendingIterator");
        throw new UnsupportedOperationException();
    }

    @Override
    public NavigableSet<E> descendingSet() {
        ROLAPLog.getLogger("ROLAPCubes.Loader").log(LogLevel.ERROR, "descendingSet");
        throw new UnsupportedOperationException();
    }

    @Override
    public NavigableSet<E> headSet(E toElement, boolean inclusive) {
        ROLAPLog.getLogger("ROLAPCubes.Loader").log(LogLevel.ERROR, "headSet");
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        ROLAPLog.getLogger("ROLAPCubes.Loader").log(LogLevel.ERROR, "headSet");
        throw new UnsupportedOperationException();
    }

    @Override
    public E higher(E e) {
        ROLAPLog.getLogger("ROLAPCubes.Loader").log(LogLevel.ERROR, "higher");
        throw new UnsupportedOperationException();
    }

    @Override
    public E lower(E e) {
        ROLAPLog.getLogger("ROLAPCubes.Loader").log(LogLevel.ERROR, "lower");
        throw new UnsupportedOperationException();
    }

    @Override
    public E pollFirst() {
        ROLAPLog.getLogger("ROLAPCubes.Loader").log(LogLevel.ERROR, "pollFirst");
        throw new UnsupportedOperationException();
    }

    @Override
    public E pollLast() {
        ROLAPLog.getLogger("ROLAPCubes.Loader").log(LogLevel.ERROR, "pollLast");
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        ROLAPLog.getLogger("ROLAPCubes.Loader").log(LogLevel.ERROR, "remove");
        throw new UnsupportedOperationException();
    }

    @Override
    public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        ROLAPLog.getLogger("ROLAPCubes.Loader").log(LogLevel.ERROR, "subSet");
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        ROLAPLog.getLogger("ROLAPCubes.Loader").log(LogLevel.ERROR, "subSet");
        throw new UnsupportedOperationException();
    }

    @Override
    public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        ROLAPLog.getLogger("ROLAPCubes.Loader").log(LogLevel.ERROR, "tailSet");
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        ROLAPLog.getLogger("ROLAPCubes.Loader").log(LogLevel.ERROR, "tailSet");
        throw new UnsupportedOperationException();
    }

    private static class LeafNode
    extends Node {
        long key00;
        long key01;
        long key02;
        long key03;
        long key04;
        long key05;
        long key06;
        long key07;
        long key08;
        long key09;
        long key10;
        long key11;
        long key12;
        long key13;
        long key14;
        long key15 = Long.MAX_VALUE;
        Cell elem00;
        Cell elem01;
        Cell elem02;
        Cell elem03;
        Cell elem04;
        Cell elem05;
        Cell elem06;
        Cell elem07;
        Cell elem08;
        Cell elem09;
        Cell elem10;
        Cell elem11;
        Cell elem12;
        Cell elem13;
        Cell elem14;
        Cell elem15;
        private LeafNode prev = null;
        private LeafNode next = null;

        public LeafNode() {
            this.key14 = Long.MAX_VALUE;
            this.key13 = Long.MAX_VALUE;
            this.key12 = Long.MAX_VALUE;
            this.key11 = Long.MAX_VALUE;
            this.key10 = Long.MAX_VALUE;
            this.key09 = Long.MAX_VALUE;
            this.key08 = Long.MAX_VALUE;
            this.key07 = Long.MAX_VALUE;
            this.key06 = Long.MAX_VALUE;
            this.key05 = Long.MAX_VALUE;
            this.key04 = Long.MAX_VALUE;
            this.key03 = Long.MAX_VALUE;
            this.key02 = Long.MAX_VALUE;
            this.key01 = Long.MAX_VALUE;
            this.key00 = Long.MAX_VALUE;
        }

        @Override
        public long getFirstKey() {
            return this.key00;
        }

        @Override
        public Node addAtLeaf(LeafNode leafNode, Cell e, BPlusTreeSetCell1 bpt) {
            return null;
        }

        @Override
        public Node add(Cell e, BPlusTreeSetCell1 bpt) {
            long key = e.getOrdinal();
            if (BPlusTreeSetCell1.findInLeaf(this, key)) {
                if (this.next != null) {
                    bpt.cachedMaxKey = this.next.key00;
                } else {
                    bpt.cachedMaxKey = Long.MAX_VALUE;
                }
                bpt.cachedLeafNode = this;
                return EXISTNODE;
            }
            LeafNode newLeaf = null;
            if (this.getSize() != 16) {
                BPlusTreeSetCell1.insertLeafElement(this, e, key);
                this.incSize();
                if (this.next != null) {
                    bpt.cachedMaxKey = this.next.key00;
                } else {
                    bpt.cachedMaxKey = Long.MAX_VALUE;
                }
                bpt.cachedLeafNode = this;
            } else {
                newLeaf = this.split();
                if (key < newLeaf.getFirstKey()) {
                    BPlusTreeSetCell1.insertLeafElement(this, e, key);
                    this.incSize();
                    bpt.cachedMaxKey = this.next.key00;
                    bpt.cachedLeafNode = this;
                } else {
                    BPlusTreeSetCell1.insertLeafElement(newLeaf, e, key);
                    newLeaf.incSize();
                    if (newLeaf.next != null) {
                        bpt.cachedMaxKey = newLeaf.next.key00;
                    } else {
                        bpt.cachedMaxKey = Long.MAX_VALUE;
                    }
                    bpt.cachedLeafNode = newLeaf;
                }
            }
            return newLeaf;
        }

        private final LeafNode split() {
            LeafNode newLeaf = new LeafNode();
            newLeaf.parent = this.parent;
            newLeaf.key00 = this.key08;
            newLeaf.key01 = this.key09;
            newLeaf.key02 = this.key10;
            newLeaf.key03 = this.key11;
            newLeaf.key04 = this.key12;
            newLeaf.key05 = this.key13;
            newLeaf.key06 = this.key14;
            newLeaf.key07 = this.key15;
            newLeaf.elem00 = this.elem08;
            newLeaf.elem01 = this.elem09;
            newLeaf.elem02 = this.elem10;
            newLeaf.elem03 = this.elem11;
            newLeaf.elem04 = this.elem12;
            newLeaf.elem05 = this.elem13;
            newLeaf.elem06 = this.elem14;
            newLeaf.elem07 = this.elem15;
            newLeaf.setSize(8);
            this.key08 = Long.MAX_VALUE;
            this.key09 = Long.MAX_VALUE;
            this.key10 = Long.MAX_VALUE;
            this.key11 = Long.MAX_VALUE;
            this.key12 = Long.MAX_VALUE;
            this.key13 = Long.MAX_VALUE;
            this.key14 = Long.MAX_VALUE;
            this.key15 = Long.MAX_VALUE;
            this.setSize(8);
            newLeaf.next = this.next;
            newLeaf.prev = this;
            if (this.next != null) {
                this.next.prev = newLeaf;
            }
            this.next = newLeaf;
            return newLeaf;
        }
    }

    private static class InternalNode
    extends Node {
        long ikey00;
        long ikey01;
        long ikey02;
        long ikey03;
        long ikey04;
        long ikey05;
        long ikey06;
        long ikey07;
        long ikey08;
        long ikey09;
        long ikey10;
        long ikey11;
        long ikey12;
        long ikey13;
        long ikey14;
        long ikey15;
        long ikey16 = Long.MAX_VALUE;
        Node ichild00;
        Node ichild01;
        Node ichild02;
        Node ichild03;
        Node ichild04;
        Node ichild05;
        Node ichild06;
        Node ichild07;
        Node ichild08;
        Node ichild09;
        Node ichild10;
        Node ichild11;
        Node ichild12;
        Node ichild13;
        Node ichild14;
        Node ichild15;
        Node ichild16;

        public InternalNode() {
            this.ikey15 = Long.MAX_VALUE;
            this.ikey14 = Long.MAX_VALUE;
            this.ikey13 = Long.MAX_VALUE;
            this.ikey12 = Long.MAX_VALUE;
            this.ikey11 = Long.MAX_VALUE;
            this.ikey10 = Long.MAX_VALUE;
            this.ikey09 = Long.MAX_VALUE;
            this.ikey08 = Long.MAX_VALUE;
            this.ikey07 = Long.MAX_VALUE;
            this.ikey06 = Long.MAX_VALUE;
            this.ikey05 = Long.MAX_VALUE;
            this.ikey04 = Long.MAX_VALUE;
            this.ikey03 = Long.MAX_VALUE;
            this.ikey02 = Long.MAX_VALUE;
            this.ikey01 = Long.MAX_VALUE;
            this.ikey00 = Long.MAX_VALUE;
        }

        @Override
        public long getFirstKey() {
            return this.ikey00;
        }

        @Override
        public final Node add(Cell e, BPlusTreeSetCell1 bpt) {
            InternalNode newInternal = null;
            long key = e.getOrdinal();
            LeafNode leafNode = BPlusTreeSetCell1.findLeafNode(this, key);
            if (leafNode == null) {
                return EXISTNODE;
            }
            Node newNode = leafNode.add(e, bpt);
            if (newNode == EXISTNODE) {
                return EXISTNODE;
            }
            if (newNode == null) {
                return null;
            }
            newInternal = newNode.parent;
            do {
                boolean needSplit;
                boolean bl = needSplit = newInternal.getSize() == 17;
                if (!needSplit) {
                    BPlusTreeSetCell1.insertInternalNode(newInternal, newNode.getFirstKey(), newNode);
                    newInternal.incSize();
                    return null;
                }
                InternalNode in = (InternalNode)newInternal.split();
                if (newNode.getFirstKey() < in.getFirstKey()) {
                    BPlusTreeSetCell1.insertInternalNode(newInternal, newNode.getFirstKey(), newNode);
                    newInternal.incSize();
                } else {
                    BPlusTreeSetCell1.insertInternalNode(in, newNode.getFirstKey(), newNode);
                    newNode.parent = in;
                    in.incSize();
                }
                newNode = in;
            } while ((newInternal = newNode.parent) != null);
            return newNode;
        }

        @Override
        public final Node addAtLeaf(LeafNode leafNode, Cell e, BPlusTreeSetCell1 bpt) {
            InternalNode newInternal = null;
            long key = e.getOrdinal();
            Node newNode = leafNode.add(e, bpt);
            if (newNode == EXISTNODE) {
                return EXISTNODE;
            }
            if (newNode == null) {
                return null;
            }
            newInternal = newNode.parent;
            do {
                boolean needSplit;
                boolean bl = needSplit = newInternal.getSize() == 17;
                if (!needSplit) {
                    BPlusTreeSetCell1.insertInternalNode(newInternal, newNode.getFirstKey(), newNode);
                    newInternal.incSize();
                    return null;
                }
                InternalNode in = (InternalNode)newInternal.split();
                if (newNode.getFirstKey() < in.getFirstKey()) {
                    BPlusTreeSetCell1.insertInternalNode(newInternal, newNode.getFirstKey(), newNode);
                    newInternal.incSize();
                } else {
                    BPlusTreeSetCell1.insertInternalNode(in, newNode.getFirstKey(), newNode);
                    newNode.parent = in;
                    in.incSize();
                }
                newNode = in;
            } while ((newInternal = newNode.parent) != null);
            return newNode;
        }

        private final Node split() {
            InternalNode newInternal = new InternalNode();
            newInternal.parent = this.parent;
            newInternal.ikey00 = this.ikey09;
            newInternal.ikey01 = this.ikey10;
            newInternal.ikey02 = this.ikey11;
            newInternal.ikey03 = this.ikey12;
            newInternal.ikey04 = this.ikey13;
            newInternal.ikey05 = this.ikey14;
            newInternal.ikey06 = this.ikey15;
            newInternal.ikey07 = this.ikey16;
            newInternal.ichild00 = this.ichild09;
            newInternal.ichild01 = this.ichild10;
            newInternal.ichild02 = this.ichild11;
            newInternal.ichild03 = this.ichild12;
            newInternal.ichild04 = this.ichild13;
            newInternal.ichild05 = this.ichild14;
            newInternal.ichild06 = this.ichild15;
            newInternal.ichild07 = this.ichild16;
            newInternal.ichild00.parent = newInternal;
            newInternal.ichild01.parent = newInternal;
            newInternal.ichild02.parent = newInternal;
            newInternal.ichild03.parent = newInternal;
            newInternal.ichild04.parent = newInternal;
            newInternal.ichild05.parent = newInternal;
            newInternal.ichild06.parent = newInternal;
            newInternal.ichild07.parent = newInternal;
            newInternal.setSize(8);
            this.ikey09 = Long.MAX_VALUE;
            this.ikey10 = Long.MAX_VALUE;
            this.ikey11 = Long.MAX_VALUE;
            this.ikey12 = Long.MAX_VALUE;
            this.ikey13 = Long.MAX_VALUE;
            this.ikey14 = Long.MAX_VALUE;
            this.ikey15 = Long.MAX_VALUE;
            this.ikey16 = Long.MAX_VALUE;
            this.setSize(9);
            return newInternal;
        }
    }

    private static abstract class Node {
        private int size;
        public InternalNode parent;

        private Node() {
        }

        public final void setSize(int i) {
            this.size = i;
        }

        public final int getSize() {
            return this.size;
        }

        public final void incSize() {
            ++this.size;
        }

        public abstract long getFirstKey();

        public abstract Node add(Cell var1, BPlusTreeSetCell1 var2);

        public abstract Node addAtLeaf(LeafNode var1, Cell var2, BPlusTreeSetCell1 var3);
    }

    class BPlusTreeSetCell1Iterator<E>
    implements Iterator<E> {
        LeafNode currentLeafNode;
        int offset;

        BPlusTreeSetCell1Iterator() {
            this.currentLeafNode = BPlusTreeSetCell1.findFirstLeafNode(BPlusTreeSetCell1.this.root);
        }

        @Override
        public final boolean hasNext() {
            if (this.currentLeafNode == null) {
                return false;
            }
            while (this.offset >= this.currentLeafNode.getSize()) {
                this.currentLeafNode = this.currentLeafNode.next;
                if (this.currentLeafNode == null) {
                    return false;
                }
                this.offset = 0;
            }
            return true;
        }

        @Override
        public final E next() {
            Cell e = this.offset == 0 ? this.currentLeafNode.elem00 : (this.offset == 1 ? this.currentLeafNode.elem01 : (this.offset == 2 ? this.currentLeafNode.elem02 : (this.offset == 3 ? this.currentLeafNode.elem03 : (this.offset == 4 ? this.currentLeafNode.elem04 : (this.offset == 5 ? this.currentLeafNode.elem05 : (this.offset == 6 ? this.currentLeafNode.elem06 : (this.offset == 7 ? this.currentLeafNode.elem07 : (this.offset == 8 ? this.currentLeafNode.elem08 : (this.offset == 9 ? this.currentLeafNode.elem09 : (this.offset == 10 ? this.currentLeafNode.elem10 : (this.offset == 11 ? this.currentLeafNode.elem11 : (this.offset == 12 ? this.currentLeafNode.elem12 : (this.offset == 13 ? this.currentLeafNode.elem13 : (this.offset == 14 ? this.currentLeafNode.elem14 : this.currentLeafNode.elem15))))))))))))));
            ++this.offset;
            return (E)e;
        }

        @Override
        public final void remove() {
        }
    }
}

