/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.runtree.olap.mdx.interpreter.AbstractBlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.util.OrdinalMath;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.Arrays;

public class BlockIterator
extends AbstractBlockIterator {
    private static final long ITERATOR_MARKER = Long.MIN_VALUE;
    private static final long TEN = 10L;
    private static final long DEGENERATE_ORDINAL = -9223372036854775798L;
    private boolean hasNext;
    private final Cell[][] blockCells;
    private final Object[] defaultValues;
    private boolean defValueReturned;
    private boolean oneFullBlock;
    private final int[] blockOrdIdx;
    private final boolean[] blockObjNull;
    private final boolean[][] resetObjNullFlag;
    private final long[][] setOrd;
    private final boolean[][] isDegenerated;
    private final long[] currSetOrd;
    private final int[][] blockOrdIdxCopy;
    private final Block[] srcBlocks;
    private Object nextObj;
    private long nextBlockOrdSurrogateId;
    private boolean sparseIteration = false;
    private long[] childBlockOrdinalsUsed;
    private final CancelManager cancelManager = ExecutionEnvironmentContext.getExecutionEnvironment().getCancelManager();

    public BlockIterator(Block[] blocks) {
        this(blocks, false);
    }

    public BlockIterator(Block[] blocks, boolean sparseIter) {
        this(blocks, sparseIter, blocks);
    }

    private BlockIterator(Block[] blocks, boolean sparseIter, Block[] theBlockSets) {
        super(theBlockSets);
        int hierIdx;
        this.childBlockOrdinalsUsed = new long[blocks.length];
        for (Block blk : this.srcBlocks = blocks) {
            if (!blk.isPipelining()) continue;
            throw new UnsupportedOperationException("cannot use blockiterator on pipeline blocks");
        }
        this.setOrd = new long[this.srcBlocks.length][this.blockSets.length];
        this.blockOrdIdx = new int[this.srcBlocks.length];
        this.blockObjNull = new boolean[this.srcBlocks.length];
        for (int i = 0; i < this.srcBlocks.length; ++i) {
            this.blockOrdIdx[i] = 0;
            this.blockObjNull[i] = false;
        }
        this.resetObjNullFlag = new boolean[this.srcBlocks.length][this.blockSets.length];
        ArrayList[] childBlockHiers = new ArrayList[this.srcBlocks.length];
        this.blockCells = new Cell[this.srcBlocks.length][0];
        this.defaultValues = new Object[this.srcBlocks.length];
        this.defValueReturned = false;
        this.oneFullBlock = false;
        for (int blockIdx = 0; blockIdx < this.srcBlocks.length; ++blockIdx) {
            childBlockHiers[blockIdx] = new ArrayList();
            for (int setIdx = 0; setIdx < this.srcBlocks[blockIdx].getSets().length; ++setIdx) {
                IHierarchy[] setHiers = this.srcBlocks[blockIdx].getSets()[setIdx].getHierarchies();
                for (hierIdx = 0; hierIdx < setHiers.length; ++hierIdx) {
                    childBlockHiers[blockIdx].add(setHiers[hierIdx]);
                }
            }
            this.blockCells[blockIdx] = this.srcBlocks[blockIdx].cellSet.toArray(new Cell[0]);
            int cellCount = this.srcBlocks[blockIdx].cellSetSize();
            long tupleCount = this.srcBlocks[blockIdx].tupleSetSize();
            if (cellCount == 0 || tupleCount < 0L || tupleCount > (long)cellCount) {
                this.defaultValues[blockIdx] = this.srcBlocks[blockIdx].getDefaultValue();
                continue;
            }
            this.oneFullBlock = true;
        }
        this.isDegenerated = new boolean[this.srcBlocks.length][this.blockSets.length];
        for (int setIdx = 0; setIdx < this.blockSets.length; ++setIdx) {
            IHierarchy[] setHiers = this.blockSets[setIdx].getHierarchies();
            block6: for (int blockIdx = 0; blockIdx < this.srcBlocks.length; ++blockIdx) {
                this.isDegenerated[blockIdx][setIdx] = true;
                for (hierIdx = 0; hierIdx < setHiers.length; ++hierIdx) {
                    if (!childBlockHiers[blockIdx].contains(setHiers[hierIdx])) continue;
                    this.isDegenerated[blockIdx][setIdx] = false;
                    continue block6;
                }
            }
        }
        this.currSetOrd = new long[this.blockSets.length];
        for (int i = 0; i < this.currSetOrd.length; ++i) {
            this.currSetOrd[i] = Long.MIN_VALUE;
            for (int j = 0; j < this.srcBlocks.length; ++j) {
                this.setOrd[j][i] = this.isDegenerated[j][i] ? -9223372036854775798L : Long.MIN_VALUE;
            }
        }
        this.blockOrdIdxCopy = new int[this.blockSets.length][this.srcBlocks.length];
        this.sparseIteration = sparseIter;
        this.hasNext = true;
        this.nextObj = this.getNext(true);
        this.nextBlockOrdSurrogateId = this.calcSearchBlockOrd();
    }

    public BlockIterator(Block[] theSrcBlocks, Block[] theBlockSets) {
        this(theSrcBlocks, false, theBlockSets);
    }

    @Override
    public boolean hasNext() {
        if (!this.oneFullBlock && !this.defValueReturned) {
            for (int i = 0; i < this.defaultValues.length; ++i) {
                if (this.defaultValues[i] == null) continue;
                return true;
            }
        }
        return this.hasNext;
    }

    @Override
    public Object next() {
        if (this.cancelManager != null && this.cancelManager.isRequestCancelled()) {
            throw new OperationCanceledException();
        }
        if (!this.oneFullBlock && !this.defValueReturned) {
            this.defValueReturned = true;
            for (int i = 0; i < this.defaultValues.length; ++i) {
                if (this.defaultValues[i] == null) continue;
                this.setBlockOrdSurrogateId(-9223372036854775788L);
                this.log(this.defaultValues, -9223372036854775788L, null);
                return this.defaultValues;
            }
        }
        if (!this.hasNext) {
            return null;
        }
        Object retObj = this.nextObj;
        this.setBlockOrdSurrogateId(this.nextBlockOrdSurrogateId);
        this.log(retObj, this.nextBlockOrdSurrogateId, this.childBlockOrdinalsUsed);
        if (this.cancelManager != null && this.cancelManager.isRequestCancelled()) {
            throw new OperationCanceledException();
        }
        this.nextObj = this.getNext(false);
        this.nextBlockOrdSurrogateId = this.calcSearchBlockOrd();
        return retObj;
    }

    private Object getNextWhenEmptyBlockSets() {
        Object[] blockObjs = new Object[this.srcBlocks.length];
        if (this.nextObj != null) {
            this.hasNext = false;
            return null;
        }
        this.hasNext = false;
        for (int i = 0; i < this.srcBlocks.length; ++i) {
            if (this.blockCells[i].length > 0) {
                blockObjs[i] = this.blockCells[i][0].getObjectValue();
                this.childBlockOrdinalsUsed[i] = this.blockCells[i][0].getOrdinal();
                this.hasNext = true;
                continue;
            }
            blockObjs[i] = this.defaultValues[i];
            this.childBlockOrdinalsUsed[i] = -9223372036854775789L;
            if (this.defaultValues[i] == null) continue;
            this.hasNext = true;
        }
        if (!this.hasNext) {
            return null;
        }
        return blockObjs;
    }

    private void resetObjNullFlags(int setIdx) {
        for (int i = 0; i < this.srcBlocks.length; ++i) {
            if (!this.resetObjNullFlag[i][setIdx]) continue;
            this.blockObjNull[i] = false;
            this.resetObjNullFlag[i][setIdx] = false;
        }
    }

    private Object getNext(boolean firstTime) {
        int i;
        Arrays.fill(this.childBlockOrdinalsUsed, -1L);
        if (!this.hasNext) {
            return null;
        }
        if (this.blockSets.length == 0) {
            return this.getNextWhenEmptyBlockSets();
        }
        Object[] blockObj = new Object[this.srcBlocks.length];
        int setIdx = firstTime ? 0 : this.blockSets.length - 1;
        this.resetObjNullFlags(setIdx);
        while (setIdx < this.blockSets.length) {
            if (this.cancelManager != null && this.cancelManager.isRequestCancelled()) {
                throw new OperationCanceledException();
            }
            this.currSetOrd[setIdx] = !this.sparseIteration ? this.getMinSetOrdinal(setIdx) : this.getMatchingSetOrdinal(setIdx);
            if (this.compareOrdinals(this.currSetOrd[setIdx], Long.MIN_VALUE) == 0L) {
                if (--setIdx < 0) {
                    this.hasNext = false;
                    return null;
                }
                this.resetObjNullFlags(setIdx);
                for (i = 0; i < this.srcBlocks.length; ++i) {
                    long targetSetSize = this.ordinalMath.subtract(this.blockSetsInfo.getSize(setIdx), 1L);
                    if (!this.isDegenerated[i][setIdx] || this.compareOrdinals(this.setOrd[i][setIdx], targetSetSize) >= 0L) continue;
                    this.blockOrdIdx[i] = this.blockOrdIdxCopy[setIdx][i];
                }
                continue;
            }
            if (setIdx < this.blockSets.length - 1) {
                this.blockOrdIdxCopy[setIdx] = (int[])this.blockOrdIdx.clone();
            }
            for (i = 0; i < this.srcBlocks.length; ++i) {
                if (this.compareOrdinals(this.setOrd[i][setIdx], this.currSetOrd[setIdx]) == 0L || this.blockObjNull[i]) continue;
                this.blockObjNull[i] = true;
                this.resetObjNullFlag[i][setIdx] = true;
            }
            if (++setIdx >= this.blockSets.length) continue;
            for (i = 0; i < this.srcBlocks.length; ++i) {
                if (!this.isDegenerated[i][setIdx]) continue;
                this.setOrd[i][setIdx] = -9223372036854775798L;
            }
        }
        setIdx = this.blockSets.length - 1;
        for (i = 0; i < this.srcBlocks.length; ++i) {
            if (this.blockObjNull[i] || this.blockCells[i].length == 0) {
                blockObj[i] = this.defaultValues[i];
                this.childBlockOrdinalsUsed[i] = -9223372036854775789L;
                continue;
            }
            blockObj[i] = this.blockCells[i][this.blockOrdIdx[i]].getObjectValue();
            this.childBlockOrdinalsUsed[i] = this.blockCells[i][this.blockOrdIdx[i]].getOrdinal();
        }
        for (i = 0; i < this.srcBlocks.length; ++i) {
            if (this.blockObjNull[i]) continue;
            if (!this.isDegenerated[i][setIdx]) {
                int n = i;
                this.blockOrdIdx[n] = this.blockOrdIdx[n] + 1;
                continue;
            }
            if (this.compareOrdinals(this.setOrd[i][setIdx], this.ordinalMath.subtract(this.blockSetsInfo.getSize(setIdx), 1L)) < 0L) continue;
            int n = i;
            this.blockOrdIdx[n] = this.blockOrdIdx[n] + 1;
        }
        return blockObj;
    }

    private long getMinSetOrdinal(int setIdx) {
        long minOrd = Long.MIN_VALUE;
        boolean minOrdInitialized = false;
        long targetSize = this.ordinalMath.subtract(this.blockSetsInfo.getSize(setIdx), 1L);
        for (int i = 0; i < this.srcBlocks.length; ++i) {
            if (this.blockObjNull[i]) continue;
            if (this.blockOrdIdx[i] >= this.blockCells[i].length) {
                this.setOrd[i][setIdx] = Long.MIN_VALUE;
            } else if (!this.isDegenerated[i][setIdx]) {
                if (this.compareOrdinals(this.setOrd[i][setIdx], this.currSetOrd[setIdx]) == 0L) {
                    this.setOrd[i][setIdx] = this.getSetOrd(i, this.blockOrdIdx[i], this.setOrd[i], setIdx);
                }
            } else {
                this.setOrd[i][setIdx] = this.setOrd[i][setIdx] == -9223372036854775798L ? 0L : (this.compareOrdinals(this.setOrd[i][setIdx], targetSize) < 0L ? this.ordinalMath.add(this.setOrd[i][setIdx], 1L) : Long.MIN_VALUE);
            }
            if (minOrdInitialized && this.compareOrdinals(this.setOrd[i][setIdx], minOrd) >= 0L) continue;
            minOrdInitialized = true;
            minOrd = this.setOrd[i][setIdx];
        }
        return minOrd;
    }

    private long getMatchingSetOrdinal(int setIdx) {
        block0: while (true) {
            int i;
            boolean match = true;
            long max = Long.MIN_VALUE;
            int firstNonDegenIdx = -1;
            int nextNonDegenIdx = -1;
            for (i = 0; i < this.srcBlocks.length; ++i) {
                if (this.isDegenerated[i][setIdx]) continue;
                if (firstNonDegenIdx == -1) {
                    firstNonDegenIdx = i;
                    this.setOrd[firstNonDegenIdx][setIdx] = this.getSetOrd(firstNonDegenIdx, this.blockOrdIdx[firstNonDegenIdx], this.setOrd[firstNonDegenIdx], setIdx);
                    max = this.setOrd[firstNonDegenIdx][setIdx];
                    continue;
                }
                nextNonDegenIdx = i;
                this.setOrd[nextNonDegenIdx][setIdx] = this.getSetOrd(nextNonDegenIdx, this.blockOrdIdx[nextNonDegenIdx], this.setOrd[nextNonDegenIdx], setIdx);
                if (this.compareOrdinals(this.setOrd[firstNonDegenIdx][setIdx], this.setOrd[nextNonDegenIdx][setIdx]) == 0L) continue;
                match = false;
            }
            if (nextNonDegenIdx != -1 && this.compareOrdinals(this.setOrd[nextNonDegenIdx][setIdx], max) > 0L) {
                max = this.setOrd[nextNonDegenIdx][setIdx];
            }
            if (match) {
                for (i = 0; i < this.srcBlocks.length; ++i) {
                    if (!this.isDegenerated[i][setIdx]) continue;
                    this.setOrd[i][setIdx] = max;
                }
                return max;
            }
            i = 0;
            while (true) {
                if (i >= this.srcBlocks.length) continue block0;
                if (!this.isDegenerated[i][setIdx]) {
                    while (this.compareOrdinals(this.setOrd[i][setIdx], max) < 0L) {
                        int n = i;
                        this.blockOrdIdx[n] = this.blockOrdIdx[n] + 1;
                        if (this.blockOrdIdx[i] >= this.blockCells[i].length) {
                            for (int j = 0; j < this.srcBlocks.length; ++j) {
                                this.setOrd[j][setIdx] = Long.MIN_VALUE;
                            }
                            return Long.MIN_VALUE;
                        }
                        this.setOrd[i][setIdx] = this.getSetOrd(i, this.blockOrdIdx[i], this.setOrd[i], setIdx);
                    }
                }
                ++i;
            }
            break;
        }
    }

    private long getSetOrd(int theBlockIdx, int theBlockCellIdx, long[] theSetOrds, int theSetIdx) {
        if (theBlockCellIdx >= this.blockCells[theBlockIdx].length) {
            return Long.MIN_VALUE;
        }
        long[] newSetOrds = this.calcSetOrds(theBlockIdx, theBlockCellIdx, theSetOrds);
        int firstDiffIdx = this.getFirstDiff(newSetOrds, theSetOrds);
        if (firstDiffIdx == theSetIdx) {
            return newSetOrds[theSetIdx];
        }
        if (firstDiffIdx < theSetIdx) {
            return Long.MIN_VALUE;
        }
        return theSetOrds[theSetIdx];
    }

    private long[] calcSetOrds(int theBlockIdx, int theBlockCellIdx, long[] theSetOrds) {
        Block block = this.srcBlocks[theBlockIdx];
        long[] newSetOrds = new long[block.getSets().length];
        long cellOrd = this.blockCells[theBlockIdx][theBlockCellIdx].getOrdinal();
        if (cellOrd == -123L) {
            cellOrd = this.ordinalMath.createSurrogateId(this.blockCells[theBlockIdx][theBlockCellIdx].getBigOrdinal());
        }
        OrdinalMath.SetArrayInfo blockSetsInfo = this.ordinalMath.getSetArrayInfo(block.getSets());
        newSetOrds = this.ordinalMath.getSetOrdinals(cellOrd, blockSetsInfo);
        long[] retSetOrd = new long[this.blockSets.length];
        int newSetOrdIdx = 0;
        for (int i = 0; i < this.blockSets.length; ++i) {
            if (this.isDegenerated[theBlockIdx][i]) {
                retSetOrd[i] = theSetOrds[i];
                continue;
            }
            retSetOrd[i] = newSetOrds[newSetOrdIdx];
            ++newSetOrdIdx;
        }
        return retSetOrd;
    }

    private int getFirstDiff(long[] newSetOrd, long[] theSetOrd) {
        int i;
        for (i = 0; i < newSetOrd.length; ++i) {
            if (this.compareOrdinals(newSetOrd[i], theSetOrd[i]) == 0L) continue;
            return i;
        }
        return i;
    }

    private long calcSearchBlockOrd() {
        long currBlockOrd = 0L;
        for (int i = this.blockSets.length - 1; i >= 0; --i) {
            if (this.compareOrdinals(this.currSetOrd[i], Long.MIN_VALUE) == 0L) {
                return Long.MIN_VALUE;
            }
            currBlockOrd = this.ordinalMath.add(currBlockOrd, this.ordinalMath.multiply(this.blockSetsInfo.getWeight(i), this.currSetOrd[i]));
        }
        return currBlockOrd;
    }

    private long compareOrdinals(long ordinalA, long ordinalB) {
        long result = ordinalA == ordinalB ? 0L : (ordinalA == Long.MIN_VALUE ? 1L : (ordinalB == Long.MIN_VALUE ? -1L : (ordinalA == -9223372036854775798L ? -1L : (ordinalB == -9223372036854775798L ? 1L : (long)this.ordinalMath.compare(ordinalA, ordinalB)))));
        return result;
    }

    @Override
    public boolean returnsCellArray() {
        return false;
    }
}

