/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.query.engine.TestEnvironmentOptions;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.AbstractBlockOrdinalTransformIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockContextMap;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSetIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSetCellIteratorDecorator;
import com.cognos.xqe.util.primitive.HashMapLongObject;
import java.util.NoSuchElementException;
import java.util.TreeSet;

public class BlockOrdinalChangeContextTransformIterator
extends AbstractBlockOrdinalTransformIterator {
    protected final AbstractBlockOrdinalTransformIterator previousIterator;
    private final boolean allowsStreaming;
    protected final Block.ContextIteratorState state = new Block.ContextIteratorState();
    protected final TreeSet<Cell> newBlockCells = Block.createTreeSet();
    protected final BlockContextMap ctxMap;
    protected final IResultSetIterator newCellSetIterator;

    public BlockOrdinalChangeContextTransformIterator(AbstractBlockOrdinalTransformIterator cellPipelineIterator, BlockContextMap contextMap, boolean streaming) {
        this.previousIterator = cellPipelineIterator;
        this.ctxMap = contextMap;
        this.state.setTreeSetCache(new HashMapLongObject<TreeSet<Cell>>());
        this.allowsStreaming = streaming;
        if (this.allowsStreaming()) {
            this.iStreamThereforeIam();
            this.state.contextSetCells = null;
        }
        this.newCellSetIterator = this.initializeCellIterator(this.allowsStreaming());
    }

    @Override
    public Object peek() {
        if (!this.hasNext()) {
            return null;
        }
        if (this.allowsStreaming()) {
            Cell blockCell = (Cell)this.previousIterator.peek();
            blockCell = this.nullSafeClone(blockCell);
            Cell returnCell = this.transformCell(blockCell);
            return new Cell[]{returnCell};
        }
        return this.newCellSetIterator.peek();
    }

    @Override
    public boolean hasNext() {
        if (this.newCellSetIterator == null) {
            return this.previousIterator.hasNext();
        }
        return this.newCellSetIterator.hasNext();
    }

    @Override
    public Object next() {
        this.iterationStarted();
        if (this.allowsStreaming()) {
            return this.streamingNext();
        }
        return this.nextHelper();
    }

    @Override
    public boolean allowsStreaming() {
        return this.allowsStreaming;
    }

    protected Object streamingNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException(this.getClass().getName() + " has no more elements. ");
        }
        ++this.numFetchedCells;
        Cell blockCell = (Cell)this.previousIterator.next();
        Cell returnCell = this.transformCell(blockCell);
        return new Cell[]{returnCell};
    }

    @Override
    protected Cell transformCell(Cell blockCell) {
        if (blockCell == null) {
            return null;
        }
        Object blockObject = blockCell.getObjectValue();
        long blockOrdinalSurrogateId = this.ctxMap.getCellOrdinalSurrogate(blockCell);
        Cell localNewCell = this.ctxMap.transformNextCell(null, blockOrdinalSurrogateId, blockObject, this.state, false);
        Cell returnCell = Block.addCellSurrogateId(null, this.getPrevBlockOrdSurrogateId(), localNewCell, false, false, this.ctxMap.getOrdinalMath());
        return returnCell;
    }

    protected Object nextHelper() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("BlockOrdinalChangeContextTransformIterator has no more elements.");
        }
        ICell temp = (ICell)this.newCellSetIterator.next();
        return temp;
    }

    private IResultSetIterator initializeCellIterator(boolean streaming) {
        if (streaming) {
            return null;
        }
        return this.initializeCellIterator();
    }

    protected IResultSetIterator initializeCellIterator() {
        while (this.previousIterator.hasNext()) {
            Cell blockCell = (Cell)this.previousIterator.next();
            Object blockObject = blockCell.getObjectValue();
            long blockOrdinalSurrogateId = this.ctxMap.getCellOrdinalSurrogate(blockCell);
            this.ctxMap.transformNextCell(this.newBlockCells, blockOrdinalSurrogateId, blockObject, this.state, true);
        }
        HashMapLongObject<TreeSet<Cell>> tsCache = this.state.getTreeSetCache();
        if (this.newBlockCells.size() > 0) {
            if (this.newBlockCells.size() != tsCache.size()) {
                Block.addCellSurrogateId(this.newBlockCells, this.getPrevBlockOrdSurrogateId(), this.state.contextSetCells, false, false, this.ctxMap.getOrdinalMath());
            }
        } else {
            TreeSet<Cell> tempTreeSet = tsCache.get(0L);
            if (tempTreeSet == null && tsCache.size() == 1) {
                tempTreeSet = tsCache.get(tsCache.keySetIterator().next());
            }
            Block.addCellSurrogateId(this.newBlockCells, this.getPrevBlockOrdSurrogateId(), tempTreeSet, false, false, this.ctxMap.getOrdinalMath());
        }
        this.ctxMap.reassignDefaultValue(this.newBlockCells);
        this.numFetchedCells = this.newBlockCells.size();
        return new ResultSetCellIteratorDecorator(this.newBlockCells.iterator());
    }

    public long getPrevBlockOrdSurrogateId() {
        return this.state.getPrevBlockOrdSurrogateId();
    }

    private void iStreamThereforeIam() {
        TestEnvironmentOptions.TestHitCountTracker thct = TestEnvironmentOptions.TestHitCountTracker.current();
        if (thct != null) {
            thct.incrementNumberOfStreamingIterators();
        }
    }

    @Override
    public int size() {
        if (this.allowsStreaming()) {
            throw new UnsupportedOperationException("Streaming iterators do not support the size function.");
        }
        return this.numFetchedCells;
    }
}

