/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.AbstractBlockOrdinalTransformIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSetIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.util.OrdinalMath;
import com.cognos.xqe.util.primitive.ArrayListInt;
import com.cognos.xqe.util.primitive.LongArrayList;
import java.math.BigInteger;
import java.util.Iterator;

public class BlockOrdinalTransformIterator
extends AbstractBlockOrdinalTransformIterator {
    private Iterator<ICell> previousIterator = null;
    private final OrdinalMath.SetArrayInfo contextSetsInfo;
    private final Set[] evalSets;
    private final OrdinalMath.SetArrayInfo evalSetsInfo;
    private final Set[] sets;
    private final OrdinalMath.SetArrayInfo setsInfo;
    private final LongArrayList blockOrdMap;
    private final ArrayListInt mapSetsToEvalSets;
    private final OrdinalMath ordinalMath;

    public BlockOrdinalTransformIterator(Iterator<ICell> previousIter, Set[] theContextSets, Set[] theEvalSets, Set[] theSets, LongArrayList theBlockOrdMap, ArrayListInt theMapSetsToEvalSets, OrdinalMath theOrdinalMath) {
        this.previousIterator = previousIter;
        this.ordinalMath = theOrdinalMath;
        Set[] contextSets = theContextSets;
        this.contextSetsInfo = this.ordinalMath.getSetArrayInfo(theContextSets);
        this.evalSets = theEvalSets;
        this.evalSetsInfo = this.ordinalMath.getSetArrayInfo(this.evalSets);
        this.sets = theSets;
        this.setsInfo = this.ordinalMath.getSetArrayInfo(theSets);
        this.blockOrdMap = theBlockOrdMap;
        this.mapSetsToEvalSets = theMapSetsToEvalSets;
    }

    @Override
    public boolean hasNext() {
        return this.previousIterator.hasNext();
    }

    @Override
    public ICell next() {
        this.iterationStarted();
        Cell cell = (Cell)this.previousIterator.next();
        this.transformCell(cell);
        ++this.numFetchedCells;
        return cell;
    }

    @Override
    protected Cell transformCell(Cell cell) {
        long[] rsSetOrdinals;
        if (cell == null) {
            return null;
        }
        long[] evalSetOrds = null;
        long lCellOrdinal = cell.getOrdinal();
        if (lCellOrdinal == -123L) {
            BigInteger bigCellOrdinal = cell.getBigOrdinal();
            lCellOrdinal = this.ordinalMath.createSurrogateId(bigCellOrdinal);
        }
        evalSetOrds = this.ordinalMath.getSetOrdinals(lCellOrdinal, this.evalSetsInfo);
        if (this.sets.length == 0) {
            rsSetOrdinals = evalSetOrds;
        } else {
            long ordNumberSurrogateId;
            long tmpOrdinal = evalSetOrds[evalSetOrds.length - 1];
            if (tmpOrdinal < 0L || tmpOrdinal >= Integer.MAX_VALUE) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Ordinal: " + tmpOrdinal + " out of range.");
            }
            evalSetOrds[evalSetOrds.length - 1] = ordNumberSurrogateId = this.blockOrdMap.get((int)tmpOrdinal);
            long[] setsOrds = this.ordinalMath.getSetOrdinals(evalSetOrds[evalSetOrds.length - 1], this.setsInfo);
            rsSetOrdinals = new long[evalSetOrds.length - 1 + setsOrds.length];
            for (int i = 0; i < rsSetOrdinals.length; ++i) {
                rsSetOrdinals[i] = i < evalSetOrds.length - 1 ? evalSetOrds[i] : setsOrds[i - evalSetOrds.length + 1];
            }
        }
        long[] newSetsOrdinals = new long[rsSetOrdinals.length];
        for (int i = 0; i < rsSetOrdinals.length; ++i) {
            newSetsOrdinals[this.mapSetsToEvalSets.get((int)i)] = rsSetOrdinals[i];
        }
        long ordinal = this.ordinalMath.getBlockOrdinal(newSetsOrdinals, this.contextSetsInfo);
        if (OrdinalMath.isSurrogateId(ordinal)) {
            cell.setBigOrdinal(this.ordinalMath.getBigInteger(ordinal));
        } else {
            cell.setOrdinal(ordinal);
        }
        return cell;
    }

    @Override
    public ICell peek() {
        if (this.previousIterator instanceof IResultSetIterator) {
            Cell peekCell = (Cell)((IResultSetIterator)this.previousIterator).peek();
            peekCell = this.nullSafeClone(peekCell);
            return this.transformCell(peekCell);
        }
        throw new UnsupportedOperationException("The underlying iterator is a " + this.previousIterator.getClass() + " which does not support peek()");
    }
}

