/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.resultset.interfaces.IIterator;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.olap.mdx.interpreter.AbstractResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ICalculationEngine;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ICalculationEngineHook;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ITupleValueIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NamedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SecuredResultSetHelper;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SelectQuery;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SetEvaluator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SolveOrderComparator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleOrdinalCalculationCache;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline.PipelineResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.UnionTupleList;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.PrimingQueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Member;
import com.cognos.xqe.runtree.olap.mdx.metadata.MemberOperations;
import com.cognos.xqe.runtree.olap.mdx.metadata.Provider;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.util.UniqueNameParser;
import com.cognos.xqe.runtree.olap.mdx.util.UniqueNameParserException;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.PushdownManager;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.monitor.ResourceMonitor;
import com.cognos.xqe.util.primitive.HashMapObjectInt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class CalculationEngine
implements ICalculationEngine {
    private static final String CLOSE_BRACKET_STR = "]";
    private static int primingTestThreshold = -1;
    private static final int DEFAULT_PRIMING_QUERY_THRESHOLD = 10;
    private InterpreterContext interpreterContext;
    private QueryStrategy queryStrategy;
    private Map<String, NamedSet> uniqueNameToNamedSet;
    private Hashtable<String, Block> cachedBlocks = new Hashtable();
    private long cachedBlocksSize = 0L;
    private Hashtable<String, Integer> cacheableExpList = new Hashtable();
    private Hashtable<String, Integer> inlineNamedSetRefCountTable = new Hashtable();
    private Map<String, CalculatedMember> uniqueNameToCalculatedMember;
    private Map<String, CalculatedMember> nameToCalculatedMember;
    private CrossJoinedSet baseSet;
    private ArrayList<CalculatedMember> calcedMembers;
    private HashMap<CalculatedMember, CrossJoinedSet> calcToCalcSet;
    private int nextCalculatedMemberID;
    private final ICalculationEngineHook calcEngineHook;
    private boolean slicerPresent = false;
    private static final int BIG_SET_SIZE = 1000000;
    private static final int TUPLEVALUE_ARRAY_MAX = 10000;

    public CalculationEngine() {
        this(null);
    }

    public CalculationEngine(ICalculationEngineHook hook) {
        this.calcEngineHook = hook;
    }

    public QueryStrategy wrapQueryStrategyForPriming() {
        this.queryStrategy = new PrimingQueryStrategy(this.getQueryStrategy());
        return this.queryStrategy;
    }

    public QueryStrategy unwrapPrimingQueryStrategy() {
        if (!(this.getQueryStrategy() instanceof PrimingQueryStrategy)) {
            return null;
        }
        this.queryStrategy = ((PrimingQueryStrategy)this.getQueryStrategy()).getBaseStrategy();
        return this.queryStrategy;
    }

    @Override
    public void initialize(InterpreterContext ic) throws InterpreterException {
        this.interpreterContext = ic;
        ICube cube = this.interpreterContext.getCube();
        Provider p = this.interpreterContext.getProvider();
        this.queryStrategy = this.interpreterContext.getQueryStrategy();
        if (this.queryStrategy == null) {
            this.queryStrategy = p.getQueryStrategy();
        }
        String cacheHint = this.queryStrategy.getCubeletHint();
        this.queryStrategy.setInfoData(this.interpreterContext.getQueryContext());
        this.queryStrategy.setCube(cube);
        this.queryStrategy.setCubeletHint(cacheHint);
        this.nextCalculatedMemberID = -1000;
        this.uniqueNameToCalculatedMember = ((Cube)cube).getCalculatedMembers();
        this.uniqueNameToNamedSet = new HashMap<String, NamedSet>();
        this.nameToCalculatedMember = new HashMap<String, CalculatedMember>();
        for (String uName : this.uniqueNameToCalculatedMember.keySet()) {
            String name = this.uniqueNameToName(uName);
            this.nameToCalculatedMember.put(name, this.uniqueNameToCalculatedMember.get(uName));
        }
        this.calcToCalcSet = new HashMap();
        this.calcedMembers = new ArrayList();
        this.cachedBlocks = new Hashtable();
        this.cachedBlocksSize = 0L;
        this.cacheableExpList = new Hashtable();
        this.inlineNamedSetRefCountTable = new Hashtable();
    }

    @Override
    public boolean isInitialized() {
        return this.interpreterContext != null;
    }

    public InterpreterContext getInterpreterContext() {
        return this.interpreterContext;
    }

    @Override
    public void setCalcToCalcSet(CalculatedMember cm, CrossJoinedSet xjs) {
        this.calcToCalcSet.put(cm, xjs);
    }

    @Override
    public void addCalcedMembers(CalculatedMember cm) {
        this.calcedMembers.add(cm);
    }

    private String uniqueNameToName(String uName) throws InterpreterException {
        CalculatedMember mem = this.uniqueNameToCalculatedMember.get(uName);
        if (mem != null) {
            return mem.getName();
        }
        UniqueNameParser p = new UniqueNameParser();
        try {
            String[] elements = p.parse(uName);
            if (elements.length > 0) {
                return elements[elements.length - 1];
            }
        }
        catch (UniqueNameParserException e) {
            throw new InterpreterException("X01499", new String[]{e.getMessage()}, e);
        }
        return null;
    }

    @Override
    public ICalculationEngine clone(InterpreterContext theInterpreterContext) throws InterpreterException {
        CalculationEngine clone = new CalculationEngine(this.calcEngineHook);
        clone.initialize(theInterpreterContext);
        for (Map.Entry<String, CalculatedMember> entry : this.uniqueNameToCalculatedMember.entrySet()) {
            clone.uniqueNameToCalculatedMember.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, NamedSet> entry : this.uniqueNameToNamedSet.entrySet()) {
            NamedSet namedSet = entry.getValue();
            if (namedSet.isInline()) continue;
            clone.uniqueNameToNamedSet.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, CalculatedMember> entry : this.nameToCalculatedMember.entrySet()) {
            clone.nameToCalculatedMember.put(entry.getKey(), entry.getValue());
        }
        clone.cachedBlocks = this.cachedBlocks;
        clone.cachedBlocksSize = this.cachedBlocksSize;
        clone.cacheableExpList = this.cacheableExpList;
        clone.inlineNamedSetRefCountTable = this.inlineNamedSetRefCountTable;
        clone.slicerInitalized(this.isthereSlicer());
        return clone;
    }

    @Override
    public void addCalculatedMember(CalculatedMember calcMem) {
        String defnName = (String)calcMem.getProperty("DefinitionUniqueName");
        String uName = calcMem.getUniqueName();
        this.uniqueNameToCalculatedMember.put(uName, calcMem);
        if (defnName != null && !defnName.equals(uName)) {
            this.uniqueNameToCalculatedMember.put(defnName, calcMem);
        }
        IDimension parentDim = calcMem.getDimension();
        String uName1 = "[" + parentDim.getName() + CLOSE_BRACKET_STR + ".[" + calcMem.getName() + CLOSE_BRACKET_STR;
        if (defnName != null && !uName1.equals(defnName) && !uName1.equals(uName)) {
            this.uniqueNameToCalculatedMember.put(uName1, calcMem);
        }
        this.nameToCalculatedMember.put(calcMem.getName(), calcMem);
    }

    @Override
    public void addNamedSet(NamedSet namedSet) {
        this.uniqueNameToNamedSet.put(namedSet.getName(), namedSet);
    }

    @Override
    public Map<String, NamedSet> getNamedSets() {
        return this.uniqueNameToNamedSet;
    }

    public Hashtable<String, Block> getCachedBlocks() {
        return this.cachedBlocks;
    }

    public void makeRoomInCachedBlocks(long size, long maxSize) {
        for (String key : this.cachedBlocks.keySet()) {
            if (size + this.cachedBlocksSize <= maxSize) break;
            Block b = this.cachedBlocks.get(key);
            this.cachedBlocks.remove(key);
            long removedEntrySize = b.cachingSize();
            this.cachedBlocksSize -= removedEntrySize;
            Block.cacheLog("Removing cache entry. Size: " + removedEntrySize + " tuples");
        }
        this.cachedBlocksSize += size;
    }

    public long getCachedBlocksSize() {
        return this.cachedBlocksSize;
    }

    public Hashtable<String, Integer> getCacheableExpList() {
        return this.cacheableExpList;
    }

    public Hashtable<String, Integer> getInlineNamedSetRefCountTable() {
        return this.inlineNamedSetRefCountTable;
    }

    public Integer getInlineNamedSetRefCount(String setName) {
        return this.inlineNamedSetRefCountTable.get(setName);
    }

    @Override
    public CalculatedMember getCalculatedMember(String uniqueName) {
        CalculatedMember result = this.uniqueNameToCalculatedMember.get(uniqueName);
        return result;
    }

    @Override
    public CalculatedMember getStatementCalculatedMember(String uniqueName) {
        CalculatedMember result = this.uniqueNameToCalculatedMember.get(uniqueName);
        if (result != null && result.getMemberId() <= -1000L) {
            return result;
        }
        return null;
    }

    @Override
    public ArrayList<IMember> getCalculatedMembers(IMetadata parentObj) {
        ArrayList<IMember> result = new ArrayList<IMember>();
        HashSet<CalculatedMember> addedCalcedMembers = new HashSet<CalculatedMember>();
        for (CalculatedMember calcMember : this.uniqueNameToCalculatedMember.values()) {
            if (addedCalcedMembers.contains(calcMember)) continue;
            if (parentObj == null) {
                result.add(calcMember);
                continue;
            }
            IMetadata calcMemberParentObj = null;
            switch (parentObj.getObjectType()) {
                case DIMENSION: {
                    calcMemberParentObj = calcMember.getDimension();
                    break;
                }
                case HIERARCHY: {
                    calcMemberParentObj = calcMember.getHierarchy();
                    break;
                }
                case LEVEL: {
                    calcMemberParentObj = calcMember.getLevel();
                    break;
                }
                case MEMBER: {
                    calcMemberParentObj = calcMember.getParent();
                    break;
                }
            }
            if (calcMemberParentObj != parentObj) continue;
            result.add(calcMember);
            addedCalcedMembers.add(calcMember);
        }
        return result;
    }

    protected ArrayList<IMember> getCalculatedMembers() {
        return this.getCalculatedMembers(null);
    }

    @Override
    public CalculatedMember findCalculatedMember(String name) {
        CalculatedMember result = this.uniqueNameToCalculatedMember.get(name);
        if (result == null) {
            result = this.nameToCalculatedMember.get(name);
        }
        return result;
    }

    @Override
    public NamedSet getNamedSet(String name) {
        return this.uniqueNameToNamedSet.get(name);
    }

    @Override
    public int getNextCalculatedMemberID() {
        return this.nextCalculatedMemberID--;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IResultSet execute(IResultSet resultSet, SelectQuery selectQuery) throws InterpreterException {
        boolean returnEmptyResult = false;
        ICube cube = this.interpreterContext.getCube();
        if (selectQuery.isMemberSearchQuery() || ((Cube)cube).ignoreSingleAxisQueries() && selectQuery.getAxes().length == 1) {
            returnEmptyResult = true;
        }
        CrossJoinedSet querySet = resultSet.getQuerySet();
        boolean needToRemoveCubeName = false;
        needToRemoveCubeName = ROLAPContext.setCurrentCubeName(cube.getName());
        try {
            IResultSet iResultSet;
            XQEConfiguration configuration;
            int primingThreshold;
            this.populateBaseAndCalculationSets(querySet, cube);
            InterpreterContext.PrimingInfo primingInfo = this.interpreterContext.getPrimingInfo();
            boolean primingEnabled = primingInfo.isPrimingEnabled() && !this.interpreterContext.inPrimingPhase() && querySet.getCalculations().length > 0 && !this.getQueryStrategy().getPushDownMode();
            int primingPotential = 0;
            if (primingEnabled && primingInfo.readyToPrime()) {
                Map<String, Integer> calcToPrimingModeMap = primingInfo.getCalcToPrimingModeMap();
                for (CalculatedMember calc : this.calcToCalcSet.keySet()) {
                    Integer primingLevel = calcToPrimingModeMap.get(calc.getUniqueName());
                    if (primingLevel == null || primingLevel <= 0) continue;
                    primingPotential += this.calcToCalcSet.get(calc).getCalculations().length;
                }
            }
            if ((primingThreshold = (configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE)).getIntegerProperty("qsPrimingQueryThreshold", 0).intValue()) == 0) {
                primingThreshold = configuration.getIntegerProperty("queryExecution.primingQuery.primingThreshold[@value]", 10);
            }
            if (primingTestThreshold > 0) {
                primingThreshold = primingTestThreshold;
            }
            if (!returnEmptyResult) {
                if (primingEnabled && primingPotential > primingThreshold && selectQuery.canPrimed()) {
                    XQELogger primingLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "PrimingQuery", LogLevel.INFO);
                    StringBuilder buffer = new StringBuilder("\n");
                    buffer.append("Query Name: " + this.interpreterContext.getQueryContext().getQueryName());
                    buffer.append(", Priming threshold: " + primingThreshold);
                    buffer.append(", Total Number of Calculations for Priming: " + primingPotential);
                    buffer.append(", Member Search Query: " + selectQuery.isMemberSearchQuery());
                    buffer.append(", Sub Query: " + selectQuery.isSubQuery());
                    buffer.append(", Query is Prime: " + (primingEnabled && primingPotential >= primingThreshold && selectQuery.canPrimed()));
                    primingLogger.log(LogLevel.TRACE, buffer.toString());
                    String millisecond = " ms";
                    InterpreterContext oldContext = this.initPrimingEnvironment();
                    IResultSet primingResult = SecuredResultSetHelper.createSecuredResultSet((ISet[])resultSet.getAxes().clone(), (ISet)resultSet.getSlicer().copy(), this.interpreterContext, false);
                    SelectQuery primingQuery = new SelectQuery(selectQuery, this);
                    long ticks = System.currentTimeMillis();
                    primingLogger.log("Started executing a set in priming mode.");
                    primingLogger.log(LogLevel.TRACE, "Priming query set: " + querySet.toString());
                    this.getResultSet(primingResult, primingQuery);
                    primingLogger.log("Priming query setup completed in " + (System.currentTimeMillis() - ticks) + millisecond);
                    ((PrimingQueryStrategy)this.interpreterContext.getQueryStrategy()).runPrimingQuery(this.interpreterContext);
                    selectQuery.setPrimed(true);
                    this.tearDownPrimingEnvironment(oldContext);
                    primingLogger.log("Finished priming: " + (System.currentTimeMillis() - ticks) + millisecond);
                }
                iResultSet = resultSet = this.getResultSet(resultSet, selectQuery);
                return iResultSet;
            }
            iResultSet = resultSet;
            return iResultSet;
        }
        finally {
            ROLAPContext.removeCurrentCubeName(needToRemoveCubeName);
        }
    }

    private void tearDownPrimingEnvironment(InterpreterContext oldContext) {
        this.unwrapPrimingQueryStrategy();
        this.interpreterContext = oldContext;
        this.interpreterContext.setQueryStrategy(this.queryStrategy);
        this.interpreterContext.getXDataContext().setInterpreterContext(oldContext);
        this.interpreterContext.getPrimingInfo().setPrimingMode(-1);
    }

    private InterpreterContext initPrimingEnvironment() throws InterpreterException {
        XDataContext dataContext = this.interpreterContext.getXDataContext();
        InterpreterContext oldContext = this.interpreterContext;
        CrossJoinedSet cjs = this.interpreterContext.getContextSet();
        this.wrapQueryStrategyForPriming();
        this.interpreterContext.setQueryStrategy(this.queryStrategy);
        this.interpreterContext.getPrimingInfo().setPrimingMode(3);
        InterpreterContext newInterpreterContext = new InterpreterContext(this.interpreterContext, cjs);
        dataContext.setInterpreterContext(newInterpreterContext);
        this.interpreterContext = newInterpreterContext;
        return oldContext;
    }

    private boolean areSetHiersInSameOrder(ISet set1, ISet set2) {
        IHierarchy[] hierSet2;
        IHierarchy[] hierSet1 = set1.getHierarchies();
        if (hierSet1.length != (hierSet2 = set2.getHierarchies()).length) {
            return false;
        }
        for (int iHier = 0; iHier < hierSet1.length; ++iHier) {
            if (hierSet1[iHier].equals(hierSet2[iHier])) continue;
            return false;
        }
        return true;
    }

    private void checkMaxSetSize(long cjsSize, int calcBatchSize) throws XQERuntimeException {
        try {
            ResourceMonitor.checkMaxSetSize(cjsSize, this.interpreterContext.getQueryContext(), XQEMessageKeys.MDX_MaxCrossjoinSize);
        }
        catch (XQERuntimeException e) {
            XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MDXEngine", LogLevel.ERROR);
            logger.log("CrossJoinedSet of tuples too large for batch executing calculated members (Set size = " + cjsSize + ", Number of execution batches = " + calcBatchSize + ").");
            throw e;
        }
    }

    public IResultSet getResultSet(IResultSet resultSet, SelectQuery selectQuery) throws InterpreterException {
        if (this.baseSet != null && this.baseSet.size() != 0L) {
            boolean hasNonEmptyAxes = false;
            if (selectQuery != null) {
                hasNonEmptyAxes = selectQuery.hasNonEmptyAxes();
            }
            QueryStrategy qs = this.getQueryStrategy();
            if (hasNonEmptyAxes) {
                qs.setNonEmptyAxes(selectQuery.axesHaveNonEmpty());
            }
            qs.execute(this.baseSet, resultSet);
            if (this.calcedMembers.size() > 0) {
                qs.rebuildCalculatedMembersSets(this, resultSet);
            }
        }
        if (this.calcedMembers.size() > 0) {
            this.interpreterContext.disableAncestorNodesCache();
            if (resultSet.isPipelining() && !PipelineResultSet.supportCalculatedMembersWithPipelining()) {
                throw new InterpreterException("Unexpected IPipelineResultSet");
            }
        }
        ArrayList<Pair> calcBatches = new ArrayList<Pair>();
        HashMap<CalculatedMember, IResultSet> calcToResultSet = null;
        for (CalculatedMember cm : this.calcedMembers) {
            int i;
            boolean valueSecured;
            boolean isUserDefined;
            InterpreterContext.PrimingInfo primingInfo = this.interpreterContext.getPrimingInfo();
            int startingPrimingMode = -1;
            boolean startingReadyToPrimeValue = primingInfo.readyToPrime();
            if (primingInfo.isPrimingEnabled()) {
                Integer calcPrimingMode;
                Map<String, Integer> calcToPrimingModeMap = primingInfo.getCalcToPrimingModeMap();
                if (this.interpreterContext.inPrimingPhase()) {
                    calcPrimingMode = calcToPrimingModeMap.get(cm.getUniqueName());
                    if (calcPrimingMode == null || calcPrimingMode < 1) continue;
                    startingPrimingMode = primingInfo.getPrimingMode();
                    primingInfo.setPrimingMode(calcPrimingMode);
                } else {
                    calcPrimingMode = calcToPrimingModeMap.get(cm.getUniqueName());
                    if (primingInfo.getPrimedCalcs().contains(cm) && calcPrimingMode != null && calcPrimingMode > 1) {
                        primingInfo.setReadyToPrime(false);
                    } else {
                        primingInfo.setReadyToPrime(true);
                    }
                }
            }
            if (MemberOperations.applySecurityToMember(cm, this.interpreterContext) == null) continue;
            IMember cmParent = cm.getParent();
            boolean bl = isUserDefined = cm.getType() == MemberTypeEnum.SESSION_CALCULATION || cm.getType() == MemberTypeEnum.QUERY_CALCULATION;
            if (cmParent != null && isUserDefined && (!isUserDefined || MemberOperations.applySecurityToMember(cmParent, this.interpreterContext) == null) || (valueSecured = MemberOperations.isValueSecured(cm, this.interpreterContext))) continue;
            Object calcSet = this.calcToCalcSet.get(cm);
            if ((calcSet = (CrossJoinedSet)MemberOperations.filterSecureValueMembers((ISet)calcSet, this.interpreterContext)) == null) continue;
            boolean isDeferredGettingValue = true;
            if (this.interpreterContext.getProvider().isInProcessOfPreCellLoading()) {
                isDeferredGettingValue = false;
            } else if (this.calcedMembers.size() == 1) {
                isDeferredGettingValue = false;
            } else {
                IHierarchy cmHier = cm.getHierarchy();
                Member[] intersectingCMs = ((CrossJoinedSet)calcSet).getCalculations();
                for (i = 0; i < intersectingCMs.length; ++i) {
                    if (intersectingCMs[i].getHierarchy().equals(cmHier)) continue;
                    isDeferredGettingValue = false;
                }
            }
            if (isDeferredGettingValue) {
                this.interpreterContext.setDeferredGettingValue(isDeferredGettingValue);
            }
            if (this.calcEngineHook != null) {
                this.calcEngineHook.preExecuteCalculatedMember(cm, (CrossJoinedSet)calcSet, this.interpreterContext);
            }
            IResultSet rs = this.executeCalculatedMember(cm, (CrossJoinedSet)calcSet, this.interpreterContext);
            if (this.calcEngineHook != null) {
                this.calcEngineHook.postExecuteCalculatedMember(cm, rs, this.interpreterContext);
            }
            if (isDeferredGettingValue) {
                this.interpreterContext.setDeferredGettingValue(false);
            }
            if (this.interpreterContext.inPrimingPhase()) {
                primingInfo.setPrimingMode(startingPrimingMode);
            } else {
                primingInfo.setReadyToPrime(startingReadyToPrimeValue);
            }
            if (cm.isNullTag() && (!cm.getHierarchy().getDimension().isMeasuresDimension() || rs.getDefaultValue() == null)) {
                int edgeId = -1;
                for (i = 0; i < resultSet.getNumberOfAxes(); ++i) {
                    ISet axis = resultSet.getAxis(i);
                    if (!axis.contains(cm.getHierarchy())) continue;
                    edgeId = i;
                    break;
                }
                if (edgeId < 0) continue;
                ISet axis = resultSet.getAxis(edgeId);
                List<Number> cmOrdinals = ((Set)axis).getTupleList().findSubTuple(new IMember[]{cm}, false);
                ((AbstractResultSet)resultSet).addTagTupleOrdinal(edgeId, cmOrdinals);
                continue;
            }
            if (!rs.isEmpty() || rs.getDefaultValue() != null) {
                this.appendResultSet(resultSet, rs, cm);
                continue;
            }
            if (rs.getCalculatedMemberResult() != null) {
                IMember cmResultMember = rs.getCalculatedMemberResult();
                Pair calcBatch = null;
                for (Pair p : calcBatches) {
                    int i2;
                    IMember[] rsMembers;
                    IHierarchy cmHier;
                    boolean isCompatibleBatch = true;
                    Map calcResult = (Map)p.getFirst();
                    List calcResultSets = (List)p.getSecond();
                    if (calcResult.containsKey(cmResultMember)) continue;
                    block4: for (IResultSet r : calcResultSets) {
                        cmHier = cmResultMember.getHierarchy();
                        rsMembers = r.getAxisCrossJoinedSet().getMembers(cmHier);
                        for (i2 = 0; i2 < rsMembers.length; ++i2) {
                            if (!rsMembers[i2].equals(cmResultMember)) continue;
                            isCompatibleBatch = false;
                            continue block4;
                        }
                    }
                    block6: for (IMember otherCMResultMember : calcResult.keySet()) {
                        cmHier = otherCMResultMember.getHierarchy();
                        rsMembers = rs.getAxisCrossJoinedSet().getMembers(cmHier);
                        for (i2 = 0; i2 < rsMembers.length; ++i2) {
                            if (!rsMembers[i2].equals(otherCMResultMember)) continue;
                            isCompatibleBatch = false;
                            continue block6;
                        }
                    }
                    if (!isCompatibleBatch) continue;
                    calcBatch = p;
                    break;
                }
                if (calcBatch == null) {
                    HashMap batchCalcResult = new HashMap();
                    ArrayList batchCalcResultSets = new ArrayList();
                    calcBatch = new Pair(batchCalcResult, batchCalcResultSets);
                    calcBatches.add(calcBatch);
                }
                ((Map)calcBatch.getFirst()).put(cmResultMember, cm);
                ((List)calcBatch.getSecond()).add(rs);
                if (calcToResultSet == null) {
                    calcToResultSet = new HashMap<CalculatedMember, IResultSet>();
                }
                IResultSet newResultSet = SecuredResultSetHelper.createSecuredResultSet((CrossJoinedSet)calcSet, this.interpreterContext, false);
                calcToResultSet.put(cm, newResultSet);
                continue;
            }
            this.appendResultSet(resultSet, rs, cm);
        }
        for (Pair p : calcBatches) {
            Map calcResult = (Map)p.getFirst();
            List calcResultSets = (List)p.getSecond();
            CalculatedMember calcMember = (CalculatedMember)calcResult.values().iterator().next();
            Set unionedEvaluationSet = null;
            IHierarchy[] hierarchies = null;
            for (IResultSet rs : calcResultSets) {
                if (unionedEvaluationSet == null) {
                    unionedEvaluationSet = rs.getAxisCrossJoinedSet();
                    hierarchies = ((Set)unionedEvaluationSet).getHierarchies();
                    continue;
                }
                CrossJoinedSet rsCJS = rs.getAxisCrossJoinedSet();
                if (this.areSetHiersInSameOrder(unionedEvaluationSet, rsCJS)) {
                    Set[] setsToUnion = new Set[]{unionedEvaluationSet, rsCJS};
                    unionedEvaluationSet = Set.union(setsToUnion, true);
                    continue;
                }
                long cjsSize = rsCJS.size();
                this.checkMaxSetSize(cjsSize, calcBatches.size());
                IIterator it2 = rsCJS.hierarchyOrderedIterator(hierarchies);
                while (cjsSize > 0L) {
                    int aSetSize = cjsSize <= Integer.MAX_VALUE ? (int)cjsSize : Integer.MAX_VALUE;
                    cjsSize -= Integer.MAX_VALUE;
                    ITuple[] rsTuples = new ITuple[aSetSize];
                    int index = 0;
                    while (it2.hasNext()) {
                        Tuple t = (Tuple)it2.next();
                        rsTuples[index] = t;
                        if (++index != aSetSize) continue;
                        break;
                    }
                    Set[] setsToUnion = new Set[]{unionedEvaluationSet, new Set(rsTuples)};
                    unionedEvaluationSet = Set.union(setsToUnion, true);
                }
            }
            if (unionedEvaluationSet != null) {
                IResultSet rs;
                calcResultSets.clear();
                SetEvaluator se = new SetEvaluator(this.interpreterContext);
                rs = se.getSetResults(unionedEvaluationSet, unionedEvaluationSet);
                boolean ordMapCalced = false;
                TupleOrdinalCalculationCache resultSetOrdCalcCache = new TupleOrdinalCalculationCache(resultSet.getQuerySet(), rs.getQuerySet().getHierarchies());
                HashMap<IResultSet, TupleOrdinalCalculationCache> cmRSToTupleCalCache = new HashMap<IResultSet, TupleOrdinalCalculationCache>();
                ITupleValueIterator rsIt = rs.tupleValueIterator();
                while (rsIt.hasNext()) {
                    TupleValue tupleValue = (TupleValue)rsIt.next();
                    Tuple t = tupleValue.getTuple();
                    if (t.containsNullMember()) continue;
                    CalculatedMember cm = null;
                    for (IMember m : calcResult.keySet()) {
                        if (!t.contains(m)) continue;
                        cm = (CalculatedMember)calcResult.get(m);
                        t.addMember(cm);
                        break;
                    }
                    if (!ordMapCalced) {
                        resultSet.getQuerySet().calcOrdinalsToIndex(t);
                        ordMapCalced = true;
                    }
                    Cell c = tupleValue.getCell();
                    c = new Cell(c, cm.getFormatId());
                    String format = (String)cm.getProperty("format");
                    cm.applyFormatToCMResult(c, format);
                    resultSet.addCell((ITuple)t, c, resultSetOrdCalcCache);
                    IResultSet cmResultSet = (IResultSet)calcToResultSet.get(cm);
                    TupleOrdinalCalculationCache cmResultSetOrdCalcCache = (TupleOrdinalCalculationCache)cmRSToTupleCalCache.get(cmResultSet);
                    if (cmResultSetOrdCalcCache == null) {
                        cmResultSetOrdCalcCache = new TupleOrdinalCalculationCache(cmResultSet.getQuerySet(), rs.getQuerySet().getHierarchies());
                        cmRSToTupleCalCache.put(cmResultSet, cmResultSetOrdCalcCache);
                    }
                    cmResultSet.addCell((ITuple)t, c, cmResultSetOrdCalcCache);
                }
                for (CalculatedMember cm : calcToResultSet.keySet()) {
                    IResultSet rsToCache = (IResultSet)calcToResultSet.get(cm);
                    if (!this.interpreterContext.inPrimingPhase()) {
                        this.interpreterContext.getCalculationCache().addResultSet(cm.getUniqueName(), rsToCache.getQuerySet(), rsToCache);
                        continue;
                    }
                    this.interpreterContext.getPrimingCache().addResultSet(cm.getUniqueName(), rsToCache.getQuerySet(), rsToCache);
                }
            }
            this.appendResultSet(resultSet, calcResultSets, calcMember);
        }
        return resultSet;
    }

    private void appendResultSet(IResultSet resultSet, IResultSet calcResult, CalculatedMember cm) {
        ITupleValueIterator tvi = calcResult.tupleValueIterator();
        if (!tvi.hasNext()) {
            return;
        }
        boolean bComputeOrdinal = true;
        if (this.baseSet == null && this.calcedMembers.size() == 1 && resultSet.getQuerySet().size() == this.calcToCalcSet.get(cm).size()) {
            bComputeOrdinal = false;
        }
        int[] hierMap = null;
        Tuple targetTuple = resultSet.getTupleByCellOrdinal(0L);
        IMember[] targetTupleMembers = targetTuple.getMembers();
        Tuple sourceTuple = ((TupleValue)tvi.peek()).getTuple();
        IMember[] calcResultTupleMembers = sourceTuple.getMembers();
        if (!bComputeOrdinal) {
            if (targetTupleMembers.length != calcResultTupleMembers.length) {
                bComputeOrdinal = true;
            } else {
                hierMap = new int[targetTupleMembers.length];
                block0: for (int i = 0; i < targetTupleMembers.length; ++i) {
                    for (int j = 0; j < calcResultTupleMembers.length; ++j) {
                        if (!targetTupleMembers[i].getHierarchy().equals(calcResultTupleMembers[j].getHierarchy())) continue;
                        hierMap[i] = j;
                        continue block0;
                    }
                }
            }
        }
        boolean ordMapCalced = false;
        while (tvi.hasNext()) {
            TupleValue tupleValue = (TupleValue)tvi.next();
            Tuple tuple = tupleValue.getTuple();
            if (tuple.containsNullMember()) continue;
            if (!ordMapCalced) {
                resultSet.getQuerySet().calcOrdinalsToIndex(tuple);
                ordMapCalced = true;
            }
            Cell c = tupleValue.getCell();
            c = cm != null ? new Cell(c, cm.getFormatId()) : new Cell(c);
            if (bComputeOrdinal || c.getOrdinal() < 0L) {
                resultSet.addCell(tuple, c);
                continue;
            }
            targetTuple = resultSet.getTupleByCellOrdinal(c.getOrdinal());
            targetTupleMembers = targetTuple.getMembers();
            calcResultTupleMembers = tuple.getMembers();
            boolean isSameTuple = true;
            for (int i = 0; isSameTuple && i < targetTupleMembers.length; ++i) {
                isSameTuple = targetTupleMembers[i].equals(calcResultTupleMembers[hierMap[i]]);
            }
            if (isSameTuple) {
                resultSet.addCell(c);
                continue;
            }
            resultSet.addCell(tuple, c);
        }
    }

    private void appendResultSet(IResultSet resultSet, List<IResultSet> calcResults, CalculatedMember cm) {
        for (IResultSet rs : calcResults) {
            this.appendResultSet(resultSet, rs, cm);
        }
    }

    private IResultSet executeCalculatedMember(CalculatedMember cm, CrossJoinedSet calcSet, InterpreterContext theInterpreterContext) throws InterpreterException {
        if (this.interpreterContext.inPrimingPhase()) {
            this.interpreterContext.getPrimingInfo().addPrimedCalc(cm);
        }
        IResultSet rs = null;
        rs = theInterpreterContext.getCalculationCache().getResultSet(cm.getUniqueName(), calcSet);
        if (this.interpreterContext.inPrimingPhase()) {
            rs = theInterpreterContext.getPrimingCache().getResultSet(cm.getUniqueName(), calcSet);
        }
        if (rs == null) {
            rs = cm.fetchTupleValues(calcSet, theInterpreterContext);
            if (!(rs == null || this.interpreterContext.inPrimingPhase() || rs.isEmpty() && rs.getDefaultValue() == null)) {
                theInterpreterContext.getCalculationCache().addResultSet(cm.getUniqueName(), calcSet, rs);
            } else if (rs != null && this.interpreterContext.inPrimingPhase()) {
                theInterpreterContext.getPrimingCache().addResultSet(cm.getUniqueName(), calcSet, rs);
            }
        } else {
            PushdownManager pm = PushdownManager.getPushdownManager(theInterpreterContext);
            if (pm != null && pm.isEnabled()) {
                pm.setPushdownExecutionFinished(true);
            }
        }
        return rs;
    }

    public void populateBaseAndCalculationSets(CrossJoinedSet set) throws InterpreterException {
        this.populateBaseAndCalculationSets(set, null);
    }

    @Override
    public void populateBaseAndCalculationSets(CrossJoinedSet set, ICube cube) throws InterpreterException {
        this.baseSet = null;
        this.calcToCalcSet.clear();
        this.calcedMembers.clear();
        ISet[] sets = set.getSets();
        HashMapObjectInt<CalculatedMember> calculatedMemToSetIndex = new HashMapObjectInt<CalculatedMember>();
        HashMap<CalculatedMember, Set> calculatedMemToSet = new HashMap<CalculatedMember, Set>();
        boolean validBaseTuples = true;
        for (int axisNumber = 0; axisNumber < sets.length; ++axisNumber) {
            Set axis = sets[axisNumber];
            HashMap<CalculatedMember, Set> tmpCalculatedMemToSet = new HashMap<CalculatedMember, Set>();
            ArrayList<Set> tmpBaseTupleSet = new ArrayList<Set>();
            ITupleList tl = axis.tupleList;
            if (tl != null) {
                tl.getCalculatedMemberSets(tmpCalculatedMemToSet, tmpBaseTupleSet, cube);
                java.util.Set<CalculatedMember> calcs = tmpCalculatedMemToSet.keySet();
                for (CalculatedMember calculatedMem : calcs) {
                    calculatedMemToSetIndex.put(calculatedMem, axisNumber);
                    Set calcSet = tmpCalculatedMemToSet.get(calculatedMem);
                    calculatedMemToSet.put(calculatedMem, calcSet);
                }
            }
            sets[axisNumber] = !tmpBaseTupleSet.isEmpty() ? (Set)tmpBaseTupleSet.get(0) : new Set(new Tuple[0]);
            if (((Set)sets[axisNumber]).size() != 0L) continue;
            validBaseTuples = false;
        }
        if (validBaseTuples) {
            this.baseSet = new CrossJoinedSet(sets);
        }
        if (calculatedMemToSet.size() == 0) {
            return;
        }
        this.constructCalculationCrossJoinedSet((Set[])sets, calculatedMemToSet, calculatedMemToSetIndex);
    }

    private void constructCalculationCrossJoinedSet(Set[] sets, HashMap<CalculatedMember, Set> calcToTupleSet, HashMapObjectInt<CalculatedMember> calcToSetIndex) {
        ICube cube = this.interpreterContext.getCube();
        SolveOrderComparator solveOrderComp = new SolveOrderComparator(cube);
        for (CalculatedMember cm : calcToTupleSet.keySet()) {
            CrossJoinedSet cjsCalcSets;
            int currentSetIndex = calcToSetIndex.get(cm);
            ISet[] calcSets = new Set[sets.length];
            calcSets[currentSetIndex] = calcToTupleSet.get(cm);
            boolean validSet = true;
            for (int j = 0; j < calcSets.length && validSet; ++j) {
                if (j == currentSetIndex) continue;
                ArrayList<ITupleList> al = new ArrayList<ITupleList>();
                java.util.Set<CalculatedMember> cms = calcToTupleSet.keySet();
                for (CalculatedMember otherCm : cms) {
                    int otherCmIndex = calcToSetIndex.get(otherCm);
                    if (otherCmIndex != j || solveOrderComp.compare(otherCm, cm) < 0) continue;
                    al.add(calcToTupleSet.get(otherCm).getTupleList());
                }
                if (al.size() > 0 || sets[j].size() != 0L) {
                    ITupleList alTupleList = null;
                    alTupleList = al.size() == 1 ? (ITupleList)al.get(0) : new Set(UnionTupleList.construct(al)).getTupleList();
                    ITupleList calcTupleList = sets[j].tupleList;
                    if (al.size() == 0) {
                        calcSets[j] = sets[j];
                        continue;
                    }
                    if (sets[j].size() == 0L) {
                        calcSets[j] = new Set(alTupleList);
                        continue;
                    }
                    ArrayList<ITupleList> combinedList = new ArrayList<ITupleList>();
                    combinedList.add(calcTupleList);
                    combinedList.add(alTupleList);
                    calcSets[j] = new Set(UnionTupleList.construct(combinedList));
                    continue;
                }
                validSet = false;
            }
            if (!validSet || (cjsCalcSets = new CrossJoinedSet(calcSets)).isEmpty()) continue;
            this.calcToCalcSet.put(cm, cjsCalcSets);
            this.calcedMembers.add(cm);
        }
    }

    @Override
    public void slicerInitalized(boolean theSlicerPresent) {
        this.slicerPresent = theSlicerPresent;
    }

    @Override
    public boolean isthereSlicer() {
        return this.slicerPresent;
    }

    @Override
    public Map<String, CalculatedMember> getAllCalcedMembers() {
        return this.uniqueNameToCalculatedMember;
    }

    @Override
    public QueryStrategy getQueryStrategy() {
        if (this.interpreterContext.getQueryStrategy() != null) {
            return this.interpreterContext.getQueryStrategy();
        }
        return this.queryStrategy;
    }

    public void setQueryStrategy(QueryStrategy qs) {
        this.queryStrategy = qs;
    }

    public CrossJoinedSet getBaseSet() {
        return this.baseSet;
    }

    public HashMap<CalculatedMember, CrossJoinedSet> getCalculatedMemberToSet() {
        return this.calcToCalcSet;
    }

    @Override
    public MDXHierInfo getMDXLocalHierarchyInfo() {
        if (null == this.calcEngineHook) {
            return null;
        }
        XMdxLocal xMdxlocalNode = (XMdxLocal)((XNode)((Object)this.calcEngineHook)).getAncestorOfType(501053);
        if (xMdxlocalNode != null && xMdxlocalNode.getLevelInfoProperty() != null) {
            return xMdxlocalNode.getLevelInfoProperty().getHierarchyInfo();
        }
        return null;
    }

    public static void setPrimingThreshold(int t) {
        primingTestThreshold = t;
    }
}

