/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueMethodNotImplementedException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullObject;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.NullMember;
import com.cognos.xqe.runtree.olap.mdx.platform.Environment;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import com.cognos.xqe.util.xml.XMLWriter;
import com.ibm.icu.text.Collator;
import java.io.Serializable;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

public class Cell
implements ICell,
Comparable<Object>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 5718212739933602214L;
    private static final BeanPropertySupport BEAN_PROPERTY_SUPPORT = new BeanPropertySupport(Cell.class);
    private static final String CANNOT_INITIALISE_A_CELL_WITH_NULL = "Cannot initialise a Cell with Null.";
    private static final String FORMAT_GROUP = "<formatGroup>";
    private static final String LT_FORMAT_GROUP_GT = "&lt;formatGroup&gt;";
    private static final String INVALID_CELL_CONSTRUCTION_WITH_VALUE = "Invalid cell construction with value ";
    private static final long IEEE_INDETERMINATE = -2251799813685248L;
    private static final int DEFAULT_MAX_INT_DIGITS = 300;
    private static final int DEFAULT_MAX_FRACTION_DIGITS = 300;
    private static DecimalFormat defaultFormat = new DecimalFormat("#0.00#");
    public static final String DEFAULT_NUMBER_FORMAT = "&lt;formatGroup&gt;&lt;numberFormat xml:lang=&quot;en-us&quot;/&gt;&lt;/formatGroup&gt;";
    private static boolean stringFormatInitialised;
    private static boolean convertNaNToZero;
    protected long ordinal;
    protected Object value;
    protected String cellFormat;
    protected FormatId formatId;
    private boolean isCalculation = false;
    private HashMap<String, Object> dynamicProperties = null;

    public String getCellFormat() {
        return this.cellFormat;
    }

    public void setCellFormat(String newCellFormat) {
        this.cellFormat = newCellFormat;
    }

    private void setCellFormatId(FormatId newFormatId) {
        this.formatId = newFormatId;
        if (this.formatId != null && this.value != null && this.value instanceof Value) {
            ((Value)this.value).setFormatId(this.formatId);
        }
    }

    private String formatNumber(double val) {
        if (this.cellFormat == null) {
            return defaultFormat.format(val);
        }
        if (this.cellFormat.startsWith(LT_FORMAT_GROUP_GT) || this.cellFormat.startsWith(FORMAT_GROUP)) {
            return defaultFormat.format(val);
        }
        return new DecimalFormat(this.cellFormat).format(val);
    }

    public Cell(Object obj) {
        this(-1L, obj, true, false);
    }

    public Cell(long ord, Object val, boolean allowNullObject) {
        this(ord, val, true, allowNullObject);
    }

    public Cell(long ord, Object val) {
        this(ord, val, true);
    }

    public Cell(Object val, long ord, boolean checkValue) {
        this(ord, val, checkValue, true);
    }

    public Cell(long ord, Object val, boolean checkValue, boolean allowNullObject) {
        if (val == null) {
            throw new NullPointerException(CANNOT_INITIALISE_A_CELL_WITH_NULL);
        }
        this.value = val;
        if (checkValue) {
            if (!allowNullObject && this.value instanceof NullObject) {
                throw new NullPointerException(INVALID_CELL_CONSTRUCTION_WITH_VALUE + this.value);
            }
            if (!(this.value instanceof IMember || this.value instanceof Level || this.value instanceof Dimension || this.value instanceof Hierarchy || this.value instanceof NullObject || this.value instanceof IValue)) {
                throw new NullPointerException(INVALID_CELL_CONSTRUCTION_WITH_VALUE + this.value);
            }
        }
        this.ordinal = ord;
    }

    public Cell(Cell clone) {
        this.ordinal = clone.ordinal;
        this.value = clone.value;
        this.cellFormat = clone.cellFormat;
        this.formatId = clone.formatId;
        this.isCalculation = clone.isCalculation();
        if (clone.hasDynamicProperties()) {
            this.setDynamicProperties(clone.getCellProperties());
        }
    }

    public Cell(Cell clone, FormatId fId) {
        this.ordinal = clone.ordinal;
        if (fId != null && clone.hasDifferentFormatId(fId) && clone.value instanceof Value) {
            Value cloneValue = (Value)clone.value;
            this.value = cloneValue.copy();
            ((Value)this.value).setFormatId(cloneValue.getFormatId());
        } else {
            this.value = clone.value;
        }
        this.cellFormat = clone.cellFormat;
        this.formatId = clone.formatId;
        this.isCalculation = clone.isCalculation();
        this.setCellFormatId(fId);
        if (clone.hasDynamicProperties()) {
            this.setDynamicProperties(clone.getCellProperties());
        }
    }

    private boolean hasDifferentFormatId(FormatId fId) {
        Object cellValue = this.getObjectValue();
        if (cellValue instanceof Value) {
            FormatId valueFormatId = ((Value)cellValue).getFormatId();
            if (valueFormatId != null && fId != null) {
                return !valueFormatId.equals(fId);
            }
            return valueFormatId != null || fId != null;
        }
        return false;
    }

    public int hashCode() {
        StringBuilder strCode = new StringBuilder();
        strCode.append(String.valueOf(this.ordinal));
        if (this.value != null) {
            strCode.append(this.value.toString());
        }
        if (this.cellFormat != null) {
            strCode.append(this.cellFormat);
        }
        if (this.formatId != null) {
            strCode.append(this.formatId.toString());
        }
        return strCode.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public boolean isError() {
        if (this.value instanceof Value) {
            return ((Value)this.value).isError();
        }
        return false;
    }

    public boolean isNumeric() {
        return this.value instanceof Double || this.value instanceof Integer || this.value instanceof Long || this.value instanceof NumericValue;
    }

    public boolean isDouble() {
        return this.value instanceof Double || this.value instanceof DoubleValue;
    }

    public boolean isInteger() {
        return this.value instanceof Integer || this.value instanceof IntegerValue;
    }

    public boolean isBoolean() {
        return this.value instanceof Boolean || this.value instanceof BooleanValue;
    }

    public boolean isString() {
        return this.value instanceof String || this.value instanceof TextValue;
    }

    public boolean isMember() {
        return this.value instanceof IMember;
    }

    public boolean isLevel() {
        return this.value instanceof Level;
    }

    public boolean isHierarchy() {
        return this.value instanceof Hierarchy;
    }

    public boolean isDimension() {
        return this.value instanceof Dimension;
    }

    @Override
    public long getOrdinal() {
        return this.ordinal;
    }

    @Override
    public void setOrdinal(long ord) {
        this.ordinal = ord;
    }

    public double getNumericValue() {
        if (this.value instanceof Value) {
            return ((Value)this.value).getDouble();
        }
        if (this.isDouble()) {
            return (Double)this.value;
        }
        if (this.isInteger()) {
            return ((Integer)this.value).doubleValue();
        }
        if (this.isBoolean()) {
            Boolean boolValue = (Boolean)this.value;
            if (boolValue.booleanValue()) {
                return 1.0;
            }
            return 0.0;
        }
        throw new NullPointerException("Cannot coerce cell value " + this.value + " to a double");
    }

    public double getDoubleValue() {
        if (this.value instanceof Value) {
            return ((Value)this.value).getDouble();
        }
        return (Double)this.value;
    }

    public int getIntegerValue() {
        if (this.value instanceof Value) {
            return ((Value)this.value).getInteger();
        }
        return (Integer)this.value;
    }

    public String getStringValue() {
        if (!stringFormatInitialised) {
            convertNaNToZero = Environment.getBooleanEnvironmentVariable("convertNanToZero");
            stringFormatInitialised = true;
        }
        if (this.isDouble()) {
            double d = this.value instanceof Value ? ((Value)this.value).getDouble() : ((Double)this.value).doubleValue();
            if (Double.isInfinite(d)) {
                if (d > 0.0) {
                    return "1.#INF";
                }
                return "-1.#INF";
            }
            if (Double.isNaN(d)) {
                if (convertNaNToZero) {
                    return this.formatNumber(0.0);
                }
                if (Double.doubleToRawLongBits(d) == -2251799813685248L) {
                    return "-1.#IND";
                }
                return "1.#QNAN";
            }
            return this.formatNumber(d);
        }
        return this.value.toString();
    }

    public boolean getBooleanValue() {
        if (this.value instanceof Value) {
            return ((Value)this.value).getBoolean();
        }
        return (Boolean)this.value;
    }

    public Object getObjectValue() {
        return this.value;
    }

    @Override
    public IValue getValue() {
        if (this.value instanceof IValue) {
            if (this.value instanceof NullMember) {
                return null;
            }
            return (IValue)this.value;
        }
        Value cellValue = null;
        if (this.isInteger()) {
            IntegerValue intValue = DataValueFactory.createIntegerValue();
            intValue.set(this.getIntegerValue());
            cellValue = intValue;
        } else if (this.isDouble()) {
            DoubleValue d = DataValueFactory.createDoubleValue();
            d.set(this.getDoubleValue());
            cellValue = d;
        } else if (this.isBoolean()) {
            BooleanValue b = DataValueFactory.createBooleanValue();
            b.set(this.getBooleanValue());
            cellValue = b;
        } else if (this.isString()) {
            StringValue vc = DataValueFactory.createStringValue();
            vc.set(this.getStringValue());
            cellValue = vc;
        }
        if (this.isNumeric()) {
            if (this.formatId == null) {
                this.formatId = FormatId.DEFAULT_NUMBER_FORMAT_FID;
                String currCellFormat = this.getCellFormat();
                if (currCellFormat != null && currCellFormat.length() > 0) {
                    this.formatId = FormatService.getInstance().registerV5Format(currCellFormat, null);
                }
            }
            cellValue.setFormatId(this.formatId);
        }
        return cellValue;
    }

    public void setValue(Object val) {
        this.value = val;
    }

    @Override
    public void setValue(IValue val) {
        this.value = val;
    }

    @Override
    public int compareTo(Object o) {
        if (this.ordinal != -123L && ((Cell)o).getOrdinal() != -123L) {
            if (this.ordinal == ((Cell)o).getOrdinal()) {
                return 0;
            }
            if (this.ordinal < ((Cell)o).getOrdinal()) {
                return -1;
            }
            return 1;
        }
        if (this.ordinal == -123L && ((Cell)o).getOrdinal() != -123L) {
            BigInteger c1Ordinal = this.getBigOrdinal();
            BigInteger c2Ordinal = BigInteger.valueOf(((Cell)o).getOrdinal());
            return c1Ordinal.compareTo(c2Ordinal);
        }
        if (this.ordinal != -123L && ((Cell)o).getOrdinal() == -123L) {
            BigInteger c1Ordinal = BigInteger.valueOf(this.getOrdinal());
            BigInteger c2Ordinal = ((Cell)o).getBigOrdinal();
            return c1Ordinal.compareTo(c2Ordinal);
        }
        int result = this.getBigOrdinal().compareTo(((Cell)o).getBigOrdinal());
        if (result == 0) {
            return 0;
        }
        if (result < 0) {
            return -1;
        }
        return 1;
    }

    public String toString() {
        String ordinalAsString = this.ordinal == -123L ? this.getBigOrdinal().toString() : String.valueOf(this.ordinal);
        String result = "Ord:" + ordinalAsString + ", Val:" + this.value;
        if (this.cellFormat != null && (this.cellFormat.startsWith(LT_FORMAT_GROUP_GT) || this.cellFormat.startsWith(FORMAT_GROUP))) {
            result = result + " cog format";
        }
        return result;
    }

    @Override
    public void toXML(XMLWriter xmlWriter) {
        xmlWriter.beginElement("Cell", -1);
        xmlWriter.attribute("CellOrdinal", this.ordinal);
        if (this.value instanceof IValue) {
            ((IValue)this.value).toXML(xmlWriter);
        } else {
            String dataType = null;
            if (this.value instanceof Double) {
                dataType = "double";
            } else if (this.value instanceof Integer) {
                dataType = "int";
            }
            if (dataType != null) {
                xmlWriter.beginElement("Value", -1);
                xmlWriter.attribute("dataType", dataType);
                xmlWriter.data(this.value.toString());
                xmlWriter.endElement();
            }
        }
        xmlWriter.endElement();
    }

    @Override
    public Object toJSON() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object copy() {
        if (this.value instanceof String) {
            return new Cell(this.ordinal, this.value);
        }
        if (this.value instanceof Value) {
            return new Cell(this.ordinal, ((Value)this.value).copy());
        }
        throw new UnsupportedOperationException();
    }

    public BeanPropertySupport getBeanPropertySupport() {
        return BEAN_PROPERTY_SUPPORT;
    }

    @Override
    public boolean isNull() {
        if (null == this.value) {
            return true;
        }
        if (this.value instanceof Value) {
            return ((Value)this.value).isNull();
        }
        return false;
    }

    @Override
    public void release() {
    }

    @Override
    public int fastHash() {
        return this.hashCode();
    }

    @Override
    public Object hashKey() {
        return this;
    }

    @Override
    public Object hashKey(Collator collator) {
        return this.hashKey();
    }

    @Override
    public int sizeOf() {
        return 0;
    }

    @Override
    public void copyFrom(IValue inValue) {
        ICell anotherCell = (ICell)inValue;
        this.setOrdinal(anotherCell.getOrdinal());
        this.setValue(anotherCell.getValue());
    }

    @Override
    public IDataType getDataType() {
        return this.getValue().getDataType();
    }

    @Override
    public boolean isMetadata() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isResultSet() {
        return false;
    }

    @Override
    public void setNull() throws ValueMethodNotImplementedException {
        throw new ValueMethodNotImplementedException(this.getClass().getName() + ".setNull()");
    }

    protected boolean hasDynamicProperties() {
        return this.dynamicProperties != null;
    }

    @Override
    public synchronized void setCellProperty(String propertyName, Object inValue) {
        if (this.dynamicProperties == null) {
            this.dynamicProperties = new HashMap();
        }
        if (null == inValue) {
            this.dynamicProperties.remove(propertyName);
        } else {
            this.dynamicProperties.put(propertyName, inValue);
        }
    }

    @Override
    public synchronized Object getCellProperty(String propertyName) {
        if (this.dynamicProperties == null) {
            this.dynamicProperties = new HashMap();
        }
        return this.dynamicProperties.get(propertyName);
    }

    protected synchronized void setDynamicProperties(Map<String, Object> properties) {
        if (this.dynamicProperties == null) {
            this.dynamicProperties = new HashMap();
        }
        this.dynamicProperties.putAll(properties);
    }

    @Override
    public HashMap<String, Object> getCellProperties() {
        return this.dynamicProperties;
    }

    public void setIsCalculation(boolean isCalc) {
        this.isCalculation = isCalc;
    }

    public boolean isCalculation() {
        return this.isCalculation;
    }

    public void setBigOrdinal(BigInteger bOrdinal) {
        throw new UnsupportedOperationException();
    }

    public BigInteger getBigOrdinal() {
        throw new UnsupportedOperationException();
    }

    static {
        defaultFormat.setDecimalSeparatorAlwaysShown(true);
        defaultFormat.setMaximumIntegerDigits(300);
        defaultFormat.setMaximumFractionDigits(300);
        stringFormatInitialised = false;
        convertNaNToZero = false;
    }
}

