/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.mdx.parser.ASTAxisSpecification;
import com.cognos.xqe.ast.mdx.parser.ASTBooleanFactor;
import com.cognos.xqe.ast.mdx.parser.ASTBooleanPrimary;
import com.cognos.xqe.ast.mdx.parser.ASTBooleanTerm;
import com.cognos.xqe.ast.mdx.parser.ASTCellProperty;
import com.cognos.xqe.ast.mdx.parser.ASTCellProps;
import com.cognos.xqe.ast.mdx.parser.ASTCharacterStringLiteral;
import com.cognos.xqe.ast.mdx.parser.ASTComposite;
import com.cognos.xqe.ast.mdx.parser.ASTConditionalExpression;
import com.cognos.xqe.ast.mdx.parser.ASTCreateFormulaStatement;
import com.cognos.xqe.ast.mdx.parser.ASTCubeName;
import com.cognos.xqe.ast.mdx.parser.ASTCubeSpecification;
import com.cognos.xqe.ast.mdx.parser.ASTDimProps;
import com.cognos.xqe.ast.mdx.parser.ASTDropFormulaStatement;
import com.cognos.xqe.ast.mdx.parser.ASTDropMemberStatement;
import com.cognos.xqe.ast.mdx.parser.ASTDropSetStatement;
import com.cognos.xqe.ast.mdx.parser.ASTElement;
import com.cognos.xqe.ast.mdx.parser.ASTExpression;
import com.cognos.xqe.ast.mdx.parser.ASTExpressionList;
import com.cognos.xqe.ast.mdx.parser.ASTFactor;
import com.cognos.xqe.ast.mdx.parser.ASTFormulaSpecification;
import com.cognos.xqe.ast.mdx.parser.ASTIfExpression;
import com.cognos.xqe.ast.mdx.parser.ASTInlineNamedSet;
import com.cognos.xqe.ast.mdx.parser.ASTMDXNode;
import com.cognos.xqe.ast.mdx.parser.ASTMandatoryProperty;
import com.cognos.xqe.ast.mdx.parser.ASTMemberName;
import com.cognos.xqe.ast.mdx.parser.ASTMemberPropertyDefinition;
import com.cognos.xqe.ast.mdx.parser.ASTMemberSpecification;
import com.cognos.xqe.ast.mdx.parser.ASTNumericValueExpression;
import com.cognos.xqe.ast.mdx.parser.ASTProperty;
import com.cognos.xqe.ast.mdx.parser.ASTSearchCondition;
import com.cognos.xqe.ast.mdx.parser.ASTSelectStatement;
import com.cognos.xqe.ast.mdx.parser.ASTSet;
import com.cognos.xqe.ast.mdx.parser.ASTSetSpecification;
import com.cognos.xqe.ast.mdx.parser.ASTSlicerSpecification;
import com.cognos.xqe.ast.mdx.parser.ASTStringValueExpression;
import com.cognos.xqe.ast.mdx.parser.ASTStringValueExpressionPrimary;
import com.cognos.xqe.ast.mdx.parser.ASTTerm;
import com.cognos.xqe.ast.mdx.parser.ASTTuple;
import com.cognos.xqe.ast.mdx.parser.ASTUnsignedNumericLiteral;
import com.cognos.xqe.ast.mdx.parser.ASTUserDefinedProperty;
import com.cognos.xqe.ast.mdx.parser.ASTValueExpressionPrimary;
import com.cognos.xqe.ast.mdx.parser.MDXParser;
import com.cognos.xqe.ast.mdx.parser.MDXParserVisitorBase;
import com.cognos.xqe.ast.mdx.parser.Node;
import com.cognos.xqe.ast.mdx.parser.ParseException;
import com.cognos.xqe.ast.mdx.parser.SimpleNode;
import com.cognos.xqe.cubingservices.CommonClassesFactory;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.Property;
import com.cognos.xqe.resultset.interfaces.IIterator;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.FunctionManager;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ErrorCell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ICalculationEngine;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSetIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ITupleValueIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.KeyWord;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NamedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullObject;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Query;
import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSetConfiguration;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSetProcessor;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SearchConditionEvaluator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SelectQuery;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Session;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SetEvaluator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MemberOperations;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.NullMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Provider;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.runtree.olap.mdx.mockprovider.NoddyDimension;
import com.cognos.xqe.runtree.olap.mdx.platform.Environment;
import com.cognos.xqe.runtree.olap.mdx.security.SecurityManagerInterface;
import com.cognos.xqe.runtree.olap.mdx.util.MapEntryValueComparator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Interpreter
extends MDXParserVisitorBase {
    private static final String PERIOD = ".";
    private static final String CLOSE_SQUARE_BRACKET = "]";
    private static final String OPEN_SQUARE_BRACKET = "[";
    private static final String PROPERTY_MEMBER_CAPTION = "MEMBER_CAPTION";
    private static final String FUNCTION_CAPTION = "CAPTION";
    private static final String FUNCTION_ALL_MEMBERS = "ALLMEMBERS";
    private static final String FUNCTION_MEMBERS = "MEMBERS";
    private static final String FUNCTION_CURRENT_MEMBER = "CURRENTMEMBER";
    private static final String FUNCTION_NEXT_MEMBER = "NEXTMEMBER";
    private static final String FUNCTION_CHILDREN = "CHILDREN";
    private static final String FUNCTION_PREV_MEMBER = "PREVMEMBER";
    private static final String FUNCTION_DEFAULT_MEMBER = "DEFAULTMEMBER";
    private static final String FUNCTION_DATA_MEMBER = "DATAMEMBER";
    private static final String FUNCTION_NAME = "NAME";
    private static final String FUNCTION_UNIQUE_NAME = "UNIQUENAME";
    private static final String FUNCTION_LASTSIBLING = "LASTSIBLING";
    private static final String FUNCTION_FIRSTSIBLING = "FIRSTSIBLING";
    private static final String FUNCTION_FIRSTCHILD = "FIRSTCHILD";
    private static final String FUNCTION_LASTCHILD = "LASTCHILD";
    private static final String FUNCTION_PARENT = "PARENT";
    private static final String FUNCTION_VALUE = "VALUE";
    private static final String FUNCTION_COUNT = "COUNT";
    private static final String FUNCTION_HIERARCHY = "HIERARCHY";
    private static final String FUNCTION_LEVELS = "LEVELS";
    private static final String FUNCTION_DESCRIPTION = "DESCRIPTION";
    private static final String FUNCTION_SIBLINGS = "SIBLINGS";
    private static final String FUNCTION_LEVEL = "LEVEL";
    private static final String FUNCTION_DIMENSION = "DIMENSION";
    private static final String FUNCTION_ORDINAL = "ORDINAL";
    private static final String RECURSIVE = "RECURSIVE";
    private static XQELogger logger = CommonClassesFactory.createXQELogger("MDXEngine");
    private static boolean infoEnabled = logger.isOn(LogLevel.INFO);
    private boolean createStatement = false;
    private boolean dropStatement = false;
    private final boolean drillThrough = false;
    private Object createDropResult = null;
    Session session = null;
    private Query query;
    private int depth;
    private final InterpreterContext interpreterContext;
    private final java.util.Set<String> reservedWords = new HashSet<String>(Arrays.asList("ALL", "SELF", "AFTER", "BEFORE", "BEFORE_AND_AFTER", "SELF_AND_AFTER", "SELF_AND_BEFORE", "SELF_BEFORE_AFTER", "LEAVES", "LEAVES_ONLY", "RECURSIVE", "ASC", "DESC", "BASC", "BDESC", "POST", "INCLUDEEMPTY", "EXCLUDEEMPTY"));
    private final java.util.Set<String> mandatoryMemberProperties = new HashSet<String>(Arrays.asList("CATALOG_NAME", "SCHEMA_NAME", "CUBE_NAME", "DIMENSION_UNIQUE_NAME", "HIERARCHY_UNIQUE_NAME", "LEVEL_UNIQUE_NAME", "LEVEL_NUMBER", "MEMBER_KEY", "KEY", "MEMBER_UNIQUE_NAME", "MEMBER_NAME", "MEMBER_TYPE", "MEMBER_GUID", "MEMBER_CAPTION", "CAPTION", "MEMBER_ORDINAL", "CHILDREN_CARDINALITY", "PARENT_LEVEL", "PARENT_UNIQUE_NAME", "PARENT_COUNT", "DESCRIPTION"));
    private final HashMap<String, Long> interpreterProfile = new HashMap();
    private long startTime;
    private String interpreterSubject = "";

    public InterpreterContext getInterpreterContext() {
        return this.interpreterContext;
    }

    public void setInterpreterSubject(String interpreterSubject) {
        this.interpreterSubject = interpreterSubject;
    }

    public QueryContext getInfoData() {
        QueryContext infoData = null;
        if (this.interpreterContext == null) {
            return infoData;
        }
        infoData = this.interpreterContext.getQueryContext();
        return infoData;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public boolean isCreateStatement() {
        return this.createStatement;
    }

    public boolean isDropStatement() {
        return this.dropStatement;
    }

    public boolean isDrillThrough() {
        return false;
    }

    public Object getCreateDropResult() {
        return this.createDropResult;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    @Override
    public void startProfile() {
        if (infoEnabled) {
            this.startTime = System.currentTimeMillis();
        }
    }

    @Override
    public void stopProfile(Node n) {
        if (infoEnabled && n != null) {
            String className = n.getClass().getName();
            Long timeInMS = this.interpreterProfile.get(className);
            timeInMS = timeInMS == null ? new Long(System.currentTimeMillis() - this.startTime) : new Long(timeInMS + (System.currentTimeMillis() - this.startTime));
            this.interpreterProfile.put(className, timeInMS);
        }
    }

    public void addFunctionProfile(Function f, long time) {
        if (infoEnabled) {
            String functionName = "ASTElement (" + f.getName() + " function)";
            Long timeInMS = this.interpreterProfile.get(functionName);
            timeInMS = timeInMS == null ? new Long(time) : new Long(timeInMS + time);
            this.interpreterProfile.put(functionName, timeInMS);
        }
    }

    public void addIdentifierProfile(String identifier, long time) {
        if (infoEnabled) {
            String str = "ASTElement (" + identifier + " identifier)";
            Long timeInMS = this.interpreterProfile.get(str);
            timeInMS = timeInMS == null ? new Long(time) : new Long(timeInMS + time);
            this.interpreterProfile.put(str, timeInMS);
        }
    }

    public void outputProfile() {
        if (infoEnabled) {
            logger.log(LogLevel.INFO, "Interpreter Profile: " + this.interpreterSubject);
            ArrayList<Map.Entry<String, Long>> al = new ArrayList<Map.Entry<String, Long>>(this.interpreterProfile.entrySet());
            Collections.sort(al, new MapEntryValueComparator());
            long totalTime = 0L;
            for (Map.Entry<String, Long> e : al) {
                Long value = e.getValue();
                totalTime += value.longValue();
                logger.log(LogLevel.INFO, " " + e.getKey() + " :: " + value);
            }
            logger.log(LogLevel.INFO, " Total Time :: " + totalTime);
        }
    }

    public Interpreter(InterpreterContext context, MDXParser p) {
        super(p);
        this.interpreterContext = context;
    }

    public Query interpretQuery() throws InterpreterException {
        this.depth = 0;
        this.getRootNode().accept(this, null);
        this.outputProfile();
        return this.query;
    }

    private void processDrop(ASTDropFormulaStatement node) throws InterpreterException {
        block11: {
            Node dropMemberOrSetStatement;
            int childCount;
            block12: {
                childCount = node.jjtGetNumChildren();
                this.dropStatement = true;
                logger.log("interpret Drop node =" + node);
                if (childCount <= 0) break block11;
                dropMemberOrSetStatement = node.jjtGetChild(childCount - 1);
                logger.log("interpret Drop last child node =" + dropMemberOrSetStatement);
                if (!(dropMemberOrSetStatement instanceof ASTDropMemberStatement)) break block12;
                childCount = dropMemberOrSetStatement.jjtGetNumChildren();
                for (int j = 0; j < childCount; ++j) {
                    Cube cube;
                    this.depth = 0;
                    Object obj = dropMemberOrSetStatement.jjtGetChild(j).accept(this, null);
                    logger.log("Child of dropmember =" + obj);
                    if (!(obj instanceof String[])) continue;
                    String[] memberName = (String[])obj;
                    try {
                        cube = this.interpreterContext.getProvider().getCube(memberName[0]);
                    }
                    catch (ProviderException e) {
                        throw new InterpreterException("X01439", new String[]{memberName[0]}, e);
                    }
                    this.interpreterContext.setCube(cube);
                    int calcNameOffset = memberName.length - 1;
                    ICalculationEngine calculationEngine = this.interpreterContext.getCalculationEngine();
                    CalculatedMember calcMem = calculationEngine.findCalculatedMember(memberName[calcNameOffset]);
                    String dropSessionObjectWithName = OPEN_SQUARE_BRACKET + cube + "]." + calcMem.getUniqueName();
                    this.createDropResult = this.session.getSessionObjects().get(dropSessionObjectWithName);
                    this.session.dropSessionMember(dropSessionObjectWithName);
                }
                break block11;
            }
            if (!(dropMemberOrSetStatement instanceof ASTDropSetStatement)) break block11;
            childCount = dropMemberOrSetStatement.jjtGetNumChildren();
            for (int j = 0; j < childCount; ++j) {
                String dropSessionObjectWithName;
                this.depth = 0;
                Object obj = dropMemberOrSetStatement.jjtGetChild(j).accept(this, null);
                if (obj instanceof NamedSet) {
                    dropSessionObjectWithName = OPEN_SQUARE_BRACKET + ((NamedSet)obj).getCubeName() + "]." + ((NamedSet)obj).getUniqueName();
                } else if (obj instanceof CalculatedMember) {
                    dropSessionObjectWithName = ((CalculatedMember)obj).getUniqueName();
                } else if (obj instanceof String[]) {
                    String[] memberName = (String[])obj;
                    dropSessionObjectWithName = "";
                    for (int k = 0; k < memberName.length; ++k) {
                        String s = memberName[k];
                        dropSessionObjectWithName = dropSessionObjectWithName + OPEN_SQUARE_BRACKET + s + CLOSE_SQUARE_BRACKET;
                        if (k >= memberName.length - 1) continue;
                        dropSessionObjectWithName = dropSessionObjectWithName + PERIOD;
                    }
                } else {
                    String classCode = this.getClassNameCode(obj.getClass().getSimpleName());
                    throw new InterpreterException("X01461", new String[]{classCode, "CMP_TYPENAMEDSET, CMP_TYPECALCMEMBER, CMP_TYPESTRING"});
                }
                if (dropSessionObjectWithName == null) continue;
                this.createDropResult = obj;
                this.session.dropSessionSet(dropSessionObjectWithName);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processCreate(ASTCreateFormulaStatement node) throws InterpreterException {
        int childCount = node.jjtGetNumChildren();
        this.createStatement = true;
        logger.log(" found create formula spec with " + childCount + " items to be created. ");
        Node formulaSpec = node.jjtGetChild(childCount - 1);
        int countSingleFormulaSpecifications = formulaSpec.jjtGetNumChildren();
        for (int i = 0; i < countSingleFormulaSpecifications; ++i) {
            Node formulaSpecNode = formulaSpec.jjtGetChild(i);
            logger.log("  Create Working on: " + formulaSpecNode.toString() + " " + formulaSpecNode.getClass().getName());
            if (formulaSpecNode.jjtGetNumChildren() <= 0) continue;
            Node setOrMemberSpec = formulaSpecNode.jjtGetChild(0);
            logger.log("  Formula spec working on: " + setOrMemberSpec.toString() + " " + setOrMemberSpec.getClass());
            if (setOrMemberSpec instanceof ASTMemberSpecification) {
                logger.log("    Found Member Specification");
                CalculatedMember mem = this.processMemberSpecification((SimpleNode)setOrMemberSpec, "SESSION");
                logger.log("Calculated member " + mem.toString());
                this.session.addSessionMember(mem);
                this.createDropResult = mem;
                continue;
            }
            if (!(setOrMemberSpec instanceof ASTSetSpecification)) continue;
            logger.log("    Found Set Specification");
            NamedSet namedSet = null;
            String cubeName = null;
            Node nodeASTSetName = setOrMemberSpec.jjtGetChild(0);
            int itemCount = nodeASTSetName.jjtGetNumChildren();
            int setNameIndex = 0;
            if (itemCount > 1) {
                cubeName = nodeASTSetName.jjtGetChild(0).accept(this, null).toString();
                setNameIndex = 1;
            }
            String setName = nodeASTSetName.jjtGetChild(setNameIndex).accept(this, null).toString();
            Node setExpressionNode = setOrMemberSpec.jjtGetChild(1);
            Provider provider = this.interpreterContext.getProvider();
            try {
                if (cubeName == null) {
                    throw new InterpreterException("X01518");
                }
                Cube c = provider.getCube(cubeName);
                if (c == null) {
                    throw new InterpreterException("X01425", new String[]{cubeName});
                }
                c.initialize();
                this.interpreterContext.setCube(c);
                IMember[] mems = new IMember[c.getDimensionCount()];
                for (int j = 0; j < mems.length; ++j) {
                    try {
                        mems[j] = ((Dimension)c.getDimension(j)).isAttributeDimension() ? ((Dimension)c.getDimension(j)).getDummyMember(c.getDimension(j).getDefaultHierarchy()) : MemberOperations.getDefaultMemberOp(c.getDimension(j), this.interpreterContext);
                        if (mems[j] != null) continue;
                        XQEDebugLog.out.println("Dimension " + c.getDimension(j).getUniqueName() + " contains no default member. Creating empty initial context");
                        continue;
                    }
                    catch (MetadataException e) {
                        throw new InterpreterException("X01408", new String[]{c.getDimension(j).getUniqueID()}, e);
                    }
                }
                ISet[] contextSets = new Set[]{new Set(new Tuple(mems))};
                this.interpreterContext.setInitialContextSet(new CrossJoinedSet(contextSets));
            }
            catch (ProviderException e) {
                throw new InterpreterException("X01425", new String[]{cubeName}, e);
            }
            if (setExpressionNode instanceof ASTValueExpressionPrimary) {
                IXQEQueryNode parent = ((ASTValueExpressionPrimary)setExpressionNode).getParent();
                ((ASTValueExpressionPrimary)setExpressionNode).setParent(null);
                Object setExpression = setExpressionNode.accept(this, null);
                ((ASTValueExpressionPrimary)setExpressionNode).setParent(parent);
                if (setExpression instanceof Set[]) {
                    namedSet = new NamedSet(setName, (Set[])setExpression);
                } else {
                    if (!(setExpression instanceof Set)) throw new InterpreterException("X01515");
                    namedSet = new NamedSet(setName, new Set[]{(Set)setExpression});
                }
            } else if (setExpressionNode instanceof ASTStringValueExpression) {
                String setString = ((ASTStringValueExpression)setExpressionNode).accept(this, null).toString();
                setString = setString.replaceAll("''", "'");
                namedSet = new NamedSet(setName, setString);
            } else if (setExpressionNode instanceof ASTSet) {
                Object setExpression = setExpressionNode.accept(this, null);
                namedSet = new NamedSet(setName, (Set[])setExpression);
            }
            namedSet.setCubeName(cubeName);
            this.session.addSessionSet(namedSet);
            this.createDropResult = namedSet;
        }
    }

    public Object interpretCalculation(Node node) throws InterpreterException {
        this.depth = 0;
        Object result = node.accept(this, null);
        this.outputProfile();
        return result;
    }

    public Object interpretCalculation() throws InterpreterException {
        this.depth = 0;
        Object result = this.getRootNode().accept(this, null);
        this.outputProfile();
        return result;
    }

    public Object interpretObject() throws InterpreterException {
        this.depth = 0;
        return this.getRootNode().accept(this, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visit(SimpleNode node, Object data) throws InterpreterException {
        this.interpreterContext.exceptIfCanceled();
        this.startProfile();
        String stringIndent = "";
        String params = "";
        String extra = "";
        if (logger.isOn(LogLevel.TRACE)) {
            ++this.depth;
            char[] chars = new char[this.depth];
            Arrays.fill(chars, ' ');
            stringIndent = "" + chars;
            String[] paramNames = node.getParameterNames();
            if (paramNames.length > 0) {
                params = "(" + params;
                for (int i = 0; i < paramNames.length; ++i) {
                    if (i > 0) {
                        params = params + ", ";
                    }
                    params = params + paramNames[i] + " = " + node.getParameterObject(paramNames[i]);
                }
                params = params + ")";
            }
            if (data != null) {
                extra = "data = " + data.getClass().getName();
            }
            logger.log(stringIndent + node.getClass().getName() + " " + params + " " + extra);
        }
        Object result = null;
        try {
            int childCount = node.jjtGetNumChildren();
            if (node instanceof ASTCreateFormulaStatement) {
                this.processCreate((ASTCreateFormulaStatement)node);
            } else if (node instanceof ASTDropFormulaStatement) {
                this.processDrop((ASTDropFormulaStatement)node);
            } else if (node instanceof ASTSelectStatement) {
                result = this.processSelect((ASTSelectStatement)node, childCount, data);
            } else if (node instanceof ASTCubeName) {
                result = this.processCubeName((ASTCubeName)node, childCount, data);
            } else if (node instanceof ASTCubeSpecification) {
                result = this.processCubeSpecification((ASTCubeSpecification)node, childCount, data);
            } else if (node instanceof ASTSlicerSpecification || node instanceof ASTProperty || node instanceof ASTConditionalExpression) {
                result = node.jjtGetChild(0).accept(this, data);
            } else if (node instanceof ASTDimProps) {
                result = this.processDimProps((ASTDimProps)node, childCount, data);
            } else if (node instanceof ASTMandatoryProperty) {
                result = new com.cognos.xqe.runtree.olap.mdx.metadata.Property(node.getKeyword());
            } else if (node instanceof ASTUserDefinedProperty) {
                result = this.processPropertyIdentifier(node);
            } else if (node instanceof ASTAxisSpecification) {
                result = this.processAxisSpecification((ASTAxisSpecification)node, childCount, data);
            } else if (node instanceof ASTCreateFormulaStatement) {
                logger.log("Create Query");
            } else if (node instanceof ASTMemberSpecification) {
                result = this.processMemberSpecification((ASTMemberSpecification)node, childCount, data);
            } else if (node instanceof ASTSetSpecification) {
                result = this.processSetSpecification((ASTSetSpecification)node, childCount, data);
            } else if (node instanceof ASTMemberPropertyDefinition) {
                result = new Object[]{node.jjtGetChild(0).accept(this, data), node.jjtGetChild(1).accept(this, data)};
            } else if (node instanceof ASTCharacterStringLiteral) {
                result = node.getParameter("literal");
            } else if (node instanceof ASTMemberName) {
                result = this.processMemberName((ASTMemberName)node, childCount, data);
            } else if (node instanceof ASTInlineNamedSet) {
                result = this.processInlineNamedSet((ASTInlineNamedSet)node, childCount, data);
            } else if (node instanceof ASTSet) {
                result = this.processSet((ASTSet)node, childCount, data);
            } else if (node instanceof ASTTuple) {
                result = this.processTuple((ASTTuple)node, childCount, data);
            } else if (node instanceof ASTComposite) {
                result = this.processComposite((ASTComposite)node, childCount, data);
            } else if (node instanceof ASTElement) {
                result = this.processElement((ASTElement)node, childCount, data);
            } else if (node instanceof ASTExpressionList) {
                result = this.processExpressionList((ASTExpressionList)node, childCount, data);
            } else if (node instanceof ASTExpression) {
                result = this.processExpression((ASTExpression)node, childCount, data);
            } else if (node instanceof ASTIfExpression) {
                result = this.processIfExpression((ASTIfExpression)node, childCount, data);
            } else if (node instanceof ASTNumericValueExpression) {
                result = this.processNumericValueExpression((ASTNumericValueExpression)node, childCount, data);
            } else if (node instanceof ASTTerm) {
                result = this.processTerm((ASTTerm)node, childCount, data);
            } else if (node instanceof ASTFactor) {
                result = this.processFactor((ASTFactor)node, childCount, data);
            } else if (node instanceof ASTValueExpressionPrimary) {
                result = this.processValueExpressionPrimary((ASTValueExpressionPrimary)node, childCount, data);
            } else if (node instanceof ASTStringValueExpressionPrimary) {
                result = this.processStringValueExpressionPrimary((ASTStringValueExpressionPrimary)node, childCount, data);
            } else if (node instanceof ASTUnsignedNumericLiteral) {
                result = this.processUnsignedNumericLiteral((ASTUnsignedNumericLiteral)node, childCount, data);
            } else if (node instanceof ASTStringValueExpression) {
                result = this.processStringValueExpression((ASTStringValueExpression)node, childCount, data);
            } else if (node instanceof ASTSearchCondition) {
                result = this.processSearchCondition((ASTSearchCondition)node, childCount, data);
            } else if (node instanceof ASTBooleanTerm) {
                result = this.processBooleanTerm((ASTBooleanTerm)node, childCount, data);
            } else if (node instanceof ASTBooleanFactor) {
                result = this.processBooleanFactor((ASTBooleanFactor)node, childCount, data);
            } else if (node instanceof ASTBooleanPrimary) {
                result = this.processBooleanPrimary((ASTBooleanPrimary)node, childCount, data);
            } else if (node instanceof ASTMDXNode) {
                result = this.processMDXNode((ASTMDXNode)node, childCount, data);
            } else if (node instanceof ASTCellProps) {
                result = this.processCellProps((ASTCellProps)node, childCount, data);
            } else if (node instanceof ASTCellProperty) {
                result = this.processCellProperty((ASTCellProperty)node, childCount, data);
            } else {
                for (int i = 0; i < childCount; ++i) {
                    node.jjtGetChild(i).accept(this, data);
                }
            }
        }
        finally {
            this.stopProfile(node);
        }
        return result;
    }

    private ResultSet setToResultSet(Set componentSet) throws InterpreterException {
        IDimension[] dims = componentSet.getDimensions();
        ISet s = this.interpreterContext.getContextSet();
        s = s.removeDimensions(dims, false);
        SetEvaluator se = new SetEvaluator(this.interpreterContext);
        ResultSetConfiguration config = this.interpreterContext.getResultSetConfiguration();
        boolean pipeEnable = config.setSupportPipelineProcessing(false);
        IResultSet rs = se.getSetResults(componentSet, s);
        config.setSupportPipelineProcessing(pipeEnable);
        IDimension[] cmdDims = componentSet.getCurrentMemberDimensions();
        rs.addCurrentMemberDimensions(cmdDims);
        return (ResultSet)rs;
    }

    public static String unescapeQuotes(String input) {
        StringBuilder buff = new StringBuilder();
        boolean justSeenQuote = false;
        boolean justSeenDoubleQuote = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\'') {
                if (!justSeenQuote) {
                    buff.append(c);
                    justSeenQuote = true;
                    continue;
                }
                justSeenQuote = false;
                continue;
            }
            if (c == '\"') {
                if (!justSeenDoubleQuote) {
                    buff.append(c);
                    justSeenDoubleQuote = true;
                    continue;
                }
                justSeenDoubleQuote = false;
                continue;
            }
            buff.append(c);
            justSeenDoubleQuote = false;
            justSeenQuote = false;
        }
        return buff.toString();
    }

    public static String unescapeQuotes2(String input) {
        StringBuilder buff = new StringBuilder();
        boolean justSeenQuote = false;
        boolean justSeenDoubleQuote = false;
        boolean sqBracketSeen = false;
        char dummyC = '\"';
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\'') {
                if (!justSeenQuote || i == 1) {
                    buff.append(c);
                    justSeenQuote = true;
                    continue;
                }
                justSeenQuote = false;
                continue;
            }
            if (c == '\"') {
                if (!justSeenDoubleQuote) {
                    buff.append(c);
                    justSeenDoubleQuote = true;
                } else {
                    justSeenDoubleQuote = false;
                    if (!sqBracketSeen) {
                        buff.append(dummyC);
                    }
                }
                if (!justSeenQuote) continue;
                justSeenQuote = false;
                continue;
            }
            if (c == '[') {
                sqBracketSeen = true;
            } else if (c == ']') {
                sqBracketSeen = false;
            }
            buff.append(c);
            justSeenDoubleQuote = false;
            justSeenQuote = false;
        }
        return buff.toString();
    }

    private Set[] unionSets(Set[] sets1, Set[] sets2) throws InterpreterException {
        if (sets1 == null || sets1.length == 0) {
            if (sets2 != null && sets2.length > 0) {
                return sets2;
            }
            return new Set[]{new Set(new Tuple[0])};
        }
        if (sets2 == null || sets2.length == 0) {
            return sets1;
        }
        CrossJoinedSet currentContextSet = this.interpreterContext.getContextSet();
        IDimension[] sets1Cmd = sets1[0].getCurrentMemberDimensions();
        IDimension[] sets2Cmd = sets2[0].getCurrentMemberDimensions();
        HashSet<Dimension> commonDims = new HashSet<Dimension>();
        commonDims.addAll(Arrays.asList(sets1Cmd));
        commonDims.addAll(Arrays.asList(sets2Cmd));
        Set workingContextSet = currentContextSet.extract(commonDims.toArray(new Dimension[0]), false);
        Set workingCtxSet1 = workingContextSet.extract(sets1Cmd, false);
        Set workingCtxSet2 = workingContextSet.extract(sets2Cmd, false);
        ArrayList<Set> unionedSets = new ArrayList<Set>();
        IIterator workingCtxSetIter = workingContextSet.iterator();
        while (workingCtxSetIter.hasNext()) {
            Tuple workingContextTuple = (Tuple)workingCtxSetIter.next();
            long[] workinCtxOrds = workingCtxSet1.getOrdinals(workingContextTuple.retain((Dimension[])sets1Cmd), false);
            long workingCtxSet1Ord = workinCtxOrds[0];
            workinCtxOrds = workingCtxSet2.getOrdinals(workingContextTuple.retain((Dimension[])sets2Cmd), false);
            long workingCtxSet2Ord = workinCtxOrds[0];
            unionedSets.add(Set.union(new Set[]{sets1[(int)workingCtxSet1Ord], sets2[(int)workingCtxSet2Ord]}, true));
        }
        return unionedSets.toArray(new Set[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CalculatedMember processMemberSpecification(SimpleNode node, String scope) throws InterpreterException {
        CalculatedMember calcMem;
        int i;
        ICube cube;
        int childCount = node.jjtGetNumChildren();
        String[] identifiers = (String[])node.jjtGetChild(0).accept(this, null);
        int dimNameOffset = 0;
        if ("SESSION".equals(scope)) {
            try {
                cube = this.interpreterContext.getProvider().getCube(identifiers[0]);
                dimNameOffset = 1;
            }
            catch (ProviderException e) {
                throw new InterpreterException("X01439", new String[]{identifiers[0]}, e);
            }
        } else {
            cube = this.interpreterContext.getCube();
            if (cube.getName().equalsIgnoreCase(identifiers[0])) {
                ++dimNameOffset;
            }
        }
        IDimension d = cube.getDimension(identifiers[dimNameOffset]);
        if (d == null && dimNameOffset == 1) {
            d = cube.getDimension(identifiers[--dimNameOffset]);
        }
        if (d == null && identifiers.length == 1) {
            throw new InterpreterException("X01439", new String[]{identifiers[0]});
        }
        IMember calcParent = null;
        IHierarchy h = null;
        int levelNameOffset = 0;
        if (d == null) {
            h = cube.getHierarchy(identifiers[dimNameOffset]);
            levelNameOffset = dimNameOffset;
            if (h == null) {
                calcParent = ((Cube)cube).findMember(identifiers[dimNameOffset]);
                if (calcParent == null) throw new InterpreterException("X01810", new String[]{identifiers[0 + dimNameOffset]});
                d = calcParent.getDimension();
                h = calcParent.getHierarchy();
            }
        } else {
            levelNameOffset = dimNameOffset + 1;
            h = d.getHierarchy(identifiers[levelNameOffset]);
        }
        ILevel calcLevel = null;
        if (calcParent == null) {
            if (h == null) {
                h = d.getDefaultHierarchy();
            } else {
                ++levelNameOffset;
            }
            calcLevel = d.getLevel(identifiers[levelNameOffset]);
            if (calcLevel != null) {
                ++levelNameOffset;
            }
        } else {
            ++levelNameOffset;
        }
        for (i = levelNameOffset; i < identifiers.length - 1; ++i) {
            try {
                if (calcParent == null) {
                    calcParent = d.getMember(identifiers[i]);
                    if (calcParent == null) {
                        calcParent = ((Dimension)d).findMember(identifiers[i]);
                    }
                    if (calcParent != null) continue;
                    throw new InterpreterException("X01439", new String[]{identifiers[i]});
                }
                IMember tempCalcParent = calcParent.getChildMember(identifiers[i]);
                if (tempCalcParent == null) throw new InterpreterException("X01439", new String[]{identifiers[i]});
                calcParent = tempCalcParent;
                continue;
            }
            catch (MetadataException e) {
                throw new InterpreterException("X01427", new String[]{identifiers[i]}, e);
            }
        }
        if (calcParent != null && (calcLevel = calcParent.getLevel().getNextLevel()) == null) {
            throw new InterpreterException("X01426", new String[]{"Null"});
        }
        if (calcLevel == null) {
            calcLevel = h.getLevel(0);
        }
        String calcName = identifiers[identifiers.length - 1];
        Node calcNode = node.jjtGetChild(1);
        try {
            block56: {
                calcMem = new CalculatedMember(calcName, calcLevel, calcNode, identifiers);
                if ("SESSION".equals(scope)) {
                    CrossJoinedSet contextSets;
                    calcMem.setMemberId(((Cube)cube).getNextSessionCalculatedMemberID());
                    Provider provider = this.interpreterContext.getProvider();
                    try {
                        ((Cube)cube).initialize();
                        IMember[] mems = new IMember[cube.getDimensionCount()];
                        for (int j = 0; j < mems.length; ++j) {
                            try {
                                mems[j] = ((Dimension)cube.getDimension(j)).isAttributeDimension() ? ((Dimension)cube.getDimension(j)).getDummyMember(cube.getDimension(j).getDefaultHierarchy()) : cube.getDimension(j).getDefaultHierarchy().getDefaultMember();
                                if (mems[j] != null) continue;
                                XQEDebugLog.out.println("Dimension " + cube.getDimension(j).getUniqueName() + " contains no default member. Creating empty initial context");
                                continue;
                            }
                            catch (MetadataException e) {
                                throw new InterpreterException("X01408", new String[]{cube.getDimension(j).getUniqueName()}, e);
                            }
                        }
                        contextSets = new CrossJoinedSet(new Set[]{new Set(new Tuple(mems))});
                    }
                    catch (ProviderException e) {
                        throw new InterpreterException("X01425", new String[]{cube.getName()}, e);
                    }
                    if (calcNode instanceof ASTCharacterStringLiteral) {
                        ByteArrayInputStream inputStream;
                        String calculationString = (String)calcNode.accept(this, null);
                        calcMem.setCalculationString(calculationString);
                        calculationString = calcMem.getUnescapeCalculationString();
                        try {
                            inputStream = new ByteArrayInputStream(calculationString.getBytes("UTF-8"));
                        }
                        catch (IOException e) {
                            throw new MetadataException("X01499", new String[]{e.toString()}, e);
                        }
                        MDXParser parser = new MDXParser(inputStream, "UTF-8");
                        XQEDebugLog.out.println("parser : " + parser);
                        try {
                            ParseException e = parser.ValueExpression();
                            if (e != null) {
                                throw e;
                            }
                        }
                        catch (ParseException e) {
                            throw new MetadataException("X01499", new String[]{e.toString()}, e);
                        }
                        InterpreterContext context = new InterpreterContext(provider, null);
                        context.setSession(this.interpreterContext.getSession());
                        context.setQueryContext(this.interpreterContext.getQueryContext());
                        context.setCube(cube);
                        context.setInitialContextSet(contextSets);
                        context.setRefCalcMember(calcMem);
                        Interpreter interpreter = new Interpreter(context, parser);
                        Object o = interpreter.interpretCalculation();
                        if (o instanceof ASTSet) {
                            throw new InterpreterException("X01496", new String[]{((ASTSet)o).toString()});
                        }
                        break block56;
                    }
                    if (calcNode instanceof ASTSet) {
                        throw new InterpreterException("X01496", new String[]{calcNode.toString()});
                    }
                    InterpreterContext context = new InterpreterContext(provider, null);
                    context.setQueryContext(this.interpreterContext.getQueryContext());
                    context.setCube(cube);
                    context.setInitialContextSet(contextSets);
                    context.setRefCalcMember(calcMem);
                    Interpreter interpreter = new Interpreter(context, null);
                    Object o = interpreter.interpretCalculation(calcNode);
                    if (o instanceof ASTSet) {
                        throw new InterpreterException("X01496", new String[]{o.toString()});
                    }
                    break block56;
                }
                calcMem.setMemberId(this.interpreterContext.getCalculationEngine().getNextCalculatedMemberID());
            }
            calcMem.setParentMember(calcParent);
            if ("STATEMENT".equalsIgnoreCase(scope)) {
                calcMem.setType(MemberTypeEnum.QUERY_CALCULATION);
            } else if ("SESSION".equalsIgnoreCase(scope)) {
                calcMem.setType(MemberTypeEnum.SESSION_CALCULATION);
            }
            StringBuilder givenName = new StringBuilder();
            int jstart = 0;
            if ("SESSION".equals(scope)) {
                jstart = 1;
            }
            for (int j = jstart; j < identifiers.length; ++j) {
                String string = identifiers[j];
                givenName.append(OPEN_SQUARE_BRACKET);
                givenName.append(string);
                givenName.append(CLOSE_SQUARE_BRACKET);
                if (j >= identifiers.length - 1) continue;
                givenName.append(PERIOD);
            }
            calcMem.setProperty("DefinitionUniqueName", givenName.toString());
            if (calcParent != null) {
                calcMem.setUniqueName(calcParent.getUniqueName() + ".[" + calcName + CLOSE_SQUARE_BRACKET);
            } else {
                calcMem.setUniqueName(d.getUniqueName() + ".[" + calcName + CLOSE_SQUARE_BRACKET);
            }
        }
        catch (MetadataException e) {
            throw new InterpreterException("X01496", new String[]{calcName}, e);
        }
        HashSet<String> alreadySetProperties = new HashSet<String>();
        for (i = 2; i < childCount; ++i) {
            Object[] property = (Object[])node.jjtGetChild(i).accept(this, null);
            String propName = (String)property[0];
            Object propValue = property[1];
            if (propValue instanceof String) {
                String propString = (String)propValue;
                propValue = CalculatedMember.unescapeCalculationString(propString);
            }
            logger.log("Calculated Member property name: " + propName + ", value: " + propValue);
            if (alreadySetProperties.contains(propName.toUpperCase())) {
                throw new InterpreterException("X01492", new String[]{propName});
            }
            if ("caption".equalsIgnoreCase(propName)) {
                calcMem.setCaption(propValue.toString());
                alreadySetProperties.add(propName.toUpperCase());
                continue;
            }
            if ("solve_order".equalsIgnoreCase(propName)) {
                Double doublePropValue = (Double)propValue;
                if (doublePropValue > 2.147483647E9) {
                    throw new InterpreterException("X01491");
                }
                calcMem.setSolveOrder(doublePropValue.intValue());
                alreadySetProperties.add(propName.toUpperCase());
                continue;
            }
            calcMem.setProperty(propName, propValue);
            alreadySetProperties.add(propName.toUpperCase());
        }
        return calcMem;
    }

    public IProperty processPropertyIdentifier(SimpleNode node) throws InterpreterException {
        IMetadata mdobj = null;
        IProperty result = null;
        ICube cube = this.interpreterContext.getCube();
        int childCount = node.jjtGetNumChildren();
        for (int i = 0; result == null && i < childCount; ++i) {
            ICalculationEngine calculationEngine;
            ILevel level;
            Object obj = node.jjtGetChild(i).accept(this, null);
            if (obj instanceof com.cognos.xqe.runtree.olap.mdx.metadata.Property) {
                result = (com.cognos.xqe.runtree.olap.mdx.metadata.Property)obj;
                if (mdobj.getObjectType() != MetadataType.LEVEL) continue;
                level = (ILevel)mdobj;
                ((Property)result).setLevel(level);
                continue;
            }
            if (!(obj instanceof String)) continue;
            String identifier = (String)obj;
            if (mdobj == null) {
                if (this.mandatoryMemberProperties.contains(identifier.toUpperCase())) {
                    mdobj = new com.cognos.xqe.runtree.olap.mdx.metadata.Property(identifier.toUpperCase());
                    ((com.cognos.xqe.runtree.olap.mdx.metadata.Property)mdobj).setUserDefined(false);
                    result = (com.cognos.xqe.runtree.olap.mdx.metadata.Property)mdobj;
                }
                if (mdobj != null || (mdobj = cube.getDimension(identifier)) != null || (mdobj = (calculationEngine = this.interpreterContext.getCalculationEngine()).findCalculatedMember(identifier)) != null) continue;
                if (cube.getName().equalsIgnoreCase(identifier)) {
                    mdobj = cube;
                    continue;
                }
                throw new InterpreterException("X01405", new String[]{identifier});
            }
            if (mdobj.getObjectType() == MetadataType.CUBE) {
                mdobj = cube.getDimension(identifier);
                if (mdobj != null || (mdobj = (calculationEngine = this.interpreterContext.getCalculationEngine()).findCalculatedMember(identifier)) != null) continue;
                throw new InterpreterException("X01405", new String[]{identifier});
            }
            if (mdobj.getObjectType() == MetadataType.DIMENSION) {
                IDimension dimension = (IDimension)mdobj;
                if ((mdobj = dimension.getLevel(identifier)) != null) continue;
                if (this.mandatoryMemberProperties.contains(identifier.toUpperCase())) {
                    result = new com.cognos.xqe.runtree.olap.mdx.metadata.Property(identifier.toUpperCase());
                    ((Property)result).setDimension(dimension);
                    ((com.cognos.xqe.runtree.olap.mdx.metadata.Property)result).setUserDefined(false);
                }
                for (ILevel l = dimension.getLevel(0); result == null && l != null; l = l.getNextLevel()) {
                    result = l.getMemberProperty(identifier);
                }
                if (result == null) {
                    throw new InterpreterException("X01405", new String[]{identifier});
                }
                if (childCount != 2 || ((com.cognos.xqe.runtree.olap.mdx.metadata.Property)result).getLevel() == null) continue;
                return new com.cognos.xqe.runtree.olap.mdx.metadata.Property(((com.cognos.xqe.runtree.olap.mdx.metadata.Property)result).getName());
            }
            if (mdobj.getObjectType() == MetadataType.LEVEL) {
                level = (ILevel)mdobj;
                result = level.getMemberProperty(identifier);
                if (result != null) continue;
                if (this.mandatoryMemberProperties.contains(identifier.toUpperCase())) {
                    result = new com.cognos.xqe.runtree.olap.mdx.metadata.Property(identifier.toUpperCase());
                    ((com.cognos.xqe.runtree.olap.mdx.metadata.Property)result).setLevel(level);
                    ((com.cognos.xqe.runtree.olap.mdx.metadata.Property)result).setUserDefined(false);
                }
                if (result != null) continue;
                throw new InterpreterException("X01405", new String[]{identifier});
            }
            throw new InterpreterException("X01405", new String[]{identifier});
        }
        return result;
    }

    private Object processMemberFunction(String identifier, Object hierOrDim, Object data, boolean isLastPartOfIndentifier) throws InterpreterException {
        Object[] result = null;
        String[] childOperands = new String[]{FUNCTION_LASTSIBLING, FUNCTION_FIRSTSIBLING, FUNCTION_FIRSTCHILD, FUNCTION_LASTCHILD, FUNCTION_PARENT, FUNCTION_PREV_MEMBER, FUNCTION_NEXT_MEMBER, FUNCTION_UNIQUE_NAME, FUNCTION_NAME, FUNCTION_CAPTION};
        for (int i = 0; i < childOperands.length; ++i) {
            IMember[] mems;
            String childOperand = childOperands[i];
            if (!childOperand.equals(identifier)) continue;
            boolean membersOut = true;
            String[] stringReturnTypes = new String[]{FUNCTION_UNIQUE_NAME, FUNCTION_NAME, FUNCTION_CAPTION};
            for (int j = 0; j < stringReturnTypes.length; ++j) {
                if (!stringReturnTypes[j].equals(identifier)) continue;
                membersOut = false;
            }
            if (hierOrDim instanceof Dimension) {
                mems = this.getCurrentMembers((Dimension)hierOrDim, data);
            } else if (hierOrDim instanceof Hierarchy) {
                mems = this.getCurrentMembers((Hierarchy)hierOrDim, data);
            } else {
                throw new InterpreterException("X01434", new String[]{identifier, "CMP_TYPEHIERARCHY, CMP_TYPEDIMENSION"});
            }
            if (mems.length == 0) {
                mems = new IMember[1];
                if (hierOrDim instanceof Dimension) {
                    mems[0] = MemberOperations.getDefaultMemberOp((Dimension)hierOrDim, this.interpreterContext);
                } else if (hierOrDim instanceof Hierarchy) {
                    mems[0] = MemberOperations.getDefaultMemberOp((Hierarchy)hierOrDim, this.interpreterContext);
                } else {
                    throw new InterpreterException("X01434", new String[]{identifier, "CMP_TYPEHIERARCHY, CMP_TYPEDIMENSION"});
                }
            }
            ArrayList<Object> output = new ArrayList<Object>();
            for (int j = 0; j < mems.length; ++j) {
                Object oB = this.processMemberIdentifierPart(mems[j], identifier, isLastPartOfIndentifier);
                output.add(oB);
            }
            result = membersOut ? output.toArray(new IMember[0]) : output.toArray(new String[0]);
        }
        return result;
    }

    private Object processFunctionCurrentMember(IDimension dimension, Object data) throws InterpreterException {
        Object result = this.getCurrentMembers(dimension, data);
        IMember[] currMembers = result;
        if (currMembers.length > 1) {
            result = new Set(Tuple.createTupleList(currMembers));
            ((Set)result).addCurrentMemberDimension(dimension);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object processElement(SimpleNode node, Object result, Object data) throws InterpreterException {
        block321: {
            block317: {
                block397: {
                    block395: {
                        block393: {
                            block388: {
                                block401: {
                                    block386: {
                                        block400: {
                                            block384: {
                                                block399: {
                                                    block382: {
                                                        block398: {
                                                            block380: {
                                                                block378: {
                                                                    block376: {
                                                                        block369: {
                                                                            block367: {
                                                                                block365: {
                                                                                    block363: {
                                                                                        block361: {
                                                                                            block318: {
                                                                                                block326: {
                                                                                                    block327: {
                                                                                                        block371: {
                                                                                                            block396: {
                                                                                                                block394: {
                                                                                                                    block392: {
                                                                                                                        block391: {
                                                                                                                            block390: {
                                                                                                                                block389: {
                                                                                                                                    block387: {
                                                                                                                                        block385: {
                                                                                                                                            block383: {
                                                                                                                                                block381: {
                                                                                                                                                    block379: {
                                                                                                                                                        block377: {
                                                                                                                                                            block375: {
                                                                                                                                                                block374: {
                                                                                                                                                                    block373: {
                                                                                                                                                                        block372: {
                                                                                                                                                                            block355: {
                                                                                                                                                                                block370: {
                                                                                                                                                                                    block368: {
                                                                                                                                                                                        block366: {
                                                                                                                                                                                            block364: {
                                                                                                                                                                                                block362: {
                                                                                                                                                                                                    block359: {
                                                                                                                                                                                                        block360: {
                                                                                                                                                                                                            block358: {
                                                                                                                                                                                                                block357: {
                                                                                                                                                                                                                    block356: {
                                                                                                                                                                                                                        block352: {
                                                                                                                                                                                                                            block353: {
                                                                                                                                                                                                                                block354: {
                                                                                                                                                                                                                                    block351: {
                                                                                                                                                                                                                                        block337: {
                                                                                                                                                                                                                                            block319: {
                                                                                                                                                                                                                                                block349: {
                                                                                                                                                                                                                                                    block350: {
                                                                                                                                                                                                                                                        block348: {
                                                                                                                                                                                                                                                            block347: {
                                                                                                                                                                                                                                                                block346: {
                                                                                                                                                                                                                                                                    block345: {
                                                                                                                                                                                                                                                                        block344: {
                                                                                                                                                                                                                                                                            block343: {
                                                                                                                                                                                                                                                                                block342: {
                                                                                                                                                                                                                                                                                    block341: {
                                                                                                                                                                                                                                                                                        block340: {
                                                                                                                                                                                                                                                                                            block339: {
                                                                                                                                                                                                                                                                                                block338: {
                                                                                                                                                                                                                                                                                                    block336: {
                                                                                                                                                                                                                                                                                                        block328: {
                                                                                                                                                                                                                                                                                                            block335: {
                                                                                                                                                                                                                                                                                                                block334: {
                                                                                                                                                                                                                                                                                                                    block333: {
                                                                                                                                                                                                                                                                                                                        block332: {
                                                                                                                                                                                                                                                                                                                            block331: {
                                                                                                                                                                                                                                                                                                                                block330: {
                                                                                                                                                                                                                                                                                                                                    block329: {
                                                                                                                                                                                                                                                                                                                                        block322: {
                                                                                                                                                                                                                                                                                                                                            block325: {
                                                                                                                                                                                                                                                                                                                                                block324: {
                                                                                                                                                                                                                                                                                                                                                    block323: {
                                                                                                                                                                                                                                                                                                                                                        block320: {
                                                                                                                                                                                                                                                                                                                                                            cube = this.interpreterContext.getCube();
                                                                                                                                                                                                                                                                                                                                                            if (cube == null && result /* !! */  instanceof ICube) {
                                                                                                                                                                                                                                                                                                                                                                cube = (ICube)result /* !! */ ;
                                                                                                                                                                                                                                                                                                                                                                this.interpreterContext.setCube(cube);
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                            identifierNode = (ASTMDXNode)node.jjtGetChild(0).accept(this, data);
                                                                                                                                                                                                                                                                                                                                                            identifier = identifierNode.getText();
                                                                                                                                                                                                                                                                                                                                                            delimitedValue = identifierNode.getParameter("delimited");
                                                                                                                                                                                                                                                                                                                                                            v0 = delimited = delimitedValue != null && "true".equals(delimitedValue) != false;
                                                                                                                                                                                                                                                                                                                                                            if (result /* !! */  == null && !delimited) {
                                                                                                                                                                                                                                                                                                                                                                if ("Null".equalsIgnoreCase(identifier)) {
                                                                                                                                                                                                                                                                                                                                                                    return NullObject.instance();
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                if ("true".equalsIgnoreCase(identifier) != false) return Boolean.valueOf(identifier);
                                                                                                                                                                                                                                                                                                                                                                if ("false".equalsIgnoreCase(identifier)) {
                                                                                                                                                                                                                                                                                                                                                                    return Boolean.valueOf(identifier);
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                if (this.reservedWords.contains(identifier)) {
                                                                                                                                                                                                                                                                                                                                                                    if (identifier.equalsIgnoreCase("RECURSIVE") == false) return identifier;
                                                                                                                                                                                                                                                                                                                                                                    return new KeyWord("RECURSIVE");
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                            if ((parentNode = node.jjtGetParent()) instanceof ASTSet && (setKeyWord = ((ASTSet)parentNode).getKeyword()) != null && "Set".equals(setKeyWord) && ((ASTSet)parentNode).getParameterObject("elementSet") != null) {
                                                                                                                                                                                                                                                                                                                                                                result /* !! */  = ((ASTSet)parentNode).getParameterObject("elementSet");
                                                                                                                                                                                                                                                                                                                                                                ((ASTSet)parentNode).setParameterObject("elementSet", null);
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                            v1 = hasExpressionList = node.getParameter("hasExpressionList") != null;
                                                                                                                                                                                                                                                                                                                                                            if (!hasExpressionList) break block320;
                                                                                                                                                                                                                                                                                                                                                            fManager = FunctionManager.getInstance();
                                                                                                                                                                                                                                                                                                                                                            expressionListNode = null;
                                                                                                                                                                                                                                                                                                                                                            if (node.jjtGetNumChildren() > 1) {
                                                                                                                                                                                                                                                                                                                                                                expressionListNode = (SimpleNode)node.jjtGetChild(1);
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                            this.stopProfile(node);
                                                                                                                                                                                                                                                                                                                                                            result /* !! */  = fManager.execute(identifier, result /* !! */ , expressionListNode, this, this.interpreterContext, data);
                                                                                                                                                                                                                                                                                                                                                            this.startProfile();
                                                                                                                                                                                                                                                                                                                                                            break block321;
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                        this.stopProfile(node);
                                                                                                                                                                                                                                                                                                                                                        time = System.currentTimeMillis();
                                                                                                                                                                                                                                                                                                                                                        lastPartObj = node.getParameterObject("lastCompositePart");
                                                                                                                                                                                                                                                                                                                                                        isLastPartOfComposite = false;
                                                                                                                                                                                                                                                                                                                                                        if (lastPartObj != null) {
                                                                                                                                                                                                                                                                                                                                                            isLastPartOfComposite = (Boolean)lastPartObj;
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                        if (result /* !! */  != null && !(result /* !! */  instanceof Cube)) break block322;
                                                                                                                                                                                                                                                                                                                                                        while (!(parentNode == null || parentNode instanceof ASTSetSpecification || parentNode instanceof ASTInlineNamedSet || parentNode instanceof ASTSet || parentNode instanceof ASTExpression)) {
                                                                                                                                                                                                                                                                                                                                                            parentNode = parentNode.jjtGetParent();
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                        if (!(parentNode instanceof ASTInlineNamedSet) || ((SimpleNode)parentNode).getParameter("InlineIdentifier") == null) break block323;
                                                                                                                                                                                                                                                                                                                                                        result /* !! */  = identifier;
                                                                                                                                                                                                                                                                                                                                                        break block317;
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                    if (!(parentNode instanceof ASTExpression) || ((SimpleNode)parentNode).getParameter("InlineIdentifier") == null) break block324;
                                                                                                                                                                                                                                                                                                                                                    result /* !! */  = identifier;
                                                                                                                                                                                                                                                                                                                                                    break block317;
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                if (!(parentNode instanceof ASTSetSpecification)) break block325;
                                                                                                                                                                                                                                                                                                                                                result /* !! */  = cube != null && cube.getName().equalsIgnoreCase(identifier) ? cube : identifier;
                                                                                                                                                                                                                                                                                                                                                break block317;
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                            if (cube == null) {
                                                                                                                                                                                                                                                                                                                                                provider = this.interpreterContext.getProvider();
                                                                                                                                                                                                                                                                                                                                                try {
                                                                                                                                                                                                                                                                                                                                                    c = provider.getCube(identifier);
                                                                                                                                                                                                                                                                                                                                                    if (c == null) {
                                                                                                                                                                                                                                                                                                                                                        throw new InterpreterException("X01425", new String[]{identifier});
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                    c.initialize();
                                                                                                                                                                                                                                                                                                                                                    result /* !! */  = c;
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                catch (ProviderException e) {
                                                                                                                                                                                                                                                                                                                                                    throw new InterpreterException("X01425", new String[]{identifier}, e);
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                result /* !! */  = null;
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                            if (result /* !! */  == null && (result /* !! */  = cube.getDimension(identifier)) == null) {
                                                                                                                                                                                                                                                                                                                                                result /* !! */  = cube.getHierarchy(identifier);
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                            if (result /* !! */  != null) break block326;
                                                                                                                                                                                                                                                                                                                                            dList = cube.getDimensions();
                                                                                                                                                                                                                                                                                                                                            dims = dList.toArray(new IDimension[0]);
                                                                                                                                                                                                                                                                                                                                            break block327;
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                        if (!(result /* !! */  instanceof Tuple) && (!(result /* !! */  instanceof Tuple[]) || ((Tuple[])result /* !! */ ).length != 1)) break block328;
                                                                                                                                                                                                                                                                                                                                        if (!Caster.isDownCastable(result /* !! */ , IMember.class, this.interpreterContext)) {
                                                                                                                                                                                                                                                                                                                                            throw new InterpreterException("X01434", new String[]{identifier, "CMP_TYPEMEMBER"});
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                        member = (IMember)Caster.castDown(result /* !! */ , IMember.class, this.interpreterContext);
                                                                                                                                                                                                                                                                                                                                        if (!identifier.equals("UNIQUENAME")) break block329;
                                                                                                                                                                                                                                                                                                                                        s = this.interpreterContext.getContextSet();
                                                                                                                                                                                                                                                                                                                                        tv = new TupleValue(s.getTuple(0L), new Cell(-1L, member.getUniqueName()));
                                                                                                                                                                                                                                                                                                                                        result /* !! */  = new TupleValue[]{tv};
                                                                                                                                                                                                                                                                                                                                        break block317;
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                    if (!identifier.equals("NAME")) break block330;
                                                                                                                                                                                                                                                                                                                                    s = this.interpreterContext.getContextSet();
                                                                                                                                                                                                                                                                                                                                    tv = new TupleValue(s.getTuple(0L), new Cell(-1L, member.getName()));
                                                                                                                                                                                                                                                                                                                                    result /* !! */  = new TupleValue[]{tv};
                                                                                                                                                                                                                                                                                                                                    break block317;
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                if (!identifier.equals("CHILDREN")) break block331;
                                                                                                                                                                                                                                                                                                                                result /* !! */  = this.childrenFunction(member);
                                                                                                                                                                                                                                                                                                                                break block317;
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                            if (!identifier.equals("FIRSTCHILD")) break block332;
                                                                                                                                                                                                                                                                                                                            if (member instanceof NullMember) {
                                                                                                                                                                                                                                                                                                                                result /* !! */  = member;
                                                                                                                                                                                                                                                                                                                                break block317;
                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                children = member.getChildMembers();
                                                                                                                                                                                                                                                                                                                                hier = member.getHierarchy();
                                                                                                                                                                                                                                                                                                                                result /* !! */  = (children = MemberOperations.applySecurityToMembers(children, hier, this.interpreterContext)).length > 0 ? children[0] : new Set(new Tuple[0]);
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                            break block317;
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                        if (!identifier.equals("LASTCHILD")) break block333;
                                                                                                                                                                                                                                                                                                                        if (member instanceof NullMember) {
                                                                                                                                                                                                                                                                                                                            result /* !! */  = member;
                                                                                                                                                                                                                                                                                                                            break block317;
                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                            children = member.getChildMembers();
                                                                                                                                                                                                                                                                                                                            hier = member.getHierarchy();
                                                                                                                                                                                                                                                                                                                            result /* !! */  = (children = MemberOperations.applySecurityToMembers(children, hier, this.interpreterContext)).length > 0 ? children[children.length - 1] : new Set(new Tuple[0]);
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                        break block317;
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                    if (!identifier.equals("FIRSTSIBLING")) break block334;
                                                                                                                                                                                                                                                                                                                    result /* !! */  = member instanceof NullMember ? member : ((siblings = MemberOperations.getSiblingsOp(member, true, this.interpreterContext)) != null && siblings.length > 0 ? siblings[0] : NullMember.getNullMember(member));
                                                                                                                                                                                                                                                                                                                    break block317;
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                if (!identifier.equals("LASTSIBLING")) break block335;
                                                                                                                                                                                                                                                                                                                result /* !! */  = member instanceof NullMember ? member : ((siblings = MemberOperations.getSiblingsOp(member, true, this.interpreterContext)) != null && siblings.length > 0 ? siblings[siblings.length - 1] : NullMember.getNullMember(member));
                                                                                                                                                                                                                                                                                                                break block317;
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            if (identifier.equals("PREVMEMBER")) {
                                                                                                                                                                                                                                                                                                                result /* !! */  = MemberOperations.getPreviousMemberOp(member, false, this.interpreterContext);
                                                                                                                                                                                                                                                                                                                break block317;
                                                                                                                                                                                                                                                                                                            } else if (identifier.equals("NEXTMEMBER")) {
                                                                                                                                                                                                                                                                                                                result /* !! */  = MemberOperations.getNextMemberOp(member, false, this.interpreterContext);
                                                                                                                                                                                                                                                                                                                break block317;
                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                if (!identifier.equals("PARENT")) {
                                                                                                                                                                                                                                                                                                                    throw new InterpreterException("X01434", new String[]{identifier, "PARENT, FIRSTSIBLING,LASTSIBLING, PREVMEMBER, NEXTMEMBER"});
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                result /* !! */  = member instanceof NullMember ? member : MemberOperations.getParentOp(member.getParent(), false, this.interpreterContext);
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            break block317;
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                        if (!(result /* !! */  instanceof IDimension) && !(result /* !! */  instanceof IDimension[])) break block336;
                                                                                                                                                                                                                                                                                                        dimension = (IDimension)result /* !! */ ;
                                                                                                                                                                                                                                                                                                        try {
                                                                                                                                                                                                                                                                                                            if (identifier.equals("DEFAULTMEMBER")) {
                                                                                                                                                                                                                                                                                                                result /* !! */  = MemberOperations.getDefaultMemberOp(dimension, this.interpreterContext);
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            if (identifier.equals("PREVMEMBER")) {
                                                                                                                                                                                                                                                                                                                mOrArray = this.getCurrentMembers(dimension, data);
                                                                                                                                                                                                                                                                                                                if (mOrArray instanceof IMember) {
                                                                                                                                                                                                                                                                                                                    result /* !! */  = MemberOperations.getPreviousMemberOp((IMember)mOrArray, false, this.interpreterContext);
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                if (mOrArray == null) ** GOTO lbl1315
                                                                                                                                                                                                                                                                                                                mArray = mOrArray;
                                                                                                                                                                                                                                                                                                                break block318;
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            if (identifier.equals("CHILDREN")) {
                                                                                                                                                                                                                                                                                                                result /* !! */  = this.getCurrentMembers(dimension, data);
                                                                                                                                                                                                                                                                                                                result /* !! */  = this.childrenFunction(result /* !! */ );
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            if (identifier.equals("NEXTMEMBER")) {
                                                                                                                                                                                                                                                                                                                mOrArray = this.getCurrentMembers(dimension, data);
                                                                                                                                                                                                                                                                                                                if (mOrArray instanceof IMember) {
                                                                                                                                                                                                                                                                                                                    result /* !! */  = MemberOperations.getNextMemberOp((IMember)mOrArray, false, this.interpreterContext);
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                if (mOrArray == null) ** GOTO lbl1315
                                                                                                                                                                                                                                                                                                                mArray = mOrArray;
                                                                                                                                                                                                                                                                                                                for (j = 0; j < mArray.length; ++j) {
                                                                                                                                                                                                                                                                                                                    mArray[j] = MemberOperations.getNextMemberOp(mArray[j], false, this.interpreterContext);
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                result /* !! */  = new Set(Tuple.createTupleList(mArray));
                                                                                                                                                                                                                                                                                                                ((Set)result /* !! */ ).addCurrentMemberDimension(mArray[0].getDimension());
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            if (identifier.equals("CURRENTMEMBER")) {
                                                                                                                                                                                                                                                                                                                result /* !! */  = this.processFunctionCurrentMember(dimension, data);
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            if (identifier.equals("DIMENSION")) {
                                                                                                                                                                                                                                                                                                                result /* !! */  = dimension;
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            if (identifier.equals("HIERARCHY")) {
                                                                                                                                                                                                                                                                                                                result /* !! */  = ((IDimension)result /* !! */ ).getDefaultHierarchy();
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            if (identifier.equals("LEVEL")) {
                                                                                                                                                                                                                                                                                                                mOrArray = this.getCurrentMembers(dimension, data);
                                                                                                                                                                                                                                                                                                                if (mOrArray instanceof IMember) {
                                                                                                                                                                                                                                                                                                                    result /* !! */  = ((IMemberCubics)mOrArray).getLevel();
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                if (mOrArray == null) ** GOTO lbl1315
                                                                                                                                                                                                                                                                                                                mems = mOrArray;
                                                                                                                                                                                                                                                                                                                if (mems.length == 1) {
                                                                                                                                                                                                                                                                                                                    result /* !! */  = mems[0].getLevel();
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                if (mems.length == 0) {
                                                                                                                                                                                                                                                                                                                    result /* !! */  = ((IDimension)result /* !! */ ).getDefaultHierarchy().getLevel(0);
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                s = new Set(Tuple.createTupleList(mems));
                                                                                                                                                                                                                                                                                                                rs = new ResultSet(new Set[]{s}, new Set(new Tuple[0]));
                                                                                                                                                                                                                                                                                                                for (i = 0; i < mems.length; ++i) {
                                                                                                                                                                                                                                                                                                                    value = mems[i].getLevel();
                                                                                                                                                                                                                                                                                                                    if (value == null) continue;
                                                                                                                                                                                                                                                                                                                    rs.addCell(new Cell(i, value));
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                result /* !! */  = rs;
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            if (identifier.equals("LEVELS")) {
                                                                                                                                                                                                                                                                                                                hier = ((IDimension)result /* !! */ ).getDefaultHierarchy();
                                                                                                                                                                                                                                                                                                                levelsList = hier.getLevels();
                                                                                                                                                                                                                                                                                                                result /* !! */  = levelsList.toArray(new Level[0]);
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            if (identifier.equals("MEMBERS") || identifier.equals("ALLMEMBERS")) {
                                                                                                                                                                                                                                                                                                                result /* !! */  = this.getMembersOrAllMembers(identifier, dimension);
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            if (identifier.equals("SIBLINGS")) {
                                                                                                                                                                                                                                                                                                                mOrArray = this.getCurrentMembers(dimension, data);
                                                                                                                                                                                                                                                                                                                if (mOrArray instanceof IMember) {
                                                                                                                                                                                                                                                                                                                    siblings = ((IMemberCubics)mOrArray).getSiblings(true);
                                                                                                                                                                                                                                                                                                                    sets = new Set[]{new Set(Tuple.createTupleList(siblings))};
                                                                                                                                                                                                                                                                                                                    sets[0].addCurrentMemberDimension(((IMemberCubics)mOrArray).getDimension());
                                                                                                                                                                                                                                                                                                                    result /* !! */  = sets;
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                if (mOrArray == null) ** GOTO lbl1315
                                                                                                                                                                                                                                                                                                                mArray = mOrArray;
                                                                                                                                                                                                                                                                                                                sets = new Set[mArray.length];
                                                                                                                                                                                                                                                                                                                for (i = 0; i < mArray.length; ++i) {
                                                                                                                                                                                                                                                                                                                    m = mArray[i];
                                                                                                                                                                                                                                                                                                                    siblings = m.getSiblings(true);
                                                                                                                                                                                                                                                                                                                    sets[i] = new Set(Tuple.createTupleList(siblings));
                                                                                                                                                                                                                                                                                                                    sets[i].addCurrentMemberDimension(mArray[i].getDimension());
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                result /* !! */  = sets;
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            if (identifier.equals("DATAMEMBER")) {
                                                                                                                                                                                                                                                                                                                mOrArray = this.getCurrentMembers(dimension, data);
                                                                                                                                                                                                                                                                                                                if (mOrArray instanceof IMember) {
                                                                                                                                                                                                                                                                                                                    result /* !! */  = ((IMember)mOrArray).getDataMember();
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                if (mOrArray == null) ** GOTO lbl1315
                                                                                                                                                                                                                                                                                                                mArray = mOrArray;
                                                                                                                                                                                                                                                                                                                for (j = 0; j < mArray.length; ++j) {
                                                                                                                                                                                                                                                                                                                    mArray[j] = mArray[j].getDataMember();
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                result /* !! */  = mArray;
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            output = null;
                                                                                                                                                                                                                                                                                                            if (!delimited) {
                                                                                                                                                                                                                                                                                                                if (identifier.equals("UNIQUENAME")) {
                                                                                                                                                                                                                                                                                                                    output = dimension.getUniqueName();
                                                                                                                                                                                                                                                                                                                } else if (identifier.equals("NAME")) {
                                                                                                                                                                                                                                                                                                                    output = dimension.getName();
                                                                                                                                                                                                                                                                                                                } else if (identifier.equals("CAPTION")) {
                                                                                                                                                                                                                                                                                                                    output = dimension.getCaption();
                                                                                                                                                                                                                                                                                                                } else if (identifier.equals("DESCRIPTION")) {
                                                                                                                                                                                                                                                                                                                    output = dimension.getDescription();
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            hierarchy = dimension.getHierarchy(identifier);
                                                                                                                                                                                                                                                                                                            level = dimension.getLevel(identifier);
                                                                                                                                                                                                                                                                                                            if (hierarchy != null && level != null) {
                                                                                                                                                                                                                                                                                                                nodePos = node.getParent().getPositionOfChild(node);
                                                                                                                                                                                                                                                                                                                output = nodePos + 1 >= node.getParent().getNumberChildren() ? level : (dimension.getLevel(nextIdent = (nextIdentNode = (ASTMDXNode)parentNode.jjtGetChild(nodePos + 1).jjtGetChild(0).accept(this, data)).getText()) != null || dimension.getHierarchyCount() > 1 ? hierarchy : level);
                                                                                                                                                                                                                                                                                                            } else if (hierarchy != null) {
                                                                                                                                                                                                                                                                                                                output = hierarchy;
                                                                                                                                                                                                                                                                                                            } else if (level != null) {
                                                                                                                                                                                                                                                                                                                output = level;
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            if (output == null) {
                                                                                                                                                                                                                                                                                                                memberUniqueName = dimension.getUniqueName() + ".[" + identifier + "]";
                                                                                                                                                                                                                                                                                                                calculationEngine = this.interpreterContext.getCalculationEngine();
                                                                                                                                                                                                                                                                                                                output = calculationEngine.getCalculatedMember(memberUniqueName);
                                                                                                                                                                                                                                                                                                                if (output == null && (output = calculationEngine.findCalculatedMember(identifier)) != null) {
                                                                                                                                                                                                                                                                                                                    closebracketInd = output.toString().indexOf("]");
                                                                                                                                                                                                                                                                                                                    outputDimension = output.toString().substring(0, closebracketInd + 1);
                                                                                                                                                                                                                                                                                                                    if (!outputDimension.equals(dimension.getUniqueName())) {
                                                                                                                                                                                                                                                                                                                        output = null;
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                if (output == null && (output = this.interpreterContext.getSelfReferencedCalcMember(memberUniqueName)) == null) {
                                                                                                                                                                                                                                                                                                                    uniqueName = "[" + cube.getName() + "]." + memberUniqueName;
                                                                                                                                                                                                                                                                                                                    output = this.interpreterContext.getSelfReferencedCalcMember(uniqueName);
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            if (output == null && identifier.equals(powerCubeRootMemberName = dimension.getName() + " (Root)")) {
                                                                                                                                                                                                                                                                                                                output = dimension.getDefaultHierarchy();
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            if (output == null) {
                                                                                                                                                                                                                                                                                                                propertyName = null;
                                                                                                                                                                                                                                                                                                                if (identifier.equalsIgnoreCase("MEMBER_CAPTION")) {
                                                                                                                                                                                                                                                                                                                    propertyName = identifier;
                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                    for (i = 0; i < dimension.getHierarchyCount(); ++i) {
                                                                                                                                                                                                                                                                                                                        h = dimension.getHierarchy(i);
                                                                                                                                                                                                                                                                                                                        for (k = 0; k < h.getLevelCount(); ++k) {
                                                                                                                                                                                                                                                                                                                            l = (Level)h.getLevel(k);
                                                                                                                                                                                                                                                                                                                            if (l.getMemberProperty(identifier) == null) continue;
                                                                                                                                                                                                                                                                                                                            propertyName = identifier;
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                if (propertyName != null) {
                                                                                                                                                                                                                                                                                                                    output = new com.cognos.xqe.runtree.olap.mdx.metadata.Property(propertyName);
                                                                                                                                                                                                                                                                                                                    cjs = this.interpreterContext.getContextSet();
                                                                                                                                                                                                                                                                                                                    mems = cjs.getMembers(dimension);
                                                                                                                                                                                                                                                                                                                    s = new Set(Tuple.createTupleList(mems));
                                                                                                                                                                                                                                                                                                                    rs = new ResultSet(new Set[]{s}, new Set(new Tuple[0]));
                                                                                                                                                                                                                                                                                                                    for (i = 0; i < mems.length; ++i) {
                                                                                                                                                                                                                                                                                                                        value = mems[i].getProperty(propertyName);
                                                                                                                                                                                                                                                                                                                        if (value == null) continue;
                                                                                                                                                                                                                                                                                                                        rs.addCell(new Cell(i, value));
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                    output = rs;
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                if (output == null) {
                                                                                                                                                                                                                                                                                                                    output = this.processMemberFunction(identifier, dimension, data, isLastPartOfComposite);
                                                                                                                                                                                                                                                                                                                    if (output == null && result /* !! */  == null) {
                                                                                                                                                                                                                                                                                                                        output = this.interpreterContext.getCalculationEngine().findCalculatedMember(identifier);
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                    if (output == null && (output = ((Dimension)dimension).findMember(identifier)) != null && output instanceof IMember && isLastPartOfComposite) {
                                                                                                                                                                                                                                                                                                                        securedResult = MemberOperations.applySecurityToMember((IMember)output, this.interpreterContext);
                                                                                                                                                                                                                                                                                                                        output = securedResult == null ? NullMember.getNullMember((IMember)output) : securedResult;
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                    if (output == null) {
                                                                                                                                                                                                                                                                                                                        output = cube.getDimension(identifier);
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            result /* !! */  = output;
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                        catch (MetadataException e) {
                                                                                                                                                                                                                                                                                                            throw new InterpreterException("X01434", new String[]{identifier, "DEFAULTMEMBER, CHILDREN, CURRENTMEMBER, "}, e);
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    if (!(result /* !! */  instanceof IMetadata) || ((IMetadata)result /* !! */ ).getObjectType() != MetadataType.HIERARCHY) break block337;
                                                                                                                                                                                                                                                                                                    h = (Hierarchy)result /* !! */ ;
                                                                                                                                                                                                                                                                                                    if (!identifier.equals("UNIQUENAME")) break block338;
                                                                                                                                                                                                                                                                                                    s = this.interpreterContext.getContextSet();
                                                                                                                                                                                                                                                                                                    tv = new TupleValue(s.getTuple(0L), new Cell(-1L, h.getUniqueName()));
                                                                                                                                                                                                                                                                                                    result /* !! */  = new TupleValue[]{tv};
                                                                                                                                                                                                                                                                                                    break block319;
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                if (!identifier.equals("CHILDREN")) break block339;
                                                                                                                                                                                                                                                                                                result /* !! */  = this.getCurrentMembers(h, data);
                                                                                                                                                                                                                                                                                                result /* !! */  = this.childrenFunction(result /* !! */ );
                                                                                                                                                                                                                                                                                                break block319;
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                            if (!identifier.equals("DATAMEMBER")) break block340;
                                                                                                                                                                                                                                                                                            mOrArray = this.getCurrentMembers(h, data);
                                                                                                                                                                                                                                                                                            if (mOrArray instanceof IMember) {
                                                                                                                                                                                                                                                                                                result /* !! */  = ((IMember)mOrArray).getDataMember();
                                                                                                                                                                                                                                                                                                break block319;
                                                                                                                                                                                                                                                                                            } else if (mOrArray != null) {
                                                                                                                                                                                                                                                                                                mArray = mOrArray;
                                                                                                                                                                                                                                                                                                for (j = 0; j < mArray.length; ++j) {
                                                                                                                                                                                                                                                                                                    mArray[j] = mArray[j].getDataMember();
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                result /* !! */  = mArray;
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                            break block319;
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                        if (!identifier.equals("DIMENSION")) break block341;
                                                                                                                                                                                                                                                                                        result /* !! */  = h.getDimension();
                                                                                                                                                                                                                                                                                        break block319;
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                    if (!identifier.equals("HIERARCHY")) break block342;
                                                                                                                                                                                                                                                                                    result /* !! */  = h;
                                                                                                                                                                                                                                                                                    break block319;
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                if (!identifier.equals("NAME")) break block343;
                                                                                                                                                                                                                                                                                s = this.interpreterContext.getContextSet();
                                                                                                                                                                                                                                                                                tv = new TupleValue(s.getTuple(0L), new Cell(-1L, h.getName()));
                                                                                                                                                                                                                                                                                result /* !! */  = new TupleValue[]{tv};
                                                                                                                                                                                                                                                                                break block319;
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                            if (!identifier.equals("CAPTION")) break block344;
                                                                                                                                                                                                                                                                            s = this.interpreterContext.getContextSet();
                                                                                                                                                                                                                                                                            tv = new TupleValue(s.getTuple(0L), new Cell(-1L, h.getCaption()));
                                                                                                                                                                                                                                                                            result /* !! */  = new TupleValue[]{tv};
                                                                                                                                                                                                                                                                            break block319;
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        if (!identifier.equals("DESCRIPTION")) break block345;
                                                                                                                                                                                                                                                                        s = this.interpreterContext.getContextSet();
                                                                                                                                                                                                                                                                        tv = new TupleValue(s.getTuple(0L), new Cell(-1L, h.getDescription()));
                                                                                                                                                                                                                                                                        result /* !! */  = new TupleValue[]{tv};
                                                                                                                                                                                                                                                                        break block319;
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    if (!identifier.equals("CURRENTMEMBER")) break block346;
                                                                                                                                                                                                                                                                    result /* !! */  = this.getCurrentMembers(h, data);
                                                                                                                                                                                                                                                                    break block319;
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                if (identifier.equals("DEFAULTMEMBER")) {
                                                                                                                                                                                                                                                                    try {
                                                                                                                                                                                                                                                                        result /* !! */  = MemberOperations.getDefaultMemberOp(h, this.interpreterContext);
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    catch (MetadataException e) {
                                                                                                                                                                                                                                                                        throw new InterpreterException("X01408", new String[]{h.getDimension().getUniqueName()}, e);
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                if (!identifier.equals("MEMBERS") && !identifier.equals("ALLMEMBERS")) break block347;
                                                                                                                                                                                                                                                                result /* !! */  = this.getMembersOrAllMembers(identifier, h);
                                                                                                                                                                                                                                                                break block319;
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                            if (!identifier.equals("LEVELS")) break block348;
                                                                                                                                                                                                                                                            levelsList = ((IHierarchy)result /* !! */ ).getLevels();
                                                                                                                                                                                                                                                            result /* !! */  = levelsList.toArray(new Level[0]);
                                                                                                                                                                                                                                                            break block319;
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        if (!identifier.equals("LEVEL")) break block349;
                                                                                                                                                                                                                                                        mOrArray = this.getCurrentMembers(h, data);
                                                                                                                                                                                                                                                        if (!(mOrArray instanceof IMember)) break block350;
                                                                                                                                                                                                                                                        result /* !! */  = ((IMemberCubics)mOrArray).getLevel();
                                                                                                                                                                                                                                                        break block319;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    if (mOrArray == null) break block319;
                                                                                                                                                                                                                                                    mems = mOrArray;
                                                                                                                                                                                                                                                    if (mems.length == 1) {
                                                                                                                                                                                                                                                        result /* !! */  = mems[0].getLevel();
                                                                                                                                                                                                                                                        break block319;
                                                                                                                                                                                                                                                    } else if (mems.length == 0) {
                                                                                                                                                                                                                                                        result /* !! */  = ((IHierarchy)result /* !! */ ).getLevel(0);
                                                                                                                                                                                                                                                        break block319;
                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                        s = new Set(Tuple.createTupleList(mems));
                                                                                                                                                                                                                                                        rs = new ResultSet(new Set[]{s}, new Set(new Tuple[0]));
                                                                                                                                                                                                                                                        for (i = 0; i < mems.length; ++i) {
                                                                                                                                                                                                                                                            value = mems[i].getLevel();
                                                                                                                                                                                                                                                            if (value == null) continue;
                                                                                                                                                                                                                                                            rs.addCell(new Cell(i, value));
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        result /* !! */  = rs;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block319;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                result /* !! */  = h.getLevel(identifier);
                                                                                                                                                                                                                                                if (result /* !! */  == null) {
                                                                                                                                                                                                                                                    try {
                                                                                                                                                                                                                                                        result /* !! */  = ((Level)h.getLevel(0)).getMember(identifier);
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    catch (MetadataException e) {
                                                                                                                                                                                                                                                        throw new InterpreterException("X01434", new String[]{identifier, "CMP_TYPEMEMBER"}, e);
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                if (result /* !! */  == null) {
                                                                                                                                                                                                                                                    memberUniqueName = h.getUniqueName() + ".[" + identifier + "]";
                                                                                                                                                                                                                                                    calculationEngine = this.interpreterContext.getCalculationEngine();
                                                                                                                                                                                                                                                    result /* !! */  = calculationEngine.getCalculatedMember(memberUniqueName);
                                                                                                                                                                                                                                                    if (result /* !! */  == null) {
                                                                                                                                                                                                                                                        memberUniqueName = "[" + h.getName() + "].[" + identifier + "]";
                                                                                                                                                                                                                                                        result /* !! */  = calculationEngine.getCalculatedMember(memberUniqueName);
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (result /* !! */  == null) {
                                                                                                                                                                                                                                                try {
                                                                                                                                                                                                                                                    result /* !! */  = h.findMember(identifier);
                                                                                                                                                                                                                                                    if (result /* !! */  != null && !(result /* !! */  instanceof IMember)) {
                                                                                                                                                                                                                                                        // empty if block
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                catch (MetadataException e) {
                                                                                                                                                                                                                                                    throw new InterpreterException("X01434", new String[]{identifier, "CMP_TYPEMEMBER"}, e);
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (result /* !! */  == null) {
                                                                                                                                                                                                                                                try {
                                                                                                                                                                                                                                                    result /* !! */  = ((Level)h.getLevel(0)).getMember(identifier);
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                catch (MetadataException e) {
                                                                                                                                                                                                                                                    throw new InterpreterException("X01434", new String[]{identifier, "CMP_TYPELEVEL"}, e);
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (result /* !! */  == null) {
                                                                                                                                                                                                                                                result /* !! */  = h.getLevel(identifier);
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (result /* !! */  == null) {
                                                                                                                                                                                                                                                memberUniqueName = h.getUniqueName() + ".[" + identifier + "]";
                                                                                                                                                                                                                                                calculationEngine = this.interpreterContext.getCalculationEngine();
                                                                                                                                                                                                                                                result /* !! */  = calculationEngine.getCalculatedMember(memberUniqueName);
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (result /* !! */  == null) {
                                                                                                                                                                                                                                                result /* !! */  = this.processMemberFunction(identifier, h, data, isLastPartOfComposite);
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (result /* !! */  == null) {
                                                                                                                                                                                                                                                try {
                                                                                                                                                                                                                                                    result /* !! */  = h.findMember(identifier);
                                                                                                                                                                                                                                                    if (result /* !! */  != null && !(result /* !! */  instanceof IMember)) {
                                                                                                                                                                                                                                                        // empty if block
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                catch (MetadataException e) {
                                                                                                                                                                                                                                                    throw new InterpreterException("X01433", new String[]{identifier, "CMP_TYPEMEMBER"}, e);
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (result /* !! */  != null && result /* !! */  instanceof IMember && isLastPartOfComposite && MemberOperations.applySecurityToMember((IMember)result /* !! */ , this.interpreterContext) == null) {
                                                                                                                                                                                                                                                result /* !! */  = NullMember.getNullMember((IMember)result /* !! */ );
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            break block317;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        if (!(result /* !! */  instanceof Level) && !(result /* !! */  instanceof Level[])) break block351;
                                                                                                                                                                                                                                        lArray = result /* !! */  instanceof Level != false ? new Level[]{(Level)result /* !! */ } : (Level[])result /* !! */ ;
                                                                                                                                                                                                                                        if (identifier.equals("COUNT")) {
                                                                                                                                                                                                                                            if (result /* !! */  instanceof Level[]) {
                                                                                                                                                                                                                                                return new Integer(lArray.length);
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            throw new InterpreterException("X01434", new String[]{identifier, "CMP_TYPESET, CMP_TYPETUPLE"});
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        if (lArray.length > 1) {
                                                                                                                                                                                                                                            throw new InterpreterException("X01490", new String[]{"", identifier, "CMP_TYPELEVEL"});
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        if (identifier.equals("UNIQUENAME")) {
                                                                                                                                                                                                                                            tvs = new TupleValue[lArray.length];
                                                                                                                                                                                                                                            s = this.interpreterContext.getContextSet();
                                                                                                                                                                                                                                            for (i = 0; i < tvs.length; ++i) {
                                                                                                                                                                                                                                                tvs[i] = new TupleValue(s.getTuple(0L), new Cell(-1L, lArray[i].getUniqueName()));
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            result /* !! */  = tvs;
                                                                                                                                                                                                                                        } else if (identifier.equals("DIMENSION")) {
                                                                                                                                                                                                                                            hs = new HashSet<IDimension>();
                                                                                                                                                                                                                                            for (i = 0; i < lArray.length; ++i) {
                                                                                                                                                                                                                                                hs.add(lArray[i].getDimension());
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (hs.size() > 1) {
                                                                                                                                                                                                                                                throw new InterpreterException("X01434", new String[]{"DIMENSION", "<= 1"});
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            result /* !! */  = hs.iterator().next();
                                                                                                                                                                                                                                        } else if (identifier.equals("HIERARCHY")) {
                                                                                                                                                                                                                                            hs = new HashSet<IHierarchy>();
                                                                                                                                                                                                                                            for (i = 0; i < lArray.length; ++i) {
                                                                                                                                                                                                                                                hs.add(lArray[i].getHierarchy());
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (hs.size() > 1) {
                                                                                                                                                                                                                                                throw new InterpreterException("X01434", new String[]{"HIERARCHY", "<= 1"});
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            result /* !! */  = hs.iterator().next();
                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                            if (identifier.equals("ORDINAL")) {
                                                                                                                                                                                                                                                if (lArray.length <= 1) return new Double(lArray[0].getIndex());
                                                                                                                                                                                                                                                throw new InterpreterException("X01434", new String[]{"ORDINAL", "<=1"});
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (identifier.equals("NAME") || identifier.equals("CAPTION") || identifier.equals("DESCRIPTION")) {
                                                                                                                                                                                                                                                tvs = new TupleValue[lArray.length];
                                                                                                                                                                                                                                                s = this.interpreterContext.getContextSet();
                                                                                                                                                                                                                                                for (i = 0; i < tvs.length; ++i) {
                                                                                                                                                                                                                                                    tvs[i] = new TupleValue(s.getTuple(0L), new Cell(0L, lArray[i].getName()));
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                result /* !! */  = tvs;
                                                                                                                                                                                                                                            } else if (identifier.equals("MEMBERS") || identifier.equals("ALLMEMBERS")) {
                                                                                                                                                                                                                                                result /* !! */  = this.getMembersOrAllMembers(identifier, lArray[0]);
                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                l = lArray[0];
                                                                                                                                                                                                                                                try {
                                                                                                                                                                                                                                                    result /* !! */  = l.getMember(identifier);
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                catch (MetadataException e) {
                                                                                                                                                                                                                                                    throw new InterpreterException("X01427", new String[]{identifier}, e);
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        if (result /* !! */  != null && result /* !! */  instanceof IMember && isLastPartOfComposite && MemberOperations.applySecurityToMember((IMember)result /* !! */ , this.interpreterContext) == null) {
                                                                                                                                                                                                                                            result /* !! */  = NullMember.getNullMember((IMember)result /* !! */ );
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        break block317;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    if (!(result /* !! */  instanceof Set[]) && !(result /* !! */  instanceof NamedSet) && (!(result /* !! */  instanceof Set) || ((Set)result /* !! */ ).isCurrentMemberSet())) break block352;
                                                                                                                                                                                                                                    if (!identifier.equals("COUNT")) {
                                                                                                                                                                                                                                        throw new InterpreterException("X01434", new String[]{identifier, "CMP_TYPESET"});
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    if (!(result /* !! */  instanceof Set[])) break block353;
                                                                                                                                                                                                                                    if (((Set[])result /* !! */ ).length != 1) break block354;
                                                                                                                                                                                                                                    result /* !! */  = new Integer((int)((Set[])result /* !! */ )[0].size());
                                                                                                                                                                                                                                    break block317;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                if (((Set[])result /* !! */ ).length == 0) {
                                                                                                                                                                                                                                    result /* !! */  = new Integer(0);
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                break block317;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            if (result /* !! */  instanceof NamedSet) {
                                                                                                                                                                                                                                sets = ((NamedSet)result /* !! */ ).getSet(this.interpreterContext);
                                                                                                                                                                                                                                if (sets.length != 1) {
                                                                                                                                                                                                                                    throw new InterpreterException("X01434", new String[]{"COUNT", "CMP_TYPENAMEDSET"});
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                result /* !! */  = new Integer((int)sets[0].size());
                                                                                                                                                                                                                                break block317;
                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                if (!(result /* !! */  instanceof Set)) {
                                                                                                                                                                                                                                    throw new InterpreterException("X01434", new String[]{"COUNT", "CMP_TYPESET, CMP_TYPENAMEDSET"});
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                result /* !! */  = new Integer((int)((Set)result /* !! */ ).size());
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            break block317;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        if (!(result /* !! */  instanceof IMember) && !(result /* !! */  instanceof IMember[]) && (!(result /* !! */  instanceof Set) || !((Set)result /* !! */ ).isCurrentMemberSet())) break block355;
                                                                                                                                                                                                                        if (result /* !! */  instanceof IMember) {
                                                                                                                                                                                                                            mArray = new IMember[]{(IMember)result /* !! */ };
                                                                                                                                                                                                                        } else if (result /* !! */  instanceof IMember[]) {
                                                                                                                                                                                                                            mArray = result /* !! */ ;
                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                            setDims = ((Set)result /* !! */ ).getDimensions();
                                                                                                                                                                                                                            mArray = ((Set)result /* !! */ ).getMembersRetainDuplicates(setDims[0]);
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        if (!identifier.equals("CHILDREN")) break block356;
                                                                                                                                                                                                                        result /* !! */  = this.childrenFunction(result /* !! */ );
                                                                                                                                                                                                                        break block317;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    if (!identifier.equals("UNIQUENAME") && !identifier.equals("NAME") && !identifier.equals("CAPTION") && !identifier.equals("DESCRIPTION")) break block357;
                                                                                                                                                                                                                    if (result /* !! */  instanceof Set) {
                                                                                                                                                                                                                        s = (Set)result /* !! */ ;
                                                                                                                                                                                                                        rs = new ResultSet(new Set[]{s}, new Set(new Tuple[0]));
                                                                                                                                                                                                                        i = 0;
                                                                                                                                                                                                                        while ((long)i < s.size()) {
                                                                                                                                                                                                                            value = this.processMemberIdentifierPart(s.getTuple(i).getMember(0), identifier, isLastPartOfComposite);
                                                                                                                                                                                                                            if (value != NullObject.instance()) {
                                                                                                                                                                                                                                rs.addCell(new Cell(i, value));
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            ++i;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        rs.changeContextCMD(this.interpreterContext.getContextSet(), (Dimension[])s.getDimensions());
                                                                                                                                                                                                                        result /* !! */  = rs;
                                                                                                                                                                                                                        break block317;
                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                        s = new Set(Tuple.createTupleList(mArray));
                                                                                                                                                                                                                        rs = new ResultSet(new Set[]{s}, new Set(new Tuple[0]));
                                                                                                                                                                                                                        for (i = 0; i < mArray.length; ++i) {
                                                                                                                                                                                                                            value = this.processMemberIdentifierPart(mArray[i], identifier, isLastPartOfComposite);
                                                                                                                                                                                                                            if (value == NullObject.instance()) continue;
                                                                                                                                                                                                                            rs.addCell(new Cell(i, value));
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        rs.changeContextCMD(this.interpreterContext.getContextSet(), (Dimension[])s.getDimensions());
                                                                                                                                                                                                                        result /* !! */  = rs;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    break block317;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                if (!identifier.equals("VALUE")) break block358;
                                                                                                                                                                                                                s = new Set(Tuple.createTupleList(mArray));
                                                                                                                                                                                                                result /* !! */  = this.setToResultSet(s);
                                                                                                                                                                                                                break block317;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            if (!identifier.equals("LEVEL")) break block359;
                                                                                                                                                                                                            if (mArray.length != 1) break block360;
                                                                                                                                                                                                            if (mArray[0] instanceof NullMember) {
                                                                                                                                                                                                                throw new InterpreterException("X01498", new String[]{"LEVEL"});
                                                                                                                                                                                                            }
                                                                                                                                                                                                            result /* !! */  = mArray[0].getLevel();
                                                                                                                                                                                                            break block317;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        s = new Set(Tuple.createTupleList(mArray));
                                                                                                                                                                                                        rs = new ResultSet(new Set[]{s}, new Set(new Tuple[0]));
                                                                                                                                                                                                        break block361;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    if (!identifier.equals("HIERARCHY")) break block362;
                                                                                                                                                                                                    s = new Set(Tuple.createTupleList(mArray));
                                                                                                                                                                                                    rs = new ResultSet(new Set[]{s}, new Set(new Tuple[0]));
                                                                                                                                                                                                    break block363;
                                                                                                                                                                                                }
                                                                                                                                                                                                if (!identifier.equals("DIMENSION")) break block364;
                                                                                                                                                                                                tuples = new Tuple[mArray.length];
                                                                                                                                                                                                break block365;
                                                                                                                                                                                            }
                                                                                                                                                                                            if (!identifier.equals("SIBLINGS")) break block366;
                                                                                                                                                                                            sets = new Set[mArray.length];
                                                                                                                                                                                            break block367;
                                                                                                                                                                                        }
                                                                                                                                                                                        if (!identifier.equals("ALLMEMBERS")) break block368;
                                                                                                                                                                                        resultSets = new Set[mArray.length];
                                                                                                                                                                                        break block369;
                                                                                                                                                                                    }
                                                                                                                                                                                    if (!identifier.equals("DATAMEMBER")) break block370;
                                                                                                                                                                                    if (result /* !! */  instanceof IMember) {
                                                                                                                                                                                        result /* !! */  = ((IMember)result /* !! */ ).getDataMember();
                                                                                                                                                                                        break block317;
                                                                                                                                                                                    } else {
                                                                                                                                                                                        resultMembers = new IMember[mArray.length];
                                                                                                                                                                                        for (j = 0; j < mArray.length; ++j) {
                                                                                                                                                                                            member = mArray[j];
                                                                                                                                                                                            resultMembers[j] = member.getDataMember();
                                                                                                                                                                                        }
                                                                                                                                                                                        result /* !! */  = resultMembers;
                                                                                                                                                                                    }
                                                                                                                                                                                    break block317;
                                                                                                                                                                                }
                                                                                                                                                                                if (identifier.equals("ORDINAL")) {
                                                                                                                                                                                    throw new InterpreterException("X01434", new String[]{identifier, "CMP_TYPELEVEL"});
                                                                                                                                                                                }
                                                                                                                                                                                for (j = 0; j < mArray.length; ++j) {
                                                                                                                                                                                    member = mArray[j];
                                                                                                                                                                                    mArray[j] = (IMember)this.processMemberIdentifierPart(member, identifier, isLastPartOfComposite);
                                                                                                                                                                                }
                                                                                                                                                                                if (result /* !! */  instanceof IMember) {
                                                                                                                                                                                    result /* !! */  = mArray[0];
                                                                                                                                                                                    break block317;
                                                                                                                                                                                } else if (result /* !! */  instanceof IMember[]) {
                                                                                                                                                                                    result /* !! */  = mArray;
                                                                                                                                                                                    break block317;
                                                                                                                                                                                } else {
                                                                                                                                                                                    s = new Set(Tuple.createTupleList(mArray));
                                                                                                                                                                                    s.addCurrentMemberDimension(mArray[0].getDimension());
                                                                                                                                                                                    result /* !! */  = s;
                                                                                                                                                                                }
                                                                                                                                                                                break block317;
                                                                                                                                                                            }
                                                                                                                                                                            if (!(result /* !! */  instanceof ResultSet)) break block371;
                                                                                                                                                                            Interpreter.logger.log("RESULT SET!!");
                                                                                                                                                                            if (!identifier.equals("ORDINAL")) break block372;
                                                                                                                                                                            rs = (ResultSet)result /* !! */ ;
                                                                                                                                                                            it = rs.valueIterator();
                                                                                                                                                                            while (it.hasNext()) {
                                                                                                                                                                                l = (Level)it.next();
                                                                                                                                                                                if (l == null) continue;
                                                                                                                                                                                it.setValue(new Double(l.getIndex()));
                                                                                                                                                                            }
                                                                                                                                                                            result /* !! */  = rs;
                                                                                                                                                                            break block317;
                                                                                                                                                                        }
                                                                                                                                                                        if (!identifier.equals("NAME")) break block373;
                                                                                                                                                                        rs = (ResultSet)result /* !! */ ;
                                                                                                                                                                        it = rs.valueIterator();
                                                                                                                                                                        while (it.hasNext()) {
                                                                                                                                                                            value = it.next();
                                                                                                                                                                            if (!(value instanceof IMetadata)) {
                                                                                                                                                                                throw new InterpreterException("X01434", new String[]{identifier, "CMP_TYPEDIMENSION, CMP_TYPEHIERARCHY, CMP_TYPELEVEL, CMP_TYPEMEMBER"});
                                                                                                                                                                            }
                                                                                                                                                                            md = (IMetadata)value;
                                                                                                                                                                            it.setValue(md.getName());
                                                                                                                                                                        }
                                                                                                                                                                        result /* !! */  = rs;
                                                                                                                                                                        break block317;
                                                                                                                                                                    }
                                                                                                                                                                    if (!identifier.equals("UNIQUENAME")) break block374;
                                                                                                                                                                    rs = (ResultSet)result /* !! */ ;
                                                                                                                                                                    it = rs.valueIterator();
                                                                                                                                                                    while (it.hasNext()) {
                                                                                                                                                                        value = it.next();
                                                                                                                                                                        if (!(value instanceof IMetadata)) {
                                                                                                                                                                            throw new InterpreterException("X01434", new String[]{identifier, "CMP_TYPEDIMENSION, CMP_TYPEHIERARCHY, CMP_TYPELEVEL, CMP_TYPEMEMBER"});
                                                                                                                                                                        }
                                                                                                                                                                        md = (IMetadata)value;
                                                                                                                                                                        it.setValue(md.getUniqueName());
                                                                                                                                                                    }
                                                                                                                                                                    result /* !! */  = rs;
                                                                                                                                                                    break block317;
                                                                                                                                                                }
                                                                                                                                                                if (!identifier.equals("DEFAULTMEMBER")) break block375;
                                                                                                                                                                al = new ArrayList<IMember>();
                                                                                                                                                                rs = (ResultSet)result /* !! */ ;
                                                                                                                                                                it = rs.valueIterator();
                                                                                                                                                                hierInfo = new HierarchyInfo();
                                                                                                                                                                break block376;
                                                                                                                                                            }
                                                                                                                                                            if (!identifier.equals("CHILDREN")) break block377;
                                                                                                                                                            al = new ArrayList<IMember>();
                                                                                                                                                            rs = (ResultSet)result /* !! */ ;
                                                                                                                                                            it = rs.valueIterator();
                                                                                                                                                            hierInfo = new HierarchyInfo();
                                                                                                                                                            break block378;
                                                                                                                                                        }
                                                                                                                                                        if (!identifier.equals("FIRSTSIBLING")) break block379;
                                                                                                                                                        al = new ArrayList<IMember>();
                                                                                                                                                        rs = (ResultSet)result /* !! */ ;
                                                                                                                                                        it = rs.valueIterator();
                                                                                                                                                        hierInfo = new HierarchyInfo();
                                                                                                                                                        break block380;
                                                                                                                                                    }
                                                                                                                                                    if (!identifier.equals("LASTSIBLING")) break block381;
                                                                                                                                                    al = new ArrayList<IMember>();
                                                                                                                                                    rs = (ResultSet)result /* !! */ ;
                                                                                                                                                    it = rs.valueIterator();
                                                                                                                                                    hierInfo = new HierarchyInfo();
                                                                                                                                                    break block382;
                                                                                                                                                }
                                                                                                                                                if (!identifier.equals("LASTCHILD")) break block383;
                                                                                                                                                al = new ArrayList<IMember>();
                                                                                                                                                rs = (ResultSet)result /* !! */ ;
                                                                                                                                                it = rs.valueIterator();
                                                                                                                                                hierInfo = new HierarchyInfo();
                                                                                                                                                break block384;
                                                                                                                                            }
                                                                                                                                            if (!identifier.equals("FIRSTCHILD")) break block385;
                                                                                                                                            al = new ArrayList<IMember>();
                                                                                                                                            rs = (ResultSet)result /* !! */ ;
                                                                                                                                            it = rs.valueIterator();
                                                                                                                                            hierInfo = new HierarchyInfo();
                                                                                                                                            break block386;
                                                                                                                                        }
                                                                                                                                        if (!identifier.equals("MEMBERS")) break block387;
                                                                                                                                        al = new ArrayList<IMember>();
                                                                                                                                        rs = (ResultSet)result /* !! */ ;
                                                                                                                                        it = rs.valueIterator();
                                                                                                                                        hierInfo = new HierarchyInfo();
                                                                                                                                        break block388;
                                                                                                                                    }
                                                                                                                                    if (!identifier.equals("LEVELS")) break block389;
                                                                                                                                    rs = (ResultSet)result /* !! */ ;
                                                                                                                                    it = rs.valueIterator();
                                                                                                                                    while (it.hasNext()) {
                                                                                                                                        value = it.next();
                                                                                                                                        if (!(value instanceof IHierarchy)) {
                                                                                                                                            throw new InterpreterException("X01434", new String[]{"LEVELS", "CMP_TYPEHIERARCHY"});
                                                                                                                                        }
                                                                                                                                        hier = (IHierarchy)value;
                                                                                                                                        it.setValue(hier.getLevels());
                                                                                                                                    }
                                                                                                                                    result /* !! */  = rs;
                                                                                                                                    break block317;
                                                                                                                                }
                                                                                                                                if (!identifier.equals("COUNT")) break block390;
                                                                                                                                rs = (ResultSet)result /* !! */ ;
                                                                                                                                it = rs.valueIterator();
                                                                                                                                while (it.hasNext()) {
                                                                                                                                    value = it.next();
                                                                                                                                    if (!(value instanceof List)) {
                                                                                                                                        throw new InterpreterException("X01434", new String[]{"COUNT", "CMP_TYPESET, CMP_TYPETUPLE"});
                                                                                                                                    }
                                                                                                                                    list = (List)value;
                                                                                                                                    it.setValue(list.size());
                                                                                                                                }
                                                                                                                                result /* !! */  = rs;
                                                                                                                                break block317;
                                                                                                                            }
                                                                                                                            if (!identifier.equals("ALLMEMBERS")) break block391;
                                                                                                                            rs = (ResultSet)result /* !! */ ;
                                                                                                                            al = new ArrayList<IMember>();
                                                                                                                            it = rs.valueIterator();
                                                                                                                            hierInfo = new HierarchyInfo();
                                                                                                                            while (it.hasNext()) {
                                                                                                                                value = it.next();
                                                                                                                                if (!(value instanceof IHierarchy)) continue;
                                                                                                                                hier = (IHierarchy)value;
                                                                                                                                al.addAll(Arrays.asList(hier.getMembers()));
                                                                                                                                hierInfo.track(hier);
                                                                                                                            }
                                                                                                                            result /* !! */  = al.toArray(new IMember[0]);
                                                                                                                            result /* !! */  = MemberOperations.applySecurityToMembers(result /* !! */ , hierInfo.getHierarchy(), this.interpreterContext);
                                                                                                                            break block317;
                                                                                                                        }
                                                                                                                        if (!identifier.equals("HIERARCHY")) break block392;
                                                                                                                        rs = (ResultSet)result /* !! */ ;
                                                                                                                        it = rs.valueIterator();
                                                                                                                        break block393;
                                                                                                                    }
                                                                                                                    if (!identifier.equals("DESCRIPTION")) break block394;
                                                                                                                    rs = (ResultSet)result /* !! */ ;
                                                                                                                    it = rs.valueIterator();
                                                                                                                    break block395;
                                                                                                                }
                                                                                                                if (!identifier.equals("CURRENTMEMBER")) break block396;
                                                                                                                rs = (ResultSet)result /* !! */ ;
                                                                                                                it = rs.valueIterator();
                                                                                                                while (it.hasNext()) {
                                                                                                                    cellValue = it.next();
                                                                                                                    if (!(cellValue instanceof IDimension)) continue;
                                                                                                                    dimension = (IDimension)cellValue;
                                                                                                                    it.setValue(this.processFunctionCurrentMember(dimension, data));
                                                                                                                    it.setValue(TextValue.ERROR_VALUE);
                                                                                                                }
                                                                                                                break block317;
                                                                                                            }
                                                                                                            if (!identifier.equals("LEVEL")) {
                                                                                                                throw new InterpreterException("X01434", new String[]{identifier, "ORDINAL,NAME,UNIQUENAME,MEMBERS, ..."});
                                                                                                            }
                                                                                                            rs = (ResultSet)result /* !! */ ;
                                                                                                            it = rs.valueIterator();
                                                                                                            break block397;
                                                                                                        }
                                                                                                        if (result /* !! */  != null) {
                                                                                                            throw new InterpreterException("X01427", new String[]{result /* !! */ .toString()});
                                                                                                        }
                                                                                                        throw new InterpreterException("X01427", new String[]{"null"});
                                                                                                    }
                                                                                                    for (i = 0; i < dims.length && result /* !! */  == null; ++i) {
                                                                                                        dim = dims[i];
                                                                                                        hCount = dim.getHierarchyCount();
                                                                                                        for (j = 0; j < hCount && result /* !! */  == null; ++j) {
                                                                                                            h = dim.getHierarchy(j);
                                                                                                            l = h.getLevel(identifier);
                                                                                                            result /* !! */  = l;
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                                if (result /* !! */  == null) {
                                                                                                    calculationEngine = this.interpreterContext.getCalculationEngine();
                                                                                                    result /* !! */  = calculationEngine.getNamedSet(identifier);
                                                                                                    if (result /* !! */  == null) {
                                                                                                        setName = UniqueNameGenerator.createUniqueName(identifier);
                                                                                                        result /* !! */  = calculationEngine.getNamedSet(setName);
                                                                                                    }
                                                                                                    if (result /* !! */  == null && cube != null) {
                                                                                                        setName = UniqueNameGenerator.createUniqueName(cube.getName(), identifier);
                                                                                                        result /* !! */  = calculationEngine.getNamedSet(setName);
                                                                                                    }
                                                                                                    unqualifiedMemberNames = Environment.getEnvironmentVariable("unqualifiedMemberNames");
                                                                                                    unqualifiedMemberNames = "true";
                                                                                                    if ("".equals(unqualifiedMemberNames)) {
                                                                                                        unqualifiedMemberNames = Environment.getEnvironmentVariable("DigitalAspects/EnableUnqualifiedMemberNameSupport");
                                                                                                    }
                                                                                                    if (result /* !! */  == null && unqualifiedMemberNames != null && "true".equalsIgnoreCase(unqualifiedMemberNames)) {
                                                                                                        result /* !! */  = calculationEngine.findCalculatedMember(identifier);
                                                                                                        if (result /* !! */  == null && cube.getName().equals(identifier)) {
                                                                                                            result /* !! */  = cube;
                                                                                                        }
                                                                                                        if (result /* !! */  == null) {
                                                                                                            try {
                                                                                                                result /* !! */  = ((Cube)cube).findMember(identifier);
                                                                                                            }
                                                                                                            catch (Exception e) {
                                                                                                                throw new InterpreterException("X01405", new String[]{identifier}, e);
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                    if (result /* !! */  != null && result /* !! */  instanceof IMember && isLastPartOfComposite && MemberOperations.applySecurityToMember((IMember)result /* !! */ , this.interpreterContext) == null) {
                                                                                                        result /* !! */  = NullMember.getNullMember((IMember)result /* !! */ );
                                                                                                    }
                                                                                                    if (result /* !! */  == null) {
                                                                                                        throw new InterpreterException("X01405", new String[]{identifier});
                                                                                                    }
                                                                                                }
                                                                                                break block317;
                                                                                            }
                                                                                            for (j = 0; j < mArray.length; ++j) {
                                                                                                prevMember = MemberOperations.getPreviousMemberOp(mArray[j], false, this.interpreterContext);
                                                                                                mArray[j] = prevMember != null ? prevMember : NullMember.getNullMember(mArray[j]);
                                                                                            }
                                                                                            result /* !! */  = new Set(Tuple.createTupleList(mArray));
                                                                                            ((Set)result /* !! */ ).addCurrentMemberDimension(mArray[0].getDimension());
                                                                                            ((Set)result /* !! */ ).addCurrentMemberHierarchy(mArray[0].getHierarchy());
                                                                                            break block317;
                                                                                        }
                                                                                        for (i = 0; i < mArray.length; ++i) {
                                                                                            if (mArray[i] instanceof NullMember) {
                                                                                                rs.addCell(new Cell(i, TextValue.ERROR_VALUE));
                                                                                                continue;
                                                                                            }
                                                                                            rs.addCell(new Cell(i, mArray[i].getLevel()));
                                                                                        }
                                                                                        if (result /* !! */  instanceof Set) {
                                                                                            rs.addCurrentMemberDimensions(((Set)result /* !! */ ).getCurrentMemberDimensions());
                                                                                        }
                                                                                        result /* !! */  = rs;
                                                                                        break block317;
                                                                                    }
                                                                                    for (i = 0; i < mArray.length; ++i) {
                                                                                        if (mArray[i] instanceof NullMember) {
                                                                                            throw new InterpreterException("X01498", new String[]{"HIERARCHY"});
                                                                                        }
                                                                                        rs.addCell(new Cell(i, mArray[i].getHierarchy()));
                                                                                    }
                                                                                    result /* !! */  = rs;
                                                                                    break block317;
                                                                                }
                                                                                for (i = 0; i < mArray.length; ++i) {
                                                                                    m = mArray[i];
                                                                                    tuples[i] = m instanceof NullMember != false ? new Tuple(m) : new Tuple(MemberOperations.getDefaultMemberOp(m.getHierarchy(), this.interpreterContext));
                                                                                }
                                                                                s = new Set(tuples);
                                                                                rs = new ResultSet(new Set[]{s}, new Set(new Tuple[0]));
                                                                                for (i = 0; i < mArray.length; ++i) {
                                                                                    if (mArray[i] instanceof NullMember) {
                                                                                        throw new InterpreterException("X01498", new String[]{"DIMENSION"});
                                                                                    }
                                                                                    rs.addCell(new Cell(i, mArray[i].getDimension()));
                                                                                }
                                                                                result /* !! */  = rs;
                                                                                break block317;
                                                                            }
                                                                            for (i = 0; i < mArray.length; ++i) {
                                                                                m = mArray[i];
                                                                                if (m instanceof NullMember) {
                                                                                    sets[i] = new Set(new Tuple[0]);
                                                                                    continue;
                                                                                }
                                                                                siblings = MemberOperations.getSiblingsOp(m, true, this.interpreterContext);
                                                                                sets[i] = new Set(Tuple.createTupleList(siblings));
                                                                                sets[i].addCurrentMemberDimension(mArray[i].getDimension());
                                                                            }
                                                                            result /* !! */  = sets;
                                                                            break block317;
                                                                        }
                                                                        for (i = 0; i < resultSets.length; ++i) {
                                                                            if (mArray[i] instanceof NullMember) {
                                                                                throw new InterpreterException("X01498", new String[]{"ALLMEMBERS"});
                                                                            }
                                                                            resultSets[i] = (Set)this.getMembersOrAllMembers(identifier, mArray[i]);
                                                                        }
                                                                        result /* !! */  = resultSets;
                                                                        break block317;
                                                                    }
                                                                    block120: while (it.hasNext()) {
                                                                        md = (IMetadata)it.next();
                                                                        switch (1.$SwitchMap$com$cognos$xqe$metadata$MetadataType[md.getObjectType().ordinal()]) {
                                                                            case 1: {
                                                                                try {
                                                                                    al.add(MemberOperations.getDefaultMemberOp((IHierarchy)md, this.interpreterContext));
                                                                                    hierInfo.track((IHierarchy)md);
                                                                                    continue block120;
                                                                                }
                                                                                catch (MetadataException e) {
                                                                                    cubeObj = this.interpreterContext.getCube();
                                                                                    throw new InterpreterException("X01508", new String[]{cubeObj.getName(), ((IHierarchy)md).getDimension().getName(), "", e.toString()}, e);
                                                                                }
                                                                            }
                                                                            case 2: {
                                                                                try {
                                                                                    al.add(MemberOperations.getDefaultMemberOp((IDimension)md, this.interpreterContext));
                                                                                    hierInfo.track((IDimension)md);
                                                                                    continue block120;
                                                                                }
                                                                                catch (MetadataException e) {
                                                                                    cubeObj = this.interpreterContext.getCube();
                                                                                    throw new InterpreterException("X01508", new String[]{cubeObj.getName(), md.getName(), "", e.toString()}, e);
                                                                                }
                                                                            }
                                                                        }
                                                                        throw new InterpreterException("X01434", new String[]{md.toString(), "CMP_TYPEDIMENSION, CMP_TYPEHIERARCHY"});
                                                                    }
                                                                    if (al.size() != 0) {
                                                                        mems = al.toArray(new IMember[0]);
                                                                        mems = MemberOperations.applySecurityToMembers(mems, hierInfo.getHierarchy(), this.interpreterContext);
                                                                        t = new Tuple[mems.length];
                                                                        for (j = 0; j < mems.length; ++j) {
                                                                            t[j] = new Tuple(new IMember[]{mems[j]});
                                                                        }
                                                                        result /* !! */  = new Set(t);
                                                                        break block317;
                                                                    } else {
                                                                        result /* !! */  = new Set(new Tuple[0]);
                                                                    }
                                                                    break block317;
                                                                }
                                                                block122: while (it.hasNext()) {
                                                                    md = (IMetadata)it.next();
                                                                    switch (1.$SwitchMap$com$cognos$xqe$metadata$MetadataType[md.getObjectType().ordinal()]) {
                                                                        case 1: {
                                                                            try {
                                                                                mems = this.getCurrentMembers(((Hierarchy)md).getDimension(), data);
                                                                                for (i = 0; i < mems.length; ++i) {
                                                                                    children = MemberOperations.getChildrenOp((IMemberCubics)mems[i], false, this.interpreterContext);
                                                                                    if (children.size() <= 0) continue;
                                                                                    al.addAll(children);
                                                                                }
                                                                                hierInfo.track((IHierarchy)md);
                                                                                continue block122;
                                                                            }
                                                                            catch (MetadataException e) {
                                                                                cubeObj = this.interpreterContext.getCube();
                                                                                throw new InterpreterException("X01508", new String[]{cubeObj.getName(), ((Hierarchy)md).getDimension().getName(), "", e.toString()}, e);
                                                                            }
                                                                        }
                                                                        case 2: {
                                                                            try {
                                                                                mems = this.getCurrentMembers((Dimension)md, data);
                                                                                for (i = 0; i < mems.length; ++i) {
                                                                                    children = MemberOperations.getChildrenOp((IMemberCubics)mems[i], false, this.interpreterContext);
                                                                                    if (children.size() <= 0) continue;
                                                                                    al.addAll(children);
                                                                                }
                                                                                hierInfo.track((IDimension)md);
                                                                                continue block122;
                                                                            }
                                                                            catch (MetadataException e) {
                                                                                cubeObj = this.interpreterContext.getCube();
                                                                                throw new InterpreterException("X01508", new String[]{cubeObj.getName(), md.getName(), "", e.toString()}, e);
                                                                            }
                                                                        }
                                                                        case 3: {
                                                                            try {
                                                                                children = MemberOperations.getChildrenOp((IMemberCubics)md, false, this.interpreterContext);
                                                                                if (children.size() <= 0) continue block122;
                                                                                al.addAll(children);
                                                                                hierInfo.track(children.get(0).getHierarchy());
                                                                                continue block122;
                                                                            }
                                                                            catch (MetadataException e) {
                                                                                cubeObj = this.interpreterContext.getCube();
                                                                                throw new InterpreterException("X01508", new String[]{cubeObj.getName(), md.getName(), "", e.toString()}, e);
                                                                            }
                                                                        }
                                                                    }
                                                                    throw new InterpreterException("X01434", new String[]{identifier, "CMP_TYPEMEMBER"});
                                                                }
                                                                if (al.size() != 0) {
                                                                    mems = al.toArray(new IMember[0]);
                                                                    mems = MemberOperations.applySecurityToMembers(mems, hierInfo.getHierarchy(), this.interpreterContext);
                                                                    t = new Tuple[mems.length];
                                                                    for (j = 0; j < mems.length; ++j) {
                                                                        t[j] = new Tuple(new IMember[]{mems[j]});
                                                                    }
                                                                    result /* !! */  = new Set(t);
                                                                    break block317;
                                                                } else {
                                                                    result /* !! */  = new Set(new Tuple[0]);
                                                                }
                                                                break block317;
                                                            }
                                                            block126: while (it.hasNext()) {
                                                                md = (IMetadata)it.next();
                                                                switch (1.$SwitchMap$com$cognos$xqe$metadata$MetadataType[md.getObjectType().ordinal()]) {
                                                                    case 1: {
                                                                        try {
                                                                            mems = this.getCurrentMembers(((Hierarchy)md).getDimension(), data);
                                                                            for (i = 0; i < mems.length; ++i) {
                                                                                siblings = mems[i].getSiblings(true);
                                                                                if (siblings.length <= 0) continue;
                                                                                al.add(siblings[0]);
                                                                            }
                                                                            hierInfo.track((IHierarchy)md);
                                                                            continue block126;
                                                                        }
                                                                        catch (MetadataException e) {
                                                                            cubeObj = this.interpreterContext.getCube();
                                                                            throw new InterpreterException("X01508", new String[]{cubeObj.getName(), ((Hierarchy)md).getDimension().getName(), "", e.toString()}, e);
                                                                        }
                                                                    }
                                                                    case 2: {
                                                                        try {
                                                                            mems = this.getCurrentMembers((Dimension)md, data);
                                                                            for (i = 0; i < mems.length; ++i) {
                                                                                siblings = mems[i].getSiblings(true);
                                                                                if (siblings.length <= 0) continue;
                                                                                al.add(siblings[0]);
                                                                            }
                                                                            hierInfo.track((IDimension)md);
                                                                            continue block126;
                                                                        }
                                                                        catch (MetadataException e) {
                                                                            cubeObj = this.interpreterContext.getCube();
                                                                            throw new InterpreterException("X01508", new String[]{cubeObj.getName(), md.getName(), "", e.toString()}, e);
                                                                        }
                                                                    }
                                                                    case 3: {
                                                                        try {
                                                                            mems = ((IMember)md).getSiblings(true);
                                                                            if (mems.length <= 0) continue block126;
                                                                            al.addAll(Arrays.asList(new IMember[]{mems[0]}));
                                                                            hierInfo.track(((IMember)md).getHierarchy());
                                                                            continue block126;
                                                                        }
                                                                        catch (MetadataException e) {
                                                                            cubeObj = this.interpreterContext.getCube();
                                                                            throw new InterpreterException("X01508", new String[]{cubeObj.getName(), md.getName(), "", e.toString()}, e);
                                                                        }
                                                                    }
                                                                }
                                                                throw new InterpreterException("X01434", new String[]{identifier, "CMP_TYPEMEMBER"});
                                                            }
                                                            if (al.size() == 0) break block398;
                                                            mems = al.toArray(new IMember[0]);
                                                            mems = MemberOperations.applySecurityToMembers(mems, hierInfo.getHierarchy(), this.interpreterContext);
                                                            t = new Tuple[mems.length];
                                                            for (j = 0; j < mems.length; ++j) {
                                                                t[j] = new Tuple(new IMember[]{mems[j]});
                                                            }
                                                            result /* !! */  = new Set(t);
                                                            if (t.length > 0) {
                                                                ((Set)result /* !! */ ).addCurrentMemberDimensions(t[0].getDimensions());
                                                                ((Set)result /* !! */ ).addCurrentMemberHierarchies(t[0].getHierarchies());
                                                            }
                                                            break block317;
                                                        }
                                                        result /* !! */  = new Set(new Tuple[0]);
                                                        break block317;
                                                    }
                                                    block130: while (it.hasNext()) {
                                                        md = (IMetadata)it.next();
                                                        switch (1.$SwitchMap$com$cognos$xqe$metadata$MetadataType[md.getObjectType().ordinal()]) {
                                                            case 1: {
                                                                try {
                                                                    mems = this.getCurrentMembers(((Hierarchy)md).getDimension(), data);
                                                                    for (i = 0; i < mems.length; ++i) {
                                                                        siblings = MemberOperations.getSiblingsOp(mems[i], true, this.interpreterContext);
                                                                        if (siblings.length <= 0) continue;
                                                                        al.add(siblings[siblings.length - 1]);
                                                                    }
                                                                    hierInfo.track((IHierarchy)md);
                                                                    continue block130;
                                                                }
                                                                catch (MetadataException e) {
                                                                    cubeObj = this.interpreterContext.getCube();
                                                                    throw new InterpreterException("X01508", new String[]{cubeObj.getName(), ((Hierarchy)md).getDimension().getName(), "", e.toString()}, e);
                                                                }
                                                            }
                                                            case 2: {
                                                                try {
                                                                    mems = this.getCurrentMembers((Dimension)md, data);
                                                                    for (i = 0; i < mems.length; ++i) {
                                                                        siblings = MemberOperations.getSiblingsOp(mems[i], true, this.interpreterContext);
                                                                        if (siblings.length <= 0) continue;
                                                                        al.add(siblings[siblings.length - 1]);
                                                                    }
                                                                    hierInfo.track((IDimension)md);
                                                                    continue block130;
                                                                }
                                                                catch (MetadataException e) {
                                                                    cubeObj = this.interpreterContext.getCube();
                                                                    throw new InterpreterException("X01508", new String[]{cubeObj.getName(), md.getName(), "", e.toString()}, e);
                                                                }
                                                            }
                                                            case 3: {
                                                                try {
                                                                    mems = MemberOperations.getSiblingsOp((IMemberCubics)md, true, this.interpreterContext);
                                                                    if (mems.length <= 0) continue block130;
                                                                    al.addAll(Arrays.asList(new IMember[]{mems[mems.length - 1]}));
                                                                    hierInfo.track(((IMember)md).getHierarchy());
                                                                    continue block130;
                                                                }
                                                                catch (MetadataException e) {
                                                                    cubeObj = this.interpreterContext.getCube();
                                                                    throw new InterpreterException("X01508", new String[]{cubeObj.getName(), md.getName(), "", e.toString()}, e);
                                                                }
                                                            }
                                                        }
                                                        throw new InterpreterException("X01434", new String[]{identifier, "CMP_TYPEMEMBER"});
                                                    }
                                                    if (al.size() == 0) break block399;
                                                    mems = al.toArray(new IMember[0]);
                                                    mems = MemberOperations.applySecurityToMembers(mems, hierInfo.getHierarchy(), this.interpreterContext);
                                                    t = new Tuple[mems.length];
                                                    for (j = 0; j < mems.length; ++j) {
                                                        t[j] = new Tuple(new IMember[]{mems[j]});
                                                    }
                                                    result /* !! */  = new Set(t);
                                                    if (t.length > 0) {
                                                        ((Set)result /* !! */ ).addCurrentMemberDimensions(t[0].getDimensions());
                                                    }
                                                    break block317;
                                                }
                                                result /* !! */  = new Set(new Tuple[0]);
                                                break block317;
                                            }
                                            block134: while (it.hasNext()) {
                                                md = (IMetadata)it.next();
                                                switch (1.$SwitchMap$com$cognos$xqe$metadata$MetadataType[md.getObjectType().ordinal()]) {
                                                    case 1: {
                                                        try {
                                                            mems = this.getCurrentMembers(((Hierarchy)md).getDimension(), data);
                                                            for (i = 0; i < mems.length; ++i) {
                                                                children = MemberOperations.getChildrenOp((IMemberCubics)mems[i], false, this.interpreterContext);
                                                                if (children.size() <= 0) continue;
                                                                al.add(children.get(children.size() - 1));
                                                            }
                                                            hierInfo.track((IHierarchy)md);
                                                            continue block134;
                                                        }
                                                        catch (MetadataException e) {
                                                            cubeObj = this.interpreterContext.getCube();
                                                            throw new InterpreterException("X01508", new String[]{cubeObj.getName(), ((Hierarchy)md).getDimension().getName(), "", e.toString()}, e);
                                                        }
                                                    }
                                                    case 2: {
                                                        try {
                                                            mems = this.getCurrentMembers((Dimension)md, data);
                                                            for (i = 0; i < mems.length; ++i) {
                                                                children = MemberOperations.getChildrenOp((IMemberCubics)mems[i], false, this.interpreterContext);
                                                                if (children.size() <= 0) continue;
                                                                al.add(children.get(children.size() - 1));
                                                            }
                                                            hierInfo.track((IDimension)md);
                                                            continue block134;
                                                        }
                                                        catch (MetadataException e) {
                                                            cubeObj = this.interpreterContext.getCube();
                                                            throw new InterpreterException("X01508", new String[]{cubeObj.getName(), md.getName(), "", e.toString()}, e);
                                                        }
                                                    }
                                                }
                                                throw new InterpreterException("X01434", new String[]{identifier, "CMP_TYPEMEMBER"});
                                            }
                                            if (al.size() == 0) break block400;
                                            mems = al.toArray(new IMember[0]);
                                            mems = MemberOperations.applySecurityToMembers(mems, hierInfo.getHierarchy(), this.interpreterContext);
                                            t = new Tuple[mems.length];
                                            for (j = 0; j < mems.length; ++j) {
                                                t[j] = new Tuple(new IMember[]{mems[j]});
                                            }
                                            result /* !! */  = new Set(t);
                                            if (t.length > 0) {
                                                ((Set)result /* !! */ ).addCurrentMemberDimensions(t[0].getDimensions());
                                            }
                                            break block317;
                                        }
                                        result /* !! */  = new Set(new Tuple[0]);
                                        break block317;
                                    }
                                    block138: while (it.hasNext()) {
                                        md = (IMetadata)it.next();
                                        switch (1.$SwitchMap$com$cognos$xqe$metadata$MetadataType[md.getObjectType().ordinal()]) {
                                            case 1: {
                                                try {
                                                    mems = this.getCurrentMembers(((Hierarchy)md).getDimension(), data);
                                                    for (i = 0; i < mems.length; ++i) {
                                                        children = MemberOperations.getChildrenOp((IMemberCubics)mems[i], false, this.interpreterContext);
                                                        if (children.size() <= 0) continue;
                                                        al.add(children.get(0));
                                                    }
                                                    hierInfo.track((IHierarchy)md);
                                                    continue block138;
                                                }
                                                catch (MetadataException e) {
                                                    cubeObj = this.interpreterContext.getCube();
                                                    throw new InterpreterException("X01508", new String[]{cubeObj.getName(), md.getName(), "", e.toString()}, e);
                                                }
                                            }
                                            case 2: {
                                                try {
                                                    mems = this.getCurrentMembers((Dimension)md, data);
                                                    for (i = 0; i < mems.length; ++i) {
                                                        children = MemberOperations.getChildrenOp((IMemberCubics)mems[i], false, this.interpreterContext);
                                                        if (children.size() <= 0) continue;
                                                        al.add(children.get(0));
                                                        hierInfo.track((IDimension)md);
                                                    }
                                                    continue block138;
                                                }
                                                catch (MetadataException e) {
                                                    cubeObj = this.interpreterContext.getCube();
                                                    throw new InterpreterException("X01508", new String[]{cubeObj.getName(), md.getName(), "", e.toString()}, e);
                                                }
                                            }
                                        }
                                        throw new InterpreterException("X01434", new String[]{md.toString(), "CMP_TYPEMEMBER"});
                                    }
                                    if (al.size() == 0) break block401;
                                    mems = al.toArray(new IMember[0]);
                                    mems = MemberOperations.applySecurityToMembers(mems, hierInfo.getHierarchy(), this.interpreterContext);
                                    t = new Tuple[mems.length];
                                    for (j = 0; j < mems.length; ++j) {
                                        t[j] = new Tuple(new IMember[]{mems[j]});
                                    }
                                    result /* !! */  = new Set(t);
                                    if (t.length > 0) {
                                        ((Set)result /* !! */ ).addCurrentMemberDimensions(t[0].getDimensions());
                                    }
                                    break block317;
                                }
                                result /* !! */  = new Set(new Tuple[0]);
                                break block317;
                            }
                            block142: while (it.hasNext()) {
                                md = (IMetadata)it.next();
                                switch (1.$SwitchMap$com$cognos$xqe$metadata$MetadataType[md.getObjectType().ordinal()]) {
                                    case 4: {
                                        try {
                                            mems = ((Level)md).getMembers();
                                            al.addAll((Collection<IMember>)mems);
                                            hierInfo.track(((Level)md).getHierarchy());
                                            continue block142;
                                        }
                                        catch (MetadataException e) {
                                            cubeObj = this.interpreterContext.getCube();
                                            throw new InterpreterException("X01508", new String[]{cubeObj.getName(), ((Level)md).getDimension().getUniqueName(), md.getName(), e.toString()}, e);
                                        }
                                    }
                                    case 1: {
                                        try {
                                            mems = ((Hierarchy)md).getMembers();
                                            for (i = 0; i < mems.length; ++i) {
                                                member = mems[i];
                                                al.add(member);
                                            }
                                            hierInfo.track((IHierarchy)md);
                                            continue block142;
                                        }
                                        catch (MetadataException e) {
                                            cubeObj = this.interpreterContext.getCube();
                                            throw new InterpreterException("X01508", new String[]{cubeObj.getName(), ((Hierarchy)md).getDimension().getUniqueName(), "", e.toString()}, e);
                                        }
                                    }
                                    case 2: {
                                        try {
                                            mems = ((Dimension)md).getMembers();
                                            for (i = 0; i < mems.length; ++i) {
                                                member = mems[i];
                                                al.add(member);
                                            }
                                            hierInfo.track((IDimension)md);
                                            continue block142;
                                        }
                                        catch (MetadataException e) {
                                            cubeObj = this.interpreterContext.getCube();
                                            throw new InterpreterException("X01508", new String[]{cubeObj.getName(), md.getName(), "", e.toString()}, e);
                                        }
                                    }
                                }
                                throw new InterpreterException("X01434", new String[]{md.toString(), "CMP_TYPELEVEL, CMP_TYPEHIERARCHY, CMP_TYPEDIMENSION"});
                            }
                            mems = al.toArray(new IMember[0]);
                            mems = MemberOperations.applySecurityToMembers(mems, hierInfo.getHierarchy(), this.interpreterContext);
                            t = new Tuple[mems.length];
                            for (j = 0; j < mems.length; ++j) {
                                t[j] = new Tuple(new IMember[]{mems[j]});
                            }
                            result /* !! */  = new Set(t);
                            break block317;
                        }
                        while (it.hasNext()) {
                            value = it.next();
                            if (value instanceof IDimension) {
                                dim = (IDimension)value;
                                it.setValue(dim.getDefaultHierarchy());
                                continue;
                            }
                            if (value instanceof ILevel) {
                                level = (ILevel)value;
                                it.setValue(level.getHierarchy());
                                continue;
                            }
                            if (value instanceof IMember) {
                                mem = (IMember)value;
                                it.setValue(mem.getHierarchy());
                                continue;
                            }
                            if (!(value instanceof IHierarchy)) {
                                throw new InterpreterException("X01434", new String[]{"HIERARCHY", "CMP_TYPEDIMENSION, CMP_TYPELEVEL, CMP_TYPEMEMBER"});
                            }
                            hi = (IHierarchy)value;
                            it.setValue(hi);
                        }
                        result /* !! */  = rs;
                        break block317;
                    }
                    while (it.hasNext()) {
                        value = it.next();
                        if (value instanceof IDimension) {
                            dim = (IDimension)value;
                            s = dim.getDescription();
                            if (s == null) {
                                s = dim.getCaption();
                            }
                            it.setValue(s);
                            continue;
                        }
                        if (value instanceof IHierarchy) {
                            hier = (IHierarchy)value;
                            s = hier.getDescription();
                            if (s == null) {
                                s = hier.getCaption();
                            }
                            it.setValue(s);
                            continue;
                        }
                        if (!(value instanceof ILevel)) {
                            throw new InterpreterException("X01434", new String[]{identifier, "CMP_TYPELEVEL, CMP_TYPEHIERARCHY, CMP_TYPEDIMENSION"});
                        }
                        level = (ILevel)value;
                        s = level.getDescription();
                        if (s == null) {
                            s = level.getCaption();
                        }
                        it.setValue(s);
                    }
                    break block317;
                }
                while (it.hasNext()) {
                    cellValue = it.next();
                    if (cellValue instanceof NullMember) {
                        throw new InterpreterException("X01498", new String[]{"LEVEL"}, 2L);
                    }
                    if (cellValue instanceof IMember) {
                        it.setValue(((IMember)cellValue).getLevel());
                        continue;
                    }
                    if (cellValue instanceof IMember[] && ((IMember[])cellValue).length == 1) {
                        it.setValue(((IMember[])cellValue)[0].getLevel());
                        continue;
                    }
                    throw new InterpreterException("X01434", new String[]{identifier, "CMP_TYPEMEMBER"});
                }
            }
            this.addIdentifierProfile(identifier, System.currentTimeMillis() - time);
            this.startProfile();
            if (result /* !! */  != null && result /* !! */  instanceof IMember && isLastPartOfComposite && MemberOperations.applySecurityToMember((IMember)result /* !! */ , this.interpreterContext) == null) {
                result /* !! */  = NullMember.getNullMember((IMember)result /* !! */ );
            }
        }
        if (result /* !! */  != null) return result /* !! */ ;
        throw new InterpreterException("X01427", new String[]{identifier});
    }

    public String getClassNameCode(String className) {
        if (className.endsWith("TupleValue") || className.endsWith("TupleValue[]") || className.endsWith("ResultSet") || className.endsWith("ResultSet[]") || className.endsWith("MetaData") || className.endsWith("MetaData[]")) {
            return "";
        }
        if (className.endsWith("Set") || className.endsWith("Set[]")) {
            return "CMP_TYPESET";
        }
        if (className.endsWith("Tuple") || className.endsWith("Tuple[]")) {
            return "CMP_TYPETUPLE";
        }
        if (className.endsWith("Member") || className.endsWith("Member[]")) {
            return "CMP_TYPEMEMBER";
        }
        if (className.endsWith("Cube") || className.endsWith("Cube[]")) {
            return "CMP_TYPECUBE";
        }
        if (className.endsWith("Dimension") || className.endsWith("Dimension[]")) {
            return "CMP_TYPEDIMENSION";
        }
        if (className.endsWith("Hierarchy") || className.endsWith("Hierarchy[]")) {
            return "CMP_TYPEHIERARCHY";
        }
        if (className.endsWith("Level") || className.endsWith("Level[]")) {
            return "CMP_TYPELEVEL";
        }
        if (className.endsWith("String") || className.endsWith("String[]")) {
            return "CMP_TYPESTRING";
        }
        if (className.endsWith("Double") || className.endsWith("Double[]") || className.endsWith("Integer") || className.endsWith("Integer[]")) {
            return "CMP_TYPENUMERIC";
        }
        if (className.endsWith("CalculatedMember") || className.endsWith("CalculatedMember[]")) {
            return "CMP_TYPECALCMEMBER";
        }
        if (className.endsWith("NamedSet") || className.endsWith("NamedSet[]")) {
            return "CMP_TYPENAMEDSET";
        }
        return className;
    }

    private Object childrenFunction(Object o) throws InterpreterException {
        IHierarchy[] currentMemberHiers;
        IDimension[] currentMemberDims;
        IMember[] mems;
        block16: {
            mems = null;
            currentMemberDims = null;
            currentMemberHiers = null;
            try {
                if (o instanceof IMember[]) {
                    mems = (IMember[])o;
                    if (mems.length > 1) {
                        currentMemberDims = new IDimension[]{mems[0].getDimension()};
                        currentMemberHiers = new IHierarchy[]{mems[0].getHierarchy()};
                    }
                    break block16;
                }
                if (o instanceof IMember) {
                    mems = new IMember[]{(IMember)o};
                    break block16;
                }
                if (o instanceof IDimension) {
                    IMember m = ((Dimension)o).getDefaultMemberWithSecurity();
                    mems = new IMember[]{m};
                    break block16;
                }
                if (o instanceof Set && ((Set)o).isCurrentMemberSet()) {
                    mems = (IMember[])Caster.cast(o, IMember[].class);
                    currentMemberDims = ((Set)o).getCurrentMemberDimensions();
                    currentMemberHiers = ((Set)o).getCurrentMemberHierarchies();
                    break block16;
                }
                if (o instanceof Tuple && ((Tuple)o).size() == 1) {
                    Tuple tuple = (Tuple)o;
                    mems = tuple.getMembers();
                    break block16;
                }
                String classCode = this.getClassNameCode(o.getClass().getSimpleName());
                throw new InterpreterException("X01461", new String[]{classCode, "CMP_TYPEMEMBER"});
            }
            catch (MetadataException e) {
                String classCode = this.getClassNameCode(o.getClass().getSimpleName());
                throw new InterpreterException("X01461", new String[]{classCode, "CMP_TYPEMEMBER"}, e);
            }
        }
        Set[] sets = new Set[mems.length];
        for (int i = 0; i < mems.length; ++i) {
            IMember m = mems[i];
            if (MemberOperations.applySecurityToMember(m, this.interpreterContext) == null) {
                m = NullMember.getNullMember(m);
            }
            if (m instanceof NullMember) {
                sets[i] = new Set(new Tuple[0]);
            } else {
                IMember[] childMems;
                try {
                    List<IMember> children = MemberOperations.getChildrenOp((IMemberCubics)m, false, this.interpreterContext);
                    childMems = children.toArray(new IMember[0]);
                }
                catch (MetadataException e) {
                    throw new InterpreterException("X01493", new String[]{m.getUniqueName(), e.toString()}, e);
                }
                ITuple[] t = new Tuple[childMems.length];
                for (int j = 0; j < childMems.length; ++j) {
                    t[j] = new Tuple(new IMember[]{childMems[j]});
                }
                sets[i] = new Set(t);
            }
            if (currentMemberDims != null) {
                sets[i].addCurrentMemberDimensions(currentMemberDims);
            }
            if (currentMemberHiers == null) continue;
            sets[i].addCurrentMemberHierarchies(currentMemberHiers);
        }
        Set[] result = sets;
        return result;
    }

    private int appendOne(IMember m, IMember[] mems, int iNext, ArrayList<IMember> memArrayList, HashMap<IMember, ArrayList<CalculatedMember>> parentToCalcMembers, boolean appendCalcs) {
        IMember mNext;
        IMember parent = m.getParent();
        memArrayList.add(m);
        while (iNext < mems.length && (mNext = mems[iNext]).getParent() == m) {
            ++iNext;
            iNext = this.appendOne(mNext, mems, iNext, memArrayList, parentToCalcMembers, true);
        }
        if (iNext < mems.length && (mNext = mems[iNext]).getParent() == parent) {
            if (m.getChildrenCardinality() == 0 && appendCalcs && parentToCalcMembers.containsKey(m)) {
                ArrayList<CalculatedMember> calcs = parentToCalcMembers.get(m);
                for (int k = 0; k < calcs.size(); ++k) {
                    CalculatedMember mem = calcs.get(k);
                    memArrayList.add(mem);
                }
            }
            return iNext;
        }
        if (appendCalcs && parentToCalcMembers.containsKey(m.getParent())) {
            ArrayList<CalculatedMember> calcs = parentToCalcMembers.get(parent);
            for (int k = 0; k < calcs.size(); ++k) {
                CalculatedMember mem = calcs.get(k);
                memArrayList.add(mem);
            }
        }
        return iNext;
    }

    private Object getMembersOrAllMembers(String identifier, IMetadata md) throws InterpreterException {
        int j;
        IMember[] mems = null;
        logger.log("Members :" + md);
        IHierarchy hier = null;
        try {
            switch (md.getObjectType()) {
                case MEMBER: {
                    throw new InterpreterException("X01431", new String[]{md.getName()});
                }
                case LEVEL: {
                    Level l = (Level)md;
                    mems = MemberOperations.getMembers(l, this.interpreterContext);
                    hier = l.getHierarchy();
                    break;
                }
                case HIERARCHY: {
                    mems = ((IHierarchy)md).getMembers();
                    hier = (IHierarchy)md;
                    break;
                }
                case DIMENSION: {
                    IDimension dim = (IDimension)md;
                    mems = dim.getMembers();
                    if (dim.getHierarchyCount() != 1) break;
                    hier = dim.getHierarchy(0);
                    break;
                }
            }
        }
        catch (MetadataException e) {
            throw new InterpreterException("X01431", new String[]{md.getName()}, e);
        }
        ArrayList<IMember> memArrayList = new ArrayList<IMember>();
        if (identifier.equals(FUNCTION_MEMBERS)) {
            for (j = 0; j < mems.length; ++j) {
                IMember member = mems[j];
                boolean isCalcMember = member.isCalculatedMember();
                int memberTypeFormula = 4;
                Object memberType = member.getProperty("MEMBER_TYPE");
                boolean isFormulaMember = false;
                if (memberType != null) {
                    if (memberType instanceof String) {
                        int mtype = Integer.parseInt((String)memberType);
                        isFormulaMember = mtype == memberTypeFormula;
                    } else if (memberType instanceof Integer) {
                        boolean bl = isFormulaMember = (Integer)memberType == memberTypeFormula;
                    }
                }
                if (isCalcMember || isFormulaMember) continue;
                memArrayList.add(member);
            }
            mems = memArrayList.toArray(new IMember[0]);
        } else if (identifier.equals(FUNCTION_ALL_MEMBERS)) {
            if (mems.length > 0) {
                IMember m;
                int i;
                IMember testMember = mems[0];
                Dimension testDimension = (Dimension)testMember.getDimension();
                ArrayList<IMember> calcMembers = this.interpreterContext.getCalculationEngine().getCalculatedMembers(testDimension);
                HashMap<IMember, ArrayList<CalculatedMember>> parentToCalcMembers = new HashMap<IMember, ArrayList<CalculatedMember>>();
                HashSet<IMember> calcMembersInSet = new HashSet<IMember>();
                int sz = mems.length;
                for (i = 0; i < sz; ++i) {
                    m = mems[i];
                    if (!(m instanceof CalculatedMember)) continue;
                    calcMembersInSet.add(m);
                }
                for (i = 0; i < calcMembers.size(); ++i) {
                    CalculatedMember cal = (CalculatedMember)calcMembers.get(i);
                    if (calcMembersInSet.contains(cal) || cal.getDimension() != testDimension) continue;
                    IMember parent = cal.getParent();
                    ArrayList<CalculatedMember> calcs = (ArrayList<CalculatedMember>)parentToCalcMembers.get(parent);
                    if (calcs == null) {
                        calcs = new ArrayList<CalculatedMember>();
                    }
                    calcs.add(cal);
                    parentToCalcMembers.put(parent, calcs);
                }
                if (parentToCalcMembers.size() > 0) {
                    int iNext = 0;
                    while (iNext < sz) {
                        m = mems[iNext];
                        ++iNext;
                        iNext = this.appendOne(m, mems, iNext, memArrayList, parentToCalcMembers, true);
                    }
                } else {
                    for (int j2 = 0; j2 < mems.length; ++j2) {
                        IMember member = mems[j2];
                        memArrayList.add(member);
                    }
                }
            }
            mems = memArrayList.toArray(new IMember[0]);
        }
        mems = MemberOperations.applySecurityToMembers(mems, hier, this.interpreterContext);
        ITuple[] t = new Tuple[mems.length];
        for (j = 0; j < mems.length; ++j) {
            t[j] = new Tuple(new IMember[]{mems[j]});
        }
        Set result = new Set(t);
        return result;
    }

    private Object processMemberIdentifierPart(IMember member, String identifier, boolean isLastPartOfIndentifier) throws InterpreterException {
        Object result = null;
        boolean identIsMemberFunction = true;
        try {
            if (identifier.equals(FUNCTION_LASTSIBLING)) {
                IMember[] siblings;
                result = member instanceof NullMember ? member : (MemberOperations.applySecurityToMember(member, this.interpreterContext) == null ? NullMember.getNullMember(member) : ((siblings = MemberOperations.getSiblingsOp(member, true, this.interpreterContext)) != null && siblings.length > 0 ? siblings[siblings.length - 1] : NullMember.getNullMember(member)));
            } else if (identifier.equals(FUNCTION_FIRSTSIBLING)) {
                IMember[] siblings;
                result = member instanceof NullMember ? member : (MemberOperations.applySecurityToMember(member, this.interpreterContext) == null ? NullMember.getNullMember(member) : ((siblings = MemberOperations.getSiblingsOp(member, true, this.interpreterContext)) != null && siblings.length > 0 ? siblings[0] : NullMember.getNullMember(member)));
            } else if (identifier.equals(FUNCTION_FIRSTCHILD)) {
                if (member instanceof NullMember) {
                    result = member;
                } else if (MemberOperations.applySecurityToMember(member, this.interpreterContext) == null) {
                    result = NullMember.getNullMember(member);
                } else {
                    IMember[] children = member.getChildMembers();
                    IHierarchy hier = member.getHierarchy();
                    result = (children = MemberOperations.applySecurityToMembers(children, hier, this.interpreterContext)).length > 0 ? children[0] : NullMember.getNullMember(member);
                }
            } else if (identifier.equals(FUNCTION_LASTCHILD)) {
                if (member instanceof NullMember) {
                    result = member;
                } else if (MemberOperations.applySecurityToMember(member, this.interpreterContext) == null) {
                    result = NullMember.getNullMember(member);
                } else {
                    IMember[] children = member.getChildMembers();
                    IHierarchy hier = member.getHierarchy();
                    result = (children = MemberOperations.applySecurityToMembers(children, hier, this.interpreterContext)).length > 0 ? children[children.length - 1] : NullMember.getNullMember(member);
                }
            } else if (identifier.equals(FUNCTION_PARENT)) {
                result = member instanceof NullMember ? member : (MemberOperations.applySecurityToMember(member, this.interpreterContext) == null ? NullMember.getNullMember(member) : MemberOperations.getParentOp(member.getParent(), false, this.interpreterContext));
            } else if (identifier.equals(FUNCTION_PREV_MEMBER)) {
                result = MemberOperations.applySecurityToMember(member, this.interpreterContext) == null ? NullMember.getNullMember(member) : MemberOperations.getPreviousMemberOp(member, false, this.interpreterContext);
            } else if (identifier.equals(FUNCTION_NEXT_MEMBER)) {
                result = MemberOperations.applySecurityToMember(member, this.interpreterContext) == null ? NullMember.getNullMember(member) : MemberOperations.getNextMemberOp(member, false, this.interpreterContext);
            } else if (identifier.equals(FUNCTION_UNIQUE_NAME)) {
                logger.log("Returning the UniqueName.");
                result = member instanceof NullMember ? NullObject.instance() : (MemberOperations.applySecurityToMember(member, this.interpreterContext) == null ? NullMember.getNullMember(member) : member.getUniqueName());
            } else if (identifier.equals(FUNCTION_NAME) || identifier.equals(FUNCTION_DESCRIPTION) || identifier.equals(FUNCTION_CAPTION)) {
                if (member instanceof NullMember) {
                    result = NullObject.instance();
                } else if (MemberOperations.applySecurityToMember(member, this.interpreterContext) == null) {
                    result = NullObject.instance();
                } else {
                    result = member.getProperty("Caption");
                    if (result == null) {
                        result = member.getName();
                    }
                }
                logger.log("Returning the Name:" + result);
            } else {
                IDimension dim;
                identIsMemberFunction = false;
                result = member.getChildMember(identifier);
                if (result == null) {
                    String memberUniqueName = member.getUniqueName() + ".[" + identifier + CLOSE_SQUARE_BRACKET;
                    ICalculationEngine calculationEngine = this.interpreterContext.getCalculationEngine();
                    result = calculationEngine.getCalculatedMember(memberUniqueName);
                }
                if (result == null) {
                    result = ((Dimension)member.getDimension()).findDescendant(member, identifier);
                }
                if (result == null && (dim = member.getDimension()) instanceof NoddyDimension) {
                    result = ((IMemberCubics)member).createChild(identifier);
                }
                if (result == null) {
                    boolean memberFixup;
                    String strMemberFindByCode = Environment.getEnvironmentVariable("memberFindByCode");
                    if (strMemberFindByCode == null) {
                        strMemberFindByCode = Environment.getEnvironmentVariable("DigitalAspects/MemberFindByCode");
                    }
                    boolean bl = memberFixup = strMemberFindByCode != null && "true".equalsIgnoreCase(strMemberFindByCode);
                    if (memberFixup) {
                        String id = identifier.substring(0, identifier.indexOf(32));
                        IMember[] mems = member.getChildMembers();
                        for (int j = 0; j < mems.length && result == null; ++j) {
                            IMember mem = mems[j];
                            if (!mem.getName().startsWith(id)) continue;
                            result = mem;
                        }
                        if (result == null) {
                            result = MemberOperations.getDefaultMemberOp(member.getHierarchy(), this.interpreterContext);
                        }
                    }
                }
            }
        }
        catch (MetadataException e) {
            throw new InterpreterException("X01434", new String[]{identifier, "LASTSIBLING, FIRSTSIBLING, FIRSTSIBLING, ..."}, e);
        }
        if (identIsMemberFunction && result == null) {
            result = NullMember.getNullMember(member);
        }
        if (result != null && !(result instanceof NullMember) && !identIsMemberFunction && result instanceof IMember && isLastPartOfIndentifier && MemberOperations.applySecurityToMember((IMember)result, this.interpreterContext) == null) {
            result = NullMember.getNullMember(member);
        }
        return result;
    }

    private IMember[] getCurrentMembers(IHierarchy h, Object data) throws InterpreterException {
        SearchConditionEvaluator sce;
        Set filterSet;
        if (data instanceof SearchConditionEvaluator && (filterSet = (sce = (SearchConditionEvaluator)data).getFilterSet()) != null && filterSet.contains(h)) {
            IMember[] currentMembers = filterSet.getMembers(h);
            return currentMembers;
        }
        CrossJoinedSet contextSet = this.interpreterContext.getContextSet();
        IMember[] currentMembers = contextSet.getMembers(h);
        if (currentMembers.length == 0) {
            IMember hierarchyDefaultMember = null;
            try {
                hierarchyDefaultMember = MemberOperations.getDefaultMemberOp(h, this.interpreterContext);
            }
            catch (MetadataException e) {
                throw new InterpreterException("X01408", new String[]{h.toString()}, e);
            }
            currentMembers = new IMember[]{hierarchyDefaultMember};
        }
        return currentMembers;
    }

    private IMember[] getCurrentMembers(IDimension dimension, Object data) {
        SearchConditionEvaluator sce;
        Set filterSet;
        if (data instanceof SearchConditionEvaluator && (filterSet = (sce = (SearchConditionEvaluator)data).getFilterSet()) != null && filterSet.contains(dimension)) {
            IMember[] currentMembers = filterSet.getMembers(dimension);
            return currentMembers;
        }
        CrossJoinedSet contextSet = this.interpreterContext.getContextSet();
        IMember[] currentMembers = contextSet.getMembers(dimension);
        if (currentMembers.length == 0) {
            currentMembers = new IMember[]{dimension.getDefaultHierarchy().getDefaultMember()};
        }
        return currentMembers;
    }

    private Object processSelect(ASTSelectStatement node, int childCount, Object data) throws InterpreterException {
        int i;
        if (childCount == 0) {
            throw new InterpreterException("X01425", new String[]{""});
        }
        boolean withSpecified = node.jjtGetChild(0) instanceof ASTFormulaSpecification;
        boolean cellPropsSpecified = node.jjtGetChild(childCount - 1) instanceof ASTCellProps;
        boolean slicerSpecified = cellPropsSpecified ? node.jjtGetChild(childCount - 2) instanceof ASTSlicerSpecification : node.jjtGetChild(childCount - 1) instanceof ASTSlicerSpecification;
        int axisCount = cellPropsSpecified ? (slicerSpecified ? childCount - 3 : childCount - 2) : (slicerSpecified ? childCount - 2 : childCount - 1);
        ICube cube = (ICube)node.jjtGetChild(axisCount).accept(this, data);
        this.interpreterContext.setCube(cube);
        IMember[] mems = new IMember[cube.getDimensionCount()];
        for (int j = 0; j < mems.length; ++j) {
            try {
                mems[j] = ((Dimension)cube.getDimension(j)).isAttributeDimension() ? ((Dimension)cube.getDimension(j)).getDummyMember(cube.getDimension(j).getDefaultHierarchy()) : MemberOperations.getDefaultMemberOp(cube.getDimension(j), this.interpreterContext);
                if (mems[j] != null) continue;
                XQEDebugLog.out.println("Dimension " + cube.getDimension(j).getUniqueName() + " contains no default member. Creating empty initial context");
                continue;
            }
            catch (MetadataException e) {
                throw new InterpreterException("X01408", new String[]{cube.getDimension(j).getUniqueName()}, e);
            }
        }
        ISet[] contextSets = new Set[]{new Set(new Tuple(mems))};
        this.interpreterContext.setInitialContextSet(new CrossJoinedSet(contextSets));
        this.query = this.interpreterContext.createSelectQuery();
        ((SelectQuery)this.query).setSubQuery(false);
        if (cellPropsSpecified) {
            node.jjtGetChild(childCount - 1).accept(this, null);
        }
        logger.log("processing with clause");
        if (withSpecified) {
            node.jjtGetChild(0).accept(this, data);
        }
        logger.log("processing where clause");
        Tuple whereTuple = null;
        if (slicerSpecified) {
            Object obj = node.jjtGetChild(axisCount + 1).accept(this, data);
            Tuple[] tuples = (Tuple[])Caster.cast(obj, Tuple[].class);
            whereTuple = tuples[0];
            logger.log("Where tuple (tuple[0]) = " + whereTuple);
        } else {
            whereTuple = new Tuple(new IMember[0]);
        }
        ((SelectQuery)this.query).setWhereTuple(whereTuple);
        if (whereTuple.size() > 0) {
            for (int j = 0; j < whereTuple.size(); ++j) {
                IMember m;
                mems[m.getDimension().getIndex()] = m = whereTuple.getMember(j);
            }
            ArrayList<IMember> removeNulls = new ArrayList<IMember>();
            for (int j = 0; j < mems.length; ++j) {
                IMember mem = mems[j];
                if (mem == null) continue;
                removeNulls.add(mem);
            }
            mems = removeNulls.toArray(new IMember[0]);
            contextSets = new Set[]{new Set(new Tuple(mems))};
            this.interpreterContext.pushContext(new CrossJoinedSet(contextSets));
        }
        if (withSpecified) {
            --axisCount;
        }
        logger.log("processing axes (count = " + axisCount + ")");
        ((SelectQuery)this.query).setNumberOfAxes(axisCount);
        if (withSpecified) {
            i = 1;
            ++axisCount;
        } else {
            i = 0;
        }
        while (i < axisCount) {
            node.jjtGetChild(i).accept(this, data);
            ++i;
        }
        ((SelectQuery)this.query).removeNullMembers();
        logger.log("Finished processing axes");
        return null;
    }

    private Object processCubeName(ASTCubeName node, int childCount, Object data) throws InterpreterException {
        String cubeName = (String)node.jjtGetChild(0).accept(this, data);
        return cubeName;
    }

    private Object processCubeSpecification(ASTCubeSpecification node, int childCount, Object data) throws InterpreterException {
        Provider provider = this.interpreterContext.getProvider();
        String cubeName = (String)node.jjtGetChild(0).accept(this, data);
        ICube c = this.interpreterContext.getCube();
        logger.log("Cube Name :" + cubeName);
        if (c == null || !c.getName().equals(cubeName)) {
            try {
                c = provider.getCube(cubeName);
                if (c == null) {
                    throw new InterpreterException("X01425", new String[]{cubeName});
                }
                ((Cube)c).initialize();
            }
            catch (ProviderException e) {
                throw new InterpreterException("X01425", new String[]{cubeName}, e);
            }
        }
        if (childCount > 1) {
            throw new InterpreterException("X01450");
        }
        try {
            ((Cube)c).initialize();
        }
        catch (ProviderException e) {
            throw new InterpreterException("X01901", new String[]{cubeName}, e);
        }
        return c;
    }

    private Object processDimProps(ASTDimProps node, int childCount, Object data) throws InterpreterException {
        ArrayList<com.cognos.xqe.runtree.olap.mdx.metadata.Property> propList = new ArrayList<com.cognos.xqe.runtree.olap.mdx.metadata.Property>();
        for (int i = 0; i < childCount; ++i) {
            com.cognos.xqe.runtree.olap.mdx.metadata.Property property;
            if (!(node.jjtGetChild(i) instanceof ASTProperty) || (property = (com.cognos.xqe.runtree.olap.mdx.metadata.Property)node.jjtGetChild(i).accept(this, data)) == null) continue;
            logger.log("Property at " + i + " of list = " + property);
            propList.add(property);
        }
        return propList;
    }

    private Object processAxisSpecification(ASTAxisSpecification node, int childCount, Object data) throws InterpreterException {
        Set set;
        ASTMDXNode subNode;
        boolean dimensionPropertiesSpecified;
        ArrayList properties = null;
        boolean bl = dimensionPropertiesSpecified = childCount > 2;
        if (dimensionPropertiesSpecified) {
            properties = (ArrayList)node.jjtGetChild(1).accept(this, data);
            subNode = (ASTMDXNode)node.jjtGetChild(2);
        } else {
            subNode = (ASTMDXNode)node.jjtGetChild(1);
        }
        int axisNumber = subNode.getValue();
        Object setOrSetArray = null;
        setOrSetArray = node.jjtGetChild(0).accept(this, data);
        if (setOrSetArray instanceof Set) {
            set = (Set)setOrSetArray;
        } else if (setOrSetArray instanceof Set[]) {
            Set[] sets = (Set[])setOrSetArray;
            set = Set.union(sets, true);
        } else if (setOrSetArray instanceof IMember) {
            set = new Set(new Tuple((IMember)setOrSetArray));
        } else if (setOrSetArray instanceof IDimension || setOrSetArray instanceof IHierarchy) {
            set = (Set)Caster.cast(setOrSetArray, Set.class, this.interpreterContext);
        } else if (setOrSetArray instanceof IMember[]) {
            set = new Set(Tuple.createTupleList((IMember[])setOrSetArray));
        } else if (setOrSetArray == null) {
            set = new Set(new Tuple[0]);
        } else if (setOrSetArray instanceof Tuple[]) {
            set = new Set((Tuple[])setOrSetArray);
        } else if (setOrSetArray instanceof ResultSet) {
            ArrayList<Set> setsToUnion = new ArrayList<Set>();
            ResultSet rs = (ResultSet)setOrSetArray;
            IResultSetIterator it = rs.iterator();
            while (it.hasNext()) {
                Object cellObj = ((Cell)it.next()).getObjectValue();
                if (cellObj instanceof Dimension || cellObj instanceof Hierarchy || cellObj instanceof IMember[] || cellObj instanceof Set) {
                    setsToUnion.add((Set)Caster.cast(cellObj, Set.class, this.interpreterContext));
                    continue;
                }
                String className = this.getClassNameCode(cellObj.getClass().getSimpleName());
                InterpreterException ie = new InterpreterException("X01461", new String[]{className, "CMP_TYPESET"});
                String errorMessage = ie.getLocalizedMessage();
                throw new InterpreterException("X60002", new String[]{axisNumber + "", errorMessage});
            }
            set = Set.union(setsToUnion.toArray(new Set[0]), true);
        } else {
            String className = this.getClassNameCode(setOrSetArray.getClass().getSimpleName());
            InterpreterException ie = new InterpreterException("X01461", new String[]{className, "CMP_TYPESET"});
            String errorMessage = ie.getLocalizedMessage();
            throw new InterpreterException("X60002", new String[]{axisNumber + "", errorMessage});
        }
        try {
            ((SelectQuery)this.query).setAxis(axisNumber, set);
            if (node.getNonEmpty()) {
                ((SelectQuery)this.query).setNonEmptyAxis(axisNumber);
                logger.log("NON EMPTY on axis " + axisNumber);
            }
            if (!set.isEmpty() && properties != null) {
                for (com.cognos.xqe.runtree.olap.mdx.metadata.Property prop : properties) {
                    ILevel l;
                    IDimension dim = prop.getDimension();
                    if (dim == null && (l = prop.getLevel()) != null) {
                        dim = l.getDimension();
                    }
                    if (dim == null || set.contains(dim)) continue;
                    throw new InterpreterException("X01458", new String[]{prop.getUniqueName()});
                }
                ((SelectQuery)this.query).setPropertiesOnAxis(axisNumber, properties);
            }
        }
        catch (InterpreterException e) {
            throw new InterpreterException("X60002", new String[]{axisNumber + "", e.toString()}, e);
        }
        if (set instanceof CrossJoinedSet) {
            set = ((CrossJoinedSet)set).removeNullMembersFromCrossJoinedSet();
        } else if (set instanceof Set) {
            set = set.removeNullMembers();
        }
        logger.log("Axis Spec");
        return null;
    }

    private Object processMemberSpecification(ASTMemberSpecification node, int childCount, Object data) throws InterpreterException {
        CalculatedMember calcMem = this.processMemberSpecification(node, "STATEMENT");
        ICalculationEngine calculationEngine = this.interpreterContext.getCalculationEngine();
        if (calculationEngine.getStatementCalculatedMember(calcMem.getUniqueName()) != null) {
            throw new InterpreterException("X80001", new String[]{calcMem.getUniqueName()});
        }
        calculationEngine.addCalculatedMember(calcMem);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object processSetSpecification(ASTSetSpecification node, int childCount, Object data) throws InterpreterException {
        String setString = null;
        NamedSet namedSet = null;
        String setName = (String)node.jjtGetChild(0).accept(this, data);
        Node setExpressionNode = node.jjtGetChild(1);
        if (setExpressionNode instanceof ASTStringValueExpression) {
            setString = ((ASTStringValueExpression)setExpressionNode).accept(this, data).toString();
            setString = setString.replaceAll("''", "'");
            namedSet = new NamedSet(setName, setString);
        } else if (setExpressionNode instanceof ASTValueExpressionPrimary) {
            IXQEQueryNode parent = ((ASTValueExpressionPrimary)setExpressionNode).getParent();
            ((ASTValueExpressionPrimary)setExpressionNode).setParent(null);
            Object setExpression = setExpressionNode.accept(this, data);
            ((ASTValueExpressionPrimary)setExpressionNode).setParent(parent);
            if (!(setExpression instanceof Set[])) throw new InterpreterException("X01515");
            namedSet = new NamedSet(setName, (Set[])setExpression);
        } else {
            if (!(setExpressionNode instanceof ASTSet)) throw new InterpreterException("X01515");
            namedSet = new NamedSet(setName, (ASTSet)setExpressionNode);
        }
        logger.log("Named Set String :" + setString);
        ICalculationEngine calculationEngine = this.interpreterContext.getCalculationEngine();
        Cube c = (Cube)this.interpreterContext.getCube();
        if (calculationEngine.getNamedSet(namedSet.getName()) != null && !this.interpreterContext.getSession().isNamedSetSessionObject(namedSet.getUniqueName(), c)) {
            throw new InterpreterException("X01428", new String[]{namedSet.getUniqueName()});
        }
        calculationEngine.addNamedSet(namedSet);
        return null;
    }

    private Object processMemberName(ASTMemberName node, int childCount, Object data) throws InterpreterException {
        String[] s = new String[childCount];
        for (int i = 0; i < childCount; ++i) {
            s[i] = (String)node.jjtGetChild(i).accept(this, data);
        }
        return s;
    }

    private Object processInlineNamedSet(ASTInlineNamedSet node, int childCount, Object data) throws InterpreterException {
        Object result = node.jjtGetChild(0).accept(this, data);
        if (node.getKeyword() != null && "InlineSet".equalsIgnoreCase(node.getKeyword())) {
            node.setParameter("InlineIdentifier", "true");
            String setName = (String)node.jjtGetChild(1).accept(this, data);
            Set[] sets = (Set[])Caster.cast(result, Set[].class);
            NamedSet namedSet = new NamedSet(setName, sets);
            ICalculationEngine calculationEngine = this.interpreterContext.getCalculationEngine();
            calculationEngine.addNamedSet(namedSet);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object processSet(ASTSet node, int childCount, Object data) throws InterpreterException {
        Object result;
        int elementCount;
        block50: {
            void var11_41;
            Set[] resultSets;
            IResultSetIterator it;
            block56: {
                Set[] currSets;
                block54: {
                    block51: {
                        block55: {
                            ITuple[] tups;
                            block53: {
                                block52: {
                                    block49: {
                                        elementCount = 0;
                                        for (int j = 0; j < childCount; ++j) {
                                            if (!(node.jjtGetChild(j) instanceof ASTElement)) continue;
                                            ++elementCount;
                                        }
                                        if (childCount != 0) break block49;
                                        result = new Set(new Tuple[0]);
                                        break block50;
                                    }
                                    if (node.getKeyword() == null || !"Set".equals(node.getKeyword())) break block51;
                                    if (childCount - elementCount > 0) break block52;
                                    result = new Set(new Tuple[0]);
                                    break block50;
                                }
                                if (childCount - elementCount <= 1) break block53;
                                currSets = new Set[]{new Set(new Tuple[0])};
                                break block54;
                            }
                            result = node.jjtGetChild(0).accept(this, data);
                            boolean currentMembers = false;
                            if (result instanceof IMember[]) {
                                currentMembers = true;
                                result = Tuple.createTupleList((IMember[])result);
                                tups = (Tuple[])result;
                                Set[] sets = new Set[tups.length];
                                for (int j = 0; j < tups.length; ++j) {
                                    sets[j] = new Set(tups[j]);
                                }
                                result = sets;
                            } else if (result instanceof ITuple[]) {
                                tups = (ITuple[])result;
                                Set[] sets = new Set[tups.length];
                                for (int j = 0; j < tups.length; ++j) {
                                    sets[j] = new Set(tups[j]);
                                }
                                result = sets;
                            } else if (result instanceof ISet && ((Set)result).isCurrentMemberSet()) {
                                void var11_39;
                                ISet set = (ISet)result;
                                currentMembers = true;
                                int setSize = (int)set.size();
                                Set[] sets = new Set[setSize];
                                boolean bl = false;
                                while (var11_39 < setSize) {
                                    sets[var11_39] = new Set(set.getTuple((long)var11_39));
                                    ++var11_39;
                                }
                                result = sets;
                            }
                            if (result instanceof ResultSet || !Caster.isCastable(result, Set[].class)) break block55;
                            Set[] sets = (Set[])Caster.cast(result, Set[].class);
                            if (currentMembers) {
                                for (int j = 0; j < sets.length; ++j) {
                                    IDimension[] ds = sets[j].getDimensions();
                                    sets[j].addCurrentMemberDimensions(ds);
                                }
                            }
                            result = sets;
                            break block50;
                        }
                        if (result instanceof Level) {
                            try {
                                IMember[] members = ((Level)result).getMembers().toArray(new IMember[0]);
                                Set[] resultSet = new Set[]{new Set(Tuple.createTupleList(members))};
                                result = resultSet;
                            }
                            catch (MetadataException e) {
                                Cube c = (Cube)this.interpreterContext.getCube();
                                throw new InterpreterException("X01508", new String[]{c.getUniqueName(), ((Level)result).getDimension().getUniqueName(), result.toString(), e.toString()}, e);
                            }
                        }
                        if (result instanceof Hierarchy || result instanceof Dimension) {
                            try {
                                result = Caster.cast(result, Set[].class, this.getInterpreterContext());
                            }
                            catch (MetadataException e) {
                                String className = this.getClassNameCode(result.getClass().getSimpleName());
                                throw new InterpreterException("X01461", new String[]{className, "CMP_TYPESET"}, e);
                            }
                        }
                        if (!(result instanceof ResultSet)) {
                            String classCode = this.getClassNameCode(result.getClass().getSimpleName());
                            throw new InterpreterException("X01461", new String[]{classCode, "CMP_TYPESET"});
                        }
                        ResultSet rs = (ResultSet)result;
                        if (rs.isEmpty()) {
                            throw new InterpreterException("X01461", new String[]{"", "CMP_TYPESET"});
                        }
                        it = rs.iterator();
                        resultSets = new Set[rs.cellCount()];
                        boolean bl = false;
                        break block56;
                    }
                    result = node.jjtGetChild(0).accept(this, data);
                    break block50;
                }
                for (int i = 0; i < childCount - elementCount; ++i) {
                    void var11_36;
                    Cube c;
                    IMember iMember;
                    ITuple[] tups;
                    Object o = node.jjtGetChild(i).accept(this, data);
                    if (o instanceof ISet) {
                        if (((Set)o).isCurrentMemberSet()) {
                            ISet set = (ISet)o;
                            IDimension[] currMemberDims = ((Set)set).getCurrentMemberDimensions();
                            int n = (int)set.size();
                            Set[] nextSets = new Set[n];
                            for (int j = 0; j < n; ++j) {
                                nextSets[j] = new Set(set.getTuple(j));
                                nextSets[j].addCurrentMemberDimensions(currMemberDims);
                                nextSets[j].addCurrentMemberHierarchies(set.getTuple(j).getHierarchies());
                            }
                            currSets = this.unionSets(currSets, nextSets);
                            continue;
                        }
                        currSets = this.unionSets(currSets, new Set[]{(Set)o});
                        continue;
                    }
                    if (o instanceof Tuple) {
                        tups = new Tuple[]{(Tuple)o};
                        currSets = this.unionSets(currSets, new Set[]{new Set(tups)});
                        continue;
                    }
                    if (o instanceof Set[]) {
                        Set[] nextSets = (Set[])o;
                        currSets = this.unionSets(currSets, nextSets);
                        continue;
                    }
                    if (o instanceof Tuple[]) {
                        tups = (Tuple[])o;
                        currSets = this.unionSets(currSets, new Set[]{new Set(tups)});
                        continue;
                    }
                    if (o instanceof IMember) {
                        currSets = this.unionSets(currSets, new Set[]{new Set(new Tuple((IMember)o))});
                        continue;
                    }
                    if (o instanceof IMember[]) {
                        IMember[] mems = (IMember[])o;
                        for (int j = 0; j < mems.length; ++j) {
                            if (mems[j] == null) continue;
                            currSets = this.unionSets(currSets, new Set[]{new Set(new Tuple(mems[j]))});
                        }
                        continue;
                    }
                    if (o instanceof Hierarchy || o instanceof Dimension) {
                        try {
                            Set currMemberSet = (Set)Caster.cast(o, Set.class, this.getInterpreterContext());
                            currSets = this.unionSets(currSets, new Set[]{currMemberSet});
                            continue;
                        }
                        catch (MetadataException e) {
                            String className = this.getClassNameCode(o.getClass().getSimpleName());
                            throw new InterpreterException("X01461", new String[]{className, "CMP_TYPESET"}, e);
                        }
                    }
                    if (!(o instanceof String)) {
                        String className = this.getClassNameCode(o.getClass().getSimpleName());
                        throw new InterpreterException("X01433", new String[]{className, "CMP_TYPEHIERARCHY, CMP_TYPEDIMENSION, CMP_TYPEMEMBER, CMP_TYPESET, CMP_TYPETUPLE"});
                    }
                    ICalculationEngine calculationEngine = this.interpreterContext.getCalculationEngine();
                    NamedSet namedSet = calculationEngine.getNamedSet((String)o);
                    if (namedSet != null) {
                        Set[] setArray = namedSet.getSet(this.interpreterContext);
                        currSets = this.unionSets(currSets, setArray);
                        continue;
                    }
                    CalculatedMember calculatedMember = calculationEngine.getCalculatedMember((String)o);
                    if (calculatedMember != null || (iMember = (c = (Cube)this.interpreterContext.getCube()).findMember((String)o)) == null || iMember instanceof IMember) {
                        // empty if block
                    }
                    if (var11_36 == null) {
                        throw new InterpreterException("X01433", new String[]{(String)o, "CMP_TYPEMEMBER, CMP_TYPECALCMEMBER, CMP_TYPENAMEDSET"});
                    }
                    currSets = this.unionSets(currSets, new Set[]{new Set(new Tuple((IMember)var11_36))});
                }
                result = currSets;
                break block50;
            }
            while (var11_41 < resultSets.length) {
                Object resultObject = ((Cell)it.next()).getObjectValue();
                if (resultObject instanceof Dimension || resultObject instanceof Hierarchy) {
                    try {
                        resultSets[var11_41] = (Set)Caster.cast(resultObject, Set.class, this.getInterpreterContext());
                    }
                    catch (MetadataException e) {
                        String classCode = this.getClassNameCode(resultObject.getClass().getSimpleName());
                        throw new InterpreterException("X01461", new String[]{classCode, "CMP_TYPESET"}, e);
                    }
                } else if (resultObject instanceof Level) {
                    IMember[] members = ((Level)resultObject).getMembers().toArray(new IMember[0]);
                    resultSets[var11_41] = new Set(Tuple.createTupleList(members));
                } else {
                    if (!(resultObject instanceof IMember)) {
                        String classCode = this.getClassNameCode(resultObject.getClass().getSimpleName());
                        throw new InterpreterException("X01461", new String[]{classCode, "CMP_TYPESET"});
                    }
                    resultSets[var11_41] = new Set(new Tuple((IMember)resultObject));
                }
                ++var11_41;
            }
            result = resultSets;
        }
        if (elementCount > 0) {
            String setElement = node.getParameter("setElement");
            if (setElement != null && "true".equals(setElement)) {
                if (node.getParameterObject("elementSet") == null) {
                    node.setParameterObject("elementSet", result);
                } else {
                    node.setParameterObject("elementSet", null);
                }
            }
            node.setParameterObject("composite", result);
            for (int j = 0; j < childCount; ++j) {
                result = node.jjtGetChild(j).accept(this, data);
                node.setParameterObject("composite", result);
            }
            node.setParameterObject("composite", null);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object processTuple(ASTTuple node, int childCount, Object data) throws InterpreterException {
        int setCount;
        Set[] outputSets;
        Iterator<IMember> rightIt;
        Iterator<IMember> leftIt;
        IHierarchy[] cmh2;
        IDimension[] cmd2;
        IHierarchy[] cmh1;
        IDimension[] cmd1;
        void var4_20;
        block63: {
            Object var4_4 = null;
            XQEDebugLog.out.println("Tuple keyword: " + node.getKeyword());
            if (node.getKeyword() != null && "NewsCurrentDate".equals(node.getKeyword())) {
                return var4_20;
            }
            if (node.getKeyword() != null && "Tuple".equalsIgnoreCase(node.getKeyword())) {
                if (childCount <= 1) {
                    Object o = node.jjtGetChild(0).accept(this, data);
                    if (o instanceof IMember || o instanceof IMember[] || o instanceof ITuple || o instanceof ITuple[]) {
                        Object object = Caster.cast(o, Tuple[].class);
                        return var4_20;
                    }
                    if (o instanceof Set || o instanceof Set[] && ((Set[])o).length == 1) {
                        Object object = o;
                        return var4_20;
                    }
                    if (o instanceof ResultSet) {
                        Object object = Caster.cast(o, Set[].class);
                        return var4_20;
                    }
                    if (!(o instanceof Dimension) && !(o instanceof Hierarchy)) {
                        String classCode = this.getClassNameCode(o.getClass().getSimpleName());
                        throw new InterpreterException("X01461", new String[]{classCode, "CMP_TYPESET, CMP_TYPETUPLE"});
                    }
                    Object object = Caster.cast(o, Tuple[].class, this.interpreterContext);
                    return var4_20;
                }
            } else if (node.getKeyword() != null && "MemberRange".equalsIgnoreCase(node.getKeyword())) {
                IMember[] obj1 = node.jjtGetChild(0).accept(this, data);
                IMember[] obj2 = node.jjtGetChild(1).accept(this, data);
                cmd1 = null;
                cmh1 = null;
                cmd2 = null;
                cmh2 = null;
                if (obj2 instanceof Set) {
                    cmd2 = ((Set)obj2).getCurrentMemberDimensions();
                    cmh2 = ((Set)obj2).getCurrentMemberHierarchies();
                }
                if (obj1 instanceof Set) {
                    cmd1 = ((Set)obj1).getCurrentMemberDimensions();
                    cmh1 = ((Set)obj2).getCurrentMemberHierarchies();
                }
                if (Caster.isDownCastable(obj1, IMember.class, this.interpreterContext)) {
                    obj1 = Caster.castDown(obj1, IMember.class, this.interpreterContext);
                } else if (Caster.isDownCastable(obj1, IMember[].class, this.interpreterContext)) {
                    obj1 = Caster.castDown(obj1, IMember[].class, this.interpreterContext);
                }
                if (Caster.isDownCastable(obj2, IMember.class, this.interpreterContext)) {
                    obj2 = Caster.castDown(obj2, IMember.class, this.interpreterContext);
                } else if (Caster.isDownCastable(obj2, IMember[].class, this.interpreterContext)) {
                    obj2 = Caster.castDown(obj2, IMember[].class, this.interpreterContext);
                }
                if (obj1 instanceof IMember) {
                    obj1 = new IMember[]{(IMember)obj1};
                }
                if (obj2 instanceof IMember) {
                    obj2 = new IMember[]{(IMember)obj2};
                }
                if (!(obj1 instanceof IMember[]) || !(obj2 instanceof IMember[])) {
                    IMember[] invalidObj = !(obj1 instanceof IMember[]) ? obj1 : obj2;
                    throw new InterpreterException("X01461", new String[]{invalidObj.getClass().toString(), "IMember"});
                }
                List<IMember> left = Arrays.asList(obj1);
                List<IMember> right = Arrays.asList(obj2);
                leftIt = left.iterator();
                rightIt = right.iterator();
                if (left.size() != right.size()) {
                    // empty if block
                }
                outputSets = new Set[left.size()];
                setCount = 0;
                break block63;
            } else {
                Object o = node.jjtGetChild(0).accept(this, data);
                if (o instanceof NamedSet) {
                    Set[] setArray = ((NamedSet)o).getSet(this.interpreterContext);
                    return var4_20;
                }
                Object object = o;
                return var4_20;
            }
            Tuple[] theResult = null;
            IMetadata md = null;
            ISet s = new Set(new Tuple[0]);
            int i = 0;
            while (true) {
                block64: {
                    int j;
                    ITuple[] tuples;
                    Object it;
                    block72: {
                        ITuple[] tups;
                        IHierarchy currentHierarchy;
                        IDimension currentDimension;
                        IMember[] ms;
                        block70: {
                            block65: {
                                Object o;
                                block71: {
                                    block69: {
                                        block68: {
                                            block67: {
                                                block66: {
                                                    if (i >= childCount) break block65;
                                                    if (!(node.jjtGetChild(i) instanceof ASTElement)) break block66;
                                                    node.setParameterObject("tupleElement", s);
                                                    o = node.jjtGetChild(i).accept(this, data);
                                                    s = (Set)Caster.cast(o, Set.class);
                                                    break block64;
                                                }
                                                o = node.jjtGetChild(i).accept(this, data);
                                                if (!(o instanceof Set) || !((Set)o).isCurrentMemberSet()) break block67;
                                                s = ((Set)s).crossjoin((Set)o);
                                                break block64;
                                            }
                                            if (!(o instanceof IMetadata)) break block68;
                                            md = (IMetadata)o;
                                            if (md.getObjectType() == MetadataType.MEMBER) {
                                                s = ((Set)s).crossjoin(new Set(new Tuple((IMember)md)));
                                                break block64;
                                            } else {
                                                if (md.getObjectType() != MetadataType.DIMENSION) {
                                                    if (md.getObjectType() != MetadataType.HIERARCHY) return o;
                                                }
                                                try {
                                                    Set currMemberSet = (Set)Caster.cast(o, Set.class, this.getInterpreterContext());
                                                    s = ((Set)s).crossjoin(currMemberSet);
                                                }
                                                catch (MetadataException e) {
                                                    String classCode = this.getClassNameCode(o.getClass().getSimpleName());
                                                    throw new InterpreterException("X01461", new String[]{classCode, "CMP_TYPESET"}, e);
                                                }
                                            }
                                        }
                                        if (!(o instanceof IMember[])) break block69;
                                        ms = (IMember[])o;
                                        currentDimension = null;
                                        currentHierarchy = null;
                                        tups = new Tuple[ms.length];
                                        break block70;
                                    }
                                    if (!(o instanceof ResultSet)) break block71;
                                    ResultSet rs = (ResultSet)o;
                                    it = rs.iterator();
                                    tuples = new Tuple[rs.cellCount()];
                                    j = 0;
                                    break block72;
                                }
                                if (!(o instanceof Tuple) && !(o instanceof Tuple[])) {
                                    String classCode = this.getClassNameCode(o.getClass().getSimpleName());
                                    throw new InterpreterException("X01461", new String[]{classCode, "CMP_TYPETUPLE, CMP_TYPEMEMBER"});
                                }
                                if (o instanceof Tuple) {
                                    s = ((Set)s).crossjoin(new Set((Tuple)o), true);
                                    break block64;
                                } else if (o instanceof Tuple[]) {
                                    s = ((Set)s).crossjoin(new Set((Tuple[])o), true);
                                }
                                break block64;
                            }
                            if (theResult == null) {
                                if (s.size() > Integer.MAX_VALUE) {
                                    throw new InterpreterException("X01491");
                                }
                                Tuple[] tups2 = new Tuple[(int)s.size()];
                                int j2 = 0;
                                it = s.iterator();
                                while (it.hasNext()) {
                                    tups2[j2] = (Tuple)((ITuple)it.next()).copy();
                                    tups2[j2].addCurrentMemberDimensions(((Set)s).getCurrentMemberDimensions());
                                    ++j2;
                                }
                                theResult = tups2;
                            }
                            Tuple[] tupleArray = theResult;
                            return var4_20;
                        }
                        for (int j3 = 0; j3 < ms.length; ++j3) {
                            if (ms[j3] == null) {
                                tups[j3] = new Tuple();
                                continue;
                            }
                            tups[j3] = new Tuple(ms[j3]);
                            if (currentDimension == null) {
                                currentDimension = ms[j3].getDimension();
                            }
                            if (currentHierarchy != null) continue;
                            currentHierarchy = ms[j3].getHierarchy();
                        }
                        s = ((Set)s).crossjoin(new Set(tups));
                        if (currentDimension != null) {
                            ((Set)s).addCurrentMemberDimension(currentDimension);
                        }
                        if (currentHierarchy != null) {
                            ((Set)s).addCurrentMemberHierarchy(currentHierarchy);
                        }
                        break block64;
                    }
                    while (it.hasNext()) {
                        Cell c = (Cell)it.next();
                        Object cellValue = c.getObjectValue();
                        if (cellValue instanceof IMember) {
                            IMember m = (IMember)c.getObjectValue();
                            tuples[j++] = new Tuple(m);
                            continue;
                        }
                        if (!(cellValue instanceof Hierarchy)) continue;
                        Set currMemberSet = (Set)Caster.cast(cellValue, Set.class, this.getInterpreterContext());
                        s = ((Set)s).crossjoin(currMemberSet);
                    }
                    if (j > 0) {
                        s = ((Set)s).crossjoin(new Set(tuples));
                    }
                }
                ++i;
            }
        }
        while (leftIt.hasNext() && rightIt.hasNext()) {
            void var4_16;
            IMember[] siblings;
            List<IMember> siblingsList;
            IMember member1 = leftIt.next();
            IMember member2 = rightIt.next();
            boolean returnEmpty = false;
            if (member1 instanceof NullMember && !(member2 instanceof NullMember)) {
                siblingsList = member2.getLevel().getMembers();
                siblings = siblingsList.toArray(new IMember[0]);
                member1 = siblings[0];
            } else if (member2 instanceof NullMember && !(member1 instanceof NullMember)) {
                siblingsList = member1.getLevel().getMembers();
                siblings = siblingsList.toArray(new IMember[0]);
                member2 = siblings[siblings.length - 1];
            } else if (member1 instanceof NullMember && member2 instanceof NullMember) {
                returnEmpty = true;
            } else if (member1.getLevel() != member2.getLevel()) {
                throw new InterpreterException("X01430", new String[]{member1.getLevel().getName(), member2.getLevel().getName()});
            }
            if (!returnEmpty) {
                SecurityManagerInterface sec;
                IMember lastMember;
                IMember firstMember;
                Level level = (Level)member1.getLevel();
                if (level.getMemberIndex(member1) <= level.getMemberIndex(member2)) {
                    firstMember = member1;
                    lastMember = member2;
                } else {
                    firstMember = member2;
                    lastMember = member1;
                }
                ArrayList<Tuple> setTuples = new ArrayList<Tuple>();
                IMember memberInRange = firstMember;
                while (memberInRange != null && memberInRange != lastMember) {
                    setTuples.add(new Tuple(memberInRange));
                    memberInRange = ((IMemberCubics)memberInRange).getNextMember();
                }
                if (memberInRange == lastMember) {
                    setTuples.add(new Tuple(lastMember));
                }
                Set set = new Set(setTuples.toArray(new Tuple[0]));
                if (this.interpreterContext.getCube() != null && (sec = ((Cube)this.interpreterContext.getCube()).getSecurityManager(this.interpreterContext.getProvider())) != null) {
                    ISet[] input = new Set[]{set};
                    ISet[] output = sec.applySecurity(input, this.interpreterContext);
                    ISet iSet = output[0];
                }
            } else {
                Set set = new Set(new Tuple[0]);
            }
            outputSets[setCount] = (Set)var4_16;
            if (cmd1 != null) {
                outputSets[setCount].addCurrentMemberDimensions(cmd1);
            }
            if (cmd2 != null) {
                outputSets[setCount].addCurrentMemberDimensions(cmd2);
            }
            if (cmh1 != null) {
                outputSets[setCount].addCurrentMemberHierarchies(cmh1);
            }
            if (cmh2 != null) {
                outputSets[setCount].addCurrentMemberHierarchies(cmh2);
            }
            ++setCount;
        }
        Set[] setArray = outputSets;
        return var4_20;
    }

    private Object processComposite(ASTComposite node, int childCount, Object data) throws InterpreterException {
        Object result = null;
        node.setParameterObject("composite", null);
        for (int j = 0; j < childCount; ++j) {
            SimpleNode childNode = (SimpleNode)node.jjtGetChild(j);
            childNode.setParameterObject("lastCompositePart", j == childCount - 1);
            result = childNode.accept(this, data);
            node.setParameterObject("composite", result);
        }
        node.setParameterObject("composite", null);
        return result;
    }

    private Object processElement(ASTElement node, int childCount, Object data) throws InterpreterException {
        Object result = null;
        SimpleNode pn = (SimpleNode)node.jjtGetParent();
        result = pn.getParameterObject("composite");
        if (pn.getParameterObject("tupleElement") != null) {
            result = pn.getParameterObject("tupleElement");
        }
        result = this.processElement((SimpleNode)node, result, data);
        return result;
    }

    private Object processExpressionList(ASTExpressionList node, int childCount, Object data) throws InterpreterException {
        Object result = null;
        Integer index = (Integer)node.getParameterObject("parameterToFetch");
        result = node.jjtGetChild(index).accept(this, data);
        return result;
    }

    private Object processExpression(ASTExpression node, int childCount, Object data) throws InterpreterException {
        if (node.getNumberChildren() <= 0) {
            return null;
        }
        Object result = node.jjtGetChild(0).accept(this, data);
        if (node.getKeyword() != null && "InlineSet".equalsIgnoreCase(node.getKeyword())) {
            node.setParameter("InlineIdentifier", "true");
            String setName = (String)node.jjtGetChild(1).accept(this, data);
            Set[] sets = (Set[])Caster.cast(result, Set[].class);
            NamedSet namedSet = new NamedSet(setName, sets);
            ICalculationEngine calculationEngine = this.interpreterContext.getCalculationEngine();
            calculationEngine.addNamedSet(namedSet);
        }
        return result;
    }

    private Object processIfExpression(ASTIfExpression node, int childCount, Object data) throws InterpreterException {
        Object o;
        Object result = null;
        logger.log("ASTIf...");
        logger.log("Childcount: " + childCount);
        if (data == null) {
            logger.log("data: null");
        } else {
            logger.log("data: " + data.getClass());
        }
        if (data instanceof SearchConditionEvaluator) {
            SearchConditionEvaluator dataSce = (SearchConditionEvaluator)data;
            SearchConditionEvaluator ifSce = new SearchConditionEvaluator(dataSce.getSubject(), this.interpreterContext);
            o = node.jjtGetChild(0).accept(this, ifSce);
        } else {
            o = node.jjtGetChild(0).accept(this, data);
        }
        SearchConditionEvaluator sce = o instanceof Boolean ? new SearchConditionEvaluator(o, this.interpreterContext) : (o instanceof NullObject ? new SearchConditionEvaluator(Boolean.FALSE, this.interpreterContext) : (o instanceof Double ? new SearchConditionEvaluator(this.interpreterContext.getBooleanOperand(o), this.interpreterContext) : (SearchConditionEvaluator)o));
        Object subject = sce.getSubject();
        if (subject instanceof Boolean) {
            result = ((Boolean)subject).booleanValue() ? node.jjtGetChild(1).accept(this, data) : node.jjtGetChild(2).accept(this, data);
        } else if (subject instanceof Boolean[] && ((Boolean[])subject).length == 1) {
            result = ((Boolean[])subject)[0].booleanValue() ? node.jjtGetChild(1).accept(this, data) : node.jjtGetChild(2).accept(this, data);
        } else if (subject instanceof ResultSet) {
            ResultSet rs = (ResultSet)subject;
            ArrayList<Tuple> trueTuples = new ArrayList<Tuple>();
            ArrayList<Tuple> falseTuples = new ArrayList<Tuple>();
            ArrayList<Tuple> errorTuples = new ArrayList<Tuple>();
            ITupleValueIterator it = rs.tupleValueIterator();
            while (it.hasNext()) {
                TupleValue tv = (TupleValue)it.next();
                Cell cell = tv.getCell();
                if (cell.isBoolean()) {
                    if (cell.getBooleanValue()) {
                        trueTuples.add(tv.getTuple());
                        continue;
                    }
                    falseTuples.add(tv.getTuple());
                    continue;
                }
                Object cellValue = cell.getObjectValue();
                if (!ErrorCell.isErrorCell(cellValue)) continue;
                errorTuples.add(tv.getTuple());
            }
            Set trueSet = new Set(trueTuples.toArray(new Tuple[0]));
            Set falseSet = new Set(falseTuples.toArray(new Tuple[0]));
            Set errorSet = new Set(errorTuples.toArray(new Tuple[0]));
            boolean trueResultInFullContext = false;
            boolean falseResultInFullContext = false;
            CrossJoinedSet outputCJS = rs.getAxisCrossJoinedSet();
            ISet contextSet = this.interpreterContext.getContextSet();
            IDimension[] axisDims = outputCJS.getDimensions();
            contextSet = contextSet.removeDimensions(axisDims);
            rs = new ResultSet(new Set[]{outputCJS}, contextSet);
            boolean returnSearchCondition = false;
            ResultSet trueResults = null;
            if (trueSet.size() > 0L) {
                Object trueObj;
                this.interpreterContext.pushContext(trueSet);
                if (data instanceof SearchConditionEvaluator) {
                    SearchConditionEvaluator dataSce = (SearchConditionEvaluator)data;
                    SearchConditionEvaluator ifSce = new SearchConditionEvaluator(dataSce.getSubject(), this.interpreterContext);
                    trueObj = node.jjtGetChild(1).accept(this, ifSce);
                } else {
                    trueObj = node.jjtGetChild(1).accept(this, data);
                }
                if (trueObj instanceof SearchConditionEvaluator) {
                    trueObj = ((SearchConditionEvaluator)trueObj).getSubject();
                    returnSearchCondition = true;
                }
                if (trueObj instanceof IMember) {
                    trueObj = Caster.cast(trueObj, Set.class);
                    trueResults = this.setToResultSet((Set)trueObj);
                    trueResults.changeContextCMD(this.interpreterContext.getContextSet(), new Dimension[0]);
                    trueResultInFullContext = true;
                } else if (trueObj instanceof IDimension) {
                    IMember o2 = ((Dimension)trueObj).getDefaultHierarchy().getDefaultMember();
                    trueObj = Caster.cast(o2, Set.class);
                    trueResults = this.setToResultSet((Set)trueObj);
                    trueResults.changeContextCMD(this.interpreterContext.getContextSet(), new Dimension[0]);
                    trueResultInFullContext = true;
                } else if (trueObj instanceof Tuple[]) {
                    trueObj = Caster.cast(trueObj, Set.class);
                    trueResults = this.setToResultSet((Set)trueObj);
                    Dimension[] cmDimensions = ((Set)trueObj).getCurrentMemberDimensions();
                    if (cmDimensions != null && cmDimensions.length != 0) {
                        trueResults.changeContextCMD(this.interpreterContext.getContextSet(), cmDimensions);
                        trueResultInFullContext = true;
                    } else {
                        trueResults.changeContext(trueSet);
                    }
                } else if (trueObj instanceof IMember[]) {
                    trueObj = Caster.cast(trueObj, Set.class);
                    trueResults = this.setToResultSet((Set)trueObj);
                    trueResults.changeContext(trueSet);
                } else if (trueObj instanceof ResultSet) {
                    trueResults = (ResultSet)trueObj;
                    trueResults.changeContext(trueSet);
                } else if (trueObj instanceof Set) {
                    trueResults = this.setToResultSet((Set)trueObj);
                    trueResults.changeContext(trueSet);
                } else if (trueObj instanceof Set[] && ((Set[])trueObj).length == 1) {
                    trueResults = this.setToResultSet(((Set[])trueObj)[0]);
                    trueResults.changeContext(trueSet);
                } else if (trueObj instanceof TupleValue[]) {
                    trueResults = (ResultSet)Caster.cast(trueObj, ResultSet.class);
                    trueResults.changeContext(trueSet);
                } else if (trueObj instanceof String || trueObj instanceof Double) {
                    trueResults = new ResultSet(new Set[]{trueSet}, new Set(new Tuple[0]));
                    int j = 0;
                    while ((long)j < trueSet.size()) {
                        trueResults.addCell(new Cell(j, trueObj));
                        ++j;
                    }
                } else if (trueObj instanceof Integer) {
                    trueResults = new ResultSet(new Set[]{trueSet}, new Set(new Tuple[0]));
                    int j = 0;
                    while ((long)j < trueSet.size()) {
                        trueResults.addCell(new Cell(j, ((Integer)trueObj).doubleValue()));
                        ++j;
                    }
                } else if (trueObj == null || trueObj instanceof NullObject) {
                    trueResults = new ResultSet(new Set[]{trueSet}, new Set(new Tuple[0]));
                } else {
                    throw new InterpreterException("X01490", new String[]{trueObj.getClass().toString(), "IIF", "CMP_TYPENUMERIC, CMP_TYPESTRING, CMP_TYPESET, ..."});
                }
                this.interpreterContext.popContext();
                logger.log("true results: " + trueResults.getClass());
            }
            ResultSet falseResults = null;
            if (falseSet.size() > 0L) {
                Object falseObj;
                this.interpreterContext.pushContext(falseSet);
                if (data instanceof SearchConditionEvaluator) {
                    SearchConditionEvaluator dataSce = (SearchConditionEvaluator)data;
                    SearchConditionEvaluator ifSce = new SearchConditionEvaluator(dataSce.getSubject(), this.interpreterContext);
                    falseObj = node.jjtGetChild(2).accept(this, ifSce);
                } else {
                    falseObj = node.jjtGetChild(2).accept(this, data);
                }
                if (falseObj instanceof SearchConditionEvaluator) {
                    falseObj = ((SearchConditionEvaluator)falseObj).getSubject();
                }
                if (falseObj instanceof IMember) {
                    falseObj = Caster.cast(falseObj, Set.class);
                    falseResults = this.setToResultSet((Set)falseObj);
                    falseResults.changeContextCMD(this.interpreterContext.getContextSet(), new Dimension[0]);
                    falseResultInFullContext = true;
                } else if (falseObj instanceof IDimension) {
                    IMember o2 = ((Dimension)falseObj).getDefaultHierarchy().getDefaultMember();
                    falseObj = Caster.cast(o2, Set.class);
                    falseResults = this.setToResultSet((Set)falseObj);
                    falseResults.changeContextCMD(this.interpreterContext.getContextSet(), new Dimension[0]);
                    falseResultInFullContext = true;
                } else if (falseObj instanceof Tuple[]) {
                    falseObj = Caster.cast(falseObj, Set.class);
                    falseResults = this.setToResultSet((Set)falseObj);
                    Dimension[] cmDimensions = ((Set)falseObj).getCurrentMemberDimensions();
                    if (cmDimensions != null && cmDimensions.length != 0) {
                        falseResults.changeContextCMD(this.interpreterContext.getContextSet(), cmDimensions);
                        falseResultInFullContext = true;
                    } else {
                        falseResults.changeContext(falseSet);
                    }
                } else if (falseObj instanceof IMember[]) {
                    falseObj = Caster.cast(falseObj, Set.class);
                    falseResults = this.setToResultSet((Set)falseObj);
                    falseResults.changeContext(falseSet);
                } else if (falseObj instanceof ResultSet) {
                    falseResults = (ResultSet)falseObj;
                    falseResults.changeContext(falseSet);
                } else if (falseObj instanceof Set) {
                    falseResults = this.setToResultSet((Set)falseObj);
                    falseResults.changeContext(falseSet);
                } else if (falseObj instanceof TupleValue[]) {
                    falseResults = (ResultSet)Caster.cast(falseObj, ResultSet.class);
                    falseResults.changeContext(falseSet);
                } else if (falseObj instanceof String || falseObj instanceof Double) {
                    falseResults = new ResultSet(new Set[]{falseSet}, new Set(new Tuple[0]));
                    int j = 0;
                    while ((long)j < falseSet.size()) {
                        falseResults.addCell(new Cell(j, falseObj));
                        ++j;
                    }
                } else if (falseObj instanceof Integer) {
                    falseResults = new ResultSet(new Set[]{falseSet}, new Set(new Tuple[0]));
                    int j = 0;
                    while ((long)j < falseSet.size()) {
                        falseResults.addCell(new Cell(j, ((Integer)falseObj).doubleValue()));
                        ++j;
                    }
                } else if (falseObj == null || falseObj instanceof NullObject) {
                    falseResults = new ResultSet(new Set[]{falseSet}, new Set(new Tuple[0]));
                } else {
                    throw new InterpreterException("X01490", new String[]{falseObj.getClass().toString(), "IIF", "CMP_TYPENUMERIC, CMP_TYPESTRING, CMP_TYPESET, ..."});
                }
                this.interpreterContext.popContext();
                logger.log("false results: " + falseResults.getClass());
            }
            ResultSet errorResults = null;
            if (errorSet.size() > 0L) {
                errorResults = new ResultSet(new Set[]{errorSet}, new Set(new Tuple[0]));
                int i = 0;
                while ((long)i < errorSet.size()) {
                    Cell errorCell = new Cell(i, TextValue.ERROR_VALUE);
                    errorResults.addCell(errorCell);
                    ++i;
                }
            }
            ICube cube = this.interpreterContext.getCube();
            IDimension[] trueDims = new Dimension[]{};
            IDimension[] falseDims = new Dimension[]{};
            IDimension[] errorDims = new Dimension[]{};
            List<IDimension> dimList = cube.getDimensions();
            IHierarchy[] dimensionOrder = ((Cube)cube).getHierarchies().toArray(new Hierarchy[0]);
            trueDims = trueResults != null ? trueResults.getAxisCrossJoinedSet().getDimensions() : trueSet.getDimensions();
            falseDims = falseResults != null ? falseResults.getAxisCrossJoinedSet().getDimensions() : falseSet.getDimensions();
            if (errorResults != null) {
                Set s;
                errorDims = errorSet.getDimensions();
                if (trueResults != null) {
                    s = trueResults.getAxisCrossJoinedSet();
                    s = (Set)s.removeDimensions(errorDims);
                    errorResults.changeContext(s);
                }
                if (falseResults != null) {
                    s = falseResults.getAxisCrossJoinedSet();
                    s = (Set)s.removeDimensions(errorDims);
                    errorResults.changeContext(s);
                }
            }
            long ordinal = 0L;
            ArrayList<Tuple> tuples = new ArrayList<Tuple>();
            ArrayList<Cell> cells = new ArrayList<Cell>();
            CrossJoinedSet context = this.interpreterContext.getContextSet();
            long contextSize = context.size();
            long rsSize = 0L;
            CrossJoinedSet xjs = null;
            if (trueResults != null && falseResults == null) {
                xjs = trueResults.getAxisCrossJoinedSet();
                rsSize = xjs.size();
            }
            if (falseResults != null && trueResults == null) {
                xjs = falseResults.getAxisCrossJoinedSet();
                rsSize = xjs.size();
            }
            if (trueResultInFullContext || falseResultInFullContext) {
                Cell newCell;
                int i;
                long[] newOrdinals;
                Cell c;
                TupleValue tv;
                ResultSet rsz = new ResultSet(this.interpreterContext);
                ISet mapSet = this.interpreterContext.getContextSet().getMultipleTupleSets();
                Dimension[] mapDims = (Dimension[])mapSet.getDimensions();
                if (trueResults != null && !trueResults.isEmpty()) {
                    it = trueResults.tupleValueIterator(dimensionOrder);
                    while (it.hasNext()) {
                        tv = (TupleValue)it.next();
                        c = tv.getCell();
                        newOrdinals = mapSet.getOrdinals(tv.getTuple().retain(mapDims));
                        for (i = 0; i < newOrdinals.length; ++i) {
                            newCell = new Cell(c);
                            newCell.setOrdinal(newOrdinals[i]);
                            rsz.addCell(newCell);
                        }
                    }
                }
                if (falseResults != null && !falseResults.isEmpty()) {
                    it = falseResults.tupleValueIterator(dimensionOrder);
                    while (it.hasNext()) {
                        tv = (TupleValue)it.next();
                        c = tv.getCell();
                        newOrdinals = mapSet.getOrdinals(tv.getTuple().retain(mapDims));
                        for (i = 0; i < newOrdinals.length; ++i) {
                            newCell = new Cell(c);
                            newCell.setOrdinal(newOrdinals[i]);
                            rsz.addCell(newCell);
                        }
                    }
                }
                if (errorResults != null && !errorResults.isEmpty()) {
                    it = errorResults.tupleValueIterator(dimensionOrder);
                    while (it.hasNext()) {
                        tv = (TupleValue)it.next();
                        c = tv.getCell();
                        newOrdinals = mapSet.getOrdinals(tv.getTuple().retain(mapDims));
                        for (i = 0; i < newOrdinals.length; ++i) {
                            newCell = new Cell(c);
                            newCell.setOrdinal(newOrdinals[i]);
                            rsz.addCell(newCell);
                        }
                    }
                }
                result = rsz;
            } else {
                if (trueResults != null && falseResults == null && rsSize == contextSize || falseResults != null && trueResults == null && rsSize == contextSize) {
                    TupleValue tv;
                    Tuple orderedTuple;
                    IMember mem;
                    int m;
                    ITuple t;
                    ArrayList<IMember> al = new ArrayList<IMember>();
                    int n = 0;
                    while ((long)n < xjs.size()) {
                        t = xjs.getTuple(n);
                        for (m = 0; m < dimensionOrder.length; ++m) {
                            mem = t.getMember(dimensionOrder[m]);
                            al.add(mem);
                        }
                        orderedTuple = new Tuple(al.toArray(new IMember[0]));
                        al.clear();
                        tuples.add(orderedTuple);
                        ++n;
                    }
                    if (errorResults != null) {
                        xjs = errorResults.getAxisCrossJoinedSet();
                        n = 0;
                        while ((long)n < xjs.size()) {
                            t = xjs.getTuple(n);
                            for (m = 0; m < dimensionOrder.length; ++m) {
                                mem = t.getMember(dimensionOrder[m]);
                                al.add(mem);
                            }
                            orderedTuple = new Tuple(al.toArray(new IMember[0]));
                            al.clear();
                            tuples.add(orderedTuple);
                            ++n;
                        }
                    }
                    Set s1 = new Set(tuples.toArray(new Tuple[0]));
                    rs = new ResultSet(new Set[]{s1}, new Set(new Tuple[0]));
                    if (trueResults != null) {
                        it = trueResults.tupleValueIterator(dimensionOrder);
                    } else if (falseResults != null) {
                        it = falseResults.tupleValueIterator(dimensionOrder);
                    }
                    while (it.hasNext()) {
                        tv = (TupleValue)it.next();
                        rs.addCell(tv.getCell());
                    }
                    if (errorResults != null) {
                        it = errorResults.tupleValueIterator(dimensionOrder);
                        while (it.hasNext()) {
                            tv = (TupleValue)it.next();
                            rs.addCell(tv.getCell());
                        }
                    }
                } else {
                    Tuple orderedTuple;
                    IMember mem;
                    int m;
                    ITuple t;
                    int n;
                    ArrayList<IMember> al;
                    Cell c;
                    TupleValue tv;
                    if (trueResults != null) {
                        if (!trueResults.isEmpty()) {
                            it = trueResults.tupleValueIterator(dimensionOrder);
                            while (it.hasNext()) {
                                tv = (TupleValue)it.next();
                                tuples.add(tv.getTuple());
                                c = tv.getCell();
                                c.setOrdinal(ordinal++);
                                cells.add(c);
                            }
                        } else {
                            xjs = trueResults.getAxisCrossJoinedSet();
                            al = new ArrayList<IMember>();
                            n = 0;
                            while ((long)n < xjs.size()) {
                                t = xjs.getTuple(n);
                                for (m = 0; m < dimensionOrder.length; ++m) {
                                    mem = t.getMember(dimensionOrder[m]);
                                    al.add(mem);
                                }
                                orderedTuple = new Tuple(al.toArray(new IMember[0]));
                                al.clear();
                                tuples.add(orderedTuple);
                                ++ordinal;
                                ++n;
                            }
                        }
                    }
                    if (falseResults != null) {
                        if (!falseResults.isEmpty()) {
                            it = falseResults.tupleValueIterator(dimensionOrder);
                            while (it.hasNext()) {
                                tv = (TupleValue)it.next();
                                tuples.add(tv.getTuple());
                                c = tv.getCell();
                                c.setOrdinal(ordinal++);
                                cells.add(c);
                            }
                        } else {
                            xjs = falseResults.getAxisCrossJoinedSet();
                            al = new ArrayList();
                            n = 0;
                            while ((long)n < xjs.size()) {
                                t = xjs.getTuple(n);
                                for (m = 0; m < dimensionOrder.length; ++m) {
                                    mem = t.getMember(dimensionOrder[m]);
                                    al.add(mem);
                                }
                                orderedTuple = new Tuple(al.toArray(new IMember[0]));
                                al.clear();
                                tuples.add(orderedTuple);
                                ++ordinal;
                                ++n;
                            }
                        }
                    }
                    if (errorResults != null) {
                        it = errorResults.tupleValueIterator(dimensionOrder);
                        while (it.hasNext()) {
                            tv = (TupleValue)it.next();
                            tuples.add(tv.getTuple());
                            c = tv.getCell();
                            c.setOrdinal(ordinal++);
                            cells.add(c);
                        }
                    }
                    Set s1 = new Set(tuples.toArray(new Tuple[0]));
                    rs = new ResultSet(new Set[]{s1}, new Set(new Tuple[0]));
                    Iterator cellIt = cells.iterator();
                    while (cellIt.hasNext()) {
                        rs.addCell((Cell)cellIt.next());
                    }
                    IDimension[] rsMultiSetDims = new Dimension[]{};
                    IDimension[] removeDims = this.interpreterContext.getContextSet().getDimensions();
                    if (rs != null) {
                        rsMultiSetDims = rs.getAxisCrossJoinedSet().getMultipleTupleSets().getDimensions();
                    }
                    ISet rsSet = this.interpreterContext.getContextSet().removeDimensions(removeDims);
                    Dimension[] mapDims = (Dimension[])rsSet.getDimensions();
                    ISet rsAxes = rsSet.getMultipleTupleSets();
                    ISet[] mapAxes = !rsAxes.isEmpty() ? new ISet[]{rsAxes} : new Set[]{};
                    ISet mapSlicer = rsSet.getSingleTupleSet();
                    if (rs != null) {
                        mapSlicer = rs.getAxisCrossJoinedSet().getSingleTupleSet();
                    }
                    ResultSet rsz = new ResultSet(mapAxes, mapSlicer);
                    CrossJoinedSet mapSet = new CrossJoinedSet(mapAxes);
                    if (trueResults != null && !rs.isEmpty()) {
                        it = rs.tupleValueIterator(dimensionOrder);
                        while (it.hasNext()) {
                            TupleValue tv2 = (TupleValue)it.next();
                            Cell c2 = tv2.getCell();
                            long[] newOrdinals = mapSet.getOrdinals(tv2.getTuple().retain(mapDims));
                            for (int i = 0; i < newOrdinals.length; ++i) {
                                Cell newCell = new Cell(c2);
                                newCell.setOrdinal(newOrdinals[i]);
                                rsz.addCell(newCell);
                            }
                            rs = rsz;
                        }
                    }
                }
                result = rs;
            }
            if (returnSearchCondition && data instanceof SearchConditionEvaluator) {
                result = new SearchConditionEvaluator(rs, this.interpreterContext);
            }
        } else {
            throw new InterpreterException("X01461", new String[]{subject.getClass().toString(), "..."});
        }
        logger.log("o:" + o.getClass());
        if (result != null) {
            logger.log("IIF result:" + result.getClass());
        } else {
            logger.log("IIF result:null");
        }
        return result;
    }

    private Object processNumericValueExpression(ASTNumericValueExpression node, int childCount, Object data) throws InterpreterException {
        Tuple[] tuples;
        Object term2;
        Object term1;
        String sign = node.getParameter("sign");
        if (data instanceof SearchConditionEvaluator) {
            term1 = node.jjtGetChild(0).accept(this, data);
            term2 = node.jjtGetChild(1).accept(this, data);
        } else {
            term1 = node.jjtGetChild(0).accept(this, null);
            term2 = node.jjtGetChild(1).accept(this, null);
        }
        Dimension[] term1CMdims = null;
        Dimension[] term2CMdims = null;
        if (Caster.isCastable(term1, Set.class)) {
            if (term1 instanceof Set) {
                term1CMdims = ((Set)term1).getCurrentMemberDimensions();
            } else if (term1 instanceof Tuple[] && (tuples = (Tuple[])term1).length > 0) {
                term1CMdims = tuples[0].getCurrentMemberDimensions();
            }
            if (!(term1 instanceof ResultSet)) {
                term1 = this.setToResultSet((Set)Caster.cast(term1, Set.class));
                if (term1CMdims != null && term1CMdims.length > 0) {
                    ((ResultSet)term1).changeContextCMD(this.interpreterContext.getContextSet(), term1CMdims);
                }
            }
        }
        if (Caster.isCastable(term2, Set.class)) {
            if (term2 instanceof Set) {
                term2CMdims = ((Set)term2).getCurrentMemberDimensions();
            } else if (term2 instanceof Tuple[] && (tuples = (Tuple[])term2).length > 0) {
                term2CMdims = tuples[0].getCurrentMemberDimensions();
            }
            if (!(term2 instanceof ResultSet)) {
                term2 = this.setToResultSet((Set)Caster.cast(term2, Set.class));
                if (term2CMdims != null && term2CMdims.length > 0) {
                    ((ResultSet)term2).changeContextCMD(this.interpreterContext.getContextSet(), term2CMdims);
                }
            }
        }
        ICube cube = this.getInterpreterContext().getCube();
        Object result = "-".equals(sign) ? new ResultSetProcessor(cube).performSimpleOp(this.interpreterContext, term1, term2, 22) : new ResultSetProcessor(cube).performSimpleOp(this.interpreterContext, term2, term1, 20);
        return result;
    }

    private Object processTerm(ASTTerm node, int childCount, Object data) throws InterpreterException {
        Object factor2;
        Object factor1;
        Object result = new Object();
        if (data instanceof SearchConditionEvaluator) {
            factor1 = node.jjtGetChild(0).accept(this, data);
            factor2 = node.jjtGetChild(1).accept(this, data);
        } else {
            factor1 = node.jjtGetChild(0).accept(this, null);
            factor2 = node.jjtGetChild(1).accept(this, null);
        }
        String sign = node.getParameter("sign");
        if ("*".equals(sign) && (factor1 instanceof Set[] || factor1 instanceof Set || factor2 instanceof Set[] || factor2 instanceof Set)) {
            Set[] s1 = (Set[])Caster.cast(factor1, Set[].class);
            Set[] s2 = (Set[])Caster.cast(factor2, Set[].class);
            Set[] sets = new Set[s1.length * s2.length];
            for (int j = 0; j < s1.length; ++j) {
                for (int k = 0; k < s2.length; ++k) {
                    sets[j * s1.length + k] = s1[j].crossjoin(s2[k]);
                }
            }
            result = sets;
        } else {
            Tuple[] tuples;
            Dimension[] factor1CMdims = null;
            Dimension[] factor2CMdims = null;
            if (Caster.isCastable(factor1, Set.class)) {
                if (factor1 instanceof Set) {
                    factor1CMdims = ((Set)factor1).getCurrentMemberDimensions();
                } else if (factor1 instanceof Tuple[] && (tuples = (Tuple[])factor1).length > 0) {
                    factor1CMdims = tuples[0].getCurrentMemberDimensions();
                }
                if (!(factor1 instanceof ResultSet)) {
                    factor1 = this.setToResultSet((Set)Caster.cast(factor1, Set.class));
                    if (factor1CMdims != null) {
                        ((ResultSet)factor1).changeContextCMD(this.interpreterContext.getContextSet(), factor1CMdims);
                    }
                }
            }
            if (Caster.isCastable(factor2, Set.class)) {
                if (factor2 instanceof Set) {
                    factor2CMdims = ((Set)factor2).getCurrentMemberDimensions();
                } else if (factor2 instanceof Tuple[] && (tuples = (Tuple[])factor2).length > 0) {
                    factor2CMdims = tuples[0].getCurrentMemberDimensions();
                }
                if (!(factor2 instanceof ResultSet)) {
                    factor2 = this.setToResultSet((Set)Caster.cast(factor2, Set.class));
                    if (factor2CMdims != null) {
                        ((ResultSet)factor2).changeContextCMD(this.interpreterContext.getContextSet(), factor2CMdims);
                    }
                }
            }
            ICube cube = this.getInterpreterContext().getCube();
            if ("*".equals(sign)) {
                result = new ResultSetProcessor(cube).performSimpleOp(this.interpreterContext, factor1, factor2, 26);
            } else if ("/".equals(sign)) {
                result = new ResultSetProcessor(cube).performSimpleOp(this.interpreterContext, factor1, factor2, 24);
            } else if ("%".equals(sign)) {
                result = new ResultSetProcessor(cube).performSimpleOp(this.interpreterContext, factor1, factor2, 28);
            }
        }
        return result;
    }

    private Object processFactor(ASTFactor node, int childCount, Object data) throws InterpreterException {
        Object o;
        Object result = null;
        double factor = 1.0;
        String sign = node.getParameter("sign");
        if (sign != null && "-".equals(sign)) {
            factor = -1.0;
        }
        if ((o = node.jjtGetChild(0).accept(this, data)) instanceof Double) {
            Double value = (Double)o;
            result = new Double(value * factor);
        } else {
            result = o;
        }
        return result;
    }

    private Object processValueExpressionPrimary(ASTValueExpressionPrimary node, int childCount, Object data) throws InterpreterException {
        Node subNode = node.jjtGetChild(0);
        Object o = subNode instanceof ASTMDXNode ? ((ASTMDXNode)subNode).getText() : subNode.accept(this, data);
        Object result = o;
        if (childCount > 1) {
            node.setParameterObject("composite", result);
            for (int j = 0; j < childCount; ++j) {
                result = node.jjtGetChild(j).accept(this, data);
                node.setParameterObject("composite", result);
            }
            node.setParameterObject("composite", null);
        }
        return result;
    }

    private Object processStringValueExpressionPrimary(ASTStringValueExpressionPrimary node, int childCount, Object data) throws InterpreterException {
        Object result;
        Node subNode = node.jjtGetChild(0);
        if (subNode instanceof ASTMDXNode) {
            String s = ((ASTMDXNode)subNode).getText();
            s = s.substring(1, s.length() - 1);
            result = s;
        } else {
            result = node.jjtGetChild(0).accept(this, data);
        }
        return result;
    }

    private Object processUnsignedNumericLiteral(ASTUnsignedNumericLiteral node, int childCount, Object data) throws InterpreterException {
        String literal = node.getParameter("literal");
        return new Double(literal);
    }

    private Object processStringValueExpression(ASTStringValueExpression node, int childCount, Object data) throws InterpreterException {
        Node subNode = node.jjtGetChild(0);
        Object result = subNode.accept(this, data);
        if (result instanceof String) {
            String str = (String)result;
            if (!str.trim().startsWith("'") || !str.trim().endsWith("'")) {
                result = Interpreter.unescapeQuotes((String)result);
            } else if (str.trim().startsWith("'") || str.trim().endsWith("'") && str.length() > 2) {
                result = Interpreter.unescapeQuotes2((String)result);
            }
        }
        return result;
    }

    private Object processSearchCondition(ASTSearchCondition node, int childCount, Object data) throws InterpreterException {
        return null;
    }

    private Object processBooleanTerm(ASTBooleanTerm node, int childCount, Object data) throws InterpreterException {
        return null;
    }

    private Object processBooleanFactor(ASTBooleanFactor node, int childCount, Object data) throws InterpreterException {
        return null;
    }

    private Object processBooleanPrimary(ASTBooleanPrimary node, int childCount, Object data) throws InterpreterException {
        return null;
    }

    private Object processMDXNode(ASTMDXNode node, int childCount, Object data) throws InterpreterException {
        if (node.getParent() instanceof ASTElement) {
            return node;
        }
        return node.getText();
    }

    private Object processCellProps(ASTCellProps node, int childCount, Object data) throws InterpreterException {
        for (int j = 0; j < childCount; ++j) {
            node.jjtGetChild(j).accept(this, data);
        }
        return null;
    }

    private Object processCellProperty(ASTCellProperty node, int childCount, Object data) throws InterpreterException {
        Object result = node.jjtGetChild(0).accept(this, data);
        String cellPropertyName = (String)result;
        logger.log("Cell Property:" + cellPropertyName);
        SelectQuery sq = (SelectQuery)this.getQuery();
        sq.addCellProperty(cellPropertyName.toUpperCase());
        return result;
    }

    private static class HierarchyInfo {
        private IHierarchy hierForAllMembersInList = null;
        private boolean hasMultipleHierarchies = false;

        private HierarchyInfo() {
        }

        public void track(IHierarchy hier) {
            if (this.hierForAllMembersInList == null) {
                this.hierForAllMembersInList = hier;
            } else if (!this.hierForAllMembersInList.equals(hier)) {
                this.hasMultipleHierarchies = true;
            }
        }

        public void track(IDimension dim) {
            if (dim.getHierarchyCount() == 1) {
                this.track(dim.getHierarchy(0));
            } else {
                this.hasMultipleHierarchies = true;
            }
        }

        public IHierarchy getHierarchy() {
            if (this.hasMultipleHierarchies) {
                return null;
            }
            return this.hierForAllMembersInList;
        }
    }
}

