/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.XMdxNode;
import com.cognos.xqe.runtree.olap.mdx.data.IXmlSerializable;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CalculationCache;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CalculationEngine;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ICalculationEngine;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NamedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullObject;
import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSetConfiguration;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SelectQuery;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Session;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SetEvaluator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Member;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.Provider;
import com.cognos.xqe.runtree.olap.mdx.util.OrdinalMath;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.MapCast;
import com.cognos.xqe.util.primitive.ArrayListLong;
import com.cognos.xqe.util.xml.XMLWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class InterpreterContext
implements IXmlSerializable {
    private Session session;
    private ICalculationEngine calculationEngine;
    private CalculationCache calculationCache;
    private CalculationCache primingCache;
    private final Stack<ResultSetConfiguration> rsConfig = new Stack();
    private boolean deferredGettingValue;
    private final OrdinalMath ordinalMath;
    private ICube cube;
    private final Provider provider;
    private QueryStrategy queryStrategy;
    private QueryContext queryContext;
    private ConcurrentMap<XMdxNode, XMdxNode> cacheableNodeList = new ConcurrentHashMap<XMdxNode, XMdxNode>();
    private String interpreterSubject = "";
    private boolean deferCustomSetExecution;
    private PrimingInfo primingInfo;
    private final ArrayList<ContextInfo> contextStack = new ArrayList();
    private XDataContext dataContext;
    private XDataContext parentDataContext;
    private CalculatedMember refCalcMember;
    private boolean evaluatingNamedSet;
    private ArrayList<IHierarchy[]> queryAxesHierarchies;

    public boolean isDeferredGettingValue() {
        return this.deferredGettingValue;
    }

    public void setDeferredGettingValue(boolean value) {
        this.deferredGettingValue = value;
    }

    public void setInterpreterSubject(String interpreterSubjectValue) {
        this.interpreterSubject = interpreterSubjectValue;
    }

    public String getInterpreterSubject() {
        return this.interpreterSubject;
    }

    public boolean isDeferCustomSetExecution() {
        return this.deferCustomSetExecution;
    }

    public void setDeferCustomSetExecution(boolean bValue) {
        this.deferCustomSetExecution = bValue;
    }

    public void setSession(Session s) {
        this.session = s;
    }

    public Session getSession() {
        return this.session;
    }

    public void setQueryContext(QueryContext qc) {
        this.queryContext = qc;
    }

    public QueryContext getQueryContext() {
        return this.queryContext;
    }

    public void setEvaluatingNamedSet(boolean evalNamedSet) {
        this.evaluatingNamedSet = evalNamedSet;
    }

    public boolean getEvaluatingNamedSet() {
        return this.evaluatingNamedSet;
    }

    public boolean isCanceled() {
        if (this.queryContext != null) {
            return this.queryContext.isCanceled();
        }
        return false;
    }

    public void exceptIfCanceled() throws InterpreterException {
        if (this.isCanceled()) {
            throw new InterpreterException("X59999", this.queryContext.getCancelMsgParms(), 5L);
        }
    }

    public InterpreterContext(Provider p) {
        this(p, null);
    }

    public InterpreterContext(Provider p, ICalculationEngine ce) {
        this.provider = p;
        this.calculationCache = new CalculationCache();
        this.primingCache = new CalculationCache();
        this.calculationEngine = ce;
        this.ordinalMath = new OrdinalMath();
        this.pushResultSetConfiguration();
        this.primingInfo = new PrimingInfo();
    }

    public InterpreterContext(InterpreterContext toClone, CrossJoinedSet newContext) throws InterpreterException {
        this.session = toClone.session;
        this.cube = toClone.cube;
        this.provider = toClone.provider;
        this.queryContext = toClone.queryContext;
        this.queryStrategy = toClone.queryStrategy;
        this.contextStack.add(new ContextInfo(newContext));
        if (toClone.inPrimingPhase()) {
            this.queryStrategy = toClone.calculationEngine.getQueryStrategy();
            this.calculationEngine = toClone.calculationEngine.clone(this);
        } else {
            this.calculationEngine = toClone.calculationEngine.clone(this);
        }
        this.calculationCache = toClone.calculationCache;
        this.primingCache = toClone.primingCache;
        this.dataContext = toClone.dataContext;
        this.refCalcMember = toClone.refCalcMember;
        this.deferredGettingValue = toClone.deferredGettingValue;
        this.queryAxesHierarchies = toClone.queryAxesHierarchies;
        this.ordinalMath = toClone.ordinalMath;
        this.pushResultSetConfiguration();
        this.primingInfo = toClone.primingInfo;
        this.interpreterSubject = toClone.interpreterSubject;
    }

    public InterpreterContext(InterpreterContext toClone) throws InterpreterException {
        this.session = toClone.session;
        this.cube = toClone.cube;
        this.provider = toClone.provider;
        this.queryContext = toClone.queryContext;
        this.queryStrategy = toClone.queryStrategy;
        this.contextStack.addAll(toClone.contextStack);
        this.calculationEngine = toClone.calculationEngine.clone(this);
        this.calculationCache = toClone.calculationCache;
        this.primingCache = toClone.primingCache;
        this.dataContext = toClone.dataContext;
        this.refCalcMember = toClone.refCalcMember;
        this.deferredGettingValue = toClone.deferredGettingValue;
        this.queryAxesHierarchies = toClone.queryAxesHierarchies;
        this.cacheableNodeList = toClone.cacheableNodeList;
        this.parentDataContext = toClone.dataContext;
        this.ordinalMath = toClone.ordinalMath;
        this.rsConfig.addAll(toClone.rsConfig);
        this.primingInfo = toClone.primingInfo;
    }

    public void setCube(ICube c) throws InterpreterException {
        if (this.cube != null) {
            throw new InterpreterException("X01497");
        }
        this.cube = c;
        this.provider.lockCube(c);
        if (this.calculationEngine == null) {
            this.calculationEngine = new CalculationEngine();
        }
        if (!this.calculationEngine.isInitialized()) {
            this.calculationEngine.initialize(this);
        }
        if (this.session != null) {
            Map<String, CalculatedMember> sessionObjects = this.session.getSessionObjects();
            XQEDebugLog.out.println(" sessionObjects.size()=" + sessionObjects.size());
            java.util.Set<Map.Entry<String, CalculatedMember>> entries = sessionObjects.entrySet();
            for (Map.Entry<String, CalculatedMember> e : entries) {
                NamedSet set;
                CalculatedMember sessionObject = e.getValue();
                XQEDebugLog.out.println("  Precession sessionObject " + sessionObject);
                if (sessionObject instanceof CalculatedMember) {
                    CalculatedMember mem = sessionObject;
                    XQEDebugLog.out.println("  Precession calc " + mem.getUniqueName());
                    if (mem.getDimension().getCube() != c) continue;
                    XQEDebugLog.out.println("    Adding session calc " + mem.getUniqueName());
                    this.calculationEngine.addCalculatedMember(mem);
                    continue;
                }
                if (!(sessionObject instanceof NamedSet) || (set = (NamedSet)((Object)sessionObject)).getCubeName() != null && !set.getCubeName().equals(c.getName())) continue;
                this.calculationEngine.addNamedSet(set);
            }
        }
        if (this.dataContext != null) {
            HashSet<String> nativeProperties;
            Map dimProperties = MapCast.uncheckedCast((Map)this.dataContext.getProperty("axesDimensionProperties"));
            if (dimProperties == null) {
                dimProperties = new HashMap();
            }
            if ((nativeProperties = (HashSet<String>)dimProperties.get("nativeProperties")) == null) {
                nativeProperties = new HashSet<String>();
            }
            nativeProperties.add("PARENT_LEVEL");
            nativeProperties.add("PARENT_UNIQUE_NAME");
            dimProperties.put("nativeProperties", nativeProperties);
            this.dataContext.setProperty("axesDimensionProperties", dimProperties);
        }
        IMember[] mems = new IMember[this.cube.getDimensionCount()];
        for (int j = 0; j < mems.length; ++j) {
            try {
                Dimension dimension = (Dimension)this.cube.getDimension(j);
                mems[j] = dimension.isAttributeDimension() ? dimension.getDummyMember(dimension.getDefaultHierarchy()) : dimension.getDefaultHierarchy().getDefaultMember();
                if (mems[j] != null) continue;
                XQEDebugLog.out.println("Dimension " + dimension.getUniqueName() + " contains no default member. Creating empty initial context");
                continue;
            }
            catch (MetadataException e) {
                throw new InterpreterException("X01408", new String[]{""}, e);
            }
        }
        Tuple tuple = new Tuple(mems, this.cube);
        ISet[] contextSets = new Set[]{new Set(tuple)};
        this.contextStack.add(new ContextInfo(new CrossJoinedSet(contextSets)));
    }

    public SelectQuery createSelectQuery() {
        SelectQuery result = new SelectQuery(this.calculationEngine);
        result.setCube(this.cube);
        return result;
    }

    public int getContextStackDepth() {
        return this.contextStack.size();
    }

    public CrossJoinedSet getContextSet(int atDepth) {
        ContextInfo ctxtInfo = this.contextStack.get(atDepth);
        return ctxtInfo.set;
    }

    public CrossJoinedSet getContextSet() {
        ContextInfo ctxtInfo = this.contextStack.get(this.topContextIndex());
        return ctxtInfo.set;
    }

    public CrossJoinedSet getRootContextSet() {
        ContextInfo ctxtInfo = this.contextStack.get(0);
        return ctxtInfo.set;
    }

    public ContextInfo getContext() {
        return this.contextStack.get(this.topContextIndex());
    }

    public boolean hasContextSet() {
        return this.contextStack != null && this.contextStack.size() > 0;
    }

    public void pushContext(Set s) throws InterpreterException {
        CrossJoinedSet cjs = this.getContextSet();
        cjs = cjs.mergeSet(s);
        ContextInfo ctxtInfo = new ContextInfo(cjs);
        this.contextStack.add(ctxtInfo);
    }

    public void pushContext(Set s, IMember removeMe) throws InterpreterException {
        CrossJoinedSet cjs = this.getContextSet();
        cjs = cjs.mergeSet(s);
        cjs = (CrossJoinedSet)cjs.removeHierarchy(removeMe.getHierarchy(), true);
        ContextInfo ctxtInfo = new ContextInfo(cjs);
        this.contextStack.add(ctxtInfo);
    }

    public void pushContext(ContextInfo ctxtInfo) throws InterpreterException {
        this.contextStack.add(ctxtInfo);
    }

    public void popContext() {
        this.contextStack.remove(this.topContextIndex());
    }

    private int topContextIndex() {
        return this.contextStack.size() - 1;
    }

    public void setInitialContextSet(CrossJoinedSet contextSet) {
        if (this.contextStack.size() > 1) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Attempt to set initial context stack once already set.");
        }
        if (!this.contextStack.isEmpty()) {
            this.contextStack.clear();
        }
        this.contextStack.add(new ContextInfo(contextSet));
    }

    public ICube getCube() {
        return this.cube;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public ICalculationEngine getCalculationEngine() {
        return this.calculationEngine;
    }

    public CalculationCache getCalculationCache() {
        return this.calculationCache;
    }

    public void setCalculationCache(CalculationCache toClone) {
        this.calculationCache = toClone;
    }

    public CalculationCache getPrimingCache() {
        return this.primingCache;
    }

    public void setPrimingnCache(CalculationCache toClone) {
        this.primingCache = toClone;
    }

    public IResultSet setToResultSet(Set componentSet) throws InterpreterException {
        IDimension[] dims = componentSet.getDimensions();
        ISet s = this.getContextSet();
        s = s.removeDimensions(dims, false);
        SetEvaluator se = new SetEvaluator(this);
        IResultSet rs = se.getSetResults(componentSet, s);
        return rs;
    }

    public Boolean getBooleanOperand(Object o) throws InterpreterException {
        if (o == null || o instanceof NullObject) {
            return Boolean.FALSE;
        }
        if (o instanceof Value) {
            Value v = (Value)o;
            if (v.isNull()) {
                return Boolean.FALSE;
            }
            if (v.isNumeric()) {
                if (v.getDouble() == 0.0) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            return v.getBoolean();
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Double) {
            if ((Double)o == 0.0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (o instanceof String) {
            return Boolean.valueOf((String)o);
        }
        throw new InterpreterException("X01490", new String[]{o.getClass().toString(), "getBooleanOperand", "String, Boolean, Double"});
    }

    public Double getDoubleOperand(Object o) throws InterpreterException {
        if (o == null || o instanceof NullObject) {
            return 0.0;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof Boolean) {
            if (!((Boolean)o).booleanValue()) {
                return 0.0;
            }
            return 1.0;
        }
        if (o instanceof String) {
            return Double.valueOf((String)o);
        }
        throw new InterpreterException("X01490", new String[]{o.getClass().getSimpleName(), "getDoubleOperand", "CMP_TYPENUMERIC"});
    }

    public Double getDoubleOperand(Object o, ParameterFetcher parameterFetcher) throws InterpreterException {
        if (o == null || o instanceof NullObject) {
            return 0.0;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof Boolean) {
            if (!((Boolean)o).booleanValue()) {
                return 0.0;
            }
            return 1.0;
        }
        if (o instanceof String) {
            try {
                return Double.valueOf((String)o);
            }
            catch (NumberFormatException e) {
                String paramName = ParameterFetcher.getParameterName(o);
                throw new InterpreterException("X01490", new String[]{paramName, parameterFetcher.getFunction().getName(), "CMP_TYPENUMERIC"}, e);
            }
        }
        String paramName = ParameterFetcher.getParameterName(o);
        throw new InterpreterException("X01490", new String[]{paramName, parameterFetcher.getFunction().getName(), "CMP_TYPENUMERIC"});
    }

    public XDataContext getXDataContext() {
        return this.dataContext;
    }

    public void setXDataContext(XDataContext context) {
        this.dataContext = context;
    }

    @Override
    public void toXML(XMLWriter xmlWriter) {
        xmlWriter.beginElement("InterpreterContext", -1);
        this.getContextSet().toXML(xmlWriter);
        xmlWriter.endElement();
    }

    public void setRefCalcMember(CalculatedMember calcMember) {
        this.refCalcMember = calcMember;
    }

    public CalculatedMember getRefCalcMember() {
        return this.refCalcMember;
    }

    public CalculatedMember getSelfReferencedCalcMember(String identifier) {
        if (this.refCalcMember != null && this.refCalcMember.getUniqueName().equals(identifier)) {
            return this.refCalcMember;
        }
        return null;
    }

    public void pushPartialContext(Block b, Set nonDegSubset) throws InterpreterException {
        ArrayList<Set> newContextSets = new ArrayList<Set>();
        CrossJoinedSet cjs = this.getContextSet();
        Set[] sets = cjs.getSets();
        for (int i = 0; i < sets.length; ++i) {
            if (!b.isDegenerated(i)) continue;
            newContextSets.add(sets[i]);
        }
        newContextSets.add(nonDegSubset);
        ISet[] ss = newContextSets.toArray(new Set[0]);
        CrossJoinedSet newContextSet = new CrossJoinedSet(ss);
        ContextInfo newContextInfo = new ContextInfo(newContextSet);
        newContextInfo.setuSetCount(1);
        if (nonDegSubset instanceof CrossJoinedSet) {
            newContextInfo.setuSetCount(((CrossJoinedSet)nonDegSubset).getSets().length);
        }
        this.contextStack.add(newContextInfo);
    }

    public void setQueryStrategy(QueryStrategy qs) {
        this.queryStrategy = qs;
    }

    public QueryStrategy getQueryStrategy() {
        return this.queryStrategy;
    }

    public void addCacheableNode(XMdxNode node) {
        this.cacheableNodeList.put(node, node);
    }

    public void removeCacheableNode(XMdxNode node) {
        this.cacheableNodeList.remove(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableAncestorNodesCache() {
        for (XMdxNode node : this.cacheableNodeList.values()) {
            node.setParameterObject("cacheable", Boolean.FALSE, this.getXDataContext());
            if (this.parentDataContext == null) continue;
            XDataContext xDataContext = this.parentDataContext;
            synchronized (xDataContext) {
                node.setParameterObject("cacheable", Boolean.FALSE, this.parentDataContext);
            }
        }
    }

    public OrdinalMath getOrdinalMath() {
        return this.ordinalMath;
    }

    public ResultSetConfiguration getResultSetConfiguration() {
        return this.rsConfig.peek();
    }

    public ResultSetConfiguration pushResultSetConfiguration() {
        return this.rsConfig.push(new ResultSetConfiguration());
    }

    public ResultSetConfiguration popResultSetConfiguration() {
        return this.rsConfig.pop();
    }

    public void setQueryAxesHierarchies(ISet[] queryAxes) {
        if (queryAxes != null) {
            if (this.queryAxesHierarchies == null) {
                this.queryAxesHierarchies = new ArrayList();
            } else {
                this.queryAxesHierarchies.clear();
            }
            for (ISet queryAxis : queryAxes) {
                this.queryAxesHierarchies.add(queryAxis.getHierarchies());
            }
        }
    }

    public ArrayList<IHierarchy[]> getQueryAxesHierarchies() {
        return this.queryAxesHierarchies;
    }

    public boolean inPrimingPhase() {
        return this.primingInfo != null && this.primingInfo.inPrimingPhase();
    }

    public PrimingInfo getPrimingInfo() {
        return this.primingInfo;
    }

    public void initPrimingInfo(Map<String, Integer> calcToPrimingModeMap) {
        this.primingInfo = new PrimingInfo(calcToPrimingModeMap);
    }

    public class PrimingInfo {
        public static final int NOT_PRIMABLE = 0;
        public static final int PRIME_WRONG_MEMBERS = 1;
        public static final int PRIME_WRONG_VALUES = 2;
        public static final int PRIMABLE = 3;
        protected int primingMode = -1;
        private Map<String, Integer> calcToPrimingModeMap;
        private HashSet<Member> primedCalcs = new HashSet();
        boolean readyToPrime = true;

        public PrimingInfo(Map<String, Integer> map) {
            this.calcToPrimingModeMap = map;
        }

        public PrimingInfo() {
        }

        public boolean isPrimingEnabled() {
            return this.calcToPrimingModeMap != null;
        }

        public void setCalcToPrimingModeMap(Map<String, Integer> map) {
            this.calcToPrimingModeMap = map;
        }

        public Map<String, Integer> getCalcToPrimingModeMap() {
            return this.calcToPrimingModeMap;
        }

        public void addPrimedCalc(CalculatedMember cm) {
            this.primedCalcs.add(cm);
        }

        public HashSet<Member> getPrimedCalcs() {
            return this.primedCalcs;
        }

        public boolean inPrimingPhase() {
            return this.primingMode > 0;
        }

        public int getPrimingMode() {
            return this.primingMode;
        }

        public void setPrimingMode(int i) {
            this.primingMode = i;
        }

        public void setReadyToPrime(boolean b) {
            this.readyToPrime = b;
        }

        public boolean readyToPrime() {
            return this.readyToPrime;
        }
    }

    public class ContextInfo {
        protected CrossJoinedSet set;
        protected ArrayListLong prevContextMap;
        private int uSetCount;
        protected CrossJoinedSet expSet;
        protected ArrayListLong expPrevContextMap;
        protected int expuSetCount;
        protected boolean[] expandedSets;
        protected ArrayListLong insNextContextMap;

        public int getuSetCount() {
            return this.uSetCount;
        }

        public void setuSetCount(int uSetCountArg) {
            this.uSetCount = uSetCountArg;
        }

        public ContextInfo(CrossJoinedSet contextSet) {
            this.set = contextSet;
        }

        public boolean hasExpandedSets() {
            return this.expSet != null;
        }
    }
}

