/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.util.concurrent.ThreadPool;
import com.cognos.xqe.util.primitive.HashSetInt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;

public class MemberLevelInfo {
    public static final int DEFAULT_MEMBERS_PER_TASK = 700000;
    private static int membersPerTask = 700000;
    private static final int MAX_TASKS = 16;
    private final Map<IHierarchy, int[]> hierToLevelMemberCount = new HashMap<IHierarchy, int[]>();
    private CrossJoinedSet cjs = null;
    private IMember[][] members = null;

    public MemberLevelInfo(CrossJoinedSet theCjs) {
        this.cjs = theCjs;
    }

    public MemberLevelInfo(IMember[][] theMembers) {
        this.members = theMembers;
    }

    public MemberLevelInfo(List<ILevel> levels) {
        for (ILevel level : levels) {
            IHierarchy hier = level.getHierarchy();
            int[] hierMemberCountByLevel = new int[hier.getLevelCount()];
            Arrays.fill(hierMemberCountByLevel, 0);
            hierMemberCountByLevel[level.getIndex()] = level.getCardinality();
            this.hierToLevelMemberCount.put(hier, hierMemberCountByLevel);
        }
    }

    public HashSetInt getLevelIndexes(IHierarchy h) {
        int[] memberCountAtLevel = this.getLevelMemberCount(h);
        HashSetInt levels = new HashSetInt();
        for (int i = 0; i < memberCountAtLevel.length; ++i) {
            if (memberCountAtLevel[i] <= 0) continue;
            levels.add(i);
        }
        return levels;
    }

    public int getMemberCount(IHierarchy h, int levelIndex) {
        int[] memberCountByLevel = this.getLevelMemberCount(h);
        return memberCountByLevel[levelIndex];
    }

    public boolean isLevelComplete(IHierarchy h, int levelIndex) {
        int levelCardinality;
        int memberCountAtLevel = this.getMemberCount(h, levelIndex);
        return memberCountAtLevel == (levelCardinality = h.getLevel(levelIndex).getCardinality());
    }

    public void selectionsSubsetted(IMember[][] newMembers) {
        if (this.members == null) {
            throw new UnsupportedOperationException("Can only use subsetting when built with IMember[][] for now");
        }
        for (int i = 0; i < newMembers.length; ++i) {
            if (newMembers[i].length == this.members[i].length || this.members[i].length <= 0) continue;
            IHierarchy h = this.members[i][0].getHierarchy();
            if (newMembers[i].length == 0) {
                this.hierToLevelMemberCount.remove(h);
                continue;
            }
            if (!this.doesInformationExist(h)) continue;
            HashSetInt levelIndexes = this.getLevelIndexes(h);
            if (this.getLevelIndexes(h).size() == 1) {
                int[] levelMemberCount = this.getLevelMemberCount(h);
                int levelIndex = levelIndexes.iterator().next();
                levelMemberCount[levelIndex] = newMembers[i].length;
                continue;
            }
            this.hierToLevelMemberCount.remove(h);
        }
        this.members = newMembers;
    }

    public void populateFrom(MemberLevelInfo other) {
        for (Map.Entry<IHierarchy, int[]> entry : other.hierToLevelMemberCount.entrySet()) {
            int[] otherLevelMemberCount = entry.getValue();
            int[] levelMemberCount = new int[otherLevelMemberCount.length];
            System.arraycopy(otherLevelMemberCount, 0, levelMemberCount, 0, levelMemberCount.length);
            this.hierToLevelMemberCount.put(entry.getKey(), levelMemberCount);
        }
    }

    public boolean doesInformationExist(IHierarchy h) {
        return this.hierToLevelMemberCount.containsKey(h);
    }

    private int[] getLevelMemberCount(IHierarchy h) {
        int[] memberCountAtLevel = this.hierToLevelMemberCount.get(h);
        if (memberCountAtLevel == null) {
            memberCountAtLevel = new int[h.getLevelCount()];
            Arrays.fill(memberCountAtLevel, 0);
            IMember[] hierMembers = null;
            if (this.cjs != null) {
                hierMembers = this.cjs.getMembers(h);
            } else if (this.members != null) {
                for (IMember[] mems : this.members) {
                    if (mems.length <= 0 || mems[0].getHierarchy() != h) continue;
                    hierMembers = mems;
                    break;
                }
            }
            if (hierMembers != null) {
                List<MemberLevelCounterTask> tasks = this.buildTasks(hierMembers, h.getLevelCount());
                if (tasks.size() == 1) {
                    memberCountAtLevel = tasks.get(0).call();
                } else {
                    ThreadPool threadPool = ThreadPool.getInstance();
                    ExecutorCompletionService<int[]> ecs = new ExecutorCompletionService<int[]>(threadPool);
                    for (MemberLevelCounterTask task : tasks) {
                        ecs.submit(task);
                    }
                    for (int i = 0; i < tasks.size(); ++i) {
                        int[] taskValues;
                        try {
                            taskValues = (int[])ecs.take().get();
                        }
                        catch (InterruptedException e) {
                            throw new XQERuntimeException(e);
                        }
                        catch (ExecutionException e) {
                            throw new XQERuntimeException(e);
                        }
                        for (int j = 0; j < memberCountAtLevel.length; ++j) {
                            memberCountAtLevel[j] = memberCountAtLevel[j] + taskValues[j];
                        }
                    }
                }
            }
            this.hierToLevelMemberCount.put(h, memberCountAtLevel);
        }
        return memberCountAtLevel;
    }

    private List<MemberLevelCounterTask> buildTasks(IMember[] hierMembers, int numLevels) {
        ArrayList<MemberLevelCounterTask> tasks = new ArrayList<MemberLevelCounterTask>();
        int taskCount = this.calcTaskCount(hierMembers);
        int mbrsPerTask = hierMembers.length / taskCount;
        int startIndex = 0;
        for (int i = 0; i < taskCount; ++i) {
            int endIndex = startIndex + mbrsPerTask;
            if (i == taskCount - 1) {
                endIndex = hierMembers.length;
            }
            tasks.add(new MemberLevelCounterTask(hierMembers, startIndex, endIndex, numLevels));
            startIndex = endIndex;
        }
        return tasks;
    }

    private int calcTaskCount(IMember[] hierMembers) {
        int tasks = hierMembers.length / membersPerTask;
        if (tasks == 0) {
            return 1;
        }
        if (tasks > 16) {
            return 16;
        }
        return tasks;
    }

    public static void setMembersPerTask(int mbrsPerTask) {
        membersPerTask = mbrsPerTask;
    }

    private static class MemberLevelCounterTask
    implements Callable<int[]> {
        private final IMember[] mbrs;
        private final int startIndex;
        private final int endIndex;
        private final int levelCount;

        MemberLevelCounterTask(IMember[] members, int startIdx, int endIdx, int numLevels) {
            this.mbrs = members;
            this.startIndex = startIdx;
            this.endIndex = endIdx;
            this.levelCount = numLevels;
        }

        @Override
        public int[] call() {
            int[] memberCountByLevel = new int[this.levelCount];
            for (int i = this.startIndex; i < this.endIndex; ++i) {
                int n = this.mbrs[i].getLevel().getIndex();
                memberCountByLevel[n] = memberCountByLevel[n] + 1;
            }
            return memberCountByLevel;
        }

        public String toString() {
            return "MemberLevelCounterTask @ index " + String.valueOf(this.startIndex);
        }
    }
}

