/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;

public enum NullBehavior {
    ZERO("zero"),
    ZERO_FIRST("zero_first"),
    ZERO_LAST("zero_last"),
    ZERO_STABLE_ELSE_FIRST("zero_stable_else_first"),
    ZERO_STABLE_ELSE_LAST("zero_stable_else_last"),
    NULL_FIRST("null_first"),
    NULL_LAST("null_last"),
    SQL("null"),
    FALSE("false");

    private String keywordValue;

    private NullBehavior(String value) {
        this.keywordValue = value;
    }

    public String getKeywordValue() {
        return this.keywordValue;
    }

    public static NullBehavior convertStringToNullBehavior(String keyword) {
        for (NullBehavior nb : NullBehavior.values()) {
            if (!nb.getKeywordValue().equals(keyword)) continue;
            return nb;
        }
        return null;
    }

    public static NullBehavior getDataSourceNullBehavior(InterpreterContext interpreterContext, String keyword, NullBehavior defaultBehavior) {
        NullBehavior behavior;
        IDataSource dataSource = interpreterContext.getXDataContext().getEnvironment().getDataSource();
        String key = null;
        String strNullHandling = null;
        if (dataSource != null) {
            if (dataSource.isROLAP()) {
                key = "RO";
            } else if (dataSource.isRelational()) {
                key = "DMR";
            }
            IDataSourceCapabilities providerCapabilities = null;
            providerCapabilities = key != null ? ProviderCapabilites.getInstance().getOrAddProviderCapabilities(key) : dataSource.getCapabilities();
            strNullHandling = providerCapabilities.getStringValue(keyword, defaultBehavior.getKeywordValue());
        }
        if ((behavior = NullBehavior.convertStringToNullBehavior(strNullHandling)) != null) {
            return behavior;
        }
        return defaultBehavior;
    }

    public static NullBehavior getDataSourceNullOrderBehavior(IDataSourceCapabilities capabilities, NullBehavior defaultBehavior) {
        String strNullHandling = Boolean.FALSE.toString();
        String strNullPosition = "FIRST";
        strNullHandling = capabilities.getStringValue("null.order.function", ZERO.toString());
        strNullPosition = capabilities.getStringValue("null.position.order.function", "FIRST");
        if (strNullHandling.equalsIgnoreCase(SQL.getKeywordValue())) {
            if (strNullPosition.equalsIgnoreCase("STABLE_ELSE_FIRST")) {
                return NULL_FIRST;
            }
            if (strNullPosition.equalsIgnoreCase("STABLE_ELSE_LAST")) {
                return NULL_LAST;
            }
            if (strNullPosition.equalsIgnoreCase("FIRST")) {
                return NULL_FIRST;
            }
            if (strNullPosition.equalsIgnoreCase("LAST")) {
                return NULL_LAST;
            }
            return defaultBehavior;
        }
        if (strNullHandling.equalsIgnoreCase(ZERO.getKeywordValue()) && strNullPosition.equalsIgnoreCase("STABLE_ELSE_FIRST")) {
            return ZERO_STABLE_ELSE_FIRST;
        }
        if (strNullHandling.equalsIgnoreCase(ZERO.getKeywordValue()) && strNullPosition.equalsIgnoreCase("STABLE_ELSE_LAST")) {
            return ZERO_STABLE_ELSE_LAST;
        }
        if (strNullPosition.equalsIgnoreCase("LAST")) {
            return ZERO_LAST;
        }
        if (strNullPosition.equalsIgnoreCase("FIRST")) {
            return ZERO_FIRST;
        }
        return defaultBehavior;
    }
}

