/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.AbstractResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BCell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ICompleteResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSetIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSetCellIteratorDecorator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSetDownsizeDelegate;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSetGenericDelegate;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSetMetadata;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ValueIterator;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Property;
import com.cognos.xqe.runtree.olap.mdx.storage.ICellStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.InMemoryCellStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.InStreamCellStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.IBlockTupleStorage;
import com.cognos.xqe.runtree.olap.mdx.util.AdditiveCellCombiner;
import com.cognos.xqe.runtree.olap.mdx.util.CellCombiner;
import com.cognos.xqe.runtree.olap.mdx.util.CompareNumbers;
import com.cognos.xqe.runtree.olap.mdx.util.ICellCombiner;
import com.cognos.xqe.runtree.olap.mdx.util.MaxCellCombiner;
import com.cognos.xqe.runtree.olap.mdx.util.MinCellCombiner;
import com.cognos.xqe.runtree.olap.mdx.util.NoopCellCombiner;
import com.cognos.xqe.runtree.olap.mdx.util.NumberOp;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.pool.XQESoftLongPool;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ResultSet
extends AbstractResultSet
implements ICompleteResultSet {
    private static final String HTML_COLON = " : ";
    private static final int MAGIC_NUMBER_10 = 10;
    private static final boolean USE_DISK_CELL_STORAGE = false;
    private ICellStorage cellMap;
    private Cell[][] cellCache = null;
    private static final int DEFAULT_ORDINAL_CACHE_BLOCK_SIZE = 100;
    private static final double CELL_RATIO_FOR_SPARSE_CACHE = 0.6;
    private int ordinalCacheBlockSize = 100;
    private long ordinalCount = -1L;
    private boolean ignoreChangeContext = false;
    private static final long MAX_NUMBER_OF_CELLS_ALLOWED_IN_MEMORY = ResultSet.getInStreamCellStorageThreshold(5000000L);
    private static final ICell NULL_CELL_PLACE_HOLDER = new Cell(-1L, DoubleValue.NULL_VALUE);

    public ResultSet() {
    }

    private ICellStorage createCellStorage(long numberOfCells, IBlockTupleStorage blockStorage) {
        if (blockStorage == null || numberOfCells > 0L && numberOfCells < MAX_NUMBER_OF_CELLS_ALLOWED_IN_MEMORY) {
            return new InMemoryCellStorage(this);
        }
        return new InStreamCellStorage(this, blockStorage);
    }

    private static long getInStreamCellStorageThreshold(long defaultValue) {
        IDataSource ds;
        long threshold = defaultValue;
        ExecutionEnvironment ee = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (ee != null && (ds = ee.getDataSource()) != null) {
            String thresholdString = ds.getCapabilities().getStringValue("mdx.cjs.maxCellsInMemory.threshold", Long.toString(threshold));
            try {
                threshold = Long.valueOf(thresholdString);
            }
            catch (NumberFormatException e) {
                throw new XQERuntimeException(XQEMessageKeys.MDX_InvalidPropertyValue, (Object)thresholdString, (Object)"mdx.cjs.maxCellsInMemory.threshold", (Object)Integer.class.getSimpleName());
            }
        }
        return threshold;
    }

    public void setIgnoreChangeContext(boolean ignoreChangeCtxt) {
        this.ignoreChangeContext = ignoreChangeCtxt;
    }

    public ResultSet(CrossJoinedSet qs) {
        super(qs);
        this.initializeCellStorage(this.size(), null);
    }

    public ResultSet(ISet[] a, ISet s) {
        super(a, s);
        this.initializeCellStorage(this.size(), null);
    }

    public ResultSet(InterpreterContext interpreterContext) {
        super(interpreterContext);
        this.initializeCellStorage(this.size(), null);
    }

    protected ResultSet(AbstractResultSet rs) {
        super(rs);
        this.initializeCellStorage(this.size(), null);
        for (ICell c : rs) {
            this.addCell((Cell)c);
        }
    }

    private void initializeCellStorage(long numberOfCells, IBlockTupleStorage storage) {
        this.cellMap = this.createCellStorage(numberOfCells, storage);
    }

    public IResultSet copy() {
        ISet[] axes = this.metadata.getAxes();
        ResultSet rs = new ResultSet(axes, this.metadata.getSlicer());
        rs.setDefaultValue(this.getDefaultValue());
        for (Map.Entry<String, CalculatedMember> entry : this.getCalcMembers().entrySet()) {
            rs.getCalcMembers().put(entry.getKey(), entry.getValue());
        }
        ArrayList[] propList = new ArrayList[axes.length];
        for (int i = 0; i < axes.length; ++i) {
            propList[i] = this.getPropertiesOnAxis(i, false);
        }
        rs.setPropertiesOnAxes(propList);
        rs.addCurrentMemberDimensions(this.getCurrentMemberDimensions());
        rs.setCellProperties(this.getCellProperties());
        for (Cell c : this) {
            if (c.getOrdinal() == -123L) {
                rs.addCell(new BCell(c, c.getBigOrdinal()));
                continue;
            }
            rs.addCell(new Cell(c));
        }
        return rs;
    }

    public ArrayList<IProperty> getPropertiesOnAxis(int axisNumber) {
        return this.getPropertiesOnAxis(axisNumber, true);
    }

    public ArrayList<IProperty> getPropertiesOnAxis(int axisNumber, boolean unique) {
        ArrayList[] axisToProperties = (ArrayList[])this.propertyMap.get("axisToProperties");
        if (axisToProperties != null) {
            HashSet<String> alreadySeenName = new HashSet<String>();
            ArrayList result = new ArrayList();
            ArrayList candidates = axisToProperties[axisNumber];
            if (candidates != null) {
                if (!unique) {
                    result = candidates;
                } else {
                    for (Property prop : candidates) {
                        String name;
                        if (prop == null || alreadySeenName.contains(name = prop.getName())) continue;
                        result.add(prop);
                        alreadySeenName.add(name);
                    }
                }
            }
            return result;
        }
        return null;
    }

    @Override
    public void putCell(Number ordinal, Cell cell) {
        if (ordinal == null) {
            ordinal = cell.getOrdinal() == -123L ? cell.getBigOrdinal() : XQESoftLongPool.getLong(cell.getOrdinal());
        }
        this.cellMap.put(ordinal, cell);
    }

    @Override
    public void addCell(ITuple tuple, Cell c) {
        this.addCell(tuple, c, null);
    }

    public void addCell(List<TupleValue> tupleValues) {
        for (TupleValue tupleValue : tupleValues) {
            this.addCell(tupleValue.getTuple(), tupleValue.getCell());
        }
    }

    public void removeCell(long ordinal) {
        Cell cell = this.getCellAtOrdinal(ordinal);
        if (cell == null) {
            return;
        }
        this.cellMap.remove(ordinal);
    }

    @Override
    public int cellCount() {
        return this.cellMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.cellMap.size() == 0;
    }

    @Override
    public IResultSetIterator iterator() {
        return new ResultSetCellIteratorDecorator(this.cellMap.getCellIterator());
    }

    public ValueIterator valueIterator() {
        return new ResultSetValueIterator();
    }

    public Dimension[] getCurrentMemberDimensions() {
        HashSet currentMemberDimensions = (HashSet)this.propertyMap.get("currentMemberDimensions");
        if (currentMemberDimensions == null) {
            return new Dimension[0];
        }
        return currentMemberDimensions.toArray(new Dimension[0]);
    }

    public void printVerbose() {
        this.metadata.printVerbose();
        XQEDebugLog.out.println("Cellset ");
        this.print();
    }

    private Cell getCachedCell(long index) {
        int blockIndex = (int)(index / (long)this.ordinalCacheBlockSize);
        Cell[] block = this.cellCache[blockIndex];
        if (block == null) {
            return null;
        }
        int cellInBlockIndex = (int)(index % (long)this.ordinalCacheBlockSize);
        return block[cellInBlockIndex];
    }

    @Override
    public void setCachedCell(long index, Cell c) {
        if (this.cellCache != null) {
            int blockIndex = (int)(index / (long)this.ordinalCacheBlockSize);
            Cell[] block = this.cellCache[blockIndex];
            if (block == null) {
                block = new Cell[this.ordinalCacheBlockSize];
                this.cellCache[blockIndex] = block;
            }
            int cellInBlockIndex = (int)(index % (long)this.ordinalCacheBlockSize);
            block[cellInBlockIndex] = c;
        }
    }

    public boolean useCellCache() {
        if (this.cellCache == null) {
            this.ordinalCount = this.size();
            if (this.ordinalCount < 0L) {
                return false;
            }
            int cellCount = this.cellCount();
            double cellRatio = (long)cellCount / this.ordinalCount;
            return this.ordinalCount < Integer.MAX_VALUE || !(cellRatio < 0.6);
        }
        return true;
    }

    @Override
    public Cell getCellAtOrdinal(long ordinal) {
        Cell result = null;
        if (this.cellMap.size() == 0) {
            return null;
        }
        if (!this.useCellCache()) {
            return (Cell)this.cellMap.get(ordinal);
        }
        if (this.cellCache == null) {
            this.ordinalCount = this.size();
            this.ordinalCacheBlockSize = 100;
            int blocks = 1;
            if (this.ordinalCount > (long)this.ordinalCacheBlockSize) {
                while (this.ordinalCount / (long)this.ordinalCacheBlockSize + 1L > Integer.MAX_VALUE) {
                    this.ordinalCacheBlockSize *= 10;
                }
                blocks = (int)(this.ordinalCount / (long)this.ordinalCacheBlockSize) + 1;
            }
            this.cellCache = new Cell[blocks][];
            for (Cell cell : this) {
                long cellOrdinal = cell.getOrdinal();
                this.setCachedCell(cellOrdinal, cell);
                if (ordinal != cellOrdinal) continue;
                result = cell;
            }
        } else {
            result = this.getCachedCell(ordinal);
        }
        return result;
    }

    public Cell getCellAtTupleOrdinal(long[] tupleOrdinal) {
        long[] setSizes = this.getQuerySet().getSetSizesInReverseOrder();
        long aCellOrdinal = ResultSetMetadata.computeCellOrdinal(tupleOrdinal, setSizes);
        if (aCellOrdinal == Long.MIN_VALUE) {
            Number[] numberTupleOrdinal = new Number[tupleOrdinal.length];
            Number[] numberSetSizes = this.getQuerySet().getSetSizesInReverseOrder(true);
            for (int j = 0; j < tupleOrdinal.length; ++j) {
                numberTupleOrdinal[j] = XQESoftLongPool.getLong(tupleOrdinal[j]);
            }
            Number numberCellOrdinal = ResultSetMetadata.computeCellOrdinal(numberTupleOrdinal, numberSetSizes);
            return (Cell)this.cellMap.get(numberCellOrdinal);
        }
        return this.getCellAtOrdinal(aCellOrdinal);
    }

    public void print() {
        XQEDebugLog.out.println("Result Set:");
        for (Cell cell : this) {
            XQEDebugLog.out.println("\t" + cell.getOrdinal() + HTML_COLON + cell.getStringValue());
        }
    }

    @Deprecated
    public void changeContext(Set contextSet) throws InterpreterException {
        if (this.ignoreChangeContext) {
            return;
        }
        this.metadata.moveContextSingleSelectionsToSlicer(contextSet);
        ISet multiTupleSet = contextSet.getMultipleTupleSets();
        if (multiTupleSet.size() > 0L && multiTupleSet.getTuple(0L).size() > 0) {
            ISet slicer = this.metadata.getSlicer();
            ISet[] axes = this.metadata.getAxes();
            IHierarchy[] hiers = multiTupleSet.getHierarchies();
            for (int i = 0; i < hiers.length; ++i) {
                if (slicer.contains(hiers[i])) {
                    slicer = slicer.removeHierarchy(hiers[i], true);
                    this.metadata.setSlicer(slicer);
                }
                for (int j = 0; j < axes.length; ++j) {
                    if (!axes[j].contains(hiers[i])) continue;
                    multiTupleSet = multiTupleSet.removeHierarchy(hiers[i], true);
                }
            }
            if (axes.length == 0) {
                axes = new ISet[]{multiTupleSet};
                this.metadata.setAxes(axes);
            } else {
                axes[0] = ((Set)axes[0]).crossjoin(multiTupleSet);
            }
            IResultSetIterator it = this.iterator();
            InMemoryCellStorage newCellSet = new InMemoryCellStorage(this);
            while (it.hasNext()) {
                Cell c = (Cell)it.next();
                long ordinal = c.getOrdinal();
                ordinal *= multiTupleSet.size();
                for (long i = 0L; i < multiTupleSet.size(); ++i) {
                    Cell newCell = new Cell(c);
                    newCell.setOrdinal(ordinal++);
                    newCellSet.put(newCell.getOrdinal(), newCell);
                }
            }
            this.cellMap = newCellSet;
            this.cellCache = null;
        }
    }

    @Deprecated
    public void changeContextCMD(Set contextSet, Dimension[] theCurrentMemberDimensions) throws InterpreterException {
        if (this.ignoreChangeContext) {
            return;
        }
        this.metadata.moveAxesSingleSelectionsToSlicer(theCurrentMemberDimensions);
        this.metadata.moveContextSingleSelectionsToSlicer(contextSet);
        ISet multiTupleSet = contextSet.getMultipleTupleSets();
        if (multiTupleSet.size() > 0L && multiTupleSet.getTuple(0L).size() > 0) {
            ISet[] axes = this.metadata.getAxes();
            ISet[] sets = new Set[axes.length];
            for (int i = 0; i < axes.length; ++i) {
                sets[i] = axes[axes.length - i - 1];
            }
            CrossJoinedSet axisSet = new CrossJoinedSet(sets);
            ArrayList<Dimension> currentMemberMultiTupleDims = new ArrayList<Dimension>();
            ((Set)axisSet).getDimensions();
            for (int i = 0; i < theCurrentMemberDimensions.length; ++i) {
                if (!axisSet.contains((IDimension)theCurrentMemberDimensions[i])) continue;
                currentMemberMultiTupleDims.add(theCurrentMemberDimensions[i]);
            }
            ArrayList<ISet> mapSets = new ArrayList<ISet>();
            for (int setIdx = 0; setIdx < sets.length; ++setIdx) {
                ISet axesSet = sets[setIdx];
                ISet[] nextMapSets = axesSet instanceof CrossJoinedSet ? ((CrossJoinedSet)axesSet).getSets() : new ISet[]{axesSet};
                for (int nextMapSetIdx = 0; nextMapSetIdx < nextMapSets.length; ++nextMapSetIdx) {
                    int dimIdx;
                    IDimension[] nextMapSetDims = nextMapSets[nextMapSetIdx].getDimensions();
                    boolean[] isCmd = new boolean[nextMapSetDims.length];
                    int cmdCount = 0;
                    for (dimIdx = 0; dimIdx < nextMapSetDims.length; ++dimIdx) {
                        if (currentMemberMultiTupleDims.contains(nextMapSetDims[dimIdx])) {
                            isCmd[dimIdx] = true;
                            ++cmdCount;
                            continue;
                        }
                        isCmd[dimIdx] = false;
                    }
                    if (cmdCount == 0) {
                        mapSets.add(nextMapSets[nextMapSetIdx]);
                        continue;
                    }
                    if (cmdCount == nextMapSetDims.length) {
                        IMember[][] currentMembers = ((Set)multiTupleSet).getMembers(nextMapSetDims);
                        for (int dimIdx2 = 0; dimIdx2 < nextMapSetDims.length; ++dimIdx2) {
                            mapSets.add(new Set(Tuple.createTupleList(currentMembers[dimIdx2])));
                        }
                        continue;
                    }
                    for (dimIdx = 0; dimIdx < nextMapSetDims.length; ++dimIdx) {
                        if (currentMemberMultiTupleDims.contains(nextMapSetDims[dimIdx])) {
                            IMember[] currentMembers = multiTupleSet.getMembers(nextMapSetDims[dimIdx]);
                            mapSets.add(new Set(Tuple.createTupleList(currentMembers)));
                            continue;
                        }
                        mapSets.add(((Set)nextMapSets[nextMapSetIdx]).extract(new IDimension[]{nextMapSetDims[dimIdx]}, false));
                    }
                }
            }
            CrossJoinedSet mapSet = new CrossJoinedSet(mapSets.toArray(new ISet[0]));
            ISet slicer = this.metadata.getSlicer();
            IDimension[] mapDims = (Dimension[])((Set)mapSet).getDimensions();
            IDimension[] dims = multiTupleSet.getDimensions();
            for (int i = 0; i < dims.length; ++i) {
                if (!slicer.contains(dims[i])) continue;
                slicer = slicer.removeDimension(dims[i]);
                this.metadata.setSlicer(slicer);
            }
            axes = new ISet[]{multiTupleSet};
            this.metadata.setAxes(axes);
            HashMap<Tuple, long[]> tupleToIndexes = ((Set)multiTupleSet).getOrdinalsMap(mapDims);
            IResultSetIterator it = this.iterator();
            InMemoryCellStorage newCellSet = new InMemoryCellStorage(this);
            long mapSetSize = ((Set)mapSet).size();
            while (it.hasNext()) {
                Cell c = (Cell)it.next();
                long ordinal = c.getOrdinal();
                if (mapSetSize != 0L && ordinal >= mapSetSize) continue;
                Tuple t = (Tuple)((Set)mapSet).getTuple(ordinal);
                long[] newOrdinals = tupleToIndexes.get(t = t.retain((Dimension[])mapDims));
                if (newOrdinals == null) continue;
                for (int i = 0; i < newOrdinals.length; ++i) {
                    Cell newCell = new Cell(c);
                    newCell.setOrdinal(newOrdinals[i]);
                    newCellSet.put(newOrdinals[i], newCell);
                }
            }
            this.cellCache = null;
            this.cellMap = newCellSet;
        }
    }

    public String toString() {
        return "ResultSet: (" + this.cellCount() + " cells)";
    }

    public ResultSet convertToNonEmptyResultSet(boolean[] nonEmptyAxesFlags) {
        int i;
        TreeMap originalTupleIndexToNonEmptyTupleIndexMap;
        if ((long)this.cellMap.size() == this.size() || nonEmptyAxesFlags == null || nonEmptyAxesFlags.length == 0) {
            return this;
        }
        XQEDebugLog.out.println("Computing non-empty ResultSet.");
        ArrayList<Integer> nonEmptyAxesNums = new ArrayList<Integer>();
        for (int i2 = 0; i2 < nonEmptyAxesFlags.length; ++i2) {
            if (!nonEmptyAxesFlags[i2]) continue;
            nonEmptyAxesNums.add(i2);
        }
        if (nonEmptyAxesNums.size() == 0) {
            return this;
        }
        ISet[] axes = this.metadata.getAxes();
        Number[] axesSizesWithEmpty = new Number[axes.length];
        for (int i3 = 0; i3 < axes.length; ++i3) {
            long axesSize = axes[i3].size();
            axesSizesWithEmpty[i3] = axesSize < 0L ? ((Set)axes[i3]).noOverflowSize() : Long.valueOf(axesSize);
        }
        HashMap axesNumToNonEmptyTupleIndexSetMap = new HashMap();
        for (int i4 = 0; i4 < nonEmptyAxesNums.size(); ++i4) {
            int axesIndex = (Integer)nonEmptyAxesNums.get(i4);
            axesNumToNonEmptyTupleIndexSetMap.put(axesIndex, new TreeMap(new CompareNumbers()));
        }
        Iterator<Number> itCellOrdinals = this.cellMap.getOrdinalIterator();
        while (itCellOrdinals.hasNext()) {
            Number currentOrdinal = itCellOrdinals.next();
            Number[] tupleOrdinalsOnAxes = ResultSetMetadata.computeTupleOrdinals(currentOrdinal, axesSizesWithEmpty);
            for (int i5 = 0; i5 < tupleOrdinalsOnAxes.length; ++i5) {
                originalTupleIndexToNonEmptyTupleIndexMap = (TreeMap)axesNumToNonEmptyTupleIndexSetMap.get(i5);
                if (originalTupleIndexToNonEmptyTupleIndexMap == null) continue;
                originalTupleIndexToNonEmptyTupleIndexMap.put(tupleOrdinalsOnAxes[i5], null);
            }
        }
        List<long[]> tagTupleOrdinals = this.getTagTupleOrdinalsList();
        if (!tagTupleOrdinals.isEmpty()) {
            for (int edgeid = 0; edgeid < tagTupleOrdinals.size(); ++edgeid) {
                long[] tupleOrdinalsOnAxes = tagTupleOrdinals.get(edgeid);
                originalTupleIndexToNonEmptyTupleIndexMap = (TreeMap)axesNumToNonEmptyTupleIndexSetMap.get(edgeid);
                for (int i6 = 0; i6 < tupleOrdinalsOnAxes.length; ++i6) {
                    if (originalTupleIndexToNonEmptyTupleIndexMap == null) continue;
                    originalTupleIndexToNonEmptyTupleIndexMap.put(tupleOrdinalsOnAxes[i6], null);
                }
            }
            tagTupleOrdinals.clear();
        }
        ISet[] nonEmptyAxes = new ISet[axes.length];
        for (i = 0; i < axes.length; ++i) {
            nonEmptyAxes[i] = axes[i];
        }
        for (i = 0; i < nonEmptyAxesNums.size(); ++i) {
            int axesIndex = (Integer)nonEmptyAxesNums.get(i);
            Set axesToBeConverted = (Set)axes[axesIndex];
            TreeMap nonEmptyTupleIndexSet = (TreeMap)axesNumToNonEmptyTupleIndexSetMap.get(axesIndex);
            ITuple[] nonEmptyTupleList = new ITuple[nonEmptyTupleIndexSet.size()];
            Iterator itNonEmptyTuple = nonEmptyTupleIndexSet.keySet().iterator();
            int newTupleIndex = 0;
            while (itNonEmptyTuple.hasNext()) {
                if (this.cancelManager != null && this.cancelManager.isRequestCancelled()) {
                    throw new OperationCanceledException();
                }
                Number oldTupleIndex = (Number)itNonEmptyTuple.next();
                nonEmptyTupleList[newTupleIndex] = oldTupleIndex instanceof BigInteger ? axesToBeConverted.getTuple((BigInteger)oldTupleIndex) : axesToBeConverted.getTuple((Long)oldTupleIndex);
                nonEmptyTupleIndexSet.put(oldTupleIndex, Long.valueOf(newTupleIndex));
                ++newTupleIndex;
            }
            Set nonEmptyAxesSet = new Set(nonEmptyTupleList);
            nonEmptyAxes[axesIndex] = nonEmptyAxesSet;
        }
        Number[] axesSizesWithoutEmpty = new Number[axes.length];
        for (int i7 = 0; i7 < nonEmptyAxes.length; ++i7) {
            long axesSize = nonEmptyAxes[i7].size();
            axesSizesWithoutEmpty[i7] = axesSize < 0L ? ((Set)nonEmptyAxes[i7]).noOverflowSize() : Long.valueOf(axesSize);
        }
        long nonEmptyResultSetSize = this.metadata.getSlicer().size();
        if (nonEmptyResultSetSize == 0L) {
            nonEmptyResultSetSize = 1L;
        }
        for (int i8 = nonEmptyAxes.length - 1; i8 >= 0; --i8) {
            nonEmptyResultSetSize = NumberOp.noOverflowMultiply(nonEmptyResultSetSize, nonEmptyAxes[i8].size());
        }
        ICellStorage oldCellStorage = this.cellMap;
        this.initializeCellStorage(nonEmptyResultSetSize, oldCellStorage.getStreamStorage());
        itCellOrdinals = oldCellStorage.getOrdinalIterator();
        while (itCellOrdinals.hasNext()) {
            if (this.cancelManager != null && this.cancelManager.isRequestCancelled()) {
                throw new OperationCanceledException();
            }
            Number currentOrdinal = itCellOrdinals.next();
            Number[] originalTupleOrdinalsOnAxes = ResultSetMetadata.computeTupleOrdinals(currentOrdinal, axesSizesWithEmpty);
            Number[] nonEmptyTupleOrdinalsOnAxes = new Number[originalTupleOrdinalsOnAxes.length];
            for (int i9 = 0; i9 < originalTupleOrdinalsOnAxes.length; ++i9) {
                TreeMap originalTupleIndexToNonEmptyTupleIndexMap2 = (TreeMap)axesNumToNonEmptyTupleIndexSetMap.get(i9);
                nonEmptyTupleOrdinalsOnAxes[i9] = originalTupleIndexToNonEmptyTupleIndexMap2 != null ? (Number)((Number)((TreeMap)axesNumToNonEmptyTupleIndexSetMap.get(i9)).get(originalTupleOrdinalsOnAxes[i9])) : (Number)originalTupleOrdinalsOnAxes[i9];
            }
            Number nonEmptyCellOrdinal = ResultSetMetadata.computeCellOrdinal(nonEmptyTupleOrdinalsOnAxes, axesSizesWithoutEmpty);
            Cell aCell = null;
            if (this.cellMap instanceof InStreamCellStorage) {
                if (this.cellMap.isCalculationCell(currentOrdinal)) {
                    aCell = (Cell)oldCellStorage.get(currentOrdinal);
                } else {
                    this.cellMap.remove(currentOrdinal);
                    aCell = (Cell)NULL_CELL_PLACE_HOLDER;
                }
            } else {
                aCell = (Cell)oldCellStorage.get(currentOrdinal);
            }
            this.addCellIntoNonEmptyResultSet(aCell, nonEmptyCellOrdinal);
            itCellOrdinals.remove();
        }
        this.metadata.setAxes(nonEmptyAxes);
        return this;
    }

    public IMember[] getMembersOnAxis(long cellOrdinal, int axisIndex, long[] axesSizes) {
        return this.metadata.getMembersOnAxis(cellOrdinal, axisIndex, axesSizes);
    }

    @Override
    public void finalizeResultSet(boolean[] nonEmptyAxes) {
        if (nonEmptyAxes != null) {
            if (this.cancelManager != null && this.cancelManager.isRequestCancelled()) {
                throw new OperationCanceledException();
            }
            this.convertToNonEmptyResultSet(nonEmptyAxes);
        }
        this.getTagTupleOrdinalsList().clear();
        this.getQuerySet().release();
    }

    @Override
    public void delegate(boolean[] nonEmptyAxes) {
        this.genericDelegate = nonEmptyAxes != null ? new ResultSetDownsizeDelegate(this, nonEmptyAxes) : new ResultSetGenericDelegate(this);
        this.resultSetDelegateMode = true;
    }

    @Override
    public void undelegate() throws InterpreterException {
        if (this.resultSetDelegateMode) {
            this.resultSetDelegateMode = false;
            this.genericDelegate.rebuildAxesList();
            this.genericDelegate.rebuildCellList();
        }
        this.genericDelegate = null;
    }

    @Override
    public void resetQuerySet() {
        this.metadata = new ResultSetMetadata(this.metadata.getAxes(), this.metadata.getSlicer());
    }

    @Override
    public void add(IResultSet other, boolean combineExistingCells) {
        ArrayList<ICellStorage> cellStorageList = new ArrayList<ICellStorage>();
        this.validateSameMetadataStructure(other);
        cellStorageList.add(other.getCellMap());
        ICellCombiner cellCombiner = this.getCellCombiner(combineExistingCells);
        this.cellMap.add(cellStorageList, cellCombiner, this);
        Map<String, CalculatedMember> calcedMembers = this.getCalcMembers();
        for (Map.Entry<String, CalculatedMember> otherEntry : other.getCalcMembers().entrySet()) {
            CalculatedMember myCalcMember = calcedMembers.get(otherEntry.getKey());
            if (myCalcMember == null) {
                calcedMembers.put(otherEntry.getKey(), otherEntry.getValue());
                continue;
            }
            if (myCalcMember.equals(otherEntry.getValue())) continue;
            throw new UnsupportedOperationException("Cannot add resultSets if calcedMember values are different.");
        }
        this.getCellProperties().addAll(other.getCellProperties());
        this.getTagTupleOrdinalsList().addAll(other.getTagTupleOrdinalsList());
        this.cellCache = null;
    }

    private ICellCombiner getCellCombiner(boolean combineExistingCells) {
        ICellCombiner cellCombiner = NoopCellCombiner.getInstance();
        CrossJoinedSet myCJS = this.metadata.getQuerySet();
        if (combineExistingCells) {
            IDimension[] dimensions;
            for (IDimension dimension : dimensions = myCJS.getDimensions()) {
                if (!dimension.isMeasuresDimension()) continue;
                IMember[] measures = myCJS.getMembers(dimension);
                AggregateTypeEnum commonMeasureType = AggregateTypeEnum.UNSUPPORTED;
                if (measures.length > 0) {
                    commonMeasureType = measures[0].getRegularAggregate();
                }
                boolean bMixedTypes = false;
                for (IMember measure : measures) {
                    AggregateTypeEnum currentMeasureType = measure.getRegularAggregate();
                    if (commonMeasureType == currentMeasureType) continue;
                    bMixedTypes = true;
                    break;
                }
                if (bMixedTypes) {
                    cellCombiner = new CellCombiner();
                    ((CellCombiner)cellCombiner).setResultSet(this);
                    break;
                }
                switch (commonMeasureType) {
                    case MAX: {
                        cellCombiner = MaxCellCombiner.getInstance();
                        break;
                    }
                    case MIN: {
                        cellCombiner = MinCellCombiner.getInstance();
                        break;
                    }
                    default: {
                        cellCombiner = AdditiveCellCombiner.getInstance();
                        break;
                    }
                }
                break;
            }
        }
        return cellCombiner;
    }

    @Override
    public ICellStorage getCellMap() {
        return this.cellMap;
    }

    @Override
    public boolean supportsRandomAccess() {
        return true;
    }

    static /* synthetic */ Cell[][] access$202(ResultSet x0, Cell[][] x1) {
        x0.cellCache = x1;
        return x1;
    }

    private final class ResultSetValueIterator
    implements ValueIterator {
        private final Iterator<ICell> cellSetIterator;
        private Cell currentCell;
        private long currentOrdinal = -1L;
        private boolean returnedDefault = false;

        private ResultSetValueIterator() {
            this.cellSetIterator = ResultSet.this.iterator();
            if (ResultSet.this.size() == (long)ResultSet.this.cellMap.size()) {
                this.returnedDefault = true;
            }
        }

        @Override
        public boolean hasNext() {
            return !this.returnedDefault || this.cellSetIterator.hasNext();
        }

        @Override
        public Object next() {
            if (ResultSet.this.cancelManager != null && ResultSet.this.cancelManager.isRequestCancelled()) {
                throw new OperationCanceledException();
            }
            ++this.currentOrdinal;
            if (!this.returnedDefault) {
                this.returnedDefault = true;
                return ResultSet.this.getDefaultValue();
            }
            this.currentCell = (Cell)this.cellSetIterator.next();
            return this.currentCell.getObjectValue();
        }

        @Override
        public void setValue(Object o) {
            if (this.currentCell == null) {
                ResultSet.this.setDefaultValue(o);
            } else if (o == ResultSet.this.getDefaultValue()) {
                this.cellSetIterator.remove();
                ResultSet.access$202(ResultSet.this, null);
            } else {
                this.currentCell.setValue(o);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

