/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SelectQuery;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.Iterator;
import org.apache.commons.collections.map.LRUMap;

public class SetEvaluator {
    private static final int MAGIC_NUMBER_3 = 3;
    private InterpreterContext interpreterContext;
    private boolean nonEmpty = false;
    private boolean applySecurity = true;

    public SetEvaluator(InterpreterContext ic) {
        this.interpreterContext = ic;
    }

    public SetEvaluator(InterpreterContext ic, boolean ne) {
        this.interpreterContext = ic;
        this.nonEmpty = ne;
    }

    public void setNonEmpty(boolean ne) {
        this.nonEmpty = ne;
    }

    public void setApplySecurity(boolean theApplySecurity) {
        this.applySecurity = theApplySecurity;
    }

    private IResultSet getFromQueryCache(ISet[] keyset) {
        IResultSet rs = null;
        String threadId = Thread.currentThread().getName();
        LRUMap lruMap = XMdxLocal.getLocalCache(threadId);
        if (lruMap == null) {
            return null;
        }
        Iterator it = lruMap.keySet().iterator();
        while (it.hasNext()) {
            boolean matched = true;
            ISet[] cachedAxes = (ISet[])it.next();
            for (int i = 0; i < cachedAxes.length; ++i) {
                if (keyset[i] == cachedAxes[i] || keyset[i].equals(cachedAxes[i])) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            rs = (IResultSet)XMdxLocal.getLocalCache(threadId).get((Object)cachedAxes);
            return ((ResultSet)rs).copy();
        }
        return rs;
    }

    private void putInQueryCache(ISet[] keys, IResultSet rs) {
        String threadId = Thread.currentThread().getName();
        ISet[] keyset = new ISet[]{new Set((Set)keys[0]), new Set((Set)keys[1]), new Set((Set)keys[2])};
        XMdxLocal.putInLocalCache(threadId, keyset, ((ResultSet)rs).copy());
    }

    public IResultSet getSetResults(ISet set, ISet ss) throws InterpreterException {
        Cube cube;
        Set contextSet = this.interpreterContext.getContextSet();
        IResultSet rs = null;
        boolean useQueryCache = false;
        ISet[] keyset = new ISet[]{contextSet, ss, set};
        if (XMdxLocal.RESULTSET_LRUMAP_MAXSIZE > 0 && set.size() + ss.size() + contextSet.size() > (long)XMdxLocal.KEYSET_SIZE && set.size() * ss.size() < (long)XMdxLocal.RESULTSET_SIZE_MAX) {
            useQueryCache = true;
            rs = this.getFromQueryCache(keyset);
            if (rs != null) {
                XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MDXEngine", LogLevel.TRACE);
                if (logger.isOn(LogLevel.TRACE)) {
                    logger.log(LogLevel.TRACE, "QuerySet solved by cached resultSet containing " + rs.cellCount() + " cells.");
                }
                return rs;
            }
        }
        if ((cube = (Cube)this.interpreterContext.getCube()).multipleHierarchySupport()) {
            IHierarchy[] hiers;
            if (set != null) {
                hiers = set.getHierarchies();
                contextSet = (Set)contextSet.removeHierarchies(hiers, false);
                ss = (Set)ss.removeHierarchies(hiers, false);
            }
            if (ss != null && !ss.isEmpty()) {
                hiers = ss.getHierarchies();
                contextSet = (Set)contextSet.removeHierarchies(hiers, false);
            }
        } else {
            IDimension[] dims;
            if (set != null) {
                dims = set.getDimensions();
                contextSet = (Set)contextSet.removeDimensions(dims, false);
                ss = (Set)ss.removeDimensions(dims, false);
            }
            if (ss != null && !ss.isEmpty()) {
                dims = ss.getDimensions();
                contextSet = (Set)contextSet.removeDimensions(dims, false);
            }
        }
        set = set != null && !set.isEmpty() ? ((Set)set).crossjoin(contextSet) : contextSet;
        SelectQuery sq = this.interpreterContext.createSelectQuery();
        Tuple whereTuple = new Tuple(new IMember[0]);
        sq.setWhereTuple(whereTuple);
        ISet[] axes = new ISet[2];
        int axesSetCount = 0;
        if (!ss.isEmpty()) {
            axes[axesSetCount++] = ss;
        }
        if (!set.isEmpty()) {
            axes[axesSetCount++] = set;
        }
        sq.setNumberOfAxes(axesSetCount);
        int axesIdx = 0;
        for (int i = 0; i < axes.length; ++i) {
            if (axes[i] == null) continue;
            sq.setAxis(axesIdx++, axes[i]);
            if (!this.nonEmpty) continue;
            sq.setNonEmptyAxis(i);
        }
        sq.setApplySecurity(this.applySecurity);
        sq.execute(this.interpreterContext);
        rs = sq.getResultSet();
        if (useQueryCache && rs.size() < (long)XMdxLocal.RESULTSET_SIZE_MAX && rs instanceof ResultSet && !this.interpreterContext.getProvider().isInProcessOfPreCellLoading() && !this.interpreterContext.inPrimingPhase()) {
            this.putInQueryCache(keyset, rs);
        }
        return rs;
    }
}

