/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullBehavior;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TypeCoercion;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.ibm.icu.text.Collator;
import java.util.Comparator;

public class SimpleTupleValueComparator
implements Comparator<Object> {
    private Collator collator;
    private boolean ascending = true;
    private NullBehavior nullHandling = NullBehavior.ZERO;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    private static final String INVALID_COMPARISON_OF_DATA_VALUES = "Invalid comparison of data values: ";
    private static final String COMMA = ", ";

    public SimpleTupleValueComparator(Collator theCollator, boolean asc, NullBehavior nh) {
        this.collator = theCollator;
        this.ascending = asc;
        this.nullHandling = nh;
    }

    @Override
    public int compare(Object o1, Object o2) {
        Double v2;
        Double v1;
        Cell cell1 = null;
        Cell cell2 = null;
        if (o1 instanceof TupleValue && o2 instanceof TupleValue) {
            cell1 = ((TupleValue)o1).getCell();
            cell2 = ((TupleValue)o2).getCell();
        } else if (o1 instanceof Cell && o2 instanceof Cell) {
            cell1 = (Cell)o1;
            cell2 = (Cell)o2;
        }
        Object value1 = cell1.getObjectValue();
        Object value2 = cell2.getObjectValue();
        if (value1 instanceof Value && value2 instanceof Value) {
            if (value1 instanceof NumericValue && value2 instanceof NumericValue) {
                return -1 * ((NumericValue)value1).compareTo((NumericValue)value2, this.nullHandling);
            }
            if (((Value)value1).isError()) {
                if (((Value)value2).isError()) {
                    return 0;
                }
                return 1;
            }
            if (((Value)value2).isError()) {
                return -1;
            }
            if (this.nullHandling == NullBehavior.NULL_FIRST || this.nullHandling == NullBehavior.NULL_LAST) {
                boolean v1IsNull = ((Value)value1).isNull();
                boolean v2IsNull = ((Value)value2).isNull();
                if (v1IsNull || v2IsNull) {
                    if (v1IsNull && v2IsNull) {
                        return 0;
                    }
                    int compValue = 1;
                    if (v1IsNull) {
                        compValue = -1;
                    }
                    if (this.nullHandling == NullBehavior.NULL_LAST) {
                        compValue = -1 * compValue;
                    }
                    if (this.ascending) {
                        compValue = -1 * compValue;
                    }
                    return compValue;
                }
            }
            boolean hasNullValue = false;
            int compValue = 0;
            if (value1 instanceof TextValue || value2 instanceof TextValue) {
                boolean descendingNullFirst;
                if (((Value)value1).isNull()) {
                    hasNullValue = true;
                    compValue = ((Value)value2).isNull() ? 0 : 1;
                } else if (((Value)value2).isNull()) {
                    hasNullValue = true;
                    compValue = -1;
                }
                boolean ascendingNullLast = this.ascending && (this.nullHandling == NullBehavior.ZERO_LAST || this.nullHandling == NullBehavior.NULL_LAST || this.nullHandling == NullBehavior.ZERO_STABLE_ELSE_LAST);
                boolean bl = descendingNullFirst = !this.ascending && (this.nullHandling == NullBehavior.ZERO_FIRST || this.nullHandling == NullBehavior.NULL_FIRST || this.nullHandling == NullBehavior.ZERO_STABLE_ELSE_FIRST);
                if (hasNullValue && this.nullHandling != NullBehavior.ZERO) {
                    if (ascendingNullLast || descendingNullFirst) {
                        return -compValue;
                    }
                    return compValue;
                }
                if (value2 instanceof TextValue) {
                    return ((TextValue)value2).compareTo(value1, this.collator);
                }
                return ((TextValue)value1).compareTo(value2, this.collator) * -1;
            }
            try {
                if (((Value)value1).isNull() || ((Value)value2).isNull()) {
                    hasNullValue = true;
                }
                compValue = ((Value)value2).compareTo(value1, this.nullHandling);
                if (hasNullValue && (!this.ascending && this.nullHandling == NullBehavior.NULL_LAST || this.ascending && this.nullHandling == NullBehavior.NULL_FIRST)) {
                    compValue = -compValue;
                }
            }
            catch (XQERuntimeException e) {
                compValue = -1 * ((Value)value1).compareTo(value2, this.nullHandling);
            }
            catch (UnsupportedOperationException e) {
                compValue = -1 * ((Value)value1).compareTo(value2, this.nullHandling);
            }
            if (((Value)value1).isNumeric() && Double.isNaN(((NumericValue)value1).getDouble()) || ((Value)value2).isNumeric() && Double.isNaN(((NumericValue)value2).getDouble())) {
                compValue *= -1;
            }
            return compValue;
        }
        if (value1 instanceof String && !(value2 instanceof String)) {
            try {
                v1 = TypeCoercion.getDoubleOperand(value1);
                v2 = TypeCoercion.getDoubleOperand(value2);
                value1 = v1;
                value2 = v2;
            }
            catch (InterpreterException e) {
                value2 = "" + value2;
            }
        }
        if (value1 instanceof String) {
            return this.collator.compare((String)value2, (String)value1);
        }
        if (value1 instanceof Double) {
            if (!(value2 instanceof Double)) {
                try {
                    value2 = TypeCoercion.getDoubleOperand(value2);
                }
                catch (InterpreterException e) {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, (Throwable)e, INVALID_COMPARISON_OF_DATA_VALUES + value1.toString() + COMMA + value2.toString());
                }
            }
            int compValue = ((Double)value2).compareTo((Double)value1);
            if (Double.isNaN((Double)value1) || Double.isNaN((Double)value2)) {
                compValue *= -1;
            }
            return compValue;
        }
        if (value1 instanceof Long) {
            if (!(value2 instanceof Long)) {
                value2 = Long.valueOf("" + value2);
            }
            return ((Long)value2).compareTo((Long)value1);
        }
        try {
            v1 = TypeCoercion.getDoubleOperand(value1);
            v2 = TypeCoercion.getDoubleOperand(value2);
            value1 = v1;
            value2 = v2;
        }
        catch (InterpreterException e) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, (Throwable)e, INVALID_COMPARISON_OF_DATA_VALUES + value1.toString() + COMMA + value2.toString());
        }
        int compValue = ((Double)value2).compareTo((Double)value1);
        if (Double.isNaN((Double)value1) || Double.isNaN((Double)value2)) {
            compValue *= -1;
        }
        return compValue;
    }
}

