/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.AbstractBlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockOrdinalChangeContextTransformIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline.RandomAccessPipelineIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PipelineBlockIterator
extends AbstractBlockIterator {
    private static final String NOT_SAME_CONTEXT_SET_ERROR = "Pipeline blocks that are combined must have the same context sets: ";
    private RandomAccessPipelineIterator[] sourceIterators = null;
    private int currentMasterIterator = 0;
    private final boolean nextReturnsCellArray;

    public PipelineBlockIterator(Block[] blocks) {
        super(blocks);
        this.validateBlocks(blocks);
        this.sourceIterators = new RandomAccessPipelineIterator[blocks.length];
        for (int index = 0; index < blocks.length; ++index) {
            Iterator<Object> sourceIter = blocks[index].getCellPipelineIterator();
            if (sourceIter == null) {
                throw new UnsupportedOperationException("PipelineBlockIterator can only work with blocks with pipeline iterators.");
            }
            this.sourceIterators[index] = new RandomAccessPipelineIterator(sourceIter);
        }
        this.nextReturnsCellArray = PipelineBlockIterator.returnsCellArray(blocks);
    }

    @Override
    public boolean hasNext() {
        for (int index = this.currentMasterIterator; index < this.sourceIterators.length; ++index) {
            if (!this.sourceIterators[index].hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object next() {
        int i;
        if (this.cancelManager != null && this.cancelManager.isRequestCancelled()) {
            throw new OperationCanceledException();
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Object[] returnArray = new Object[this.sourceIterators.length];
        long ordinal = 0L;
        for (i = this.currentMasterIterator; i < this.sourceIterators.length; ++i) {
            if (this.sourceIterators[i].hasNext()) {
                returnArray[this.currentMasterIterator] = this.sourceIterators[i].next();
                ordinal = this.sourceIterators[i].getPrevBlockOrdSurrogateId();
                break;
            }
            ++this.currentMasterIterator;
        }
        for (i = this.currentMasterIterator + 1; i < this.sourceIterators.length; ++i) {
            returnArray[i] = this.sourceIterators[i].getValueAtOrdinal(ordinal);
        }
        this.setBlockOrdSurrogateId(ordinal);
        for (int index = 0; index < this.sourceIterators.length; ++index) {
            if (!(returnArray[index] instanceof Cell)) continue;
            returnArray[index] = ((Cell)returnArray[index]).getObjectValue();
        }
        return returnArray;
    }

    @Override
    public boolean returnsCellArray() {
        return this.nextReturnsCellArray;
    }

    private void validateBlocks(Block[] blocks) {
        Set[] contextSets = blocks[0].getContextSet();
        long tupleSetSize = blocks[0].tupleSetSize();
        for (int i = 1; i < blocks.length; ++i) {
            long thisBlocksTupleSetSize;
            Set[] thisBlocksContextSets = blocks[i].getContextSet();
            if (contextSets != null && thisBlocksContextSets != null) {
                if (contextSets.length != thisBlocksContextSets.length) {
                    throw new UnsupportedOperationException("Pipeline blocks that are combined must have the same context sets:  Some blocks have unequal number of contextSets.  Block 0 has " + contextSets.length + " while block " + i + " has " + thisBlocksContextSets.length);
                }
                for (int j = 0; j < contextSets.length; ++j) {
                    if (contextSets[j].size() == thisBlocksContextSets[j].size()) continue;
                    throw new UnsupportedOperationException("Pipeline blocks that are combined must have the same context sets:  Context set " + j + " in Block 0 and " + i + " are different. Block 0: " + contextSets[j] + "\n Block " + j + ":" + thisBlocksContextSets[j]);
                }
            } else if (thisBlocksContextSets != null || contextSets != null) {
                throw new UnsupportedOperationException("Pipeline blocks that are combined must have the same context sets: One has null contextSets, the other does not.");
            }
            if (tupleSetSize == (thisBlocksTupleSetSize = blocks[i].tupleSetSize())) continue;
            throw new UnsupportedOperationException("The pipeline blocks have different set sizes.  The first  block has " + tupleSetSize + " tuples, while block " + i + " has  " + thisBlocksTupleSetSize);
        }
    }

    public static boolean returnsCellArray(Block[] blocks) {
        for (Block b : blocks) {
            Iterator<?> sourceIter = b.getCellPipelineIterator();
            if (sourceIter == null || !(sourceIter instanceof BlockOrdinalChangeContextTransformIterator) || !((BlockOrdinalChangeContextTransformIterator)sourceIter).allowsStreaming()) continue;
            return true;
        }
        return false;
    }
}

