/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline;

import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockOrdinalChangeContextTransformIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.util.primitive.HashMapLongObject;
import com.cognos.xqe.util.primitive.IteratorLong;
import java.util.Iterator;

public class RandomAccessPipelineIterator
implements Iterator<Object> {
    private final Iterator<Object> sourceIter;
    private final HashMapLongObject<Object> fetchedValues = new HashMapLongObject();
    private long prevReturnedOrdinal;
    private IteratorLong fetchedValuesIterator = null;

    public RandomAccessPipelineIterator(Iterator<Object> aSourceIter) {
        this.sourceIter = aSourceIter;
    }

    @Override
    public boolean hasNext() {
        return !this.fetchedValues.isEmpty() || this.sourceIter.hasNext();
    }

    @Override
    public Object next() {
        Object nextObj = null;
        if (this.fetchedValues.isEmpty()) {
            nextObj = this.pullNextValueFromSourceIterator();
        } else {
            if (this.fetchedValuesIterator == null) {
                this.fetchedValuesIterator = this.fetchedValues.keySetIterator();
            }
            this.prevReturnedOrdinal = this.fetchedValuesIterator.next();
            nextObj = this.fetchedValues.get(this.prevReturnedOrdinal);
            this.fetchedValuesIterator.remove();
        }
        return nextObj;
    }

    private Object pullNextValueFromSourceIterator() {
        Object nextObj = this.sourceIter.next();
        if (nextObj instanceof Cell) {
            this.prevReturnedOrdinal = ((Cell)nextObj).getOrdinal();
        } else if (this.sourceIter instanceof BlockOrdinalChangeContextTransformIterator) {
            this.prevReturnedOrdinal = ((BlockOrdinalChangeContextTransformIterator)this.sourceIter).getPrevBlockOrdSurrogateId();
        } else {
            throw new UnsupportedOperationException("Unsupported iterator type " + this.sourceIter.getClass());
        }
        return nextObj;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported");
    }

    public long getPrevBlockOrdSurrogateId() {
        return this.prevReturnedOrdinal;
    }

    public Object getValueAtOrdinal(long ordinal) {
        Object returnObject = this.fetchedValues.remove(ordinal);
        if (returnObject == null) {
            while (this.sourceIter.hasNext()) {
                Object value = this.pullNextValueFromSourceIterator();
                if (this.prevReturnedOrdinal == ordinal) {
                    returnObject = value;
                    break;
                }
                this.fetchedValues.put(this.prevReturnedOrdinal, value);
            }
        }
        this.fetchedValuesIterator = null;
        this.prevReturnedOrdinal = returnObject != null ? ordinal : -1L;
        return returnObject;
    }
}

