/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleListFilter;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.SimpleTupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.TupleIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.TupleList;
import com.cognos.xqe.runtree.olap.mdx.util.SymmetricSubqueryIterator;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class FilteredTupleList
extends TupleList {
    TupleList childTupleList;
    ITupleListFilter filter;
    long size;
    private static final double CARD_LENGTH_REBUILD_RATIO = 0.5;
    private static final long REBUILD_THRESHOLD = 10L;

    private FilteredTupleList(ITupleList child, ITupleListFilter theFilter) {
        this.childTupleList = (TupleList)child;
        this.filter = theFilter;
        this.size = theFilter.cardinality();
        this.setDistinctFlag(child.getDistinctFlag());
    }

    public static ITupleList construct(ITupleList child, ITupleListFilter filter) {
        if (child == null) {
            return null;
        }
        if (filter == null || filter.length() == 0L) {
            return null;
        }
        if (filter.length() > child.size()) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "filter.length: " + filter.length() + " >  child.size() " + child.size());
        }
        long card = filter.cardinality();
        if (card == child.size()) {
            return child;
        }
        ITupleList tl = new FilteredTupleList(child, filter);
        if ((card < 10L || (double)card / (double)child.listSize() < 0.5) && (tl = SimpleTupleList.rebuildAsSimpleTupleList(tl)) != null) {
            tl.setDistinctFlag(child.getDistinctFlag());
        }
        tl.setInvalidTuplesRemoved(child.getInvalidTuplesRemoved());
        return tl;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public BigInteger noOverflowSize() {
        return BigInteger.valueOf(this.filter.cardinality());
    }

    @Override
    public int width() {
        return this.childTupleList.width();
    }

    @Override
    public long listSize() {
        return this.childTupleList.listSize();
    }

    @Override
    public List<Number> find(IMember[] findMems, boolean first) {
        List<Number> subIndices = this.childTupleList.find(findMems, false);
        ArrayList<Number> indices = new ArrayList<Number>();
        FilterIteratorState iterState = new FilterIteratorState();
        for (int inx = 0; inx < subIndices.size(); ++inx) {
            long childIndex = (Long)subIndices.get(inx);
            if (!this.filter.isEnabled(childIndex)) continue;
            indices.add(iterState.mapChildIndexToFilteredIndex(childIndex));
        }
        return indices;
    }

    @Override
    public ITupleIterator iterator() {
        return new FilteredTupleIterator(this);
    }

    @Override
    public ITupleList copy() {
        ITupleList tl = SimpleTupleList.cloneAsSimpleTupleList(this);
        if (tl == null) {
            tl = new FilteredTupleList(this.childTupleList.copy(), this.filter);
            tl.setDistinctFlag(this.getDistinctFlag());
        }
        return tl;
    }

    public long nextEnabledTuple(long tupleOrd) {
        return this.filter.nextEnabledTuple(tupleOrd);
    }

    @Override
    public List<Set> getSymmetricSets(boolean splitAsymmetricSets) {
        Set set = new Set(this);
        if (SymmetricSubqueryIterator.isAsymmetric(set)) {
            if (!splitAsymmetricSets) {
                return null;
            }
            return SymmetricSubqueryIterator.getSymmetricSubsets(set, new HashSet<IHierarchy>());
        }
        ArrayList<Set> sets = new ArrayList<Set>();
        sets.add(set);
        return sets;
    }

    private final class FilteredTupleIterator
    extends TupleIterator {
        TupleIterator childTupleListIterator;
        FilterIteratorState iterState;

        private FilteredTupleIterator(TupleList tl) {
            super(tl);
            this.iterState = new FilterIteratorState();
            this.childTupleListIterator = (TupleIterator)FilteredTupleList.this.childTupleList.iterator();
        }

        @Override
        protected IMember[] fetchMembers(long index) {
            long childIndex = this.iterState.mapFilteredIndexToChildIndex(index);
            return this.childTupleListIterator.fetchMembers(childIndex);
        }

        @Override
        protected IMember[] fetchMembers(BigInteger index) {
            if (index.bitLength() > 63) {
                this.throwExceedsMaxLongException(index);
            }
            return this.fetchMembers(index.longValue());
        }

        protected void throwExceedsMaxLongException(BigInteger index) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "The index for the filter tuple list exceeds the Long.MAX_VALUE: " + index.toString());
        }

        @Override
        protected int fetchMembers(long index, IMember[] membersArray, int indexToStart) {
            long childIndex = this.iterState.mapFilteredIndexToChildIndex(index);
            return this.childTupleListIterator.fetchMembers(childIndex, membersArray, indexToStart);
        }

        @Override
        protected int fetchMembers(BigInteger index, IMember[] membersArray, int indexToStart) {
            if (index.bitLength() > 63) {
                this.throwExceedsMaxLongException(index);
            }
            return this.fetchMembers(index.longValue(), membersArray, indexToStart);
        }

        @Override
        public ITuple getTuple(long index) {
            this.checkForCancelRequest();
            long childIndex = this.iterState.mapFilteredIndexToChildIndex(index);
            return this.childTupleListIterator.getTuple(childIndex);
        }

        @Override
        public ITuple getTuple(BigInteger index) {
            this.checkForCancelRequest();
            if (index.bitLength() > 63) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "The index for the filter tuple list exceeds the Long.MAX_VALUE : " + index.toString());
            }
            return this.getTuple(index.longValue());
        }
    }

    private class FilterIteratorState {
        long prevFilteredIndex = -1L;
        long prevChildIndex = -1L;

        private FilterIteratorState() {
        }

        long mapFilteredIndexToChildIndex(long filteredIndex) {
            if (filteredIndex == this.prevFilteredIndex) {
                return this.prevChildIndex;
            }
            if (filteredIndex < this.prevFilteredIndex / 2L) {
                this.prevFilteredIndex = -1L;
                this.prevChildIndex = -1L;
            }
            while (filteredIndex < this.prevFilteredIndex) {
                --this.prevChildIndex;
                while (!FilteredTupleList.this.filter.isEnabled(this.prevChildIndex)) {
                    --this.prevChildIndex;
                }
                --this.prevFilteredIndex;
            }
            while (filteredIndex > this.prevFilteredIndex) {
                this.prevChildIndex = FilteredTupleList.this.filter.nextEnabledTuple(this.prevChildIndex + 1L);
                ++this.prevFilteredIndex;
            }
            return this.prevChildIndex;
        }

        long mapChildIndexToFilteredIndex(long childIndex) {
            int last;
            int first;
            if (childIndex > this.prevChildIndex) {
                first = (int)this.prevChildIndex + 1;
                last = (int)childIndex;
            } else {
                first = (int)childIndex + 1;
                last = (int)this.prevChildIndex;
            }
            if (!FilteredTupleList.this.filter.isEnabled(childIndex)) {
                throw new InternalError("FilterTL: [childIndex] is false");
            }
            long bitCount = 1L;
            for (int inx = first; inx < last; ++inx) {
                if (!FilteredTupleList.this.filter.isEnabled(inx)) continue;
                ++bitCount;
            }
            this.prevFilteredIndex = childIndex > this.prevChildIndex ? (this.prevFilteredIndex += bitCount) : (this.prevFilteredIndex -= bitCount);
            this.prevChildIndex = childIndex;
            return this.prevFilteredIndex;
        }
    }
}

