/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.SimpleTupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.TupleIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.TupleList;
import com.cognos.xqe.runtree.olap.mdx.util.SymmetricSubqueryIterator;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class SortedTupleList
extends TupleList {
    TupleList childTupleList;
    long[] order;

    private SortedTupleList(ITupleList child, long[] theOrder) {
        this.childTupleList = (TupleList)child;
        this.order = theOrder;
        this.setDistinctFlag(child.getDistinctFlag());
    }

    public static ITupleList construct(ITupleList child, long[] order) {
        if (child == null) {
            return null;
        }
        if (order == null || order.length == 0) {
            return null;
        }
        if (child.size() == (long)order.length) {
            int inx;
            for (inx = 0; inx < order.length && order[inx] == (long)inx; ++inx) {
            }
            if (inx == order.length) {
                return child;
            }
        }
        SortedTupleList tl = new SortedTupleList(child, order);
        tl.setInvalidTuplesRemoved(child.getInvalidTuplesRemoved());
        return tl;
    }

    @Override
    public long size() {
        return this.order.length;
    }

    @Override
    public BigInteger noOverflowSize() {
        return BigInteger.valueOf(this.order.length);
    }

    @Override
    public int width() {
        return this.childTupleList.width();
    }

    @Override
    public long listSize() {
        return this.childTupleList.listSize();
    }

    @Override
    public List<Number> find(IMember[] findMems, boolean first) {
        return super.find(findMems, first);
    }

    @Override
    public ITupleIterator iterator() {
        return new SortedTupleIterator(this);
    }

    @Override
    public ITupleList copy() {
        ITupleList tl = SimpleTupleList.cloneAsSimpleTupleList(this);
        if (tl == null) {
            tl = new SortedTupleList(this.childTupleList.copy(), this.order);
            tl.setDistinctFlag(this.getDistinctFlag());
        }
        return tl;
    }

    @Override
    public boolean containsNullMembers() {
        return this.childTupleList.containsNullMembers();
    }

    @Override
    public boolean containsCalculatedMembers() {
        return this.childTupleList.containsCalculatedMembers();
    }

    @Override
    public List<Set> getSymmetricSets(boolean splitAsymmetricSets) {
        if (this.childTupleList.size() == (long)this.order.length) {
            return this.childTupleList.getSymmetricSets(splitAsymmetricSets);
        }
        Set set = new Set(this);
        if (SymmetricSubqueryIterator.isAsymmetric(set)) {
            if (!splitAsymmetricSets) {
                return null;
            }
            return SymmetricSubqueryIterator.getSymmetricSubsets(set, new HashSet<IHierarchy>());
        }
        ArrayList<Set> sets = new ArrayList<Set>();
        sets.add(set);
        return sets;
    }

    private final class SortedTupleIterator
    extends TupleIterator {
        TupleIterator childTupleListIterator;

        private SortedTupleIterator(TupleList tl) {
            super(tl);
            this.childTupleListIterator = (TupleIterator)SortedTupleList.this.childTupleList.iterator();
        }

        @Override
        protected IMember[] fetchMembers(long index) {
            long childOrdinal = SortedTupleList.this.order[(int)index];
            return this.childTupleListIterator.fetchMembers(childOrdinal);
        }

        @Override
        protected IMember[] fetchMembers(BigInteger index) {
            if (index.compareTo(TupleList.INT_MAX_VALUE) >= 0) {
                this.throwExceededMaxValueException(index);
            }
            long childOrdinal = SortedTupleList.this.order[index.intValue()];
            return this.childTupleListIterator.fetchMembers(childOrdinal);
        }

        protected void throwExceededMaxValueException(BigInteger index) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "The index for the sorted tuple list exceeds the Integer.MAX_VALUE: " + index);
        }

        @Override
        protected int fetchMembers(long index, IMember[] membersArray, int indexToStart) {
            long childOrdinal = SortedTupleList.this.order[(int)index];
            return this.childTupleListIterator.fetchMembers(childOrdinal, membersArray, indexToStart);
        }

        @Override
        protected int fetchMembers(BigInteger index, IMember[] membersArray, int indexToStart) {
            if (index.compareTo(TupleList.INT_MAX_VALUE) >= 0) {
                this.throwExceededMaxValueException(index);
            }
            long childOrdinal = SortedTupleList.this.order[index.intValue()];
            return this.childTupleListIterator.fetchMembers(childOrdinal, membersArray, indexToStart);
        }

        @Override
        public ITuple getTuple(long index) {
            this.checkForCancelRequest();
            long childOrdinal = SortedTupleList.this.order[(int)index];
            return this.childTupleListIterator.getTuple(childOrdinal);
        }

        @Override
        public ITuple getTuple(BigInteger index) {
            this.checkForCancelRequest();
            if (index.compareTo(TupleList.INT_MAX_VALUE) >= 0) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "The index for the sorted tuple list exceeds the Integer.MAX_VALUE : " + index);
            }
            long childOrdinal = SortedTupleList.this.order[index.intValue()];
            return this.childTupleListIterator.getTuple(childOrdinal);
        }
    }
}

